(ns {{name}}.core-test
  (:require [midje.sweet :refer :all]
            [{{name}}.core :refer :all]
            [cloudlog-events.testing :refer [scenario as emit query apply-rules]]))

(fact
 ;; This test is written in the cloudlog testing DSL.
 ;; See http://axiom-clj.org/cloudlog-events.testing.html for more details.
 (scenario
  (as "alice"
      (emit [:{{name}}/task "alice" "Create app" 1000])
      (emit [:{{name}}/task "alice" "Show app to @bob" 2000])
      (query [:{{name}}/my-tasks "alice"]) => #{["alice" "Create app" 1000]
                                              ["alice" "Show app to @bob" 2000]})
  (apply-rules [:{{name}}.core/task-where-user-is-mentioned "bob"])
  => #{["alice" "Show app to @bob" 2000]}
  (as "bob"
      (query [:{{name}}/my-tasks "bob"]) => #{["alice" "Show app to @bob" 2000]})))
