(ns bloodstain.core
  (:require [bultitude.core :as bultitude]))

(defn- make-xform [meta-key]
  (let [pred (fn pred [m]
               (and (contains? m meta-key)
                    (get m meta-key)))]
    (comp (map ns-interns)
          (mapcat vals)
          (map meta)
          (filter pred))))

(defn find-meta-in-dir [dir meta-key]
  (let [xform (make-xform meta-key)]
    (into [] xform (bultitude/namespaces-in-dir dir))))
