/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.zeromq.ZMQ;

public class EmbeddedLibraryTools {
    public static final boolean LOADED_EMBEDDED_LIBRARY = EmbeddedLibraryTools.loadEmbeddedLibrary();

    public static String getCurrentPlatformIdentifier() {
        return System.getProperty("os.arch") + "/" + System.getProperty("os.name");
    }

    public static Collection<String> getEmbeddedLibraryList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection<String> collection = EmbeddedLibraryTools.catalogClasspath();
        for (String string : collection) {
            if (!string.startsWith("NATIVE")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private static void catalogArchive(File file, Collection<String> collection) {
        try {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory()) continue;
                collection.add(jarEntry.getName());
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
    }

    private static Collection<String> catalogClasspath() {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray = System.getProperty("java.class.path", "").split(File.pathSeparator)) {
            File file = new File(string);
            if (file.isFile() && string.toLowerCase().endsWith(".jar")) {
                EmbeddedLibraryTools.catalogArchive(file, arrayList);
                continue;
            }
            if (!file.isDirectory()) continue;
            int n = file.getPath().length() + 1;
            EmbeddedLibraryTools.catalogFiles(n, file, arrayList);
        }
        return arrayList;
    }

    private static void catalogFiles(int n, File file, Collection<String> collection) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                EmbeddedLibraryTools.catalogFiles(n, file2, collection);
                continue;
            }
            collection.add(file2.getPath().substring(n));
        }
    }

    private static boolean loadEmbeddedLibrary() {
        boolean bl = false;
        String[] stringArray = new String[]{"so", "dylib", "dll"};
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/NATIVE/");
        stringBuilder.append(EmbeddedLibraryTools.getCurrentPlatformIdentifier());
        stringBuilder.append("/libjzmq.");
        URL uRL = null;
        for (String string : stringArray) {
            uRL = ZMQ.class.getResource(stringBuilder.toString() + string);
            if (uRL != null) break;
        }
        if (uRL != null) {
            try {
                File file = File.createTempFile("libjzmq-", ".lib");
                file.deleteOnExit();
                InputStream inputStream = uRL.openStream();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                int n = 0;
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray)) > -1) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                }
                ((OutputStream)bufferedOutputStream).close();
                inputStream.close();
                System.load(file.getAbsolutePath());
                file.delete();
                bl = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    private EmbeddedLibraryTools() {
    }
}

