/*
 * Decompiled with CFR 0.152.
 */
package com.infochimps.elasticsearch;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class ElasticSearchSplit
extends InputSplit
implements Writable {
    private String queryString;
    private long from;
    private long size;

    public ElasticSearchSplit() {
    }

    public ElasticSearchSplit(String queryString, long from, long size) {
        this.queryString = queryString;
        this.from = from;
        this.size = size;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public long getFrom() {
        return this.from;
    }

    public long getSize() {
        return this.size;
    }

    public String[] getLocations() {
        return new String[0];
    }

    public long getLength() {
        return 0L;
    }

    public void readFields(DataInput in) throws IOException {
        this.queryString = Text.readString((DataInput)in);
        this.from = in.readLong();
        this.size = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.queryString);
        out.writeLong(this.from);
        out.writeLong(this.size);
    }
}

