/*
 * Decompiled with CFR 0.152.
 */
package com.infochimps.elasticsearch.hadoop.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HadoopUtils {
    public static void uploadLocalFile(Path localsrc, Path hdfsdest, Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(hdfsdest) && fs.getFileStatus(hdfsdest).isDir()) {
            fs.delete(hdfsdest, true);
        }
        fs.copyFromLocalFile(false, true, localsrc, hdfsdest);
    }

    public static void uploadLocalFileIfChanged(Path localsrc, Path hdfsdest, Configuration conf) throws IOException {
        long l_time = new File(localsrc.toUri()).lastModified();
        try {
            long h_time = FileSystem.get((Configuration)conf).getFileStatus(hdfsdest).getModificationTime();
            if (l_time > h_time) {
                HadoopUtils.uploadLocalFile(localsrc, hdfsdest, conf);
            }
        }
        catch (FileNotFoundException e) {
            HadoopUtils.uploadLocalFile(localsrc, hdfsdest, conf);
        }
    }

    public static String fetchFileFromCache(String basename, Configuration conf) throws IOException {
        Path[] cacheFiles = DistributedCache.getLocalCacheFiles((Configuration)conf);
        if (cacheFiles != null && cacheFiles.length > 0) {
            for (Path cacheFile : cacheFiles) {
                if (!cacheFile.getName().equals(basename)) continue;
                return cacheFile.toString();
            }
        }
        return null;
    }

    public static String fetchArchiveFromCache(String basename, Configuration conf) throws IOException {
        Path[] cacheArchives = DistributedCache.getLocalCacheArchives((Configuration)conf);
        if (cacheArchives != null && cacheArchives.length > 0) {
            for (Path cacheArchive : cacheArchives) {
                if (!cacheArchive.getName().equals(basename)) continue;
                return cacheArchive.toString();
            }
        }
        return null;
    }

    public static void shipFileIfNotShipped(Path hdfsPath, Configuration conf) throws IOException {
        if (HadoopUtils.fetchFileFromCache(hdfsPath.getName(), conf) == null) {
            try {
                DistributedCache.addCacheFile((URI)hdfsPath.toUri(), (Configuration)conf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void shipArchiveIfNotShipped(Path hdfsPath, Configuration conf) throws IOException {
        if (HadoopUtils.fetchArchiveFromCache(hdfsPath.getName(), conf) == null) {
            try {
                DistributedCache.addCacheArchive((URI)hdfsPath.toUri(), (Configuration)conf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

