(ns cljx.hooks
  (:require leiningen.cljx
            [robert.hooke :as hooke]
            [leiningen.compile :as lcompile]
            [leiningen.jar :as ljar]))

(defn- jar-hook [task project]
  (leiningen.cljx/cljx project)
  (task project))

(defn- compile-hook [task project]
  (leiningen.cljx/cljx project)
  (task project))

(defn activate []
  (hooke/add-hook #'lcompile/compile #'compile-hook)
  (hooke/add-hook #'ljar/jar #'jar-hook))
