
/*
create table midis(
  id varchar(100) primary key,
  name varchar(200) not null
);

create table meta_messages(
  id varchar(100) primary key,
  midi_id varchar(100) not null,
  type integer,
  message varchar(1000),
  foreign key(midi_id) references midis(id) on delete cascade
);
 */


-- :name insert-midi! :! :n
insert into midis(id, name)
values (:id, :name)


-- :name update-midi! :! :n
update midis
set name=:name
where id=:id

-- :name insert-meta-message! :! :n
insert into meta_messages(id, midi_id, type, ticks, message, offset)
values (:id, :midi_id, :type, :ticks, :message, :offset)

-- :name midi-by-id :? :1
select * from midis
 where id = :id

-- :name search-midi :? :*
select * from midis where name like :name-like
-- :name get-all-midis :? :*
select * from midis

-- :name meta-message-by-id :? :1
select * from meta_messages
 where id = :id

-- :name meta-messages-by-midi-id :? :*
select * from meta_messages
 where midi_id = :midi_id
 order by ticks asc

  -- :name midi-stats :? :*
select id, name,
       (select count(*)
          from meta_messages
         where midi_id=m.id and type=1) as type_1_count,
       (select count(*)
          from meta_messages
         where midi_id=m.id and type=5) as type_5_count
  from midis m
 order by created asc;
