# Simple Batch Processor

A simple Clojure stream to batch processor. Allows a restricted number of
batch handler threads to be executed against a stream of incoming messages
on both batch-size and timeout.

![Simple Batch Processor Diagram](/doc/simple-batch-processor-diagram.png)

## Usage

### Create Batch Processor Functions

#### stream->batch

Returns a batch processing function.

If you want to dispose of the associated threadpool, you must manually
call `shutdown`.

```clojure
(def message-processor 
  (stream->batch
    (fn [batch] (do-some-things batch))
    {:batch-size 5 :timeout 100 :threads 4}))

(doseq [x (range 9001)]
  (message-processor x))
```

#### defstream->batch

Defs a batch processing function to a var.

If you want to dispose of the associated threadpool, you must manually
call `shutdown`.

```clojure
(defstream->batch message-processor
  (fn [batch] (do-some-things batch))
  {:batch-size 5 :timeout 100 :threads 4})

(doseq [x (range 9001)]
  (message-processor x))
```

#### with-stream->batch

Temporary scoped binding for batch processing function,
with automatic threadpool shutdown.

```clojure
(with-stream->batch [tmp-proc (fn [batch] (do-some-things batch))
                     {:batch-size 5 :threads 2 :timeout 1000}]
  (doseq [x (range 17)]
    (tmp-proc x)))
```

### Utility Functions

#### queue-size
#### queue-contents
#### purge-queue
#### shutdown

## License

Simple Batch Processor is released under the Apache License.
See [LICENSE.txt](LICENSE.txt) for complete license text.

Copyright [2016] [Benjamin Baker-Smith]
