/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.internal.Utilities;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;

public final class TlsTunnelBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket build(SSLSocketFactory factory, Proxy proxy, String host, int port) throws IOException {
        Socket socket;
        block3: {
            boolean success = false;
            Socket proxySocket = null;
            try {
                InetSocketAddress proxyAddress = (InetSocketAddress)proxy.address();
                proxySocket = new Socket(proxyAddress.getAddress(), proxyAddress.getPort());
                this.makeTunnel(host, port, proxySocket.getOutputStream(), proxySocket.getInputStream());
                Socket socket2 = factory.createSocket(proxySocket, host, port, true);
                success = true;
                socket = socket2;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    Utilities.close(proxySocket);
                }
                throw throwable;
            }
            Utilities.close(proxySocket);
        }
        return socket;
    }

    void makeTunnel(String host, int port, OutputStream out, InputStream in) throws IOException {
        String userAgent = "java-apns";
        String connect = String.format("CONNECT %1$s:%2$d HTTP/1.1\r\nHost: %1$s:%2$d\r\nUser-Agent: %3$s\r\nProxy-Connection: Keep-Alive\r\n\r\n", host, port, userAgent);
        out.write(connect.getBytes("UTF-8"));
        String statusLine = TlsTunnelBuilder.readAsciiUntilCrlf(in);
        if (!statusLine.matches("HTTP\\/1\\.\\d 2\\d\\d .*")) {
            throw new ProtocolException("TLS tunnel failed: " + statusLine);
        }
        while (TlsTunnelBuilder.readAsciiUntilCrlf(in).length() != 0) {
        }
    }

    public static String readAsciiUntilCrlf(InputStream in) throws IOException {
        int c;
        StringBuilder result = new StringBuilder(80);
        while ((c = in.read()) != -1) {
            if (c == 10) {
                if (result.length() > 0 && result.charAt(result.length() - 1) == '\r') {
                    result.deleteCharAt(result.length() - 1);
                }
                return result.toString();
            }
            result.append((char)c);
        }
        throw new EOFException("Expected CRLF");
    }
}

