/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.ApnsDelegate;
import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.DeliveryError;
import com.notnoop.apns.ReconnectPolicy;
import com.notnoop.apns.SimpleApnsNotification;
import com.notnoop.apns.internal.ApnsConnection;
import com.notnoop.apns.internal.ReconnectPolicies;
import com.notnoop.apns.internal.TlsTunnelBuilder;
import com.notnoop.apns.internal.Utilities;
import com.notnoop.exceptions.ApnsDeliveryErrorException;
import com.notnoop.exceptions.NetworkIOException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApnsConnectionImpl
implements ApnsConnection {
    private static final Logger logger = LoggerFactory.getLogger(ApnsConnectionImpl.class);
    private final SocketFactory factory;
    private final String host;
    private final int port;
    private final Proxy proxy;
    private final ReconnectPolicy reconnectPolicy;
    private final ApnsDelegate delegate;
    private int cacheLength;
    private final boolean errorDetection;
    private final boolean autoAdjustCacheLength;
    private final ConcurrentLinkedQueue<ApnsNotification> cachedNotifications;
    private final ConcurrentLinkedQueue<ApnsNotification> notificationsBuffer;
    private Socket socket;
    int DELAY_IN_MS = 1000;
    private static final int RETRIES = 3;

    public ApnsConnectionImpl(SocketFactory factory, String host, int port) {
        this(factory, host, port, new ReconnectPolicies.Never(), ApnsDelegate.EMPTY);
    }

    public ApnsConnectionImpl(SocketFactory factory, String host, int port, ReconnectPolicy reconnectPolicy, ApnsDelegate delegate) {
        this(factory, host, port, null, reconnectPolicy, delegate);
    }

    public ApnsConnectionImpl(SocketFactory factory, String host, int port, Proxy proxy, ReconnectPolicy reconnectPolicy, ApnsDelegate delegate) {
        this(factory, host, port, proxy, reconnectPolicy, delegate, false, 100, true);
    }

    public ApnsConnectionImpl(SocketFactory factory, String host, int port, Proxy proxy, ReconnectPolicy reconnectPolicy, ApnsDelegate delegate, boolean errorDetection, int cacheLength, boolean autoAdjustCacheLength) {
        this.factory = factory;
        this.host = host;
        this.port = port;
        this.reconnectPolicy = reconnectPolicy;
        this.delegate = delegate == null ? ApnsDelegate.EMPTY : delegate;
        this.proxy = proxy;
        this.errorDetection = errorDetection;
        this.cacheLength = cacheLength;
        this.autoAdjustCacheLength = autoAdjustCacheLength;
        this.cachedNotifications = new ConcurrentLinkedQueue();
        this.notificationsBuffer = new ConcurrentLinkedQueue();
    }

    public synchronized void close() {
        Utilities.close(this.socket);
    }

    private void monitorSocket(final Socket socket) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MonitoringThread
        extends Thread {
            MonitoringThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    InputStream in = socket.getInputStream();
                    int expectedSize = 6;
                    byte[] bytes = new byte[6];
                    while (in.read(bytes) == 6) {
                        int resendSize;
                        int command = bytes[0] & 0xFF;
                        if (command != 8) {
                            throw new IOException("Unexpected command byte " + command);
                        }
                        int statusCode = bytes[1] & 0xFF;
                        DeliveryError e = DeliveryError.ofCode(statusCode);
                        int id = Utilities.parseBytes(bytes[2], bytes[3], bytes[4], bytes[5]);
                        LinkedList<ApnsNotification> tempCache = new LinkedList<ApnsNotification>();
                        ApnsNotification notification = null;
                        boolean foundNotification = false;
                        while (!ApnsConnectionImpl.this.cachedNotifications.isEmpty()) {
                            notification = (ApnsNotification)ApnsConnectionImpl.this.cachedNotifications.poll();
                            if (notification.getIdentifier() == id) {
                                foundNotification = true;
                                break;
                            }
                            tempCache.add(notification);
                        }
                        if (foundNotification) {
                            ApnsConnectionImpl.this.delegate.messageSendFailed(notification, new ApnsDeliveryErrorException(e));
                        } else {
                            ApnsConnectionImpl.this.cachedNotifications.addAll(tempCache);
                            resendSize = tempCache.size();
                            logger.warn("Received error for message that wasn't in the cache...");
                            if (ApnsConnectionImpl.this.autoAdjustCacheLength) {
                                ApnsConnectionImpl.this.cacheLength = ApnsConnectionImpl.this.cacheLength + resendSize / 2;
                                ApnsConnectionImpl.this.delegate.cacheLengthExceeded(ApnsConnectionImpl.this.cacheLength);
                            }
                            ApnsConnectionImpl.this.delegate.messageSendFailed(null, new ApnsDeliveryErrorException(e));
                        }
                        resendSize = 0;
                        while (!ApnsConnectionImpl.this.cachedNotifications.isEmpty()) {
                            ++resendSize;
                            ApnsConnectionImpl.this.notificationsBuffer.add(ApnsConnectionImpl.this.cachedNotifications.poll());
                        }
                        ApnsConnectionImpl.this.delegate.notificationsResent(resendSize);
                        ApnsConnectionImpl.this.delegate.connectionClosed(e, id);
                        ApnsConnectionImpl.this.drainBuffer();
                    }
                }
                catch (Exception e) {
                    logger.info("Exception while waiting for error code", e);
                    ApnsConnectionImpl.this.delegate.connectionClosed(DeliveryError.UNKNOWN, -1);
                }
                finally {
                    ApnsConnectionImpl.this.close();
                }
            }
        }
        MonitoringThread t = new MonitoringThread();
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Socket socket() throws NetworkIOException {
        if (this.reconnectPolicy.shouldReconnect()) {
            Utilities.close(this.socket);
            this.socket = null;
        }
        if (this.socket == null || this.socket.isClosed()) {
            try {
                if (this.proxy == null) {
                    this.socket = this.factory.createSocket(this.host, this.port);
                } else if (this.proxy.type() == Proxy.Type.HTTP) {
                    TlsTunnelBuilder tunnelBuilder = new TlsTunnelBuilder();
                    this.socket = tunnelBuilder.build((SSLSocketFactory)this.factory, this.proxy, this.host, this.port);
                } else {
                    boolean success = false;
                    Socket proxySocket = null;
                    try {
                        proxySocket = new Socket(this.proxy);
                        proxySocket.connect(new InetSocketAddress(this.host, this.port));
                        this.socket = ((SSLSocketFactory)this.factory).createSocket(proxySocket, this.host, this.port, false);
                        success = true;
                    }
                    finally {
                        if (!success) {
                            Utilities.close(proxySocket);
                        }
                    }
                }
                if (this.errorDetection) {
                    this.monitorSocket(this.socket);
                }
                this.reconnectPolicy.reconnected();
                logger.debug("Made a new connection to APNS");
            }
            catch (IOException e) {
                logger.error("Couldn't connect to APNS server", e);
                throw new NetworkIOException(e);
            }
        }
        return this.socket;
    }

    public synchronized void sendMessage(ApnsNotification m) throws NetworkIOException {
        this.sendMessage(m, false);
    }

    public synchronized void sendMessage(ApnsNotification m, boolean fromBuffer) throws NetworkIOException {
        int attempts = 0;
        while (true) {
            try {
                ++attempts;
                Socket socket = this.socket();
                socket.getOutputStream().write(m.marshall());
                socket.getOutputStream().flush();
                this.cacheNotification(m);
                this.delegate.messageSent(m, fromBuffer);
                logger.debug("Message \"{}\" sent", (Object)m);
                attempts = 0;
                this.drainBuffer();
            }
            catch (Exception e) {
                Utilities.close(this.socket);
                this.socket = null;
                if (attempts >= 3) {
                    logger.error("Couldn't send message after 3 retries." + m, e);
                    this.delegate.messageSendFailed(m, e);
                    Utilities.wrapAndThrowAsRuntimeException(e);
                }
                if (attempts == 1) continue;
                logger.info("Failed to send message " + m + "... trying again after delay", e);
                Utilities.sleep(this.DELAY_IN_MS);
                continue;
            }
            break;
        }
    }

    private void drainBuffer() {
        if (!this.notificationsBuffer.isEmpty()) {
            this.sendMessage(this.notificationsBuffer.poll(), true);
        }
    }

    private void cacheNotification(ApnsNotification notification) {
        this.cachedNotifications.add(notification);
        while (this.cachedNotifications.size() > this.cacheLength) {
            this.cachedNotifications.poll();
            logger.debug("Removing notification from cache " + notification);
        }
    }

    public ApnsConnectionImpl copy() {
        return new ApnsConnectionImpl(this.factory, this.host, this.port, this.proxy, this.reconnectPolicy.copy(), this.delegate, this.errorDetection, this.cacheLength, this.autoAdjustCacheLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection() throws NetworkIOException {
        ApnsConnectionImpl testConnection = null;
        try {
            testConnection = new ApnsConnectionImpl(this.factory, this.host, this.port, this.proxy, this.reconnectPolicy.copy(), this.delegate);
            testConnection.sendMessage(new SimpleApnsNotification(new byte[]{0}, new byte[]{0}));
        }
        finally {
            if (testConnection != null) {
                testConnection.close();
            }
        }
    }

    public void setCacheLength(int cacheLength) {
        this.cacheLength = cacheLength;
    }

    public int getCacheLength() {
        return this.cacheLength;
    }
}

