/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns;

import com.notnoop.apns.ApnsServerExceptionDelegate;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public abstract class AbstractApnsServerSocket {
    private final SSLServerSocket serverSocket;
    private final ExecutorService executorService;
    private final ApnsServerExceptionDelegate exceptionDelegate;

    public AbstractApnsServerSocket(SSLContext sslContext, int port, ExecutorService executorService, ApnsServerExceptionDelegate exceptionDelegate) throws IOException {
        SSLServerSocketFactory serverSocketFactory = sslContext.getServerSocketFactory();
        this.serverSocket = (SSLServerSocket)serverSocketFactory.createServerSocket(port);
        this.executorService = executorService;
        this.exceptionDelegate = exceptionDelegate;
    }

    public final void start() {
        new Thread(new Runnable(){

            public void run() {
                AbstractApnsServerSocket.this.startAccept();
            }
        }).start();
    }

    private void startAccept() {
        try {
            while (true) {
                Socket accept = this.serverSocket.accept();
                this.executorService.execute(new SocketHandler(accept));
            }
        }
        catch (IOException ioe) {
            this.executorService.shutdown();
            return;
        }
    }

    public final void stop() {
        try {
            this.serverSocket.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    abstract void handleSocket(Socket var1) throws IOException;

    private class SocketHandler
    implements Runnable {
        private final Socket socket;

        SocketHandler(Socket socket) {
            this.socket = socket;
        }

        public void run() {
            try {
                AbstractApnsServerSocket.this.handleSocket(this.socket);
            }
            catch (IOException ioe) {
                AbstractApnsServerSocket.this.exceptionDelegate.handleRequestFailed(ioe);
            }
        }
    }
}

