/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsDelegate;
import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.DeliveryError;
import com.notnoop.exceptions.InvalidSSLConfig;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;

public class MainClass {
    public static void main(String[] args) throws InvalidSSLConfig, FileNotFoundException {
        if (args.length != 4) {
            System.err.println("Usage: test <p|s> <cert> <cert-password>\ntest p ./cert abc123 token");
            System.exit(777);
        }
        ApnsDelegate delegate = new ApnsDelegate(){

            public void messageSent(ApnsNotification message, boolean resent) {
                System.out.println("Sent message " + message + " Resent: " + resent);
            }

            public void messageSendFailed(ApnsNotification message, Throwable e) {
                System.out.println("Failed message " + message);
            }

            public void connectionClosed(DeliveryError e, int messageIdentifier) {
                System.out.println("Closed connection: " + messageIdentifier + "\n   deliveryError " + e.toString());
            }

            public void cacheLengthExceeded(int newCacheLength) {
                System.out.println("cacheLengthExceeded " + newCacheLength);
            }

            public void notificationsResent(int resendCount) {
                System.out.println("notificationResent " + resendCount);
            }
        };
        ApnsService svc = APNS.newService().withAppleDestination(args[0].equals("p")).withCert((InputStream)new FileInputStream(args[1]), args[2]).withDelegate(delegate).build();
        String goodToken = args[3];
        String payload = APNS.newPayload().alertBody("Wrzlmbrmpf dummy alert").build();
        svc.start();
        System.out.println("Sending message");
        ApnsNotification goodMsg = svc.push(goodToken, payload);
        System.out.println("Message id: " + goodMsg.getIdentifier());
        System.out.println("Getting inactive devices");
        Map inactiveDevices = svc.getInactiveDevices();
        for (Map.Entry ent : inactiveDevices.entrySet()) {
            System.out.println("Inactive " + (String)ent.getKey() + " at date " + ent.getValue());
        }
        System.out.println("Stopping service");
        svc.stop();
    }
}

