/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.integration;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsDelegate;
import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.DeliveryError;
import com.notnoop.apns.EnhancedApnsNotification;
import com.notnoop.apns.SimpleApnsNotification;
import com.notnoop.apns.utils.ApnsServerStub;
import com.notnoop.apns.utils.FixedCertificates;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ApnsConnectionCacheTest {
    ApnsServerStub server;
    static SimpleApnsNotification msg1 = new SimpleApnsNotification("a87d8878d878a79", "{\"aps\":{}}");
    static SimpleApnsNotification msg2 = new SimpleApnsNotification("a87d8878d878a88", "{\"aps\":{}}");
    static EnhancedApnsNotification eMsg1 = new EnhancedApnsNotification(EnhancedApnsNotification.INCREMENT_ID(), 1, "a87d8878d878a88", "{\"aps\":{}}");
    static EnhancedApnsNotification eMsg2 = new EnhancedApnsNotification(EnhancedApnsNotification.INCREMENT_ID(), 1, "a87d8878d878a88", "{\"aps\":{}}");
    static EnhancedApnsNotification eMsg3 = new EnhancedApnsNotification(EnhancedApnsNotification.INCREMENT_ID(), 1, "a87d8878d878a88", "{\"aps\":{}}");

    @Before
    public void startup() {
    }

    @After
    public void tearDown() {
        this.server.stop();
        this.server = null;
    }

    @Test(timeout=5000L)
    public void handleReTransmissionError5Good1Bad7Good() throws InterruptedException {
        int i;
        this.server = new ApnsServerStub(FixedCertificates.serverContext().getServerSocketFactory(), 7654, 7843);
        final CountDownLatch sync = new CountDownLatch(20);
        final AtomicInteger numResent = new AtomicInteger();
        final AtomicInteger numSent = new AtomicInteger();
        int EXPECTED_RESEND_COUNT = 7;
        int EXPECTED_SEND_COUNT = 12;
        this.server.waitForError.acquire();
        this.server.start();
        ApnsService service = APNS.newService().withSSLContext(FixedCertificates.clientContext()).withGatewayDestination("localhost", 7654).withDelegate(new ApnsDelegate(){

            public void messageSent(ApnsNotification message, boolean resent) {
                if (!resent) {
                    numSent.incrementAndGet();
                }
                sync.countDown();
            }

            public void messageSendFailed(ApnsNotification message, Throwable e) {
                numSent.decrementAndGet();
            }

            public void connectionClosed(DeliveryError e, int messageIdentifier) {
            }

            public void cacheLengthExceeded(int newCacheLength) {
            }

            public void notificationsResent(int resendCount) {
                numResent.set(resendCount);
            }
        }).build();
        this.server.stopAt(eMsg1.length() * 5 + eMsg2.length() + eMsg3.length() * 14);
        for (i = 0; i < 5; ++i) {
            service.push((ApnsNotification)eMsg1);
        }
        service.push((ApnsNotification)eMsg2);
        for (i = 0; i < 7; ++i) {
            service.push((ApnsNotification)eMsg3);
        }
        this.server.sendError(8, eMsg2.getIdentifier());
        this.server.waitForError.release();
        this.server.messages.acquire();
        sync.await();
        Assert.assertEquals((long)EXPECTED_RESEND_COUNT, (long)numResent.get());
        Assert.assertEquals((long)EXPECTED_SEND_COUNT, (long)numSent.get());
    }

    @Test(timeout=5000L)
    public void handleReTransmissionError1Good1Bad2Good() throws InterruptedException {
        this.server = new ApnsServerStub(FixedCertificates.serverContext().getServerSocketFactory(), 7654, 7843);
        final CountDownLatch sync = new CountDownLatch(6);
        final AtomicInteger numResent = new AtomicInteger();
        final AtomicInteger numSent = new AtomicInteger();
        int EXPECTED_RESEND_COUNT = 2;
        int EXPECTED_SEND_COUNT = 3;
        this.server.waitForError.acquire();
        this.server.start();
        ApnsService service = APNS.newService().withSSLContext(FixedCertificates.clientContext()).withGatewayDestination("localhost", 7654).withDelegate(new ApnsDelegate(){

            public void messageSent(ApnsNotification message, boolean resent) {
                if (!resent) {
                    numSent.incrementAndGet();
                }
                sync.countDown();
            }

            public void messageSendFailed(ApnsNotification message, Throwable e) {
                numSent.decrementAndGet();
            }

            public void connectionClosed(DeliveryError e, int messageIdentifier) {
            }

            public void cacheLengthExceeded(int newCacheLength) {
            }

            public void notificationsResent(int resendCount) {
                numResent.set(resendCount);
            }
        }).build();
        this.server.stopAt(msg1.length() * 3 + eMsg2.length() * 2);
        service.push((ApnsNotification)msg1);
        service.push((ApnsNotification)eMsg2);
        service.push((ApnsNotification)eMsg1);
        service.push((ApnsNotification)msg2);
        this.server.sendError(8, eMsg2.getIdentifier());
        this.server.waitForError.release();
        this.server.messages.acquire();
        sync.await();
        Assert.assertEquals((long)EXPECTED_RESEND_COUNT, (long)numResent.get());
        Assert.assertEquals((long)EXPECTED_SEND_COUNT, (long)numSent.get());
    }

    @Test(timeout=5000L)
    public void handleReTransmissionError1Bad() throws InterruptedException {
        this.server = new ApnsServerStub(FixedCertificates.serverContext().getServerSocketFactory(), 7654, 7843);
        final CountDownLatch sync = new CountDownLatch(1);
        final AtomicInteger numError = new AtomicInteger();
        int EXPECTED_ERROR_COUNT = 1;
        this.server.waitForError.acquire();
        this.server.start();
        ApnsService service = APNS.newService().withSSLContext(FixedCertificates.clientContext()).withGatewayDestination("localhost", 7654).withDelegate(new ApnsDelegate(){

            public void messageSent(ApnsNotification message, boolean resent) {
            }

            public void messageSendFailed(ApnsNotification message, Throwable e) {
                numError.incrementAndGet();
                sync.countDown();
            }

            public void connectionClosed(DeliveryError e, int messageIdentifier) {
            }

            public void cacheLengthExceeded(int newCacheLength) {
            }

            public void notificationsResent(int resendCount) {
            }
        }).build();
        this.server.stopAt(eMsg1.length());
        service.push((ApnsNotification)eMsg1);
        this.server.sendError(8, eMsg1.getIdentifier());
        this.server.waitForError.release();
        this.server.messages.acquire();
        sync.await();
        Assert.assertEquals((long)EXPECTED_ERROR_COUNT, (long)numError.get());
    }

    @Test(timeout=10000L)
    public void handleTransmissionErrorInQueuedConnection() throws InterruptedException {
        int i;
        this.server = new ApnsServerStub(FixedCertificates.serverContext().getServerSocketFactory(), 7654, 7843);
        final AtomicInteger sync = new AtomicInteger(138);
        final AtomicInteger numResent = new AtomicInteger();
        final AtomicInteger numSent = new AtomicInteger();
        this.server.waitForError.acquire();
        this.server.start();
        ApnsService service = APNS.newService().withSSLContext(FixedCertificates.clientContext()).withGatewayDestination("localhost", 7654).asQueued().withDelegate(new ApnsDelegate(){

            public void messageSent(ApnsNotification message, boolean resent) {
                if (!resent) {
                    numSent.incrementAndGet();
                }
                sync.getAndDecrement();
            }

            public void messageSendFailed(ApnsNotification message, Throwable e) {
                numSent.decrementAndGet();
                sync.incrementAndGet();
            }

            public void connectionClosed(DeliveryError e, int messageIdentifier) {
            }

            public void cacheLengthExceeded(int newCacheLength) {
            }

            public void notificationsResent(int resendCount) {
                numResent.set(resendCount);
                sync.getAndAdd(resendCount);
            }
        }).build();
        this.server.stopAt(eMsg3.length() * 50 + msg1.length() * 3 + eMsg2.length() * 2 + eMsg1.length() * 85);
        for (i = 0; i < 50; ++i) {
            service.push((ApnsNotification)eMsg3);
        }
        service.push((ApnsNotification)msg1);
        service.push((ApnsNotification)eMsg2);
        service.push((ApnsNotification)eMsg1);
        service.push((ApnsNotification)msg2);
        for (i = 0; i < 85; ++i) {
            service.push((ApnsNotification)eMsg1);
        }
        this.server.sendError(8, eMsg2.getIdentifier());
        this.server.waitForError.release();
        this.server.messages.acquire();
        while (sync.get() != 0) {
            Thread.yield();
        }
    }

    @Test(timeout=5000L)
    public void cacheLengthNotification() throws InterruptedException {
        int i;
        this.server = new ApnsServerStub(FixedCertificates.serverContext().getServerSocketFactory(), 7654, 7843);
        final CountDownLatch sync = new CountDownLatch(1);
        int ORIGINAL_CACHE_LENGTH = 100;
        final AtomicInteger modifiedCacheLength = new AtomicInteger();
        this.server.waitForError.acquire();
        this.server.start();
        ApnsService service = APNS.newService().withSSLContext(FixedCertificates.clientContext()).withGatewayDestination("localhost", 7654).withDelegate(new ApnsDelegate(){

            public void messageSent(ApnsNotification message, boolean resent) {
            }

            public void messageSendFailed(ApnsNotification message, Throwable e) {
            }

            public void connectionClosed(DeliveryError e, int messageIdentifier) {
            }

            public void cacheLengthExceeded(int newCacheLength) {
                modifiedCacheLength.set(newCacheLength);
                sync.countDown();
            }

            public void notificationsResent(int resendCount) {
            }
        }).build();
        this.server.stopAt(eMsg1.length() * 5 + eMsg2.length() + eMsg3.length() * 14);
        for (i = 0; i < 5; ++i) {
            service.push((ApnsNotification)eMsg1);
        }
        service.push((ApnsNotification)eMsg2);
        for (i = 0; i < 101; ++i) {
            service.push((ApnsNotification)eMsg3);
        }
        this.server.sendError(8, eMsg2.getIdentifier());
        this.server.waitForError.release();
        this.server.messages.acquire();
        sync.await();
        Assert.assertTrue((ORIGINAL_CACHE_LENGTH < modifiedCacheLength.get() ? 1 : 0) != 0);
    }
}

