/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.integration;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.EnhancedApnsNotification;
import com.notnoop.apns.SimpleApnsNotification;
import com.notnoop.apns.utils.ApnsServerStub;
import com.notnoop.apns.utils.FixedCertificates;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ApnsConnectionTest {
    ApnsServerStub server;
    static SimpleApnsNotification msg1 = new SimpleApnsNotification("a87d8878d878a79", "{\"aps\":{}}");
    static SimpleApnsNotification msg2 = new SimpleApnsNotification("a87d8878d878a88", "{\"aps\":{}}");
    static EnhancedApnsNotification eMsg1 = new EnhancedApnsNotification(EnhancedApnsNotification.INCREMENT_ID(), 1, "a87d8878d878a88", "{\"aps\":{}}");
    static EnhancedApnsNotification eMsg2 = new EnhancedApnsNotification(EnhancedApnsNotification.INCREMENT_ID(), 1, "a87d8878d878a88", "{\"aps\":{}}");
    static EnhancedApnsNotification eMsg3 = new EnhancedApnsNotification(EnhancedApnsNotification.INCREMENT_ID(), 1, "a87d8878d878a88", "{\"aps\":{}}");

    @Before
    public void startup() {
    }

    @After
    public void tearDown() {
        this.server.stop();
        this.server = null;
    }

    @Test(timeout=2000L)
    public void sendOneSimple() throws InterruptedException {
        this.server = ApnsServerStub.prepareAndStartServer(7654, 7843);
        ApnsService service = APNS.newService().withSSLContext(FixedCertificates.clientContext()).withGatewayDestination("localhost", 7654).build();
        this.server.stopAt(msg1.length());
        service.push((ApnsNotification)msg1);
        this.server.messages.acquire();
        Assert.assertArrayEquals((byte[])msg1.marshall(), (byte[])this.server.received.toByteArray());
    }

    @Test(timeout=2000L)
    public void sendOneQueued() throws InterruptedException {
        this.server = ApnsServerStub.prepareAndStartServer(7654, 7843);
        ApnsService service = APNS.newService().withSSLContext(FixedCertificates.clientContext()).withGatewayDestination("localhost", 7654).asQueued().build();
        this.server.stopAt(msg1.length());
        service.push((ApnsNotification)msg1);
        this.server.messages.acquire();
        Assert.assertArrayEquals((byte[])msg1.marshall(), (byte[])this.server.received.toByteArray());
    }
}

