/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.internal.ApnsFeedbackConnection;
import com.notnoop.apns.internal.ApnsFeedbackParsingUtils;
import com.notnoop.apns.internal.MockingUtils;
import com.notnoop.apns.internal.Utilities;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.net.SocketFactory;
import org.junit.Test;

public class ApnsFeedbackConnectionTest {
    InputStream simpleStream = new ByteArrayInputStream(ApnsFeedbackParsingUtils.simple);
    InputStream threeStream = new ByteArrayInputStream(ApnsFeedbackParsingUtils.three);

    @Test
    public void rowParseOneDevice() {
        ApnsFeedbackParsingUtils.checkRawSimple(Utilities.parseFeedbackStreamRaw((InputStream)this.simpleStream));
    }

    @Test
    public void threeParseTwoDevices() {
        ApnsFeedbackParsingUtils.checkRawThree(Utilities.parseFeedbackStreamRaw((InputStream)this.threeStream));
    }

    @Test
    public void parsedSimple() {
        ApnsFeedbackParsingUtils.checkParsedSimple(Utilities.parseFeedbackStream((InputStream)this.simpleStream));
    }

    @Test
    public void parsedThree() {
        ApnsFeedbackParsingUtils.checkParsedThree(Utilities.parseFeedbackStream((InputStream)this.threeStream));
    }

    @Test
    public void connectionParsedOne() {
        SocketFactory sf = MockingUtils.mockSocketFactory(null, this.simpleStream);
        ApnsFeedbackConnection connection = new ApnsFeedbackConnection(sf, "localhost", 80);
        ApnsFeedbackParsingUtils.checkParsedSimple(connection.getInactiveDevices());
    }

    @Test
    public void connectionParsedThree() {
        SocketFactory sf = MockingUtils.mockSocketFactory(null, this.threeStream);
        ApnsFeedbackConnection connection = new ApnsFeedbackConnection(sf, "localhost", 80);
        ApnsFeedbackParsingUtils.checkParsedThree(connection.getInactiveDevices());
    }

    @Test
    public void feedbackWithclosedSocket() {
        SocketFactory sf = MockingUtils.mockClosedThenOpenSocket(null, this.simpleStream, true, 1);
        ApnsFeedbackConnection connection = new ApnsFeedbackConnection(sf, "localhost", 80);
        connection.DELAY_IN_MS = 0;
        ApnsFeedbackParsingUtils.checkParsedSimple(connection.getInactiveDevices());
    }

    @Test
    public void feedbackWitherrorOnce() {
        SocketFactory sf = MockingUtils.mockClosedThenOpenSocket(null, this.simpleStream, true, 2);
        ApnsFeedbackConnection connection = new ApnsFeedbackConnection(sf, "localhost", 80);
        connection.DELAY_IN_MS = 0;
        ApnsFeedbackParsingUtils.checkParsedSimple(connection.getInactiveDevices());
    }

    @Test(expected=Exception.class)
    public void feedbackWitherrorTwice() {
        SocketFactory sf = MockingUtils.mockClosedThenOpenSocket(null, this.simpleStream, true, 3);
        ApnsFeedbackConnection connection = new ApnsFeedbackConnection(sf, "localhost", 80);
        connection.DELAY_IN_MS = 0;
        ApnsFeedbackParsingUtils.checkParsedSimple(connection.getInactiveDevices());
    }
}

