/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.EnhancedApnsNotification;
import com.notnoop.apns.internal.ApnsConnection;
import com.notnoop.apns.internal.BatchApnsService;
import java.io.IOException;
import java.util.concurrent.Executors;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BatchApnsServiceTest {
    private ApnsConnection prototype;
    private BatchApnsService service;
    private int delayTimeInSec = 2;
    private int delayTimeInSec_millis = this.delayTimeInSec * 1000;
    private int delayTimeInSec1_2_millis = this.delayTimeInSec * 1000 / 2;
    private int delayTimeInSec1_4_millis = this.delayTimeInSec * 1000 / 4;
    private int maxDelayTimeInSec = 2 * this.delayTimeInSec;

    @Before
    public void setup() {
        this.prototype = (ApnsConnection)Mockito.mock(ApnsConnection.class);
        Mockito.when((Object)this.prototype.copy()).thenReturn((Object)this.prototype);
        this.service = new BatchApnsService(this.prototype, null, this.delayTimeInSec, this.maxDelayTimeInSec, Executors.defaultThreadFactory());
    }

    @Test
    public void simpleBatchWait_one() throws IOException, InterruptedException {
        EnhancedApnsNotification message = this.service.push("1234", "{}");
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)0))).copy();
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)0))).sendMessage((ApnsNotification)message);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)0))).close();
        Thread.sleep(this.delayTimeInSec_millis + 250);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)1))).copy();
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)1))).sendMessage((ApnsNotification)message);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void simpleBatchWait_multiple() throws IOException, InterruptedException {
        EnhancedApnsNotification message1 = this.service.push("1234", "{}");
        Thread.sleep(this.delayTimeInSec1_2_millis);
        EnhancedApnsNotification message2 = this.service.push("4321", "{}");
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)0))).copy();
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)0))).sendMessage((ApnsNotification)message1);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)0))).sendMessage((ApnsNotification)message2);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)0))).close();
        Thread.sleep(this.delayTimeInSec1_4_millis * 3);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)0))).copy();
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)0))).sendMessage((ApnsNotification)message1);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)0))).sendMessage((ApnsNotification)message2);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)0))).close();
        Thread.sleep(this.delayTimeInSec1_4_millis + 250);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)1))).copy();
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)1))).sendMessage((ApnsNotification)message1);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)1))).sendMessage((ApnsNotification)message2);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void simpleBatchWait_maxDelay() throws IOException, InterruptedException {
        EnhancedApnsNotification message1 = this.service.push("1234", "{}");
        Thread.sleep(this.delayTimeInSec1_4_millis * 3);
        EnhancedApnsNotification message2 = this.service.push("4321", "{}");
        Thread.sleep(this.delayTimeInSec1_4_millis * 3);
        EnhancedApnsNotification message3 = this.service.push("4321", "{}");
        Thread.sleep(this.delayTimeInSec1_4_millis * 3);
        EnhancedApnsNotification message4 = this.service.push("4321", "{}");
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)0))).copy();
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)0))).sendMessage((ApnsNotification)message1);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)0))).sendMessage((ApnsNotification)message2);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)0))).sendMessage((ApnsNotification)message3);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)0))).sendMessage((ApnsNotification)message4);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)0))).close();
        Thread.sleep(this.delayTimeInSec1_4_millis + 250);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)1))).copy();
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)1))).sendMessage((ApnsNotification)message1);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)1))).sendMessage((ApnsNotification)message2);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)1))).sendMessage((ApnsNotification)message3);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)1))).sendMessage((ApnsNotification)message4);
        ((ApnsConnection)Mockito.verify((Object)this.prototype, (VerificationMode)Mockito.times((int)1))).close();
    }
}

