/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import javax.net.SocketFactory;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;

public class MockingUtils {
    static SocketFactory mockSocketFactory(OutputStream out, InputStream in) {
        try {
            Socket socket = (Socket)Mockito.mock(Socket.class);
            Mockito.when((Object)socket.getOutputStream()).thenReturn((Object)out);
            Mockito.when((Object)socket.getInputStream()).thenReturn((Object)in);
            SocketFactory factory = (SocketFactory)Mockito.mock(SocketFactory.class);
            Mockito.when((Object)factory.createSocket()).thenReturn((Object)socket);
            Mockito.when((Object)factory.createSocket(Matchers.anyString(), Matchers.anyInt())).thenReturn((Object)socket);
            return factory;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssertionError((Object)"Cannot be here!");
        }
    }

    static SocketFactory mockClosedThenOpenSocket(OutputStream out, InputStream in, boolean isClosed, int failedTries) {
        try {
            ArrayList<Socket> socketMocks = new ArrayList<Socket>(failedTries + 1);
            for (int i = 0; i < failedTries; ++i) {
                Socket socket = (Socket)Mockito.mock(Socket.class);
                if (isClosed) {
                    Mockito.when((Object)socket.isClosed()).thenReturn((Object)true);
                    Mockito.when((Object)socket.isConnected()).thenReturn((Object)false);
                    Mockito.when((Object)socket.getOutputStream()).thenThrow(new Throwable[]{new AssertionError((Object)"Should have checked for closed connection")});
                } else {
                    Mockito.when((Object)socket.getOutputStream()).thenThrow(new Throwable[]{new IOException("simulated IOException")});
                }
                socketMocks.add(socket);
            }
            Socket socket = (Socket)Mockito.mock(Socket.class);
            Mockito.when((Object)socket.getOutputStream()).thenReturn((Object)out);
            Mockito.when((Object)socket.getInputStream()).thenReturn((Object)in);
            Mockito.when((Object)socket.isConnected()).thenReturn((Object)true);
            socketMocks.add(socket);
            SocketFactory factory = (SocketFactory)Mockito.mock(SocketFactory.class);
            OngoingStubbing stubbing = Mockito.when((Object)factory.createSocket(Matchers.anyString(), Matchers.anyInt()));
            for (Socket t : socketMocks) {
                stubbing = stubbing.thenReturn((Object)t);
            }
            return factory;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssertionError((Object)"Cannot be here!");
        }
    }
}

