/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.internal.TlsTunnelBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;

public class TlsTunnelBuilderTest {
    @Test
    public void readAsciiMultipleLines() throws IOException {
        InputStream in = this.inputStream("abc\r\ndef\r\n");
        Assert.assertEquals((Object)"abc", (Object)TlsTunnelBuilder.readAsciiUntilCrlf((InputStream)in));
        Assert.assertEquals((Object)"def", (Object)TlsTunnelBuilder.readAsciiUntilCrlf((InputStream)in));
    }

    @Test
    public void readAsciiMissingCr() throws IOException {
        InputStream in = this.inputStream("abc\ndef\r\n");
        Assert.assertEquals((Object)"abc", (Object)TlsTunnelBuilder.readAsciiUntilCrlf((InputStream)in));
        Assert.assertEquals((Object)"def", (Object)TlsTunnelBuilder.readAsciiUntilCrlf((InputStream)in));
    }

    @Test
    public void readAsciiMissingLf() throws IOException {
        InputStream in = this.inputStream("abc\rdef\r\n");
        Assert.assertEquals((Object)"abc\rdef", (Object)TlsTunnelBuilder.readAsciiUntilCrlf((InputStream)in));
    }

    @Test
    public void readAsciiNoCrlf() throws IOException {
        InputStream in = this.inputStream("abc");
        try {
            TlsTunnelBuilder.readAsciiUntilCrlf((InputStream)in);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void readAsciiEmptyLine() throws IOException {
        InputStream in = this.inputStream("abc\r\n\r\n");
        Assert.assertEquals((Object)"abc", (Object)TlsTunnelBuilder.readAsciiUntilCrlf((InputStream)in));
        Assert.assertEquals((Object)"", (Object)TlsTunnelBuilder.readAsciiUntilCrlf((InputStream)in));
    }

    @Test
    public void makeTunnelSuccess() throws IOException {
        InputStream response = this.inputStream("HTTP/1.1 200 OK\r\nHeader: Value\r\nAnother-Header: Another Value\r\n\r\nORIGIN DATA\r\n");
        ByteArrayOutputStream request = new ByteArrayOutputStream();
        new TlsTunnelBuilder().makeTunnel("origin.example.com", 9876, (OutputStream)request, response);
        Assert.assertEquals((Object)"CONNECT origin.example.com:9876 HTTP/1.1\r\nHost: origin.example.com:9876\r\nUser-Agent: java-apns\r\nProxy-Connection: Keep-Alive\r\n\r\n", (Object)request.toString("UTF-8"));
        Assert.assertEquals((Object)"ORIGIN DATA", (Object)TlsTunnelBuilder.readAsciiUntilCrlf((InputStream)response));
    }

    @Test
    public void proxyServerRequestsAuth() throws IOException {
        InputStream response = this.inputStream("HTTP/1.1 407 AUTH REQUIRED\r\n\r\n");
        ByteArrayOutputStream request = new ByteArrayOutputStream();
        try {
            new TlsTunnelBuilder().makeTunnel("origin.example.com", 9876, (OutputStream)request, response);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private InputStream inputStream(String content) throws IOException {
        return new ByteArrayInputStream(content.getBytes("UTF-8"));
    }
}

