/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.internal.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class UtilitiesTest {
    @Test
    public void testEncodeAndDecode() {
        String encodedHex = "a1b2d4";
        byte[] decoded = Utilities.decodeHex((String)encodedHex);
        String encoded = Utilities.encodeHex((byte[])decoded);
        Assert.assertEquals((Object)encodedHex.toLowerCase(), (Object)encoded.toLowerCase());
    }

    @Test
    public void testParsingBytes() {
        Assert.assertEquals((long)-16711936L, (long)Utilities.parseBytes((int)255, (int)0, (int)255, (int)0));
        Assert.assertEquals((long)0xFF00FFL, (long)Utilities.parseBytes((int)0, (int)255, (int)0, (int)255));
        Assert.assertEquals((long)-559038737L, (long)Utilities.parseBytes((int)222, (int)173, (int)190, (int)239));
        Assert.assertEquals((long)246267631L, (long)Utilities.parseBytes((int)14, (int)173, (int)190, (int)239));
        Assert.assertTrue((Utilities.parseBytes((int)240, (int)0, (int)0, (int)0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((Utilities.parseBytes((int)128, (int)0, (int)0, (int)0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((Utilities.parseBytes((int)112, (int)0, (int)0, (int)0) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEncodingUTF8() {
        String m = "esem\u00e9ny";
        byte[] expected = new byte[]{101, 115, 101, 109, -61, -87, 110, 121};
        Assert.assertArrayEquals((byte[])expected, (byte[])Utilities.toUTF8Bytes((String)m));
    }
}

