(ns clue.misc-test
  (:require [cljs.test :refer-macros [deftest is run-tests testing]]
            [clue.misc :as misc]))

(deftest vec->js-str*
  (testing "should take a vector and transforms it into a js string vector"
    (is (= "[1, 2]" (misc/vec->js-str* [1 2])))))

(deftest ->js-str*
  (testing "should take a value and transforms it into a js string value"
    (is (= "a" (misc/->js-str* :a)))
    (is (= "1" (misc/->js-str* 1)))
    (is (= "null" (misc/->js-str* nil)))
    (is (= "[1, 2, a]" (misc/->js-str* [1 2 :a])))))

(deftest ->js-str
  (testing "should take variadic number of arguments, apply ->js-str* to each one and return a string"
    (is (= "a && b" (misc/->js-str :a " && " :b)))
    (is (= "hello world" (misc/->js-str :hello " " :world)))
    (is (= "[1, 2][a]" (misc/->js-str [1 2] "[" :a "]")))))

(deftest keywords?
  (testing "should take a map and returns true if all the keys are keywords"
    (is (misc/keywords? {:a 1 :b 2}))
    (is (false? (misc/keywords? {:a 1 "b" 2})))))

(deftest keywordize-keys
  (testing "should take a map and returns the same map with the keys as keywords"
    (is (misc/keywords? (misc/keywordize-keys {"count" 1 :list [1]})))
    (is (misc/keywords? (misc/keywordize-keys {"count" 1 "list" [1] :other 2})))
    (is (misc/keywords? (misc/keywordize-keys {:count 1 :list [1] :other 2})))))

(deftest map-values
  (testing "should take a map and a function and return a new map with the function applied to the values"
    (is (= (:count (misc/map-values {:count 0} inc) 1)))))

(deftest map-keys
  (testing "should take a map and a function and return a new map with the function applied to the keys"
    (is (= (:count (misc/map-keys {"count" 0} keyword) 0)))))

(deftest tap
  (testing "should take a value, logs it and returns it"
    (let [logger (atom [])]
      (with-redefs [println #(swap! logger conj %)]
        (is (= 1 (misc/tap 1)))
        (is (= 1 (-> logger deref first)))))))
