(ns clue.vue-instance
  (:require [clue.misc :as misc]
            [clue.protocols.vue-instance :as p.vue-instance]))

(deftype VueState [data]
  IDeref
  (-deref [_]
    (-> data js->clj misc/keywordize-keys))

  IReset
  (-reset! [_ new-value]
    (doseq [key (keys new-value)]
      (goog.object/set data (name key) (clj->js (get new-value key))))
    new-value)

  ISwap
  (-swap! [this f]
    (reset! this (f (deref this))))
  (-swap! [this f a]
    (reset! this (f (deref this) a)))
  (-swap! [this f a b]
    (reset! this (f (deref this) a b)))
  (-swap! [this f a b xs]
    (reset! this (apply f (deref this) a b xs))))

(defn get-instance* [vue]
  (:instance vue))

(defn get-data [vue]
  (-> vue
      p.vue-instance/get-instance*
      .-$data
      VueState.))

(defrecord VueInstance [instance]
  p.vue-instance/IVueInstance
  (get-instance* [this]
    (get-instance* this))
  (get-data [this]
    (get-data this)))

(defn new-vue-instance [instance]
  (VueInstance. instance))
