if(typeof Math.imul == "undefined" || (Math.imul(0xffffffff,5) == 0)) {
    Math.imul = function (a, b) {
        var ah  = (a >>> 16) & 0xffff;
        var al = a & 0xffff;
        var bh  = (b >>> 16) & 0xffff;
        var bl = b & 0xffff;
        // the shift by 0 fixes the sign on the high part
        // the final |0 converts the unsigned value into a signed value
        return ((al * bl) + (((ah * bl + al * bh) << 16) >>> 0)|0);
    }
}

/*!
 * jQuery JavaScript Library v1.6.4
 * http://jquery.com/
 *
 * Copyright 2011, John Resig
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * Includes Sizzle.js
 * http://sizzlejs.com/
 * Copyright 2011, The Dojo Foundation
 * Released under the MIT, BSD, and GPL Licenses.
 *
 * Date: Mon Sep 12 18:54:48 2011 -0400
 */
(function( window, undefined ) {

// Use the correct document accordingly with window argument (sandbox)
var document = window.document,
	navigator = window.navigator,
	location = window.location;
var jQuery = (function() {

// Define a local copy of jQuery
var jQuery = function( selector, context ) {
		// The jQuery object is actually just the init constructor 'enhanced'
		return new jQuery.fn.init( selector, context, rootjQuery );
	},

	// Map over jQuery in case of overwrite
	_jQuery = window.jQuery,

	// Map over the $ in case of overwrite
	_$ = window.$,

	// A central reference to the root jQuery(document)
	rootjQuery,

	// A simple way to check for HTML strings or ID strings
	// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
	quickExpr = /^(?:[^#<]*(<[\w\W]+>)[^>]*$|#([\w\-]*)$)/,

	// Check if a string has a non-whitespace character in it
	rnotwhite = /\S/,

	// Used for trimming whitespace
	trimLeft = /^\s+/,
	trimRight = /\s+$/,

	// Check for digits
	rdigit = /\d/,

	// Match a standalone tag
	rsingleTag = /^<(\w+)\s*\/?>(?:<\/\1>)?$/,

	// JSON RegExp
	rvalidchars = /^[\],:{}\s]*$/,
	rvalidescape = /\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,
	rvalidtokens = /"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,
	rvalidbraces = /(?:^|:|,)(?:\s*\[)+/g,

	// Useragent RegExp
	rwebkit = /(webkit)[ \/]([\w.]+)/,
	ropera = /(opera)(?:.*version)?[ \/]([\w.]+)/,
	rmsie = /(msie) ([\w.]+)/,
	rmozilla = /(mozilla)(?:.*? rv:([\w.]+))?/,

	// Matches dashed string for camelizing
	rdashAlpha = /-([a-z]|[0-9])/ig,
	rmsPrefix = /^-ms-/,

	// Used by jQuery.camelCase as callback to replace()
	fcamelCase = function( all, letter ) {
		return ( letter + "" ).toUpperCase();
	},

	// Keep a UserAgent string for use with jQuery.browser
	userAgent = navigator.userAgent,

	// For matching the engine and version of the browser
	browserMatch,

	// The deferred used on DOM ready
	readyList,

	// The ready event handler
	DOMContentLoaded,

	// Save a reference to some core methods
	toString = Object.prototype.toString,
	hasOwn = Object.prototype.hasOwnProperty,
	push = Array.prototype.push,
	slice = Array.prototype.slice,
	trim = String.prototype.trim,
	indexOf = Array.prototype.indexOf,

	// [[Class]] -> type pairs
	class2type = {};

jQuery.fn = jQuery.prototype = {
	constructor: jQuery,
	init: function( selector, context, rootjQuery ) {
		var match, elem, ret, doc;

		// Handle $(""), $(null), or $(undefined)
		if ( !selector ) {
			return this;
		}

		// Handle $(DOMElement)
		if ( selector.nodeType ) {
			this.context = this[0] = selector;
			this.length = 1;
			return this;
		}

		// The body element only exists once, optimize finding it
		if ( selector === "body" && !context && document.body ) {
			this.context = document;
			this[0] = document.body;
			this.selector = selector;
			this.length = 1;
			return this;
		}

		// Handle HTML strings
		if ( typeof selector === "string" ) {
			// Are we dealing with HTML string or an ID?
			if ( selector.charAt(0) === "<" && selector.charAt( selector.length - 1 ) === ">" && selector.length >= 3 ) {
				// Assume that strings that start and end with <> are HTML and skip the regex check
				match = [ null, selector, null ];

			} else {
				match = quickExpr.exec( selector );
			}

			// Verify a match, and that no context was specified for #id
			if ( match && (match[1] || !context) ) {

				// HANDLE: $(html) -> $(array)
				if ( match[1] ) {
					context = context instanceof jQuery ? context[0] : context;
					doc = (context ? context.ownerDocument || context : document);

					// If a single string is passed in and it's a single tag
					// just do a createElement and skip the rest
					ret = rsingleTag.exec( selector );

					if ( ret ) {
						if ( jQuery.isPlainObject( context ) ) {
							selector = [ document.createElement( ret[1] ) ];
							jQuery.fn.attr.call( selector, context, true );

						} else {
							selector = [ doc.createElement( ret[1] ) ];
						}

					} else {
						ret = jQuery.buildFragment( [ match[1] ], [ doc ] );
						selector = (ret.cacheable ? jQuery.clone(ret.fragment) : ret.fragment).childNodes;
					}

					return jQuery.merge( this, selector );

				// HANDLE: $("#id")
				} else {
					elem = document.getElementById( match[2] );

					// Check parentNode to catch when Blackberry 4.6 returns
					// nodes that are no longer in the document #6963
					if ( elem && elem.parentNode ) {
						// Handle the case where IE and Opera return items
						// by name instead of ID
						if ( elem.id !== match[2] ) {
							return rootjQuery.find( selector );
						}

						// Otherwise, we inject the element directly into the jQuery object
						this.length = 1;
						this[0] = elem;
					}

					this.context = document;
					this.selector = selector;
					return this;
				}

			// HANDLE: $(expr, $(...))
			} else if ( !context || context.jquery ) {
				return (context || rootjQuery).find( selector );

			// HANDLE: $(expr, context)
			// (which is just equivalent to: $(context).find(expr)
			} else {
				return this.constructor( context ).find( selector );
			}

		// HANDLE: $(function)
		// Shortcut for document ready
		} else if ( jQuery.isFunction( selector ) ) {
			return rootjQuery.ready( selector );
		}

		if (selector.selector !== undefined) {
			this.selector = selector.selector;
			this.context = selector.context;
		}

		return jQuery.makeArray( selector, this );
	},

	// Start with an empty selector
	selector: "",

	// The current version of jQuery being used
	jquery: "1.6.4",

	// The default length of a jQuery object is 0
	length: 0,

	// The number of elements contained in the matched element set
	size: function() {
		return this.length;
	},

	toArray: function() {
		return slice.call( this, 0 );
	},

	// Get the Nth element in the matched element set OR
	// Get the whole matched element set as a clean array
	get: function( num ) {
		return num == null ?

			// Return a 'clean' array
			this.toArray() :

			// Return just the object
			( num < 0 ? this[ this.length + num ] : this[ num ] );
	},

	// Take an array of elements and push it onto the stack
	// (returning the new matched element set)
	pushStack: function( elems, name, selector ) {
		// Build a new jQuery matched element set
		var ret = this.constructor();

		if ( jQuery.isArray( elems ) ) {
			push.apply( ret, elems );

		} else {
			jQuery.merge( ret, elems );
		}

		// Add the old object onto the stack (as a reference)
		ret.prevObject = this;

		ret.context = this.context;

		if ( name === "find" ) {
			ret.selector = this.selector + (this.selector ? " " : "") + selector;
		} else if ( name ) {
			ret.selector = this.selector + "." + name + "(" + selector + ")";
		}

		// Return the newly-formed element set
		return ret;
	},

	// Execute a callback for every element in the matched set.
	// (You can seed the arguments with an array of args, but this is
	// only used internally.)
	each: function( callback, args ) {
		return jQuery.each( this, callback, args );
	},

	ready: function( fn ) {
		// Attach the listeners
		jQuery.bindReady();

		// Add the callback
		readyList.done( fn );

		return this;
	},

	eq: function( i ) {
		return i === -1 ?
			this.slice( i ) :
			this.slice( i, +i + 1 );
	},

	first: function() {
		return this.eq( 0 );
	},

	last: function() {
		return this.eq( -1 );
	},

	slice: function() {
		return this.pushStack( slice.apply( this, arguments ),
			"slice", slice.call(arguments).join(",") );
	},

	map: function( callback ) {
		return this.pushStack( jQuery.map(this, function( elem, i ) {
			return callback.call( elem, i, elem );
		}));
	},

	end: function() {
		return this.prevObject || this.constructor(null);
	},

	// For internal use only.
	// Behaves like an Array's method, not like a jQuery method.
	push: push,
	sort: [].sort,
	splice: [].splice
};

// Give the init function the jQuery prototype for later instantiation
jQuery.fn.init.prototype = jQuery.fn;

jQuery.extend = jQuery.fn.extend = function() {
	var options, name, src, copy, copyIsArray, clone,
		target = arguments[0] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;
		target = arguments[1] || {};
		// skip the boolean and the target
		i = 2;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && !jQuery.isFunction(target) ) {
		target = {};
	}

	// extend jQuery itself if only one argument is passed
	if ( length === i ) {
		target = this;
		--i;
	}

	for ( ; i < length; i++ ) {
		// Only deal with non-null/undefined values
		if ( (options = arguments[ i ]) != null ) {
			// Extend the base object
			for ( name in options ) {
				src = target[ name ];
				copy = options[ name ];

				// Prevent never-ending loop
				if ( target === copy ) {
					continue;
				}

				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( jQuery.isPlainObject(copy) || (copyIsArray = jQuery.isArray(copy)) ) ) {
					if ( copyIsArray ) {
						copyIsArray = false;
						clone = src && jQuery.isArray(src) ? src : [];

					} else {
						clone = src && jQuery.isPlainObject(src) ? src : {};
					}

					// Never move original objects, clone them
					target[ name ] = jQuery.extend( deep, clone, copy );

				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

jQuery.extend({
	noConflict: function( deep ) {
		if ( window.$ === jQuery ) {
			window.$ = _$;
		}

		if ( deep && window.jQuery === jQuery ) {
			window.jQuery = _jQuery;
		}

		return jQuery;
	},

	// Is the DOM ready to be used? Set to true once it occurs.
	isReady: false,

	// A counter to track how many items to wait for before
	// the ready event fires. See #6781
	readyWait: 1,

	// Hold (or release) the ready event
	holdReady: function( hold ) {
		if ( hold ) {
			jQuery.readyWait++;
		} else {
			jQuery.ready( true );
		}
	},

	// Handle when the DOM is ready
	ready: function( wait ) {
		// Either a released hold or an DOMready/load event and not yet ready
		if ( (wait === true && !--jQuery.readyWait) || (wait !== true && !jQuery.isReady) ) {
			// Make sure body exists, at least, in case IE gets a little overzealous (ticket #5443).
			if ( !document.body ) {
				return setTimeout( jQuery.ready, 1 );
			}

			// Remember that the DOM is ready
			jQuery.isReady = true;

			// If a normal DOM Ready event fired, decrement, and wait if need be
			if ( wait !== true && --jQuery.readyWait > 0 ) {
				return;
			}

			// If there are functions bound, to execute
			readyList.resolveWith( document, [ jQuery ] );

			// Trigger any bound ready events
			if ( jQuery.fn.trigger ) {
				jQuery( document ).trigger( "ready" ).unbind( "ready" );
			}
		}
	},

	bindReady: function() {
		if ( readyList ) {
			return;
		}

		readyList = jQuery._Deferred();

		// Catch cases where $(document).ready() is called after the
		// browser event has already occurred.
		if ( document.readyState === "complete" ) {
			// Handle it asynchronously to allow scripts the opportunity to delay ready
			return setTimeout( jQuery.ready, 1 );
		}

		// Mozilla, Opera and webkit nightlies currently support this event
		if ( document.addEventListener ) {
			// Use the handy event callback
			document.addEventListener( "DOMContentLoaded", DOMContentLoaded, false );

			// A fallback to window.onload, that will always work
			window.addEventListener( "load", jQuery.ready, false );

		// If IE event model is used
		} else if ( document.attachEvent ) {
			// ensure firing before onload,
			// maybe late but safe also for iframes
			document.attachEvent( "onreadystatechange", DOMContentLoaded );

			// A fallback to window.onload, that will always work
			window.attachEvent( "onload", jQuery.ready );

			// If IE and not a frame
			// continually check to see if the document is ready
			var toplevel = false;

			try {
				toplevel = window.frameElement == null;
			} catch(e) {}

			if ( document.documentElement.doScroll && toplevel ) {
				doScrollCheck();
			}
		}
	},

	// See test/unit/core.js for details concerning isFunction.
	// Since version 1.3, DOM methods and functions like alert
	// aren't supported. They return false on IE (#2968).
	isFunction: function( obj ) {
		return jQuery.type(obj) === "function";
	},

	isArray: Array.isArray || function( obj ) {
		return jQuery.type(obj) === "array";
	},

	// A crude way of determining if an object is a window
	isWindow: function( obj ) {
		return obj && typeof obj === "object" && "setInterval" in obj;
	},

	isNaN: function( obj ) {
		return obj == null || !rdigit.test( obj ) || isNaN( obj );
	},

	type: function( obj ) {
		return obj == null ?
			String( obj ) :
			class2type[ toString.call(obj) ] || "object";
	},

	isPlainObject: function( obj ) {
		// Must be an Object.
		// Because of IE, we also have to check the presence of the constructor property.
		// Make sure that DOM nodes and window objects don't pass through, as well
		if ( !obj || jQuery.type(obj) !== "object" || obj.nodeType || jQuery.isWindow( obj ) ) {
			return false;
		}

		try {
			// Not own constructor property must be Object
			if ( obj.constructor &&
				!hasOwn.call(obj, "constructor") &&
				!hasOwn.call(obj.constructor.prototype, "isPrototypeOf") ) {
				return false;
			}
		} catch ( e ) {
			// IE8,9 Will throw exceptions on certain host objects #9897
			return false;
		}

		// Own properties are enumerated firstly, so to speed up,
		// if last one is own, then all properties are own.

		var key;
		for ( key in obj ) {}

		return key === undefined || hasOwn.call( obj, key );
	},

	isEmptyObject: function( obj ) {
		for ( var name in obj ) {
			return false;
		}
		return true;
	},

	error: function( msg ) {
		throw msg;
	},

	parseJSON: function( data ) {
		if ( typeof data !== "string" || !data ) {
			return null;
		}

		// Make sure leading/trailing whitespace is removed (IE can't handle it)
		data = jQuery.trim( data );

		// Attempt to parse using the native JSON parser first
		if ( window.JSON && window.JSON.parse ) {
			return window.JSON.parse( data );
		}

		// Make sure the incoming data is actual JSON
		// Logic borrowed from http://json.org/json2.js
		if ( rvalidchars.test( data.replace( rvalidescape, "@" )
			.replace( rvalidtokens, "]" )
			.replace( rvalidbraces, "")) ) {

			return (new Function( "return " + data ))();

		}
		jQuery.error( "Invalid JSON: " + data );
	},

	// Cross-browser xml parsing
	parseXML: function( data ) {
		var xml, tmp;
		try {
			if ( window.DOMParser ) { // Standard
				tmp = new DOMParser();
				xml = tmp.parseFromString( data , "text/xml" );
			} else { // IE
				xml = new ActiveXObject( "Microsoft.XMLDOM" );
				xml.async = "false";
				xml.loadXML( data );
			}
		} catch( e ) {
			xml = undefined;
		}
		if ( !xml || !xml.documentElement || xml.getElementsByTagName( "parsererror" ).length ) {
			jQuery.error( "Invalid XML: " + data );
		}
		return xml;
	},

	noop: function() {},

	// Evaluates a script in a global context
	// Workarounds based on findings by Jim Driscoll
	// http://weblogs.java.net/blog/driscoll/archive/2009/09/08/eval-javascript-global-context
	globalEval: function( data ) {
		if ( data && rnotwhite.test( data ) ) {
			// We use execScript on Internet Explorer
			// We use an anonymous function so that context is window
			// rather than jQuery in Firefox
			( window.execScript || function( data ) {
				window[ "eval" ].call( window, data );
			} )( data );
		}
	},

	// Convert dashed to camelCase; used by the css and data modules
	// Microsoft forgot to hump their vendor prefix (#9572)
	camelCase: function( string ) {
		return string.replace( rmsPrefix, "ms-" ).replace( rdashAlpha, fcamelCase );
	},

	nodeName: function( elem, name ) {
		return elem.nodeName && elem.nodeName.toUpperCase() === name.toUpperCase();
	},

	// args is for internal usage only
	each: function( object, callback, args ) {
		var name, i = 0,
			length = object.length,
			isObj = length === undefined || jQuery.isFunction( object );

		if ( args ) {
			if ( isObj ) {
				for ( name in object ) {
					if ( callback.apply( object[ name ], args ) === false ) {
						break;
					}
				}
			} else {
				for ( ; i < length; ) {
					if ( callback.apply( object[ i++ ], args ) === false ) {
						break;
					}
				}
			}

		// A special, fast, case for the most common use of each
		} else {
			if ( isObj ) {
				for ( name in object ) {
					if ( callback.call( object[ name ], name, object[ name ] ) === false ) {
						break;
					}
				}
			} else {
				for ( ; i < length; ) {
					if ( callback.call( object[ i ], i, object[ i++ ] ) === false ) {
						break;
					}
				}
			}
		}

		return object;
	},

	// Use native String.trim function wherever possible
	trim: trim ?
		function( text ) {
			return text == null ?
				"" :
				trim.call( text );
		} :

		// Otherwise use our own trimming functionality
		function( text ) {
			return text == null ?
				"" :
				text.toString().replace( trimLeft, "" ).replace( trimRight, "" );
		},

	// results is for internal usage only
	makeArray: function( array, results ) {
		var ret = results || [];

		if ( array != null ) {
			// The window, strings (and functions) also have 'length'
			// The extra typeof function check is to prevent crashes
			// in Safari 2 (See: #3039)
			// Tweaked logic slightly to handle Blackberry 4.7 RegExp issues #6930
			var type = jQuery.type( array );

			if ( array.length == null || type === "string" || type === "function" || type === "regexp" || jQuery.isWindow( array ) ) {
				push.call( ret, array );
			} else {
				jQuery.merge( ret, array );
			}
		}

		return ret;
	},

	inArray: function( elem, array ) {
		if ( !array ) {
			return -1;
		}

		if ( indexOf ) {
			return indexOf.call( array, elem );
		}

		for ( var i = 0, length = array.length; i < length; i++ ) {
			if ( array[ i ] === elem ) {
				return i;
			}
		}

		return -1;
	},

	merge: function( first, second ) {
		var i = first.length,
			j = 0;

		if ( typeof second.length === "number" ) {
			for ( var l = second.length; j < l; j++ ) {
				first[ i++ ] = second[ j ];
			}

		} else {
			while ( second[j] !== undefined ) {
				first[ i++ ] = second[ j++ ];
			}
		}

		first.length = i;

		return first;
	},

	grep: function( elems, callback, inv ) {
		var ret = [], retVal;
		inv = !!inv;

		// Go through the array, only saving the items
		// that pass the validator function
		for ( var i = 0, length = elems.length; i < length; i++ ) {
			retVal = !!callback( elems[ i ], i );
			if ( inv !== retVal ) {
				ret.push( elems[ i ] );
			}
		}

		return ret;
	},

	// arg is for internal usage only
	map: function( elems, callback, arg ) {
		var value, key, ret = [],
			i = 0,
			length = elems.length,
			// jquery objects are treated as arrays
			isArray = elems instanceof jQuery || length !== undefined && typeof length === "number" && ( ( length > 0 && elems[ 0 ] && elems[ length -1 ] ) || length === 0 || jQuery.isArray( elems ) ) ;

		// Go through the array, translating each of the items to their
		if ( isArray ) {
			for ( ; i < length; i++ ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret[ ret.length ] = value;
				}
			}

		// Go through every key on the object,
		} else {
			for ( key in elems ) {
				value = callback( elems[ key ], key, arg );

				if ( value != null ) {
					ret[ ret.length ] = value;
				}
			}
		}

		// Flatten any nested arrays
		return ret.concat.apply( [], ret );
	},

	// A global GUID counter for objects
	guid: 1,

	// Bind a function to a context, optionally partially applying any
	// arguments.
	proxy: function( fn, context ) {
		if ( typeof context === "string" ) {
			var tmp = fn[ context ];
			context = fn;
			fn = tmp;
		}

		// Quick check to determine if target is callable, in the spec
		// this throws a TypeError, but we will just return undefined.
		if ( !jQuery.isFunction( fn ) ) {
			return undefined;
		}

		// Simulated bind
		var args = slice.call( arguments, 2 ),
			proxy = function() {
				return fn.apply( context, args.concat( slice.call( arguments ) ) );
			};

		// Set the guid of unique handler to the same of original handler, so it can be removed
		proxy.guid = fn.guid = fn.guid || proxy.guid || jQuery.guid++;

		return proxy;
	},

	// Mutifunctional method to get and set values to a collection
	// The value/s can optionally be executed if it's a function
	access: function( elems, key, value, exec, fn, pass ) {
		var length = elems.length;

		// Setting many attributes
		if ( typeof key === "object" ) {
			for ( var k in key ) {
				jQuery.access( elems, k, key[k], exec, fn, value );
			}
			return elems;
		}

		// Setting one attribute
		if ( value !== undefined ) {
			// Optionally, function values get executed if exec is true
			exec = !pass && exec && jQuery.isFunction(value);

			for ( var i = 0; i < length; i++ ) {
				fn( elems[i], key, exec ? value.call( elems[i], i, fn( elems[i], key ) ) : value, pass );
			}

			return elems;
		}

		// Getting an attribute
		return length ? fn( elems[0], key ) : undefined;
	},

	now: function() {
		return (new Date()).getTime();
	},

	// Use of jQuery.browser is frowned upon.
	// More details: http://docs.jquery.com/Utilities/jQuery.browser
	uaMatch: function( ua ) {
		ua = ua.toLowerCase();

		var match = rwebkit.exec( ua ) ||
			ropera.exec( ua ) ||
			rmsie.exec( ua ) ||
			ua.indexOf("compatible") < 0 && rmozilla.exec( ua ) ||
			[];

		return { browser: match[1] || "", version: match[2] || "0" };
	},

	sub: function() {
		function jQuerySub( selector, context ) {
			return new jQuerySub.fn.init( selector, context );
		}
		jQuery.extend( true, jQuerySub, this );
		jQuerySub.superclass = this;
		jQuerySub.fn = jQuerySub.prototype = this();
		jQuerySub.fn.constructor = jQuerySub;
		jQuerySub.sub = this.sub;
		jQuerySub.fn.init = function init( selector, context ) {
			if ( context && context instanceof jQuery && !(context instanceof jQuerySub) ) {
				context = jQuerySub( context );
			}

			return jQuery.fn.init.call( this, selector, context, rootjQuerySub );
		};
		jQuerySub.fn.init.prototype = jQuerySub.fn;
		var rootjQuerySub = jQuerySub(document);
		return jQuerySub;
	},

	browser: {}
});

// Populate the class2type map
jQuery.each("Boolean Number String Function Array Date RegExp Object".split(" "), function(i, name) {
	class2type[ "[object " + name + "]" ] = name.toLowerCase();
});

browserMatch = jQuery.uaMatch( userAgent );
if ( browserMatch.browser ) {
	jQuery.browser[ browserMatch.browser ] = true;
	jQuery.browser.version = browserMatch.version;
}

// Deprecated, use jQuery.browser.webkit instead
if ( jQuery.browser.webkit ) {
	jQuery.browser.safari = true;
}

// IE doesn't match non-breaking spaces with \s
if ( rnotwhite.test( "\xA0" ) ) {
	trimLeft = /^[\s\xA0]+/;
	trimRight = /[\s\xA0]+$/;
}

// All jQuery objects should point back to these
rootjQuery = jQuery(document);

// Cleanup functions for the document ready method
if ( document.addEventListener ) {
	DOMContentLoaded = function() {
		document.removeEventListener( "DOMContentLoaded", DOMContentLoaded, false );
		jQuery.ready();
	};

} else if ( document.attachEvent ) {
	DOMContentLoaded = function() {
		// Make sure body exists, at least, in case IE gets a little overzealous (ticket #5443).
		if ( document.readyState === "complete" ) {
			document.detachEvent( "onreadystatechange", DOMContentLoaded );
			jQuery.ready();
		}
	};
}

// The DOM ready check for Internet Explorer
function doScrollCheck() {
	if ( jQuery.isReady ) {
		return;
	}

	try {
		// If IE is used, use the trick by Diego Perini
		// http://javascript.nwbox.com/IEContentLoaded/
		document.documentElement.doScroll("left");
	} catch(e) {
		setTimeout( doScrollCheck, 1 );
		return;
	}

	// and execute any waiting functions
	jQuery.ready();
}

return jQuery;

})();


var // Promise methods
	promiseMethods = "done fail isResolved isRejected promise then always pipe".split( " " ),
	// Static reference to slice
	sliceDeferred = [].slice;

jQuery.extend({
	// Create a simple deferred (one callbacks list)
	_Deferred: function() {
		var // callbacks list
			callbacks = [],
			// stored [ context , args ]
			fired,
			// to avoid firing when already doing so
			firing,
			// flag to know if the deferred has been cancelled
			cancelled,
			// the deferred itself
			deferred  = {

				// done( f1, f2, ...)
				done: function() {
					if ( !cancelled ) {
						var args = arguments,
							i,
							length,
							elem,
							type,
							_fired;
						if ( fired ) {
							_fired = fired;
							fired = 0;
						}
						for ( i = 0, length = args.length; i < length; i++ ) {
							elem = args[ i ];
							type = jQuery.type( elem );
							if ( type === "array" ) {
								deferred.done.apply( deferred, elem );
							} else if ( type === "function" ) {
								callbacks.push( elem );
							}
						}
						if ( _fired ) {
							deferred.resolveWith( _fired[ 0 ], _fired[ 1 ] );
						}
					}
					return this;
				},

				// resolve with given context and args
				resolveWith: function( context, args ) {
					if ( !cancelled && !fired && !firing ) {
						// make sure args are available (#8421)
						args = args || [];
						firing = 1;
						try {
							while( callbacks[ 0 ] ) {
								callbacks.shift().apply( context, args );
							}
						}
						finally {
							fired = [ context, args ];
							firing = 0;
						}
					}
					return this;
				},

				// resolve with this as context and given arguments
				resolve: function() {
					deferred.resolveWith( this, arguments );
					return this;
				},

				// Has this deferred been resolved?
				isResolved: function() {
					return !!( firing || fired );
				},

				// Cancel
				cancel: function() {
					cancelled = 1;
					callbacks = [];
					return this;
				}
			};

		return deferred;
	},

	// Full fledged deferred (two callbacks list)
	Deferred: function( func ) {
		var deferred = jQuery._Deferred(),
			failDeferred = jQuery._Deferred(),
			promise;
		// Add errorDeferred methods, then and promise
		jQuery.extend( deferred, {
			then: function( doneCallbacks, failCallbacks ) {
				deferred.done( doneCallbacks ).fail( failCallbacks );
				return this;
			},
			always: function() {
				return deferred.done.apply( deferred, arguments ).fail.apply( this, arguments );
			},
			fail: failDeferred.done,
			rejectWith: failDeferred.resolveWith,
			reject: failDeferred.resolve,
			isRejected: failDeferred.isResolved,
			pipe: function( fnDone, fnFail ) {
				return jQuery.Deferred(function( newDefer ) {
					jQuery.each( {
						done: [ fnDone, "resolve" ],
						fail: [ fnFail, "reject" ]
					}, function( handler, data ) {
						var fn = data[ 0 ],
							action = data[ 1 ],
							returned;
						if ( jQuery.isFunction( fn ) ) {
							deferred[ handler ](function() {
								returned = fn.apply( this, arguments );
								if ( returned && jQuery.isFunction( returned.promise ) ) {
									returned.promise().then( newDefer.resolve, newDefer.reject );
								} else {
									newDefer[ action + "With" ]( this === deferred ? newDefer : this, [ returned ] );
								}
							});
						} else {
							deferred[ handler ]( newDefer[ action ] );
						}
					});
				}).promise();
			},
			// Get a promise for this deferred
			// If obj is provided, the promise aspect is added to the object
			promise: function( obj ) {
				if ( obj == null ) {
					if ( promise ) {
						return promise;
					}
					promise = obj = {};
				}
				var i = promiseMethods.length;
				while( i-- ) {
					obj[ promiseMethods[i] ] = deferred[ promiseMethods[i] ];
				}
				return obj;
			}
		});
		// Make sure only one callback list will be used
		deferred.done( failDeferred.cancel ).fail( deferred.cancel );
		// Unexpose cancel
		delete deferred.cancel;
		// Call given func if any
		if ( func ) {
			func.call( deferred, deferred );
		}
		return deferred;
	},

	// Deferred helper
	when: function( firstParam ) {
		var args = arguments,
			i = 0,
			length = args.length,
			count = length,
			deferred = length <= 1 && firstParam && jQuery.isFunction( firstParam.promise ) ?
				firstParam :
				jQuery.Deferred();
		function resolveFunc( i ) {
			return function( value ) {
				args[ i ] = arguments.length > 1 ? sliceDeferred.call( arguments, 0 ) : value;
				if ( !( --count ) ) {
					// Strange bug in FF4:
					// Values changed onto the arguments object sometimes end up as undefined values
					// outside the $.when method. Cloning the object into a fresh array solves the issue
					deferred.resolveWith( deferred, sliceDeferred.call( args, 0 ) );
				}
			};
		}
		if ( length > 1 ) {
			for( ; i < length; i++ ) {
				if ( args[ i ] && jQuery.isFunction( args[ i ].promise ) ) {
					args[ i ].promise().then( resolveFunc(i), deferred.reject );
				} else {
					--count;
				}
			}
			if ( !count ) {
				deferred.resolveWith( deferred, args );
			}
		} else if ( deferred !== firstParam ) {
			deferred.resolveWith( deferred, length ? [ firstParam ] : [] );
		}
		return deferred.promise();
	}
});



jQuery.support = (function() {

	var div = document.createElement( "div" ),
		documentElement = document.documentElement,
		all,
		a,
		select,
		opt,
		input,
		marginDiv,
		support,
		fragment,
		body,
		testElementParent,
		testElement,
		testElementStyle,
		tds,
		events,
		eventName,
		i,
		isSupported;

	// Preliminary tests
	div.setAttribute("className", "t");
	div.innerHTML = "   <link/><table></table><a href='/a' style='top:1px;float:left;opacity:.55;'>a</a><input type='checkbox'/>";


	all = div.getElementsByTagName( "*" );
	a = div.getElementsByTagName( "a" )[ 0 ];

	// Can't get basic test support
	if ( !all || !all.length || !a ) {
		return {};
	}

	// First batch of supports tests
	select = document.createElement( "select" );
	opt = select.appendChild( document.createElement("option") );
	input = div.getElementsByTagName( "input" )[ 0 ];

	support = {
		// IE strips leading whitespace when .innerHTML is used
		leadingWhitespace: ( div.firstChild.nodeType === 3 ),

		// Make sure that tbody elements aren't automatically inserted
		// IE will insert them into empty tables
		tbody: !div.getElementsByTagName( "tbody" ).length,

		// Make sure that link elements get serialized correctly by innerHTML
		// This requires a wrapper element in IE
		htmlSerialize: !!div.getElementsByTagName( "link" ).length,

		// Get the style information from getAttribute
		// (IE uses .cssText instead)
		style: /top/.test( a.getAttribute("style") ),

		// Make sure that URLs aren't manipulated
		// (IE normalizes it by default)
		hrefNormalized: ( a.getAttribute( "href" ) === "/a" ),

		// Make sure that element opacity exists
		// (IE uses filter instead)
		// Use a regex to work around a WebKit issue. See #5145
		opacity: /^0.55$/.test( a.style.opacity ),

		// Verify style float existence
		// (IE uses styleFloat instead of cssFloat)
		cssFloat: !!a.style.cssFloat,

		// Make sure that if no value is specified for a checkbox
		// that it defaults to "on".
		// (WebKit defaults to "" instead)
		checkOn: ( input.value === "on" ),

		// Make sure that a selected-by-default option has a working selected property.
		// (WebKit defaults to false instead of true, IE too, if it's in an optgroup)
		optSelected: opt.selected,

		// Test setAttribute on camelCase class. If it works, we need attrFixes when doing get/setAttribute (ie6/7)
		getSetAttribute: div.className !== "t",

		// Will be defined later
		submitBubbles: true,
		changeBubbles: true,
		focusinBubbles: false,
		deleteExpando: true,
		noCloneEvent: true,
		inlineBlockNeedsLayout: false,
		shrinkWrapBlocks: false,
		reliableMarginRight: true
	};

	// Make sure checked status is properly cloned
	input.checked = true;
	support.noCloneChecked = input.cloneNode( true ).checked;

	// Make sure that the options inside disabled selects aren't marked as disabled
	// (WebKit marks them as disabled)
	select.disabled = true;
	support.optDisabled = !opt.disabled;

	// Test to see if it's possible to delete an expando from an element
	// Fails in Internet Explorer
	try {
		delete div.test;
	} catch( e ) {
		support.deleteExpando = false;
	}

	if ( !div.addEventListener && div.attachEvent && div.fireEvent ) {
		div.attachEvent( "onclick", function() {
			// Cloning a node shouldn't copy over any
			// bound event handlers (IE does this)
			support.noCloneEvent = false;
		});
		div.cloneNode( true ).fireEvent( "onclick" );
	}

	// Check if a radio maintains it's value
	// after being appended to the DOM
	input = document.createElement("input");
	input.value = "t";
	input.setAttribute("type", "radio");
	support.radioValue = input.value === "t";

	input.setAttribute("checked", "checked");
	div.appendChild( input );
	fragment = document.createDocumentFragment();
	fragment.appendChild( div.firstChild );

	// WebKit doesn't clone checked state correctly in fragments
	support.checkClone = fragment.cloneNode( true ).cloneNode( true ).lastChild.checked;

	div.innerHTML = "";

	// Figure out if the W3C box model works as expected
	div.style.width = div.style.paddingLeft = "1px";

	body = document.getElementsByTagName( "body" )[ 0 ];
	// We use our own, invisible, body unless the body is already present
	// in which case we use a div (#9239)
	testElement = document.createElement( body ? "div" : "body" );
	testElementStyle = {
		visibility: "hidden",
		width: 0,
		height: 0,
		border: 0,
		margin: 0,
		background: "none"
	};
	if ( body ) {
		jQuery.extend( testElementStyle, {
			position: "absolute",
			left: "-1000px",
			top: "-1000px"
		});
	}
	for ( i in testElementStyle ) {
		testElement.style[ i ] = testElementStyle[ i ];
	}
	testElement.appendChild( div );
	testElementParent = body || documentElement;
	testElementParent.insertBefore( testElement, testElementParent.firstChild );

	// Check if a disconnected checkbox will retain its checked
	// value of true after appended to the DOM (IE6/7)
	support.appendChecked = input.checked;

	support.boxModel = div.offsetWidth === 2;

	if ( "zoom" in div.style ) {
		// Check if natively block-level elements act like inline-block
		// elements when setting their display to 'inline' and giving
		// them layout
		// (IE < 8 does this)
		div.style.display = "inline";
		div.style.zoom = 1;
		support.inlineBlockNeedsLayout = ( div.offsetWidth === 2 );

		// Check if elements with layout shrink-wrap their children
		// (IE 6 does this)
		div.style.display = "";
		div.innerHTML = "<div style='width:4px;'></div>";
		support.shrinkWrapBlocks = ( div.offsetWidth !== 2 );
	}

	div.innerHTML = "<table><tr><td style='padding:0;border:0;display:none'></td><td>t</td></tr></table>";
	tds = div.getElementsByTagName( "td" );

	// Check if table cells still have offsetWidth/Height when they are set
	// to display:none and there are still other visible table cells in a
	// table row; if so, offsetWidth/Height are not reliable for use when
	// determining if an element has been hidden directly using
	// display:none (it is still safe to use offsets if a parent element is
	// hidden; don safety goggles and see bug #4512 for more information).
	// (only IE 8 fails this test)
	isSupported = ( tds[ 0 ].offsetHeight === 0 );

	tds[ 0 ].style.display = "";
	tds[ 1 ].style.display = "none";

	// Check if empty table cells still have offsetWidth/Height
	// (IE < 8 fail this test)
	support.reliableHiddenOffsets = isSupported && ( tds[ 0 ].offsetHeight === 0 );
	div.innerHTML = "";

	// Check if div with explicit width and no margin-right incorrectly
	// gets computed margin-right based on width of container. For more
	// info see bug #3333
	// Fails in WebKit before Feb 2011 nightlies
	// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
	if ( document.defaultView && document.defaultView.getComputedStyle ) {
		marginDiv = document.createElement( "div" );
		marginDiv.style.width = "0";
		marginDiv.style.marginRight = "0";
		div.appendChild( marginDiv );
		support.reliableMarginRight =
			( parseInt( ( document.defaultView.getComputedStyle( marginDiv, null ) || { marginRight: 0 } ).marginRight, 10 ) || 0 ) === 0;
	}

	// Remove the body element we added
	testElement.innerHTML = "";
	testElementParent.removeChild( testElement );

	// Technique from Juriy Zaytsev
	// http://thinkweb2.com/projects/prototype/detecting-event-support-without-browser-sniffing/
	// We only care about the case where non-standard event systems
	// are used, namely in IE. Short-circuiting here helps us to
	// avoid an eval call (in setAttribute) which can cause CSP
	// to go haywire. See: https://developer.mozilla.org/en/Security/CSP
	if ( div.attachEvent ) {
		for( i in {
			submit: 1,
			change: 1,
			focusin: 1
		} ) {
			eventName = "on" + i;
			isSupported = ( eventName in div );
			if ( !isSupported ) {
				div.setAttribute( eventName, "return;" );
				isSupported = ( typeof div[ eventName ] === "function" );
			}
			support[ i + "Bubbles" ] = isSupported;
		}
	}

	// Null connected elements to avoid leaks in IE
	testElement = fragment = select = opt = body = marginDiv = div = input = null;

	return support;
})();

// Keep track of boxModel
jQuery.boxModel = jQuery.support.boxModel;




var rbrace = /^(?:\{.*\}|\[.*\])$/,
	rmultiDash = /([A-Z])/g;

jQuery.extend({
	cache: {},

	// Please use with caution
	uuid: 0,

	// Unique for each copy of jQuery on the page
	// Non-digits removed to match rinlinejQuery
	expando: "jQuery" + ( jQuery.fn.jquery + Math.random() ).replace( /\D/g, "" ),

	// The following elements throw uncatchable exceptions if you
	// attempt to add expando properties to them.
	noData: {
		"embed": true,
		// Ban all objects except for Flash (which handle expandos)
		"object": "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000",
		"applet": true
	},

	hasData: function( elem ) {
		elem = elem.nodeType ? jQuery.cache[ elem[jQuery.expando] ] : elem[ jQuery.expando ];

		return !!elem && !isEmptyDataObject( elem );
	},

	data: function( elem, name, data, pvt /* Internal Use Only */ ) {
		if ( !jQuery.acceptData( elem ) ) {
			return;
		}

		var thisCache, ret,
			internalKey = jQuery.expando,
			getByName = typeof name === "string",

			// We have to handle DOM nodes and JS objects differently because IE6-7
			// can't GC object references properly across the DOM-JS boundary
			isNode = elem.nodeType,

			// Only DOM nodes need the global jQuery cache; JS object data is
			// attached directly to the object so GC can occur automatically
			cache = isNode ? jQuery.cache : elem,

			// Only defining an ID for JS objects if its cache already exists allows
			// the code to shortcut on the same path as a DOM node with no cache
			id = isNode ? elem[ jQuery.expando ] : elem[ jQuery.expando ] && jQuery.expando;

		// Avoid doing any more work than we need to when trying to get data on an
		// object that has no data at all
		if ( (!id || (pvt && id && (cache[ id ] && !cache[ id ][ internalKey ]))) && getByName && data === undefined ) {
			return;
		}

		if ( !id ) {
			// Only DOM nodes need a new unique ID for each element since their data
			// ends up in the global cache
			if ( isNode ) {
				elem[ jQuery.expando ] = id = ++jQuery.uuid;
			} else {
				id = jQuery.expando;
			}
		}

		if ( !cache[ id ] ) {
			cache[ id ] = {};

			// TODO: This is a hack for 1.5 ONLY. Avoids exposing jQuery
			// metadata on plain JS objects when the object is serialized using
			// JSON.stringify
			if ( !isNode ) {
				cache[ id ].toJSON = jQuery.noop;
			}
		}

		// An object can be passed to jQuery.data instead of a key/value pair; this gets
		// shallow copied over onto the existing cache
		if ( typeof name === "object" || typeof name === "function" ) {
			if ( pvt ) {
				cache[ id ][ internalKey ] = jQuery.extend(cache[ id ][ internalKey ], name);
			} else {
				cache[ id ] = jQuery.extend(cache[ id ], name);
			}
		}

		thisCache = cache[ id ];

		// Internal jQuery data is stored in a separate object inside the object's data
		// cache in order to avoid key collisions between internal data and user-defined
		// data
		if ( pvt ) {
			if ( !thisCache[ internalKey ] ) {
				thisCache[ internalKey ] = {};
			}

			thisCache = thisCache[ internalKey ];
		}

		if ( data !== undefined ) {
			thisCache[ jQuery.camelCase( name ) ] = data;
		}

		// TODO: This is a hack for 1.5 ONLY. It will be removed in 1.6. Users should
		// not attempt to inspect the internal events object using jQuery.data, as this
		// internal data object is undocumented and subject to change.
		if ( name === "events" && !thisCache[name] ) {
			return thisCache[ internalKey ] && thisCache[ internalKey ].events;
		}

		// Check for both converted-to-camel and non-converted data property names
		// If a data property was specified
		if ( getByName ) {

			// First Try to find as-is property data
			ret = thisCache[ name ];

			// Test for null|undefined property data
			if ( ret == null ) {

				// Try to find the camelCased property
				ret = thisCache[ jQuery.camelCase( name ) ];
			}
		} else {
			ret = thisCache;
		}

		return ret;
	},

	removeData: function( elem, name, pvt /* Internal Use Only */ ) {
		if ( !jQuery.acceptData( elem ) ) {
			return;
		}

		var thisCache,

			// Reference to internal data cache key
			internalKey = jQuery.expando,

			isNode = elem.nodeType,

			// See jQuery.data for more information
			cache = isNode ? jQuery.cache : elem,

			// See jQuery.data for more information
			id = isNode ? elem[ jQuery.expando ] : jQuery.expando;

		// If there is already no cache entry for this object, there is no
		// purpose in continuing
		if ( !cache[ id ] ) {
			return;
		}

		if ( name ) {

			thisCache = pvt ? cache[ id ][ internalKey ] : cache[ id ];

			if ( thisCache ) {

				// Support interoperable removal of hyphenated or camelcased keys
				if ( !thisCache[ name ] ) {
					name = jQuery.camelCase( name );
				}

				delete thisCache[ name ];

				// If there is no data left in the cache, we want to continue
				// and let the cache object itself get destroyed
				if ( !isEmptyDataObject(thisCache) ) {
					return;
				}
			}
		}

		// See jQuery.data for more information
		if ( pvt ) {
			delete cache[ id ][ internalKey ];

			// Don't destroy the parent cache unless the internal data object
			// had been the only thing left in it
			if ( !isEmptyDataObject(cache[ id ]) ) {
				return;
			}
		}

		var internalCache = cache[ id ][ internalKey ];

		// Browsers that fail expando deletion also refuse to delete expandos on
		// the window, but it will allow it on all other JS objects; other browsers
		// don't care
		// Ensure that `cache` is not a window object #10080
		if ( jQuery.support.deleteExpando || !cache.setInterval ) {
			delete cache[ id ];
		} else {
			cache[ id ] = null;
		}

		// We destroyed the entire user cache at once because it's faster than
		// iterating through each key, but we need to continue to persist internal
		// data if it existed
		if ( internalCache ) {
			cache[ id ] = {};
			// TODO: This is a hack for 1.5 ONLY. Avoids exposing jQuery
			// metadata on plain JS objects when the object is serialized using
			// JSON.stringify
			if ( !isNode ) {
				cache[ id ].toJSON = jQuery.noop;
			}

			cache[ id ][ internalKey ] = internalCache;

		// Otherwise, we need to eliminate the expando on the node to avoid
		// false lookups in the cache for entries that no longer exist
		} else if ( isNode ) {
			// IE does not allow us to delete expando properties from nodes,
			// nor does it have a removeAttribute function on Document nodes;
			// we must handle all of these cases
			if ( jQuery.support.deleteExpando ) {
				delete elem[ jQuery.expando ];
			} else if ( elem.removeAttribute ) {
				elem.removeAttribute( jQuery.expando );
			} else {
				elem[ jQuery.expando ] = null;
			}
		}
	},

	// For internal use only.
	_data: function( elem, name, data ) {
		return jQuery.data( elem, name, data, true );
	},

	// A method for determining if a DOM node can handle the data expando
	acceptData: function( elem ) {
		if ( elem.nodeName ) {
			var match = jQuery.noData[ elem.nodeName.toLowerCase() ];

			if ( match ) {
				return !(match === true || elem.getAttribute("classid") !== match);
			}
		}

		return true;
	}
});

jQuery.fn.extend({
	data: function( key, value ) {
		var data = null;

		if ( typeof key === "undefined" ) {
			if ( this.length ) {
				data = jQuery.data( this[0] );

				if ( this[0].nodeType === 1 ) {
			    var attr = this[0].attributes, name;
					for ( var i = 0, l = attr.length; i < l; i++ ) {
						name = attr[i].name;

						if ( name.indexOf( "data-" ) === 0 ) {
							name = jQuery.camelCase( name.substring(5) );

							dataAttr( this[0], name, data[ name ] );
						}
					}
				}
			}

			return data;

		} else if ( typeof key === "object" ) {
			return this.each(function() {
				jQuery.data( this, key );
			});
		}

		var parts = key.split(".");
		parts[1] = parts[1] ? "." + parts[1] : "";

		if ( value === undefined ) {
			data = this.triggerHandler("getData" + parts[1] + "!", [parts[0]]);

			// Try to fetch any internally stored data first
			if ( data === undefined && this.length ) {
				data = jQuery.data( this[0], key );
				data = dataAttr( this[0], key, data );
			}

			return data === undefined && parts[1] ?
				this.data( parts[0] ) :
				data;

		} else {
			return this.each(function() {
				var $this = jQuery( this ),
					args = [ parts[0], value ];

				$this.triggerHandler( "setData" + parts[1] + "!", args );
				jQuery.data( this, key, value );
				$this.triggerHandler( "changeData" + parts[1] + "!", args );
			});
		}
	},

	removeData: function( key ) {
		return this.each(function() {
			jQuery.removeData( this, key );
		});
	}
});

function dataAttr( elem, key, data ) {
	// If nothing was found internally, try to fetch any
	// data from the HTML5 data-* attribute
	if ( data === undefined && elem.nodeType === 1 ) {

		var name = "data-" + key.replace( rmultiDash, "-$1" ).toLowerCase();

		data = elem.getAttribute( name );

		if ( typeof data === "string" ) {
			try {
				data = data === "true" ? true :
				data === "false" ? false :
				data === "null" ? null :
				!jQuery.isNaN( data ) ? parseFloat( data ) :
					rbrace.test( data ) ? jQuery.parseJSON( data ) :
					data;
			} catch( e ) {}

			// Make sure we set the data so it isn't changed later
			jQuery.data( elem, key, data );

		} else {
			data = undefined;
		}
	}

	return data;
}

// TODO: This is a hack for 1.5 ONLY to allow objects with a single toJSON
// property to be considered empty objects; this property always exists in
// order to make sure JSON.stringify does not expose internal metadata
function isEmptyDataObject( obj ) {
	for ( var name in obj ) {
		if ( name !== "toJSON" ) {
			return false;
		}
	}

	return true;
}




function handleQueueMarkDefer( elem, type, src ) {
	var deferDataKey = type + "defer",
		queueDataKey = type + "queue",
		markDataKey = type + "mark",
		defer = jQuery.data( elem, deferDataKey, undefined, true );
	if ( defer &&
		( src === "queue" || !jQuery.data( elem, queueDataKey, undefined, true ) ) &&
		( src === "mark" || !jQuery.data( elem, markDataKey, undefined, true ) ) ) {
		// Give room for hard-coded callbacks to fire first
		// and eventually mark/queue something else on the element
		setTimeout( function() {
			if ( !jQuery.data( elem, queueDataKey, undefined, true ) &&
				!jQuery.data( elem, markDataKey, undefined, true ) ) {
				jQuery.removeData( elem, deferDataKey, true );
				defer.resolve();
			}
		}, 0 );
	}
}

jQuery.extend({

	_mark: function( elem, type ) {
		if ( elem ) {
			type = (type || "fx") + "mark";
			jQuery.data( elem, type, (jQuery.data(elem,type,undefined,true) || 0) + 1, true );
		}
	},

	_unmark: function( force, elem, type ) {
		if ( force !== true ) {
			type = elem;
			elem = force;
			force = false;
		}
		if ( elem ) {
			type = type || "fx";
			var key = type + "mark",
				count = force ? 0 : ( (jQuery.data( elem, key, undefined, true) || 1 ) - 1 );
			if ( count ) {
				jQuery.data( elem, key, count, true );
			} else {
				jQuery.removeData( elem, key, true );
				handleQueueMarkDefer( elem, type, "mark" );
			}
		}
	},

	queue: function( elem, type, data ) {
		if ( elem ) {
			type = (type || "fx") + "queue";
			var q = jQuery.data( elem, type, undefined, true );
			// Speed up dequeue by getting out quickly if this is just a lookup
			if ( data ) {
				if ( !q || jQuery.isArray(data) ) {
					q = jQuery.data( elem, type, jQuery.makeArray(data), true );
				} else {
					q.push( data );
				}
			}
			return q || [];
		}
	},

	dequeue: function( elem, type ) {
		type = type || "fx";

		var queue = jQuery.queue( elem, type ),
			fn = queue.shift(),
			defer;

		// If the fx queue is dequeued, always remove the progress sentinel
		if ( fn === "inprogress" ) {
			fn = queue.shift();
		}

		if ( fn ) {
			// Add a progress sentinel to prevent the fx queue from being
			// automatically dequeued
			if ( type === "fx" ) {
				queue.unshift("inprogress");
			}

			fn.call(elem, function() {
				jQuery.dequeue(elem, type);
			});
		}

		if ( !queue.length ) {
			jQuery.removeData( elem, type + "queue", true );
			handleQueueMarkDefer( elem, type, "queue" );
		}
	}
});

jQuery.fn.extend({
	queue: function( type, data ) {
		if ( typeof type !== "string" ) {
			data = type;
			type = "fx";
		}

		if ( data === undefined ) {
			return jQuery.queue( this[0], type );
		}
		return this.each(function() {
			var queue = jQuery.queue( this, type, data );

			if ( type === "fx" && queue[0] !== "inprogress" ) {
				jQuery.dequeue( this, type );
			}
		});
	},
	dequeue: function( type ) {
		return this.each(function() {
			jQuery.dequeue( this, type );
		});
	},
	// Based off of the plugin by Clint Helfers, with permission.
	// http://blindsignals.com/index.php/2009/07/jquery-delay/
	delay: function( time, type ) {
		time = jQuery.fx ? jQuery.fx.speeds[time] || time : time;
		type = type || "fx";

		return this.queue( type, function() {
			var elem = this;
			setTimeout(function() {
				jQuery.dequeue( elem, type );
			}, time );
		});
	},
	clearQueue: function( type ) {
		return this.queue( type || "fx", [] );
	},
	// Get a promise resolved when queues of a certain type
	// are emptied (fx is the type by default)
	promise: function( type, object ) {
		if ( typeof type !== "string" ) {
			object = type;
			type = undefined;
		}
		type = type || "fx";
		var defer = jQuery.Deferred(),
			elements = this,
			i = elements.length,
			count = 1,
			deferDataKey = type + "defer",
			queueDataKey = type + "queue",
			markDataKey = type + "mark",
			tmp;
		function resolve() {
			if ( !( --count ) ) {
				defer.resolveWith( elements, [ elements ] );
			}
		}
		while( i-- ) {
			if (( tmp = jQuery.data( elements[ i ], deferDataKey, undefined, true ) ||
					( jQuery.data( elements[ i ], queueDataKey, undefined, true ) ||
						jQuery.data( elements[ i ], markDataKey, undefined, true ) ) &&
					jQuery.data( elements[ i ], deferDataKey, jQuery._Deferred(), true ) )) {
				count++;
				tmp.done( resolve );
			}
		}
		resolve();
		return defer.promise();
	}
});




var rclass = /[\n\t\r]/g,
	rspace = /\s+/,
	rreturn = /\r/g,
	rtype = /^(?:button|input)$/i,
	rfocusable = /^(?:button|input|object|select|textarea)$/i,
	rclickable = /^a(?:rea)?$/i,
	rboolean = /^(?:autofocus|autoplay|async|checked|controls|defer|disabled|hidden|loop|multiple|open|readonly|required|scoped|selected)$/i,
	nodeHook, boolHook;

jQuery.fn.extend({
	attr: function( name, value ) {
		return jQuery.access( this, name, value, true, jQuery.attr );
	},

	removeAttr: function( name ) {
		return this.each(function() {
			jQuery.removeAttr( this, name );
		});
	},
	
	prop: function( name, value ) {
		return jQuery.access( this, name, value, true, jQuery.prop );
	},
	
	removeProp: function( name ) {
		name = jQuery.propFix[ name ] || name;
		return this.each(function() {
			// try/catch handles cases where IE balks (such as removing a property on window)
			try {
				this[ name ] = undefined;
				delete this[ name ];
			} catch( e ) {}
		});
	},

	addClass: function( value ) {
		var classNames, i, l, elem,
			setClass, c, cl;

		if ( jQuery.isFunction( value ) ) {
			return this.each(function( j ) {
				jQuery( this ).addClass( value.call(this, j, this.className) );
			});
		}

		if ( value && typeof value === "string" ) {
			classNames = value.split( rspace );

			for ( i = 0, l = this.length; i < l; i++ ) {
				elem = this[ i ];

				if ( elem.nodeType === 1 ) {
					if ( !elem.className && classNames.length === 1 ) {
						elem.className = value;

					} else {
						setClass = " " + elem.className + " ";

						for ( c = 0, cl = classNames.length; c < cl; c++ ) {
							if ( !~setClass.indexOf( " " + classNames[ c ] + " " ) ) {
								setClass += classNames[ c ] + " ";
							}
						}
						elem.className = jQuery.trim( setClass );
					}
				}
			}
		}

		return this;
	},

	removeClass: function( value ) {
		var classNames, i, l, elem, className, c, cl;

		if ( jQuery.isFunction( value ) ) {
			return this.each(function( j ) {
				jQuery( this ).removeClass( value.call(this, j, this.className) );
			});
		}

		if ( (value && typeof value === "string") || value === undefined ) {
			classNames = (value || "").split( rspace );

			for ( i = 0, l = this.length; i < l; i++ ) {
				elem = this[ i ];

				if ( elem.nodeType === 1 && elem.className ) {
					if ( value ) {
						className = (" " + elem.className + " ").replace( rclass, " " );
						for ( c = 0, cl = classNames.length; c < cl; c++ ) {
							className = className.replace(" " + classNames[ c ] + " ", " ");
						}
						elem.className = jQuery.trim( className );

					} else {
						elem.className = "";
					}
				}
			}
		}

		return this;
	},

	toggleClass: function( value, stateVal ) {
		var type = typeof value,
			isBool = typeof stateVal === "boolean";

		if ( jQuery.isFunction( value ) ) {
			return this.each(function( i ) {
				jQuery( this ).toggleClass( value.call(this, i, this.className, stateVal), stateVal );
			});
		}

		return this.each(function() {
			if ( type === "string" ) {
				// toggle individual class names
				var className,
					i = 0,
					self = jQuery( this ),
					state = stateVal,
					classNames = value.split( rspace );

				while ( (className = classNames[ i++ ]) ) {
					// check each className given, space seperated list
					state = isBool ? state : !self.hasClass( className );
					self[ state ? "addClass" : "removeClass" ]( className );
				}

			} else if ( type === "undefined" || type === "boolean" ) {
				if ( this.className ) {
					// store className if set
					jQuery._data( this, "__className__", this.className );
				}

				// toggle whole className
				this.className = this.className || value === false ? "" : jQuery._data( this, "__className__" ) || "";
			}
		});
	},

	hasClass: function( selector ) {
		var className = " " + selector + " ";
		for ( var i = 0, l = this.length; i < l; i++ ) {
			if ( this[i].nodeType === 1 && (" " + this[i].className + " ").replace(rclass, " ").indexOf( className ) > -1 ) {
				return true;
			}
		}

		return false;
	},

	val: function( value ) {
		var hooks, ret,
			elem = this[0];
		
		if ( !arguments.length ) {
			if ( elem ) {
				hooks = jQuery.valHooks[ elem.nodeName.toLowerCase() ] || jQuery.valHooks[ elem.type ];

				if ( hooks && "get" in hooks && (ret = hooks.get( elem, "value" )) !== undefined ) {
					return ret;
				}

				ret = elem.value;

				return typeof ret === "string" ? 
					// handle most common string cases
					ret.replace(rreturn, "") : 
					// handle cases where value is null/undef or number
					ret == null ? "" : ret;
			}

			return undefined;
		}

		var isFunction = jQuery.isFunction( value );

		return this.each(function( i ) {
			var self = jQuery(this), val;

			if ( this.nodeType !== 1 ) {
				return;
			}

			if ( isFunction ) {
				val = value.call( this, i, self.val() );
			} else {
				val = value;
			}

			// Treat null/undefined as ""; convert numbers to string
			if ( val == null ) {
				val = "";
			} else if ( typeof val === "number" ) {
				val += "";
			} else if ( jQuery.isArray( val ) ) {
				val = jQuery.map(val, function ( value ) {
					return value == null ? "" : value + "";
				});
			}

			hooks = jQuery.valHooks[ this.nodeName.toLowerCase() ] || jQuery.valHooks[ this.type ];

			// If set returns undefined, fall back to normal setting
			if ( !hooks || !("set" in hooks) || hooks.set( this, val, "value" ) === undefined ) {
				this.value = val;
			}
		});
	}
});

jQuery.extend({
	valHooks: {
		option: {
			get: function( elem ) {
				// attributes.value is undefined in Blackberry 4.7 but
				// uses .value. See #6932
				var val = elem.attributes.value;
				return !val || val.specified ? elem.value : elem.text;
			}
		},
		select: {
			get: function( elem ) {
				var value,
					index = elem.selectedIndex,
					values = [],
					options = elem.options,
					one = elem.type === "select-one";

				// Nothing was selected
				if ( index < 0 ) {
					return null;
				}

				// Loop through all the selected options
				for ( var i = one ? index : 0, max = one ? index + 1 : options.length; i < max; i++ ) {
					var option = options[ i ];

					// Don't return options that are disabled or in a disabled optgroup
					if ( option.selected && (jQuery.support.optDisabled ? !option.disabled : option.getAttribute("disabled") === null) &&
							(!option.parentNode.disabled || !jQuery.nodeName( option.parentNode, "optgroup" )) ) {

						// Get the specific value for the option
						value = jQuery( option ).val();

						// We don't need an array for one selects
						if ( one ) {
							return value;
						}

						// Multi-Selects return an array
						values.push( value );
					}
				}

				// Fixes Bug #2551 -- select.val() broken in IE after form.reset()
				if ( one && !values.length && options.length ) {
					return jQuery( options[ index ] ).val();
				}

				return values;
			},

			set: function( elem, value ) {
				var values = jQuery.makeArray( value );

				jQuery(elem).find("option").each(function() {
					this.selected = jQuery.inArray( jQuery(this).val(), values ) >= 0;
				});

				if ( !values.length ) {
					elem.selectedIndex = -1;
				}
				return values;
			}
		}
	},

	attrFn: {
		val: true,
		css: true,
		html: true,
		text: true,
		data: true,
		width: true,
		height: true,
		offset: true
	},
	
	attrFix: {
		// Always normalize to ensure hook usage
		tabindex: "tabIndex"
	},
	
	attr: function( elem, name, value, pass ) {
		var nType = elem.nodeType;
		
		// don't get/set attributes on text, comment and attribute nodes
		if ( !elem || nType === 3 || nType === 8 || nType === 2 ) {
			return undefined;
		}

		if ( pass && name in jQuery.attrFn ) {
			return jQuery( elem )[ name ]( value );
		}

		// Fallback to prop when attributes are not supported
		if ( !("getAttribute" in elem) ) {
			return jQuery.prop( elem, name, value );
		}

		var ret, hooks,
			notxml = nType !== 1 || !jQuery.isXMLDoc( elem );

		// Normalize the name if needed
		if ( notxml ) {
			name = jQuery.attrFix[ name ] || name;

			hooks = jQuery.attrHooks[ name ];

			if ( !hooks ) {
				// Use boolHook for boolean attributes
				if ( rboolean.test( name ) ) {
					hooks = boolHook;

				// Use nodeHook if available( IE6/7 )
				} else if ( nodeHook ) {
					hooks = nodeHook;
				}
			}
		}

		if ( value !== undefined ) {

			if ( value === null ) {
				jQuery.removeAttr( elem, name );
				return undefined;

			} else if ( hooks && "set" in hooks && notxml && (ret = hooks.set( elem, value, name )) !== undefined ) {
				return ret;

			} else {
				elem.setAttribute( name, "" + value );
				return value;
			}

		} else if ( hooks && "get" in hooks && notxml && (ret = hooks.get( elem, name )) !== null ) {
			return ret;

		} else {

			ret = elem.getAttribute( name );

			// Non-existent attributes return null, we normalize to undefined
			return ret === null ?
				undefined :
				ret;
		}
	},

	removeAttr: function( elem, name ) {
		var propName;
		if ( elem.nodeType === 1 ) {
			name = jQuery.attrFix[ name ] || name;

			jQuery.attr( elem, name, "" );
			elem.removeAttribute( name );

			// Set corresponding property to false for boolean attributes
			if ( rboolean.test( name ) && (propName = jQuery.propFix[ name ] || name) in elem ) {
				elem[ propName ] = false;
			}
		}
	},

	attrHooks: {
		type: {
			set: function( elem, value ) {
				// We can't allow the type property to be changed (since it causes problems in IE)
				if ( rtype.test( elem.nodeName ) && elem.parentNode ) {
					jQuery.error( "type property can't be changed" );
				} else if ( !jQuery.support.radioValue && value === "radio" && jQuery.nodeName(elem, "input") ) {
					// Setting the type on a radio button after the value resets the value in IE6-9
					// Reset value to it's default in case type is set after value
					// This is for element creation
					var val = elem.value;
					elem.setAttribute( "type", value );
					if ( val ) {
						elem.value = val;
					}
					return value;
				}
			}
		},
		// Use the value property for back compat
		// Use the nodeHook for button elements in IE6/7 (#1954)
		value: {
			get: function( elem, name ) {
				if ( nodeHook && jQuery.nodeName( elem, "button" ) ) {
					return nodeHook.get( elem, name );
				}
				return name in elem ?
					elem.value :
					null;
			},
			set: function( elem, value, name ) {
				if ( nodeHook && jQuery.nodeName( elem, "button" ) ) {
					return nodeHook.set( elem, value, name );
				}
				// Does not return so that setAttribute is also used
				elem.value = value;
			}
		}
	},

	propFix: {
		tabindex: "tabIndex",
		readonly: "readOnly",
		"for": "htmlFor",
		"class": "className",
		maxlength: "maxLength",
		cellspacing: "cellSpacing",
		cellpadding: "cellPadding",
		rowspan: "rowSpan",
		colspan: "colSpan",
		usemap: "useMap",
		frameborder: "frameBorder",
		contenteditable: "contentEditable"
	},
	
	prop: function( elem, name, value ) {
		var nType = elem.nodeType;

		// don't get/set properties on text, comment and attribute nodes
		if ( !elem || nType === 3 || nType === 8 || nType === 2 ) {
			return undefined;
		}

		var ret, hooks,
			notxml = nType !== 1 || !jQuery.isXMLDoc( elem );

		if ( notxml ) {
			// Fix name and attach hooks
			name = jQuery.propFix[ name ] || name;
			hooks = jQuery.propHooks[ name ];
		}

		if ( value !== undefined ) {
			if ( hooks && "set" in hooks && (ret = hooks.set( elem, value, name )) !== undefined ) {
				return ret;

			} else {
				return (elem[ name ] = value);
			}

		} else {
			if ( hooks && "get" in hooks && (ret = hooks.get( elem, name )) !== null ) {
				return ret;

			} else {
				return elem[ name ];
			}
		}
	},
	
	propHooks: {
		tabIndex: {
			get: function( elem ) {
				// elem.tabIndex doesn't always return the correct value when it hasn't been explicitly set
				// http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
				var attributeNode = elem.getAttributeNode("tabindex");

				return attributeNode && attributeNode.specified ?
					parseInt( attributeNode.value, 10 ) :
					rfocusable.test( elem.nodeName ) || rclickable.test( elem.nodeName ) && elem.href ?
						0 :
						undefined;
			}
		}
	}
});

// Add the tabindex propHook to attrHooks for back-compat
jQuery.attrHooks.tabIndex = jQuery.propHooks.tabIndex;

// Hook for boolean attributes
boolHook = {
	get: function( elem, name ) {
		// Align boolean attributes with corresponding properties
		// Fall back to attribute presence where some booleans are not supported
		var attrNode;
		return jQuery.prop( elem, name ) === true || ( attrNode = elem.getAttributeNode( name ) ) && attrNode.nodeValue !== false ?
			name.toLowerCase() :
			undefined;
	},
	set: function( elem, value, name ) {
		var propName;
		if ( value === false ) {
			// Remove boolean attributes when set to false
			jQuery.removeAttr( elem, name );
		} else {
			// value is true since we know at this point it's type boolean and not false
			// Set boolean attributes to the same name and set the DOM property
			propName = jQuery.propFix[ name ] || name;
			if ( propName in elem ) {
				// Only set the IDL specifically if it already exists on the element
				elem[ propName ] = true;
			}

			elem.setAttribute( name, name.toLowerCase() );
		}
		return name;
	}
};

// IE6/7 do not support getting/setting some attributes with get/setAttribute
if ( !jQuery.support.getSetAttribute ) {
	
	// Use this for any attribute in IE6/7
	// This fixes almost every IE6/7 issue
	nodeHook = jQuery.valHooks.button = {
		get: function( elem, name ) {
			var ret;
			ret = elem.getAttributeNode( name );
			// Return undefined if nodeValue is empty string
			return ret && ret.nodeValue !== "" ?
				ret.nodeValue :
				undefined;
		},
		set: function( elem, value, name ) {
			// Set the existing or create a new attribute node
			var ret = elem.getAttributeNode( name );
			if ( !ret ) {
				ret = document.createAttribute( name );
				elem.setAttributeNode( ret );
			}
			return (ret.nodeValue = value + "");
		}
	};

	// Set width and height to auto instead of 0 on empty string( Bug #8150 )
	// This is for removals
	jQuery.each([ "width", "height" ], function( i, name ) {
		jQuery.attrHooks[ name ] = jQuery.extend( jQuery.attrHooks[ name ], {
			set: function( elem, value ) {
				if ( value === "" ) {
					elem.setAttribute( name, "auto" );
					return value;
				}
			}
		});
	});
}


// Some attributes require a special call on IE
if ( !jQuery.support.hrefNormalized ) {
	jQuery.each([ "href", "src", "width", "height" ], function( i, name ) {
		jQuery.attrHooks[ name ] = jQuery.extend( jQuery.attrHooks[ name ], {
			get: function( elem ) {
				var ret = elem.getAttribute( name, 2 );
				return ret === null ? undefined : ret;
			}
		});
	});
}

if ( !jQuery.support.style ) {
	jQuery.attrHooks.style = {
		get: function( elem ) {
			// Return undefined in the case of empty string
			// Normalize to lowercase since IE uppercases css property names
			return elem.style.cssText.toLowerCase() || undefined;
		},
		set: function( elem, value ) {
			return (elem.style.cssText = "" + value);
		}
	};
}

// Safari mis-reports the default selected property of an option
// Accessing the parent's selectedIndex property fixes it
if ( !jQuery.support.optSelected ) {
	jQuery.propHooks.selected = jQuery.extend( jQuery.propHooks.selected, {
		get: function( elem ) {
			var parent = elem.parentNode;

			if ( parent ) {
				parent.selectedIndex;

				// Make sure that it also works with optgroups, see #5701
				if ( parent.parentNode ) {
					parent.parentNode.selectedIndex;
				}
			}
			return null;
		}
	});
}

// Radios and checkboxes getter/setter
if ( !jQuery.support.checkOn ) {
	jQuery.each([ "radio", "checkbox" ], function() {
		jQuery.valHooks[ this ] = {
			get: function( elem ) {
				// Handle the case where in Webkit "" is returned instead of "on" if a value isn't specified
				return elem.getAttribute("value") === null ? "on" : elem.value;
			}
		};
	});
}
jQuery.each([ "radio", "checkbox" ], function() {
	jQuery.valHooks[ this ] = jQuery.extend( jQuery.valHooks[ this ], {
		set: function( elem, value ) {
			if ( jQuery.isArray( value ) ) {
				return (elem.checked = jQuery.inArray( jQuery(elem).val(), value ) >= 0);
			}
		}
	});
});




var rnamespaces = /\.(.*)$/,
	rformElems = /^(?:textarea|input|select)$/i,
	rperiod = /\./g,
	rspaces = / /g,
	rescape = /[^\w\s.|`]/g,
	fcleanup = function( nm ) {
		return nm.replace(rescape, "\\$&");
	};

/*
 * A number of helper functions used for managing events.
 * Many of the ideas behind this code originated from
 * Dean Edwards' addEvent library.
 */
jQuery.event = {

	// Bind an event to an element
	// Original by Dean Edwards
	add: function( elem, types, handler, data ) {
		if ( elem.nodeType === 3 || elem.nodeType === 8 ) {
			return;
		}

		if ( handler === false ) {
			handler = returnFalse;
		} else if ( !handler ) {
			// Fixes bug #7229. Fix recommended by jdalton
			return;
		}

		var handleObjIn, handleObj;

		if ( handler.handler ) {
			handleObjIn = handler;
			handler = handleObjIn.handler;
		}

		// Make sure that the function being executed has a unique ID
		if ( !handler.guid ) {
			handler.guid = jQuery.guid++;
		}

		// Init the element's event structure
		var elemData = jQuery._data( elem );

		// If no elemData is found then we must be trying to bind to one of the
		// banned noData elements
		if ( !elemData ) {
			return;
		}

		var events = elemData.events,
			eventHandle = elemData.handle;

		if ( !events ) {
			elemData.events = events = {};
		}

		if ( !eventHandle ) {
			elemData.handle = eventHandle = function( e ) {
				// Discard the second event of a jQuery.event.trigger() and
				// when an event is called after a page has unloaded
				return typeof jQuery !== "undefined" && (!e || jQuery.event.triggered !== e.type) ?
					jQuery.event.handle.apply( eventHandle.elem, arguments ) :
					undefined;
			};
		}

		// Add elem as a property of the handle function
		// This is to prevent a memory leak with non-native events in IE.
		eventHandle.elem = elem;

		// Handle multiple events separated by a space
		// jQuery(...).bind("mouseover mouseout", fn);
		types = types.split(" ");

		var type, i = 0, namespaces;

		while ( (type = types[ i++ ]) ) {
			handleObj = handleObjIn ?
				jQuery.extend({}, handleObjIn) :
				{ handler: handler, data: data };

			// Namespaced event handlers
			if ( type.indexOf(".") > -1 ) {
				namespaces = type.split(".");
				type = namespaces.shift();
				handleObj.namespace = namespaces.slice(0).sort().join(".");

			} else {
				namespaces = [];
				handleObj.namespace = "";
			}

			handleObj.type = type;
			if ( !handleObj.guid ) {
				handleObj.guid = handler.guid;
			}

			// Get the current list of functions bound to this event
			var handlers = events[ type ],
				special = jQuery.event.special[ type ] || {};

			// Init the event handler queue
			if ( !handlers ) {
				handlers = events[ type ] = [];

				// Check for a special event handler
				// Only use addEventListener/attachEvent if the special
				// events handler returns false
				if ( !special.setup || special.setup.call( elem, data, namespaces, eventHandle ) === false ) {
					// Bind the global event handler to the element
					if ( elem.addEventListener ) {
						elem.addEventListener( type, eventHandle, false );

					} else if ( elem.attachEvent ) {
						elem.attachEvent( "on" + type, eventHandle );
					}
				}
			}

			if ( special.add ) {
				special.add.call( elem, handleObj );

				if ( !handleObj.handler.guid ) {
					handleObj.handler.guid = handler.guid;
				}
			}

			// Add the function to the element's handler list
			handlers.push( handleObj );

			// Keep track of which events have been used, for event optimization
			jQuery.event.global[ type ] = true;
		}

		// Nullify elem to prevent memory leaks in IE
		elem = null;
	},

	global: {},

	// Detach an event or set of events from an element
	remove: function( elem, types, handler, pos ) {
		// don't do events on text and comment nodes
		if ( elem.nodeType === 3 || elem.nodeType === 8 ) {
			return;
		}

		if ( handler === false ) {
			handler = returnFalse;
		}

		var ret, type, fn, j, i = 0, all, namespaces, namespace, special, eventType, handleObj, origType,
			elemData = jQuery.hasData( elem ) && jQuery._data( elem ),
			events = elemData && elemData.events;

		if ( !elemData || !events ) {
			return;
		}

		// types is actually an event object here
		if ( types && types.type ) {
			handler = types.handler;
			types = types.type;
		}

		// Unbind all events for the element
		if ( !types || typeof types === "string" && types.charAt(0) === "." ) {
			types = types || "";

			for ( type in events ) {
				jQuery.event.remove( elem, type + types );
			}

			return;
		}

		// Handle multiple events separated by a space
		// jQuery(...).unbind("mouseover mouseout", fn);
		types = types.split(" ");

		while ( (type = types[ i++ ]) ) {
			origType = type;
			handleObj = null;
			all = type.indexOf(".") < 0;
			namespaces = [];

			if ( !all ) {
				// Namespaced event handlers
				namespaces = type.split(".");
				type = namespaces.shift();

				namespace = new RegExp("(^|\\.)" +
					jQuery.map( namespaces.slice(0).sort(), fcleanup ).join("\\.(?:.*\\.)?") + "(\\.|$)");
			}

			eventType = events[ type ];

			if ( !eventType ) {
				continue;
			}

			if ( !handler ) {
				for ( j = 0; j < eventType.length; j++ ) {
					handleObj = eventType[ j ];

					if ( all || namespace.test( handleObj.namespace ) ) {
						jQuery.event.remove( elem, origType, handleObj.handler, j );
						eventType.splice( j--, 1 );
					}
				}

				continue;
			}

			special = jQuery.event.special[ type ] || {};

			for ( j = pos || 0; j < eventType.length; j++ ) {
				handleObj = eventType[ j ];

				if ( handler.guid === handleObj.guid ) {
					// remove the given handler for the given type
					if ( all || namespace.test( handleObj.namespace ) ) {
						if ( pos == null ) {
							eventType.splice( j--, 1 );
						}

						if ( special.remove ) {
							special.remove.call( elem, handleObj );
						}
					}

					if ( pos != null ) {
						break;
					}
				}
			}

			// remove generic event handler if no more handlers exist
			if ( eventType.length === 0 || pos != null && eventType.length === 1 ) {
				if ( !special.teardown || special.teardown.call( elem, namespaces ) === false ) {
					jQuery.removeEvent( elem, type, elemData.handle );
				}

				ret = null;
				delete events[ type ];
			}
		}

		// Remove the expando if it's no longer used
		if ( jQuery.isEmptyObject( events ) ) {
			var handle = elemData.handle;
			if ( handle ) {
				handle.elem = null;
			}

			delete elemData.events;
			delete elemData.handle;

			if ( jQuery.isEmptyObject( elemData ) ) {
				jQuery.removeData( elem, undefined, true );
			}
		}
	},
	
	// Events that are safe to short-circuit if no handlers are attached.
	// Native DOM events should not be added, they may have inline handlers.
	customEvent: {
		"getData": true,
		"setData": true,
		"changeData": true
	},

	trigger: function( event, data, elem, onlyHandlers ) {
		// Event object or event type
		var type = event.type || event,
			namespaces = [],
			exclusive;

		if ( type.indexOf("!") >= 0 ) {
			// Exclusive events trigger only for the exact event (no namespaces)
			type = type.slice(0, -1);
			exclusive = true;
		}

		if ( type.indexOf(".") >= 0 ) {
			// Namespaced trigger; create a regexp to match event type in handle()
			namespaces = type.split(".");
			type = namespaces.shift();
			namespaces.sort();
		}

		if ( (!elem || jQuery.event.customEvent[ type ]) && !jQuery.event.global[ type ] ) {
			// No jQuery handlers for this event type, and it can't have inline handlers
			return;
		}

		// Caller can pass in an Event, Object, or just an event type string
		event = typeof event === "object" ?
			// jQuery.Event object
			event[ jQuery.expando ] ? event :
			// Object literal
			new jQuery.Event( type, event ) :
			// Just the event type (string)
			new jQuery.Event( type );

		event.type = type;
		event.exclusive = exclusive;
		event.namespace = namespaces.join(".");
		event.namespace_re = new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.)?") + "(\\.|$)");
		
		// triggerHandler() and global events don't bubble or run the default action
		if ( onlyHandlers || !elem ) {
			event.preventDefault();
			event.stopPropagation();
		}

		// Handle a global trigger
		if ( !elem ) {
			// TODO: Stop taunting the data cache; remove global events and always attach to document
			jQuery.each( jQuery.cache, function() {
				// internalKey variable is just used to make it easier to find
				// and potentially change this stuff later; currently it just
				// points to jQuery.expando
				var internalKey = jQuery.expando,
					internalCache = this[ internalKey ];
				if ( internalCache && internalCache.events && internalCache.events[ type ] ) {
					jQuery.event.trigger( event, data, internalCache.handle.elem );
				}
			});
			return;
		}

		// Don't do events on text and comment nodes
		if ( elem.nodeType === 3 || elem.nodeType === 8 ) {
			return;
		}

		// Clean up the event in case it is being reused
		event.result = undefined;
		event.target = elem;

		// Clone any incoming data and prepend the event, creating the handler arg list
		data = data != null ? jQuery.makeArray( data ) : [];
		data.unshift( event );

		var cur = elem,
			// IE doesn't like method names with a colon (#3533, #8272)
			ontype = type.indexOf(":") < 0 ? "on" + type : "";

		// Fire event on the current element, then bubble up the DOM tree
		do {
			var handle = jQuery._data( cur, "handle" );

			event.currentTarget = cur;
			if ( handle ) {
				handle.apply( cur, data );
			}

			// Trigger an inline bound script
			if ( ontype && jQuery.acceptData( cur ) && cur[ ontype ] && cur[ ontype ].apply( cur, data ) === false ) {
				event.result = false;
				event.preventDefault();
			}

			// Bubble up to document, then to window
			cur = cur.parentNode || cur.ownerDocument || cur === event.target.ownerDocument && window;
		} while ( cur && !event.isPropagationStopped() );

		// If nobody prevented the default action, do it now
		if ( !event.isDefaultPrevented() ) {
			var old,
				special = jQuery.event.special[ type ] || {};

			if ( (!special._default || special._default.call( elem.ownerDocument, event ) === false) &&
				!(type === "click" && jQuery.nodeName( elem, "a" )) && jQuery.acceptData( elem ) ) {

				// Call a native DOM method on the target with the same name name as the event.
				// Can't use an .isFunction)() check here because IE6/7 fails that test.
				// IE<9 dies on focus to hidden element (#1486), may want to revisit a try/catch.
				try {
					if ( ontype && elem[ type ] ) {
						// Don't re-trigger an onFOO event when we call its FOO() method
						old = elem[ ontype ];

						if ( old ) {
							elem[ ontype ] = null;
						}

						jQuery.event.triggered = type;
						elem[ type ]();
					}
				} catch ( ieError ) {}

				if ( old ) {
					elem[ ontype ] = old;
				}

				jQuery.event.triggered = undefined;
			}
		}
		
		return event.result;
	},

	handle: function( event ) {
		event = jQuery.event.fix( event || window.event );
		// Snapshot the handlers list since a called handler may add/remove events.
		var handlers = ((jQuery._data( this, "events" ) || {})[ event.type ] || []).slice(0),
			run_all = !event.exclusive && !event.namespace,
			args = Array.prototype.slice.call( arguments, 0 );

		// Use the fix-ed Event rather than the (read-only) native event
		args[0] = event;
		event.currentTarget = this;

		for ( var j = 0, l = handlers.length; j < l; j++ ) {
			var handleObj = handlers[ j ];

			// Triggered event must 1) be non-exclusive and have no namespace, or
			// 2) have namespace(s) a subset or equal to those in the bound event.
			if ( run_all || event.namespace_re.test( handleObj.namespace ) ) {
				// Pass in a reference to the handler function itself
				// So that we can later remove it
				event.handler = handleObj.handler;
				event.data = handleObj.data;
				event.handleObj = handleObj;

				var ret = handleObj.handler.apply( this, args );

				if ( ret !== undefined ) {
					event.result = ret;
					if ( ret === false ) {
						event.preventDefault();
						event.stopPropagation();
					}
				}

				if ( event.isImmediatePropagationStopped() ) {
					break;
				}
			}
		}
		return event.result;
	},

	props: "altKey attrChange attrName bubbles button cancelable charCode clientX clientY ctrlKey currentTarget data detail eventPhase fromElement handler keyCode layerX layerY metaKey newValue offsetX offsetY pageX pageY prevValue relatedNode relatedTarget screenX screenY shiftKey srcElement target toElement view wheelDelta which".split(" "),

	fix: function( event ) {
		if ( event[ jQuery.expando ] ) {
			return event;
		}

		// store a copy of the original event object
		// and "clone" to set read-only properties
		var originalEvent = event;
		event = jQuery.Event( originalEvent );

		for ( var i = this.props.length, prop; i; ) {
			prop = this.props[ --i ];
			event[ prop ] = originalEvent[ prop ];
		}

		// Fix target property, if necessary
		if ( !event.target ) {
			// Fixes #1925 where srcElement might not be defined either
			event.target = event.srcElement || document;
		}

		// check if target is a textnode (safari)
		if ( event.target.nodeType === 3 ) {
			event.target = event.target.parentNode;
		}

		// Add relatedTarget, if necessary
		if ( !event.relatedTarget && event.fromElement ) {
			event.relatedTarget = event.fromElement === event.target ? event.toElement : event.fromElement;
		}

		// Calculate pageX/Y if missing and clientX/Y available
		if ( event.pageX == null && event.clientX != null ) {
			var eventDocument = event.target.ownerDocument || document,
				doc = eventDocument.documentElement,
				body = eventDocument.body;

			event.pageX = event.clientX + (doc && doc.scrollLeft || body && body.scrollLeft || 0) - (doc && doc.clientLeft || body && body.clientLeft || 0);
			event.pageY = event.clientY + (doc && doc.scrollTop  || body && body.scrollTop  || 0) - (doc && doc.clientTop  || body && body.clientTop  || 0);
		}

		// Add which for key events
		if ( event.which == null && (event.charCode != null || event.keyCode != null) ) {
			event.which = event.charCode != null ? event.charCode : event.keyCode;
		}

		// Add metaKey to non-Mac browsers (use ctrl for PC's and Meta for Macs)
		if ( !event.metaKey && event.ctrlKey ) {
			event.metaKey = event.ctrlKey;
		}

		// Add which for click: 1 === left; 2 === middle; 3 === right
		// Note: button is not normalized, so don't use it
		if ( !event.which && event.button !== undefined ) {
			event.which = (event.button & 1 ? 1 : ( event.button & 2 ? 3 : ( event.button & 4 ? 2 : 0 ) ));
		}

		return event;
	},

	// Deprecated, use jQuery.guid instead
	guid: 1E8,

	// Deprecated, use jQuery.proxy instead
	proxy: jQuery.proxy,

	special: {
		ready: {
			// Make sure the ready event is setup
			setup: jQuery.bindReady,
			teardown: jQuery.noop
		},

		live: {
			add: function( handleObj ) {
				jQuery.event.add( this,
					liveConvert( handleObj.origType, handleObj.selector ),
					jQuery.extend({}, handleObj, {handler: liveHandler, guid: handleObj.handler.guid}) );
			},

			remove: function( handleObj ) {
				jQuery.event.remove( this, liveConvert( handleObj.origType, handleObj.selector ), handleObj );
			}
		},

		beforeunload: {
			setup: function( data, namespaces, eventHandle ) {
				// We only want to do this special case on windows
				if ( jQuery.isWindow( this ) ) {
					this.onbeforeunload = eventHandle;
				}
			},

			teardown: function( namespaces, eventHandle ) {
				if ( this.onbeforeunload === eventHandle ) {
					this.onbeforeunload = null;
				}
			}
		}
	}
};

jQuery.removeEvent = document.removeEventListener ?
	function( elem, type, handle ) {
		if ( elem.removeEventListener ) {
			elem.removeEventListener( type, handle, false );
		}
	} :
	function( elem, type, handle ) {
		if ( elem.detachEvent ) {
			elem.detachEvent( "on" + type, handle );
		}
	};

jQuery.Event = function( src, props ) {
	// Allow instantiation without the 'new' keyword
	if ( !this.preventDefault ) {
		return new jQuery.Event( src, props );
	}

	// Event object
	if ( src && src.type ) {
		this.originalEvent = src;
		this.type = src.type;

		// Events bubbling up the document may have been marked as prevented
		// by a handler lower down the tree; reflect the correct value.
		this.isDefaultPrevented = (src.defaultPrevented || src.returnValue === false ||
			src.getPreventDefault && src.getPreventDefault()) ? returnTrue : returnFalse;

	// Event type
	} else {
		this.type = src;
	}

	// Put explicitly provided properties onto the event object
	if ( props ) {
		jQuery.extend( this, props );
	}

	// timeStamp is buggy for some events on Firefox(#3843)
	// So we won't rely on the native value
	this.timeStamp = jQuery.now();

	// Mark it as fixed
	this[ jQuery.expando ] = true;
};

function returnFalse() {
	return false;
}
function returnTrue() {
	return true;
}

// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
// http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
jQuery.Event.prototype = {
	preventDefault: function() {
		this.isDefaultPrevented = returnTrue;

		var e = this.originalEvent;
		if ( !e ) {
			return;
		}

		// if preventDefault exists run it on the original event
		if ( e.preventDefault ) {
			e.preventDefault();

		// otherwise set the returnValue property of the original event to false (IE)
		} else {
			e.returnValue = false;
		}
	},
	stopPropagation: function() {
		this.isPropagationStopped = returnTrue;

		var e = this.originalEvent;
		if ( !e ) {
			return;
		}
		// if stopPropagation exists run it on the original event
		if ( e.stopPropagation ) {
			e.stopPropagation();
		}
		// otherwise set the cancelBubble property of the original event to true (IE)
		e.cancelBubble = true;
	},
	stopImmediatePropagation: function() {
		this.isImmediatePropagationStopped = returnTrue;
		this.stopPropagation();
	},
	isDefaultPrevented: returnFalse,
	isPropagationStopped: returnFalse,
	isImmediatePropagationStopped: returnFalse
};

// Checks if an event happened on an element within another element
// Used in jQuery.event.special.mouseenter and mouseleave handlers
var withinElement = function( event ) {

	// Check if mouse(over|out) are still within the same parent element
	var related = event.relatedTarget,
		inside = false,
		eventType = event.type;

	event.type = event.data;

	if ( related !== this ) {

		if ( related ) {
			inside = jQuery.contains( this, related );
		}

		if ( !inside ) {

			jQuery.event.handle.apply( this, arguments );

			event.type = eventType;
		}
	}
},

// In case of event delegation, we only need to rename the event.type,
// liveHandler will take care of the rest.
delegate = function( event ) {
	event.type = event.data;
	jQuery.event.handle.apply( this, arguments );
};

// Create mouseenter and mouseleave events
jQuery.each({
	mouseenter: "mouseover",
	mouseleave: "mouseout"
}, function( orig, fix ) {
	jQuery.event.special[ orig ] = {
		setup: function( data ) {
			jQuery.event.add( this, fix, data && data.selector ? delegate : withinElement, orig );
		},
		teardown: function( data ) {
			jQuery.event.remove( this, fix, data && data.selector ? delegate : withinElement );
		}
	};
});

// submit delegation
if ( !jQuery.support.submitBubbles ) {

	jQuery.event.special.submit = {
		setup: function( data, namespaces ) {
			if ( !jQuery.nodeName( this, "form" ) ) {
				jQuery.event.add(this, "click.specialSubmit", function( e ) {
					// Avoid triggering error on non-existent type attribute in IE VML (#7071)
					var elem = e.target,
						type = jQuery.nodeName( elem, "input" ) || jQuery.nodeName( elem, "button" ) ? elem.type : "";

					if ( (type === "submit" || type === "image") && jQuery( elem ).closest("form").length ) {
						trigger( "submit", this, arguments );
					}
				});

				jQuery.event.add(this, "keypress.specialSubmit", function( e ) {
					var elem = e.target,
						type = jQuery.nodeName( elem, "input" ) || jQuery.nodeName( elem, "button" ) ? elem.type : "";

					if ( (type === "text" || type === "password") && jQuery( elem ).closest("form").length && e.keyCode === 13 ) {
						trigger( "submit", this, arguments );
					}
				});

			} else {
				return false;
			}
		},

		teardown: function( namespaces ) {
			jQuery.event.remove( this, ".specialSubmit" );
		}
	};

}

// change delegation, happens here so we have bind.
if ( !jQuery.support.changeBubbles ) {

	var changeFilters,

	getVal = function( elem ) {
		var type = jQuery.nodeName( elem, "input" ) ? elem.type : "",
			val = elem.value;

		if ( type === "radio" || type === "checkbox" ) {
			val = elem.checked;

		} else if ( type === "select-multiple" ) {
			val = elem.selectedIndex > -1 ?
				jQuery.map( elem.options, function( elem ) {
					return elem.selected;
				}).join("-") :
				"";

		} else if ( jQuery.nodeName( elem, "select" ) ) {
			val = elem.selectedIndex;
		}

		return val;
	},

	testChange = function testChange( e ) {
		var elem = e.target, data, val;

		if ( !rformElems.test( elem.nodeName ) || elem.readOnly ) {
			return;
		}

		data = jQuery._data( elem, "_change_data" );
		val = getVal(elem);

		// the current data will be also retrieved by beforeactivate
		if ( e.type !== "focusout" || elem.type !== "radio" ) {
			jQuery._data( elem, "_change_data", val );
		}

		if ( data === undefined || val === data ) {
			return;
		}

		if ( data != null || val ) {
			e.type = "change";
			e.liveFired = undefined;
			jQuery.event.trigger( e, arguments[1], elem );
		}
	};

	jQuery.event.special.change = {
		filters: {
			focusout: testChange,

			beforedeactivate: testChange,

			click: function( e ) {
				var elem = e.target, type = jQuery.nodeName( elem, "input" ) ? elem.type : "";

				if ( type === "radio" || type === "checkbox" || jQuery.nodeName( elem, "select" ) ) {
					testChange.call( this, e );
				}
			},

			// Change has to be called before submit
			// Keydown will be called before keypress, which is used in submit-event delegation
			keydown: function( e ) {
				var elem = e.target, type = jQuery.nodeName( elem, "input" ) ? elem.type : "";

				if ( (e.keyCode === 13 && !jQuery.nodeName( elem, "textarea" ) ) ||
					(e.keyCode === 32 && (type === "checkbox" || type === "radio")) ||
					type === "select-multiple" ) {
					testChange.call( this, e );
				}
			},

			// Beforeactivate happens also before the previous element is blurred
			// with this event you can't trigger a change event, but you can store
			// information
			beforeactivate: function( e ) {
				var elem = e.target;
				jQuery._data( elem, "_change_data", getVal(elem) );
			}
		},

		setup: function( data, namespaces ) {
			if ( this.type === "file" ) {
				return false;
			}

			for ( var type in changeFilters ) {
				jQuery.event.add( this, type + ".specialChange", changeFilters[type] );
			}

			return rformElems.test( this.nodeName );
		},

		teardown: function( namespaces ) {
			jQuery.event.remove( this, ".specialChange" );

			return rformElems.test( this.nodeName );
		}
	};

	changeFilters = jQuery.event.special.change.filters;

	// Handle when the input is .focus()'d
	changeFilters.focus = changeFilters.beforeactivate;
}

function trigger( type, elem, args ) {
	// Piggyback on a donor event to simulate a different one.
	// Fake originalEvent to avoid donor's stopPropagation, but if the
	// simulated event prevents default then we do the same on the donor.
	// Don't pass args or remember liveFired; they apply to the donor event.
	var event = jQuery.extend( {}, args[ 0 ] );
	event.type = type;
	event.originalEvent = {};
	event.liveFired = undefined;
	jQuery.event.handle.call( elem, event );
	if ( event.isDefaultPrevented() ) {
		args[ 0 ].preventDefault();
	}
}

// Create "bubbling" focus and blur events
if ( !jQuery.support.focusinBubbles ) {
	jQuery.each({ focus: "focusin", blur: "focusout" }, function( orig, fix ) {

		// Attach a single capturing handler while someone wants focusin/focusout
		var attaches = 0;

		jQuery.event.special[ fix ] = {
			setup: function() {
				if ( attaches++ === 0 ) {
					document.addEventListener( orig, handler, true );
				}
			},
			teardown: function() {
				if ( --attaches === 0 ) {
					document.removeEventListener( orig, handler, true );
				}
			}
		};

		function handler( donor ) {
			// Donor event is always a native one; fix it and switch its type.
			// Let focusin/out handler cancel the donor focus/blur event.
			var e = jQuery.event.fix( donor );
			e.type = fix;
			e.originalEvent = {};
			jQuery.event.trigger( e, null, e.target );
			if ( e.isDefaultPrevented() ) {
				donor.preventDefault();
			}
		}
	});
}

jQuery.each(["bind", "one"], function( i, name ) {
	jQuery.fn[ name ] = function( type, data, fn ) {
		var handler;

		// Handle object literals
		if ( typeof type === "object" ) {
			for ( var key in type ) {
				this[ name ](key, data, type[key], fn);
			}
			return this;
		}

		if ( arguments.length === 2 || data === false ) {
			fn = data;
			data = undefined;
		}

		if ( name === "one" ) {
			handler = function( event ) {
				jQuery( this ).unbind( event, handler );
				return fn.apply( this, arguments );
			};
			handler.guid = fn.guid || jQuery.guid++;
		} else {
			handler = fn;
		}

		if ( type === "unload" && name !== "one" ) {
			this.one( type, data, fn );

		} else {
			for ( var i = 0, l = this.length; i < l; i++ ) {
				jQuery.event.add( this[i], type, handler, data );
			}
		}

		return this;
	};
});

jQuery.fn.extend({
	unbind: function( type, fn ) {
		// Handle object literals
		if ( typeof type === "object" && !type.preventDefault ) {
			for ( var key in type ) {
				this.unbind(key, type[key]);
			}

		} else {
			for ( var i = 0, l = this.length; i < l; i++ ) {
				jQuery.event.remove( this[i], type, fn );
			}
		}

		return this;
	},

	delegate: function( selector, types, data, fn ) {
		return this.live( types, data, fn, selector );
	},

	undelegate: function( selector, types, fn ) {
		if ( arguments.length === 0 ) {
			return this.unbind( "live" );

		} else {
			return this.die( types, null, fn, selector );
		}
	},

	trigger: function( type, data ) {
		return this.each(function() {
			jQuery.event.trigger( type, data, this );
		});
	},

	triggerHandler: function( type, data ) {
		if ( this[0] ) {
			return jQuery.event.trigger( type, data, this[0], true );
		}
	},

	toggle: function( fn ) {
		// Save reference to arguments for access in closure
		var args = arguments,
			guid = fn.guid || jQuery.guid++,
			i = 0,
			toggler = function( event ) {
				// Figure out which function to execute
				var lastToggle = ( jQuery.data( this, "lastToggle" + fn.guid ) || 0 ) % i;
				jQuery.data( this, "lastToggle" + fn.guid, lastToggle + 1 );

				// Make sure that clicks stop
				event.preventDefault();

				// and execute the function
				return args[ lastToggle ].apply( this, arguments ) || false;
			};

		// link all the functions, so any of them can unbind this click handler
		toggler.guid = guid;
		while ( i < args.length ) {
			args[ i++ ].guid = guid;
		}

		return this.click( toggler );
	},

	hover: function( fnOver, fnOut ) {
		return this.mouseenter( fnOver ).mouseleave( fnOut || fnOver );
	}
});

var liveMap = {
	focus: "focusin",
	blur: "focusout",
	mouseenter: "mouseover",
	mouseleave: "mouseout"
};

jQuery.each(["live", "die"], function( i, name ) {
	jQuery.fn[ name ] = function( types, data, fn, origSelector /* Internal Use Only */ ) {
		var type, i = 0, match, namespaces, preType,
			selector = origSelector || this.selector,
			context = origSelector ? this : jQuery( this.context );

		if ( typeof types === "object" && !types.preventDefault ) {
			for ( var key in types ) {
				context[ name ]( key, data, types[key], selector );
			}

			return this;
		}

		if ( name === "die" && !types &&
					origSelector && origSelector.charAt(0) === "." ) {

			context.unbind( origSelector );

			return this;
		}

		if ( data === false || jQuery.isFunction( data ) ) {
			fn = data || returnFalse;
			data = undefined;
		}

		types = (types || "").split(" ");

		while ( (type = types[ i++ ]) != null ) {
			match = rnamespaces.exec( type );
			namespaces = "";

			if ( match )  {
				namespaces = match[0];
				type = type.replace( rnamespaces, "" );
			}

			if ( type === "hover" ) {
				types.push( "mouseenter" + namespaces, "mouseleave" + namespaces );
				continue;
			}

			preType = type;

			if ( liveMap[ type ] ) {
				types.push( liveMap[ type ] + namespaces );
				type = type + namespaces;

			} else {
				type = (liveMap[ type ] || type) + namespaces;
			}

			if ( name === "live" ) {
				// bind live handler
				for ( var j = 0, l = context.length; j < l; j++ ) {
					jQuery.event.add( context[j], "live." + liveConvert( type, selector ),
						{ data: data, selector: selector, handler: fn, origType: type, origHandler: fn, preType: preType } );
				}

			} else {
				// unbind live handler
				context.unbind( "live." + liveConvert( type, selector ), fn );
			}
		}

		return this;
	};
});

function liveHandler( event ) {
	var stop, maxLevel, related, match, handleObj, elem, j, i, l, data, close, namespace, ret,
		elems = [],
		selectors = [],
		events = jQuery._data( this, "events" );

	// Make sure we avoid non-left-click bubbling in Firefox (#3861) and disabled elements in IE (#6911)
	if ( event.liveFired === this || !events || !events.live || event.target.disabled || event.button && event.type === "click" ) {
		return;
	}

	if ( event.namespace ) {
		namespace = new RegExp("(^|\\.)" + event.namespace.split(".").join("\\.(?:.*\\.)?") + "(\\.|$)");
	}

	event.liveFired = this;

	var live = events.live.slice(0);

	for ( j = 0; j < live.length; j++ ) {
		handleObj = live[j];

		if ( handleObj.origType.replace( rnamespaces, "" ) === event.type ) {
			selectors.push( handleObj.selector );

		} else {
			live.splice( j--, 1 );
		}
	}

	match = jQuery( event.target ).closest( selectors, event.currentTarget );

	for ( i = 0, l = match.length; i < l; i++ ) {
		close = match[i];

		for ( j = 0; j < live.length; j++ ) {
			handleObj = live[j];

			if ( close.selector === handleObj.selector && (!namespace || namespace.test( handleObj.namespace )) && !close.elem.disabled ) {
				elem = close.elem;
				related = null;

				// Those two events require additional checking
				if ( handleObj.preType === "mouseenter" || handleObj.preType === "mouseleave" ) {
					event.type = handleObj.preType;
					related = jQuery( event.relatedTarget ).closest( handleObj.selector )[0];

					// Make sure not to accidentally match a child element with the same selector
					if ( related && jQuery.contains( elem, related ) ) {
						related = elem;
					}
				}

				if ( !related || related !== elem ) {
					elems.push({ elem: elem, handleObj: handleObj, level: close.level });
				}
			}
		}
	}

	for ( i = 0, l = elems.length; i < l; i++ ) {
		match = elems[i];

		if ( maxLevel && match.level > maxLevel ) {
			break;
		}

		event.currentTarget = match.elem;
		event.data = match.handleObj.data;
		event.handleObj = match.handleObj;

		ret = match.handleObj.origHandler.apply( match.elem, arguments );

		if ( ret === false || event.isPropagationStopped() ) {
			maxLevel = match.level;

			if ( ret === false ) {
				stop = false;
			}
			if ( event.isImmediatePropagationStopped() ) {
				break;
			}
		}
	}

	return stop;
}

function liveConvert( type, selector ) {
	return (type && type !== "*" ? type + "." : "") + selector.replace(rperiod, "`").replace(rspaces, "&");
}

jQuery.each( ("blur focus focusin focusout load resize scroll unload click dblclick " +
	"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " +
	"change select submit keydown keypress keyup error").split(" "), function( i, name ) {

	// Handle event binding
	jQuery.fn[ name ] = function( data, fn ) {
		if ( fn == null ) {
			fn = data;
			data = null;
		}

		return arguments.length > 0 ?
			this.bind( name, data, fn ) :
			this.trigger( name );
	};

	if ( jQuery.attrFn ) {
		jQuery.attrFn[ name ] = true;
	}
});



/*!
 * Sizzle CSS Selector Engine
 *  Copyright 2011, The Dojo Foundation
 *  Released under the MIT, BSD, and GPL Licenses.
 *  More information: http://sizzlejs.com/
 */
(function(){

var chunker = /((?:\((?:\([^()]+\)|[^()]+)+\)|\[(?:\[[^\[\]]*\]|['"][^'"]*['"]|[^\[\]'"]+)+\]|\\.|[^ >+~,(\[\\]+)+|[>+~])(\s*,\s*)?((?:.|\r|\n)*)/g,
	done = 0,
	toString = Object.prototype.toString,
	hasDuplicate = false,
	baseHasDuplicate = true,
	rBackslash = /\\/g,
	rNonWord = /\W/;

// Here we check if the JavaScript engine is using some sort of
// optimization where it does not always call our comparision
// function. If that is the case, discard the hasDuplicate value.
//   Thus far that includes Google Chrome.
[0, 0].sort(function() {
	baseHasDuplicate = false;
	return 0;
});

var Sizzle = function( selector, context, results, seed ) {
	results = results || [];
	context = context || document;

	var origContext = context;

	if ( context.nodeType !== 1 && context.nodeType !== 9 ) {
		return [];
	}
	
	if ( !selector || typeof selector !== "string" ) {
		return results;
	}

	var m, set, checkSet, extra, ret, cur, pop, i,
		prune = true,
		contextXML = Sizzle.isXML( context ),
		parts = [],
		soFar = selector;
	
	// Reset the position of the chunker regexp (start from head)
	do {
		chunker.exec( "" );
		m = chunker.exec( soFar );

		if ( m ) {
			soFar = m[3];
		
			parts.push( m[1] );
		
			if ( m[2] ) {
				extra = m[3];
				break;
			}
		}
	} while ( m );

	if ( parts.length > 1 && origPOS.exec( selector ) ) {

		if ( parts.length === 2 && Expr.relative[ parts[0] ] ) {
			set = posProcess( parts[0] + parts[1], context );

		} else {
			set = Expr.relative[ parts[0] ] ?
				[ context ] :
				Sizzle( parts.shift(), context );

			while ( parts.length ) {
				selector = parts.shift();

				if ( Expr.relative[ selector ] ) {
					selector += parts.shift();
				}
				
				set = posProcess( selector, set );
			}
		}

	} else {
		// Take a shortcut and set the context if the root selector is an ID
		// (but not if it'll be faster if the inner selector is an ID)
		if ( !seed && parts.length > 1 && context.nodeType === 9 && !contextXML &&
				Expr.match.ID.test(parts[0]) && !Expr.match.ID.test(parts[parts.length - 1]) ) {

			ret = Sizzle.find( parts.shift(), context, contextXML );
			context = ret.expr ?
				Sizzle.filter( ret.expr, ret.set )[0] :
				ret.set[0];
		}

		if ( context ) {
			ret = seed ?
				{ expr: parts.pop(), set: makeArray(seed) } :
				Sizzle.find( parts.pop(), parts.length === 1 && (parts[0] === "~" || parts[0] === "+") && context.parentNode ? context.parentNode : context, contextXML );

			set = ret.expr ?
				Sizzle.filter( ret.expr, ret.set ) :
				ret.set;

			if ( parts.length > 0 ) {
				checkSet = makeArray( set );

			} else {
				prune = false;
			}

			while ( parts.length ) {
				cur = parts.pop();
				pop = cur;

				if ( !Expr.relative[ cur ] ) {
					cur = "";
				} else {
					pop = parts.pop();
				}

				if ( pop == null ) {
					pop = context;
				}

				Expr.relative[ cur ]( checkSet, pop, contextXML );
			}

		} else {
			checkSet = parts = [];
		}
	}

	if ( !checkSet ) {
		checkSet = set;
	}

	if ( !checkSet ) {
		Sizzle.error( cur || selector );
	}

	if ( toString.call(checkSet) === "[object Array]" ) {
		if ( !prune ) {
			results.push.apply( results, checkSet );

		} else if ( context && context.nodeType === 1 ) {
			for ( i = 0; checkSet[i] != null; i++ ) {
				if ( checkSet[i] && (checkSet[i] === true || checkSet[i].nodeType === 1 && Sizzle.contains(context, checkSet[i])) ) {
					results.push( set[i] );
				}
			}

		} else {
			for ( i = 0; checkSet[i] != null; i++ ) {
				if ( checkSet[i] && checkSet[i].nodeType === 1 ) {
					results.push( set[i] );
				}
			}
		}

	} else {
		makeArray( checkSet, results );
	}

	if ( extra ) {
		Sizzle( extra, origContext, results, seed );
		Sizzle.uniqueSort( results );
	}

	return results;
};

Sizzle.uniqueSort = function( results ) {
	if ( sortOrder ) {
		hasDuplicate = baseHasDuplicate;
		results.sort( sortOrder );

		if ( hasDuplicate ) {
			for ( var i = 1; i < results.length; i++ ) {
				if ( results[i] === results[ i - 1 ] ) {
					results.splice( i--, 1 );
				}
			}
		}
	}

	return results;
};

Sizzle.matches = function( expr, set ) {
	return Sizzle( expr, null, null, set );
};

Sizzle.matchesSelector = function( node, expr ) {
	return Sizzle( expr, null, null, [node] ).length > 0;
};

Sizzle.find = function( expr, context, isXML ) {
	var set;

	if ( !expr ) {
		return [];
	}

	for ( var i = 0, l = Expr.order.length; i < l; i++ ) {
		var match,
			type = Expr.order[i];
		
		if ( (match = Expr.leftMatch[ type ].exec( expr )) ) {
			var left = match[1];
			match.splice( 1, 1 );

			if ( left.substr( left.length - 1 ) !== "\\" ) {
				match[1] = (match[1] || "").replace( rBackslash, "" );
				set = Expr.find[ type ]( match, context, isXML );

				if ( set != null ) {
					expr = expr.replace( Expr.match[ type ], "" );
					break;
				}
			}
		}
	}

	if ( !set ) {
		set = typeof context.getElementsByTagName !== "undefined" ?
			context.getElementsByTagName( "*" ) :
			[];
	}

	return { set: set, expr: expr };
};

Sizzle.filter = function( expr, set, inplace, not ) {
	var match, anyFound,
		old = expr,
		result = [],
		curLoop = set,
		isXMLFilter = set && set[0] && Sizzle.isXML( set[0] );

	while ( expr && set.length ) {
		for ( var type in Expr.filter ) {
			if ( (match = Expr.leftMatch[ type ].exec( expr )) != null && match[2] ) {
				var found, item,
					filter = Expr.filter[ type ],
					left = match[1];

				anyFound = false;

				match.splice(1,1);

				if ( left.substr( left.length - 1 ) === "\\" ) {
					continue;
				}

				if ( curLoop === result ) {
					result = [];
				}

				if ( Expr.preFilter[ type ] ) {
					match = Expr.preFilter[ type ]( match, curLoop, inplace, result, not, isXMLFilter );

					if ( !match ) {
						anyFound = found = true;

					} else if ( match === true ) {
						continue;
					}
				}

				if ( match ) {
					for ( var i = 0; (item = curLoop[i]) != null; i++ ) {
						if ( item ) {
							found = filter( item, match, i, curLoop );
							var pass = not ^ !!found;

							if ( inplace && found != null ) {
								if ( pass ) {
									anyFound = true;

								} else {
									curLoop[i] = false;
								}

							} else if ( pass ) {
								result.push( item );
								anyFound = true;
							}
						}
					}
				}

				if ( found !== undefined ) {
					if ( !inplace ) {
						curLoop = result;
					}

					expr = expr.replace( Expr.match[ type ], "" );

					if ( !anyFound ) {
						return [];
					}

					break;
				}
			}
		}

		// Improper expression
		if ( expr === old ) {
			if ( anyFound == null ) {
				Sizzle.error( expr );

			} else {
				break;
			}
		}

		old = expr;
	}

	return curLoop;
};

Sizzle.error = function( msg ) {
	throw "Syntax error, unrecognized expression: " + msg;
};

var Expr = Sizzle.selectors = {
	order: [ "ID", "NAME", "TAG" ],

	match: {
		ID: /#((?:[\w\u00c0-\uFFFF\-]|\\.)+)/,
		CLASS: /\.((?:[\w\u00c0-\uFFFF\-]|\\.)+)/,
		NAME: /\[name=['"]*((?:[\w\u00c0-\uFFFF\-]|\\.)+)['"]*\]/,
		ATTR: /\[\s*((?:[\w\u00c0-\uFFFF\-]|\\.)+)\s*(?:(\S?=)\s*(?:(['"])(.*?)\3|(#?(?:[\w\u00c0-\uFFFF\-]|\\.)*)|)|)\s*\]/,
		TAG: /^((?:[\w\u00c0-\uFFFF\*\-]|\\.)+)/,
		CHILD: /:(only|nth|last|first)-child(?:\(\s*(even|odd|(?:[+\-]?\d+|(?:[+\-]?\d*)?n\s*(?:[+\-]\s*\d+)?))\s*\))?/,
		POS: /:(nth|eq|gt|lt|first|last|even|odd)(?:\((\d*)\))?(?=[^\-]|$)/,
		PSEUDO: /:((?:[\w\u00c0-\uFFFF\-]|\\.)+)(?:\((['"]?)((?:\([^\)]+\)|[^\(\)]*)+)\2\))?/
	},

	leftMatch: {},

	attrMap: {
		"class": "className",
		"for": "htmlFor"
	},

	attrHandle: {
		href: function( elem ) {
			return elem.getAttribute( "href" );
		},
		type: function( elem ) {
			return elem.getAttribute( "type" );
		}
	},

	relative: {
		"+": function(checkSet, part){
			var isPartStr = typeof part === "string",
				isTag = isPartStr && !rNonWord.test( part ),
				isPartStrNotTag = isPartStr && !isTag;

			if ( isTag ) {
				part = part.toLowerCase();
			}

			for ( var i = 0, l = checkSet.length, elem; i < l; i++ ) {
				if ( (elem = checkSet[i]) ) {
					while ( (elem = elem.previousSibling) && elem.nodeType !== 1 ) {}

					checkSet[i] = isPartStrNotTag || elem && elem.nodeName.toLowerCase() === part ?
						elem || false :
						elem === part;
				}
			}

			if ( isPartStrNotTag ) {
				Sizzle.filter( part, checkSet, true );
			}
		},

		">": function( checkSet, part ) {
			var elem,
				isPartStr = typeof part === "string",
				i = 0,
				l = checkSet.length;

			if ( isPartStr && !rNonWord.test( part ) ) {
				part = part.toLowerCase();

				for ( ; i < l; i++ ) {
					elem = checkSet[i];

					if ( elem ) {
						var parent = elem.parentNode;
						checkSet[i] = parent.nodeName.toLowerCase() === part ? parent : false;
					}
				}

			} else {
				for ( ; i < l; i++ ) {
					elem = checkSet[i];

					if ( elem ) {
						checkSet[i] = isPartStr ?
							elem.parentNode :
							elem.parentNode === part;
					}
				}

				if ( isPartStr ) {
					Sizzle.filter( part, checkSet, true );
				}
			}
		},

		"": function(checkSet, part, isXML){
			var nodeCheck,
				doneName = done++,
				checkFn = dirCheck;

			if ( typeof part === "string" && !rNonWord.test( part ) ) {
				part = part.toLowerCase();
				nodeCheck = part;
				checkFn = dirNodeCheck;
			}

			checkFn( "parentNode", part, doneName, checkSet, nodeCheck, isXML );
		},

		"~": function( checkSet, part, isXML ) {
			var nodeCheck,
				doneName = done++,
				checkFn = dirCheck;

			if ( typeof part === "string" && !rNonWord.test( part ) ) {
				part = part.toLowerCase();
				nodeCheck = part;
				checkFn = dirNodeCheck;
			}

			checkFn( "previousSibling", part, doneName, checkSet, nodeCheck, isXML );
		}
	},

	find: {
		ID: function( match, context, isXML ) {
			if ( typeof context.getElementById !== "undefined" && !isXML ) {
				var m = context.getElementById(match[1]);
				// Check parentNode to catch when Blackberry 4.6 returns
				// nodes that are no longer in the document #6963
				return m && m.parentNode ? [m] : [];
			}
		},

		NAME: function( match, context ) {
			if ( typeof context.getElementsByName !== "undefined" ) {
				var ret = [],
					results = context.getElementsByName( match[1] );

				for ( var i = 0, l = results.length; i < l; i++ ) {
					if ( results[i].getAttribute("name") === match[1] ) {
						ret.push( results[i] );
					}
				}

				return ret.length === 0 ? null : ret;
			}
		},

		TAG: function( match, context ) {
			if ( typeof context.getElementsByTagName !== "undefined" ) {
				return context.getElementsByTagName( match[1] );
			}
		}
	},
	preFilter: {
		CLASS: function( match, curLoop, inplace, result, not, isXML ) {
			match = " " + match[1].replace( rBackslash, "" ) + " ";

			if ( isXML ) {
				return match;
			}

			for ( var i = 0, elem; (elem = curLoop[i]) != null; i++ ) {
				if ( elem ) {
					if ( not ^ (elem.className && (" " + elem.className + " ").replace(/[\t\n\r]/g, " ").indexOf(match) >= 0) ) {
						if ( !inplace ) {
							result.push( elem );
						}

					} else if ( inplace ) {
						curLoop[i] = false;
					}
				}
			}

			return false;
		},

		ID: function( match ) {
			return match[1].replace( rBackslash, "" );
		},

		TAG: function( match, curLoop ) {
			return match[1].replace( rBackslash, "" ).toLowerCase();
		},

		CHILD: function( match ) {
			if ( match[1] === "nth" ) {
				if ( !match[2] ) {
					Sizzle.error( match[0] );
				}

				match[2] = match[2].replace(/^\+|\s*/g, '');

				// parse equations like 'even', 'odd', '5', '2n', '3n+2', '4n-1', '-n+6'
				var test = /(-?)(\d*)(?:n([+\-]?\d*))?/.exec(
					match[2] === "even" && "2n" || match[2] === "odd" && "2n+1" ||
					!/\D/.test( match[2] ) && "0n+" + match[2] || match[2]);

				// calculate the numbers (first)n+(last) including if they are negative
				match[2] = (test[1] + (test[2] || 1)) - 0;
				match[3] = test[3] - 0;
			}
			else if ( match[2] ) {
				Sizzle.error( match[0] );
			}

			// TODO: Move to normal caching system
			match[0] = done++;

			return match;
		},

		ATTR: function( match, curLoop, inplace, result, not, isXML ) {
			var name = match[1] = match[1].replace( rBackslash, "" );
			
			if ( !isXML && Expr.attrMap[name] ) {
				match[1] = Expr.attrMap[name];
			}

			// Handle if an un-quoted value was used
			match[4] = ( match[4] || match[5] || "" ).replace( rBackslash, "" );

			if ( match[2] === "~=" ) {
				match[4] = " " + match[4] + " ";
			}

			return match;
		},

		PSEUDO: function( match, curLoop, inplace, result, not ) {
			if ( match[1] === "not" ) {
				// If we're dealing with a complex expression, or a simple one
				if ( ( chunker.exec(match[3]) || "" ).length > 1 || /^\w/.test(match[3]) ) {
					match[3] = Sizzle(match[3], null, null, curLoop);

				} else {
					var ret = Sizzle.filter(match[3], curLoop, inplace, true ^ not);

					if ( !inplace ) {
						result.push.apply( result, ret );
					}

					return false;
				}

			} else if ( Expr.match.POS.test( match[0] ) || Expr.match.CHILD.test( match[0] ) ) {
				return true;
			}
			
			return match;
		},

		POS: function( match ) {
			match.unshift( true );

			return match;
		}
	},
	
	filters: {
		enabled: function( elem ) {
			return elem.disabled === false && elem.type !== "hidden";
		},

		disabled: function( elem ) {
			return elem.disabled === true;
		},

		checked: function( elem ) {
			return elem.checked === true;
		},
		
		selected: function( elem ) {
			// Accessing this property makes selected-by-default
			// options in Safari work properly
			if ( elem.parentNode ) {
				elem.parentNode.selectedIndex;
			}
			
			return elem.selected === true;
		},

		parent: function( elem ) {
			return !!elem.firstChild;
		},

		empty: function( elem ) {
			return !elem.firstChild;
		},

		has: function( elem, i, match ) {
			return !!Sizzle( match[3], elem ).length;
		},

		header: function( elem ) {
			return (/h\d/i).test( elem.nodeName );
		},

		text: function( elem ) {
			var attr = elem.getAttribute( "type" ), type = elem.type;
			// IE6 and 7 will map elem.type to 'text' for new HTML5 types (search, etc) 
			// use getAttribute instead to test this case
			return elem.nodeName.toLowerCase() === "input" && "text" === type && ( attr === type || attr === null );
		},

		radio: function( elem ) {
			return elem.nodeName.toLowerCase() === "input" && "radio" === elem.type;
		},

		checkbox: function( elem ) {
			return elem.nodeName.toLowerCase() === "input" && "checkbox" === elem.type;
		},

		file: function( elem ) {
			return elem.nodeName.toLowerCase() === "input" && "file" === elem.type;
		},

		password: function( elem ) {
			return elem.nodeName.toLowerCase() === "input" && "password" === elem.type;
		},

		submit: function( elem ) {
			var name = elem.nodeName.toLowerCase();
			return (name === "input" || name === "button") && "submit" === elem.type;
		},

		image: function( elem ) {
			return elem.nodeName.toLowerCase() === "input" && "image" === elem.type;
		},

		reset: function( elem ) {
			var name = elem.nodeName.toLowerCase();
			return (name === "input" || name === "button") && "reset" === elem.type;
		},

		button: function( elem ) {
			var name = elem.nodeName.toLowerCase();
			return name === "input" && "button" === elem.type || name === "button";
		},

		input: function( elem ) {
			return (/input|select|textarea|button/i).test( elem.nodeName );
		},

		focus: function( elem ) {
			return elem === elem.ownerDocument.activeElement;
		}
	},
	setFilters: {
		first: function( elem, i ) {
			return i === 0;
		},

		last: function( elem, i, match, array ) {
			return i === array.length - 1;
		},

		even: function( elem, i ) {
			return i % 2 === 0;
		},

		odd: function( elem, i ) {
			return i % 2 === 1;
		},

		lt: function( elem, i, match ) {
			return i < match[3] - 0;
		},

		gt: function( elem, i, match ) {
			return i > match[3] - 0;
		},

		nth: function( elem, i, match ) {
			return match[3] - 0 === i;
		},

		eq: function( elem, i, match ) {
			return match[3] - 0 === i;
		}
	},
	filter: {
		PSEUDO: function( elem, match, i, array ) {
			var name = match[1],
				filter = Expr.filters[ name ];

			if ( filter ) {
				return filter( elem, i, match, array );

			} else if ( name === "contains" ) {
				return (elem.textContent || elem.innerText || Sizzle.getText([ elem ]) || "").indexOf(match[3]) >= 0;

			} else if ( name === "not" ) {
				var not = match[3];

				for ( var j = 0, l = not.length; j < l; j++ ) {
					if ( not[j] === elem ) {
						return false;
					}
				}

				return true;

			} else {
				Sizzle.error( name );
			}
		},

		CHILD: function( elem, match ) {
			var type = match[1],
				node = elem;

			switch ( type ) {
				case "only":
				case "first":
					while ( (node = node.previousSibling) )	 {
						if ( node.nodeType === 1 ) { 
							return false; 
						}
					}

					if ( type === "first" ) { 
						return true; 
					}

					node = elem;

				case "last":
					while ( (node = node.nextSibling) )	 {
						if ( node.nodeType === 1 ) { 
							return false; 
						}
					}

					return true;

				case "nth":
					var first = match[2],
						last = match[3];

					if ( first === 1 && last === 0 ) {
						return true;
					}
					
					var doneName = match[0],
						parent = elem.parentNode;
	
					if ( parent && (parent.sizcache !== doneName || !elem.nodeIndex) ) {
						var count = 0;
						
						for ( node = parent.firstChild; node; node = node.nextSibling ) {
							if ( node.nodeType === 1 ) {
								node.nodeIndex = ++count;
							}
						} 

						parent.sizcache = doneName;
					}
					
					var diff = elem.nodeIndex - last;

					if ( first === 0 ) {
						return diff === 0;

					} else {
						return ( diff % first === 0 && diff / first >= 0 );
					}
			}
		},

		ID: function( elem, match ) {
			return elem.nodeType === 1 && elem.getAttribute("id") === match;
		},

		TAG: function( elem, match ) {
			return (match === "*" && elem.nodeType === 1) || elem.nodeName.toLowerCase() === match;
		},
		
		CLASS: function( elem, match ) {
			return (" " + (elem.className || elem.getAttribute("class")) + " ")
				.indexOf( match ) > -1;
		},

		ATTR: function( elem, match ) {
			var name = match[1],
				result = Expr.attrHandle[ name ] ?
					Expr.attrHandle[ name ]( elem ) :
					elem[ name ] != null ?
						elem[ name ] :
						elem.getAttribute( name ),
				value = result + "",
				type = match[2],
				check = match[4];

			return result == null ?
				type === "!=" :
				type === "=" ?
				value === check :
				type === "*=" ?
				value.indexOf(check) >= 0 :
				type === "~=" ?
				(" " + value + " ").indexOf(check) >= 0 :
				!check ?
				value && result !== false :
				type === "!=" ?
				value !== check :
				type === "^=" ?
				value.indexOf(check) === 0 :
				type === "$=" ?
				value.substr(value.length - check.length) === check :
				type === "|=" ?
				value === check || value.substr(0, check.length + 1) === check + "-" :
				false;
		},

		POS: function( elem, match, i, array ) {
			var name = match[2],
				filter = Expr.setFilters[ name ];

			if ( filter ) {
				return filter( elem, i, match, array );
			}
		}
	}
};

var origPOS = Expr.match.POS,
	fescape = function(all, num){
		return "\\" + (num - 0 + 1);
	};

for ( var type in Expr.match ) {
	Expr.match[ type ] = new RegExp( Expr.match[ type ].source + (/(?![^\[]*\])(?![^\(]*\))/.source) );
	Expr.leftMatch[ type ] = new RegExp( /(^(?:.|\r|\n)*?)/.source + Expr.match[ type ].source.replace(/\\(\d+)/g, fescape) );
}

var makeArray = function( array, results ) {
	array = Array.prototype.slice.call( array, 0 );

	if ( results ) {
		results.push.apply( results, array );
		return results;
	}
	
	return array;
};

// Perform a simple check to determine if the browser is capable of
// converting a NodeList to an array using builtin methods.
// Also verifies that the returned array holds DOM nodes
// (which is not the case in the Blackberry browser)
try {
	Array.prototype.slice.call( document.documentElement.childNodes, 0 )[0].nodeType;

// Provide a fallback method if it does not work
} catch( e ) {
	makeArray = function( array, results ) {
		var i = 0,
			ret = results || [];

		if ( toString.call(array) === "[object Array]" ) {
			Array.prototype.push.apply( ret, array );

		} else {
			if ( typeof array.length === "number" ) {
				for ( var l = array.length; i < l; i++ ) {
					ret.push( array[i] );
				}

			} else {
				for ( ; array[i]; i++ ) {
					ret.push( array[i] );
				}
			}
		}

		return ret;
	};
}

var sortOrder, siblingCheck;

if ( document.documentElement.compareDocumentPosition ) {
	sortOrder = function( a, b ) {
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		if ( !a.compareDocumentPosition || !b.compareDocumentPosition ) {
			return a.compareDocumentPosition ? -1 : 1;
		}

		return a.compareDocumentPosition(b) & 4 ? -1 : 1;
	};

} else {
	sortOrder = function( a, b ) {
		// The nodes are identical, we can exit early
		if ( a === b ) {
			hasDuplicate = true;
			return 0;

		// Fallback to using sourceIndex (in IE) if it's available on both nodes
		} else if ( a.sourceIndex && b.sourceIndex ) {
			return a.sourceIndex - b.sourceIndex;
		}

		var al, bl,
			ap = [],
			bp = [],
			aup = a.parentNode,
			bup = b.parentNode,
			cur = aup;

		// If the nodes are siblings (or identical) we can do a quick check
		if ( aup === bup ) {
			return siblingCheck( a, b );

		// If no parents were found then the nodes are disconnected
		} else if ( !aup ) {
			return -1;

		} else if ( !bup ) {
			return 1;
		}

		// Otherwise they're somewhere else in the tree so we need
		// to build up a full list of the parentNodes for comparison
		while ( cur ) {
			ap.unshift( cur );
			cur = cur.parentNode;
		}

		cur = bup;

		while ( cur ) {
			bp.unshift( cur );
			cur = cur.parentNode;
		}

		al = ap.length;
		bl = bp.length;

		// Start walking down the tree looking for a discrepancy
		for ( var i = 0; i < al && i < bl; i++ ) {
			if ( ap[i] !== bp[i] ) {
				return siblingCheck( ap[i], bp[i] );
			}
		}

		// We ended someplace up the tree so do a sibling check
		return i === al ?
			siblingCheck( a, bp[i], -1 ) :
			siblingCheck( ap[i], b, 1 );
	};

	siblingCheck = function( a, b, ret ) {
		if ( a === b ) {
			return ret;
		}

		var cur = a.nextSibling;

		while ( cur ) {
			if ( cur === b ) {
				return -1;
			}

			cur = cur.nextSibling;
		}

		return 1;
	};
}

// Utility function for retreiving the text value of an array of DOM nodes
Sizzle.getText = function( elems ) {
	var ret = "", elem;

	for ( var i = 0; elems[i]; i++ ) {
		elem = elems[i];

		// Get the text from text nodes and CDATA nodes
		if ( elem.nodeType === 3 || elem.nodeType === 4 ) {
			ret += elem.nodeValue;

		// Traverse everything else, except comment nodes
		} else if ( elem.nodeType !== 8 ) {
			ret += Sizzle.getText( elem.childNodes );
		}
	}

	return ret;
};

// Check to see if the browser returns elements by name when
// querying by getElementById (and provide a workaround)
(function(){
	// We're going to inject a fake input element with a specified name
	var form = document.createElement("div"),
		id = "script" + (new Date()).getTime(),
		root = document.documentElement;

	form.innerHTML = "<a name='" + id + "'/>";

	// Inject it into the root element, check its status, and remove it quickly
	root.insertBefore( form, root.firstChild );

	// The workaround has to do additional checks after a getElementById
	// Which slows things down for other browsers (hence the branching)
	if ( document.getElementById( id ) ) {
		Expr.find.ID = function( match, context, isXML ) {
			if ( typeof context.getElementById !== "undefined" && !isXML ) {
				var m = context.getElementById(match[1]);

				return m ?
					m.id === match[1] || typeof m.getAttributeNode !== "undefined" && m.getAttributeNode("id").nodeValue === match[1] ?
						[m] :
						undefined :
					[];
			}
		};

		Expr.filter.ID = function( elem, match ) {
			var node = typeof elem.getAttributeNode !== "undefined" && elem.getAttributeNode("id");

			return elem.nodeType === 1 && node && node.nodeValue === match;
		};
	}

	root.removeChild( form );

	// release memory in IE
	root = form = null;
})();

(function(){
	// Check to see if the browser returns only elements
	// when doing getElementsByTagName("*")

	// Create a fake element
	var div = document.createElement("div");
	div.appendChild( document.createComment("") );

	// Make sure no comments are found
	if ( div.getElementsByTagName("*").length > 0 ) {
		Expr.find.TAG = function( match, context ) {
			var results = context.getElementsByTagName( match[1] );

			// Filter out possible comments
			if ( match[1] === "*" ) {
				var tmp = [];

				for ( var i = 0; results[i]; i++ ) {
					if ( results[i].nodeType === 1 ) {
						tmp.push( results[i] );
					}
				}

				results = tmp;
			}

			return results;
		};
	}

	// Check to see if an attribute returns normalized href attributes
	div.innerHTML = "<a href='#'></a>";

	if ( div.firstChild && typeof div.firstChild.getAttribute !== "undefined" &&
			div.firstChild.getAttribute("href") !== "#" ) {

		Expr.attrHandle.href = function( elem ) {
			return elem.getAttribute( "href", 2 );
		};
	}

	// release memory in IE
	div = null;
})();

if ( document.querySelectorAll ) {
	(function(){
		var oldSizzle = Sizzle,
			div = document.createElement("div"),
			id = "__sizzle__";

		div.innerHTML = "<p class='TEST'></p>";

		// Safari can't handle uppercase or unicode characters when
		// in quirks mode.
		if ( div.querySelectorAll && div.querySelectorAll(".TEST").length === 0 ) {
			return;
		}
	
		Sizzle = function( query, context, extra, seed ) {
			context = context || document;

			// Only use querySelectorAll on non-XML documents
			// (ID selectors don't work in non-HTML documents)
			if ( !seed && !Sizzle.isXML(context) ) {
				// See if we find a selector to speed up
				var match = /^(\w+$)|^\.([\w\-]+$)|^#([\w\-]+$)/.exec( query );
				
				if ( match && (context.nodeType === 1 || context.nodeType === 9) ) {
					// Speed-up: Sizzle("TAG")
					if ( match[1] ) {
						return makeArray( context.getElementsByTagName( query ), extra );
					
					// Speed-up: Sizzle(".CLASS")
					} else if ( match[2] && Expr.find.CLASS && context.getElementsByClassName ) {
						return makeArray( context.getElementsByClassName( match[2] ), extra );
					}
				}
				
				if ( context.nodeType === 9 ) {
					// Speed-up: Sizzle("body")
					// The body element only exists once, optimize finding it
					if ( query === "body" && context.body ) {
						return makeArray( [ context.body ], extra );
						
					// Speed-up: Sizzle("#ID")
					} else if ( match && match[3] ) {
						var elem = context.getElementById( match[3] );

						// Check parentNode to catch when Blackberry 4.6 returns
						// nodes that are no longer in the document #6963
						if ( elem && elem.parentNode ) {
							// Handle the case where IE and Opera return items
							// by name instead of ID
							if ( elem.id === match[3] ) {
								return makeArray( [ elem ], extra );
							}
							
						} else {
							return makeArray( [], extra );
						}
					}
					
					try {
						return makeArray( context.querySelectorAll(query), extra );
					} catch(qsaError) {}

				// qSA works strangely on Element-rooted queries
				// We can work around this by specifying an extra ID on the root
				// and working up from there (Thanks to Andrew Dupont for the technique)
				// IE 8 doesn't work on object elements
				} else if ( context.nodeType === 1 && context.nodeName.toLowerCase() !== "object" ) {
					var oldContext = context,
						old = context.getAttribute( "id" ),
						nid = old || id,
						hasParent = context.parentNode,
						relativeHierarchySelector = /^\s*[+~]/.test( query );

					if ( !old ) {
						context.setAttribute( "id", nid );
					} else {
						nid = nid.replace( /'/g, "\\$&" );
					}
					if ( relativeHierarchySelector && hasParent ) {
						context = context.parentNode;
					}

					try {
						if ( !relativeHierarchySelector || hasParent ) {
							return makeArray( context.querySelectorAll( "[id='" + nid + "'] " + query ), extra );
						}

					} catch(pseudoError) {
					} finally {
						if ( !old ) {
							oldContext.removeAttribute( "id" );
						}
					}
				}
			}
		
			return oldSizzle(query, context, extra, seed);
		};

		for ( var prop in oldSizzle ) {
			Sizzle[ prop ] = oldSizzle[ prop ];
		}

		// release memory in IE
		div = null;
	})();
}

(function(){
	var html = document.documentElement,
		matches = html.matchesSelector || html.mozMatchesSelector || html.webkitMatchesSelector || html.msMatchesSelector;

	if ( matches ) {
		// Check to see if it's possible to do matchesSelector
		// on a disconnected node (IE 9 fails this)
		var disconnectedMatch = !matches.call( document.createElement( "div" ), "div" ),
			pseudoWorks = false;

		try {
			// This should fail with an exception
			// Gecko does not error, returns false instead
			matches.call( document.documentElement, "[test!='']:sizzle" );
	
		} catch( pseudoError ) {
			pseudoWorks = true;
		}

		Sizzle.matchesSelector = function( node, expr ) {
			// Make sure that attribute selectors are quoted
			expr = expr.replace(/\=\s*([^'"\]]*)\s*\]/g, "='$1']");

			if ( !Sizzle.isXML( node ) ) {
				try { 
					if ( pseudoWorks || !Expr.match.PSEUDO.test( expr ) && !/!=/.test( expr ) ) {
						var ret = matches.call( node, expr );

						// IE 9's matchesSelector returns false on disconnected nodes
						if ( ret || !disconnectedMatch ||
								// As well, disconnected nodes are said to be in a document
								// fragment in IE 9, so check for that
								node.document && node.document.nodeType !== 11 ) {
							return ret;
						}
					}
				} catch(e) {}
			}

			return Sizzle(expr, null, null, [node]).length > 0;
		};
	}
})();

(function(){
	var div = document.createElement("div");

	div.innerHTML = "<div class='test e'></div><div class='test'></div>";

	// Opera can't find a second classname (in 9.6)
	// Also, make sure that getElementsByClassName actually exists
	if ( !div.getElementsByClassName || div.getElementsByClassName("e").length === 0 ) {
		return;
	}

	// Safari caches class attributes, doesn't catch changes (in 3.2)
	div.lastChild.className = "e";

	if ( div.getElementsByClassName("e").length === 1 ) {
		return;
	}
	
	Expr.order.splice(1, 0, "CLASS");
	Expr.find.CLASS = function( match, context, isXML ) {
		if ( typeof context.getElementsByClassName !== "undefined" && !isXML ) {
			return context.getElementsByClassName(match[1]);
		}
	};

	// release memory in IE
	div = null;
})();

function dirNodeCheck( dir, cur, doneName, checkSet, nodeCheck, isXML ) {
	for ( var i = 0, l = checkSet.length; i < l; i++ ) {
		var elem = checkSet[i];

		if ( elem ) {
			var match = false;

			elem = elem[dir];

			while ( elem ) {
				if ( elem.sizcache === doneName ) {
					match = checkSet[elem.sizset];
					break;
				}

				if ( elem.nodeType === 1 && !isXML ){
					elem.sizcache = doneName;
					elem.sizset = i;
				}

				if ( elem.nodeName.toLowerCase() === cur ) {
					match = elem;
					break;
				}

				elem = elem[dir];
			}

			checkSet[i] = match;
		}
	}
}

function dirCheck( dir, cur, doneName, checkSet, nodeCheck, isXML ) {
	for ( var i = 0, l = checkSet.length; i < l; i++ ) {
		var elem = checkSet[i];

		if ( elem ) {
			var match = false;
			
			elem = elem[dir];

			while ( elem ) {
				if ( elem.sizcache === doneName ) {
					match = checkSet[elem.sizset];
					break;
				}

				if ( elem.nodeType === 1 ) {
					if ( !isXML ) {
						elem.sizcache = doneName;
						elem.sizset = i;
					}

					if ( typeof cur !== "string" ) {
						if ( elem === cur ) {
							match = true;
							break;
						}

					} else if ( Sizzle.filter( cur, [elem] ).length > 0 ) {
						match = elem;
						break;
					}
				}

				elem = elem[dir];
			}

			checkSet[i] = match;
		}
	}
}

if ( document.documentElement.contains ) {
	Sizzle.contains = function( a, b ) {
		return a !== b && (a.contains ? a.contains(b) : true);
	};

} else if ( document.documentElement.compareDocumentPosition ) {
	Sizzle.contains = function( a, b ) {
		return !!(a.compareDocumentPosition(b) & 16);
	};

} else {
	Sizzle.contains = function() {
		return false;
	};
}

Sizzle.isXML = function( elem ) {
	// documentElement is verified for cases where it doesn't yet exist
	// (such as loading iframes in IE - #4833) 
	var documentElement = (elem ? elem.ownerDocument || elem : 0).documentElement;

	return documentElement ? documentElement.nodeName !== "HTML" : false;
};

var posProcess = function( selector, context ) {
	var match,
		tmpSet = [],
		later = "",
		root = context.nodeType ? [context] : context;

	// Position selectors must be done after the filter
	// And so must :not(positional) so we move all PSEUDOs to the end
	while ( (match = Expr.match.PSEUDO.exec( selector )) ) {
		later += match[0];
		selector = selector.replace( Expr.match.PSEUDO, "" );
	}

	selector = Expr.relative[selector] ? selector + "*" : selector;

	for ( var i = 0, l = root.length; i < l; i++ ) {
		Sizzle( selector, root[i], tmpSet );
	}

	return Sizzle.filter( later, tmpSet );
};

// EXPOSE
jQuery.find = Sizzle;
jQuery.expr = Sizzle.selectors;
jQuery.expr[":"] = jQuery.expr.filters;
jQuery.unique = Sizzle.uniqueSort;
jQuery.text = Sizzle.getText;
jQuery.isXMLDoc = Sizzle.isXML;
jQuery.contains = Sizzle.contains;


})();


var runtil = /Until$/,
	rparentsprev = /^(?:parents|prevUntil|prevAll)/,
	// Note: This RegExp should be improved, or likely pulled from Sizzle
	rmultiselector = /,/,
	isSimple = /^.[^:#\[\.,]*$/,
	slice = Array.prototype.slice,
	POS = jQuery.expr.match.POS,
	// methods guaranteed to produce a unique set when starting from a unique set
	guaranteedUnique = {
		children: true,
		contents: true,
		next: true,
		prev: true
	};

jQuery.fn.extend({
	find: function( selector ) {
		var self = this,
			i, l;

		if ( typeof selector !== "string" ) {
			return jQuery( selector ).filter(function() {
				for ( i = 0, l = self.length; i < l; i++ ) {
					if ( jQuery.contains( self[ i ], this ) ) {
						return true;
					}
				}
			});
		}

		var ret = this.pushStack( "", "find", selector ),
			length, n, r;

		for ( i = 0, l = this.length; i < l; i++ ) {
			length = ret.length;
			jQuery.find( selector, this[i], ret );

			if ( i > 0 ) {
				// Make sure that the results are unique
				for ( n = length; n < ret.length; n++ ) {
					for ( r = 0; r < length; r++ ) {
						if ( ret[r] === ret[n] ) {
							ret.splice(n--, 1);
							break;
						}
					}
				}
			}
		}

		return ret;
	},

	has: function( target ) {
		var targets = jQuery( target );
		return this.filter(function() {
			for ( var i = 0, l = targets.length; i < l; i++ ) {
				if ( jQuery.contains( this, targets[i] ) ) {
					return true;
				}
			}
		});
	},

	not: function( selector ) {
		return this.pushStack( winnow(this, selector, false), "not", selector);
	},

	filter: function( selector ) {
		return this.pushStack( winnow(this, selector, true), "filter", selector );
	},

	is: function( selector ) {
		return !!selector && ( typeof selector === "string" ?
			jQuery.filter( selector, this ).length > 0 :
			this.filter( selector ).length > 0 );
	},

	closest: function( selectors, context ) {
		var ret = [], i, l, cur = this[0];
		
		// Array
		if ( jQuery.isArray( selectors ) ) {
			var match, selector,
				matches = {},
				level = 1;

			if ( cur && selectors.length ) {
				for ( i = 0, l = selectors.length; i < l; i++ ) {
					selector = selectors[i];

					if ( !matches[ selector ] ) {
						matches[ selector ] = POS.test( selector ) ?
							jQuery( selector, context || this.context ) :
							selector;
					}
				}

				while ( cur && cur.ownerDocument && cur !== context ) {
					for ( selector in matches ) {
						match = matches[ selector ];

						if ( match.jquery ? match.index( cur ) > -1 : jQuery( cur ).is( match ) ) {
							ret.push({ selector: selector, elem: cur, level: level });
						}
					}

					cur = cur.parentNode;
					level++;
				}
			}

			return ret;
		}

		// String
		var pos = POS.test( selectors ) || typeof selectors !== "string" ?
				jQuery( selectors, context || this.context ) :
				0;

		for ( i = 0, l = this.length; i < l; i++ ) {
			cur = this[i];

			while ( cur ) {
				if ( pos ? pos.index(cur) > -1 : jQuery.find.matchesSelector(cur, selectors) ) {
					ret.push( cur );
					break;

				} else {
					cur = cur.parentNode;
					if ( !cur || !cur.ownerDocument || cur === context || cur.nodeType === 11 ) {
						break;
					}
				}
			}
		}

		ret = ret.length > 1 ? jQuery.unique( ret ) : ret;

		return this.pushStack( ret, "closest", selectors );
	},

	// Determine the position of an element within
	// the matched set of elements
	index: function( elem ) {

		// No argument, return index in parent
		if ( !elem ) {
			return ( this[0] && this[0].parentNode ) ? this.prevAll().length : -1;
		}

		// index in selector
		if ( typeof elem === "string" ) {
			return jQuery.inArray( this[0], jQuery( elem ) );
		}

		// Locate the position of the desired element
		return jQuery.inArray(
			// If it receives a jQuery object, the first element is used
			elem.jquery ? elem[0] : elem, this );
	},

	add: function( selector, context ) {
		var set = typeof selector === "string" ?
				jQuery( selector, context ) :
				jQuery.makeArray( selector && selector.nodeType ? [ selector ] : selector ),
			all = jQuery.merge( this.get(), set );

		return this.pushStack( isDisconnected( set[0] ) || isDisconnected( all[0] ) ?
			all :
			jQuery.unique( all ) );
	},

	andSelf: function() {
		return this.add( this.prevObject );
	}
});

// A painfully simple check to see if an element is disconnected
// from a document (should be improved, where feasible).
function isDisconnected( node ) {
	return !node || !node.parentNode || node.parentNode.nodeType === 11;
}

jQuery.each({
	parent: function( elem ) {
		var parent = elem.parentNode;
		return parent && parent.nodeType !== 11 ? parent : null;
	},
	parents: function( elem ) {
		return jQuery.dir( elem, "parentNode" );
	},
	parentsUntil: function( elem, i, until ) {
		return jQuery.dir( elem, "parentNode", until );
	},
	next: function( elem ) {
		return jQuery.nth( elem, 2, "nextSibling" );
	},
	prev: function( elem ) {
		return jQuery.nth( elem, 2, "previousSibling" );
	},
	nextAll: function( elem ) {
		return jQuery.dir( elem, "nextSibling" );
	},
	prevAll: function( elem ) {
		return jQuery.dir( elem, "previousSibling" );
	},
	nextUntil: function( elem, i, until ) {
		return jQuery.dir( elem, "nextSibling", until );
	},
	prevUntil: function( elem, i, until ) {
		return jQuery.dir( elem, "previousSibling", until );
	},
	siblings: function( elem ) {
		return jQuery.sibling( elem.parentNode.firstChild, elem );
	},
	children: function( elem ) {
		return jQuery.sibling( elem.firstChild );
	},
	contents: function( elem ) {
		return jQuery.nodeName( elem, "iframe" ) ?
			elem.contentDocument || elem.contentWindow.document :
			jQuery.makeArray( elem.childNodes );
	}
}, function( name, fn ) {
	jQuery.fn[ name ] = function( until, selector ) {
		var ret = jQuery.map( this, fn, until ),
			// The variable 'args' was introduced in
			// https://github.com/jquery/jquery/commit/52a0238
			// to work around a bug in Chrome 10 (Dev) and should be removed when the bug is fixed.
			// http://code.google.com/p/v8/issues/detail?id=1050
			args = slice.call(arguments);

		if ( !runtil.test( name ) ) {
			selector = until;
		}

		if ( selector && typeof selector === "string" ) {
			ret = jQuery.filter( selector, ret );
		}

		ret = this.length > 1 && !guaranteedUnique[ name ] ? jQuery.unique( ret ) : ret;

		if ( (this.length > 1 || rmultiselector.test( selector )) && rparentsprev.test( name ) ) {
			ret = ret.reverse();
		}

		return this.pushStack( ret, name, args.join(",") );
	};
});

jQuery.extend({
	filter: function( expr, elems, not ) {
		if ( not ) {
			expr = ":not(" + expr + ")";
		}

		return elems.length === 1 ?
			jQuery.find.matchesSelector(elems[0], expr) ? [ elems[0] ] : [] :
			jQuery.find.matches(expr, elems);
	},

	dir: function( elem, dir, until ) {
		var matched = [],
			cur = elem[ dir ];

		while ( cur && cur.nodeType !== 9 && (until === undefined || cur.nodeType !== 1 || !jQuery( cur ).is( until )) ) {
			if ( cur.nodeType === 1 ) {
				matched.push( cur );
			}
			cur = cur[dir];
		}
		return matched;
	},

	nth: function( cur, result, dir, elem ) {
		result = result || 1;
		var num = 0;

		for ( ; cur; cur = cur[dir] ) {
			if ( cur.nodeType === 1 && ++num === result ) {
				break;
			}
		}

		return cur;
	},

	sibling: function( n, elem ) {
		var r = [];

		for ( ; n; n = n.nextSibling ) {
			if ( n.nodeType === 1 && n !== elem ) {
				r.push( n );
			}
		}

		return r;
	}
});

// Implement the identical functionality for filter and not
function winnow( elements, qualifier, keep ) {

	// Can't pass null or undefined to indexOf in Firefox 4
	// Set to 0 to skip string check
	qualifier = qualifier || 0;

	if ( jQuery.isFunction( qualifier ) ) {
		return jQuery.grep(elements, function( elem, i ) {
			var retVal = !!qualifier.call( elem, i, elem );
			return retVal === keep;
		});

	} else if ( qualifier.nodeType ) {
		return jQuery.grep(elements, function( elem, i ) {
			return (elem === qualifier) === keep;
		});

	} else if ( typeof qualifier === "string" ) {
		var filtered = jQuery.grep(elements, function( elem ) {
			return elem.nodeType === 1;
		});

		if ( isSimple.test( qualifier ) ) {
			return jQuery.filter(qualifier, filtered, !keep);
		} else {
			qualifier = jQuery.filter( qualifier, filtered );
		}
	}

	return jQuery.grep(elements, function( elem, i ) {
		return (jQuery.inArray( elem, qualifier ) >= 0) === keep;
	});
}




var rinlinejQuery = / jQuery\d+="(?:\d+|null)"/g,
	rleadingWhitespace = /^\s+/,
	rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/ig,
	rtagName = /<([\w:]+)/,
	rtbody = /<tbody/i,
	rhtml = /<|&#?\w+;/,
	rnocache = /<(?:script|object|embed|option|style)/i,
	// checked="checked" or checked
	rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
	rscriptType = /\/(java|ecma)script/i,
	rcleanScript = /^\s*<!(?:\[CDATA\[|\-\-)/,
	wrapMap = {
		option: [ 1, "<select multiple='multiple'>", "</select>" ],
		legend: [ 1, "<fieldset>", "</fieldset>" ],
		thead: [ 1, "<table>", "</table>" ],
		tr: [ 2, "<table><tbody>", "</tbody></table>" ],
		td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],
		col: [ 2, "<table><tbody></tbody><colgroup>", "</colgroup></table>" ],
		area: [ 1, "<map>", "</map>" ],
		_default: [ 0, "", "" ]
	};

wrapMap.optgroup = wrapMap.option;
wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
wrapMap.th = wrapMap.td;

// IE can't serialize <link> and <script> tags normally
if ( !jQuery.support.htmlSerialize ) {
	wrapMap._default = [ 1, "div<div>", "</div>" ];
}

jQuery.fn.extend({
	text: function( text ) {
		if ( jQuery.isFunction(text) ) {
			return this.each(function(i) {
				var self = jQuery( this );

				self.text( text.call(this, i, self.text()) );
			});
		}

		if ( typeof text !== "object" && text !== undefined ) {
			return this.empty().append( (this[0] && this[0].ownerDocument || document).createTextNode( text ) );
		}

		return jQuery.text( this );
	},

	wrapAll: function( html ) {
		if ( jQuery.isFunction( html ) ) {
			return this.each(function(i) {
				jQuery(this).wrapAll( html.call(this, i) );
			});
		}

		if ( this[0] ) {
			// The elements to wrap the target around
			var wrap = jQuery( html, this[0].ownerDocument ).eq(0).clone(true);

			if ( this[0].parentNode ) {
				wrap.insertBefore( this[0] );
			}

			wrap.map(function() {
				var elem = this;

				while ( elem.firstChild && elem.firstChild.nodeType === 1 ) {
					elem = elem.firstChild;
				}

				return elem;
			}).append( this );
		}

		return this;
	},

	wrapInner: function( html ) {
		if ( jQuery.isFunction( html ) ) {
			return this.each(function(i) {
				jQuery(this).wrapInner( html.call(this, i) );
			});
		}

		return this.each(function() {
			var self = jQuery( this ),
				contents = self.contents();

			if ( contents.length ) {
				contents.wrapAll( html );

			} else {
				self.append( html );
			}
		});
	},

	wrap: function( html ) {
		return this.each(function() {
			jQuery( this ).wrapAll( html );
		});
	},

	unwrap: function() {
		return this.parent().each(function() {
			if ( !jQuery.nodeName( this, "body" ) ) {
				jQuery( this ).replaceWith( this.childNodes );
			}
		}).end();
	},

	append: function() {
		return this.domManip(arguments, true, function( elem ) {
			if ( this.nodeType === 1 ) {
				this.appendChild( elem );
			}
		});
	},

	prepend: function() {
		return this.domManip(arguments, true, function( elem ) {
			if ( this.nodeType === 1 ) {
				this.insertBefore( elem, this.firstChild );
			}
		});
	},

	before: function() {
		if ( this[0] && this[0].parentNode ) {
			return this.domManip(arguments, false, function( elem ) {
				this.parentNode.insertBefore( elem, this );
			});
		} else if ( arguments.length ) {
			var set = jQuery(arguments[0]);
			set.push.apply( set, this.toArray() );
			return this.pushStack( set, "before", arguments );
		}
	},

	after: function() {
		if ( this[0] && this[0].parentNode ) {
			return this.domManip(arguments, false, function( elem ) {
				this.parentNode.insertBefore( elem, this.nextSibling );
			});
		} else if ( arguments.length ) {
			var set = this.pushStack( this, "after", arguments );
			set.push.apply( set, jQuery(arguments[0]).toArray() );
			return set;
		}
	},

	// keepData is for internal use only--do not document
	remove: function( selector, keepData ) {
		for ( var i = 0, elem; (elem = this[i]) != null; i++ ) {
			if ( !selector || jQuery.filter( selector, [ elem ] ).length ) {
				if ( !keepData && elem.nodeType === 1 ) {
					jQuery.cleanData( elem.getElementsByTagName("*") );
					jQuery.cleanData( [ elem ] );
				}

				if ( elem.parentNode ) {
					elem.parentNode.removeChild( elem );
				}
			}
		}

		return this;
	},

	empty: function() {
		for ( var i = 0, elem; (elem = this[i]) != null; i++ ) {
			// Remove element nodes and prevent memory leaks
			if ( elem.nodeType === 1 ) {
				jQuery.cleanData( elem.getElementsByTagName("*") );
			}

			// Remove any remaining nodes
			while ( elem.firstChild ) {
				elem.removeChild( elem.firstChild );
			}
		}

		return this;
	},

	clone: function( dataAndEvents, deepDataAndEvents ) {
		dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
		deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

		return this.map( function () {
			return jQuery.clone( this, dataAndEvents, deepDataAndEvents );
		});
	},

	html: function( value ) {
		if ( value === undefined ) {
			return this[0] && this[0].nodeType === 1 ?
				this[0].innerHTML.replace(rinlinejQuery, "") :
				null;

		// See if we can take a shortcut and just use innerHTML
		} else if ( typeof value === "string" && !rnocache.test( value ) &&
			(jQuery.support.leadingWhitespace || !rleadingWhitespace.test( value )) &&
			!wrapMap[ (rtagName.exec( value ) || ["", ""])[1].toLowerCase() ] ) {

			value = value.replace(rxhtmlTag, "<$1></$2>");

			try {
				for ( var i = 0, l = this.length; i < l; i++ ) {
					// Remove element nodes and prevent memory leaks
					if ( this[i].nodeType === 1 ) {
						jQuery.cleanData( this[i].getElementsByTagName("*") );
						this[i].innerHTML = value;
					}
				}

			// If using innerHTML throws an exception, use the fallback method
			} catch(e) {
				this.empty().append( value );
			}

		} else if ( jQuery.isFunction( value ) ) {
			this.each(function(i){
				var self = jQuery( this );

				self.html( value.call(this, i, self.html()) );
			});

		} else {
			this.empty().append( value );
		}

		return this;
	},

	replaceWith: function( value ) {
		if ( this[0] && this[0].parentNode ) {
			// Make sure that the elements are removed from the DOM before they are inserted
			// this can help fix replacing a parent with child elements
			if ( jQuery.isFunction( value ) ) {
				return this.each(function(i) {
					var self = jQuery(this), old = self.html();
					self.replaceWith( value.call( this, i, old ) );
				});
			}

			if ( typeof value !== "string" ) {
				value = jQuery( value ).detach();
			}

			return this.each(function() {
				var next = this.nextSibling,
					parent = this.parentNode;

				jQuery( this ).remove();

				if ( next ) {
					jQuery(next).before( value );
				} else {
					jQuery(parent).append( value );
				}
			});
		} else {
			return this.length ?
				this.pushStack( jQuery(jQuery.isFunction(value) ? value() : value), "replaceWith", value ) :
				this;
		}
	},

	detach: function( selector ) {
		return this.remove( selector, true );
	},

	domManip: function( args, table, callback ) {
		var results, first, fragment, parent,
			value = args[0],
			scripts = [];

		// We can't cloneNode fragments that contain checked, in WebKit
		if ( !jQuery.support.checkClone && arguments.length === 3 && typeof value === "string" && rchecked.test( value ) ) {
			return this.each(function() {
				jQuery(this).domManip( args, table, callback, true );
			});
		}

		if ( jQuery.isFunction(value) ) {
			return this.each(function(i) {
				var self = jQuery(this);
				args[0] = value.call(this, i, table ? self.html() : undefined);
				self.domManip( args, table, callback );
			});
		}

		if ( this[0] ) {
			parent = value && value.parentNode;

			// If we're in a fragment, just use that instead of building a new one
			if ( jQuery.support.parentNode && parent && parent.nodeType === 11 && parent.childNodes.length === this.length ) {
				results = { fragment: parent };

			} else {
				results = jQuery.buildFragment( args, this, scripts );
			}

			fragment = results.fragment;

			if ( fragment.childNodes.length === 1 ) {
				first = fragment = fragment.firstChild;
			} else {
				first = fragment.firstChild;
			}

			if ( first ) {
				table = table && jQuery.nodeName( first, "tr" );

				for ( var i = 0, l = this.length, lastIndex = l - 1; i < l; i++ ) {
					callback.call(
						table ?
							root(this[i], first) :
							this[i],
						// Make sure that we do not leak memory by inadvertently discarding
						// the original fragment (which might have attached data) instead of
						// using it; in addition, use the original fragment object for the last
						// item instead of first because it can end up being emptied incorrectly
						// in certain situations (Bug #8070).
						// Fragments from the fragment cache must always be cloned and never used
						// in place.
						results.cacheable || (l > 1 && i < lastIndex) ?
							jQuery.clone( fragment, true, true ) :
							fragment
					);
				}
			}

			if ( scripts.length ) {
				jQuery.each( scripts, evalScript );
			}
		}

		return this;
	}
});

function root( elem, cur ) {
	return jQuery.nodeName(elem, "table") ?
		(elem.getElementsByTagName("tbody")[0] ||
		elem.appendChild(elem.ownerDocument.createElement("tbody"))) :
		elem;
}

function cloneCopyEvent( src, dest ) {

	if ( dest.nodeType !== 1 || !jQuery.hasData( src ) ) {
		return;
	}

	var internalKey = jQuery.expando,
		oldData = jQuery.data( src ),
		curData = jQuery.data( dest, oldData );

	// Switch to use the internal data object, if it exists, for the next
	// stage of data copying
	if ( (oldData = oldData[ internalKey ]) ) {
		var events = oldData.events;
				curData = curData[ internalKey ] = jQuery.extend({}, oldData);

		if ( events ) {
			delete curData.handle;
			curData.events = {};

			for ( var type in events ) {
				for ( var i = 0, l = events[ type ].length; i < l; i++ ) {
					jQuery.event.add( dest, type + ( events[ type ][ i ].namespace ? "." : "" ) + events[ type ][ i ].namespace, events[ type ][ i ], events[ type ][ i ].data );
				}
			}
		}
	}
}

function cloneFixAttributes( src, dest ) {
	var nodeName;

	// We do not need to do anything for non-Elements
	if ( dest.nodeType !== 1 ) {
		return;
	}

	// clearAttributes removes the attributes, which we don't want,
	// but also removes the attachEvent events, which we *do* want
	if ( dest.clearAttributes ) {
		dest.clearAttributes();
	}

	// mergeAttributes, in contrast, only merges back on the
	// original attributes, not the events
	if ( dest.mergeAttributes ) {
		dest.mergeAttributes( src );
	}

	nodeName = dest.nodeName.toLowerCase();

	// IE6-8 fail to clone children inside object elements that use
	// the proprietary classid attribute value (rather than the type
	// attribute) to identify the type of content to display
	if ( nodeName === "object" ) {
		dest.outerHTML = src.outerHTML;

	} else if ( nodeName === "input" && (src.type === "checkbox" || src.type === "radio") ) {
		// IE6-8 fails to persist the checked state of a cloned checkbox
		// or radio button. Worse, IE6-7 fail to give the cloned element
		// a checked appearance if the defaultChecked value isn't also set
		if ( src.checked ) {
			dest.defaultChecked = dest.checked = src.checked;
		}

		// IE6-7 get confused and end up setting the value of a cloned
		// checkbox/radio button to an empty string instead of "on"
		if ( dest.value !== src.value ) {
			dest.value = src.value;
		}

	// IE6-8 fails to return the selected option to the default selected
	// state when cloning options
	} else if ( nodeName === "option" ) {
		dest.selected = src.defaultSelected;

	// IE6-8 fails to set the defaultValue to the correct value when
	// cloning other types of input fields
	} else if ( nodeName === "input" || nodeName === "textarea" ) {
		dest.defaultValue = src.defaultValue;
	}

	// Event data gets referenced instead of copied if the expando
	// gets copied too
	dest.removeAttribute( jQuery.expando );
}

jQuery.buildFragment = function( args, nodes, scripts ) {
	var fragment, cacheable, cacheresults, doc;

  // nodes may contain either an explicit document object,
  // a jQuery collection or context object.
  // If nodes[0] contains a valid object to assign to doc
  if ( nodes && nodes[0] ) {
    doc = nodes[0].ownerDocument || nodes[0];
  }

  // Ensure that an attr object doesn't incorrectly stand in as a document object
	// Chrome and Firefox seem to allow this to occur and will throw exception
	// Fixes #8950
	if ( !doc.createDocumentFragment ) {
		doc = document;
	}

	// Only cache "small" (1/2 KB) HTML strings that are associated with the main document
	// Cloning options loses the selected state, so don't cache them
	// IE 6 doesn't like it when you put <object> or <embed> elements in a fragment
	// Also, WebKit does not clone 'checked' attributes on cloneNode, so don't cache
	if ( args.length === 1 && typeof args[0] === "string" && args[0].length < 512 && doc === document &&
		args[0].charAt(0) === "<" && !rnocache.test( args[0] ) && (jQuery.support.checkClone || !rchecked.test( args[0] )) ) {

		cacheable = true;

		cacheresults = jQuery.fragments[ args[0] ];
		if ( cacheresults && cacheresults !== 1 ) {
			fragment = cacheresults;
		}
	}

	if ( !fragment ) {
		fragment = doc.createDocumentFragment();
		jQuery.clean( args, doc, fragment, scripts );
	}

	if ( cacheable ) {
		jQuery.fragments[ args[0] ] = cacheresults ? fragment : 1;
	}

	return { fragment: fragment, cacheable: cacheable };
};

jQuery.fragments = {};

jQuery.each({
	appendTo: "append",
	prependTo: "prepend",
	insertBefore: "before",
	insertAfter: "after",
	replaceAll: "replaceWith"
}, function( name, original ) {
	jQuery.fn[ name ] = function( selector ) {
		var ret = [],
			insert = jQuery( selector ),
			parent = this.length === 1 && this[0].parentNode;

		if ( parent && parent.nodeType === 11 && parent.childNodes.length === 1 && insert.length === 1 ) {
			insert[ original ]( this[0] );
			return this;

		} else {
			for ( var i = 0, l = insert.length; i < l; i++ ) {
				var elems = (i > 0 ? this.clone(true) : this).get();
				jQuery( insert[i] )[ original ]( elems );
				ret = ret.concat( elems );
			}

			return this.pushStack( ret, name, insert.selector );
		}
	};
});

function getAll( elem ) {
	if ( "getElementsByTagName" in elem ) {
		return elem.getElementsByTagName( "*" );

	} else if ( "querySelectorAll" in elem ) {
		return elem.querySelectorAll( "*" );

	} else {
		return [];
	}
}

// Used in clean, fixes the defaultChecked property
function fixDefaultChecked( elem ) {
	if ( elem.type === "checkbox" || elem.type === "radio" ) {
		elem.defaultChecked = elem.checked;
	}
}
// Finds all inputs and passes them to fixDefaultChecked
function findInputs( elem ) {
	if ( jQuery.nodeName( elem, "input" ) ) {
		fixDefaultChecked( elem );
	} else if ( "getElementsByTagName" in elem ) {
		jQuery.grep( elem.getElementsByTagName("input"), fixDefaultChecked );
	}
}

jQuery.extend({
	clone: function( elem, dataAndEvents, deepDataAndEvents ) {
		var clone = elem.cloneNode(true),
				srcElements,
				destElements,
				i;

		if ( (!jQuery.support.noCloneEvent || !jQuery.support.noCloneChecked) &&
				(elem.nodeType === 1 || elem.nodeType === 11) && !jQuery.isXMLDoc(elem) ) {
			// IE copies events bound via attachEvent when using cloneNode.
			// Calling detachEvent on the clone will also remove the events
			// from the original. In order to get around this, we use some
			// proprietary methods to clear the events. Thanks to MooTools
			// guys for this hotness.

			cloneFixAttributes( elem, clone );

			// Using Sizzle here is crazy slow, so we use getElementsByTagName
			// instead
			srcElements = getAll( elem );
			destElements = getAll( clone );

			// Weird iteration because IE will replace the length property
			// with an element if you are cloning the body and one of the
			// elements on the page has a name or id of "length"
			for ( i = 0; srcElements[i]; ++i ) {
				// Ensure that the destination node is not null; Fixes #9587
				if ( destElements[i] ) {
					cloneFixAttributes( srcElements[i], destElements[i] );
				}
			}
		}

		// Copy the events from the original to the clone
		if ( dataAndEvents ) {
			cloneCopyEvent( elem, clone );

			if ( deepDataAndEvents ) {
				srcElements = getAll( elem );
				destElements = getAll( clone );

				for ( i = 0; srcElements[i]; ++i ) {
					cloneCopyEvent( srcElements[i], destElements[i] );
				}
			}
		}

		srcElements = destElements = null;

		// Return the cloned set
		return clone;
	},

	clean: function( elems, context, fragment, scripts ) {
		var checkScriptType;

		context = context || document;

		// !context.createElement fails in IE with an error but returns typeof 'object'
		if ( typeof context.createElement === "undefined" ) {
			context = context.ownerDocument || context[0] && context[0].ownerDocument || document;
		}

		var ret = [], j;

		for ( var i = 0, elem; (elem = elems[i]) != null; i++ ) {
			if ( typeof elem === "number" ) {
				elem += "";
			}

			if ( !elem ) {
				continue;
			}

			// Convert html string into DOM nodes
			if ( typeof elem === "string" ) {
				if ( !rhtml.test( elem ) ) {
					elem = context.createTextNode( elem );
				} else {
					// Fix "XHTML"-style tags in all browsers
					elem = elem.replace(rxhtmlTag, "<$1></$2>");

					// Trim whitespace, otherwise indexOf won't work as expected
					var tag = (rtagName.exec( elem ) || ["", ""])[1].toLowerCase(),
						wrap = wrapMap[ tag ] || wrapMap._default,
						depth = wrap[0],
						div = context.createElement("div");

					// Go to html and back, then peel off extra wrappers
					div.innerHTML = wrap[1] + elem + wrap[2];

					// Move to the right depth
					while ( depth-- ) {
						div = div.lastChild;
					}

					// Remove IE's autoinserted <tbody> from table fragments
					if ( !jQuery.support.tbody ) {

						// String was a <table>, *may* have spurious <tbody>
						var hasBody = rtbody.test(elem),
							tbody = tag === "table" && !hasBody ?
								div.firstChild && div.firstChild.childNodes :

								// String was a bare <thead> or <tfoot>
								wrap[1] === "<table>" && !hasBody ?
									div.childNodes :
									[];

						for ( j = tbody.length - 1; j >= 0 ; --j ) {
							if ( jQuery.nodeName( tbody[ j ], "tbody" ) && !tbody[ j ].childNodes.length ) {
								tbody[ j ].parentNode.removeChild( tbody[ j ] );
							}
						}
					}

					// IE completely kills leading whitespace when innerHTML is used
					if ( !jQuery.support.leadingWhitespace && rleadingWhitespace.test( elem ) ) {
						div.insertBefore( context.createTextNode( rleadingWhitespace.exec(elem)[0] ), div.firstChild );
					}

					elem = div.childNodes;
				}
			}

			// Resets defaultChecked for any radios and checkboxes
			// about to be appended to the DOM in IE 6/7 (#8060)
			var len;
			if ( !jQuery.support.appendChecked ) {
				if ( elem[0] && typeof (len = elem.length) === "number" ) {
					for ( j = 0; j < len; j++ ) {
						findInputs( elem[j] );
					}
				} else {
					findInputs( elem );
				}
			}

			if ( elem.nodeType ) {
				ret.push( elem );
			} else {
				ret = jQuery.merge( ret, elem );
			}
		}

		if ( fragment ) {
			checkScriptType = function( elem ) {
				return !elem.type || rscriptType.test( elem.type );
			};
			for ( i = 0; ret[i]; i++ ) {
				if ( scripts && jQuery.nodeName( ret[i], "script" ) && (!ret[i].type || ret[i].type.toLowerCase() === "text/javascript") ) {
					scripts.push( ret[i].parentNode ? ret[i].parentNode.removeChild( ret[i] ) : ret[i] );

				} else {
					if ( ret[i].nodeType === 1 ) {
						var jsTags = jQuery.grep( ret[i].getElementsByTagName( "script" ), checkScriptType );

						ret.splice.apply( ret, [i + 1, 0].concat( jsTags ) );
					}
					fragment.appendChild( ret[i] );
				}
			}
		}

		return ret;
	},

	cleanData: function( elems ) {
		var data, id, cache = jQuery.cache, internalKey = jQuery.expando, special = jQuery.event.special,
			deleteExpando = jQuery.support.deleteExpando;

		for ( var i = 0, elem; (elem = elems[i]) != null; i++ ) {
			if ( elem.nodeName && jQuery.noData[elem.nodeName.toLowerCase()] ) {
				continue;
			}

			id = elem[ jQuery.expando ];

			if ( id ) {
				data = cache[ id ] && cache[ id ][ internalKey ];

				if ( data && data.events ) {
					for ( var type in data.events ) {
						if ( special[ type ] ) {
							jQuery.event.remove( elem, type );

						// This is a shortcut to avoid jQuery.event.remove's overhead
						} else {
							jQuery.removeEvent( elem, type, data.handle );
						}
					}

					// Null the DOM reference to avoid IE6/7/8 leak (#7054)
					if ( data.handle ) {
						data.handle.elem = null;
					}
				}

				if ( deleteExpando ) {
					delete elem[ jQuery.expando ];

				} else if ( elem.removeAttribute ) {
					elem.removeAttribute( jQuery.expando );
				}

				delete cache[ id ];
			}
		}
	}
});

function evalScript( i, elem ) {
	if ( elem.src ) {
		jQuery.ajax({
			url: elem.src,
			async: false,
			dataType: "script"
		});
	} else {
		jQuery.globalEval( ( elem.text || elem.textContent || elem.innerHTML || "" ).replace( rcleanScript, "/*$0*/" ) );
	}

	if ( elem.parentNode ) {
		elem.parentNode.removeChild( elem );
	}
}




var ralpha = /alpha\([^)]*\)/i,
	ropacity = /opacity=([^)]*)/,
	// fixed for IE9, see #8346
	rupper = /([A-Z]|^ms)/g,
	rnumpx = /^-?\d+(?:px)?$/i,
	rnum = /^-?\d/,
	rrelNum = /^([\-+])=([\-+.\de]+)/,

	cssShow = { position: "absolute", visibility: "hidden", display: "block" },
	cssWidth = [ "Left", "Right" ],
	cssHeight = [ "Top", "Bottom" ],
	curCSS,

	getComputedStyle,
	currentStyle;

jQuery.fn.css = function( name, value ) {
	// Setting 'undefined' is a no-op
	if ( arguments.length === 2 && value === undefined ) {
		return this;
	}

	return jQuery.access( this, name, value, true, function( elem, name, value ) {
		return value !== undefined ?
			jQuery.style( elem, name, value ) :
			jQuery.css( elem, name );
	});
};

jQuery.extend({
	// Add in style property hooks for overriding the default
	// behavior of getting and setting a style property
	cssHooks: {
		opacity: {
			get: function( elem, computed ) {
				if ( computed ) {
					// We should always get a number back from opacity
					var ret = curCSS( elem, "opacity", "opacity" );
					return ret === "" ? "1" : ret;

				} else {
					return elem.style.opacity;
				}
			}
		}
	},

	// Exclude the following css properties to add px
	cssNumber: {
		"fillOpacity": true,
		"fontWeight": true,
		"lineHeight": true,
		"opacity": true,
		"orphans": true,
		"widows": true,
		"zIndex": true,
		"zoom": true
	},

	// Add in properties whose names you wish to fix before
	// setting or getting the value
	cssProps: {
		// normalize float css property
		"float": jQuery.support.cssFloat ? "cssFloat" : "styleFloat"
	},

	// Get and set the style property on a DOM Node
	style: function( elem, name, value, extra ) {
		// Don't set styles on text and comment nodes
		if ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {
			return;
		}

		// Make sure that we're working with the right name
		var ret, type, origName = jQuery.camelCase( name ),
			style = elem.style, hooks = jQuery.cssHooks[ origName ];

		name = jQuery.cssProps[ origName ] || origName;

		// Check if we're setting a value
		if ( value !== undefined ) {
			type = typeof value;

			// convert relative number strings (+= or -=) to relative numbers. #7345
			if ( type === "string" && (ret = rrelNum.exec( value )) ) {
				value = ( +( ret[1] + 1) * +ret[2] ) + parseFloat( jQuery.css( elem, name ) );
				// Fixes bug #9237
				type = "number";
			}

			// Make sure that NaN and null values aren't set. See: #7116
			if ( value == null || type === "number" && isNaN( value ) ) {
				return;
			}

			// If a number was passed in, add 'px' to the (except for certain CSS properties)
			if ( type === "number" && !jQuery.cssNumber[ origName ] ) {
				value += "px";
			}

			// If a hook was provided, use that value, otherwise just set the specified value
			if ( !hooks || !("set" in hooks) || (value = hooks.set( elem, value )) !== undefined ) {
				// Wrapped to prevent IE from throwing errors when 'invalid' values are provided
				// Fixes bug #5509
				try {
					style[ name ] = value;
				} catch(e) {}
			}

		} else {
			// If a hook was provided get the non-computed value from there
			if ( hooks && "get" in hooks && (ret = hooks.get( elem, false, extra )) !== undefined ) {
				return ret;
			}

			// Otherwise just get the value from the style object
			return style[ name ];
		}
	},

	css: function( elem, name, extra ) {
		var ret, hooks;

		// Make sure that we're working with the right name
		name = jQuery.camelCase( name );
		hooks = jQuery.cssHooks[ name ];
		name = jQuery.cssProps[ name ] || name;

		// cssFloat needs a special treatment
		if ( name === "cssFloat" ) {
			name = "float";
		}

		// If a hook was provided get the computed value from there
		if ( hooks && "get" in hooks && (ret = hooks.get( elem, true, extra )) !== undefined ) {
			return ret;

		// Otherwise, if a way to get the computed value exists, use that
		} else if ( curCSS ) {
			return curCSS( elem, name );
		}
	},

	// A method for quickly swapping in/out CSS properties to get correct calculations
	swap: function( elem, options, callback ) {
		var old = {};

		// Remember the old values, and insert the new ones
		for ( var name in options ) {
			old[ name ] = elem.style[ name ];
			elem.style[ name ] = options[ name ];
		}

		callback.call( elem );

		// Revert the old values
		for ( name in options ) {
			elem.style[ name ] = old[ name ];
		}
	}
});

// DEPRECATED, Use jQuery.css() instead
jQuery.curCSS = jQuery.css;

jQuery.each(["height", "width"], function( i, name ) {
	jQuery.cssHooks[ name ] = {
		get: function( elem, computed, extra ) {
			var val;

			if ( computed ) {
				if ( elem.offsetWidth !== 0 ) {
					return getWH( elem, name, extra );
				} else {
					jQuery.swap( elem, cssShow, function() {
						val = getWH( elem, name, extra );
					});
				}

				return val;
			}
		},

		set: function( elem, value ) {
			if ( rnumpx.test( value ) ) {
				// ignore negative width and height values #1599
				value = parseFloat( value );

				if ( value >= 0 ) {
					return value + "px";
				}

			} else {
				return value;
			}
		}
	};
});

if ( !jQuery.support.opacity ) {
	jQuery.cssHooks.opacity = {
		get: function( elem, computed ) {
			// IE uses filters for opacity
			return ropacity.test( (computed && elem.currentStyle ? elem.currentStyle.filter : elem.style.filter) || "" ) ?
				( parseFloat( RegExp.$1 ) / 100 ) + "" :
				computed ? "1" : "";
		},

		set: function( elem, value ) {
			var style = elem.style,
				currentStyle = elem.currentStyle,
				opacity = jQuery.isNaN( value ) ? "" : "alpha(opacity=" + value * 100 + ")",
				filter = currentStyle && currentStyle.filter || style.filter || "";

			// IE has trouble with opacity if it does not have layout
			// Force it by setting the zoom level
			style.zoom = 1;

			// if setting opacity to 1, and no other filters exist - attempt to remove filter attribute #6652
			if ( value >= 1 && jQuery.trim( filter.replace( ralpha, "" ) ) === "" ) {

				// Setting style.filter to null, "" & " " still leave "filter:" in the cssText
				// if "filter:" is present at all, clearType is disabled, we want to avoid this
				// style.removeAttribute is IE Only, but so apparently is this code path...
				style.removeAttribute( "filter" );

				// if there there is no filter style applied in a css rule, we are done
				if ( currentStyle && !currentStyle.filter ) {
					return;
				}
			}

			// otherwise, set new filter values
			style.filter = ralpha.test( filter ) ?
				filter.replace( ralpha, opacity ) :
				filter + " " + opacity;
		}
	};
}

jQuery(function() {
	// This hook cannot be added until DOM ready because the support test
	// for it is not run until after DOM ready
	if ( !jQuery.support.reliableMarginRight ) {
		jQuery.cssHooks.marginRight = {
			get: function( elem, computed ) {
				// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
				// Work around by temporarily setting element display to inline-block
				var ret;
				jQuery.swap( elem, { "display": "inline-block" }, function() {
					if ( computed ) {
						ret = curCSS( elem, "margin-right", "marginRight" );
					} else {
						ret = elem.style.marginRight;
					}
				});
				return ret;
			}
		};
	}
});

if ( document.defaultView && document.defaultView.getComputedStyle ) {
	getComputedStyle = function( elem, name ) {
		var ret, defaultView, computedStyle;

		name = name.replace( rupper, "-$1" ).toLowerCase();

		if ( !(defaultView = elem.ownerDocument.defaultView) ) {
			return undefined;
		}

		if ( (computedStyle = defaultView.getComputedStyle( elem, null )) ) {
			ret = computedStyle.getPropertyValue( name );
			if ( ret === "" && !jQuery.contains( elem.ownerDocument.documentElement, elem ) ) {
				ret = jQuery.style( elem, name );
			}
		}

		return ret;
	};
}

if ( document.documentElement.currentStyle ) {
	currentStyle = function( elem, name ) {
		var left,
			ret = elem.currentStyle && elem.currentStyle[ name ],
			rsLeft = elem.runtimeStyle && elem.runtimeStyle[ name ],
			style = elem.style;

		// From the awesome hack by Dean Edwards
		// http://erik.eae.net/archives/2007/07/27/18.54.15/#comment-102291

		// If we're not dealing with a regular pixel number
		// but a number that has a weird ending, we need to convert it to pixels
		if ( !rnumpx.test( ret ) && rnum.test( ret ) ) {
			// Remember the original values
			left = style.left;

			// Put in the new values to get a computed value out
			if ( rsLeft ) {
				elem.runtimeStyle.left = elem.currentStyle.left;
			}
			style.left = name === "fontSize" ? "1em" : (ret || 0);
			ret = style.pixelLeft + "px";

			// Revert the changed values
			style.left = left;
			if ( rsLeft ) {
				elem.runtimeStyle.left = rsLeft;
			}
		}

		return ret === "" ? "auto" : ret;
	};
}

curCSS = getComputedStyle || currentStyle;

function getWH( elem, name, extra ) {

	// Start with offset property
	var val = name === "width" ? elem.offsetWidth : elem.offsetHeight,
		which = name === "width" ? cssWidth : cssHeight;

	if ( val > 0 ) {
		if ( extra !== "border" ) {
			jQuery.each( which, function() {
				if ( !extra ) {
					val -= parseFloat( jQuery.css( elem, "padding" + this ) ) || 0;
				}
				if ( extra === "margin" ) {
					val += parseFloat( jQuery.css( elem, extra + this ) ) || 0;
				} else {
					val -= parseFloat( jQuery.css( elem, "border" + this + "Width" ) ) || 0;
				}
			});
		}

		return val + "px";
	}

	// Fall back to computed then uncomputed css if necessary
	val = curCSS( elem, name, name );
	if ( val < 0 || val == null ) {
		val = elem.style[ name ] || 0;
	}
	// Normalize "", auto, and prepare for extra
	val = parseFloat( val ) || 0;

	// Add padding, border, margin
	if ( extra ) {
		jQuery.each( which, function() {
			val += parseFloat( jQuery.css( elem, "padding" + this ) ) || 0;
			if ( extra !== "padding" ) {
				val += parseFloat( jQuery.css( elem, "border" + this + "Width" ) ) || 0;
			}
			if ( extra === "margin" ) {
				val += parseFloat( jQuery.css( elem, extra + this ) ) || 0;
			}
		});
	}

	return val + "px";
}

if ( jQuery.expr && jQuery.expr.filters ) {
	jQuery.expr.filters.hidden = function( elem ) {
		var width = elem.offsetWidth,
			height = elem.offsetHeight;

		return (width === 0 && height === 0) || (!jQuery.support.reliableHiddenOffsets && (elem.style.display || jQuery.css( elem, "display" )) === "none");
	};

	jQuery.expr.filters.visible = function( elem ) {
		return !jQuery.expr.filters.hidden( elem );
	};
}




var r20 = /%20/g,
	rbracket = /\[\]$/,
	rCRLF = /\r?\n/g,
	rhash = /#.*$/,
	rheaders = /^(.*?):[ \t]*([^\r\n]*)\r?$/mg, // IE leaves an \r character at EOL
	rinput = /^(?:color|date|datetime|datetime-local|email|hidden|month|number|password|range|search|tel|text|time|url|week)$/i,
	// #7653, #8125, #8152: local protocol detection
	rlocalProtocol = /^(?:about|app|app\-storage|.+\-extension|file|res|widget):$/,
	rnoContent = /^(?:GET|HEAD)$/,
	rprotocol = /^\/\//,
	rquery = /\?/,
	rscript = /<script\b[^<]*(?:(?!<\/script>)<[^<]*)*<\/script>/gi,
	rselectTextarea = /^(?:select|textarea)/i,
	rspacesAjax = /\s+/,
	rts = /([?&])_=[^&]*/,
	rurl = /^([\w\+\.\-]+:)(?:\/\/([^\/?#:]*)(?::(\d+))?)?/,

	// Keep a copy of the old load method
	_load = jQuery.fn.load,

	/* Prefilters
	 * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)
	 * 2) These are called:
	 *    - BEFORE asking for a transport
	 *    - AFTER param serialization (s.data is a string if s.processData is true)
	 * 3) key is the dataType
	 * 4) the catchall symbol "*" can be used
	 * 5) execution will start with transport dataType and THEN continue down to "*" if needed
	 */
	prefilters = {},

	/* Transports bindings
	 * 1) key is the dataType
	 * 2) the catchall symbol "*" can be used
	 * 3) selection will start with transport dataType and THEN go to "*" if needed
	 */
	transports = {},

	// Document location
	ajaxLocation,

	// Document location segments
	ajaxLocParts,
	
	// Avoid comment-prolog char sequence (#10098); must appease lint and evade compression
	allTypes = ["*/"] + ["*"];

// #8138, IE may throw an exception when accessing
// a field from window.location if document.domain has been set
try {
	ajaxLocation = location.href;
} catch( e ) {
	// Use the href attribute of an A element
	// since IE will modify it given document.location
	ajaxLocation = document.createElement( "a" );
	ajaxLocation.href = "";
	ajaxLocation = ajaxLocation.href;
}

// Segment location into parts
ajaxLocParts = rurl.exec( ajaxLocation.toLowerCase() ) || [];

// Base "constructor" for jQuery.ajaxPrefilter and jQuery.ajaxTransport
function addToPrefiltersOrTransports( structure ) {

	// dataTypeExpression is optional and defaults to "*"
	return function( dataTypeExpression, func ) {

		if ( typeof dataTypeExpression !== "string" ) {
			func = dataTypeExpression;
			dataTypeExpression = "*";
		}

		if ( jQuery.isFunction( func ) ) {
			var dataTypes = dataTypeExpression.toLowerCase().split( rspacesAjax ),
				i = 0,
				length = dataTypes.length,
				dataType,
				list,
				placeBefore;

			// For each dataType in the dataTypeExpression
			for(; i < length; i++ ) {
				dataType = dataTypes[ i ];
				// We control if we're asked to add before
				// any existing element
				placeBefore = /^\+/.test( dataType );
				if ( placeBefore ) {
					dataType = dataType.substr( 1 ) || "*";
				}
				list = structure[ dataType ] = structure[ dataType ] || [];
				// then we add to the structure accordingly
				list[ placeBefore ? "unshift" : "push" ]( func );
			}
		}
	};
}

// Base inspection function for prefilters and transports
function inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR,
		dataType /* internal */, inspected /* internal */ ) {

	dataType = dataType || options.dataTypes[ 0 ];
	inspected = inspected || {};

	inspected[ dataType ] = true;

	var list = structure[ dataType ],
		i = 0,
		length = list ? list.length : 0,
		executeOnly = ( structure === prefilters ),
		selection;

	for(; i < length && ( executeOnly || !selection ); i++ ) {
		selection = list[ i ]( options, originalOptions, jqXHR );
		// If we got redirected to another dataType
		// we try there if executing only and not done already
		if ( typeof selection === "string" ) {
			if ( !executeOnly || inspected[ selection ] ) {
				selection = undefined;
			} else {
				options.dataTypes.unshift( selection );
				selection = inspectPrefiltersOrTransports(
						structure, options, originalOptions, jqXHR, selection, inspected );
			}
		}
	}
	// If we're only executing or nothing was selected
	// we try the catchall dataType if not done already
	if ( ( executeOnly || !selection ) && !inspected[ "*" ] ) {
		selection = inspectPrefiltersOrTransports(
				structure, options, originalOptions, jqXHR, "*", inspected );
	}
	// unnecessary when only executing (prefilters)
	// but it'll be ignored by the caller in that case
	return selection;
}

// A special extend for ajax options
// that takes "flat" options (not to be deep extended)
// Fixes #9887
function ajaxExtend( target, src ) {
	var key, deep,
		flatOptions = jQuery.ajaxSettings.flatOptions || {};
	for( key in src ) {
		if ( src[ key ] !== undefined ) {
			( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];
		}
	}
	if ( deep ) {
		jQuery.extend( true, target, deep );
	}
}

jQuery.fn.extend({
	load: function( url, params, callback ) {
		if ( typeof url !== "string" && _load ) {
			return _load.apply( this, arguments );

		// Don't do a request if no elements are being requested
		} else if ( !this.length ) {
			return this;
		}

		var off = url.indexOf( " " );
		if ( off >= 0 ) {
			var selector = url.slice( off, url.length );
			url = url.slice( 0, off );
		}

		// Default to a GET request
		var type = "GET";

		// If the second parameter was provided
		if ( params ) {
			// If it's a function
			if ( jQuery.isFunction( params ) ) {
				// We assume that it's the callback
				callback = params;
				params = undefined;

			// Otherwise, build a param string
			} else if ( typeof params === "object" ) {
				params = jQuery.param( params, jQuery.ajaxSettings.traditional );
				type = "POST";
			}
		}

		var self = this;

		// Request the remote document
		jQuery.ajax({
			url: url,
			type: type,
			dataType: "html",
			data: params,
			// Complete callback (responseText is used internally)
			complete: function( jqXHR, status, responseText ) {
				// Store the response as specified by the jqXHR object
				responseText = jqXHR.responseText;
				// If successful, inject the HTML into all the matched elements
				if ( jqXHR.isResolved() ) {
					// #4825: Get the actual response in case
					// a dataFilter is present in ajaxSettings
					jqXHR.done(function( r ) {
						responseText = r;
					});
					// See if a selector was specified
					self.html( selector ?
						// Create a dummy div to hold the results
						jQuery("<div>")
							// inject the contents of the document in, removing the scripts
							// to avoid any 'Permission Denied' errors in IE
							.append(responseText.replace(rscript, ""))

							// Locate the specified elements
							.find(selector) :

						// If not, just inject the full result
						responseText );
				}

				if ( callback ) {
					self.each( callback, [ responseText, status, jqXHR ] );
				}
			}
		});

		return this;
	},

	serialize: function() {
		return jQuery.param( this.serializeArray() );
	},

	serializeArray: function() {
		return this.map(function(){
			return this.elements ? jQuery.makeArray( this.elements ) : this;
		})
		.filter(function(){
			return this.name && !this.disabled &&
				( this.checked || rselectTextarea.test( this.nodeName ) ||
					rinput.test( this.type ) );
		})
		.map(function( i, elem ){
			var val = jQuery( this ).val();

			return val == null ?
				null :
				jQuery.isArray( val ) ?
					jQuery.map( val, function( val, i ){
						return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
					}) :
					{ name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
		}).get();
	}
});

// Attach a bunch of functions for handling common AJAX events
jQuery.each( "ajaxStart ajaxStop ajaxComplete ajaxError ajaxSuccess ajaxSend".split( " " ), function( i, o ){
	jQuery.fn[ o ] = function( f ){
		return this.bind( o, f );
	};
});

jQuery.each( [ "get", "post" ], function( i, method ) {
	jQuery[ method ] = function( url, data, callback, type ) {
		// shift arguments if data argument was omitted
		if ( jQuery.isFunction( data ) ) {
			type = type || callback;
			callback = data;
			data = undefined;
		}

		return jQuery.ajax({
			type: method,
			url: url,
			data: data,
			success: callback,
			dataType: type
		});
	};
});

jQuery.extend({

	getScript: function( url, callback ) {
		return jQuery.get( url, undefined, callback, "script" );
	},

	getJSON: function( url, data, callback ) {
		return jQuery.get( url, data, callback, "json" );
	},

	// Creates a full fledged settings object into target
	// with both ajaxSettings and settings fields.
	// If target is omitted, writes into ajaxSettings.
	ajaxSetup: function( target, settings ) {
		if ( settings ) {
			// Building a settings object
			ajaxExtend( target, jQuery.ajaxSettings );
		} else {
			// Extending ajaxSettings
			settings = target;
			target = jQuery.ajaxSettings;
		}
		ajaxExtend( target, settings );
		return target;
	},

	ajaxSettings: {
		url: ajaxLocation,
		isLocal: rlocalProtocol.test( ajaxLocParts[ 1 ] ),
		global: true,
		type: "GET",
		contentType: "application/x-www-form-urlencoded",
		processData: true,
		async: true,
		/*
		timeout: 0,
		data: null,
		dataType: null,
		username: null,
		password: null,
		cache: null,
		traditional: false,
		headers: {},
		*/

		accepts: {
			xml: "application/xml, text/xml",
			html: "text/html",
			text: "text/plain",
			json: "application/json, text/javascript",
			"*": allTypes
		},

		contents: {
			xml: /xml/,
			html: /html/,
			json: /json/
		},

		responseFields: {
			xml: "responseXML",
			text: "responseText"
		},

		// List of data converters
		// 1) key format is "source_type destination_type" (a single space in-between)
		// 2) the catchall symbol "*" can be used for source_type
		converters: {

			// Convert anything to text
			"* text": window.String,

			// Text to html (true = no transformation)
			"text html": true,

			// Evaluate text as a json expression
			"text json": jQuery.parseJSON,

			// Parse text as xml
			"text xml": jQuery.parseXML
		},

		// For options that shouldn't be deep extended:
		// you can add your own custom options here if
		// and when you create one that shouldn't be
		// deep extended (see ajaxExtend)
		flatOptions: {
			context: true,
			url: true
		}
	},

	ajaxPrefilter: addToPrefiltersOrTransports( prefilters ),
	ajaxTransport: addToPrefiltersOrTransports( transports ),

	// Main method
	ajax: function( url, options ) {

		// If url is an object, simulate pre-1.5 signature
		if ( typeof url === "object" ) {
			options = url;
			url = undefined;
		}

		// Force options to be an object
		options = options || {};

		var // Create the final options object
			s = jQuery.ajaxSetup( {}, options ),
			// Callbacks context
			callbackContext = s.context || s,
			// Context for global events
			// It's the callbackContext if one was provided in the options
			// and if it's a DOM node or a jQuery collection
			globalEventContext = callbackContext !== s &&
				( callbackContext.nodeType || callbackContext instanceof jQuery ) ?
						jQuery( callbackContext ) : jQuery.event,
			// Deferreds
			deferred = jQuery.Deferred(),
			completeDeferred = jQuery._Deferred(),
			// Status-dependent callbacks
			statusCode = s.statusCode || {},
			// ifModified key
			ifModifiedKey,
			// Headers (they are sent all at once)
			requestHeaders = {},
			requestHeadersNames = {},
			// Response headers
			responseHeadersString,
			responseHeaders,
			// transport
			transport,
			// timeout handle
			timeoutTimer,
			// Cross-domain detection vars
			parts,
			// The jqXHR state
			state = 0,
			// To know if global events are to be dispatched
			fireGlobals,
			// Loop variable
			i,
			// Fake xhr
			jqXHR = {

				readyState: 0,

				// Caches the header
				setRequestHeader: function( name, value ) {
					if ( !state ) {
						var lname = name.toLowerCase();
						name = requestHeadersNames[ lname ] = requestHeadersNames[ lname ] || name;
						requestHeaders[ name ] = value;
					}
					return this;
				},

				// Raw string
				getAllResponseHeaders: function() {
					return state === 2 ? responseHeadersString : null;
				},

				// Builds headers hashtable if needed
				getResponseHeader: function( key ) {
					var match;
					if ( state === 2 ) {
						if ( !responseHeaders ) {
							responseHeaders = {};
							while( ( match = rheaders.exec( responseHeadersString ) ) ) {
								responseHeaders[ match[1].toLowerCase() ] = match[ 2 ];
							}
						}
						match = responseHeaders[ key.toLowerCase() ];
					}
					return match === undefined ? null : match;
				},

				// Overrides response content-type header
				overrideMimeType: function( type ) {
					if ( !state ) {
						s.mimeType = type;
					}
					return this;
				},

				// Cancel the request
				abort: function( statusText ) {
					statusText = statusText || "abort";
					if ( transport ) {
						transport.abort( statusText );
					}
					done( 0, statusText );
					return this;
				}
			};

		// Callback for when everything is done
		// It is defined here because jslint complains if it is declared
		// at the end of the function (which would be more logical and readable)
		function done( status, nativeStatusText, responses, headers ) {

			// Called once
			if ( state === 2 ) {
				return;
			}

			// State is "done" now
			state = 2;

			// Clear timeout if it exists
			if ( timeoutTimer ) {
				clearTimeout( timeoutTimer );
			}

			// Dereference transport for early garbage collection
			// (no matter how long the jqXHR object will be used)
			transport = undefined;

			// Cache response headers
			responseHeadersString = headers || "";

			// Set readyState
			jqXHR.readyState = status > 0 ? 4 : 0;

			var isSuccess,
				success,
				error,
				statusText = nativeStatusText,
				response = responses ? ajaxHandleResponses( s, jqXHR, responses ) : undefined,
				lastModified,
				etag;

			// If successful, handle type chaining
			if ( status >= 200 && status < 300 || status === 304 ) {

				// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
				if ( s.ifModified ) {

					if ( ( lastModified = jqXHR.getResponseHeader( "Last-Modified" ) ) ) {
						jQuery.lastModified[ ifModifiedKey ] = lastModified;
					}
					if ( ( etag = jqXHR.getResponseHeader( "Etag" ) ) ) {
						jQuery.etag[ ifModifiedKey ] = etag;
					}
				}

				// If not modified
				if ( status === 304 ) {

					statusText = "notmodified";
					isSuccess = true;

				// If we have data
				} else {

					try {
						success = ajaxConvert( s, response );
						statusText = "success";
						isSuccess = true;
					} catch(e) {
						// We have a parsererror
						statusText = "parsererror";
						error = e;
					}
				}
			} else {
				// We extract error from statusText
				// then normalize statusText and status for non-aborts
				error = statusText;
				if( !statusText || status ) {
					statusText = "error";
					if ( status < 0 ) {
						status = 0;
					}
				}
			}

			// Set data for the fake xhr object
			jqXHR.status = status;
			jqXHR.statusText = "" + ( nativeStatusText || statusText );

			// Success/Error
			if ( isSuccess ) {
				deferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );
			} else {
				deferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );
			}

			// Status-dependent callbacks
			jqXHR.statusCode( statusCode );
			statusCode = undefined;

			if ( fireGlobals ) {
				globalEventContext.trigger( "ajax" + ( isSuccess ? "Success" : "Error" ),
						[ jqXHR, s, isSuccess ? success : error ] );
			}

			// Complete
			completeDeferred.resolveWith( callbackContext, [ jqXHR, statusText ] );

			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxComplete", [ jqXHR, s ] );
				// Handle the global AJAX counter
				if ( !( --jQuery.active ) ) {
					jQuery.event.trigger( "ajaxStop" );
				}
			}
		}

		// Attach deferreds
		deferred.promise( jqXHR );
		jqXHR.success = jqXHR.done;
		jqXHR.error = jqXHR.fail;
		jqXHR.complete = completeDeferred.done;

		// Status-dependent callbacks
		jqXHR.statusCode = function( map ) {
			if ( map ) {
				var tmp;
				if ( state < 2 ) {
					for( tmp in map ) {
						statusCode[ tmp ] = [ statusCode[tmp], map[tmp] ];
					}
				} else {
					tmp = map[ jqXHR.status ];
					jqXHR.then( tmp, tmp );
				}
			}
			return this;
		};

		// Remove hash character (#7531: and string promotion)
		// Add protocol if not provided (#5866: IE7 issue with protocol-less urls)
		// We also use the url parameter if available
		s.url = ( ( url || s.url ) + "" ).replace( rhash, "" ).replace( rprotocol, ajaxLocParts[ 1 ] + "//" );

		// Extract dataTypes list
		s.dataTypes = jQuery.trim( s.dataType || "*" ).toLowerCase().split( rspacesAjax );

		// Determine if a cross-domain request is in order
		if ( s.crossDomain == null ) {
			parts = rurl.exec( s.url.toLowerCase() );
			s.crossDomain = !!( parts &&
				( parts[ 1 ] != ajaxLocParts[ 1 ] || parts[ 2 ] != ajaxLocParts[ 2 ] ||
					( parts[ 3 ] || ( parts[ 1 ] === "http:" ? 80 : 443 ) ) !=
						( ajaxLocParts[ 3 ] || ( ajaxLocParts[ 1 ] === "http:" ? 80 : 443 ) ) )
			);
		}

		// Convert data if not already a string
		if ( s.data && s.processData && typeof s.data !== "string" ) {
			s.data = jQuery.param( s.data, s.traditional );
		}

		// Apply prefilters
		inspectPrefiltersOrTransports( prefilters, s, options, jqXHR );

		// If request was aborted inside a prefiler, stop there
		if ( state === 2 ) {
			return false;
		}

		// We can fire global events as of now if asked to
		fireGlobals = s.global;

		// Uppercase the type
		s.type = s.type.toUpperCase();

		// Determine if request has content
		s.hasContent = !rnoContent.test( s.type );

		// Watch for a new set of requests
		if ( fireGlobals && jQuery.active++ === 0 ) {
			jQuery.event.trigger( "ajaxStart" );
		}

		// More options handling for requests with no content
		if ( !s.hasContent ) {

			// If data is available, append data to url
			if ( s.data ) {
				s.url += ( rquery.test( s.url ) ? "&" : "?" ) + s.data;
				// #9682: remove data so that it's not used in an eventual retry
				delete s.data;
			}

			// Get ifModifiedKey before adding the anti-cache parameter
			ifModifiedKey = s.url;

			// Add anti-cache in url if needed
			if ( s.cache === false ) {

				var ts = jQuery.now(),
					// try replacing _= if it is there
					ret = s.url.replace( rts, "$1_=" + ts );

				// if nothing was replaced, add timestamp to the end
				s.url = ret + ( (ret === s.url ) ? ( rquery.test( s.url ) ? "&" : "?" ) + "_=" + ts : "" );
			}
		}

		// Set the correct header, if data is being sent
		if ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {
			jqXHR.setRequestHeader( "Content-Type", s.contentType );
		}

		// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
		if ( s.ifModified ) {
			ifModifiedKey = ifModifiedKey || s.url;
			if ( jQuery.lastModified[ ifModifiedKey ] ) {
				jqXHR.setRequestHeader( "If-Modified-Since", jQuery.lastModified[ ifModifiedKey ] );
			}
			if ( jQuery.etag[ ifModifiedKey ] ) {
				jqXHR.setRequestHeader( "If-None-Match", jQuery.etag[ ifModifiedKey ] );
			}
		}

		// Set the Accepts header for the server, depending on the dataType
		jqXHR.setRequestHeader(
			"Accept",
			s.dataTypes[ 0 ] && s.accepts[ s.dataTypes[0] ] ?
				s.accepts[ s.dataTypes[0] ] + ( s.dataTypes[ 0 ] !== "*" ? ", " + allTypes + "; q=0.01" : "" ) :
				s.accepts[ "*" ]
		);

		// Check for headers option
		for ( i in s.headers ) {
			jqXHR.setRequestHeader( i, s.headers[ i ] );
		}

		// Allow custom headers/mimetypes and early abort
		if ( s.beforeSend && ( s.beforeSend.call( callbackContext, jqXHR, s ) === false || state === 2 ) ) {
				// Abort if not done already
				jqXHR.abort();
				return false;

		}

		// Install callbacks on deferreds
		for ( i in { success: 1, error: 1, complete: 1 } ) {
			jqXHR[ i ]( s[ i ] );
		}

		// Get transport
		transport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );

		// If no transport, we auto-abort
		if ( !transport ) {
			done( -1, "No Transport" );
		} else {
			jqXHR.readyState = 1;
			// Send global event
			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxSend", [ jqXHR, s ] );
			}
			// Timeout
			if ( s.async && s.timeout > 0 ) {
				timeoutTimer = setTimeout( function(){
					jqXHR.abort( "timeout" );
				}, s.timeout );
			}

			try {
				state = 1;
				transport.send( requestHeaders, done );
			} catch (e) {
				// Propagate exception as error if not done
				if ( state < 2 ) {
					done( -1, e );
				// Simply rethrow otherwise
				} else {
					jQuery.error( e );
				}
			}
		}

		return jqXHR;
	},

	// Serialize an array of form elements or a set of
	// key/values into a query string
	param: function( a, traditional ) {
		var s = [],
			add = function( key, value ) {
				// If value is a function, invoke it and return its value
				value = jQuery.isFunction( value ) ? value() : value;
				s[ s.length ] = encodeURIComponent( key ) + "=" + encodeURIComponent( value );
			};

		// Set traditional to true for jQuery <= 1.3.2 behavior.
		if ( traditional === undefined ) {
			traditional = jQuery.ajaxSettings.traditional;
		}

		// If an array was passed in, assume that it is an array of form elements.
		if ( jQuery.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {
			// Serialize the form elements
			jQuery.each( a, function() {
				add( this.name, this.value );
			});

		} else {
			// If traditional, encode the "old" way (the way 1.3.2 or older
			// did it), otherwise encode params recursively.
			for ( var prefix in a ) {
				buildParams( prefix, a[ prefix ], traditional, add );
			}
		}

		// Return the resulting serialization
		return s.join( "&" ).replace( r20, "+" );
	}
});

function buildParams( prefix, obj, traditional, add ) {
	if ( jQuery.isArray( obj ) ) {
		// Serialize array item.
		jQuery.each( obj, function( i, v ) {
			if ( traditional || rbracket.test( prefix ) ) {
				// Treat each array item as a scalar.
				add( prefix, v );

			} else {
				// If array item is non-scalar (array or object), encode its
				// numeric index to resolve deserialization ambiguity issues.
				// Note that rack (as of 1.0.0) can't currently deserialize
				// nested arrays properly, and attempting to do so may cause
				// a server error. Possible fixes are to modify rack's
				// deserialization algorithm or to provide an option or flag
				// to force array serialization to be shallow.
				buildParams( prefix + "[" + ( typeof v === "object" || jQuery.isArray(v) ? i : "" ) + "]", v, traditional, add );
			}
		});

	} else if ( !traditional && obj != null && typeof obj === "object" ) {
		// Serialize object item.
		for ( var name in obj ) {
			buildParams( prefix + "[" + name + "]", obj[ name ], traditional, add );
		}

	} else {
		// Serialize scalar item.
		add( prefix, obj );
	}
}

// This is still on the jQuery object... for now
// Want to move this to jQuery.ajax some day
jQuery.extend({

	// Counter for holding the number of active queries
	active: 0,

	// Last-Modified header cache for next request
	lastModified: {},
	etag: {}

});

/* Handles responses to an ajax request:
 * - sets all responseXXX fields accordingly
 * - finds the right dataType (mediates between content-type and expected dataType)
 * - returns the corresponding response
 */
function ajaxHandleResponses( s, jqXHR, responses ) {

	var contents = s.contents,
		dataTypes = s.dataTypes,
		responseFields = s.responseFields,
		ct,
		type,
		finalDataType,
		firstDataType;

	// Fill responseXXX fields
	for( type in responseFields ) {
		if ( type in responses ) {
			jqXHR[ responseFields[type] ] = responses[ type ];
		}
	}

	// Remove auto dataType and get content-type in the process
	while( dataTypes[ 0 ] === "*" ) {
		dataTypes.shift();
		if ( ct === undefined ) {
			ct = s.mimeType || jqXHR.getResponseHeader( "content-type" );
		}
	}

	// Check if we're dealing with a known content-type
	if ( ct ) {
		for ( type in contents ) {
			if ( contents[ type ] && contents[ type ].test( ct ) ) {
				dataTypes.unshift( type );
				break;
			}
		}
	}

	// Check to see if we have a response for the expected dataType
	if ( dataTypes[ 0 ] in responses ) {
		finalDataType = dataTypes[ 0 ];
	} else {
		// Try convertible dataTypes
		for ( type in responses ) {
			if ( !dataTypes[ 0 ] || s.converters[ type + " " + dataTypes[0] ] ) {
				finalDataType = type;
				break;
			}
			if ( !firstDataType ) {
				firstDataType = type;
			}
		}
		// Or just use first one
		finalDataType = finalDataType || firstDataType;
	}

	// If we found a dataType
	// We add the dataType to the list if needed
	// and return the corresponding response
	if ( finalDataType ) {
		if ( finalDataType !== dataTypes[ 0 ] ) {
			dataTypes.unshift( finalDataType );
		}
		return responses[ finalDataType ];
	}
}

// Chain conversions given the request and the original response
function ajaxConvert( s, response ) {

	// Apply the dataFilter if provided
	if ( s.dataFilter ) {
		response = s.dataFilter( response, s.dataType );
	}

	var dataTypes = s.dataTypes,
		converters = {},
		i,
		key,
		length = dataTypes.length,
		tmp,
		// Current and previous dataTypes
		current = dataTypes[ 0 ],
		prev,
		// Conversion expression
		conversion,
		// Conversion function
		conv,
		// Conversion functions (transitive conversion)
		conv1,
		conv2;

	// For each dataType in the chain
	for( i = 1; i < length; i++ ) {

		// Create converters map
		// with lowercased keys
		if ( i === 1 ) {
			for( key in s.converters ) {
				if( typeof key === "string" ) {
					converters[ key.toLowerCase() ] = s.converters[ key ];
				}
			}
		}

		// Get the dataTypes
		prev = current;
		current = dataTypes[ i ];

		// If current is auto dataType, update it to prev
		if( current === "*" ) {
			current = prev;
		// If no auto and dataTypes are actually different
		} else if ( prev !== "*" && prev !== current ) {

			// Get the converter
			conversion = prev + " " + current;
			conv = converters[ conversion ] || converters[ "* " + current ];

			// If there is no direct converter, search transitively
			if ( !conv ) {
				conv2 = undefined;
				for( conv1 in converters ) {
					tmp = conv1.split( " " );
					if ( tmp[ 0 ] === prev || tmp[ 0 ] === "*" ) {
						conv2 = converters[ tmp[1] + " " + current ];
						if ( conv2 ) {
							conv1 = converters[ conv1 ];
							if ( conv1 === true ) {
								conv = conv2;
							} else if ( conv2 === true ) {
								conv = conv1;
							}
							break;
						}
					}
				}
			}
			// If we found no converter, dispatch an error
			if ( !( conv || conv2 ) ) {
				jQuery.error( "No conversion from " + conversion.replace(" "," to ") );
			}
			// If found converter is not an equivalence
			if ( conv !== true ) {
				// Convert with 1 or 2 converters accordingly
				response = conv ? conv( response ) : conv2( conv1(response) );
			}
		}
	}
	return response;
}




var jsc = jQuery.now(),
	jsre = /(\=)\?(&|$)|\?\?/i;

// Default jsonp settings
jQuery.ajaxSetup({
	jsonp: "callback",
	jsonpCallback: function() {
		return jQuery.expando + "_" + ( jsc++ );
	}
});

// Detect, normalize options and install callbacks for jsonp requests
jQuery.ajaxPrefilter( "json jsonp", function( s, originalSettings, jqXHR ) {

	var inspectData = s.contentType === "application/x-www-form-urlencoded" &&
		( typeof s.data === "string" );

	if ( s.dataTypes[ 0 ] === "jsonp" ||
		s.jsonp !== false && ( jsre.test( s.url ) ||
				inspectData && jsre.test( s.data ) ) ) {

		var responseContainer,
			jsonpCallback = s.jsonpCallback =
				jQuery.isFunction( s.jsonpCallback ) ? s.jsonpCallback() : s.jsonpCallback,
			previous = window[ jsonpCallback ],
			url = s.url,
			data = s.data,
			replace = "$1" + jsonpCallback + "$2";

		if ( s.jsonp !== false ) {
			url = url.replace( jsre, replace );
			if ( s.url === url ) {
				if ( inspectData ) {
					data = data.replace( jsre, replace );
				}
				if ( s.data === data ) {
					// Add callback manually
					url += (/\?/.test( url ) ? "&" : "?") + s.jsonp + "=" + jsonpCallback;
				}
			}
		}

		s.url = url;
		s.data = data;

		// Install callback
		window[ jsonpCallback ] = function( response ) {
			responseContainer = [ response ];
		};

		// Clean-up function
		jqXHR.always(function() {
			// Set callback back to previous value
			window[ jsonpCallback ] = previous;
			// Call if it was a function and we have a response
			if ( responseContainer && jQuery.isFunction( previous ) ) {
				window[ jsonpCallback ]( responseContainer[ 0 ] );
			}
		});

		// Use data converter to retrieve json after script execution
		s.converters["script json"] = function() {
			if ( !responseContainer ) {
				jQuery.error( jsonpCallback + " was not called" );
			}
			return responseContainer[ 0 ];
		};

		// force json dataType
		s.dataTypes[ 0 ] = "json";

		// Delegate to script
		return "script";
	}
});




// Install script dataType
jQuery.ajaxSetup({
	accepts: {
		script: "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"
	},
	contents: {
		script: /javascript|ecmascript/
	},
	converters: {
		"text script": function( text ) {
			jQuery.globalEval( text );
			return text;
		}
	}
});

// Handle cache's special case and global
jQuery.ajaxPrefilter( "script", function( s ) {
	if ( s.cache === undefined ) {
		s.cache = false;
	}
	if ( s.crossDomain ) {
		s.type = "GET";
		s.global = false;
	}
});

// Bind script tag hack transport
jQuery.ajaxTransport( "script", function(s) {

	// This transport only deals with cross domain requests
	if ( s.crossDomain ) {

		var script,
			head = document.head || document.getElementsByTagName( "head" )[0] || document.documentElement;

		return {

			send: function( _, callback ) {

				script = document.createElement( "script" );

				script.async = "async";

				if ( s.scriptCharset ) {
					script.charset = s.scriptCharset;
				}

				script.src = s.url;

				// Attach handlers for all browsers
				script.onload = script.onreadystatechange = function( _, isAbort ) {

					if ( isAbort || !script.readyState || /loaded|complete/.test( script.readyState ) ) {

						// Handle memory leak in IE
						script.onload = script.onreadystatechange = null;

						// Remove the script
						if ( head && script.parentNode ) {
							head.removeChild( script );
						}

						// Dereference the script
						script = undefined;

						// Callback if not abort
						if ( !isAbort ) {
							callback( 200, "success" );
						}
					}
				};
				// Use insertBefore instead of appendChild  to circumvent an IE6 bug.
				// This arises when a base node is used (#2709 and #4378).
				head.insertBefore( script, head.firstChild );
			},

			abort: function() {
				if ( script ) {
					script.onload( 0, 1 );
				}
			}
		};
	}
});




var // #5280: Internet Explorer will keep connections alive if we don't abort on unload
	xhrOnUnloadAbort = window.ActiveXObject ? function() {
		// Abort all pending requests
		for ( var key in xhrCallbacks ) {
			xhrCallbacks[ key ]( 0, 1 );
		}
	} : false,
	xhrId = 0,
	xhrCallbacks;

// Functions to create xhrs
function createStandardXHR() {
	try {
		return new window.XMLHttpRequest();
	} catch( e ) {}
}

function createActiveXHR() {
	try {
		return new window.ActiveXObject( "Microsoft.XMLHTTP" );
	} catch( e ) {}
}

// Create the request object
// (This is still attached to ajaxSettings for backward compatibility)
jQuery.ajaxSettings.xhr = window.ActiveXObject ?
	/* Microsoft failed to properly
	 * implement the XMLHttpRequest in IE7 (can't request local files),
	 * so we use the ActiveXObject when it is available
	 * Additionally XMLHttpRequest can be disabled in IE7/IE8 so
	 * we need a fallback.
	 */
	function() {
		return !this.isLocal && createStandardXHR() || createActiveXHR();
	} :
	// For all other browsers, use the standard XMLHttpRequest object
	createStandardXHR;

// Determine support properties
(function( xhr ) {
	jQuery.extend( jQuery.support, {
		ajax: !!xhr,
		cors: !!xhr && ( "withCredentials" in xhr )
	});
})( jQuery.ajaxSettings.xhr() );

// Create transport if the browser can provide an xhr
if ( jQuery.support.ajax ) {

	jQuery.ajaxTransport(function( s ) {
		// Cross domain only allowed if supported through XMLHttpRequest
		if ( !s.crossDomain || jQuery.support.cors ) {

			var callback;

			return {
				send: function( headers, complete ) {

					// Get a new xhr
					var xhr = s.xhr(),
						handle,
						i;

					// Open the socket
					// Passing null username, generates a login popup on Opera (#2865)
					if ( s.username ) {
						xhr.open( s.type, s.url, s.async, s.username, s.password );
					} else {
						xhr.open( s.type, s.url, s.async );
					}

					// Apply custom fields if provided
					if ( s.xhrFields ) {
						for ( i in s.xhrFields ) {
							xhr[ i ] = s.xhrFields[ i ];
						}
					}

					// Override mime type if needed
					if ( s.mimeType && xhr.overrideMimeType ) {
						xhr.overrideMimeType( s.mimeType );
					}

					// X-Requested-With header
					// For cross-domain requests, seeing as conditions for a preflight are
					// akin to a jigsaw puzzle, we simply never set it to be sure.
					// (it can always be set on a per-request basis or even using ajaxSetup)
					// For same-domain requests, won't change header if already provided.
					if ( !s.crossDomain && !headers["X-Requested-With"] ) {
						headers[ "X-Requested-With" ] = "XMLHttpRequest";
					}

					// Need an extra try/catch for cross domain requests in Firefox 3
					try {
						for ( i in headers ) {
							xhr.setRequestHeader( i, headers[ i ] );
						}
					} catch( _ ) {}

					// Do send the request
					// This may raise an exception which is actually
					// handled in jQuery.ajax (so no try/catch here)
					xhr.send( ( s.hasContent && s.data ) || null );

					// Listener
					callback = function( _, isAbort ) {

						var status,
							statusText,
							responseHeaders,
							responses,
							xml;

						// Firefox throws exceptions when accessing properties
						// of an xhr when a network error occured
						// http://helpful.knobs-dials.com/index.php/Component_returned_failure_code:_0x80040111_(NS_ERROR_NOT_AVAILABLE)
						try {

							// Was never called and is aborted or complete
							if ( callback && ( isAbort || xhr.readyState === 4 ) ) {

								// Only called once
								callback = undefined;

								// Do not keep as active anymore
								if ( handle ) {
									xhr.onreadystatechange = jQuery.noop;
									if ( xhrOnUnloadAbort ) {
										delete xhrCallbacks[ handle ];
									}
								}

								// If it's an abort
								if ( isAbort ) {
									// Abort it manually if needed
									if ( xhr.readyState !== 4 ) {
										xhr.abort();
									}
								} else {
									status = xhr.status;
									responseHeaders = xhr.getAllResponseHeaders();
									responses = {};
									xml = xhr.responseXML;

									// Construct response list
									if ( xml && xml.documentElement /* #4958 */ ) {
										responses.xml = xml;
									}
									responses.text = xhr.responseText;

									// Firefox throws an exception when accessing
									// statusText for faulty cross-domain requests
									try {
										statusText = xhr.statusText;
									} catch( e ) {
										// We normalize with Webkit giving an empty statusText
										statusText = "";
									}

									// Filter status for non standard behaviors

									// If the request is local and we have data: assume a success
									// (success with no data won't get notified, that's the best we
									// can do given current implementations)
									if ( !status && s.isLocal && !s.crossDomain ) {
										status = responses.text ? 200 : 404;
									// IE - #1450: sometimes returns 1223 when it should be 204
									} else if ( status === 1223 ) {
										status = 204;
									}
								}
							}
						} catch( firefoxAccessException ) {
							if ( !isAbort ) {
								complete( -1, firefoxAccessException );
							}
						}

						// Call complete if needed
						if ( responses ) {
							complete( status, statusText, responses, responseHeaders );
						}
					};

					// if we're in sync mode or it's in cache
					// and has been retrieved directly (IE6 & IE7)
					// we need to manually fire the callback
					if ( !s.async || xhr.readyState === 4 ) {
						callback();
					} else {
						handle = ++xhrId;
						if ( xhrOnUnloadAbort ) {
							// Create the active xhrs callbacks list if needed
							// and attach the unload handler
							if ( !xhrCallbacks ) {
								xhrCallbacks = {};
								jQuery( window ).unload( xhrOnUnloadAbort );
							}
							// Add to list of active xhrs callbacks
							xhrCallbacks[ handle ] = callback;
						}
						xhr.onreadystatechange = callback;
					}
				},

				abort: function() {
					if ( callback ) {
						callback(0,1);
					}
				}
			};
		}
	});
}




var elemdisplay = {},
	iframe, iframeDoc,
	rfxtypes = /^(?:toggle|show|hide)$/,
	rfxnum = /^([+\-]=)?([\d+.\-]+)([a-z%]*)$/i,
	timerId,
	fxAttrs = [
		// height animations
		[ "height", "marginTop", "marginBottom", "paddingTop", "paddingBottom" ],
		// width animations
		[ "width", "marginLeft", "marginRight", "paddingLeft", "paddingRight" ],
		// opacity animations
		[ "opacity" ]
	],
	fxNow;

jQuery.fn.extend({
	show: function( speed, easing, callback ) {
		var elem, display;

		if ( speed || speed === 0 ) {
			return this.animate( genFx("show", 3), speed, easing, callback);

		} else {
			for ( var i = 0, j = this.length; i < j; i++ ) {
				elem = this[i];

				if ( elem.style ) {
					display = elem.style.display;

					// Reset the inline display of this element to learn if it is
					// being hidden by cascaded rules or not
					if ( !jQuery._data(elem, "olddisplay") && display === "none" ) {
						display = elem.style.display = "";
					}

					// Set elements which have been overridden with display: none
					// in a stylesheet to whatever the default browser style is
					// for such an element
					if ( display === "" && jQuery.css( elem, "display" ) === "none" ) {
						jQuery._data(elem, "olddisplay", defaultDisplay(elem.nodeName));
					}
				}
			}

			// Set the display of most of the elements in a second loop
			// to avoid the constant reflow
			for ( i = 0; i < j; i++ ) {
				elem = this[i];

				if ( elem.style ) {
					display = elem.style.display;

					if ( display === "" || display === "none" ) {
						elem.style.display = jQuery._data(elem, "olddisplay") || "";
					}
				}
			}

			return this;
		}
	},

	hide: function( speed, easing, callback ) {
		if ( speed || speed === 0 ) {
			return this.animate( genFx("hide", 3), speed, easing, callback);

		} else {
			for ( var i = 0, j = this.length; i < j; i++ ) {
				if ( this[i].style ) {
					var display = jQuery.css( this[i], "display" );

					if ( display !== "none" && !jQuery._data( this[i], "olddisplay" ) ) {
						jQuery._data( this[i], "olddisplay", display );
					}
				}
			}

			// Set the display of the elements in a second loop
			// to avoid the constant reflow
			for ( i = 0; i < j; i++ ) {
				if ( this[i].style ) {
					this[i].style.display = "none";
				}
			}

			return this;
		}
	},

	// Save the old toggle function
	_toggle: jQuery.fn.toggle,

	toggle: function( fn, fn2, callback ) {
		var bool = typeof fn === "boolean";

		if ( jQuery.isFunction(fn) && jQuery.isFunction(fn2) ) {
			this._toggle.apply( this, arguments );

		} else if ( fn == null || bool ) {
			this.each(function() {
				var state = bool ? fn : jQuery(this).is(":hidden");
				jQuery(this)[ state ? "show" : "hide" ]();
			});

		} else {
			this.animate(genFx("toggle", 3), fn, fn2, callback);
		}

		return this;
	},

	fadeTo: function( speed, to, easing, callback ) {
		return this.filter(":hidden").css("opacity", 0).show().end()
					.animate({opacity: to}, speed, easing, callback);
	},

	animate: function( prop, speed, easing, callback ) {
		var optall = jQuery.speed(speed, easing, callback);

		if ( jQuery.isEmptyObject( prop ) ) {
			return this.each( optall.complete, [ false ] );
		}

		// Do not change referenced properties as per-property easing will be lost
		prop = jQuery.extend( {}, prop );

		return this[ optall.queue === false ? "each" : "queue" ](function() {
			// XXX 'this' does not always have a nodeName when running the
			// test suite

			if ( optall.queue === false ) {
				jQuery._mark( this );
			}

			var opt = jQuery.extend( {}, optall ),
				isElement = this.nodeType === 1,
				hidden = isElement && jQuery(this).is(":hidden"),
				name, val, p,
				display, e,
				parts, start, end, unit;

			// will store per property easing and be used to determine when an animation is complete
			opt.animatedProperties = {};

			for ( p in prop ) {

				// property name normalization
				name = jQuery.camelCase( p );
				if ( p !== name ) {
					prop[ name ] = prop[ p ];
					delete prop[ p ];
				}

				val = prop[ name ];

				// easing resolution: per property > opt.specialEasing > opt.easing > 'swing' (default)
				if ( jQuery.isArray( val ) ) {
					opt.animatedProperties[ name ] = val[ 1 ];
					val = prop[ name ] = val[ 0 ];
				} else {
					opt.animatedProperties[ name ] = opt.specialEasing && opt.specialEasing[ name ] || opt.easing || 'swing';
				}

				if ( val === "hide" && hidden || val === "show" && !hidden ) {
					return opt.complete.call( this );
				}

				if ( isElement && ( name === "height" || name === "width" ) ) {
					// Make sure that nothing sneaks out
					// Record all 3 overflow attributes because IE does not
					// change the overflow attribute when overflowX and
					// overflowY are set to the same value
					opt.overflow = [ this.style.overflow, this.style.overflowX, this.style.overflowY ];

					// Set display property to inline-block for height/width
					// animations on inline elements that are having width/height
					// animated
					if ( jQuery.css( this, "display" ) === "inline" &&
							jQuery.css( this, "float" ) === "none" ) {
						if ( !jQuery.support.inlineBlockNeedsLayout ) {
							this.style.display = "inline-block";

						} else {
							display = defaultDisplay( this.nodeName );

							// inline-level elements accept inline-block;
							// block-level elements need to be inline with layout
							if ( display === "inline" ) {
								this.style.display = "inline-block";

							} else {
								this.style.display = "inline";
								this.style.zoom = 1;
							}
						}
					}
				}
			}

			if ( opt.overflow != null ) {
				this.style.overflow = "hidden";
			}

			for ( p in prop ) {
				e = new jQuery.fx( this, opt, p );
				val = prop[ p ];

				if ( rfxtypes.test(val) ) {
					e[ val === "toggle" ? hidden ? "show" : "hide" : val ]();

				} else {
					parts = rfxnum.exec( val );
					start = e.cur();

					if ( parts ) {
						end = parseFloat( parts[2] );
						unit = parts[3] || ( jQuery.cssNumber[ p ] ? "" : "px" );

						// We need to compute starting value
						if ( unit !== "px" ) {
							jQuery.style( this, p, (end || 1) + unit);
							start = ((end || 1) / e.cur()) * start;
							jQuery.style( this, p, start + unit);
						}

						// If a +=/-= token was provided, we're doing a relative animation
						if ( parts[1] ) {
							end = ( (parts[ 1 ] === "-=" ? -1 : 1) * end ) + start;
						}

						e.custom( start, end, unit );

					} else {
						e.custom( start, val, "" );
					}
				}
			}

			// For JS strict compliance
			return true;
		});
	},

	stop: function( clearQueue, gotoEnd ) {
		if ( clearQueue ) {
			this.queue([]);
		}

		this.each(function() {
			var timers = jQuery.timers,
				i = timers.length;
			// clear marker counters if we know they won't be
			if ( !gotoEnd ) {
				jQuery._unmark( true, this );
			}
			while ( i-- ) {
				if ( timers[i].elem === this ) {
					if (gotoEnd) {
						// force the next step to be the last
						timers[i](true);
					}

					timers.splice(i, 1);
				}
			}
		});

		// start the next in the queue if the last step wasn't forced
		if ( !gotoEnd ) {
			this.dequeue();
		}

		return this;
	}

});

// Animations created synchronously will run synchronously
function createFxNow() {
	setTimeout( clearFxNow, 0 );
	return ( fxNow = jQuery.now() );
}

function clearFxNow() {
	fxNow = undefined;
}

// Generate parameters to create a standard animation
function genFx( type, num ) {
	var obj = {};

	jQuery.each( fxAttrs.concat.apply([], fxAttrs.slice(0,num)), function() {
		obj[ this ] = type;
	});

	return obj;
}

// Generate shortcuts for custom animations
jQuery.each({
	slideDown: genFx("show", 1),
	slideUp: genFx("hide", 1),
	slideToggle: genFx("toggle", 1),
	fadeIn: { opacity: "show" },
	fadeOut: { opacity: "hide" },
	fadeToggle: { opacity: "toggle" }
}, function( name, props ) {
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return this.animate( props, speed, easing, callback );
	};
});

jQuery.extend({
	speed: function( speed, easing, fn ) {
		var opt = speed && typeof speed === "object" ? jQuery.extend({}, speed) : {
			complete: fn || !fn && easing ||
				jQuery.isFunction( speed ) && speed,
			duration: speed,
			easing: fn && easing || easing && !jQuery.isFunction(easing) && easing
		};

		opt.duration = jQuery.fx.off ? 0 : typeof opt.duration === "number" ? opt.duration :
			opt.duration in jQuery.fx.speeds ? jQuery.fx.speeds[opt.duration] : jQuery.fx.speeds._default;

		// Queueing
		opt.old = opt.complete;
		opt.complete = function( noUnmark ) {
			if ( jQuery.isFunction( opt.old ) ) {
				opt.old.call( this );
			}

			if ( opt.queue !== false ) {
				jQuery.dequeue( this );
			} else if ( noUnmark !== false ) {
				jQuery._unmark( this );
			}
		};

		return opt;
	},

	easing: {
		linear: function( p, n, firstNum, diff ) {
			return firstNum + diff * p;
		},
		swing: function( p, n, firstNum, diff ) {
			return ((-Math.cos(p*Math.PI)/2) + 0.5) * diff + firstNum;
		}
	},

	timers: [],

	fx: function( elem, options, prop ) {
		this.options = options;
		this.elem = elem;
		this.prop = prop;

		options.orig = options.orig || {};
	}

});

jQuery.fx.prototype = {
	// Simple function for setting a style value
	update: function() {
		if ( this.options.step ) {
			this.options.step.call( this.elem, this.now, this );
		}

		(jQuery.fx.step[this.prop] || jQuery.fx.step._default)( this );
	},

	// Get the current size
	cur: function() {
		if ( this.elem[this.prop] != null && (!this.elem.style || this.elem.style[this.prop] == null) ) {
			return this.elem[ this.prop ];
		}

		var parsed,
			r = jQuery.css( this.elem, this.prop );
		// Empty strings, null, undefined and "auto" are converted to 0,
		// complex values such as "rotate(1rad)" are returned as is,
		// simple values such as "10px" are parsed to Float.
		return isNaN( parsed = parseFloat( r ) ) ? !r || r === "auto" ? 0 : r : parsed;
	},

	// Start an animation from one number to another
	custom: function( from, to, unit ) {
		var self = this,
			fx = jQuery.fx;

		this.startTime = fxNow || createFxNow();
		this.start = from;
		this.end = to;
		this.unit = unit || this.unit || ( jQuery.cssNumber[ this.prop ] ? "" : "px" );
		this.now = this.start;
		this.pos = this.state = 0;

		function t( gotoEnd ) {
			return self.step(gotoEnd);
		}

		t.elem = this.elem;

		if ( t() && jQuery.timers.push(t) && !timerId ) {
			timerId = setInterval( fx.tick, fx.interval );
		}
	},

	// Simple 'show' function
	show: function() {
		// Remember where we started, so that we can go back to it later
		this.options.orig[this.prop] = jQuery.style( this.elem, this.prop );
		this.options.show = true;

		// Begin the animation
		// Make sure that we start at a small width/height to avoid any
		// flash of content
		this.custom(this.prop === "width" || this.prop === "height" ? 1 : 0, this.cur());

		// Start by showing the element
		jQuery( this.elem ).show();
	},

	// Simple 'hide' function
	hide: function() {
		// Remember where we started, so that we can go back to it later
		this.options.orig[this.prop] = jQuery.style( this.elem, this.prop );
		this.options.hide = true;

		// Begin the animation
		this.custom(this.cur(), 0);
	},

	// Each step of an animation
	step: function( gotoEnd ) {
		var t = fxNow || createFxNow(),
			done = true,
			elem = this.elem,
			options = this.options,
			i, n;

		if ( gotoEnd || t >= options.duration + this.startTime ) {
			this.now = this.end;
			this.pos = this.state = 1;
			this.update();

			options.animatedProperties[ this.prop ] = true;

			for ( i in options.animatedProperties ) {
				if ( options.animatedProperties[i] !== true ) {
					done = false;
				}
			}

			if ( done ) {
				// Reset the overflow
				if ( options.overflow != null && !jQuery.support.shrinkWrapBlocks ) {

					jQuery.each( [ "", "X", "Y" ], function (index, value) {
						elem.style[ "overflow" + value ] = options.overflow[index];
					});
				}

				// Hide the element if the "hide" operation was done
				if ( options.hide ) {
					jQuery(elem).hide();
				}

				// Reset the properties, if the item has been hidden or shown
				if ( options.hide || options.show ) {
					for ( var p in options.animatedProperties ) {
						jQuery.style( elem, p, options.orig[p] );
					}
				}

				// Execute the complete function
				options.complete.call( elem );
			}

			return false;

		} else {
			// classical easing cannot be used with an Infinity duration
			if ( options.duration == Infinity ) {
				this.now = t;
			} else {
				n = t - this.startTime;
				this.state = n / options.duration;

				// Perform the easing function, defaults to swing
				this.pos = jQuery.easing[ options.animatedProperties[ this.prop ] ]( this.state, n, 0, 1, options.duration );
				this.now = this.start + ((this.end - this.start) * this.pos);
			}
			// Perform the next step of the animation
			this.update();
		}

		return true;
	}
};

jQuery.extend( jQuery.fx, {
	tick: function() {
		for ( var timers = jQuery.timers, i = 0 ; i < timers.length ; ++i ) {
			if ( !timers[i]() ) {
				timers.splice(i--, 1);
			}
		}

		if ( !timers.length ) {
			jQuery.fx.stop();
		}
	},

	interval: 13,

	stop: function() {
		clearInterval( timerId );
		timerId = null;
	},

	speeds: {
		slow: 600,
		fast: 200,
		// Default speed
		_default: 400
	},

	step: {
		opacity: function( fx ) {
			jQuery.style( fx.elem, "opacity", fx.now );
		},

		_default: function( fx ) {
			if ( fx.elem.style && fx.elem.style[ fx.prop ] != null ) {
				fx.elem.style[ fx.prop ] = (fx.prop === "width" || fx.prop === "height" ? Math.max(0, fx.now) : fx.now) + fx.unit;
			} else {
				fx.elem[ fx.prop ] = fx.now;
			}
		}
	}
});

if ( jQuery.expr && jQuery.expr.filters ) {
	jQuery.expr.filters.animated = function( elem ) {
		return jQuery.grep(jQuery.timers, function( fn ) {
			return elem === fn.elem;
		}).length;
	};
}

// Try to restore the default display value of an element
function defaultDisplay( nodeName ) {

	if ( !elemdisplay[ nodeName ] ) {

		var body = document.body,
			elem = jQuery( "<" + nodeName + ">" ).appendTo( body ),
			display = elem.css( "display" );

		elem.remove();

		// If the simple way fails,
		// get element's real default display by attaching it to a temp iframe
		if ( display === "none" || display === "" ) {
			// No iframe to use yet, so create it
			if ( !iframe ) {
				iframe = document.createElement( "iframe" );
				iframe.frameBorder = iframe.width = iframe.height = 0;
			}

			body.appendChild( iframe );

			// Create a cacheable copy of the iframe document on first call.
			// IE and Opera will allow us to reuse the iframeDoc without re-writing the fake HTML
			// document to it; WebKit & Firefox won't allow reusing the iframe document.
			if ( !iframeDoc || !iframe.createElement ) {
				iframeDoc = ( iframe.contentWindow || iframe.contentDocument ).document;
				iframeDoc.write( ( document.compatMode === "CSS1Compat" ? "<!doctype html>" : "" ) + "<html><body>" );
				iframeDoc.close();
			}

			elem = iframeDoc.createElement( nodeName );

			iframeDoc.body.appendChild( elem );

			display = jQuery.css( elem, "display" );

			body.removeChild( iframe );
		}

		// Store the correct default display
		elemdisplay[ nodeName ] = display;
	}

	return elemdisplay[ nodeName ];
}




var rtable = /^t(?:able|d|h)$/i,
	rroot = /^(?:body|html)$/i;

if ( "getBoundingClientRect" in document.documentElement ) {
	jQuery.fn.offset = function( options ) {
		var elem = this[0], box;

		if ( options ) {
			return this.each(function( i ) {
				jQuery.offset.setOffset( this, options, i );
			});
		}

		if ( !elem || !elem.ownerDocument ) {
			return null;
		}

		if ( elem === elem.ownerDocument.body ) {
			return jQuery.offset.bodyOffset( elem );
		}

		try {
			box = elem.getBoundingClientRect();
		} catch(e) {}

		var doc = elem.ownerDocument,
			docElem = doc.documentElement;

		// Make sure we're not dealing with a disconnected DOM node
		if ( !box || !jQuery.contains( docElem, elem ) ) {
			return box ? { top: box.top, left: box.left } : { top: 0, left: 0 };
		}

		var body = doc.body,
			win = getWindow(doc),
			clientTop  = docElem.clientTop  || body.clientTop  || 0,
			clientLeft = docElem.clientLeft || body.clientLeft || 0,
			scrollTop  = win.pageYOffset || jQuery.support.boxModel && docElem.scrollTop  || body.scrollTop,
			scrollLeft = win.pageXOffset || jQuery.support.boxModel && docElem.scrollLeft || body.scrollLeft,
			top  = box.top  + scrollTop  - clientTop,
			left = box.left + scrollLeft - clientLeft;

		return { top: top, left: left };
	};

} else {
	jQuery.fn.offset = function( options ) {
		var elem = this[0];

		if ( options ) {
			return this.each(function( i ) {
				jQuery.offset.setOffset( this, options, i );
			});
		}

		if ( !elem || !elem.ownerDocument ) {
			return null;
		}

		if ( elem === elem.ownerDocument.body ) {
			return jQuery.offset.bodyOffset( elem );
		}

		jQuery.offset.initialize();

		var computedStyle,
			offsetParent = elem.offsetParent,
			prevOffsetParent = elem,
			doc = elem.ownerDocument,
			docElem = doc.documentElement,
			body = doc.body,
			defaultView = doc.defaultView,
			prevComputedStyle = defaultView ? defaultView.getComputedStyle( elem, null ) : elem.currentStyle,
			top = elem.offsetTop,
			left = elem.offsetLeft;

		while ( (elem = elem.parentNode) && elem !== body && elem !== docElem ) {
			if ( jQuery.offset.supportsFixedPosition && prevComputedStyle.position === "fixed" ) {
				break;
			}

			computedStyle = defaultView ? defaultView.getComputedStyle(elem, null) : elem.currentStyle;
			top  -= elem.scrollTop;
			left -= elem.scrollLeft;

			if ( elem === offsetParent ) {
				top  += elem.offsetTop;
				left += elem.offsetLeft;

				if ( jQuery.offset.doesNotAddBorder && !(jQuery.offset.doesAddBorderForTableAndCells && rtable.test(elem.nodeName)) ) {
					top  += parseFloat( computedStyle.borderTopWidth  ) || 0;
					left += parseFloat( computedStyle.borderLeftWidth ) || 0;
				}

				prevOffsetParent = offsetParent;
				offsetParent = elem.offsetParent;
			}

			if ( jQuery.offset.subtractsBorderForOverflowNotVisible && computedStyle.overflow !== "visible" ) {
				top  += parseFloat( computedStyle.borderTopWidth  ) || 0;
				left += parseFloat( computedStyle.borderLeftWidth ) || 0;
			}

			prevComputedStyle = computedStyle;
		}

		if ( prevComputedStyle.position === "relative" || prevComputedStyle.position === "static" ) {
			top  += body.offsetTop;
			left += body.offsetLeft;
		}

		if ( jQuery.offset.supportsFixedPosition && prevComputedStyle.position === "fixed" ) {
			top  += Math.max( docElem.scrollTop, body.scrollTop );
			left += Math.max( docElem.scrollLeft, body.scrollLeft );
		}

		return { top: top, left: left };
	};
}

jQuery.offset = {
	initialize: function() {
		var body = document.body, container = document.createElement("div"), innerDiv, checkDiv, table, td, bodyMarginTop = parseFloat( jQuery.css(body, "marginTop") ) || 0,
			html = "<div style='position:absolute;top:0;left:0;margin:0;border:5px solid #000;padding:0;width:1px;height:1px;'><div></div></div><table style='position:absolute;top:0;left:0;margin:0;border:5px solid #000;padding:0;width:1px;height:1px;' cellpadding='0' cellspacing='0'><tr><td></td></tr></table>";

		jQuery.extend( container.style, { position: "absolute", top: 0, left: 0, margin: 0, border: 0, width: "1px", height: "1px", visibility: "hidden" } );

		container.innerHTML = html;
		body.insertBefore( container, body.firstChild );
		innerDiv = container.firstChild;
		checkDiv = innerDiv.firstChild;
		td = innerDiv.nextSibling.firstChild.firstChild;

		this.doesNotAddBorder = (checkDiv.offsetTop !== 5);
		this.doesAddBorderForTableAndCells = (td.offsetTop === 5);

		checkDiv.style.position = "fixed";
		checkDiv.style.top = "20px";

		// safari subtracts parent border width here which is 5px
		this.supportsFixedPosition = (checkDiv.offsetTop === 20 || checkDiv.offsetTop === 15);
		checkDiv.style.position = checkDiv.style.top = "";

		innerDiv.style.overflow = "hidden";
		innerDiv.style.position = "relative";

		this.subtractsBorderForOverflowNotVisible = (checkDiv.offsetTop === -5);

		this.doesNotIncludeMarginInBodyOffset = (body.offsetTop !== bodyMarginTop);

		body.removeChild( container );
		jQuery.offset.initialize = jQuery.noop;
	},

	bodyOffset: function( body ) {
		var top = body.offsetTop,
			left = body.offsetLeft;

		jQuery.offset.initialize();

		if ( jQuery.offset.doesNotIncludeMarginInBodyOffset ) {
			top  += parseFloat( jQuery.css(body, "marginTop") ) || 0;
			left += parseFloat( jQuery.css(body, "marginLeft") ) || 0;
		}

		return { top: top, left: left };
	},

	setOffset: function( elem, options, i ) {
		var position = jQuery.css( elem, "position" );

		// set position first, in-case top/left are set even on static elem
		if ( position === "static" ) {
			elem.style.position = "relative";
		}

		var curElem = jQuery( elem ),
			curOffset = curElem.offset(),
			curCSSTop = jQuery.css( elem, "top" ),
			curCSSLeft = jQuery.css( elem, "left" ),
			calculatePosition = (position === "absolute" || position === "fixed") && jQuery.inArray("auto", [curCSSTop, curCSSLeft]) > -1,
			props = {}, curPosition = {}, curTop, curLeft;

		// need to be able to calculate position if either top or left is auto and position is either absolute or fixed
		if ( calculatePosition ) {
			curPosition = curElem.position();
			curTop = curPosition.top;
			curLeft = curPosition.left;
		} else {
			curTop = parseFloat( curCSSTop ) || 0;
			curLeft = parseFloat( curCSSLeft ) || 0;
		}

		if ( jQuery.isFunction( options ) ) {
			options = options.call( elem, i, curOffset );
		}

		if (options.top != null) {
			props.top = (options.top - curOffset.top) + curTop;
		}
		if (options.left != null) {
			props.left = (options.left - curOffset.left) + curLeft;
		}

		if ( "using" in options ) {
			options.using.call( elem, props );
		} else {
			curElem.css( props );
		}
	}
};


jQuery.fn.extend({
	position: function() {
		if ( !this[0] ) {
			return null;
		}

		var elem = this[0],

		// Get *real* offsetParent
		offsetParent = this.offsetParent(),

		// Get correct offsets
		offset       = this.offset(),
		parentOffset = rroot.test(offsetParent[0].nodeName) ? { top: 0, left: 0 } : offsetParent.offset();

		// Subtract element margins
		// note: when an element has margin: auto the offsetLeft and marginLeft
		// are the same in Safari causing offset.left to incorrectly be 0
		offset.top  -= parseFloat( jQuery.css(elem, "marginTop") ) || 0;
		offset.left -= parseFloat( jQuery.css(elem, "marginLeft") ) || 0;

		// Add offsetParent borders
		parentOffset.top  += parseFloat( jQuery.css(offsetParent[0], "borderTopWidth") ) || 0;
		parentOffset.left += parseFloat( jQuery.css(offsetParent[0], "borderLeftWidth") ) || 0;

		// Subtract the two offsets
		return {
			top:  offset.top  - parentOffset.top,
			left: offset.left - parentOffset.left
		};
	},

	offsetParent: function() {
		return this.map(function() {
			var offsetParent = this.offsetParent || document.body;
			while ( offsetParent && (!rroot.test(offsetParent.nodeName) && jQuery.css(offsetParent, "position") === "static") ) {
				offsetParent = offsetParent.offsetParent;
			}
			return offsetParent;
		});
	}
});


// Create scrollLeft and scrollTop methods
jQuery.each( ["Left", "Top"], function( i, name ) {
	var method = "scroll" + name;

	jQuery.fn[ method ] = function( val ) {
		var elem, win;

		if ( val === undefined ) {
			elem = this[ 0 ];

			if ( !elem ) {
				return null;
			}

			win = getWindow( elem );

			// Return the scroll offset
			return win ? ("pageXOffset" in win) ? win[ i ? "pageYOffset" : "pageXOffset" ] :
				jQuery.support.boxModel && win.document.documentElement[ method ] ||
					win.document.body[ method ] :
				elem[ method ];
		}

		// Set the scroll offset
		return this.each(function() {
			win = getWindow( this );

			if ( win ) {
				win.scrollTo(
					!i ? val : jQuery( win ).scrollLeft(),
					 i ? val : jQuery( win ).scrollTop()
				);

			} else {
				this[ method ] = val;
			}
		});
	};
});

function getWindow( elem ) {
	return jQuery.isWindow( elem ) ?
		elem :
		elem.nodeType === 9 ?
			elem.defaultView || elem.parentWindow :
			false;
}




// Create width, height, innerHeight, innerWidth, outerHeight and outerWidth methods
jQuery.each([ "Height", "Width" ], function( i, name ) {

	var type = name.toLowerCase();

	// innerHeight and innerWidth
	jQuery.fn[ "inner" + name ] = function() {
		var elem = this[0];
		return elem && elem.style ?
			parseFloat( jQuery.css( elem, type, "padding" ) ) :
			null;
	};

	// outerHeight and outerWidth
	jQuery.fn[ "outer" + name ] = function( margin ) {
		var elem = this[0];
		return elem && elem.style ?
			parseFloat( jQuery.css( elem, type, margin ? "margin" : "border" ) ) :
			null;
	};

	jQuery.fn[ type ] = function( size ) {
		// Get window width or height
		var elem = this[0];
		if ( !elem ) {
			return size == null ? null : this;
		}

		if ( jQuery.isFunction( size ) ) {
			return this.each(function( i ) {
				var self = jQuery( this );
				self[ type ]( size.call( this, i, self[ type ]() ) );
			});
		}

		if ( jQuery.isWindow( elem ) ) {
			// Everyone else use document.documentElement or document.body depending on Quirks vs Standards mode
			// 3rd condition allows Nokia support, as it supports the docElem prop but not CSS1Compat
			var docElemProp = elem.document.documentElement[ "client" + name ],
				body = elem.document.body;
			return elem.document.compatMode === "CSS1Compat" && docElemProp ||
				body && body[ "client" + name ] || docElemProp;

		// Get document width or height
		} else if ( elem.nodeType === 9 ) {
			// Either scroll[Width/Height] or offset[Width/Height], whichever is greater
			return Math.max(
				elem.documentElement["client" + name],
				elem.body["scroll" + name], elem.documentElement["scroll" + name],
				elem.body["offset" + name], elem.documentElement["offset" + name]
			);

		// Get or set width or height on the element
		} else if ( size === undefined ) {
			var orig = jQuery.css( elem, type ),
				ret = parseFloat( orig );

			return jQuery.isNaN( ret ) ? orig : ret;

		// Set the width or height on the element (default to pixels if value is unitless)
		} else {
			return this.css( type, typeof size === "string" ? size : size + "px" );
		}
	};

});


// Expose jQuery to the global object
window.jQuery = window.$ = jQuery;
})(window);

/* jquery.signalR.core.js */
/*global window:false */
/*!
 * ASP.NET SignalR JavaScript Library v2.2.2
 * http://signalr.net/
 *
 * Copyright (c) .NET Foundation. All rights reserved.
 * Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.
 *
 */

(function ($, window, undefined) {

    var resources = {
        nojQuery: "jQuery was not found. Please ensure jQuery is referenced before the SignalR client JavaScript file.",
        noTransportOnInit: "No transport could be initialized successfully. Try specifying a different transport or none at all for auto initialization.",
        errorOnNegotiate: "Error during negotiation request.",
        stoppedWhileLoading: "The connection was stopped during page load.",
        stoppedWhileNegotiating: "The connection was stopped during the negotiate request.",
        errorParsingNegotiateResponse: "Error parsing negotiate response.",
        errorDuringStartRequest: "Error during start request. Stopping the connection.",
        stoppedDuringStartRequest: "The connection was stopped during the start request.",
        errorParsingStartResponse: "Error parsing start response: '{0}'. Stopping the connection.",
        invalidStartResponse: "Invalid start response: '{0}'. Stopping the connection.",
        protocolIncompatible: "You are using a version of the client that isn't compatible with the server. Client version {0}, server version {1}.",
        sendFailed: "Send failed.",
        parseFailed: "Failed at parsing response: {0}",
        longPollFailed: "Long polling request failed.",
        eventSourceFailedToConnect: "EventSource failed to connect.",
        eventSourceError: "Error raised by EventSource",
        webSocketClosed: "WebSocket closed.",
        pingServerFailedInvalidResponse: "Invalid ping response when pinging server: '{0}'.",
        pingServerFailed: "Failed to ping server.",
        pingServerFailedStatusCode: "Failed to ping server.  Server responded with status code {0}, stopping the connection.",
        pingServerFailedParse: "Failed to parse ping server response, stopping the connection.",
        noConnectionTransport: "Connection is in an invalid state, there is no transport active.",
        webSocketsInvalidState: "The Web Socket transport is in an invalid state, transitioning into reconnecting.",
        reconnectTimeout: "Couldn't reconnect within the configured timeout of {0} ms, disconnecting.",
        reconnectWindowTimeout: "The client has been inactive since {0} and it has exceeded the inactivity timeout of {1} ms. Stopping the connection."
    };

    if (typeof ($) !== "function") {
        // no jQuery!
        throw new Error(resources.nojQuery);
    }

    var signalR,
        _connection,
        _pageLoaded = (window.document.readyState === "complete"),
        _pageWindow = $(window),
        _negotiateAbortText = "__Negotiate Aborted__",
        events = {
            onStart: "onStart",
            onStarting: "onStarting",
            onReceived: "onReceived",
            onError: "onError",
            onConnectionSlow: "onConnectionSlow",
            onReconnecting: "onReconnecting",
            onReconnect: "onReconnect",
            onStateChanged: "onStateChanged",
            onDisconnect: "onDisconnect"
        },
        ajaxDefaults = {
            processData: true,
            timeout: null,
            async: true,
            global: false,
            cache: false
        },
        log = function (msg, logging) {
            if (logging === false) {
                return;
            }
            var m;
            if (typeof (window.console) === "undefined") {
                return;
            }
            m = "[" + new Date().toTimeString() + "] SignalR: " + msg;
            if (window.console.debug) {
                window.console.debug(m);
            } else if (window.console.log) {
                window.console.log(m);
            }
        },

        changeState = function (connection, expectedState, newState) {
            if (expectedState === connection.state) {
                connection.state = newState;

                $(connection).triggerHandler(events.onStateChanged, [{ oldState: expectedState, newState: newState }]);
                return true;
            }

            return false;
        },

        isDisconnecting = function (connection) {
            return connection.state === signalR.connectionState.disconnected;
        },

        supportsKeepAlive = function (connection) {
            return connection._.keepAliveData.activated &&
                   connection.transport.supportsKeepAlive(connection);
        },

        configureStopReconnectingTimeout = function (connection) {
            var stopReconnectingTimeout,
                onReconnectTimeout;

            // Check if this connection has already been configured to stop reconnecting after a specified timeout.
            // Without this check if a connection is stopped then started events will be bound multiple times.
            if (!connection._.configuredStopReconnectingTimeout) {
                onReconnectTimeout = function (connection) {
                    var message = signalR._.format(signalR.resources.reconnectTimeout, connection.disconnectTimeout);
                    connection.log(message);
                    $(connection).triggerHandler(events.onError, [signalR._.error(message, /* source */ "TimeoutException")]);
                    connection.stop(/* async */ false, /* notifyServer */ false);
                };

                connection.reconnecting(function () {
                    var connection = this;

                    // Guard against state changing in a previous user defined even handler
                    if (connection.state === signalR.connectionState.reconnecting) {
                        stopReconnectingTimeout = window.setTimeout(function () { onReconnectTimeout(connection); }, connection.disconnectTimeout);
                    }
                });

                connection.stateChanged(function (data) {
                    if (data.oldState === signalR.connectionState.reconnecting) {
                        // Clear the pending reconnect timeout check
                        window.clearTimeout(stopReconnectingTimeout);
                    }
                });

                connection._.configuredStopReconnectingTimeout = true;
            }
        };

    signalR = function (url, qs, logging) {
        /// <summary>Creates a new SignalR connection for the given url</summary>
        /// <param name="url" type="String">The URL of the long polling endpoint</param>
        /// <param name="qs" type="Object">
        ///     [Optional] Custom querystring parameters to add to the connection URL.
        ///     If an object, every non-function member will be added to the querystring.
        ///     If a string, it's added to the QS as specified.
        /// </param>
        /// <param name="logging" type="Boolean">
        ///     [Optional] A flag indicating whether connection logging is enabled to the browser
        ///     console/log. Defaults to false.
        /// </param>

        return new signalR.fn.init(url, qs, logging);
    };

    signalR._ = {
        defaultContentType: "application/x-www-form-urlencoded; charset=UTF-8",

        ieVersion: (function () {
            var version,
                matches;

            if (window.navigator.appName === 'Microsoft Internet Explorer') {
                // Check if the user agent has the pattern "MSIE (one or more numbers).(one or more numbers)";
                matches = /MSIE ([0-9]+\.[0-9]+)/.exec(window.navigator.userAgent);

                if (matches) {
                    version = window.parseFloat(matches[1]);
                }
            }

            // undefined value means not IE
            return version;
        })(),

        error: function (message, source, context) {
            var e = new Error(message);
            e.source = source;

            if (typeof context !== "undefined") {
                e.context = context;
            }

            return e;
        },

        transportError: function (message, transport, source, context) {
            var e = this.error(message, source, context);
            e.transport = transport ? transport.name : undefined;
            return e;
        },

        format: function () {
            /// <summary>Usage: format("Hi {0}, you are {1}!", "Foo", 100) </summary>
            var s = arguments[0];
            for (var i = 0; i < arguments.length - 1; i++) {
                s = s.replace("{" + i + "}", arguments[i + 1]);
            }
            return s;
        },

        firefoxMajorVersion: function (userAgent) {
            // Firefox user agents: http://useragentstring.com/pages/Firefox/
            var matches = userAgent.match(/Firefox\/(\d+)/);
            if (!matches || !matches.length || matches.length < 2) {
                return 0;
            }
            return parseInt(matches[1], 10 /* radix */);
        },

        configurePingInterval: function (connection) {
            var config = connection._.config,
                onFail = function (error) {
                    $(connection).triggerHandler(events.onError, [error]);
                };

            if (config && !connection._.pingIntervalId && config.pingInterval) {
                connection._.pingIntervalId = window.setInterval(function () {
                    signalR.transports._logic.pingServer(connection).fail(onFail);
                }, config.pingInterval);
            }
        }
    };

    signalR.events = events;

    signalR.resources = resources;

    signalR.ajaxDefaults = ajaxDefaults;

    signalR.changeState = changeState;

    signalR.isDisconnecting = isDisconnecting;

    signalR.connectionState = {
        connecting: 0,
        connected: 1,
        reconnecting: 2,
        disconnected: 4
    };

    signalR.hub = {
        start: function () {
            // This will get replaced with the real hub connection start method when hubs is referenced correctly
            throw new Error("SignalR: Error loading hubs. Ensure your hubs reference is correct, e.g. <script src='/signalr/js'></script>.");
        }
    };

    // .on() was added in version 1.7.0, .load() was removed in version 3.0.0 so we fallback to .load() if .on() does
    // not exist to not break existing applications
    if (typeof _pageWindow.on == "function") {
        _pageWindow.on("load", function () { _pageLoaded = true; });
    }
    else {
        _pageWindow.load(function () { _pageLoaded = true; });
    }

    function validateTransport(requestedTransport, connection) {
        /// <summary>Validates the requested transport by cross checking it with the pre-defined signalR.transports</summary>
        /// <param name="requestedTransport" type="Object">The designated transports that the user has specified.</param>
        /// <param name="connection" type="signalR">The connection that will be using the requested transports.  Used for logging purposes.</param>
        /// <returns type="Object" />

        if ($.isArray(requestedTransport)) {
            // Go through transport array and remove an "invalid" tranports
            for (var i = requestedTransport.length - 1; i >= 0; i--) {
                var transport = requestedTransport[i];
                if ($.type(transport) !== "string" || !signalR.transports[transport]) {
                    connection.log("Invalid transport: " + transport + ", removing it from the transports list.");
                    requestedTransport.splice(i, 1);
                }
            }

            // Verify we still have transports left, if we dont then we have invalid transports
            if (requestedTransport.length === 0) {
                connection.log("No transports remain within the specified transport array.");
                requestedTransport = null;
            }
        } else if (!signalR.transports[requestedTransport] && requestedTransport !== "auto") {
            connection.log("Invalid transport: " + requestedTransport.toString() + ".");
            requestedTransport = null;
        } else if (requestedTransport === "auto" && signalR._.ieVersion <= 8) {
            // If we're doing an auto transport and we're IE8 then force longPolling, #1764
            return ["longPolling"];

        }

        return requestedTransport;
    }

    function getDefaultPort(protocol) {
        if (protocol === "http:") {
            return 80;
        } else if (protocol === "https:") {
            return 443;
        }
    }

    function addDefaultPort(protocol, url) {
        // Remove ports  from url.  We have to check if there's a / or end of line
        // following the port in order to avoid removing ports such as 8080.
        if (url.match(/:\d+$/)) {
            return url;
        } else {
            return url + ":" + getDefaultPort(protocol);
        }
    }

    function ConnectingMessageBuffer(connection, drainCallback) {
        var that = this,
            buffer = [];

        that.tryBuffer = function (message) {
            if (connection.state === $.signalR.connectionState.connecting) {
                buffer.push(message);

                return true;
            }

            return false;
        };

        that.drain = function () {
            // Ensure that the connection is connected when we drain (do not want to drain while a connection is not active)
            if (connection.state === $.signalR.connectionState.connected) {
                while (buffer.length > 0) {
                    drainCallback(buffer.shift());
                }
            }
        };

        that.clear = function () {
            buffer = [];
        };
    }

    signalR.fn = signalR.prototype = {
        init: function (url, qs, logging) {
            var $connection = $(this);

            this.url = url;
            this.qs = qs;
            this.lastError = null;
            this._ = {
                keepAliveData: {},
                connectingMessageBuffer: new ConnectingMessageBuffer(this, function (message) {
                    $connection.triggerHandler(events.onReceived, [message]);
                }),
                lastMessageAt: new Date().getTime(),
                lastActiveAt: new Date().getTime(),
                beatInterval: 5000, // Default value, will only be overridden if keep alive is enabled,
                beatHandle: null,
                totalTransportConnectTimeout: 0 // This will be the sum of the TransportConnectTimeout sent in response to negotiate and connection.transportConnectTimeout
            };
            if (typeof (logging) === "boolean") {
                this.logging = logging;
            }
        },

        _parseResponse: function (response) {
            var that = this;

            if (!response) {
                return response;
            } else if (typeof response === "string") {
                return that.json.parse(response);
            } else {
                return response;
            }
        },

        _originalJson: window.JSON,

        json: window.JSON,

        isCrossDomain: function (url, against) {
            /// <summary>Checks if url is cross domain</summary>
            /// <param name="url" type="String">The base URL</param>
            /// <param name="against" type="Object">
            ///     An optional argument to compare the URL against, if not specified it will be set to window.location.
            ///     If specified it must contain a protocol and a host property.
            /// </param>
            var link;

            url = $.trim(url);

            against = against || window.location;

            if (url.indexOf("http") !== 0) {
                return false;
            }

            // Create an anchor tag.
            link = window.document.createElement("a");
            link.href = url;

            // When checking for cross domain we have to special case port 80 because the window.location will remove the
            return link.protocol + addDefaultPort(link.protocol, link.host) !== against.protocol + addDefaultPort(against.protocol, against.host);
        },

        ajaxDataType: "text",

        contentType: "application/json; charset=UTF-8",

        logging: false,

        state: signalR.connectionState.disconnected,

        clientProtocol: "1.5",

        reconnectDelay: 2000,

        transportConnectTimeout: 0,

        disconnectTimeout: 30000, // This should be set by the server in response to the negotiate request (30s default)

        reconnectWindow: 30000, // This should be set by the server in response to the negotiate request

        keepAliveWarnAt: 2 / 3, // Warn user of slow connection if we breach the X% mark of the keep alive timeout

        start: function (options, callback) {
            /// <summary>Starts the connection</summary>
            /// <param name="options" type="Object">Options map</param>
            /// <param name="callback" type="Function">A callback function to execute when the connection has started</param>
            var connection = this,
                config = {
                    pingInterval: 300000,
                    waitForPageLoad: true,
                    transport: "auto",
                    jsonp: false
                },
                initialize,
                deferred = connection._deferral || $.Deferred(), // Check to see if there is a pre-existing deferral that's being built on, if so we want to keep using it
                parser = window.document.createElement("a");

            connection.lastError = null;

            // Persist the deferral so that if start is called multiple times the same deferral is used.
            connection._deferral = deferred;

            if (!connection.json) {
                // no JSON!
                throw new Error("SignalR: No JSON parser found. Please ensure json2.js is referenced before the SignalR.js file if you need to support clients without native JSON parsing support, e.g. IE<8.");
            }

            if ($.type(options) === "function") {
                // Support calling with single callback parameter
                callback = options;
            } else if ($.type(options) === "object") {
                $.extend(config, options);
                if ($.type(config.callback) === "function") {
                    callback = config.callback;
                }
            }

            config.transport = validateTransport(config.transport, connection);

            // If the transport is invalid throw an error and abort start
            if (!config.transport) {
                throw new Error("SignalR: Invalid transport(s) specified, aborting start.");
            }

            connection._.config = config;

            // Check to see if start is being called prior to page load
            // If waitForPageLoad is true we then want to re-direct function call to the window load event
            if (!_pageLoaded && config.waitForPageLoad === true) {
                connection._.deferredStartHandler = function () {
                    connection.start(options, callback);
                };
                _pageWindow.bind("load", connection._.deferredStartHandler);

                return deferred.promise();
            }

            // If we're already connecting just return the same deferral as the original connection start
            if (connection.state === signalR.connectionState.connecting) {
                return deferred.promise();
            } else if (changeState(connection,
                            signalR.connectionState.disconnected,
                            signalR.connectionState.connecting) === false) {
                // We're not connecting so try and transition into connecting.
                // If we fail to transition then we're either in connected or reconnecting.

                deferred.resolve(connection);
                return deferred.promise();
            }

            configureStopReconnectingTimeout(connection);

            // Resolve the full url
            parser.href = connection.url;
            if (!parser.protocol || parser.protocol === ":") {
                connection.protocol = window.document.location.protocol;
                connection.host = parser.host || window.document.location.host;
            } else {
                connection.protocol = parser.protocol;
                connection.host = parser.host;
            }

            connection.baseUrl = connection.protocol + "//" + connection.host;

            // Set the websocket protocol
            connection.wsProtocol = connection.protocol === "https:" ? "wss://" : "ws://";

            // If jsonp with no/auto transport is specified, then set the transport to long polling
            // since that is the only transport for which jsonp really makes sense.
            // Some developers might actually choose to specify jsonp for same origin requests
            // as demonstrated by Issue #623.
            if (config.transport === "auto" && config.jsonp === true) {
                config.transport = "longPolling";
            }

            // If the url is protocol relative, prepend the current windows protocol to the url.
            if (connection.url.indexOf("//") === 0) {
                connection.url = window.location.protocol + connection.url;
                connection.log("Protocol relative URL detected, normalizing it to '" + connection.url + "'.");
            }

            if (this.isCrossDomain(connection.url)) {
                connection.log("Auto detected cross domain url.");

                if (config.transport === "auto") {
                    // TODO: Support XDM with foreverFrame
                    config.transport = ["webSockets", "serverSentEvents", "longPolling"];
                }

                if (typeof (config.withCredentials) === "undefined") {
                    config.withCredentials = true;
                }

                // Determine if jsonp is the only choice for negotiation, ajaxSend and ajaxAbort.
                // i.e. if the browser doesn't supports CORS
                // If it is, ignore any preference to the contrary, and switch to jsonp.
                if (!config.jsonp) {
                    config.jsonp = !$.support.cors;

                    if (config.jsonp) {
                        connection.log("Using jsonp because this browser doesn't support CORS.");
                    }
                }

                connection.contentType = signalR._.defaultContentType;
            }

            connection.withCredentials = config.withCredentials;

            connection.ajaxDataType = config.jsonp ? "jsonp" : "text";

            $(connection).bind(events.onStart, function (e, data) {
                if ($.type(callback) === "function") {
                    callback.call(connection);
                }
                deferred.resolve(connection);
            });

            connection._.initHandler = signalR.transports._logic.initHandler(connection);

            initialize = function (transports, index) {
                var noTransportError = signalR._.error(resources.noTransportOnInit);

                index = index || 0;
                if (index >= transports.length) {
                    if (index === 0) {
                        connection.log("No transports supported by the server were selected.");
                    } else if (index === 1) {
                        connection.log("No fallback transports were selected.");
                    } else {
                        connection.log("Fallback transports exhausted.");
                    }

                    // No transport initialized successfully
                    $(connection).triggerHandler(events.onError, [noTransportError]);
                    deferred.reject(noTransportError);
                    // Stop the connection if it has connected and move it into the disconnected state
                    connection.stop();
                    return;
                }

                // The connection was aborted
                if (connection.state === signalR.connectionState.disconnected) {
                    return;
                }

                var transportName = transports[index],
                    transport = signalR.transports[transportName],
                    onFallback = function () {
                        initialize(transports, index + 1);
                    };

                connection.transport = transport;

                try {
                    connection._.initHandler.start(transport, function () { // success
                        // Firefox 11+ doesn't allow sync XHR withCredentials: https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest#withCredentials
                        var isFirefox11OrGreater = signalR._.firefoxMajorVersion(window.navigator.userAgent) >= 11,
                            asyncAbort = !!connection.withCredentials && isFirefox11OrGreater;

                        connection.log("The start request succeeded. Transitioning to the connected state.");

                        if (supportsKeepAlive(connection)) {
                            signalR.transports._logic.monitorKeepAlive(connection);
                        }

                        signalR.transports._logic.startHeartbeat(connection);

                        // Used to ensure low activity clients maintain their authentication.
                        // Must be configured once a transport has been decided to perform valid ping requests.
                        signalR._.configurePingInterval(connection);

                        if (!changeState(connection,
                                            signalR.connectionState.connecting,
                                            signalR.connectionState.connected)) {
                            connection.log("WARNING! The connection was not in the connecting state.");
                        }

                        // Drain any incoming buffered messages (messages that came in prior to connect)
                        connection._.connectingMessageBuffer.drain();

                        $(connection).triggerHandler(events.onStart);

                        // wire the stop handler for when the user leaves the page
                        _pageWindow.bind("unload", function () {
                            connection.log("Window unloading, stopping the connection.");

                            connection.stop(asyncAbort);
                        });

                        if (isFirefox11OrGreater) {
                            // Firefox does not fire cross-domain XHRs in the normal unload handler on tab close.
                            // #2400
                            _pageWindow.bind("beforeunload", function () {
                                // If connection.stop() runs runs in beforeunload and fails, it will also fail
                                // in unload unless connection.stop() runs after a timeout.
                                window.setTimeout(function () {
                                    connection.stop(asyncAbort);
                                }, 0);
                            });
                        }
                    }, onFallback);
                }
                catch (error) {
                    connection.log(transport.name + " transport threw '" + error.message + "' when attempting to start.");
                    onFallback();
                }
            };

            var url = connection.url + "/negotiate",
                onFailed = function (error, connection) {
                    var err = signalR._.error(resources.errorOnNegotiate, error, connection._.negotiateRequest);

                    $(connection).triggerHandler(events.onError, err);
                    deferred.reject(err);
                    // Stop the connection if negotiate failed
                    connection.stop();
                };

            $(connection).triggerHandler(events.onStarting);

            url = signalR.transports._logic.prepareQueryString(connection, url);

            connection.log("Negotiating with '" + url + "'.");

            // Save the ajax negotiate request object so we can abort it if stop is called while the request is in flight.
            connection._.negotiateRequest = signalR.transports._logic.ajax(connection, {
                url: url,
                error: function (error, statusText) {
                    // We don't want to cause any errors if we're aborting our own negotiate request.
                    if (statusText !== _negotiateAbortText) {
                        onFailed(error, connection);
                    } else {
                        // This rejection will noop if the deferred has already been resolved or rejected.
                        deferred.reject(signalR._.error(resources.stoppedWhileNegotiating, null /* error */, connection._.negotiateRequest));
                    }
                },
                success: function (result) {
                    var res,
                        keepAliveData,
                        protocolError,
                        transports = [],
                        supportedTransports = [];

                    try {
                        res = connection._parseResponse(result);
                    } catch (error) {
                        onFailed(signalR._.error(resources.errorParsingNegotiateResponse, error), connection);
                        return;
                    }

                    keepAliveData = connection._.keepAliveData;
                    connection.appRelativeUrl = res.Url;
                    connection.id = res.ConnectionId;
                    connection.token = res.ConnectionToken;
                    connection.webSocketServerUrl = res.WebSocketServerUrl;

                    // The long poll timeout is the ConnectionTimeout plus 10 seconds
                    connection._.pollTimeout = res.ConnectionTimeout * 1000 + 10000; // in ms

                    // Once the server has labeled the PersistentConnection as Disconnected, we should stop attempting to reconnect
                    // after res.DisconnectTimeout seconds.
                    connection.disconnectTimeout = res.DisconnectTimeout * 1000; // in ms

                    // Add the TransportConnectTimeout from the response to the transportConnectTimeout from the client to calculate the total timeout
                    connection._.totalTransportConnectTimeout = connection.transportConnectTimeout + res.TransportConnectTimeout * 1000;

                    // If we have a keep alive
                    if (res.KeepAliveTimeout) {
                        // Register the keep alive data as activated
                        keepAliveData.activated = true;

                        // Timeout to designate when to force the connection into reconnecting converted to milliseconds
                        keepAliveData.timeout = res.KeepAliveTimeout * 1000;

                        // Timeout to designate when to warn the developer that the connection may be dead or is not responding.
                        keepAliveData.timeoutWarning = keepAliveData.timeout * connection.keepAliveWarnAt;

                        // Instantiate the frequency in which we check the keep alive.  It must be short in order to not miss/pick up any changes
                        connection._.beatInterval = (keepAliveData.timeout - keepAliveData.timeoutWarning) / 3;
                    } else {
                        keepAliveData.activated = false;
                    }

                    connection.reconnectWindow = connection.disconnectTimeout + (keepAliveData.timeout || 0);

                    if (!res.ProtocolVersion || res.ProtocolVersion !== connection.clientProtocol) {
                        protocolError = signalR._.error(signalR._.format(resources.protocolIncompatible, connection.clientProtocol, res.ProtocolVersion));
                        $(connection).triggerHandler(events.onError, [protocolError]);
                        deferred.reject(protocolError);

                        return;
                    }

                    $.each(signalR.transports, function (key) {
                        if ((key.indexOf("_") === 0) || (key === "webSockets" && !res.TryWebSockets)) {
                            return true;
                        }
                        supportedTransports.push(key);
                    });

                    if ($.isArray(config.transport)) {
                        $.each(config.transport, function (_, transport) {
                            if ($.inArray(transport, supportedTransports) >= 0) {
                                transports.push(transport);
                            }
                        });
                    } else if (config.transport === "auto") {
                        transports = supportedTransports;
                    } else if ($.inArray(config.transport, supportedTransports) >= 0) {
                        transports.push(config.transport);
                    }

                    initialize(transports);
                }
            });

            return deferred.promise();
        },

        starting: function (callback) {
            /// <summary>Adds a callback that will be invoked before anything is sent over the connection</summary>
            /// <param name="callback" type="Function">A callback function to execute before the connection is fully instantiated.</param>
            /// <returns type="signalR" />
            var connection = this;
            $(connection).bind(events.onStarting, function (e, data) {
                callback.call(connection);
            });
            return connection;
        },

        send: function (data) {
            /// <summary>Sends data over the connection</summary>
            /// <param name="data" type="String">The data to send over the connection</param>
            /// <returns type="signalR" />
            var connection = this;

            if (connection.state === signalR.connectionState.disconnected) {
                // Connection hasn't been started yet
                throw new Error("SignalR: Connection must be started before data can be sent. Call .start() before .send()");
            }

            if (connection.state === signalR.connectionState.connecting) {
                // Connection hasn't been started yet
                throw new Error("SignalR: Connection has not been fully initialized. Use .start().done() or .start().fail() to run logic after the connection has started.");
            }

            connection.transport.send(connection, data);
            // REVIEW: Should we return deferred here?
            return connection;
        },

        received: function (callback) {
            /// <summary>Adds a callback that will be invoked after anything is received over the connection</summary>
            /// <param name="callback" type="Function">A callback function to execute when any data is received on the connection</param>
            /// <returns type="signalR" />
            var connection = this;
            $(connection).bind(events.onReceived, function (e, data) {
                callback.call(connection, data);
            });
            return connection;
        },

        stateChanged: function (callback) {
            /// <summary>Adds a callback that will be invoked when the connection state changes</summary>
            /// <param name="callback" type="Function">A callback function to execute when the connection state changes</param>
            /// <returns type="signalR" />
            var connection = this;
            $(connection).bind(events.onStateChanged, function (e, data) {
                callback.call(connection, data);
            });
            return connection;
        },

        error: function (callback) {
            /// <summary>Adds a callback that will be invoked after an error occurs with the connection</summary>
            /// <param name="callback" type="Function">A callback function to execute when an error occurs on the connection</param>
            /// <returns type="signalR" />
            var connection = this;
            $(connection).bind(events.onError, function (e, errorData, sendData) {
                connection.lastError = errorData;
                // In practice 'errorData' is the SignalR built error object.
                // In practice 'sendData' is undefined for all error events except those triggered by
                // 'ajaxSend' and 'webSockets.send'.'sendData' is the original send payload.
                callback.call(connection, errorData, sendData);
            });
            return connection;
        },

        disconnected: function (callback) {
            /// <summary>Adds a callback that will be invoked when the client disconnects</summary>
            /// <param name="callback" type="Function">A callback function to execute when the connection is broken</param>
            /// <returns type="signalR" />
            var connection = this;
            $(connection).bind(events.onDisconnect, function (e, data) {
                callback.call(connection);
            });
            return connection;
        },

        connectionSlow: function (callback) {
            /// <summary>Adds a callback that will be invoked when the client detects a slow connection</summary>
            /// <param name="callback" type="Function">A callback function to execute when the connection is slow</param>
            /// <returns type="signalR" />
            var connection = this;
            $(connection).bind(events.onConnectionSlow, function (e, data) {
                callback.call(connection);
            });

            return connection;
        },

        reconnecting: function (callback) {
            /// <summary>Adds a callback that will be invoked when the underlying transport begins reconnecting</summary>
            /// <param name="callback" type="Function">A callback function to execute when the connection enters a reconnecting state</param>
            /// <returns type="signalR" />
            var connection = this;
            $(connection).bind(events.onReconnecting, function (e, data) {
                callback.call(connection);
            });
            return connection;
        },

        reconnected: function (callback) {
            /// <summary>Adds a callback that will be invoked when the underlying transport reconnects</summary>
            /// <param name="callback" type="Function">A callback function to execute when the connection is restored</param>
            /// <returns type="signalR" />
            var connection = this;
            $(connection).bind(events.onReconnect, function (e, data) {
                callback.call(connection);
            });
            return connection;
        },

        stop: function (async, notifyServer) {
            /// <summary>Stops listening</summary>
            /// <param name="async" type="Boolean">Whether or not to asynchronously abort the connection</param>
            /// <param name="notifyServer" type="Boolean">Whether we want to notify the server that we are aborting the connection</param>
            /// <returns type="signalR" />
            var connection = this,
                // Save deferral because this is always cleaned up
                deferral = connection._deferral;

            // Verify that we've bound a load event.
            if (connection._.deferredStartHandler) {
                // Unbind the event.
                _pageWindow.unbind("load", connection._.deferredStartHandler);
            }

            // Always clean up private non-timeout based state.
            delete connection._.config;
            delete connection._.deferredStartHandler;

            // This needs to be checked despite the connection state because a connection start can be deferred until page load.
            // If we've deferred the start due to a page load we need to unbind the "onLoad" -> start event.
            if (!_pageLoaded && (!connection._.config || connection._.config.waitForPageLoad === true)) {
                connection.log("Stopping connection prior to negotiate.");

                // If we have a deferral we should reject it
                if (deferral) {
                    deferral.reject(signalR._.error(resources.stoppedWhileLoading));
                }

                // Short-circuit because the start has not been fully started.
                return;
            }

            if (connection.state === signalR.connectionState.disconnected) {
                return;
            }

            connection.log("Stopping connection.");

            // Clear this no matter what
            window.clearTimeout(connection._.beatHandle);
            window.clearInterval(connection._.pingIntervalId);

            if (connection.transport) {
                connection.transport.stop(connection);

                if (notifyServer !== false) {
                    connection.transport.abort(connection, async);
                }

                if (supportsKeepAlive(connection)) {
                    signalR.transports._logic.stopMonitoringKeepAlive(connection);
                }

                connection.transport = null;
            }

            if (connection._.negotiateRequest) {
                // If the negotiation request has already completed this will noop.
                connection._.negotiateRequest.abort(_negotiateAbortText);
                delete connection._.negotiateRequest;
            }

            // Ensure that initHandler.stop() is called before connection._deferral is deleted
            if (connection._.initHandler) {
                connection._.initHandler.stop();
            }

            delete connection._deferral;
            delete connection.messageId;
            delete connection.groupsToken;
            delete connection.id;
            delete connection._.pingIntervalId;
            delete connection._.lastMessageAt;
            delete connection._.lastActiveAt;

            // Clear out our message buffer
            connection._.connectingMessageBuffer.clear();
            
            // Clean up this event
            $(connection).unbind(events.onStart);

            // Trigger the disconnect event
            changeState(connection, connection.state, signalR.connectionState.disconnected);
            $(connection).triggerHandler(events.onDisconnect);

            return connection;
        },

        log: function (msg) {
            log(msg, this.logging);
        }
    };

    signalR.fn.init.prototype = signalR.fn;

    signalR.noConflict = function () {
        /// <summary>Reinstates the original value of $.connection and returns the signalR object for manual assignment</summary>
        /// <returns type="signalR" />
        if ($.connection === signalR) {
            $.connection = _connection;
        }
        return signalR;
    };

    if ($.connection) {
        _connection = $.connection;
    }

    $.connection = $.signalR = signalR;

}(window.jQuery, window));
/* jquery.signalR.transports.common.js */
// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

/*global window:false */

(function ($, window, undefined) {

    var signalR = $.signalR,
        events = $.signalR.events,
        changeState = $.signalR.changeState,
        startAbortText = "__Start Aborted__",
        transportLogic;

    signalR.transports = {};

    function beat(connection) {
        if (connection._.keepAliveData.monitoring) {
            checkIfAlive(connection);
        }

        // Ensure that we successfully marked active before continuing the heartbeat.
        if (transportLogic.markActive(connection)) {
            connection._.beatHandle = window.setTimeout(function () {
                beat(connection);
            }, connection._.beatInterval);
        }
    }

    function checkIfAlive(connection) {
        var keepAliveData = connection._.keepAliveData,
            timeElapsed;

        // Only check if we're connected
        if (connection.state === signalR.connectionState.connected) {
            timeElapsed = new Date().getTime() - connection._.lastMessageAt;

            // Check if the keep alive has completely timed out
            if (timeElapsed >= keepAliveData.timeout) {
                connection.log("Keep alive timed out.  Notifying transport that connection has been lost.");

                // Notify transport that the connection has been lost
                connection.transport.lostConnection(connection);
            } else if (timeElapsed >= keepAliveData.timeoutWarning) {
                // This is to assure that the user only gets a single warning
                if (!keepAliveData.userNotified) {
                    connection.log("Keep alive has been missed, connection may be dead/slow.");
                    $(connection).triggerHandler(events.onConnectionSlow);
                    keepAliveData.userNotified = true;
                }
            } else {
                keepAliveData.userNotified = false;
            }
        }
    }

    function getAjaxUrl(connection, path) {
        var url = connection.url + path;

        if (connection.transport) {
            url += "?transport=" + connection.transport.name;
        }

        return transportLogic.prepareQueryString(connection, url);
    }

    function InitHandler(connection) {
        this.connection = connection;

        this.startRequested = false;
        this.startCompleted = false;
        this.connectionStopped = false;
    }

    InitHandler.prototype = {
        start: function (transport, onSuccess, onFallback) {
            var that = this,
                connection = that.connection,
                failCalled = false;

            if (that.startRequested || that.connectionStopped) {
                connection.log("WARNING! " + transport.name + " transport cannot be started. Initialization ongoing or completed.");
                return;
            }

            connection.log(transport.name + " transport starting.");

            transport.start(connection, function () {
                if (!failCalled) {
                    that.initReceived(transport, onSuccess);
                }
            }, function (error) {
                // Don't allow the same transport to cause onFallback to be called twice
                if (!failCalled) {
                    failCalled = true;
                    that.transportFailed(transport, error, onFallback);
                }

                // Returns true if the transport should stop;
                // false if it should attempt to reconnect
                return !that.startCompleted || that.connectionStopped;
            });

            that.transportTimeoutHandle = window.setTimeout(function () {
                if (!failCalled) {
                    failCalled = true;
                    connection.log(transport.name + " transport timed out when trying to connect.");
                    that.transportFailed(transport, undefined, onFallback);
                }
            }, connection._.totalTransportConnectTimeout);
        },

        stop: function () {
            this.connectionStopped = true;
            window.clearTimeout(this.transportTimeoutHandle);
            signalR.transports._logic.tryAbortStartRequest(this.connection);
        },

        initReceived: function (transport, onSuccess) {
            var that = this,
                connection = that.connection;

            if (that.startRequested) {
                connection.log("WARNING! The client received multiple init messages.");
                return;
            }

            if (that.connectionStopped) {
                return;
            }

            that.startRequested = true;
            window.clearTimeout(that.transportTimeoutHandle);

            connection.log(transport.name + " transport connected. Initiating start request.");
            signalR.transports._logic.ajaxStart(connection, function () {
                that.startCompleted = true;
                onSuccess();
            });
        },

        transportFailed: function (transport, error, onFallback) {
            var connection = this.connection,
                deferred = connection._deferral,
                wrappedError;

            if (this.connectionStopped) {
                return;
            }

            window.clearTimeout(this.transportTimeoutHandle);

            if (!this.startRequested) {
                transport.stop(connection);

                connection.log(transport.name + " transport failed to connect. Attempting to fall back.");
                onFallback();
            } else if (!this.startCompleted) {
                // Do not attempt to fall back if a start request is ongoing during a transport failure.
                // Instead, trigger an error and stop the connection.
                wrappedError = signalR._.error(signalR.resources.errorDuringStartRequest, error);

                connection.log(transport.name + " transport failed during the start request. Stopping the connection.");
                $(connection).triggerHandler(events.onError, [wrappedError]);
                if (deferred) {
                    deferred.reject(wrappedError);
                }

                connection.stop();
            } else {
                // The start request has completed, but the connection has not stopped.
                // No need to do anything here. The transport should attempt its normal reconnect logic.
            }
        }
    };

    transportLogic = signalR.transports._logic = {
        ajax: function (connection, options) {
            return $.ajax(
                $.extend(/*deep copy*/ true, {}, $.signalR.ajaxDefaults, {
                    type: "GET",
                    data: {},
                    xhrFields: { withCredentials: connection.withCredentials },
                    contentType: connection.contentType,
                    dataType: connection.ajaxDataType
                }, options));
        },

        pingServer: function (connection) {
            /// <summary>Pings the server</summary>
            /// <param name="connection" type="signalr">Connection associated with the server ping</param>
            /// <returns type="signalR" />
            var url,
                xhr,
                deferral = $.Deferred();

            if (connection.transport) {
                url = connection.url + "/ping";

                url = transportLogic.addQs(url, connection.qs);

                xhr = transportLogic.ajax(connection, {
                    url: url,
                    success: function (result) {
                        var data;

                        try {
                            data = connection._parseResponse(result);
                        }
                        catch (error) {
                            deferral.reject(
                                signalR._.transportError(
                                    signalR.resources.pingServerFailedParse,
                                    connection.transport,
                                    error,
                                    xhr
                                )
                            );
                            connection.stop();
                            return;
                        }

                        if (data.Response === "pong") {
                            deferral.resolve();
                        }
                        else {
                            deferral.reject(
                                signalR._.transportError(
                                    signalR._.format(signalR.resources.pingServerFailedInvalidResponse, result),
                                    connection.transport,
                                    null /* error */,
                                    xhr
                                )
                            );
                        }
                    },
                    error: function (error) {
                        if (error.status === 401 || error.status === 403) {
                            deferral.reject(
                                signalR._.transportError(
                                    signalR._.format(signalR.resources.pingServerFailedStatusCode, error.status),
                                    connection.transport,
                                    error,
                                    xhr
                                )
                            );
                            connection.stop();
                        }
                        else {
                            deferral.reject(
                                signalR._.transportError(
                                    signalR.resources.pingServerFailed,
                                    connection.transport,
                                    error,
                                    xhr
                                )
                            );
                        }
                    }
                });
            }
            else {
                deferral.reject(
                    signalR._.transportError(
                        signalR.resources.noConnectionTransport,
                        connection.transport
                    )
                );
            }

            return deferral.promise();
        },

        prepareQueryString: function (connection, url) {
            var preparedUrl;

            // Use addQs to start since it handles the ?/& prefix for us
            preparedUrl = transportLogic.addQs(url, "clientProtocol=" + connection.clientProtocol);

            // Add the user-specified query string params if any
            preparedUrl = transportLogic.addQs(preparedUrl, connection.qs);

            if (connection.token) {
                preparedUrl += "&connectionToken=" + window.encodeURIComponent(connection.token);
            }

            if (connection.data) {
                preparedUrl += "&connectionData=" + window.encodeURIComponent(connection.data);
            }

            return preparedUrl;
        },

        addQs: function (url, qs) {
            var appender = url.indexOf("?") !== -1 ? "&" : "?",
                firstChar;

            if (!qs) {
                return url;
            }

            if (typeof (qs) === "object") {
                return url + appender + $.param(qs);
            }

            if (typeof (qs) === "string") {
                firstChar = qs.charAt(0);

                if (firstChar === "?" || firstChar === "&") {
                    appender = "";
                }

                return url + appender + qs;
            }

            throw new Error("Query string property must be either a string or object.");
        },

        // BUG #2953: The url needs to be same otherwise it will cause a memory leak
        getUrl: function (connection, transport, reconnecting, poll, ajaxPost) {
            /// <summary>Gets the url for making a GET based connect request</summary>
            var baseUrl = transport === "webSockets" ? "" : connection.baseUrl,
                url = baseUrl + connection.appRelativeUrl,
                qs = "transport=" + transport;

            if (!ajaxPost && connection.groupsToken) {
                qs += "&groupsToken=" + window.encodeURIComponent(connection.groupsToken);
            }

            if (!reconnecting) {
                url += "/connect";
            } else {
                if (poll) {
                    // longPolling transport specific
                    url += "/poll";
                } else {
                    url += "/reconnect";
                }

                if (!ajaxPost && connection.messageId) {
                    qs += "&messageId=" + window.encodeURIComponent(connection.messageId);
                }
            }
            url += "?" + qs;
            url = transportLogic.prepareQueryString(connection, url);

            if (!ajaxPost) {
                url += "&tid=" + Math.floor(Math.random() * 11);
            }

            return url;
        },

        maximizePersistentResponse: function (minPersistentResponse) {
            return {
                MessageId: minPersistentResponse.C,
                Messages: minPersistentResponse.M,
                Initialized: typeof (minPersistentResponse.S) !== "undefined" ? true : false,
                ShouldReconnect: typeof (minPersistentResponse.T) !== "undefined" ? true : false,
                LongPollDelay: minPersistentResponse.L,
                GroupsToken: minPersistentResponse.G
            };
        },

        updateGroups: function (connection, groupsToken) {
            if (groupsToken) {
                connection.groupsToken = groupsToken;
            }
        },

        stringifySend: function (connection, message) {
            if (typeof (message) === "string" || typeof (message) === "undefined" || message === null) {
                return message;
            }
            return connection.json.stringify(message);
        },

        ajaxSend: function (connection, data) {
            var payload = transportLogic.stringifySend(connection, data),
                url = getAjaxUrl(connection, "/send"),
                xhr,
                onFail = function (error, connection) {
                    $(connection).triggerHandler(events.onError, [signalR._.transportError(signalR.resources.sendFailed, connection.transport, error, xhr), data]);
                };


            xhr = transportLogic.ajax(connection, {
                url: url,
                type: connection.ajaxDataType === "jsonp" ? "GET" : "POST",
                contentType: signalR._.defaultContentType,
                data: {
                    data: payload
                },
                success: function (result) {
                    var res;

                    if (result) {
                        try {
                            res = connection._parseResponse(result);
                        }
                        catch (error) {
                            onFail(error, connection);
                            connection.stop();
                            return;
                        }

                        transportLogic.triggerReceived(connection, res);
                    }
                },
                error: function (error, textStatus) {
                    if (textStatus === "abort" || textStatus === "parsererror") {
                        // The parsererror happens for sends that don't return any data, and hence
                        // don't write the jsonp callback to the response. This is harder to fix on the server
                        // so just hack around it on the client for now.
                        return;
                    }

                    onFail(error, connection);
                }
            });

            return xhr;
        },

        ajaxAbort: function (connection, async) {
            if (typeof (connection.transport) === "undefined") {
                return;
            }

            // Async by default unless explicitly overidden
            async = typeof async === "undefined" ? true : async;

            var url = getAjaxUrl(connection, "/abort");

            transportLogic.ajax(connection, {
                url: url,
                async: async,
                timeout: 1000,
                type: "POST"
            });

            connection.log("Fired ajax abort async = " + async + ".");
        },

        ajaxStart: function (connection, onSuccess) {
            var rejectDeferred = function (error) {
                    var deferred = connection._deferral;
                    if (deferred) {
                        deferred.reject(error);
                    }
                },
                triggerStartError = function (error) {
                    connection.log("The start request failed. Stopping the connection.");
                    $(connection).triggerHandler(events.onError, [error]);
                    rejectDeferred(error);
                    connection.stop();
                };

            connection._.startRequest = transportLogic.ajax(connection, {
                url: getAjaxUrl(connection, "/start"),
                success: function (result, statusText, xhr) {
                    var data;

                    try {
                        data = connection._parseResponse(result);
                    } catch (error) {
                        triggerStartError(signalR._.error(
                            signalR._.format(signalR.resources.errorParsingStartResponse, result),
                            error, xhr));
                        return;
                    }

                    if (data.Response === "started") {
                        onSuccess();
                    } else {
                        triggerStartError(signalR._.error(
                            signalR._.format(signalR.resources.invalidStartResponse, result),
                            null /* error */, xhr));
                    }
                },
                error: function (xhr, statusText, error) {
                    if (statusText !== startAbortText) {
                        triggerStartError(signalR._.error(
                            signalR.resources.errorDuringStartRequest,
                            error, xhr));
                    } else {
                        // Stop has been called, no need to trigger the error handler
                        // or stop the connection again with onStartError
                        connection.log("The start request aborted because connection.stop() was called.");
                        rejectDeferred(signalR._.error(
                            signalR.resources.stoppedDuringStartRequest,
                            null /* error */, xhr));
                    }
                }
            });
        },

        tryAbortStartRequest: function (connection) {
            if (connection._.startRequest) {
                // If the start request has already completed this will noop.
                connection._.startRequest.abort(startAbortText);
                delete connection._.startRequest;
            }
        },

        tryInitialize: function (connection, persistentResponse, onInitialized) {
            if (persistentResponse.Initialized && onInitialized) {
                onInitialized();
            } else if (persistentResponse.Initialized) {
                connection.log("WARNING! The client received an init message after reconnecting.");
            }

        },

        triggerReceived: function (connection, data) {
            if (!connection._.connectingMessageBuffer.tryBuffer(data)) {
                $(connection).triggerHandler(events.onReceived, [data]);
            }
        },

        processMessages: function (connection, minData, onInitialized) {
            var data;

            // Update the last message time stamp
            transportLogic.markLastMessage(connection);

            if (minData) {
                data = transportLogic.maximizePersistentResponse(minData);

                transportLogic.updateGroups(connection, data.GroupsToken);

                if (data.MessageId) {
                    connection.messageId = data.MessageId;
                }

                if (data.Messages) {
                    $.each(data.Messages, function (index, message) {
                        transportLogic.triggerReceived(connection, message);
                    });

                    transportLogic.tryInitialize(connection, data, onInitialized);
                }
            }
        },

        monitorKeepAlive: function (connection) {
            var keepAliveData = connection._.keepAliveData;

            // If we haven't initiated the keep alive timeouts then we need to
            if (!keepAliveData.monitoring) {
                keepAliveData.monitoring = true;

                transportLogic.markLastMessage(connection);

                // Save the function so we can unbind it on stop
                connection._.keepAliveData.reconnectKeepAliveUpdate = function () {
                    // Mark a new message so that keep alive doesn't time out connections
                    transportLogic.markLastMessage(connection);
                };

                // Update Keep alive on reconnect
                $(connection).bind(events.onReconnect, connection._.keepAliveData.reconnectKeepAliveUpdate);

                connection.log("Now monitoring keep alive with a warning timeout of " + keepAliveData.timeoutWarning + ", keep alive timeout of " + keepAliveData.timeout + " and disconnecting timeout of " + connection.disconnectTimeout);
            } else {
                connection.log("Tried to monitor keep alive but it's already being monitored.");
            }
        },

        stopMonitoringKeepAlive: function (connection) {
            var keepAliveData = connection._.keepAliveData;

            // Only attempt to stop the keep alive monitoring if its being monitored
            if (keepAliveData.monitoring) {
                // Stop monitoring
                keepAliveData.monitoring = false;

                // Remove the updateKeepAlive function from the reconnect event
                $(connection).unbind(events.onReconnect, connection._.keepAliveData.reconnectKeepAliveUpdate);

                // Clear all the keep alive data
                connection._.keepAliveData = {};
                connection.log("Stopping the monitoring of the keep alive.");
            }
        },

        startHeartbeat: function (connection) {
            connection._.lastActiveAt = new Date().getTime();
            beat(connection);
        },

        markLastMessage: function (connection) {
            connection._.lastMessageAt = new Date().getTime();
        },

        markActive: function (connection) {
            if (transportLogic.verifyLastActive(connection)) {
                connection._.lastActiveAt = new Date().getTime();
                return true;
            }

            return false;
        },

        isConnectedOrReconnecting: function (connection) {
            return connection.state === signalR.connectionState.connected ||
                   connection.state === signalR.connectionState.reconnecting;
        },

        ensureReconnectingState: function (connection) {
            if (changeState(connection,
                        signalR.connectionState.connected,
                        signalR.connectionState.reconnecting) === true) {
                $(connection).triggerHandler(events.onReconnecting);
            }
            return connection.state === signalR.connectionState.reconnecting;
        },

        clearReconnectTimeout: function (connection) {
            if (connection && connection._.reconnectTimeout) {
                window.clearTimeout(connection._.reconnectTimeout);
                delete connection._.reconnectTimeout;
            }
        },

        verifyLastActive: function (connection) {
            if (new Date().getTime() - connection._.lastActiveAt >= connection.reconnectWindow) {
                var message = signalR._.format(signalR.resources.reconnectWindowTimeout, new Date(connection._.lastActiveAt), connection.reconnectWindow);
                connection.log(message);
                $(connection).triggerHandler(events.onError, [signalR._.error(message, /* source */ "TimeoutException")]);
                connection.stop(/* async */ false, /* notifyServer */ false);
                return false;
            }

            return true;
        },

        reconnect: function (connection, transportName) {
            var transport = signalR.transports[transportName];

            // We should only set a reconnectTimeout if we are currently connected
            // and a reconnectTimeout isn't already set.
            if (transportLogic.isConnectedOrReconnecting(connection) && !connection._.reconnectTimeout) {
                // Need to verify before the setTimeout occurs because an application sleep could occur during the setTimeout duration.
                if (!transportLogic.verifyLastActive(connection)) {
                    return;
                }

                connection._.reconnectTimeout = window.setTimeout(function () {
                    if (!transportLogic.verifyLastActive(connection)) {
                        return;
                    }

                    transport.stop(connection);

                    if (transportLogic.ensureReconnectingState(connection)) {
                        connection.log(transportName + " reconnecting.");
                        transport.start(connection);
                    }
                }, connection.reconnectDelay);
            }
        },

        handleParseFailure: function (connection, result, error, onFailed, context) {
            var wrappedError = signalR._.transportError(
                signalR._.format(signalR.resources.parseFailed, result),
                connection.transport,
                error,
                context);

            // If we're in the initialization phase trigger onFailed, otherwise stop the connection.
            if (onFailed && onFailed(wrappedError)) {
                connection.log("Failed to parse server response while attempting to connect.");
            } else {
                $(connection).triggerHandler(events.onError, [wrappedError]);
                connection.stop();
            }
        },

        initHandler: function (connection) {
            return new InitHandler(connection);
        },

        foreverFrame: {
            count: 0,
            connections: {}
        }
    };

}(window.jQuery, window));
/* jquery.signalR.transports.webSockets.js */
// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.


/*global window:false */
/// <reference path="jquery.signalR.transports.common.js" />

(function ($, window, undefined) {

    var signalR = $.signalR,
        events = $.signalR.events,
        changeState = $.signalR.changeState,
        transportLogic = signalR.transports._logic;

    signalR.transports.webSockets = {
        name: "webSockets",

        supportsKeepAlive: function () {
            return true;
        },

        send: function (connection, data) {
            var payload = transportLogic.stringifySend(connection, data);

            try {
                connection.socket.send(payload);
            } catch (ex) {
                $(connection).triggerHandler(events.onError,
                    [signalR._.transportError(
                        signalR.resources.webSocketsInvalidState,
                        connection.transport,
                        ex,
                        connection.socket
                    ),
                    data]);
            }
        },

        start: function (connection, onSuccess, onFailed) {
            var url,
                opened = false,
                that = this,
                reconnecting = !onSuccess,
                $connection = $(connection);

            if (!window.WebSocket) {
                onFailed();
                return;
            }

            if (!connection.socket) {
                if (connection.webSocketServerUrl) {
                    url = connection.webSocketServerUrl;
                } else {
                    url = connection.wsProtocol + connection.host;
                }

                url += transportLogic.getUrl(connection, this.name, reconnecting);

                connection.log("Connecting to websocket endpoint '" + url + "'.");
                connection.socket = new window.WebSocket(url);

                connection.socket.onopen = function () {
                    opened = true;
                    connection.log("Websocket opened.");

                    transportLogic.clearReconnectTimeout(connection);

                    if (changeState(connection,
                                    signalR.connectionState.reconnecting,
                                    signalR.connectionState.connected) === true) {
                        $connection.triggerHandler(events.onReconnect);
                    }
                };

                connection.socket.onclose = function (event) {
                    var error;

                    // Only handle a socket close if the close is from the current socket.
                    // Sometimes on disconnect the server will push down an onclose event
                    // to an expired socket.

                    if (this === connection.socket) {
                        if (opened && typeof event.wasClean !== "undefined" && event.wasClean === false) {
                            // Ideally this would use the websocket.onerror handler (rather than checking wasClean in onclose) but
                            // I found in some circumstances Chrome won't call onerror. This implementation seems to work on all browsers.
                            error = signalR._.transportError(
                                signalR.resources.webSocketClosed,
                                connection.transport,
                                event);

                            connection.log("Unclean disconnect from websocket: " + (event.reason || "[no reason given]."));
                        } else {
                            connection.log("Websocket closed.");
                        }

                        if (!onFailed || !onFailed(error)) {
                            if (error) {
                                $(connection).triggerHandler(events.onError, [error]);
                            }

                            that.reconnect(connection);
                        }
                    }
                };

                connection.socket.onmessage = function (event) {
                    var data;

                    try {
                        data = connection._parseResponse(event.data);
                    }
                    catch (error) {
                        transportLogic.handleParseFailure(connection, event.data, error, onFailed, event);
                        return;
                    }

                    if (data) {
                        // data.M is PersistentResponse.Messages
                        if ($.isEmptyObject(data) || data.M) {
                            transportLogic.processMessages(connection, data, onSuccess);
                        } else {
                            // For websockets we need to trigger onReceived
                            // for callbacks to outgoing hub calls.
                            transportLogic.triggerReceived(connection, data);
                        }
                    }
                };
            }
        },

        reconnect: function (connection) {
            transportLogic.reconnect(connection, this.name);
        },

        lostConnection: function (connection) {
            this.reconnect(connection);
        },

        stop: function (connection) {
            // Don't trigger a reconnect after stopping
            transportLogic.clearReconnectTimeout(connection);

            if (connection.socket) {
                connection.log("Closing the Websocket.");
                connection.socket.close();
                connection.socket = null;
            }
        },

        abort: function (connection, async) {
            transportLogic.ajaxAbort(connection, async);
        }
    };

}(window.jQuery, window));
/* jquery.signalR.transports.serverSentEvents.js */
// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.


/*global window:false */
/// <reference path="jquery.signalR.transports.common.js" />

(function ($, window, undefined) {

    var signalR = $.signalR,
        events = $.signalR.events,
        changeState = $.signalR.changeState,
        transportLogic = signalR.transports._logic,
        clearReconnectAttemptTimeout = function (connection) {
            window.clearTimeout(connection._.reconnectAttemptTimeoutHandle);
            delete connection._.reconnectAttemptTimeoutHandle;
        };

    signalR.transports.serverSentEvents = {
        name: "serverSentEvents",

        supportsKeepAlive: function () {
            return true;
        },

        timeOut: 3000,

        start: function (connection, onSuccess, onFailed) {
            var that = this,
                opened = false,
                $connection = $(connection),
                reconnecting = !onSuccess,
                url;

            if (connection.eventSource) {
                connection.log("The connection already has an event source. Stopping it.");
                connection.stop();
            }

            if (!window.EventSource) {
                if (onFailed) {
                    connection.log("This browser doesn't support SSE.");
                    onFailed();
                }
                return;
            }

            url = transportLogic.getUrl(connection, this.name, reconnecting);

            try {
                connection.log("Attempting to connect to SSE endpoint '" + url + "'.");
                connection.eventSource = new window.EventSource(url, { withCredentials: connection.withCredentials });
            }
            catch (e) {
                connection.log("EventSource failed trying to connect with error " + e.Message + ".");
                if (onFailed) {
                    // The connection failed, call the failed callback
                    onFailed();
                } else {
                    $connection.triggerHandler(events.onError, [signalR._.transportError(signalR.resources.eventSourceFailedToConnect, connection.transport, e)]);
                    if (reconnecting) {
                        // If we were reconnecting, rather than doing initial connect, then try reconnect again
                        that.reconnect(connection);
                    }
                }
                return;
            }

            if (reconnecting) {
                connection._.reconnectAttemptTimeoutHandle = window.setTimeout(function () {
                    if (opened === false) {
                        // If we're reconnecting and the event source is attempting to connect,
                        // don't keep retrying. This causes duplicate connections to spawn.
                        if (connection.eventSource.readyState !== window.EventSource.OPEN) {
                            // If we were reconnecting, rather than doing initial connect, then try reconnect again
                            that.reconnect(connection);
                        }
                    }
                },
                that.timeOut);
            }

            connection.eventSource.addEventListener("open", function (e) {
                connection.log("EventSource connected.");

                clearReconnectAttemptTimeout(connection);
                transportLogic.clearReconnectTimeout(connection);

                if (opened === false) {
                    opened = true;

                    if (changeState(connection,
                                         signalR.connectionState.reconnecting,
                                         signalR.connectionState.connected) === true) {
                        $connection.triggerHandler(events.onReconnect);
                    }
                }
            }, false);

            connection.eventSource.addEventListener("message", function (e) {
                var res;

                // process messages
                if (e.data === "initialized") {
                    return;
                }

                try {
                    res = connection._parseResponse(e.data);
                }
                catch (error) {
                    transportLogic.handleParseFailure(connection, e.data, error, onFailed, e);
                    return;
                }

                transportLogic.processMessages(connection, res, onSuccess);
            }, false);

            connection.eventSource.addEventListener("error", function (e) {
                var error = signalR._.transportError(
                    signalR.resources.eventSourceError,
                    connection.transport,
                    e);

                // Only handle an error if the error is from the current Event Source.
                // Sometimes on disconnect the server will push down an error event
                // to an expired Event Source.
                if (this !== connection.eventSource) {
                    return;
                }

                if (onFailed && onFailed(error)) {
                    return;
                }

                connection.log("EventSource readyState: " + connection.eventSource.readyState + ".");

                if (e.eventPhase === window.EventSource.CLOSED) {
                    // We don't use the EventSource's native reconnect function as it
                    // doesn't allow us to change the URL when reconnecting. We need
                    // to change the URL to not include the /connect suffix, and pass
                    // the last message id we received.
                    connection.log("EventSource reconnecting due to the server connection ending.");
                    that.reconnect(connection);
                } else {
                    // connection error
                    connection.log("EventSource error.");
                    $connection.triggerHandler(events.onError, [error]);
                }
            }, false);
        },

        reconnect: function (connection) {
            transportLogic.reconnect(connection, this.name);
        },

        lostConnection: function (connection) {
            this.reconnect(connection);
        },

        send: function (connection, data) {
            transportLogic.ajaxSend(connection, data);
        },

        stop: function (connection) {
            // Don't trigger a reconnect after stopping
            clearReconnectAttemptTimeout(connection);
            transportLogic.clearReconnectTimeout(connection);

            if (connection && connection.eventSource) {
                connection.log("EventSource calling close().");
                connection.eventSource.close();
                connection.eventSource = null;
                delete connection.eventSource;
            }
        },

        abort: function (connection, async) {
            transportLogic.ajaxAbort(connection, async);
        }
    };

}(window.jQuery, window));
/* jquery.signalR.transports.foreverFrame.js */
// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.


/*global window:false */
/// <reference path="jquery.signalR.transports.common.js" />

(function ($, window, undefined) {

    var signalR = $.signalR,
        events = $.signalR.events,
        changeState = $.signalR.changeState,
        transportLogic = signalR.transports._logic,
        createFrame = function () {
            var frame = window.document.createElement("iframe");
            frame.setAttribute("style", "position:absolute;top:0;left:0;width:0;height:0;visibility:hidden;");
            return frame;
        },
        // Used to prevent infinite loading icon spins in older versions of ie
        // We build this object inside a closure so we don't pollute the rest of
        // the foreverFrame transport with unnecessary functions/utilities.
        loadPreventer = (function () {
            var loadingFixIntervalId = null,
                loadingFixInterval = 1000,
                attachedTo = 0;

            return {
                prevent: function () {
                    // Prevent additional iframe removal procedures from newer browsers
                    if (signalR._.ieVersion <= 8) {
                        // We only ever want to set the interval one time, so on the first attachedTo
                        if (attachedTo === 0) {
                            // Create and destroy iframe every 3 seconds to prevent loading icon, super hacky
                            loadingFixIntervalId = window.setInterval(function () {
                                var tempFrame = createFrame();

                                window.document.body.appendChild(tempFrame);
                                window.document.body.removeChild(tempFrame);

                                tempFrame = null;
                            }, loadingFixInterval);
                        }

                        attachedTo++;
                    }
                },
                cancel: function () {
                    // Only clear the interval if there's only one more object that the loadPreventer is attachedTo
                    if (attachedTo === 1) {
                        window.clearInterval(loadingFixIntervalId);
                    }

                    if (attachedTo > 0) {
                        attachedTo--;
                    }
                }
            };
        })();

    signalR.transports.foreverFrame = {
        name: "foreverFrame",

        supportsKeepAlive: function () {
            return true;
        },

        // Added as a value here so we can create tests to verify functionality
        iframeClearThreshold: 50,

        start: function (connection, onSuccess, onFailed) {
            var that = this,
                frameId = (transportLogic.foreverFrame.count += 1),
                url,
                frame = createFrame(),
                frameLoadHandler = function () {
                    connection.log("Forever frame iframe finished loading and is no longer receiving messages.");
                    if (!onFailed || !onFailed()) {
                        that.reconnect(connection);
                    }
                };

            if (window.EventSource) {
                // If the browser supports SSE, don't use Forever Frame
                if (onFailed) {
                    connection.log("Forever Frame is not supported by SignalR on browsers with SSE support.");
                    onFailed();
                }
                return;
            }

            frame.setAttribute("data-signalr-connection-id", connection.id);

            // Start preventing loading icon
            // This will only perform work if the loadPreventer is not attached to another connection.
            loadPreventer.prevent();

            // Build the url
            url = transportLogic.getUrl(connection, this.name);
            url += "&frameId=" + frameId;

            // add frame to the document prior to setting URL to avoid caching issues.
            window.document.documentElement.appendChild(frame);

            connection.log("Binding to iframe's load event.");

            if (frame.addEventListener) {
                frame.addEventListener("load", frameLoadHandler, false);
            } else if (frame.attachEvent) {
                frame.attachEvent("onload", frameLoadHandler);
            }

            frame.src = url;
            transportLogic.foreverFrame.connections[frameId] = connection;

            connection.frame = frame;
            connection.frameId = frameId;

            if (onSuccess) {
                connection.onSuccess = function () {
                    connection.log("Iframe transport started.");
                    onSuccess();
                };
            }
        },

        reconnect: function (connection) {
            var that = this;

            // Need to verify connection state and verify before the setTimeout occurs because an application sleep could occur during the setTimeout duration.
            if (transportLogic.isConnectedOrReconnecting(connection) && transportLogic.verifyLastActive(connection)) {
                window.setTimeout(function () {
                    // Verify that we're ok to reconnect.
                    if (!transportLogic.verifyLastActive(connection)) {
                        return;
                    }

                    if (connection.frame && transportLogic.ensureReconnectingState(connection)) {
                        var frame = connection.frame,
                            src = transportLogic.getUrl(connection, that.name, true) + "&frameId=" + connection.frameId;
                        connection.log("Updating iframe src to '" + src + "'.");
                        frame.src = src;
                    }
                }, connection.reconnectDelay);
            }
        },

        lostConnection: function (connection) {
            this.reconnect(connection);
        },

        send: function (connection, data) {
            transportLogic.ajaxSend(connection, data);
        },

        receive: function (connection, data) {
            var cw,
                body,
                response;

            if (connection.json !== connection._originalJson) {
                // If there's a custom JSON parser configured then serialize the object
                // using the original (browser) JSON parser and then deserialize it using
                // the custom parser (connection._parseResponse does that). This is so we
                // can easily send the response from the server as "raw" JSON but still
                // support custom JSON deserialization in the browser.
                data = connection._originalJson.stringify(data);
            }

            response = connection._parseResponse(data);

            transportLogic.processMessages(connection, response, connection.onSuccess);

            // Protect against connection stopping from a callback trigger within the processMessages above.
            if (connection.state === $.signalR.connectionState.connected) {
                // Delete the script & div elements
                connection.frameMessageCount = (connection.frameMessageCount || 0) + 1;
                if (connection.frameMessageCount > signalR.transports.foreverFrame.iframeClearThreshold) {
                    connection.frameMessageCount = 0;
                    cw = connection.frame.contentWindow || connection.frame.contentDocument;
                    if (cw && cw.document && cw.document.body) {
                        body = cw.document.body;

                        // Remove all the child elements from the iframe's body to conserver memory
                        while (body.firstChild) {
                            body.removeChild(body.firstChild);
                        }
                    }
                }
            }
        },

        stop: function (connection) {
            var cw = null;

            // Stop attempting to prevent loading icon
            loadPreventer.cancel();

            if (connection.frame) {
                if (connection.frame.stop) {
                    connection.frame.stop();
                } else {
                    try {
                        cw = connection.frame.contentWindow || connection.frame.contentDocument;
                        if (cw.document && cw.document.execCommand) {
                            cw.document.execCommand("Stop");
                        }
                    }
                    catch (e) {
                        connection.log("Error occurred when stopping foreverFrame transport. Message = " + e.message + ".");
                    }
                }

                // Ensure the iframe is where we left it
                if (connection.frame.parentNode === window.document.documentElement) {
                    window.document.documentElement.removeChild(connection.frame);
                }

                delete transportLogic.foreverFrame.connections[connection.frameId];
                connection.frame = null;
                connection.frameId = null;
                delete connection.frame;
                delete connection.frameId;
                delete connection.onSuccess;
                delete connection.frameMessageCount;
                connection.log("Stopping forever frame.");
            }
        },

        abort: function (connection, async) {
            transportLogic.ajaxAbort(connection, async);
        },

        getConnection: function (id) {
            return transportLogic.foreverFrame.connections[id];
        },

        started: function (connection) {
            if (changeState(connection,
                signalR.connectionState.reconnecting,
                signalR.connectionState.connected) === true) {

                $(connection).triggerHandler(events.onReconnect);
            }
        }
    };

}(window.jQuery, window));
/* jquery.signalR.transports.longPolling.js */
// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.


/*global window:false */
/// <reference path="jquery.signalR.transports.common.js" />

(function ($, window, undefined) {

    var signalR = $.signalR,
        events = $.signalR.events,
        changeState = $.signalR.changeState,
        isDisconnecting = $.signalR.isDisconnecting,
        transportLogic = signalR.transports._logic;

    signalR.transports.longPolling = {
        name: "longPolling",

        supportsKeepAlive: function () {
            return false;
        },

        reconnectDelay: 3000,

        start: function (connection, onSuccess, onFailed) {
            /// <summary>Starts the long polling connection</summary>
            /// <param name="connection" type="signalR">The SignalR connection to start</param>
            var that = this,
                fireConnect = function () {
                    fireConnect = $.noop;

                    connection.log("LongPolling connected.");

                    if (onSuccess) {
                        onSuccess();
                    } else {
                        connection.log("WARNING! The client received an init message after reconnecting.");
                    }
                },
                tryFailConnect = function (error) {
                    if (onFailed(error)) {
                        connection.log("LongPolling failed to connect.");
                        return true;
                    }

                    return false;
                },
                privateData = connection._,
                reconnectErrors = 0,
                fireReconnected = function (instance) {
                    window.clearTimeout(privateData.reconnectTimeoutId);
                    privateData.reconnectTimeoutId = null;

                    if (changeState(instance,
                                    signalR.connectionState.reconnecting,
                                    signalR.connectionState.connected) === true) {
                        // Successfully reconnected!
                        instance.log("Raising the reconnect event");
                        $(instance).triggerHandler(events.onReconnect);
                    }
                },
                // 1 hour
                maxFireReconnectedTimeout = 3600000;

            if (connection.pollXhr) {
                connection.log("Polling xhr requests already exists, aborting.");
                connection.stop();
            }

            connection.messageId = null;

            privateData.reconnectTimeoutId = null;

            privateData.pollTimeoutId = window.setTimeout(function () {
                (function poll(instance, raiseReconnect) {
                    var messageId = instance.messageId,
                        connect = (messageId === null),
                        reconnecting = !connect,
                        polling = !raiseReconnect,
                        url = transportLogic.getUrl(instance, that.name, reconnecting, polling, true /* use Post for longPolling */),
                        postData = {};

                    if (instance.messageId) {
                        postData.messageId = instance.messageId;
                    }

                    if (instance.groupsToken) {
                        postData.groupsToken = instance.groupsToken;
                    }

                    // If we've disconnected during the time we've tried to re-instantiate the poll then stop.
                    if (isDisconnecting(instance) === true) {
                        return;
                    }

                    connection.log("Opening long polling request to '" + url + "'.");
                    instance.pollXhr = transportLogic.ajax(connection, {
                        xhrFields: {
                            onprogress: function () {
                                transportLogic.markLastMessage(connection);
                            }
                        },
                        url: url,
                        type: "POST",
                        contentType: signalR._.defaultContentType,
                        data: postData,
                        timeout: connection._.pollTimeout,
                        success: function (result) {
                            var minData,
                                delay = 0,
                                data,
                                shouldReconnect;

                            connection.log("Long poll complete.");

                            // Reset our reconnect errors so if we transition into a reconnecting state again we trigger
                            // reconnected quickly
                            reconnectErrors = 0;

                            try {
                                // Remove any keep-alives from the beginning of the result
                                minData = connection._parseResponse(result);
                            }
                            catch (error) {
                                transportLogic.handleParseFailure(instance, result, error, tryFailConnect, instance.pollXhr);
                                return;
                            }

                            // If there's currently a timeout to trigger reconnect, fire it now before processing messages
                            if (privateData.reconnectTimeoutId !== null) {
                                fireReconnected(instance);
                            }

                            if (minData) {
                                data = transportLogic.maximizePersistentResponse(minData);
                            }

                            transportLogic.processMessages(instance, minData, fireConnect);

                            if (data &&
                                $.type(data.LongPollDelay) === "number") {
                                delay = data.LongPollDelay;
                            }

                            if (isDisconnecting(instance) === true) {
                                return;
                            }

                            shouldReconnect = data && data.ShouldReconnect;
                            if (shouldReconnect) {
                                // Transition into the reconnecting state
                                // If this fails then that means that the user transitioned the connection into a invalid state in processMessages.
                                if (!transportLogic.ensureReconnectingState(instance)) {
                                    return;
                                }
                            }

                            // We never want to pass a raiseReconnect flag after a successful poll.  This is handled via the error function
                            if (delay > 0) {
                                privateData.pollTimeoutId = window.setTimeout(function () {
                                    poll(instance, shouldReconnect);
                                }, delay);
                            } else {
                                poll(instance, shouldReconnect);
                            }
                        },

                        error: function (data, textStatus) {
                            var error = signalR._.transportError(signalR.resources.longPollFailed, connection.transport, data, instance.pollXhr);

                            // Stop trying to trigger reconnect, connection is in an error state
                            // If we're not in the reconnect state this will noop
                            window.clearTimeout(privateData.reconnectTimeoutId);
                            privateData.reconnectTimeoutId = null;

                            if (textStatus === "abort") {
                                connection.log("Aborted xhr request.");
                                return;
                            }

                            if (!tryFailConnect(error)) {

                                // Increment our reconnect errors, we assume all errors to be reconnect errors
                                // In the case that it's our first error this will cause Reconnect to be fired
                                // after 1 second due to reconnectErrors being = 1.
                                reconnectErrors++;

                                if (connection.state !== signalR.connectionState.reconnecting) {
                                    connection.log("An error occurred using longPolling. Status = " + textStatus + ".  Response = " + data.responseText + ".");
                                    $(instance).triggerHandler(events.onError, [error]);
                                }

                                // We check the state here to verify that we're not in an invalid state prior to verifying Reconnect.
                                // If we're not in connected or reconnecting then the next ensureReconnectingState check will fail and will return.
                                // Therefore we don't want to change that failure code path.
                                if ((connection.state === signalR.connectionState.connected ||
                                    connection.state === signalR.connectionState.reconnecting) &&
                                    !transportLogic.verifyLastActive(connection)) {
                                    return;
                                }

                                // Transition into the reconnecting state
                                // If this fails then that means that the user transitioned the connection into the disconnected or connecting state within the above error handler trigger.
                                if (!transportLogic.ensureReconnectingState(instance)) {
                                    return;
                                }

                                // Call poll with the raiseReconnect flag as true after the reconnect delay
                                privateData.pollTimeoutId = window.setTimeout(function () {
                                    poll(instance, true);
                                }, that.reconnectDelay);
                            }
                        }
                    });

                    // This will only ever pass after an error has occurred via the poll ajax procedure.
                    if (reconnecting && raiseReconnect === true) {
                        // We wait to reconnect depending on how many times we've failed to reconnect.
                        // This is essentially a heuristic that will exponentially increase in wait time before
                        // triggering reconnected.  This depends on the "error" handler of Poll to cancel this
                        // timeout if it triggers before the Reconnected event fires.
                        // The Math.min at the end is to ensure that the reconnect timeout does not overflow.
                        privateData.reconnectTimeoutId = window.setTimeout(function () { fireReconnected(instance); }, Math.min(1000 * (Math.pow(2, reconnectErrors) - 1), maxFireReconnectedTimeout));
                    }
                }(connection));
            }, 250); // Have to delay initial poll so Chrome doesn't show loader spinner in tab
        },

        lostConnection: function (connection) {
            if (connection.pollXhr) {
                connection.pollXhr.abort("lostConnection");
            }
        },

        send: function (connection, data) {
            transportLogic.ajaxSend(connection, data);
        },

        stop: function (connection) {
            /// <summary>Stops the long polling connection</summary>
            /// <param name="connection" type="signalR">The SignalR connection to stop</param>

            window.clearTimeout(connection._.pollTimeoutId);
            window.clearTimeout(connection._.reconnectTimeoutId);

            delete connection._.pollTimeoutId;
            delete connection._.reconnectTimeoutId;

            if (connection.pollXhr) {
                connection.pollXhr.abort();
                connection.pollXhr = null;
                delete connection.pollXhr;
            }
        },

        abort: function (connection, async) {
            transportLogic.ajaxAbort(connection, async);
        }
    };

}(window.jQuery, window));
/* jquery.signalR.hubs.js */
// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

/*global window:false */
/// <reference path="jquery.signalR.core.js" />

(function ($, window, undefined) {

    var eventNamespace = ".hubProxy",
        signalR = $.signalR;

    function makeEventName(event) {
        return event + eventNamespace;
    }

    // Equivalent to Array.prototype.map
    function map(arr, fun, thisp) {
        var i,
            length = arr.length,
            result = [];
        for (i = 0; i < length; i += 1) {
            if (arr.hasOwnProperty(i)) {
                result[i] = fun.call(thisp, arr[i], i, arr);
            }
        }
        return result;
    }

    function getArgValue(a) {
        return $.isFunction(a) ? null : ($.type(a) === "undefined" ? null : a);
    }

    function hasMembers(obj) {
        for (var key in obj) {
            // If we have any properties in our callback map then we have callbacks and can exit the loop via return
            if (obj.hasOwnProperty(key)) {
                return true;
            }
        }

        return false;
    }

    function clearInvocationCallbacks(connection, error) {
        /// <param name="connection" type="hubConnection" />
        var callbacks = connection._.invocationCallbacks,
            callback;

        if (hasMembers(callbacks)) {
            connection.log("Clearing hub invocation callbacks with error: " + error + ".");
        }

        // Reset the callback cache now as we have a local var referencing it
        connection._.invocationCallbackId = 0;
        delete connection._.invocationCallbacks;
        connection._.invocationCallbacks = {};

        // Loop over the callbacks and invoke them.
        // We do this using a local var reference and *after* we've cleared the cache
        // so that if a fail callback itself tries to invoke another method we don't
        // end up with its callback in the list we're looping over.
        for (var callbackId in callbacks) {
            callback = callbacks[callbackId];
            callback.method.call(callback.scope, { E: error });
        }
    }

    // hubProxy
    function hubProxy(hubConnection, hubName) {
        /// <summary>
        ///     Creates a new proxy object for the given hub connection that can be used to invoke
        ///     methods on server hubs and handle client method invocation requests from the server.
        /// </summary>
        return new hubProxy.fn.init(hubConnection, hubName);
    }

    hubProxy.fn = hubProxy.prototype = {
        init: function (connection, hubName) {
            this.state = {};
            this.connection = connection;
            this.hubName = hubName;
            this._ = {
                callbackMap: {}
            };
        },

        constructor: hubProxy,

        hasSubscriptions: function () {
            return hasMembers(this._.callbackMap);
        },

        on: function (eventName, callback) {
            /// <summary>Wires up a callback to be invoked when a invocation request is received from the server hub.</summary>
            /// <param name="eventName" type="String">The name of the hub event to register the callback for.</param>
            /// <param name="callback" type="Function">The callback to be invoked.</param>
            var that = this,
                callbackMap = that._.callbackMap;

            // Normalize the event name to lowercase
            eventName = eventName.toLowerCase();

            // If there is not an event registered for this callback yet we want to create its event space in the callback map.
            if (!callbackMap[eventName]) {
                callbackMap[eventName] = {};
            }

            // Map the callback to our encompassed function
            callbackMap[eventName][callback] = function (e, data) {
                callback.apply(that, data);
            };

            $(that).bind(makeEventName(eventName), callbackMap[eventName][callback]);

            return that;
        },

        off: function (eventName, callback) {
            /// <summary>Removes the callback invocation request from the server hub for the given event name.</summary>
            /// <param name="eventName" type="String">The name of the hub event to unregister the callback for.</param>
            /// <param name="callback" type="Function">The callback to be invoked.</param>
            var that = this,
                callbackMap = that._.callbackMap,
                callbackSpace;

            // Normalize the event name to lowercase
            eventName = eventName.toLowerCase();

            callbackSpace = callbackMap[eventName];

            // Verify that there is an event space to unbind
            if (callbackSpace) {
                // Only unbind if there's an event bound with eventName and a callback with the specified callback
                if (callbackSpace[callback]) {
                    $(that).unbind(makeEventName(eventName), callbackSpace[callback]);

                    // Remove the callback from the callback map
                    delete callbackSpace[callback];

                    // Check if there are any members left on the event, if not we need to destroy it.
                    if (!hasMembers(callbackSpace)) {
                        delete callbackMap[eventName];
                    }
                } else if (!callback) { // Check if we're removing the whole event and we didn't error because of an invalid callback
                    $(that).unbind(makeEventName(eventName));

                    delete callbackMap[eventName];
                }
            }

            return that;
        },

        invoke: function (methodName) {
            /// <summary>Invokes a server hub method with the given arguments.</summary>
            /// <param name="methodName" type="String">The name of the server hub method.</param>

            var that = this,
                connection = that.connection,
                args = $.makeArray(arguments).slice(1),
                argValues = map(args, getArgValue),
                data = { H: that.hubName, M: methodName, A: argValues, I: connection._.invocationCallbackId },
                d = $.Deferred(),
                callback = function (minResult) {
                    var result = that._maximizeHubResponse(minResult),
                        source,
                        error;

                    // Update the hub state
                    $.extend(that.state, result.State);

                    if (result.Progress) {
                        if (d.notifyWith) {
                            // Progress is only supported in jQuery 1.7+
                            d.notifyWith(that, [result.Progress.Data]);
                        } else if(!connection._.progressjQueryVersionLogged) {
                            connection.log("A hub method invocation progress update was received but the version of jQuery in use (" + $.prototype.jquery + ") does not support progress updates. Upgrade to jQuery 1.7+ to receive progress notifications.");
                            connection._.progressjQueryVersionLogged = true;
                        }
                    } else if (result.Error) {
                        // Server hub method threw an exception, log it & reject the deferred
                        if (result.StackTrace) {
                            connection.log(result.Error + "\n" + result.StackTrace + ".");
                        }

                        // result.ErrorData is only set if a HubException was thrown
                        source = result.IsHubException ? "HubException" : "Exception";
                        error = signalR._.error(result.Error, source);
                        error.data = result.ErrorData;

                        connection.log(that.hubName + "." + methodName + " failed to execute. Error: " + error.message);
                        d.rejectWith(that, [error]);
                    } else {
                        // Server invocation succeeded, resolve the deferred
                        connection.log("Invoked " + that.hubName + "." + methodName);
                        d.resolveWith(that, [result.Result]);
                    }
                };

            connection._.invocationCallbacks[connection._.invocationCallbackId.toString()] = { scope: that, method: callback };
            connection._.invocationCallbackId += 1;

            if (!$.isEmptyObject(that.state)) {
                data.S = that.state;
            }

            connection.log("Invoking " + that.hubName + "." + methodName);
            connection.send(data);

            return d.promise();
        },

        _maximizeHubResponse: function (minHubResponse) {
            return {
                State: minHubResponse.S,
                Result: minHubResponse.R,
                Progress: minHubResponse.P ? {
                    Id: minHubResponse.P.I,
                    Data: minHubResponse.P.D
                } : null,
                Id: minHubResponse.I,
                IsHubException: minHubResponse.H,
                Error: minHubResponse.E,
                StackTrace: minHubResponse.T,
                ErrorData: minHubResponse.D
            };
        }
    };

    hubProxy.fn.init.prototype = hubProxy.fn;

    // hubConnection
    function hubConnection(url, options) {
        /// <summary>Creates a new hub connection.</summary>
        /// <param name="url" type="String">[Optional] The hub route url, defaults to "/signalr".</param>
        /// <param name="options" type="Object">[Optional] Settings to use when creating the hubConnection.</param>
        var settings = {
            qs: null,
            logging: false,
            useDefaultPath: true
        };

        $.extend(settings, options);

        if (!url || settings.useDefaultPath) {
            url = (url || "") + "/signalr";
        }
        return new hubConnection.fn.init(url, settings);
    }

    hubConnection.fn = hubConnection.prototype = $.connection();

    hubConnection.fn.init = function (url, options) {
        var settings = {
                qs: null,
                logging: false,
                useDefaultPath: true
            },
            connection = this;

        $.extend(settings, options);

        // Call the base constructor
        $.signalR.fn.init.call(connection, url, settings.qs, settings.logging);

        // Object to store hub proxies for this connection
        connection.proxies = {};

        connection._.invocationCallbackId = 0;
        connection._.invocationCallbacks = {};

        // Wire up the received handler
        connection.received(function (minData) {
            var data, proxy, dataCallbackId, callback, hubName, eventName;
            if (!minData) {
                return;
            }

            // We have to handle progress updates first in order to ensure old clients that receive
            // progress updates enter the return value branch and then no-op when they can't find
            // the callback in the map (because the minData.I value will not be a valid callback ID)
            if (typeof (minData.P) !== "undefined") {
                // Process progress notification
                dataCallbackId = minData.P.I.toString();
                callback = connection._.invocationCallbacks[dataCallbackId];
                if (callback) {
                    callback.method.call(callback.scope, minData);
                }
            } else if (typeof (minData.I) !== "undefined") {
                // We received the return value from a server method invocation, look up callback by id and call it
                dataCallbackId = minData.I.toString();
                callback = connection._.invocationCallbacks[dataCallbackId];
                if (callback) {
                    // Delete the callback from the proxy
                    connection._.invocationCallbacks[dataCallbackId] = null;
                    delete connection._.invocationCallbacks[dataCallbackId];

                    // Invoke the callback
                    callback.method.call(callback.scope, minData);
                }
            } else {
                data = this._maximizeClientHubInvocation(minData);

                // We received a client invocation request, i.e. broadcast from server hub
                connection.log("Triggering client hub event '" + data.Method + "' on hub '" + data.Hub + "'.");

                // Normalize the names to lowercase
                hubName = data.Hub.toLowerCase();
                eventName = data.Method.toLowerCase();

                // Trigger the local invocation event
                proxy = this.proxies[hubName];

                // Update the hub state
                $.extend(proxy.state, data.State);
                $(proxy).triggerHandler(makeEventName(eventName), [data.Args]);
            }
        });

        connection.error(function (errData, origData) {
            var callbackId, callback;

            if (!origData) {
                // No original data passed so this is not a send error
                return;
            }

            callbackId = origData.I;
            callback = connection._.invocationCallbacks[callbackId];

            // Verify that there is a callback bound (could have been cleared)
            if (callback) {
                // Delete the callback
                connection._.invocationCallbacks[callbackId] = null;
                delete connection._.invocationCallbacks[callbackId];

                // Invoke the callback with an error to reject the promise
                callback.method.call(callback.scope, { E: errData });
            }
        });

        connection.reconnecting(function () {
            if (connection.transport && connection.transport.name === "webSockets") {
                clearInvocationCallbacks(connection, "Connection started reconnecting before invocation result was received.");
            }
        });

        connection.disconnected(function () {
            clearInvocationCallbacks(connection, "Connection was disconnected before invocation result was received.");
        });
    };

    hubConnection.fn._maximizeClientHubInvocation = function (minClientHubInvocation) {
        return {
            Hub: minClientHubInvocation.H,
            Method: minClientHubInvocation.M,
            Args: minClientHubInvocation.A,
            State: minClientHubInvocation.S
        };
    };

    hubConnection.fn._registerSubscribedHubs = function () {
        /// <summary>
        ///     Sets the starting event to loop through the known hubs and register any new hubs
        ///     that have been added to the proxy.
        /// </summary>
        var connection = this;

        if (!connection._subscribedToHubs) {
            connection._subscribedToHubs = true;
            connection.starting(function () {
                // Set the connection's data object with all the hub proxies with active subscriptions.
                // These proxies will receive notifications from the server.
                var subscribedHubs = [];

                $.each(connection.proxies, function (key) {
                    if (this.hasSubscriptions()) {
                        subscribedHubs.push({ name: key });
                        connection.log("Client subscribed to hub '" + key + "'.");
                    }
                });

                if (subscribedHubs.length === 0) {
                    connection.log("No hubs have been subscribed to.  The client will not receive data from hubs.  To fix, declare at least one client side function prior to connection start for each hub you wish to subscribe to.");
                }

                connection.data = connection.json.stringify(subscribedHubs);
            });
        }
    };

    hubConnection.fn.createHubProxy = function (hubName) {
        /// <summary>
        ///     Creates a new proxy object for the given hub connection that can be used to invoke
        ///     methods on server hubs and handle client method invocation requests from the server.
        /// </summary>
        /// <param name="hubName" type="String">
        ///     The name of the hub on the server to create the proxy for.
        /// </param>

        // Normalize the name to lowercase
        hubName = hubName.toLowerCase();

        var proxy = this.proxies[hubName];
        if (!proxy) {
            proxy = hubProxy(this, hubName);
            this.proxies[hubName] = proxy;
        }

        this._registerSubscribedHubs();

        return proxy;
    };

    hubConnection.fn.init.prototype = hubConnection.fn;

    $.hubConnection = hubConnection;

}(window.jQuery, window));
/* jquery.signalR.version.js */
// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.


/*global window:false */
(function ($, undefined) {
    $.signalR.version = "2.2.2";
}(window.jQuery));

var CLOSURE_NO_DEPS=true;var COMPILED=false;var goog=goog||{};goog.global=this;goog.global.CLOSURE_UNCOMPILED_DEFINES;goog.global.CLOSURE_DEFINES;goog.isDef=function(val){return val!==void 0};goog.isString=function(val){return typeof val=="string"};goog.isBoolean=function(val){return typeof val=="boolean"};goog.isNumber=function(val){return typeof val=="number"};
goog.exportPath_=function(name,opt_object,opt_objectToExportTo){var parts=name.split(".");var cur=opt_objectToExportTo||goog.global;if(!(parts[0]in cur)&&cur.execScript)cur.execScript("var "+parts[0]);for(var part;parts.length&&(part=parts.shift());)if(!parts.length&&goog.isDef(opt_object))cur[part]=opt_object;else if(cur[part]&&cur[part]!==Object.prototype[part])cur=cur[part];else cur=cur[part]={}};
goog.define=function(name,defaultValue){var value=defaultValue;if(!COMPILED)if(goog.global.CLOSURE_UNCOMPILED_DEFINES&&goog.global.CLOSURE_UNCOMPILED_DEFINES.nodeType===undefined&&Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_UNCOMPILED_DEFINES,name))value=goog.global.CLOSURE_UNCOMPILED_DEFINES[name];else if(goog.global.CLOSURE_DEFINES&&goog.global.CLOSURE_DEFINES.nodeType===undefined&&Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_DEFINES,name))value=goog.global.CLOSURE_DEFINES[name];
goog.exportPath_(name,value)};goog.define("goog.DEBUG",true);goog.define("goog.LOCALE","en");goog.define("goog.TRUSTED_SITE",true);goog.define("goog.STRICT_MODE_COMPATIBLE",false);goog.define("goog.DISALLOW_TEST_ONLY_CODE",COMPILED&&!goog.DEBUG);goog.define("goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING",false);
goog.provide=function(name){if(goog.isInModuleLoader_())throw Error("goog.provide can not be used within a goog.module.");if(!COMPILED)if(goog.isProvided_(name))throw Error('Namespace "'+name+'" already declared.');goog.constructNamespace_(name)};
goog.constructNamespace_=function(name,opt_obj){if(!COMPILED){delete goog.implicitNamespaces_[name];var namespace=name;while(namespace=namespace.substring(0,namespace.lastIndexOf("."))){if(goog.getObjectByName(namespace))break;goog.implicitNamespaces_[namespace]=true}}goog.exportPath_(name,opt_obj)};goog.VALID_MODULE_RE_=/^[a-zA-Z_$][a-zA-Z0-9._$]*$/;
goog.module=function(name){if(!goog.isString(name)||!name||name.search(goog.VALID_MODULE_RE_)==-1)throw Error("Invalid module identifier");if(!goog.isInModuleLoader_())throw Error("Module "+name+" has been loaded incorrectly. Note, "+"modules cannot be loaded as normal scripts. They require some kind of "+"pre-processing step. You're likely trying to load a module via a "+"script tag or as a part of a concatenated bundle without rewriting the "+"module. For more info see: "+"https://github.com/google/closure-library/wiki/goog.module:-an-ES6-module-like-alternative-to-goog.provide.");
if(goog.moduleLoaderState_.moduleName)throw Error("goog.module may only be called once per module.");goog.moduleLoaderState_.moduleName=name;if(!COMPILED){if(goog.isProvided_(name))throw Error('Namespace "'+name+'" already declared.');delete goog.implicitNamespaces_[name]}};goog.module.get=function(name){return goog.module.getInternal_(name)};
goog.module.getInternal_=function(name){if(!COMPILED)if(name in goog.loadedModules_)return goog.loadedModules_[name];else if(!goog.implicitNamespaces_[name]){var ns=goog.getObjectByName(name);return ns!=null?ns:null}return null};goog.moduleLoaderState_=null;goog.isInModuleLoader_=function(){return goog.moduleLoaderState_!=null};
goog.module.declareLegacyNamespace=function(){if(!COMPILED&&!goog.isInModuleLoader_())throw new Error("goog.module.declareLegacyNamespace must be called from "+"within a goog.module");if(!COMPILED&&!goog.moduleLoaderState_.moduleName)throw Error("goog.module must be called prior to "+"goog.module.declareLegacyNamespace.");goog.moduleLoaderState_.declareLegacyNamespace=true};
goog.setTestOnly=function(opt_message){if(goog.DISALLOW_TEST_ONLY_CODE){opt_message=opt_message||"";throw Error("Importing test-only code into non-debug environment"+(opt_message?": "+opt_message:"."));}};goog.forwardDeclare=function(name){};goog.forwardDeclare("Document");goog.forwardDeclare("HTMLScriptElement");goog.forwardDeclare("XMLHttpRequest");
if(!COMPILED){goog.isProvided_=function(name){return name in goog.loadedModules_||!goog.implicitNamespaces_[name]&&goog.isDefAndNotNull(goog.getObjectByName(name))};goog.implicitNamespaces_={"goog.module":true}}goog.getObjectByName=function(name,opt_obj){var parts=name.split(".");var cur=opt_obj||goog.global;for(var part;part=parts.shift();)if(goog.isDefAndNotNull(cur[part]))cur=cur[part];else return null;return cur};
goog.globalize=function(obj,opt_global){var global=opt_global||goog.global;for(var x in obj)global[x]=obj[x]};
goog.addDependency=function(relPath,provides,requires,opt_loadFlags){if(goog.DEPENDENCIES_ENABLED){var provide,require;var path=relPath.replace(/\\/g,"/");var deps=goog.dependencies_;if(!opt_loadFlags||typeof opt_loadFlags==="boolean")opt_loadFlags=opt_loadFlags?{"module":"goog"}:{};for(var i=0;provide=provides[i];i++){deps.nameToPath[provide]=path;deps.loadFlags[path]=opt_loadFlags}for(var j=0;require=requires[j];j++){if(!(path in deps.requires))deps.requires[path]={};deps.requires[path][require]=
true}}};goog.define("goog.ENABLE_DEBUG_LOADER",true);goog.logToConsole_=function(msg){if(goog.global.console)goog.global.console["error"](msg)};
goog.require=function(name){if(!COMPILED){if(goog.ENABLE_DEBUG_LOADER&&goog.IS_OLD_IE_)goog.maybeProcessDeferredDep_(name);if(goog.isProvided_(name)){if(goog.isInModuleLoader_())return goog.module.getInternal_(name)}else if(goog.ENABLE_DEBUG_LOADER){var path=goog.getPathFromDeps_(name);if(path)goog.writeScripts_(path);else{var errorMessage="goog.require could not find: "+name;goog.logToConsole_(errorMessage);throw Error(errorMessage);}}return null}};goog.basePath="";goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;goog.global.CLOSURE_IMPORT_SCRIPT;goog.nullFunction=function(){};goog.abstractMethod=function(){throw Error("unimplemented abstract method");};goog.addSingletonGetter=function(ctor){ctor.instance_=undefined;ctor.getInstance=function(){if(ctor.instance_)return ctor.instance_;if(goog.DEBUG)goog.instantiatedSingletons_[goog.instantiatedSingletons_.length]=ctor;return ctor.instance_=new ctor}};goog.instantiatedSingletons_=[];goog.define("goog.LOAD_MODULE_USING_EVAL",true);
goog.define("goog.SEAL_MODULE_EXPORTS",goog.DEBUG);goog.loadedModules_={};goog.DEPENDENCIES_ENABLED=!COMPILED&&goog.ENABLE_DEBUG_LOADER;goog.define("goog.TRANSPILE","detect");goog.define("goog.TRANSPILER","transpile.js");
if(goog.DEPENDENCIES_ENABLED){goog.dependencies_={loadFlags:{},nameToPath:{},requires:{},visited:{},written:{},deferred:{}};goog.inHtmlDocument_=function(){var doc=goog.global.document;return doc!=null&&"write"in doc};goog.findBasePath_=function(){if(goog.isDef(goog.global.CLOSURE_BASE_PATH)&&goog.isString(goog.global.CLOSURE_BASE_PATH)){goog.basePath=goog.global.CLOSURE_BASE_PATH;return}else if(!goog.inHtmlDocument_())return;var doc=goog.global.document;var currentScript=doc.currentScript;if(currentScript)var scripts=
[currentScript];else var scripts=doc.getElementsByTagName("SCRIPT");for(var i=scripts.length-1;i>=0;--i){var script=scripts[i];var src=script.src;var qmark=src.lastIndexOf("?");var l=qmark==-1?src.length:qmark;if(src.substr(l-7,7)=="base.js"){goog.basePath=src.substr(0,l-7);return}}};goog.importScript_=function(src,opt_sourceText){var importScript=goog.global.CLOSURE_IMPORT_SCRIPT||goog.writeScriptTag_;if(importScript(src,opt_sourceText))goog.dependencies_.written[src]=true};goog.IS_OLD_IE_=!!(!goog.global.atob&&
goog.global.document&&goog.global.document.all);goog.oldIeWaiting_=false;goog.importProcessedScript_=function(src,isModule,needsTranspile){var bootstrap='goog.retrieveAndExec_("'+src+'", '+isModule+", "+needsTranspile+");";goog.importScript_("",bootstrap)};goog.queuedModules_=[];goog.wrapModule_=function(srcUrl,scriptText){if(!goog.LOAD_MODULE_USING_EVAL||!goog.isDef(goog.global.JSON))return""+"goog.loadModule(function(exports) {"+'"use strict";'+scriptText+"\n"+";return exports"+"});"+"\n//# sourceURL\x3d"+
srcUrl+"\n";else return""+"goog.loadModule("+goog.global.JSON.stringify(scriptText+"\n//# sourceURL\x3d"+srcUrl+"\n")+");"};goog.loadQueuedModules_=function(){var count=goog.queuedModules_.length;if(count>0){var queue=goog.queuedModules_;goog.queuedModules_=[];for(var i=0;i<count;i++){var path=queue[i];goog.maybeProcessDeferredPath_(path)}}goog.oldIeWaiting_=false};goog.maybeProcessDeferredDep_=function(name){if(goog.isDeferredModule_(name)&&goog.allDepsAreAvailable_(name)){var path=goog.getPathFromDeps_(name);
goog.maybeProcessDeferredPath_(goog.basePath+path)}};goog.isDeferredModule_=function(name){var path=goog.getPathFromDeps_(name);var loadFlags=path&&goog.dependencies_.loadFlags[path]||{};var languageLevel=loadFlags["lang"]||"es3";if(path&&(loadFlags["module"]=="goog"||goog.needsTranspile_(languageLevel))){var abspath=goog.basePath+path;return abspath in goog.dependencies_.deferred}return false};goog.allDepsAreAvailable_=function(name){var path=goog.getPathFromDeps_(name);if(path&&path in goog.dependencies_.requires)for(var requireName in goog.dependencies_.requires[path])if(!goog.isProvided_(requireName)&&
!goog.isDeferredModule_(requireName))return false;return true};goog.maybeProcessDeferredPath_=function(abspath){if(abspath in goog.dependencies_.deferred){var src=goog.dependencies_.deferred[abspath];delete goog.dependencies_.deferred[abspath];goog.globalEval(src)}};goog.loadModuleFromUrl=function(url){goog.retrieveAndExec_(url,true,false)};goog.writeScriptSrcNode_=function(src){goog.global.document.write('\x3cscript type\x3d"text/javascript" src\x3d"'+src+'"\x3e\x3c/'+"script\x3e")};goog.appendScriptSrcNode_=
function(src){var doc=goog.global.document;var scriptEl=doc.createElement("script");scriptEl.type="text/javascript";scriptEl.src=src;scriptEl.defer=false;scriptEl.async=false;doc.head.appendChild(scriptEl)};goog.writeScriptTag_=function(src,opt_sourceText){if(goog.inHtmlDocument_()){var doc=goog.global.document;if(!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING&&doc.readyState=="complete"){var isDeps=/\bdeps.js$/.test(src);if(isDeps)return false;else throw Error('Cannot write "'+src+'" after document load');
}if(opt_sourceText===undefined)if(!goog.IS_OLD_IE_)if(goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING)goog.appendScriptSrcNode_(src);else goog.writeScriptSrcNode_(src);else{goog.oldIeWaiting_=true;var state=" onreadystatechange\x3d'goog.onScriptLoad_(this, "+ ++goog.lastNonModuleScriptIndex_+")' ";doc.write('\x3cscript type\x3d"text/javascript" src\x3d"'+src+'"'+state+"\x3e\x3c/"+"script\x3e")}else doc.write('\x3cscript type\x3d"text/javascript"\x3e'+goog.protectScriptTag_(opt_sourceText)+"\x3c/"+"script\x3e");
return true}else return false};goog.protectScriptTag_=function(str){return str.replace(/<\/(SCRIPT)/ig,"\\x3c/$1")};goog.needsTranspile_=function(lang){if(goog.TRANSPILE=="always")return true;else if(goog.TRANSPILE=="never")return false;else if(!goog.requiresTranspilation_)goog.requiresTranspilation_=goog.createRequiresTranspilation_();if(lang in goog.requiresTranspilation_)return goog.requiresTranspilation_[lang];else throw new Error("Unknown language mode: "+lang);};goog.requiresTranspilation_=
null;goog.lastNonModuleScriptIndex_=0;goog.onScriptLoad_=function(script,scriptIndex){if(script.readyState=="complete"&&goog.lastNonModuleScriptIndex_==scriptIndex)goog.loadQueuedModules_();return true};goog.writeScripts_=function(pathToLoad){var scripts=[];var seenScript={};var deps=goog.dependencies_;function visitNode(path){if(path in deps.written)return;if(path in deps.visited)return;deps.visited[path]=true;if(path in deps.requires)for(var requireName in deps.requires[path])if(!goog.isProvided_(requireName))if(requireName in
deps.nameToPath)visitNode(deps.nameToPath[requireName]);else throw Error("Undefined nameToPath for "+requireName);if(!(path in seenScript)){seenScript[path]=true;scripts.push(path)}}visitNode(pathToLoad);for(var i=0;i<scripts.length;i++){var path=scripts[i];goog.dependencies_.written[path]=true}var moduleState=goog.moduleLoaderState_;goog.moduleLoaderState_=null;for(var i=0;i<scripts.length;i++){var path=scripts[i];if(path){var loadFlags=deps.loadFlags[path]||{};var languageLevel=loadFlags["lang"]||
"es3";var needsTranspile=goog.needsTranspile_(languageLevel);if(loadFlags["module"]=="goog"||needsTranspile)goog.importProcessedScript_(goog.basePath+path,loadFlags["module"]=="goog",needsTranspile);else goog.importScript_(goog.basePath+path)}else{goog.moduleLoaderState_=moduleState;throw Error("Undefined script input");}}goog.moduleLoaderState_=moduleState};goog.getPathFromDeps_=function(rule){if(rule in goog.dependencies_.nameToPath)return goog.dependencies_.nameToPath[rule];else return null};goog.findBasePath_();
if(!goog.global.CLOSURE_NO_DEPS)goog.importScript_(goog.basePath+"deps.js")}goog.hasBadLetScoping=null;goog.useSafari10Workaround=function(){if(goog.hasBadLetScoping==null){var hasBadLetScoping;try{hasBadLetScoping=!eval('"use strict";'+"let x \x3d 1; function f() { return typeof x; };"+'f() \x3d\x3d "number";')}catch(e){hasBadLetScoping=false}goog.hasBadLetScoping=hasBadLetScoping}return goog.hasBadLetScoping};
goog.workaroundSafari10EvalBug=function(moduleDef){return"(function(){"+moduleDef+"\n"+";"+"})();\n"};
goog.loadModule=function(moduleDef){var previousState=goog.moduleLoaderState_;try{goog.moduleLoaderState_={moduleName:undefined,declareLegacyNamespace:false};var exports;if(goog.isFunction(moduleDef))exports=moduleDef.call(undefined,{});else if(goog.isString(moduleDef)){if(goog.useSafari10Workaround())moduleDef=goog.workaroundSafari10EvalBug(moduleDef);exports=goog.loadModuleFromSource_.call(undefined,moduleDef)}else throw Error("Invalid module definition");var moduleName=goog.moduleLoaderState_.moduleName;
if(!goog.isString(moduleName)||!moduleName)throw Error('Invalid module name "'+moduleName+'"');if(goog.moduleLoaderState_.declareLegacyNamespace)goog.constructNamespace_(moduleName,exports);else if(goog.SEAL_MODULE_EXPORTS&&Object.seal&&typeof exports=="object"&&exports!=null)Object.seal(exports);goog.loadedModules_[moduleName]=exports}finally{goog.moduleLoaderState_=previousState}};goog.loadModuleFromSource_=function(){var exports={};eval(arguments[0]);return exports};
goog.normalizePath_=function(path){var components=path.split("/");var i=0;while(i<components.length)if(components[i]==".")components.splice(i,1);else if(i&&components[i]==".."&&components[i-1]&&components[i-1]!="..")components.splice(--i,2);else i++;return components.join("/")};goog.global.CLOSURE_LOAD_FILE_SYNC;
goog.loadFileSync_=function(src){if(goog.global.CLOSURE_LOAD_FILE_SYNC)return goog.global.CLOSURE_LOAD_FILE_SYNC(src);else try{var xhr=new goog.global["XMLHttpRequest"];xhr.open("get",src,false);xhr.send();return xhr.status==0||xhr.status==200?xhr.responseText:null}catch(err){return null}};
goog.retrieveAndExec_=function(src,isModule,needsTranspile){if(!COMPILED){var originalPath=src;src=goog.normalizePath_(src);var importScript=goog.global.CLOSURE_IMPORT_SCRIPT||goog.writeScriptTag_;var scriptText=goog.loadFileSync_(src);if(scriptText==null)throw new Error('Load of "'+src+'" failed');if(needsTranspile)scriptText=goog.transpile_.call(goog.global,scriptText,src);if(isModule)scriptText=goog.wrapModule_(src,scriptText);else scriptText+="\n//# sourceURL\x3d"+src;var isOldIE=goog.IS_OLD_IE_;
if(isOldIE&&goog.oldIeWaiting_){goog.dependencies_.deferred[originalPath]=scriptText;goog.queuedModules_.push(originalPath)}else importScript(src,scriptText)}};
goog.transpile_=function(code,path){var jscomp=goog.global["$jscomp"];if(!jscomp)goog.global["$jscomp"]=jscomp={};var transpile=jscomp.transpile;if(!transpile){var transpilerPath=goog.basePath+goog.TRANSPILER;var transpilerCode=goog.loadFileSync_(transpilerPath);if(transpilerCode){eval(transpilerCode+"\n//# sourceURL\x3d"+transpilerPath);if(goog.global["$gwtExport"]&&goog.global["$gwtExport"]["$jscomp"]&&!goog.global["$gwtExport"]["$jscomp"]["transpile"])throw new Error('The transpiler did not properly export the "transpile" '+
"method. $gwtExport: "+JSON.stringify(goog.global["$gwtExport"]));goog.global["$jscomp"].transpile=goog.global["$gwtExport"]["$jscomp"]["transpile"];jscomp=goog.global["$jscomp"];transpile=jscomp.transpile}}if(!transpile){var suffix=" requires transpilation but no transpiler was found.";transpile=jscomp.transpile=function(code,path){goog.logToConsole_(path+suffix);return code}}return transpile(code,path)};
goog.typeOf=function(value){var s=typeof value;if(s=="object")if(value){if(value instanceof Array)return"array";else if(value instanceof Object)return s;var className=Object.prototype.toString.call(value);if(className=="[object Window]")return"object";if(className=="[object Array]"||typeof value.length=="number"&&typeof value.splice!="undefined"&&typeof value.propertyIsEnumerable!="undefined"&&!value.propertyIsEnumerable("splice"))return"array";if(className=="[object Function]"||typeof value.call!=
"undefined"&&typeof value.propertyIsEnumerable!="undefined"&&!value.propertyIsEnumerable("call"))return"function"}else return"null";else if(s=="function"&&typeof value.call=="undefined")return"object";return s};goog.isNull=function(val){return val===null};goog.isDefAndNotNull=function(val){return val!=null};goog.isArray=function(val){return goog.typeOf(val)=="array"};goog.isArrayLike=function(val){var type=goog.typeOf(val);return type=="array"||type=="object"&&typeof val.length=="number"};
goog.isDateLike=function(val){return goog.isObject(val)&&typeof val.getFullYear=="function"};goog.isFunction=function(val){return goog.typeOf(val)=="function"};goog.isObject=function(val){var type=typeof val;return type=="object"&&val!=null||type=="function"};goog.getUid=function(obj){return obj[goog.UID_PROPERTY_]||(obj[goog.UID_PROPERTY_]=++goog.uidCounter_)};goog.hasUid=function(obj){return!!obj[goog.UID_PROPERTY_]};
goog.removeUid=function(obj){if(obj!==null&&"removeAttribute"in obj)obj.removeAttribute(goog.UID_PROPERTY_);try{delete obj[goog.UID_PROPERTY_]}catch(ex){}};goog.UID_PROPERTY_="closure_uid_"+(Math.random()*1E9>>>0);goog.uidCounter_=0;goog.getHashCode=goog.getUid;goog.removeHashCode=goog.removeUid;
goog.cloneObject=function(obj){var type=goog.typeOf(obj);if(type=="object"||type=="array"){if(obj.clone)return obj.clone();var clone=type=="array"?[]:{};for(var key in obj)clone[key]=goog.cloneObject(obj[key]);return clone}return obj};goog.bindNative_=function(fn,selfObj,var_args){return fn.call.apply(fn.bind,arguments)};
goog.bindJs_=function(fn,selfObj,var_args){if(!fn)throw new Error;if(arguments.length>2){var boundArgs=Array.prototype.slice.call(arguments,2);return function(){var newArgs=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(newArgs,boundArgs);return fn.apply(selfObj,newArgs)}}else return function(){return fn.apply(selfObj,arguments)}};
goog.bind=function(fn,selfObj,var_args){if(Function.prototype.bind&&Function.prototype.bind.toString().indexOf("native code")!=-1)goog.bind=goog.bindNative_;else goog.bind=goog.bindJs_;return goog.bind.apply(null,arguments)};goog.partial=function(fn,var_args){var args=Array.prototype.slice.call(arguments,1);return function(){var newArgs=args.slice();newArgs.push.apply(newArgs,arguments);return fn.apply(this,newArgs)}};goog.mixin=function(target,source){for(var x in source)target[x]=source[x]};
goog.now=goog.TRUSTED_SITE&&Date.now||function(){return+new Date};
goog.globalEval=function(script){if(goog.global.execScript)goog.global.execScript(script,"JavaScript");else if(goog.global.eval){if(goog.evalWorksForGlobals_==null){goog.global.eval("var _evalTest_ \x3d 1;");if(typeof goog.global["_evalTest_"]!="undefined"){try{delete goog.global["_evalTest_"]}catch(ignore){}goog.evalWorksForGlobals_=true}else goog.evalWorksForGlobals_=false}if(goog.evalWorksForGlobals_)goog.global.eval(script);else{var doc=goog.global.document;var scriptElt=doc.createElement("SCRIPT");
scriptElt.type="text/javascript";scriptElt.defer=false;scriptElt.appendChild(doc.createTextNode(script));doc.body.appendChild(scriptElt);doc.body.removeChild(scriptElt)}}else throw Error("goog.globalEval not available");};goog.evalWorksForGlobals_=null;goog.cssNameMapping_;goog.cssNameMappingStyle_;goog.global.CLOSURE_CSS_NAME_MAP_FN;
goog.getCssName=function(className,opt_modifier){if(String(className).charAt(0)==".")throw new Error('className passed in goog.getCssName must not start with ".".'+" You passed: "+className);var getMapping=function(cssName){return goog.cssNameMapping_[cssName]||cssName};var renameByParts=function(cssName){var parts=cssName.split("-");var mapped=[];for(var i=0;i<parts.length;i++)mapped.push(getMapping(parts[i]));return mapped.join("-")};var rename;if(goog.cssNameMapping_)rename=goog.cssNameMappingStyle_==
"BY_WHOLE"?getMapping:renameByParts;else rename=function(a){return a};var result=opt_modifier?className+"-"+rename(opt_modifier):rename(className);if(goog.global.CLOSURE_CSS_NAME_MAP_FN)return goog.global.CLOSURE_CSS_NAME_MAP_FN(result);return result};goog.setCssNameMapping=function(mapping,opt_style){goog.cssNameMapping_=mapping;goog.cssNameMappingStyle_=opt_style};goog.global.CLOSURE_CSS_NAME_MAPPING;if(!COMPILED&&goog.global.CLOSURE_CSS_NAME_MAPPING)goog.cssNameMapping_=goog.global.CLOSURE_CSS_NAME_MAPPING;
goog.getMsg=function(str,opt_values){if(opt_values)str=str.replace(/\{\$([^}]+)}/g,function(match,key){return opt_values!=null&&key in opt_values?opt_values[key]:match});return str};goog.getMsgWithFallback=function(a,b){return a};goog.exportSymbol=function(publicPath,object,opt_objectToExportTo){goog.exportPath_(publicPath,object,opt_objectToExportTo)};goog.exportProperty=function(object,publicName,symbol){object[publicName]=symbol};
goog.inherits=function(childCtor,parentCtor){function tempCtor(){}tempCtor.prototype=parentCtor.prototype;childCtor.superClass_=parentCtor.prototype;childCtor.prototype=new tempCtor;childCtor.prototype.constructor=childCtor;childCtor.base=function(me,methodName,var_args){var args=new Array(arguments.length-2);for(var i=2;i<arguments.length;i++)args[i-2]=arguments[i];return parentCtor.prototype[methodName].apply(me,args)}};
goog.base=function(me,opt_methodName,var_args){var caller=arguments.callee.caller;if(goog.STRICT_MODE_COMPATIBLE||goog.DEBUG&&!caller)throw Error("arguments.caller not defined.  goog.base() cannot be used "+"with strict mode code. See "+"http://www.ecma-international.org/ecma-262/5.1/#sec-C");if(caller.superClass_){var ctorArgs=new Array(arguments.length-1);for(var i=1;i<arguments.length;i++)ctorArgs[i-1]=arguments[i];return caller.superClass_.constructor.apply(me,ctorArgs)}var args=new Array(arguments.length-
2);for(var i=2;i<arguments.length;i++)args[i-2]=arguments[i];var foundCaller=false;for(var ctor=me.constructor;ctor;ctor=ctor.superClass_&&ctor.superClass_.constructor)if(ctor.prototype[opt_methodName]===caller)foundCaller=true;else if(foundCaller)return ctor.prototype[opt_methodName].apply(me,args);if(me[opt_methodName]===caller)return me.constructor.prototype[opt_methodName].apply(me,args);else throw Error("goog.base called from a method of one name "+"to a method of a different name");};
goog.scope=function(fn){if(goog.isInModuleLoader_())throw Error("goog.scope is not supported within a goog.module.");fn.call(goog.global)};if(!COMPILED)goog.global["COMPILED"]=COMPILED;
goog.defineClass=function(superClass,def){var constructor=def.constructor;var statics=def.statics;if(!constructor||constructor==Object.prototype.constructor)constructor=function(){throw Error("cannot instantiate an interface (no constructor defined).");};var cls=goog.defineClass.createSealingConstructor_(constructor,superClass);if(superClass)goog.inherits(cls,superClass);delete def.constructor;delete def.statics;goog.defineClass.applyProperties_(cls.prototype,def);if(statics!=null)if(statics instanceof
Function)statics(cls);else goog.defineClass.applyProperties_(cls,statics);return cls};goog.defineClass.ClassDescriptor;goog.define("goog.defineClass.SEAL_CLASS_INSTANCES",goog.DEBUG);
goog.defineClass.createSealingConstructor_=function(ctr,superClass){if(!goog.defineClass.SEAL_CLASS_INSTANCES)return ctr;var superclassSealable=!goog.defineClass.isUnsealable_(superClass);var wrappedCtr=function(){var instance=ctr.apply(this,arguments)||this;instance[goog.UID_PROPERTY_]=instance[goog.UID_PROPERTY_];if(this.constructor===wrappedCtr&&superclassSealable&&Object.seal instanceof Function)Object.seal(instance);return instance};return wrappedCtr};
goog.defineClass.isUnsealable_=function(ctr){return ctr&&ctr.prototype&&ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]};goog.defineClass.OBJECT_PROTOTYPE_FIELDS_=["constructor","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","toLocaleString","toString","valueOf"];
goog.defineClass.applyProperties_=function(target,source){var key;for(key in source)if(Object.prototype.hasOwnProperty.call(source,key))target[key]=source[key];for(var i=0;i<goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length;i++){key=goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[i];if(Object.prototype.hasOwnProperty.call(source,key))target[key]=source[key]}};goog.tagUnsealableClass=function(ctr){if(!COMPILED&&goog.defineClass.SEAL_CLASS_INSTANCES)ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]=true};
goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_="goog_defineClass_legacy_unsealable";
goog.createRequiresTranspilation_=function(){var requiresTranspilation={"es3":false};var transpilationRequiredForAllLaterModes=false;function addNewerLanguageTranspilationCheck(modeName,isSupported){if(transpilationRequiredForAllLaterModes)requiresTranspilation[modeName]=true;else if(isSupported())requiresTranspilation[modeName]=false;else{requiresTranspilation[modeName]=true;transpilationRequiredForAllLaterModes=true}}function evalCheck(code){try{return!!eval(code)}catch(ignored){return false}}var userAgent=
goog.global.navigator&&goog.global.navigator.userAgent?goog.global.navigator.userAgent:"";addNewerLanguageTranspilationCheck("es5",function(){return evalCheck("[1,].length\x3d\x3d1")});addNewerLanguageTranspilationCheck("es6",function(){var re=/Edge\/(\d+)(\.\d)*/i;var edgeUserAgent=userAgent.match(re);if(edgeUserAgent&&Number(edgeUserAgent[1])<15)return false;var es6fullTest="class X{constructor(){if(new.target!\x3dString)throw 1;this.x\x3d42}}"+"let q\x3dReflect.construct(X,[],String);if(q.x!\x3d42||!(q instanceof "+
"String))throw 1;for(const a of[2,3]){if(a\x3d\x3d2)continue;function "+"f(z\x3d{a}){let a\x3d0;return z.a}{function f(){return 0;}}return f()"+"\x3d\x3d3}";return evalCheck('(()\x3d\x3e{"use strict";'+es6fullTest+"})()")});addNewerLanguageTranspilationCheck("es6-impl",function(){return true});addNewerLanguageTranspilationCheck("es7",function(){return evalCheck("2 ** 2 \x3d\x3d 4")});addNewerLanguageTranspilationCheck("es8",function(){return evalCheck("async () \x3d\x3e 1, true")});return requiresTranspilation};goog.provide("goog.string");goog.provide("goog.string.Unicode");goog.define("goog.string.DETECT_DOUBLE_ESCAPING",false);goog.define("goog.string.FORCE_NON_DOM_HTML_UNESCAPING",false);goog.string.Unicode={NBSP:" "};goog.string.startsWith=function(str,prefix){return str.lastIndexOf(prefix,0)==0};goog.string.endsWith=function(str,suffix){var l=str.length-suffix.length;return l>=0&&str.indexOf(suffix,l)==l};
goog.string.caseInsensitiveStartsWith=function(str,prefix){return goog.string.caseInsensitiveCompare(prefix,str.substr(0,prefix.length))==0};goog.string.caseInsensitiveEndsWith=function(str,suffix){return goog.string.caseInsensitiveCompare(suffix,str.substr(str.length-suffix.length,suffix.length))==0};goog.string.caseInsensitiveEquals=function(str1,str2){return str1.toLowerCase()==str2.toLowerCase()};
goog.string.subs=function(str,var_args){var splitParts=str.split("%s");var returnString="";var subsArguments=Array.prototype.slice.call(arguments,1);while(subsArguments.length&&splitParts.length>1)returnString+=splitParts.shift()+subsArguments.shift();return returnString+splitParts.join("%s")};goog.string.collapseWhitespace=function(str){return str.replace(/[\s\xa0]+/g," ").replace(/^\s+|\s+$/g,"")};goog.string.isEmptyOrWhitespace=function(str){return/^[\s\xa0]*$/.test(str)};
goog.string.isEmptyString=function(str){return str.length==0};goog.string.isEmpty=goog.string.isEmptyOrWhitespace;goog.string.isEmptyOrWhitespaceSafe=function(str){return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(str))};goog.string.isEmptySafe=goog.string.isEmptyOrWhitespaceSafe;goog.string.isBreakingWhitespace=function(str){return!/[^\t\n\r ]/.test(str)};goog.string.isAlpha=function(str){return!/[^a-zA-Z]/.test(str)};goog.string.isNumeric=function(str){return!/[^0-9]/.test(str)};
goog.string.isAlphaNumeric=function(str){return!/[^a-zA-Z0-9]/.test(str)};goog.string.isSpace=function(ch){return ch==" "};goog.string.isUnicodeChar=function(ch){return ch.length==1&&ch>=" "&&ch<="~"||ch>=""&&ch<="�"};goog.string.stripNewlines=function(str){return str.replace(/(\r\n|\r|\n)+/g," ")};goog.string.canonicalizeNewlines=function(str){return str.replace(/(\r\n|\r|\n)/g,"\n")};goog.string.normalizeWhitespace=function(str){return str.replace(/\xa0|\s/g," ")};
goog.string.normalizeSpaces=function(str){return str.replace(/\xa0|[ \t]+/g," ")};goog.string.collapseBreakingSpaces=function(str){return str.replace(/[\t\r\n ]+/g," ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g,"")};goog.string.trim=goog.TRUSTED_SITE&&String.prototype.trim?function(str){return str.trim()}:function(str){return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g,"")};goog.string.trimLeft=function(str){return str.replace(/^[\s\xa0]+/,"")};
goog.string.trimRight=function(str){return str.replace(/[\s\xa0]+$/,"")};goog.string.caseInsensitiveCompare=function(str1,str2){var test1=String(str1).toLowerCase();var test2=String(str2).toLowerCase();if(test1<test2)return-1;else if(test1==test2)return 0;else return 1};
goog.string.numberAwareCompare_=function(str1,str2,tokenizerRegExp){if(str1==str2)return 0;if(!str1)return-1;if(!str2)return 1;var tokens1=str1.toLowerCase().match(tokenizerRegExp);var tokens2=str2.toLowerCase().match(tokenizerRegExp);var count=Math.min(tokens1.length,tokens2.length);for(var i=0;i<count;i++){var a=tokens1[i];var b=tokens2[i];if(a!=b){var num1=parseInt(a,10);if(!isNaN(num1)){var num2=parseInt(b,10);if(!isNaN(num2)&&num1-num2)return num1-num2}return a<b?-1:1}}if(tokens1.length!=tokens2.length)return tokens1.length-
tokens2.length;return str1<str2?-1:1};goog.string.intAwareCompare=function(str1,str2){return goog.string.numberAwareCompare_(str1,str2,/\d+|\D+/g)};goog.string.floatAwareCompare=function(str1,str2){return goog.string.numberAwareCompare_(str1,str2,/\d+|\.\d+|\D+/g)};goog.string.numerateCompare=goog.string.floatAwareCompare;goog.string.urlEncode=function(str){return encodeURIComponent(String(str))};goog.string.urlDecode=function(str){return decodeURIComponent(str.replace(/\+/g," "))};
goog.string.newLineToBr=function(str,opt_xml){return str.replace(/(\r\n|\r|\n)/g,opt_xml?"\x3cbr /\x3e":"\x3cbr\x3e")};
goog.string.htmlEscape=function(str,opt_isLikelyToContainHtmlChars){if(opt_isLikelyToContainHtmlChars){str=str.replace(goog.string.AMP_RE_,"\x26amp;").replace(goog.string.LT_RE_,"\x26lt;").replace(goog.string.GT_RE_,"\x26gt;").replace(goog.string.QUOT_RE_,"\x26quot;").replace(goog.string.SINGLE_QUOTE_RE_,"\x26#39;").replace(goog.string.NULL_RE_,"\x26#0;");if(goog.string.DETECT_DOUBLE_ESCAPING)str=str.replace(goog.string.E_RE_,"\x26#101;");return str}else{if(!goog.string.ALL_RE_.test(str))return str;
if(str.indexOf("\x26")!=-1)str=str.replace(goog.string.AMP_RE_,"\x26amp;");if(str.indexOf("\x3c")!=-1)str=str.replace(goog.string.LT_RE_,"\x26lt;");if(str.indexOf("\x3e")!=-1)str=str.replace(goog.string.GT_RE_,"\x26gt;");if(str.indexOf('"')!=-1)str=str.replace(goog.string.QUOT_RE_,"\x26quot;");if(str.indexOf("'")!=-1)str=str.replace(goog.string.SINGLE_QUOTE_RE_,"\x26#39;");if(str.indexOf("\x00")!=-1)str=str.replace(goog.string.NULL_RE_,"\x26#0;");if(goog.string.DETECT_DOUBLE_ESCAPING&&str.indexOf("e")!=
-1)str=str.replace(goog.string.E_RE_,"\x26#101;");return str}};goog.string.AMP_RE_=/&/g;goog.string.LT_RE_=/</g;goog.string.GT_RE_=/>/g;goog.string.QUOT_RE_=/"/g;goog.string.SINGLE_QUOTE_RE_=/'/g;goog.string.NULL_RE_=/\x00/g;goog.string.E_RE_=/e/g;goog.string.ALL_RE_=goog.string.DETECT_DOUBLE_ESCAPING?/[\x00&<>"'e]/:/[\x00&<>"']/;
goog.string.unescapeEntities=function(str){if(goog.string.contains(str,"\x26"))if(!goog.string.FORCE_NON_DOM_HTML_UNESCAPING&&"document"in goog.global)return goog.string.unescapeEntitiesUsingDom_(str);else return goog.string.unescapePureXmlEntities_(str);return str};goog.string.unescapeEntitiesWithDocument=function(str,document){if(goog.string.contains(str,"\x26"))return goog.string.unescapeEntitiesUsingDom_(str,document);return str};
goog.string.unescapeEntitiesUsingDom_=function(str,opt_document){var seen={"\x26amp;":"\x26","\x26lt;":"\x3c","\x26gt;":"\x3e","\x26quot;":'"'};var div;if(opt_document)div=opt_document.createElement("div");else div=goog.global.document.createElement("div");return str.replace(goog.string.HTML_ENTITY_PATTERN_,function(s,entity){var value=seen[s];if(value)return value;if(entity.charAt(0)=="#"){var n=Number("0"+entity.substr(1));if(!isNaN(n))value=String.fromCharCode(n)}if(!value){div.innerHTML=s+" ";
value=div.firstChild.nodeValue.slice(0,-1)}return seen[s]=value})};goog.string.unescapePureXmlEntities_=function(str){return str.replace(/&([^;]+);/g,function(s,entity){switch(entity){case "amp":return"\x26";case "lt":return"\x3c";case "gt":return"\x3e";case "quot":return'"';default:if(entity.charAt(0)=="#"){var n=Number("0"+entity.substr(1));if(!isNaN(n))return String.fromCharCode(n)}return s}})};goog.string.HTML_ENTITY_PATTERN_=/&([^;\s<&]+);?/g;
goog.string.whitespaceEscape=function(str,opt_xml){return goog.string.newLineToBr(str.replace(/  /g," \x26#160;"),opt_xml)};goog.string.preserveSpaces=function(str){return str.replace(/(^|[\n ]) /g,"$1"+goog.string.Unicode.NBSP)};goog.string.stripQuotes=function(str,quoteChars){var length=quoteChars.length;for(var i=0;i<length;i++){var quoteChar=length==1?quoteChars:quoteChars.charAt(i);if(str.charAt(0)==quoteChar&&str.charAt(str.length-1)==quoteChar)return str.substring(1,str.length-1)}return str};
goog.string.truncate=function(str,chars,opt_protectEscapedCharacters){if(opt_protectEscapedCharacters)str=goog.string.unescapeEntities(str);if(str.length>chars)str=str.substring(0,chars-3)+"...";if(opt_protectEscapedCharacters)str=goog.string.htmlEscape(str);return str};
goog.string.truncateMiddle=function(str,chars,opt_protectEscapedCharacters,opt_trailingChars){if(opt_protectEscapedCharacters)str=goog.string.unescapeEntities(str);if(opt_trailingChars&&str.length>chars){if(opt_trailingChars>chars)opt_trailingChars=chars;var endPoint=str.length-opt_trailingChars;var startPoint=chars-opt_trailingChars;str=str.substring(0,startPoint)+"..."+str.substring(endPoint)}else if(str.length>chars){var half=Math.floor(chars/2);var endPos=str.length-half;half+=chars%2;str=str.substring(0,
half)+"..."+str.substring(endPos)}if(opt_protectEscapedCharacters)str=goog.string.htmlEscape(str);return str};goog.string.specialEscapeChars_={"\x00":"\\0","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t","\x0B":"\\x0B",'"':'\\"',"\\":"\\\\","\x3c":"\x3c"};goog.string.jsEscapeCache_={"'":"\\'"};
goog.string.quote=function(s){s=String(s);var sb=['"'];for(var i=0;i<s.length;i++){var ch=s.charAt(i);var cc=ch.charCodeAt(0);sb[i+1]=goog.string.specialEscapeChars_[ch]||(cc>31&&cc<127?ch:goog.string.escapeChar(ch))}sb.push('"');return sb.join("")};goog.string.escapeString=function(str){var sb=[];for(var i=0;i<str.length;i++)sb[i]=goog.string.escapeChar(str.charAt(i));return sb.join("")};
goog.string.escapeChar=function(c){if(c in goog.string.jsEscapeCache_)return goog.string.jsEscapeCache_[c];if(c in goog.string.specialEscapeChars_)return goog.string.jsEscapeCache_[c]=goog.string.specialEscapeChars_[c];var rv=c;var cc=c.charCodeAt(0);if(cc>31&&cc<127)rv=c;else{if(cc<256){rv="\\x";if(cc<16||cc>256)rv+="0"}else{rv="\\u";if(cc<4096)rv+="0"}rv+=cc.toString(16).toUpperCase()}return goog.string.jsEscapeCache_[c]=rv};
goog.string.contains=function(str,subString){return str.indexOf(subString)!=-1};goog.string.caseInsensitiveContains=function(str,subString){return goog.string.contains(str.toLowerCase(),subString.toLowerCase())};goog.string.countOf=function(s,ss){return s&&ss?s.split(ss).length-1:0};goog.string.removeAt=function(s,index,stringLength){var resultStr=s;if(index>=0&&index<s.length&&stringLength>0)resultStr=s.substr(0,index)+s.substr(index+stringLength,s.length-index-stringLength);return resultStr};
goog.string.remove=function(str,substr){return str.replace(substr,"")};goog.string.removeAll=function(s,ss){var re=new RegExp(goog.string.regExpEscape(ss),"g");return s.replace(re,"")};goog.string.replaceAll=function(s,ss,replacement){var re=new RegExp(goog.string.regExpEscape(ss),"g");return s.replace(re,replacement.replace(/\$/g,"$$$$"))};goog.string.regExpEscape=function(s){return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g,"\\$1").replace(/\x08/g,"\\x08")};
goog.string.repeat=String.prototype.repeat?function(string,length){return string.repeat(length)}:function(string,length){return(new Array(length+1)).join(string)};goog.string.padNumber=function(num,length,opt_precision){var s=goog.isDef(opt_precision)?num.toFixed(opt_precision):String(num);var index=s.indexOf(".");if(index==-1)index=s.length;return goog.string.repeat("0",Math.max(0,length-index))+s};goog.string.makeSafe=function(obj){return obj==null?"":String(obj)};
goog.string.buildString=function(var_args){return Array.prototype.join.call(arguments,"")};goog.string.getRandomString=function(){var x=2147483648;return Math.floor(Math.random()*x).toString(36)+Math.abs(Math.floor(Math.random()*x)^goog.now()).toString(36)};
goog.string.compareVersions=function(version1,version2){var order=0;var v1Subs=goog.string.trim(String(version1)).split(".");var v2Subs=goog.string.trim(String(version2)).split(".");var subCount=Math.max(v1Subs.length,v2Subs.length);for(var subIdx=0;order==0&&subIdx<subCount;subIdx++){var v1Sub=v1Subs[subIdx]||"";var v2Sub=v2Subs[subIdx]||"";do{var v1Comp=/(\d*)(\D*)(.*)/.exec(v1Sub)||["","","",""];var v2Comp=/(\d*)(\D*)(.*)/.exec(v2Sub)||["","","",""];if(v1Comp[0].length==0&&v2Comp[0].length==0)break;
var v1CompNum=v1Comp[1].length==0?0:parseInt(v1Comp[1],10);var v2CompNum=v2Comp[1].length==0?0:parseInt(v2Comp[1],10);order=goog.string.compareElements_(v1CompNum,v2CompNum)||goog.string.compareElements_(v1Comp[2].length==0,v2Comp[2].length==0)||goog.string.compareElements_(v1Comp[2],v2Comp[2]);v1Sub=v1Comp[3];v2Sub=v2Comp[3]}while(order==0)}return order};goog.string.compareElements_=function(left,right){if(left<right)return-1;else if(left>right)return 1;return 0};
goog.string.hashCode=function(str){var result=0;for(var i=0;i<str.length;++i)result=31*result+str.charCodeAt(i)>>>0;return result};goog.string.uniqueStringCounter_=Math.random()*2147483648|0;goog.string.createUniqueString=function(){return"goog_"+goog.string.uniqueStringCounter_++};goog.string.toNumber=function(str){var num=Number(str);if(num==0&&goog.string.isEmptyOrWhitespace(str))return NaN;return num};goog.string.isLowerCamelCase=function(str){return/^[a-z]+([A-Z][a-z]*)*$/.test(str)};
goog.string.isUpperCamelCase=function(str){return/^([A-Z][a-z]*)+$/.test(str)};goog.string.toCamelCase=function(str){return String(str).replace(/\-([a-z])/g,function(all,match){return match.toUpperCase()})};goog.string.toSelectorCase=function(str){return String(str).replace(/([A-Z])/g,"-$1").toLowerCase()};
goog.string.toTitleCase=function(str,opt_delimiters){var delimiters=goog.isString(opt_delimiters)?goog.string.regExpEscape(opt_delimiters):"\\s";delimiters=delimiters?"|["+delimiters+"]+":"";var regexp=new RegExp("(^"+delimiters+")([a-z])","g");return str.replace(regexp,function(all,p1,p2){return p1+p2.toUpperCase()})};goog.string.capitalize=function(str){return String(str.charAt(0)).toUpperCase()+String(str.substr(1)).toLowerCase()};
goog.string.parseInt=function(value){if(isFinite(value))value=String(value);if(goog.isString(value))return/^\s*-?0x/i.test(value)?parseInt(value,16):parseInt(value,10);return NaN};goog.string.splitLimit=function(str,separator,limit){var parts=str.split(separator);var returnVal=[];while(limit>0&&parts.length){returnVal.push(parts.shift());limit--}if(parts.length)returnVal.push(parts.join(separator));return returnVal};
goog.string.lastComponent=function(str,separators){if(!separators)return str;else if(typeof separators=="string")separators=[separators];var lastSeparatorIndex=-1;for(var i=0;i<separators.length;i++){if(separators[i]=="")continue;var currentSeparatorIndex=str.lastIndexOf(separators[i]);if(currentSeparatorIndex>lastSeparatorIndex)lastSeparatorIndex=currentSeparatorIndex}if(lastSeparatorIndex==-1)return str;return str.slice(lastSeparatorIndex+1)};
goog.string.editDistance=function(a,b){var v0=[];var v1=[];if(a==b)return 0;if(!a.length||!b.length)return Math.max(a.length,b.length);for(var i=0;i<b.length+1;i++)v0[i]=i;for(var i=0;i<a.length;i++){v1[0]=i+1;for(var j=0;j<b.length;j++){var cost=Number(a[i]!=b[j]);v1[j+1]=Math.min(v1[j]+1,v0[j+1]+1,v0[j]+cost)}for(var j=0;j<v0.length;j++)v0[j]=v1[j]}return v1[b.length]};goog.provide("goog.object");goog.object.is=function(v,v2){if(v===v2)return v!==0||1/v===1/v2;return v!==v&&v2!==v2};goog.object.forEach=function(obj,f,opt_obj){for(var key in obj)f.call(opt_obj,obj[key],key,obj)};goog.object.filter=function(obj,f,opt_obj){var res={};for(var key in obj)if(f.call(opt_obj,obj[key],key,obj))res[key]=obj[key];return res};goog.object.map=function(obj,f,opt_obj){var res={};for(var key in obj)res[key]=f.call(opt_obj,obj[key],key,obj);return res};
goog.object.some=function(obj,f,opt_obj){for(var key in obj)if(f.call(opt_obj,obj[key],key,obj))return true;return false};goog.object.every=function(obj,f,opt_obj){for(var key in obj)if(!f.call(opt_obj,obj[key],key,obj))return false;return true};goog.object.getCount=function(obj){var rv=0;for(var key in obj)rv++;return rv};goog.object.getAnyKey=function(obj){for(var key in obj)return key};goog.object.getAnyValue=function(obj){for(var key in obj)return obj[key]};
goog.object.contains=function(obj,val){return goog.object.containsValue(obj,val)};goog.object.getValues=function(obj){var res=[];var i=0;for(var key in obj)res[i++]=obj[key];return res};goog.object.getKeys=function(obj){var res=[];var i=0;for(var key in obj)res[i++]=key;return res};goog.object.getValueByKeys=function(obj,var_args){var isArrayLike=goog.isArrayLike(var_args);var keys=isArrayLike?var_args:arguments;for(var i=isArrayLike?0:1;i<keys.length;i++){obj=obj[keys[i]];if(!goog.isDef(obj))break}return obj};
goog.object.containsKey=function(obj,key){return obj!==null&&key in obj};goog.object.containsValue=function(obj,val){for(var key in obj)if(obj[key]==val)return true;return false};goog.object.findKey=function(obj,f,opt_this){for(var key in obj)if(f.call(opt_this,obj[key],key,obj))return key;return undefined};goog.object.findValue=function(obj,f,opt_this){var key=goog.object.findKey(obj,f,opt_this);return key&&obj[key]};goog.object.isEmpty=function(obj){for(var key in obj)return false;return true};
goog.object.clear=function(obj){for(var i in obj)delete obj[i]};goog.object.remove=function(obj,key){var rv;if(rv=key in obj)delete obj[key];return rv};goog.object.add=function(obj,key,val){if(obj!==null&&key in obj)throw Error('The object already contains the key "'+key+'"');goog.object.set(obj,key,val)};goog.object.get=function(obj,key,opt_val){if(obj!==null&&key in obj)return obj[key];return opt_val};goog.object.set=function(obj,key,value){obj[key]=value};
goog.object.setIfUndefined=function(obj,key,value){return key in obj?obj[key]:obj[key]=value};goog.object.setWithReturnValueIfNotSet=function(obj,key,f){if(key in obj)return obj[key];var val=f();obj[key]=val;return val};goog.object.equals=function(a,b){for(var k in a)if(!(k in b)||a[k]!==b[k])return false;for(var k in b)if(!(k in a))return false;return true};goog.object.clone=function(obj){var res={};for(var key in obj)res[key]=obj[key];return res};
goog.object.unsafeClone=function(obj){var type=goog.typeOf(obj);if(type=="object"||type=="array"){if(goog.isFunction(obj.clone))return obj.clone();var clone=type=="array"?[]:{};for(var key in obj)clone[key]=goog.object.unsafeClone(obj[key]);return clone}return obj};goog.object.transpose=function(obj){var transposed={};for(var key in obj)transposed[obj[key]]=key;return transposed};
goog.object.PROTOTYPE_FIELDS_=["constructor","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","toLocaleString","toString","valueOf"];goog.object.extend=function(target,var_args){var key,source;for(var i=1;i<arguments.length;i++){source=arguments[i];for(key in source)target[key]=source[key];for(var j=0;j<goog.object.PROTOTYPE_FIELDS_.length;j++){key=goog.object.PROTOTYPE_FIELDS_[j];if(Object.prototype.hasOwnProperty.call(source,key))target[key]=source[key]}}};
goog.object.create=function(var_args){var argLength=arguments.length;if(argLength==1&&goog.isArray(arguments[0]))return goog.object.create.apply(null,arguments[0]);if(argLength%2)throw Error("Uneven number of arguments");var rv={};for(var i=0;i<argLength;i+=2)rv[arguments[i]]=arguments[i+1];return rv};
goog.object.createSet=function(var_args){var argLength=arguments.length;if(argLength==1&&goog.isArray(arguments[0]))return goog.object.createSet.apply(null,arguments[0]);var rv={};for(var i=0;i<argLength;i++)rv[arguments[i]]=true;return rv};goog.object.createImmutableView=function(obj){var result=obj;if(Object.isFrozen&&!Object.isFrozen(obj)){result=Object.create(obj);Object.freeze(result)}return result};goog.object.isImmutableView=function(obj){return!!Object.isFrozen&&Object.isFrozen(obj)};
goog.object.getAllPropertyNames=function(obj,opt_includeObjectPrototype,opt_includeFunctionPrototype){if(!obj)return[];if(!Object.getOwnPropertyNames||!Object.getPrototypeOf)return goog.object.getKeys(obj);var visitedSet={};var proto=obj;while(proto&&(proto!==Object.prototype||!!opt_includeObjectPrototype)&&(proto!==Function.prototype||!!opt_includeFunctionPrototype)){var names=Object.getOwnPropertyNames(proto);for(var i=0;i<names.length;i++)visitedSet[names[i]]=true;proto=Object.getPrototypeOf(proto)}return goog.object.getKeys(visitedSet)};goog.provide("goog.math.Integer");goog.math.Integer=function(bits,sign){this.bits_=[];this.sign_=sign;var top=true;for(var i=bits.length-1;i>=0;i--){var val=bits[i]|0;if(!top||val!=sign){this.bits_[i]=val;top=false}}};goog.math.Integer.IntCache_={};
goog.math.Integer.fromInt=function(value){if(-128<=value&&value<128){var cachedObj=goog.math.Integer.IntCache_[value];if(cachedObj)return cachedObj}var obj=new goog.math.Integer([value|0],value<0?-1:0);if(-128<=value&&value<128)goog.math.Integer.IntCache_[value]=obj;return obj};
goog.math.Integer.fromNumber=function(value){if(isNaN(value)||!isFinite(value))return goog.math.Integer.ZERO;else if(value<0)return goog.math.Integer.fromNumber(-value).negate();else{var bits=[];var pow=1;for(var i=0;value>=pow;i++){bits[i]=value/pow|0;pow*=goog.math.Integer.TWO_PWR_32_DBL_}return new goog.math.Integer(bits,0)}};goog.math.Integer.fromBits=function(bits){var high=bits[bits.length-1];return new goog.math.Integer(bits,high&1<<31?-1:0)};
goog.math.Integer.fromString=function(str,opt_radix){if(str.length==0)throw Error("number format error: empty string");var radix=opt_radix||10;if(radix<2||36<radix)throw Error("radix out of range: "+radix);if(str.charAt(0)=="-")return goog.math.Integer.fromString(str.substring(1),radix).negate();else if(str.indexOf("-")>=0)throw Error('number format error: interior "-" character');var radixToPower=goog.math.Integer.fromNumber(Math.pow(radix,8));var result=goog.math.Integer.ZERO;for(var i=0;i<str.length;i+=
8){var size=Math.min(8,str.length-i);var value=parseInt(str.substring(i,i+size),radix);if(size<8){var power=goog.math.Integer.fromNumber(Math.pow(radix,size));result=result.multiply(power).add(goog.math.Integer.fromNumber(value))}else{result=result.multiply(radixToPower);result=result.add(goog.math.Integer.fromNumber(value))}}return result};goog.math.Integer.TWO_PWR_32_DBL_=(1<<16)*(1<<16);goog.math.Integer.ZERO=goog.math.Integer.fromInt(0);goog.math.Integer.ONE=goog.math.Integer.fromInt(1);
goog.math.Integer.TWO_PWR_24_=goog.math.Integer.fromInt(1<<24);goog.math.Integer.prototype.toInt=function(){return this.bits_.length>0?this.bits_[0]:this.sign_};goog.math.Integer.prototype.toNumber=function(){if(this.isNegative())return-this.negate().toNumber();else{var val=0;var pow=1;for(var i=0;i<this.bits_.length;i++){val+=this.getBitsUnsigned(i)*pow;pow*=goog.math.Integer.TWO_PWR_32_DBL_}return val}};
goog.math.Integer.prototype.toString=function(opt_radix){var radix=opt_radix||10;if(radix<2||36<radix)throw Error("radix out of range: "+radix);if(this.isZero())return"0";else if(this.isNegative())return"-"+this.negate().toString(radix);var radixToPower=goog.math.Integer.fromNumber(Math.pow(radix,6));var rem=this;var result="";while(true){var remDiv=rem.divide(radixToPower);var intval=rem.subtract(remDiv.multiply(radixToPower)).toInt()>>>0;var digits=intval.toString(radix);rem=remDiv;if(rem.isZero())return digits+
result;else{while(digits.length<6)digits="0"+digits;result=""+digits+result}}};goog.math.Integer.prototype.getBits=function(index){if(index<0)return 0;else if(index<this.bits_.length)return this.bits_[index];else return this.sign_};goog.math.Integer.prototype.getBitsUnsigned=function(index){var val=this.getBits(index);return val>=0?val:goog.math.Integer.TWO_PWR_32_DBL_+val};goog.math.Integer.prototype.getSign=function(){return this.sign_};
goog.math.Integer.prototype.isZero=function(){if(this.sign_!=0)return false;for(var i=0;i<this.bits_.length;i++)if(this.bits_[i]!=0)return false;return true};goog.math.Integer.prototype.isNegative=function(){return this.sign_==-1};goog.math.Integer.prototype.isOdd=function(){return this.bits_.length==0&&this.sign_==-1||this.bits_.length>0&&(this.bits_[0]&1)!=0};
goog.math.Integer.prototype.equals=function(other){if(this.sign_!=other.sign_)return false;var len=Math.max(this.bits_.length,other.bits_.length);for(var i=0;i<len;i++)if(this.getBits(i)!=other.getBits(i))return false;return true};goog.math.Integer.prototype.notEquals=function(other){return!this.equals(other)};goog.math.Integer.prototype.greaterThan=function(other){return this.compare(other)>0};goog.math.Integer.prototype.greaterThanOrEqual=function(other){return this.compare(other)>=0};
goog.math.Integer.prototype.lessThan=function(other){return this.compare(other)<0};goog.math.Integer.prototype.lessThanOrEqual=function(other){return this.compare(other)<=0};goog.math.Integer.prototype.compare=function(other){var diff=this.subtract(other);if(diff.isNegative())return-1;else if(diff.isZero())return 0;else return+1};
goog.math.Integer.prototype.shorten=function(numBits){var arr_index=numBits-1>>5;var bit_index=(numBits-1)%32;var bits=[];for(var i=0;i<arr_index;i++)bits[i]=this.getBits(i);var sigBits=bit_index==31?4294967295:(1<<bit_index+1)-1;var val=this.getBits(arr_index)&sigBits;if(val&1<<bit_index){val|=4294967295-sigBits;bits[arr_index]=val;return new goog.math.Integer(bits,-1)}else{bits[arr_index]=val;return new goog.math.Integer(bits,0)}};goog.math.Integer.prototype.negate=function(){return this.not().add(goog.math.Integer.ONE)};
goog.math.Integer.prototype.add=function(other){var len=Math.max(this.bits_.length,other.bits_.length);var arr=[];var carry=0;for(var i=0;i<=len;i++){var a1=this.getBits(i)>>>16;var a0=this.getBits(i)&65535;var b1=other.getBits(i)>>>16;var b0=other.getBits(i)&65535;var c0=carry+a0+b0;var c1=(c0>>>16)+a1+b1;carry=c1>>>16;c0&=65535;c1&=65535;arr[i]=c1<<16|c0}return goog.math.Integer.fromBits(arr)};goog.math.Integer.prototype.subtract=function(other){return this.add(other.negate())};
goog.math.Integer.prototype.multiply=function(other){if(this.isZero())return goog.math.Integer.ZERO;else if(other.isZero())return goog.math.Integer.ZERO;if(this.isNegative())if(other.isNegative())return this.negate().multiply(other.negate());else return this.negate().multiply(other).negate();else if(other.isNegative())return this.multiply(other.negate()).negate();if(this.lessThan(goog.math.Integer.TWO_PWR_24_)&&other.lessThan(goog.math.Integer.TWO_PWR_24_))return goog.math.Integer.fromNumber(this.toNumber()*
other.toNumber());var len=this.bits_.length+other.bits_.length;var arr=[];for(var i=0;i<2*len;i++)arr[i]=0;for(var i=0;i<this.bits_.length;i++)for(var j=0;j<other.bits_.length;j++){var a1=this.getBits(i)>>>16;var a0=this.getBits(i)&65535;var b1=other.getBits(j)>>>16;var b0=other.getBits(j)&65535;arr[2*i+2*j]+=a0*b0;goog.math.Integer.carry16_(arr,2*i+2*j);arr[2*i+2*j+1]+=a1*b0;goog.math.Integer.carry16_(arr,2*i+2*j+1);arr[2*i+2*j+1]+=a0*b1;goog.math.Integer.carry16_(arr,2*i+2*j+1);arr[2*i+2*j+2]+=
a1*b1;goog.math.Integer.carry16_(arr,2*i+2*j+2)}for(var i=0;i<len;i++)arr[i]=arr[2*i+1]<<16|arr[2*i];for(var i=len;i<2*len;i++)arr[i]=0;return new goog.math.Integer(arr,0)};goog.math.Integer.carry16_=function(bits,index){while((bits[index]&65535)!=bits[index]){bits[index+1]+=bits[index]>>>16;bits[index]&=65535;index++}};
goog.math.Integer.prototype.slowDivide_=function(other){if(this.isNegative()||other.isNegative())throw Error("slowDivide_ only works with positive integers.");var twoPower=goog.math.Integer.ONE;var multiple=other;while(multiple.lessThanOrEqual(this)){twoPower=twoPower.shiftLeft(1);multiple=multiple.shiftLeft(1)}var res=twoPower.shiftRight(1);var total=multiple.shiftRight(1);var total2;multiple=multiple.shiftRight(2);twoPower=twoPower.shiftRight(2);while(!multiple.isZero()){total2=total.add(multiple);
if(total2.lessThanOrEqual(this)){res=res.add(twoPower);total=total2}multiple=multiple.shiftRight(1);twoPower=twoPower.shiftRight(1)}return res};
goog.math.Integer.prototype.divide=function(other){if(other.isZero())throw Error("division by zero");else if(this.isZero())return goog.math.Integer.ZERO;if(this.isNegative())if(other.isNegative())return this.negate().divide(other.negate());else return this.negate().divide(other).negate();else if(other.isNegative())return this.divide(other.negate()).negate();if(this.bits_.length>30)return this.slowDivide_(other);var res=goog.math.Integer.ZERO;var rem=this;while(rem.greaterThanOrEqual(other)){var approx=
Math.max(1,Math.floor(rem.toNumber()/other.toNumber()));var log2=Math.ceil(Math.log(approx)/Math.LN2);var delta=log2<=48?1:Math.pow(2,log2-48);var approxRes=goog.math.Integer.fromNumber(approx);var approxRem=approxRes.multiply(other);while(approxRem.isNegative()||approxRem.greaterThan(rem)){approx-=delta;approxRes=goog.math.Integer.fromNumber(approx);approxRem=approxRes.multiply(other)}if(approxRes.isZero())approxRes=goog.math.Integer.ONE;res=res.add(approxRes);rem=rem.subtract(approxRem)}return res};
goog.math.Integer.prototype.modulo=function(other){return this.subtract(this.divide(other).multiply(other))};goog.math.Integer.prototype.not=function(){var len=this.bits_.length;var arr=[];for(var i=0;i<len;i++)arr[i]=~this.bits_[i];return new goog.math.Integer(arr,~this.sign_)};goog.math.Integer.prototype.and=function(other){var len=Math.max(this.bits_.length,other.bits_.length);var arr=[];for(var i=0;i<len;i++)arr[i]=this.getBits(i)&other.getBits(i);return new goog.math.Integer(arr,this.sign_&other.sign_)};
goog.math.Integer.prototype.or=function(other){var len=Math.max(this.bits_.length,other.bits_.length);var arr=[];for(var i=0;i<len;i++)arr[i]=this.getBits(i)|other.getBits(i);return new goog.math.Integer(arr,this.sign_|other.sign_)};goog.math.Integer.prototype.xor=function(other){var len=Math.max(this.bits_.length,other.bits_.length);var arr=[];for(var i=0;i<len;i++)arr[i]=this.getBits(i)^other.getBits(i);return new goog.math.Integer(arr,this.sign_^other.sign_)};
goog.math.Integer.prototype.shiftLeft=function(numBits){var arr_delta=numBits>>5;var bit_delta=numBits%32;var len=this.bits_.length+arr_delta+(bit_delta>0?1:0);var arr=[];for(var i=0;i<len;i++)if(bit_delta>0)arr[i]=this.getBits(i-arr_delta)<<bit_delta|this.getBits(i-arr_delta-1)>>>32-bit_delta;else arr[i]=this.getBits(i-arr_delta);return new goog.math.Integer(arr,this.sign_)};
goog.math.Integer.prototype.shiftRight=function(numBits){var arr_delta=numBits>>5;var bit_delta=numBits%32;var len=this.bits_.length-arr_delta;var arr=[];for(var i=0;i<len;i++)if(bit_delta>0)arr[i]=this.getBits(i+arr_delta)>>>bit_delta|this.getBits(i+arr_delta+1)<<32-bit_delta;else arr[i]=this.getBits(i+arr_delta);return new goog.math.Integer(arr,this.sign_)};goog.provide("goog.string.StringBuffer");goog.string.StringBuffer=function(opt_a1,var_args){if(opt_a1!=null)this.append.apply(this,arguments)};goog.string.StringBuffer.prototype.buffer_="";goog.string.StringBuffer.prototype.set=function(s){this.buffer_=""+s};goog.string.StringBuffer.prototype.append=function(a1,opt_a2,var_args){this.buffer_+=String(a1);if(opt_a2!=null)for(var i=1;i<arguments.length;i++)this.buffer_+=arguments[i];return this};
goog.string.StringBuffer.prototype.clear=function(){this.buffer_=""};goog.string.StringBuffer.prototype.getLength=function(){return this.buffer_.length};goog.string.StringBuffer.prototype.toString=function(){return this.buffer_};goog.provide("goog.debug.Error");goog.debug.Error=function(opt_msg){if(Error.captureStackTrace)Error.captureStackTrace(this,goog.debug.Error);else{var stack=(new Error).stack;if(stack)this.stack=stack}if(opt_msg)this.message=String(opt_msg);this.reportErrorToServer=true};goog.inherits(goog.debug.Error,Error);goog.debug.Error.prototype.name="CustomError";goog.provide("goog.dom.NodeType");goog.dom.NodeType={ELEMENT:1,ATTRIBUTE:2,TEXT:3,CDATA_SECTION:4,ENTITY_REFERENCE:5,ENTITY:6,PROCESSING_INSTRUCTION:7,COMMENT:8,DOCUMENT:9,DOCUMENT_TYPE:10,DOCUMENT_FRAGMENT:11,NOTATION:12};goog.provide("goog.asserts");goog.provide("goog.asserts.AssertionError");goog.require("goog.debug.Error");goog.require("goog.dom.NodeType");goog.require("goog.string");goog.define("goog.asserts.ENABLE_ASSERTS",goog.DEBUG);goog.asserts.AssertionError=function(messagePattern,messageArgs){messageArgs.unshift(messagePattern);goog.debug.Error.call(this,goog.string.subs.apply(null,messageArgs));messageArgs.shift();this.messagePattern=messagePattern};goog.inherits(goog.asserts.AssertionError,goog.debug.Error);
goog.asserts.AssertionError.prototype.name="AssertionError";goog.asserts.DEFAULT_ERROR_HANDLER=function(e){throw e;};goog.asserts.errorHandler_=goog.asserts.DEFAULT_ERROR_HANDLER;goog.asserts.doAssertFailure_=function(defaultMessage,defaultArgs,givenMessage,givenArgs){var message="Assertion failed";if(givenMessage){message+=": "+givenMessage;var args=givenArgs}else if(defaultMessage){message+=": "+defaultMessage;args=defaultArgs}var e=new goog.asserts.AssertionError(""+message,args||[]);goog.asserts.errorHandler_(e)};
goog.asserts.setErrorHandler=function(errorHandler){if(goog.asserts.ENABLE_ASSERTS)goog.asserts.errorHandler_=errorHandler};goog.asserts.assert=function(condition,opt_message,var_args){if(goog.asserts.ENABLE_ASSERTS&&!condition)goog.asserts.doAssertFailure_("",null,opt_message,Array.prototype.slice.call(arguments,2));return condition};
goog.asserts.fail=function(opt_message,var_args){if(goog.asserts.ENABLE_ASSERTS)goog.asserts.errorHandler_(new goog.asserts.AssertionError("Failure"+(opt_message?": "+opt_message:""),Array.prototype.slice.call(arguments,1)))};goog.asserts.assertNumber=function(value,opt_message,var_args){if(goog.asserts.ENABLE_ASSERTS&&!goog.isNumber(value))goog.asserts.doAssertFailure_("Expected number but got %s: %s.",[goog.typeOf(value),value],opt_message,Array.prototype.slice.call(arguments,2));return value};
goog.asserts.assertString=function(value,opt_message,var_args){if(goog.asserts.ENABLE_ASSERTS&&!goog.isString(value))goog.asserts.doAssertFailure_("Expected string but got %s: %s.",[goog.typeOf(value),value],opt_message,Array.prototype.slice.call(arguments,2));return value};
goog.asserts.assertFunction=function(value,opt_message,var_args){if(goog.asserts.ENABLE_ASSERTS&&!goog.isFunction(value))goog.asserts.doAssertFailure_("Expected function but got %s: %s.",[goog.typeOf(value),value],opt_message,Array.prototype.slice.call(arguments,2));return value};
goog.asserts.assertObject=function(value,opt_message,var_args){if(goog.asserts.ENABLE_ASSERTS&&!goog.isObject(value))goog.asserts.doAssertFailure_("Expected object but got %s: %s.",[goog.typeOf(value),value],opt_message,Array.prototype.slice.call(arguments,2));return value};
goog.asserts.assertArray=function(value,opt_message,var_args){if(goog.asserts.ENABLE_ASSERTS&&!goog.isArray(value))goog.asserts.doAssertFailure_("Expected array but got %s: %s.",[goog.typeOf(value),value],opt_message,Array.prototype.slice.call(arguments,2));return value};
goog.asserts.assertBoolean=function(value,opt_message,var_args){if(goog.asserts.ENABLE_ASSERTS&&!goog.isBoolean(value))goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.",[goog.typeOf(value),value],opt_message,Array.prototype.slice.call(arguments,2));return value};
goog.asserts.assertElement=function(value,opt_message,var_args){if(goog.asserts.ENABLE_ASSERTS&&(!goog.isObject(value)||value.nodeType!=goog.dom.NodeType.ELEMENT))goog.asserts.doAssertFailure_("Expected Element but got %s: %s.",[goog.typeOf(value),value],opt_message,Array.prototype.slice.call(arguments,2));return value};
goog.asserts.assertInstanceof=function(value,type,opt_message,var_args){if(goog.asserts.ENABLE_ASSERTS&&!(value instanceof type))goog.asserts.doAssertFailure_("Expected instanceof %s but got %s.",[goog.asserts.getType_(type),goog.asserts.getType_(value)],opt_message,Array.prototype.slice.call(arguments,3));return value};goog.asserts.assertObjectPrototypeIsIntact=function(){for(var key in Object.prototype)goog.asserts.fail(key+" should not be enumerable in Object.prototype.")};
goog.asserts.getType_=function(value){if(value instanceof Function)return value.displayName||value.name||"unknown type name";else if(value instanceof Object)return value.constructor.displayName||value.constructor.name||Object.prototype.toString.call(value);else return value===null?"null":typeof value};goog.provide("goog.array");goog.require("goog.asserts");goog.define("goog.NATIVE_ARRAY_PROTOTYPES",goog.TRUSTED_SITE);goog.define("goog.array.ASSUME_NATIVE_FUNCTIONS",false);goog.array.peek=function(array){return array[array.length-1]};goog.array.last=goog.array.peek;
goog.array.indexOf=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.indexOf)?function(arr,obj,opt_fromIndex){goog.asserts.assert(arr.length!=null);return Array.prototype.indexOf.call(arr,obj,opt_fromIndex)}:function(arr,obj,opt_fromIndex){var fromIndex=opt_fromIndex==null?0:opt_fromIndex<0?Math.max(0,arr.length+opt_fromIndex):opt_fromIndex;if(goog.isString(arr)){if(!goog.isString(obj)||obj.length!=1)return-1;return arr.indexOf(obj,fromIndex)}for(var i=fromIndex;i<
arr.length;i++)if(i in arr&&arr[i]===obj)return i;return-1};
goog.array.lastIndexOf=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.lastIndexOf)?function(arr,obj,opt_fromIndex){goog.asserts.assert(arr.length!=null);var fromIndex=opt_fromIndex==null?arr.length-1:opt_fromIndex;return Array.prototype.lastIndexOf.call(arr,obj,fromIndex)}:function(arr,obj,opt_fromIndex){var fromIndex=opt_fromIndex==null?arr.length-1:opt_fromIndex;if(fromIndex<0)fromIndex=Math.max(0,arr.length+fromIndex);if(goog.isString(arr)){if(!goog.isString(obj)||
obj.length!=1)return-1;return arr.lastIndexOf(obj,fromIndex)}for(var i=fromIndex;i>=0;i--)if(i in arr&&arr[i]===obj)return i;return-1};goog.array.forEach=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.forEach)?function(arr,f,opt_obj){goog.asserts.assert(arr.length!=null);Array.prototype.forEach.call(arr,f,opt_obj)}:function(arr,f,opt_obj){var l=arr.length;var arr2=goog.isString(arr)?arr.split(""):arr;for(var i=0;i<l;i++)if(i in arr2)f.call(opt_obj,arr2[i],i,arr)};
goog.array.forEachRight=function(arr,f,opt_obj){var l=arr.length;var arr2=goog.isString(arr)?arr.split(""):arr;for(var i=l-1;i>=0;--i)if(i in arr2)f.call(opt_obj,arr2[i],i,arr)};
goog.array.filter=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.filter)?function(arr,f,opt_obj){goog.asserts.assert(arr.length!=null);return Array.prototype.filter.call(arr,f,opt_obj)}:function(arr,f,opt_obj){var l=arr.length;var res=[];var resLength=0;var arr2=goog.isString(arr)?arr.split(""):arr;for(var i=0;i<l;i++)if(i in arr2){var val=arr2[i];if(f.call(opt_obj,val,i,arr))res[resLength++]=val}return res};
goog.array.map=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.map)?function(arr,f,opt_obj){goog.asserts.assert(arr.length!=null);return Array.prototype.map.call(arr,f,opt_obj)}:function(arr,f,opt_obj){var l=arr.length;var res=new Array(l);var arr2=goog.isString(arr)?arr.split(""):arr;for(var i=0;i<l;i++)if(i in arr2)res[i]=f.call(opt_obj,arr2[i],i,arr);return res};
goog.array.reduce=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.reduce)?function(arr,f,val,opt_obj){goog.asserts.assert(arr.length!=null);if(opt_obj)f=goog.bind(f,opt_obj);return Array.prototype.reduce.call(arr,f,val)}:function(arr,f,val,opt_obj){var rval=val;goog.array.forEach(arr,function(val,index){rval=f.call(opt_obj,rval,val,index,arr)});return rval};
goog.array.reduceRight=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.reduceRight)?function(arr,f,val,opt_obj){goog.asserts.assert(arr.length!=null);goog.asserts.assert(f!=null);if(opt_obj)f=goog.bind(f,opt_obj);return Array.prototype.reduceRight.call(arr,f,val)}:function(arr,f,val,opt_obj){var rval=val;goog.array.forEachRight(arr,function(val,index){rval=f.call(opt_obj,rval,val,index,arr)});return rval};
goog.array.some=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.some)?function(arr,f,opt_obj){goog.asserts.assert(arr.length!=null);return Array.prototype.some.call(arr,f,opt_obj)}:function(arr,f,opt_obj){var l=arr.length;var arr2=goog.isString(arr)?arr.split(""):arr;for(var i=0;i<l;i++)if(i in arr2&&f.call(opt_obj,arr2[i],i,arr))return true;return false};
goog.array.every=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.every)?function(arr,f,opt_obj){goog.asserts.assert(arr.length!=null);return Array.prototype.every.call(arr,f,opt_obj)}:function(arr,f,opt_obj){var l=arr.length;var arr2=goog.isString(arr)?arr.split(""):arr;for(var i=0;i<l;i++)if(i in arr2&&!f.call(opt_obj,arr2[i],i,arr))return false;return true};
goog.array.count=function(arr,f,opt_obj){var count=0;goog.array.forEach(arr,function(element,index,arr){if(f.call(opt_obj,element,index,arr))++count},opt_obj);return count};goog.array.find=function(arr,f,opt_obj){var i=goog.array.findIndex(arr,f,opt_obj);return i<0?null:goog.isString(arr)?arr.charAt(i):arr[i]};goog.array.findIndex=function(arr,f,opt_obj){var l=arr.length;var arr2=goog.isString(arr)?arr.split(""):arr;for(var i=0;i<l;i++)if(i in arr2&&f.call(opt_obj,arr2[i],i,arr))return i;return-1};
goog.array.findRight=function(arr,f,opt_obj){var i=goog.array.findIndexRight(arr,f,opt_obj);return i<0?null:goog.isString(arr)?arr.charAt(i):arr[i]};goog.array.findIndexRight=function(arr,f,opt_obj){var l=arr.length;var arr2=goog.isString(arr)?arr.split(""):arr;for(var i=l-1;i>=0;i--)if(i in arr2&&f.call(opt_obj,arr2[i],i,arr))return i;return-1};goog.array.contains=function(arr,obj){return goog.array.indexOf(arr,obj)>=0};goog.array.isEmpty=function(arr){return arr.length==0};
goog.array.clear=function(arr){if(!goog.isArray(arr))for(var i=arr.length-1;i>=0;i--)delete arr[i];arr.length=0};goog.array.insert=function(arr,obj){if(!goog.array.contains(arr,obj))arr.push(obj)};goog.array.insertAt=function(arr,obj,opt_i){goog.array.splice(arr,opt_i,0,obj)};goog.array.insertArrayAt=function(arr,elementsToAdd,opt_i){goog.partial(goog.array.splice,arr,opt_i,0).apply(null,elementsToAdd)};
goog.array.insertBefore=function(arr,obj,opt_obj2){var i;if(arguments.length==2||(i=goog.array.indexOf(arr,opt_obj2))<0)arr.push(obj);else goog.array.insertAt(arr,obj,i)};goog.array.remove=function(arr,obj){var i=goog.array.indexOf(arr,obj);var rv;if(rv=i>=0)goog.array.removeAt(arr,i);return rv};goog.array.removeLast=function(arr,obj){var i=goog.array.lastIndexOf(arr,obj);if(i>=0){goog.array.removeAt(arr,i);return true}return false};
goog.array.removeAt=function(arr,i){goog.asserts.assert(arr.length!=null);return Array.prototype.splice.call(arr,i,1).length==1};goog.array.removeIf=function(arr,f,opt_obj){var i=goog.array.findIndex(arr,f,opt_obj);if(i>=0){goog.array.removeAt(arr,i);return true}return false};goog.array.removeAllIf=function(arr,f,opt_obj){var removedCount=0;goog.array.forEachRight(arr,function(val,index){if(f.call(opt_obj,val,index,arr))if(goog.array.removeAt(arr,index))removedCount++});return removedCount};
goog.array.concat=function(var_args){return Array.prototype.concat.apply([],arguments)};goog.array.join=function(var_args){return Array.prototype.concat.apply([],arguments)};goog.array.toArray=function(object){var length=object.length;if(length>0){var rv=new Array(length);for(var i=0;i<length;i++)rv[i]=object[i];return rv}return[]};goog.array.clone=goog.array.toArray;
goog.array.extend=function(arr1,var_args){for(var i=1;i<arguments.length;i++){var arr2=arguments[i];if(goog.isArrayLike(arr2)){var len1=arr1.length||0;var len2=arr2.length||0;arr1.length=len1+len2;for(var j=0;j<len2;j++)arr1[len1+j]=arr2[j]}else arr1.push(arr2)}};goog.array.splice=function(arr,index,howMany,var_args){goog.asserts.assert(arr.length!=null);return Array.prototype.splice.apply(arr,goog.array.slice(arguments,1))};
goog.array.slice=function(arr,start,opt_end){goog.asserts.assert(arr.length!=null);if(arguments.length<=2)return Array.prototype.slice.call(arr,start);else return Array.prototype.slice.call(arr,start,opt_end)};
goog.array.removeDuplicates=function(arr,opt_rv,opt_hashFn){var returnArray=opt_rv||arr;var defaultHashFn=function(item){return goog.isObject(item)?"o"+goog.getUid(item):(typeof item).charAt(0)+item};var hashFn=opt_hashFn||defaultHashFn;var seen={},cursorInsert=0,cursorRead=0;while(cursorRead<arr.length){var current=arr[cursorRead++];var key=hashFn(current);if(!Object.prototype.hasOwnProperty.call(seen,key)){seen[key]=true;returnArray[cursorInsert++]=current}}returnArray.length=cursorInsert};
goog.array.binarySearch=function(arr,target,opt_compareFn){return goog.array.binarySearch_(arr,opt_compareFn||goog.array.defaultCompare,false,target)};goog.array.binarySelect=function(arr,evaluator,opt_obj){return goog.array.binarySearch_(arr,evaluator,true,undefined,opt_obj)};
goog.array.binarySearch_=function(arr,compareFn,isEvaluator,opt_target,opt_selfObj){var left=0;var right=arr.length;var found;while(left<right){var middle=left+right>>1;var compareResult;if(isEvaluator)compareResult=compareFn.call(opt_selfObj,arr[middle],middle,arr);else compareResult=compareFn(opt_target,arr[middle]);if(compareResult>0)left=middle+1;else{right=middle;found=!compareResult}}return found?left:~left};goog.array.sort=function(arr,opt_compareFn){arr.sort(opt_compareFn||goog.array.defaultCompare)};
goog.array.stableSort=function(arr,opt_compareFn){var compArr=new Array(arr.length);for(var i=0;i<arr.length;i++)compArr[i]={index:i,value:arr[i]};var valueCompareFn=opt_compareFn||goog.array.defaultCompare;function stableCompareFn(obj1,obj2){return valueCompareFn(obj1.value,obj2.value)||obj1.index-obj2.index}goog.array.sort(compArr,stableCompareFn);for(var i=0;i<arr.length;i++)arr[i]=compArr[i].value};
goog.array.sortByKey=function(arr,keyFn,opt_compareFn){var keyCompareFn=opt_compareFn||goog.array.defaultCompare;goog.array.sort(arr,function(a,b){return keyCompareFn(keyFn(a),keyFn(b))})};goog.array.sortObjectsByKey=function(arr,key,opt_compareFn){goog.array.sortByKey(arr,function(obj){return obj[key]},opt_compareFn)};
goog.array.isSorted=function(arr,opt_compareFn,opt_strict){var compare=opt_compareFn||goog.array.defaultCompare;for(var i=1;i<arr.length;i++){var compareResult=compare(arr[i-1],arr[i]);if(compareResult>0||compareResult==0&&opt_strict)return false}return true};
goog.array.equals=function(arr1,arr2,opt_equalsFn){if(!goog.isArrayLike(arr1)||!goog.isArrayLike(arr2)||arr1.length!=arr2.length)return false;var l=arr1.length;var equalsFn=opt_equalsFn||goog.array.defaultCompareEquality;for(var i=0;i<l;i++)if(!equalsFn(arr1[i],arr2[i]))return false;return true};
goog.array.compare3=function(arr1,arr2,opt_compareFn){var compare=opt_compareFn||goog.array.defaultCompare;var l=Math.min(arr1.length,arr2.length);for(var i=0;i<l;i++){var result=compare(arr1[i],arr2[i]);if(result!=0)return result}return goog.array.defaultCompare(arr1.length,arr2.length)};goog.array.defaultCompare=function(a,b){return a>b?1:a<b?-1:0};goog.array.inverseDefaultCompare=function(a,b){return-goog.array.defaultCompare(a,b)};goog.array.defaultCompareEquality=function(a,b){return a===b};
goog.array.binaryInsert=function(array,value,opt_compareFn){var index=goog.array.binarySearch(array,value,opt_compareFn);if(index<0){goog.array.insertAt(array,value,-(index+1));return true}return false};goog.array.binaryRemove=function(array,value,opt_compareFn){var index=goog.array.binarySearch(array,value,opt_compareFn);return index>=0?goog.array.removeAt(array,index):false};
goog.array.bucket=function(array,sorter,opt_obj){var buckets={};for(var i=0;i<array.length;i++){var value=array[i];var key=sorter.call(opt_obj,value,i,array);if(goog.isDef(key)){var bucket=buckets[key]||(buckets[key]=[]);bucket.push(value)}}return buckets};goog.array.toObject=function(arr,keyFunc,opt_obj){var ret={};goog.array.forEach(arr,function(element,index){ret[keyFunc.call(opt_obj,element,index,arr)]=element});return ret};
goog.array.range=function(startOrEnd,opt_end,opt_step){var array=[];var start=0;var end=startOrEnd;var step=opt_step||1;if(opt_end!==undefined){start=startOrEnd;end=opt_end}if(step*(end-start)<0)return[];if(step>0)for(var i=start;i<end;i+=step)array.push(i);else for(var i=start;i>end;i+=step)array.push(i);return array};goog.array.repeat=function(value,n){var array=[];for(var i=0;i<n;i++)array[i]=value;return array};
goog.array.flatten=function(var_args){var CHUNK_SIZE=8192;var result=[];for(var i=0;i<arguments.length;i++){var element=arguments[i];if(goog.isArray(element))for(var c=0;c<element.length;c+=CHUNK_SIZE){var chunk=goog.array.slice(element,c,c+CHUNK_SIZE);var recurseResult=goog.array.flatten.apply(null,chunk);for(var r=0;r<recurseResult.length;r++)result.push(recurseResult[r])}else result.push(element)}return result};
goog.array.rotate=function(array,n){goog.asserts.assert(array.length!=null);if(array.length){n%=array.length;if(n>0)Array.prototype.unshift.apply(array,array.splice(-n,n));else if(n<0)Array.prototype.push.apply(array,array.splice(0,-n))}return array};
goog.array.moveItem=function(arr,fromIndex,toIndex){goog.asserts.assert(fromIndex>=0&&fromIndex<arr.length);goog.asserts.assert(toIndex>=0&&toIndex<arr.length);var removedItems=Array.prototype.splice.call(arr,fromIndex,1);Array.prototype.splice.call(arr,toIndex,0,removedItems[0])};
goog.array.zip=function(var_args){if(!arguments.length)return[];var result=[];var minLen=arguments[0].length;for(var i=1;i<arguments.length;i++)if(arguments[i].length<minLen)minLen=arguments[i].length;for(var i=0;i<minLen;i++){var value=[];for(var j=0;j<arguments.length;j++)value.push(arguments[j][i]);result.push(value)}return result};
goog.array.shuffle=function(arr,opt_randFn){var randFn=opt_randFn||Math.random;for(var i=arr.length-1;i>0;i--){var j=Math.floor(randFn()*(i+1));var tmp=arr[i];arr[i]=arr[j];arr[j]=tmp}};goog.array.copyByIndex=function(arr,index_arr){var result=[];goog.array.forEach(index_arr,function(index){result.push(arr[index])});return result};goog.array.concatMap=function(arr,f,opt_obj){return goog.array.concat.apply([],goog.array.map(arr,f,opt_obj))};goog.provide("goog.reflect");goog.reflect.object=function(type,object){return object};goog.reflect.objectProperty=function(prop,object){return prop};goog.reflect.sinkValue=function(x){goog.reflect.sinkValue[" "](x);return x};goog.reflect.sinkValue[" "]=goog.nullFunction;goog.reflect.canAccessProperty=function(obj,prop){try{goog.reflect.sinkValue(obj[prop]);return true}catch(e){}return false};
goog.reflect.cache=function(cacheObj,key,valueFn,opt_keyFn){var storedKey=opt_keyFn?opt_keyFn(key):key;if(Object.prototype.hasOwnProperty.call(cacheObj,storedKey))return cacheObj[storedKey];return cacheObj[storedKey]=valueFn(key)};goog.provide("goog.math.Long");goog.require("goog.asserts");goog.require("goog.reflect");goog.math.Long=function(low,high){this.low_=low|0;this.high_=high|0};goog.math.Long.IntCache_={};goog.math.Long.valueCache_={};goog.math.Long.getCachedIntValue_=function(value){return goog.reflect.cache(goog.math.Long.IntCache_,value,function(val){return new goog.math.Long(val,val<0?-1:0)})};
goog.math.Long.MAX_VALUE_FOR_RADIX_=["","","111111111111111111111111111111111111111111111111111111111111111","2021110011022210012102010021220101220221","13333333333333333333333333333333","1104332401304422434310311212","1540241003031030222122211","22341010611245052052300","777777777777777777777","67404283172107811827","9223372036854775807","1728002635214590697","41a792678515120367","10b269549075433c37","4340724c6c71dc7a7","160e2ad3246366807","7fffffffffffffff","33d3d8307b214008","16agh595df825fa7",
"ba643dci0ffeehh","5cbfjia3fh26ja7","2heiciiie82dh97","1adaibb21dckfa7","i6k448cf4192c2","acd772jnc9l0l7","64ie1focnn5g77","3igoecjbmca687","27c48l5b37oaop","1bk39f3ah3dmq7","q1se8f0m04isb","hajppbc1fc207","bm03i95hia437","7vvvvvvvvvvvv","5hg4ck9jd4u37","3tdtk1v8j6tpp","2pijmikexrxp7","1y2p0ij32e8e7"];
goog.math.Long.MIN_VALUE_FOR_RADIX_=["","","-1000000000000000000000000000000000000000000000000000000000000000","-2021110011022210012102010021220101220222","-20000000000000000000000000000000","-1104332401304422434310311213","-1540241003031030222122212","-22341010611245052052301","-1000000000000000000000","-67404283172107811828","-9223372036854775808","-1728002635214590698","-41a792678515120368","-10b269549075433c38","-4340724c6c71dc7a8","-160e2ad3246366808","-8000000000000000","-33d3d8307b214009",
"-16agh595df825fa8","-ba643dci0ffeehi","-5cbfjia3fh26ja8","-2heiciiie82dh98","-1adaibb21dckfa8","-i6k448cf4192c3","-acd772jnc9l0l8","-64ie1focnn5g78","-3igoecjbmca688","-27c48l5b37oaoq","-1bk39f3ah3dmq8","-q1se8f0m04isc","-hajppbc1fc208","-bm03i95hia438","-8000000000000","-5hg4ck9jd4u38","-3tdtk1v8j6tpq","-2pijmikexrxp8","-1y2p0ij32e8e8"];
goog.math.Long.fromInt=function(value){var intValue=value|0;goog.asserts.assert(value===intValue,"value should be a 32-bit integer");if(-128<=intValue&&intValue<128)return goog.math.Long.getCachedIntValue_(intValue);else return new goog.math.Long(intValue,intValue<0?-1:0)};
goog.math.Long.fromNumber=function(value){if(isNaN(value))return goog.math.Long.getZero();else if(value<=-goog.math.Long.TWO_PWR_63_DBL_)return goog.math.Long.getMinValue();else if(value+1>=goog.math.Long.TWO_PWR_63_DBL_)return goog.math.Long.getMaxValue();else if(value<0)return goog.math.Long.fromNumber(-value).negate();else return new goog.math.Long(value%goog.math.Long.TWO_PWR_32_DBL_|0,value/goog.math.Long.TWO_PWR_32_DBL_|0)};
goog.math.Long.fromBits=function(lowBits,highBits){return new goog.math.Long(lowBits,highBits)};
goog.math.Long.fromString=function(str,opt_radix){if(str.length==0)throw Error("number format error: empty string");var radix=opt_radix||10;if(radix<2||36<radix)throw Error("radix out of range: "+radix);if(str.charAt(0)=="-")return goog.math.Long.fromString(str.substring(1),radix).negate();else if(str.indexOf("-")>=0)throw Error('number format error: interior "-" character: '+str);var radixToPower=goog.math.Long.fromNumber(Math.pow(radix,8));var result=goog.math.Long.getZero();for(var i=0;i<str.length;i+=
8){var size=Math.min(8,str.length-i);var value=parseInt(str.substring(i,i+size),radix);if(size<8){var power=goog.math.Long.fromNumber(Math.pow(radix,size));result=result.multiply(power).add(goog.math.Long.fromNumber(value))}else{result=result.multiply(radixToPower);result=result.add(goog.math.Long.fromNumber(value))}}return result};
goog.math.Long.isStringInRange=function(str,opt_radix){var radix=opt_radix||10;if(radix<2||36<radix)throw Error("radix out of range: "+radix);var extremeValue=str.charAt(0)=="-"?goog.math.Long.MIN_VALUE_FOR_RADIX_[radix]:goog.math.Long.MAX_VALUE_FOR_RADIX_[radix];if(str.length<extremeValue.length)return true;else if(str.length==extremeValue.length&&str<=extremeValue)return true;else return false};goog.math.Long.TWO_PWR_16_DBL_=1<<16;goog.math.Long.TWO_PWR_32_DBL_=goog.math.Long.TWO_PWR_16_DBL_*goog.math.Long.TWO_PWR_16_DBL_;
goog.math.Long.TWO_PWR_64_DBL_=goog.math.Long.TWO_PWR_32_DBL_*goog.math.Long.TWO_PWR_32_DBL_;goog.math.Long.TWO_PWR_63_DBL_=goog.math.Long.TWO_PWR_64_DBL_/2;goog.math.Long.getZero=function(){return goog.math.Long.getCachedIntValue_(0)};goog.math.Long.getOne=function(){return goog.math.Long.getCachedIntValue_(1)};goog.math.Long.getNegOne=function(){return goog.math.Long.getCachedIntValue_(-1)};
goog.math.Long.getMaxValue=function(){return goog.reflect.cache(goog.math.Long.valueCache_,goog.math.Long.ValueCacheId_.MAX_VALUE,function(){return goog.math.Long.fromBits(4294967295|0,2147483647|0)})};goog.math.Long.getMinValue=function(){return goog.reflect.cache(goog.math.Long.valueCache_,goog.math.Long.ValueCacheId_.MIN_VALUE,function(){return goog.math.Long.fromBits(0,2147483648|0)})};
goog.math.Long.getTwoPwr24=function(){return goog.reflect.cache(goog.math.Long.valueCache_,goog.math.Long.ValueCacheId_.TWO_PWR_24,function(){return goog.math.Long.fromInt(1<<24)})};goog.math.Long.prototype.toInt=function(){return this.low_};goog.math.Long.prototype.toNumber=function(){return this.high_*goog.math.Long.TWO_PWR_32_DBL_+this.getLowBitsUnsigned()};
goog.math.Long.prototype.toString=function(opt_radix){var radix=opt_radix||10;if(radix<2||36<radix)throw Error("radix out of range: "+radix);if(this.isZero())return"0";if(this.isNegative())if(this.equals(goog.math.Long.getMinValue())){var radixLong=goog.math.Long.fromNumber(radix);var div=this.div(radixLong);var rem=div.multiply(radixLong).subtract(this);return div.toString(radix)+rem.toInt().toString(radix)}else return"-"+this.negate().toString(radix);var radixToPower=goog.math.Long.fromNumber(Math.pow(radix,
6));var rem=this;var result="";while(true){var remDiv=rem.div(radixToPower);var intval=rem.subtract(remDiv.multiply(radixToPower)).toInt()>>>0;var digits=intval.toString(radix);rem=remDiv;if(rem.isZero())return digits+result;else{while(digits.length<6)digits="0"+digits;result=""+digits+result}}};goog.math.Long.prototype.getHighBits=function(){return this.high_};goog.math.Long.prototype.getLowBits=function(){return this.low_};
goog.math.Long.prototype.getLowBitsUnsigned=function(){return this.low_>=0?this.low_:goog.math.Long.TWO_PWR_32_DBL_+this.low_};goog.math.Long.prototype.getNumBitsAbs=function(){if(this.isNegative())if(this.equals(goog.math.Long.getMinValue()))return 64;else return this.negate().getNumBitsAbs();else{var val=this.high_!=0?this.high_:this.low_;for(var bit=31;bit>0;bit--)if((val&1<<bit)!=0)break;return this.high_!=0?bit+33:bit+1}};
goog.math.Long.prototype.isZero=function(){return this.high_==0&&this.low_==0};goog.math.Long.prototype.isNegative=function(){return this.high_<0};goog.math.Long.prototype.isOdd=function(){return(this.low_&1)==1};goog.math.Long.prototype.equals=function(other){return this.high_==other.high_&&this.low_==other.low_};goog.math.Long.prototype.notEquals=function(other){return this.high_!=other.high_||this.low_!=other.low_};goog.math.Long.prototype.lessThan=function(other){return this.compare(other)<0};
goog.math.Long.prototype.lessThanOrEqual=function(other){return this.compare(other)<=0};goog.math.Long.prototype.greaterThan=function(other){return this.compare(other)>0};goog.math.Long.prototype.greaterThanOrEqual=function(other){return this.compare(other)>=0};
goog.math.Long.prototype.compare=function(other){if(this.equals(other))return 0;var thisNeg=this.isNegative();var otherNeg=other.isNegative();if(thisNeg&&!otherNeg)return-1;if(!thisNeg&&otherNeg)return 1;if(this.subtract(other).isNegative())return-1;else return 1};goog.math.Long.prototype.negate=function(){if(this.equals(goog.math.Long.getMinValue()))return goog.math.Long.getMinValue();else return this.not().add(goog.math.Long.getOne())};
goog.math.Long.prototype.add=function(other){var a48=this.high_>>>16;var a32=this.high_&65535;var a16=this.low_>>>16;var a00=this.low_&65535;var b48=other.high_>>>16;var b32=other.high_&65535;var b16=other.low_>>>16;var b00=other.low_&65535;var c48=0,c32=0,c16=0,c00=0;c00+=a00+b00;c16+=c00>>>16;c00&=65535;c16+=a16+b16;c32+=c16>>>16;c16&=65535;c32+=a32+b32;c48+=c32>>>16;c32&=65535;c48+=a48+b48;c48&=65535;return goog.math.Long.fromBits(c16<<16|c00,c48<<16|c32)};goog.math.Long.prototype.subtract=function(other){return this.add(other.negate())};
goog.math.Long.prototype.multiply=function(other){if(this.isZero())return goog.math.Long.getZero();else if(other.isZero())return goog.math.Long.getZero();if(this.equals(goog.math.Long.getMinValue()))return other.isOdd()?goog.math.Long.getMinValue():goog.math.Long.getZero();else if(other.equals(goog.math.Long.getMinValue()))return this.isOdd()?goog.math.Long.getMinValue():goog.math.Long.getZero();if(this.isNegative())if(other.isNegative())return this.negate().multiply(other.negate());else return this.negate().multiply(other).negate();
else if(other.isNegative())return this.multiply(other.negate()).negate();if(this.lessThan(goog.math.Long.getTwoPwr24())&&other.lessThan(goog.math.Long.getTwoPwr24()))return goog.math.Long.fromNumber(this.toNumber()*other.toNumber());var a48=this.high_>>>16;var a32=this.high_&65535;var a16=this.low_>>>16;var a00=this.low_&65535;var b48=other.high_>>>16;var b32=other.high_&65535;var b16=other.low_>>>16;var b00=other.low_&65535;var c48=0,c32=0,c16=0,c00=0;c00+=a00*b00;c16+=c00>>>16;c00&=65535;c16+=a16*
b00;c32+=c16>>>16;c16&=65535;c16+=a00*b16;c32+=c16>>>16;c16&=65535;c32+=a32*b00;c48+=c32>>>16;c32&=65535;c32+=a16*b16;c48+=c32>>>16;c32&=65535;c32+=a00*b32;c48+=c32>>>16;c32&=65535;c48+=a48*b00+a32*b16+a16*b32+a00*b48;c48&=65535;return goog.math.Long.fromBits(c16<<16|c00,c48<<16|c32)};
goog.math.Long.prototype.div=function(other){if(other.isZero())throw Error("division by zero");else if(this.isZero())return goog.math.Long.getZero();if(this.equals(goog.math.Long.getMinValue()))if(other.equals(goog.math.Long.getOne())||other.equals(goog.math.Long.getNegOne()))return goog.math.Long.getMinValue();else if(other.equals(goog.math.Long.getMinValue()))return goog.math.Long.getOne();else{var halfThis=this.shiftRight(1);var approx=halfThis.div(other).shiftLeft(1);if(approx.equals(goog.math.Long.getZero()))return other.isNegative()?
goog.math.Long.getOne():goog.math.Long.getNegOne();else{var rem=this.subtract(other.multiply(approx));var result=approx.add(rem.div(other));return result}}else if(other.equals(goog.math.Long.getMinValue()))return goog.math.Long.getZero();if(this.isNegative())if(other.isNegative())return this.negate().div(other.negate());else return this.negate().div(other).negate();else if(other.isNegative())return this.div(other.negate()).negate();var res=goog.math.Long.getZero();var rem=this;while(rem.greaterThanOrEqual(other)){var approx=
Math.max(1,Math.floor(rem.toNumber()/other.toNumber()));var log2=Math.ceil(Math.log(approx)/Math.LN2);var delta=log2<=48?1:Math.pow(2,log2-48);var approxRes=goog.math.Long.fromNumber(approx);var approxRem=approxRes.multiply(other);while(approxRem.isNegative()||approxRem.greaterThan(rem)){approx-=delta;approxRes=goog.math.Long.fromNumber(approx);approxRem=approxRes.multiply(other)}if(approxRes.isZero())approxRes=goog.math.Long.getOne();res=res.add(approxRes);rem=rem.subtract(approxRem)}return res};
goog.math.Long.prototype.modulo=function(other){return this.subtract(this.div(other).multiply(other))};goog.math.Long.prototype.not=function(){return goog.math.Long.fromBits(~this.low_,~this.high_)};goog.math.Long.prototype.and=function(other){return goog.math.Long.fromBits(this.low_&other.low_,this.high_&other.high_)};goog.math.Long.prototype.or=function(other){return goog.math.Long.fromBits(this.low_|other.low_,this.high_|other.high_)};
goog.math.Long.prototype.xor=function(other){return goog.math.Long.fromBits(this.low_^other.low_,this.high_^other.high_)};goog.math.Long.prototype.shiftLeft=function(numBits){numBits&=63;if(numBits==0)return this;else{var low=this.low_;if(numBits<32){var high=this.high_;return goog.math.Long.fromBits(low<<numBits,high<<numBits|low>>>32-numBits)}else return goog.math.Long.fromBits(0,low<<numBits-32)}};
goog.math.Long.prototype.shiftRight=function(numBits){numBits&=63;if(numBits==0)return this;else{var high=this.high_;if(numBits<32){var low=this.low_;return goog.math.Long.fromBits(low>>>numBits|high<<32-numBits,high>>numBits)}else return goog.math.Long.fromBits(high>>numBits-32,high>=0?0:-1)}};
goog.math.Long.prototype.shiftRightUnsigned=function(numBits){numBits&=63;if(numBits==0)return this;else{var high=this.high_;if(numBits<32){var low=this.low_;return goog.math.Long.fromBits(low>>>numBits|high<<32-numBits,high>>>numBits)}else if(numBits==32)return goog.math.Long.fromBits(high,0);else return goog.math.Long.fromBits(high>>>numBits-32,0)}};goog.math.Long.ValueCacheId_={MAX_VALUE:1,MIN_VALUE:2,TWO_PWR_24:6};goog.provide("cljs.core");goog.require("goog.math.Long");goog.require("goog.math.Integer");goog.require("goog.string");goog.require("goog.object");goog.require("goog.array");goog.require("goog.string.StringBuffer");cljs.core._STAR_clojurescript_version_STAR_="1.9.671";cljs.core._STAR_unchecked_if_STAR_=false;cljs.core._STAR_warn_on_infer_STAR_=false;if(typeof cljs.core.PROTOCOL_SENTINEL!=="undefined");else cljs.core.PROTOCOL_SENTINEL={};goog.define("cljs.core._STAR_target_STAR_","default");
cljs.core._STAR_ns_STAR_=null;cljs.core._STAR_out_STAR_=null;cljs.core._STAR_assert_STAR_=true;if(typeof cljs.core._STAR_print_fn_STAR_!=="undefined");else cljs.core._STAR_print_fn_STAR_=function cljs$core$_STAR_print_fn_STAR_(_){throw new Error("No *print-fn* fn set for evaluation environment");};
if(typeof cljs.core._STAR_print_err_fn_STAR_!=="undefined");else cljs.core._STAR_print_err_fn_STAR_=function cljs$core$_STAR_print_err_fn_STAR_(_){throw new Error("No *print-err-fn* fn set for evaluation environment");};cljs.core.set_print_fn_BANG_=function cljs$core$set_print_fn_BANG_(f){return cljs.core._STAR_print_fn_STAR_=f};cljs.core.set_print_err_fn_BANG_=function cljs$core$set_print_err_fn_BANG_(f){return cljs.core._STAR_print_err_fn_STAR_=f};cljs.core._STAR_flush_on_newline_STAR_=true;
cljs.core._STAR_print_newline_STAR_=true;cljs.core._STAR_print_readably_STAR_=true;cljs.core._STAR_print_meta_STAR_=false;cljs.core._STAR_print_dup_STAR_=false;cljs.core._STAR_print_namespace_maps_STAR_=false;cljs.core._STAR_print_length_STAR_=null;cljs.core._STAR_print_level_STAR_=null;if(typeof cljs.core._STAR_loaded_libs_STAR_!=="undefined");else cljs.core._STAR_loaded_libs_STAR_=null;
cljs.core.pr_opts=function cljs$core$pr_opts(){return new cljs.core.PersistentArrayMap(null,5,[new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,
"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_],null)};
cljs.core.enable_console_print_BANG_=function cljs$core$enable_console_print_BANG_(){cljs.core._STAR_print_newline_STAR_=false;cljs.core._STAR_print_fn_STAR_=function(){var G__9357__delegate=function(args){return console.log.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args))};var G__9357=function(var_args){var args=null;if(arguments.length>0){var G__9358__i=0,G__9358__a=new Array(arguments.length-0);while(G__9358__i<G__9358__a.length){G__9358__a[G__9358__i]=arguments[G__9358__i+
0];++G__9358__i}args=new cljs.core.IndexedSeq(G__9358__a,0,null)}return G__9357__delegate.call(this,args)};G__9357.cljs$lang$maxFixedArity=0;G__9357.cljs$lang$applyTo=function(arglist__9359){var args=cljs.core.seq(arglist__9359);return G__9357__delegate(args)};G__9357.cljs$core$IFn$_invoke$arity$variadic=G__9357__delegate;return G__9357}();cljs.core._STAR_print_err_fn_STAR_=function(){var G__9360__delegate=function(args){return console.error.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args))};
var G__9360=function(var_args){var args=null;if(arguments.length>0){var G__9361__i=0,G__9361__a=new Array(arguments.length-0);while(G__9361__i<G__9361__a.length){G__9361__a[G__9361__i]=arguments[G__9361__i+0];++G__9361__i}args=new cljs.core.IndexedSeq(G__9361__a,0,null)}return G__9360__delegate.call(this,args)};G__9360.cljs$lang$maxFixedArity=0;G__9360.cljs$lang$applyTo=function(arglist__9362){var args=cljs.core.seq(arglist__9362);return G__9360__delegate(args)};G__9360.cljs$core$IFn$_invoke$arity$variadic=
G__9360__delegate;return G__9360}();return null};cljs.core.truth_=function cljs$core$truth_(x){return x!=null&&x!==false};cljs.core.not_native=null;cljs.core.identical_QMARK_=function cljs$core$identical_QMARK_(x,y){return x===y};cljs.core.nil_QMARK_=function cljs$core$nil_QMARK_(x){return x==null};cljs.core.array_QMARK_=function cljs$core$array_QMARK_(x){if(cljs.core._STAR_target_STAR_==="nodejs")return Array.isArray(x);else return x instanceof Array};
cljs.core.number_QMARK_=function cljs$core$number_QMARK_(x){return typeof x==="number"};cljs.core.not=function cljs$core$not(x){if(x==null)return true;else if(x===false)return true;else return false};cljs.core.some_QMARK_=function cljs$core$some_QMARK_(x){return!(x==null)};cljs.core.object_QMARK_=function cljs$core$object_QMARK_(x){if(!(x==null))return x.constructor===Object;else return false};cljs.core.string_QMARK_=function cljs$core$string_QMARK_(x){return goog.isString(x)};
cljs.core.char_QMARK_=function cljs$core$char_QMARK_(x){return typeof x==="string"&&1===x.length};cljs.core.any_QMARK_=function cljs$core$any_QMARK_(x){return true};cljs.core.native_satisfies_QMARK_=function cljs$core$native_satisfies_QMARK_(p,x){var x__$1=x==null?null:x;if(p[goog.typeOf(x__$1)])return true;else if(p["_"])return true;else return false};cljs.core.is_proto_=function cljs$core$is_proto_(x){return x.constructor.prototype===x};cljs.core._STAR_main_cli_fn_STAR_=null;
cljs.core.type=function cljs$core$type(x){if(x==null)return null;else return x.constructor};cljs.core.missing_protocol=function cljs$core$missing_protocol(proto,obj){var ty=cljs.core.type(obj);var ty__$1=cljs.core.truth_(function(){var and__7273__auto__=ty;if(cljs.core.truth_(and__7273__auto__))return ty.cljs$lang$type;else return and__7273__auto__}())?ty.cljs$lang$ctorStr:goog.typeOf(obj);return new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join(""))};
cljs.core.type__GT_str=function cljs$core$type__GT_str(ty){var temp__4655__auto__=ty.cljs$lang$ctorStr;if(cljs.core.truth_(temp__4655__auto__)){var s=temp__4655__auto__;return s}else return[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ty)].join("")};cljs.core.load_file=function cljs$core$load_file(file){if(cljs.core.truth_(COMPILED))return null;else return goog.nodeGlobalRequire(file)};
if(typeof Symbol!=="undefined"&&goog.typeOf(Symbol)==="function")cljs.core.ITER_SYMBOL=Symbol.iterator;else cljs.core.ITER_SYMBOL="@@iterator";
cljs.core.CHAR_MAP={"]":"_RBRACK_","'":"_SINGLEQUOTE_","\x3d":"_EQ_",'"':"_DOUBLEQUOTE_","!":"_BANG_","*":"_STAR_","%":"_PERCENT_","|":"_BAR_","~":"_TILDE_","/":"_SLASH_","\\":"_BSLASH_","-":"_","?":"_QMARK_","\x26":"_AMPERSAND_",":":"_COLON_","\x3c":"_LT_","{":"_LBRACE_","}":"_RBRACE_","[":"_LBRACK_","#":"_SHARP_","^":"_CARET_","+":"_PLUS_","@":"_CIRCA_","\x3e":"_GT_"};
cljs.core.DEMUNGE_MAP={"_RBRACE_":"}","_COLON_":":","_BANG_":"!","_QMARK_":"?","_BSLASH_":"\\\\","_SLASH_":"/","_PERCENT_":"%","_PLUS_":"+","_SHARP_":"#","_LBRACE_":"{","_BAR_":"|","_LBRACK_":"[","_EQ_":"\x3d","_":"-","_TILDE_":"~","_RBRACK_":"]","_GT_":"\x3e","_SINGLEQUOTE_":"'","_CIRCA_":"@","_AMPERSAND_":"\x26","_DOUBLEQUOTE_":'\\"',"_CARET_":"^","_LT_":"\x3c","_STAR_":"*"};cljs.core.DEMUNGE_PATTERN=null;
cljs.core.system_time=function cljs$core$system_time(){if(typeof performance!=="undefined"&&!(performance.now==null))return performance.now();else if(typeof process!=="undefined"&&!(process.hrtime==null)){var t=process.hrtime();return(t[0]*1E9+t[1])/1E6}else return(new Date).getTime()};
cljs.core.make_array=function cljs$core$make_array(var_args){var G__9367=arguments.length;switch(G__9367){case 1:return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9369=arguments.length;var i__8411__auto___9370=0;while(true){if(i__8411__auto___9370<len__8410__auto___9369){args_arr__8429__auto__.push(arguments[i__8411__auto___9370]);
var G__9371=i__8411__auto___9370+1;i__8411__auto___9370=G__9371;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.make_array.cljs$core$IFn$_invoke$arity$1=function(size){return new Array(size)};cljs.core.make_array.cljs$core$IFn$_invoke$arity$2=function(type,size){return new Array(size)};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic=function(type,size,more_sizes){var dims=more_sizes;var dimarray=new Array(size);var n__8209__auto___9372=dimarray.length;var i_9373=0;while(true){if(i_9373<n__8209__auto___9372){dimarray[i_9373]=cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array,null,dims);var G__9374=i_9373+1;i_9373=G__9374;continue}else;break}return dimarray};
cljs.core.make_array.cljs$lang$applyTo=function(seq9364){var G__9365=cljs.core.first(seq9364);var seq9364__$1=cljs.core.next(seq9364);var G__9366=cljs.core.first(seq9364__$1);var seq9364__$2=cljs.core.next(seq9364__$1);return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic(G__9365,G__9366,seq9364__$2)};cljs.core.make_array.cljs$lang$maxFixedArity=2;
cljs.core.aclone=function cljs$core$aclone(arr){var len=arr.length;var new_arr=new Array(len);var n__8209__auto___9375=len;var i_9376=0;while(true){if(i_9376<n__8209__auto___9375){new_arr[i_9376]=arr[i_9376];var G__9377=i_9376+1;i_9376=G__9377;continue}else;break}return new_arr};cljs.core.array=function cljs$core$array(var_args){var a=new Array(arguments.length);var i=0;while(true){if(i<a.length){a[i]=arguments[i];var G__9378=i+1;i=G__9378;continue}else return a;break}};
cljs.core.aget=function cljs$core$aget(var_args){var G__9383=arguments.length;switch(G__9383){case 2:return cljs.core.aget.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9385=arguments.length;var i__8411__auto___9386=0;while(true){if(i__8411__auto___9386<len__8410__auto___9385){args_arr__8429__auto__.push(arguments[i__8411__auto___9386]);var G__9387=i__8411__auto___9386+1;i__8411__auto___9386=G__9387;continue}else;break}var argseq__8430__auto__=
new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.aget.cljs$core$IFn$_invoke$arity$2=function(array,i){return array[i]};cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic=function(array,i,idxs){return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.aget,array[i],idxs)};
cljs.core.aget.cljs$lang$applyTo=function(seq9380){var G__9381=cljs.core.first(seq9380);var seq9380__$1=cljs.core.next(seq9380);var G__9382=cljs.core.first(seq9380__$1);var seq9380__$2=cljs.core.next(seq9380__$1);return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(G__9381,G__9382,seq9380__$2)};cljs.core.aget.cljs$lang$maxFixedArity=2;
cljs.core.aset=function cljs$core$aset(var_args){var G__9393=arguments.length;switch(G__9393){case 3:return cljs.core.aset.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9395=arguments.length;var i__8411__auto___9396=0;while(true){if(i__8411__auto___9396<len__8410__auto___9395){args_arr__8429__auto__.push(arguments[i__8411__auto___9396]);var G__9397=i__8411__auto___9396+1;i__8411__auto___9396=G__9397;continue}else;
break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(3),0,null);return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],arguments[2],argseq__8430__auto__)}};cljs.core.aset.cljs$core$IFn$_invoke$arity$3=function(array,i,val){return array[i]=val};cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic=function(array,idx,idx2,idxv){return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.aset,array[idx],idx2,idxv)};
cljs.core.aset.cljs$lang$applyTo=function(seq9389){var G__9390=cljs.core.first(seq9389);var seq9389__$1=cljs.core.next(seq9389);var G__9391=cljs.core.first(seq9389__$1);var seq9389__$2=cljs.core.next(seq9389__$1);var G__9392=cljs.core.first(seq9389__$2);var seq9389__$3=cljs.core.next(seq9389__$2);return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(G__9390,G__9391,G__9392,seq9389__$3)};cljs.core.aset.cljs$lang$maxFixedArity=3;cljs.core.alength=function cljs$core$alength(array){return array.length};
cljs.core.into_array=function cljs$core$into_array(var_args){var G__9399=arguments.length;switch(G__9399){case 1:return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$1=function(aseq){return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq)};cljs.core.into_array.cljs$core$IFn$_invoke$arity$2=function(type,aseq){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(a,x){a.push(x);return a},[],aseq)};cljs.core.into_array.cljs$lang$maxFixedArity=2;
cljs.core.js_invoke=function cljs$core$js_invoke(var_args){var args__8417__auto__=[];var len__8410__auto___9404=arguments.length;var i__8411__auto___9405=0;while(true){if(i__8411__auto___9405<len__8410__auto___9404){args__8417__auto__.push(arguments[i__8411__auto___9405]);var G__9406=i__8411__auto___9405+1;i__8411__auto___9405=G__9406;continue}else;break}var argseq__8418__auto__=2<args__8417__auto__.length?new cljs.core.IndexedSeq(args__8417__auto__.slice(2),0,null):null;return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(arguments[0],
arguments[1],argseq__8418__auto__)};cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic=function(obj,s,args){return obj[s].apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args))};cljs.core.js_invoke.cljs$lang$maxFixedArity=2;
cljs.core.js_invoke.cljs$lang$applyTo=function(seq9401){var G__9402=cljs.core.first(seq9401);var seq9401__$1=cljs.core.next(seq9401);var G__9403=cljs.core.first(seq9401__$1);var seq9401__$2=cljs.core.next(seq9401__$1);return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(G__9402,G__9403,seq9401__$2)};cljs.core.Fn=function(){};cljs.core.IFn=function(){};
cljs.core._invoke=function cljs$core$_invoke(var_args){var G__9408=arguments.length;switch(G__9408){case 1:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;
case 5:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4]);break;case 6:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5]);break;case 7:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6]);break;case 8:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8(arguments[0],
arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],arguments[7]);break;case 9:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],arguments[7],arguments[8]);break;case 10:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],arguments[7],arguments[8],arguments[9]);break;case 11:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11(arguments[0],
arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],arguments[7],arguments[8],arguments[9],arguments[10]);break;case 12:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],arguments[7],arguments[8],arguments[9],arguments[10],arguments[11]);break;case 13:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],
arguments[6],arguments[7],arguments[8],arguments[9],arguments[10],arguments[11],arguments[12]);break;case 14:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],arguments[7],arguments[8],arguments[9],arguments[10],arguments[11],arguments[12],arguments[13]);break;case 15:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],
arguments[7],arguments[8],arguments[9],arguments[10],arguments[11],arguments[12],arguments[13],arguments[14]);break;case 16:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],arguments[7],arguments[8],arguments[9],arguments[10],arguments[11],arguments[12],arguments[13],arguments[14],arguments[15]);break;case 17:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17(arguments[0],arguments[1],arguments[2],
arguments[3],arguments[4],arguments[5],arguments[6],arguments[7],arguments[8],arguments[9],arguments[10],arguments[11],arguments[12],arguments[13],arguments[14],arguments[15],arguments[16]);break;case 18:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],arguments[7],arguments[8],arguments[9],arguments[10],arguments[11],arguments[12],arguments[13],arguments[14],arguments[15],arguments[16],arguments[17]);
break;case 19:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],arguments[7],arguments[8],arguments[9],arguments[10],arguments[11],arguments[12],arguments[13],arguments[14],arguments[15],arguments[16],arguments[17],arguments[18]);break;case 20:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],arguments[7],
arguments[8],arguments[9],arguments[10],arguments[11],arguments[12],arguments[13],arguments[14],arguments[15],arguments[16],arguments[17],arguments[18],arguments[19]);break;case 21:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],arguments[7],arguments[8],arguments[9],arguments[10],arguments[11],arguments[12],arguments[13],arguments[14],arguments[15],arguments[16],arguments[17],arguments[18],arguments[19],
arguments[20]);break;case 22:return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],arguments[7],arguments[8],arguments[9],arguments[10],arguments[11],arguments[12],arguments[13],arguments[14],arguments[15],arguments[16],arguments[17],arguments[18],arguments[19],arguments[20],arguments[21]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$1=function(this$){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$1==null))return this$.cljs$core$IFn$_invoke$arity$1(this$);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(this$):m__7955__auto__.call(null,this$);else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==
null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(this$):m__7955__auto____$1.call(null,this$);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$2=function(this$,a){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$2==null))return this$.cljs$core$IFn$_invoke$arity$2(this$,a);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(this$,a):m__7955__auto__.call(null,this$,a);else{var m__7955__auto____$1=cljs.core._invoke["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,a):m__7955__auto____$1.call(null,this$,a);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$3=function(this$,a,b){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$3==null))return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$3?m__7955__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b):m__7955__auto__.call(null,this$,a,b);else{var m__7955__auto____$1=
cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,a,b):m__7955__auto____$1.call(null,this$,a,b);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$4=function(this$,a,b,c){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$4==null))return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$4?m__7955__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c):m__7955__auto__.call(null,this$,a,b,c);else{var m__7955__auto____$1=
cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$4?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$4(this$,a,b,c):m__7955__auto____$1.call(null,this$,a,b,c);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$5=function(this$,a,b,c,d){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$5==null))return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$5?m__7955__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d):m__7955__auto__.call(null,this$,a,b,c,d);else{var m__7955__auto____$1=
cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$5?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d):m__7955__auto____$1.call(null,this$,a,b,c,d);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$6=function(this$,a,b,c,d,e){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$6==null))return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$6?m__7955__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e):m__7955__auto__.call(null,this$,a,b,c,d,e);
else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$6?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e):m__7955__auto____$1.call(null,this$,a,b,c,d,e);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$7=function(this$,a,b,c,d,e,f){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$7==null))return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$7?m__7955__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f):m__7955__auto__.call(null,this$,a,b,c,
d,e,f);else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$7?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f):m__7955__auto____$1.call(null,this$,a,b,c,d,e,f);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$8=function(this$,a,b,c,d,e,f,g){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$8==null))return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$8?m__7955__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g):m__7955__auto__.call(null,this$,
a,b,c,d,e,f,g);else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$8?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g):m__7955__auto____$1.call(null,this$,a,b,c,d,e,f,g);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$9=function(this$,a,b,c,d,e,f,g,h){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$9==null))return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$9?m__7955__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h):m__7955__auto__.call(null,
this$,a,b,c,d,e,f,g,h);else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$9?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h):m__7955__auto____$1.call(null,this$,a,b,c,d,e,f,g,h);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$10=function(this$,a,b,c,d,e,f,g,h,i){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$10==null))return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$10?m__7955__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i):m__7955__auto__.call(null,
this$,a,b,c,d,e,f,g,h,i);else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$10?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i):m__7955__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$11=function(this$,a,b,c,d,e,f,g,h,i,j){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$11==null))return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$11?m__7955__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j):m__7955__auto__.call(null,
this$,a,b,c,d,e,f,g,h,i,j);else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$11?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j):m__7955__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$12=function(this$,a,b,c,d,e,f,g,h,i,j,k){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$12==null))return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$12?m__7955__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k):m__7955__auto__.call(null,
this$,a,b,c,d,e,f,g,h,i,j,k);else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$12?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k):m__7955__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$13=function(this$,a,b,c,d,e,f,g,h,i,j,k,l){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$13==null))return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$13?m__7955__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,
l):m__7955__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$13?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l):m__7955__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$14=function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$14==null))return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$14?m__7955__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,
j,k,l,m):m__7955__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$14?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m):m__7955__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$15=function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$15==null))return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$15?m__7955__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,
h,i,j,k,l,m,n):m__7955__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$15?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n):m__7955__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$16=function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$16==null))return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$16?m__7955__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,
f,g,h,i,j,k,l,m,n,o):m__7955__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$16?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o):m__7955__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$17=function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$17==null))return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$17?m__7955__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,
d,e,f,g,h,i,j,k,l,m,n,o,p):m__7955__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$17?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p):m__7955__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$18=function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$18==null))return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$18?m__7955__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,
b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q):m__7955__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$18?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q):m__7955__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$19=function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$19==null))return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$19?m__7955__auto__.cljs$core$IFn$_invoke$arity$19(this$,
a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r):m__7955__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$19?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r):m__7955__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$20=function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$20==null))return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$20?m__7955__auto__.cljs$core$IFn$_invoke$arity$20(this$,
a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s):m__7955__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$20?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s):m__7955__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$21=function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$21==null))return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$21?m__7955__auto__.cljs$core$IFn$_invoke$arity$21(this$,
a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t):m__7955__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$21?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t):m__7955__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);else throw cljs.core.missing_protocol("IFn.-invoke",this$);}}};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$22=function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){if(!(this$==null)&&!(this$.cljs$core$IFn$_invoke$arity$22==null))return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._invoke[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$22?m__7955__auto__.cljs$core$IFn$_invoke$arity$22(this$,
a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest):m__7955__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);else{var m__7955__auto____$1=cljs.core._invoke["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$22?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest):m__7955__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);else throw cljs.core.missing_protocol("IFn.-invoke",
this$);}}};cljs.core._invoke.cljs$lang$maxFixedArity=22;cljs.core.ICloneable=function(){};
cljs.core._clone=function cljs$core$_clone(value){if(!(value==null)&&!(value.cljs$core$ICloneable$_clone$arity$1==null))return value.cljs$core$ICloneable$_clone$arity$1(value);else{var x__7954__auto__=value==null?null:value;var m__7955__auto__=cljs.core._clone[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(value):m__7955__auto__.call(null,value);else{var m__7955__auto____$1=cljs.core._clone["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(value):m__7955__auto____$1.call(null,value);else throw cljs.core.missing_protocol("ICloneable.-clone",value);}}};cljs.core.ICounted=function(){};
cljs.core._count=function cljs$core$_count(coll){if(!(coll==null)&&!(coll.cljs$core$ICounted$_count$arity$1==null))return coll.cljs$core$ICounted$_count$arity$1(coll);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._count[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto__.call(null,coll);else{var m__7955__auto____$1=cljs.core._count["_"];if(!(m__7955__auto____$1==
null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto____$1.call(null,coll);else throw cljs.core.missing_protocol("ICounted.-count",coll);}}};cljs.core.IEmptyableCollection=function(){};
cljs.core._empty=function cljs$core$_empty(coll){if(!(coll==null)&&!(coll.cljs$core$IEmptyableCollection$_empty$arity$1==null))return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._empty[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto__.call(null,coll);else{var m__7955__auto____$1=cljs.core._empty["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto____$1.call(null,coll);else throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);}}};cljs.core.ICollection=function(){};
cljs.core._conj=function cljs$core$_conj(coll,o){if(!(coll==null)&&!(coll.cljs$core$ICollection$_conj$arity$2==null))return coll.cljs$core$ICollection$_conj$arity$2(coll,o);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._conj[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(coll,o):m__7955__auto__.call(null,coll,o);else{var m__7955__auto____$1=cljs.core._conj["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,o):m__7955__auto____$1.call(null,coll,o);else throw cljs.core.missing_protocol("ICollection.-conj",coll);}}};cljs.core.IIndexed=function(){};
cljs.core._nth=function cljs$core$_nth(var_args){var G__9411=arguments.length;switch(G__9411){case 2:return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core._nth.cljs$core$IFn$_invoke$arity$2=function(coll,n){if(!(coll==null)&&!(coll.cljs$core$IIndexed$_nth$arity$2==null))return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._nth[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(coll,n):m__7955__auto__.call(null,coll,n);else{var m__7955__auto____$1=cljs.core._nth["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,n):m__7955__auto____$1.call(null,coll,n);else throw cljs.core.missing_protocol("IIndexed.-nth",coll);}}};
cljs.core._nth.cljs$core$IFn$_invoke$arity$3=function(coll,n,not_found){if(!(coll==null)&&!(coll.cljs$core$IIndexed$_nth$arity$3==null))return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._nth[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$3?m__7955__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found):m__7955__auto__.call(null,coll,n,not_found);else{var m__7955__auto____$1=
cljs.core._nth["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,n,not_found):m__7955__auto____$1.call(null,coll,n,not_found);else throw cljs.core.missing_protocol("IIndexed.-nth",coll);}}};cljs.core._nth.cljs$lang$maxFixedArity=3;cljs.core.ASeq=function(){};cljs.core.ISeq=function(){};
cljs.core._first=function cljs$core$_first(coll){if(!(coll==null)&&!(coll.cljs$core$ISeq$_first$arity$1==null))return coll.cljs$core$ISeq$_first$arity$1(coll);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._first[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto__.call(null,coll);else{var m__7955__auto____$1=cljs.core._first["_"];if(!(m__7955__auto____$1==
null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto____$1.call(null,coll);else throw cljs.core.missing_protocol("ISeq.-first",coll);}}};
cljs.core._rest=function cljs$core$_rest(coll){if(!(coll==null)&&!(coll.cljs$core$ISeq$_rest$arity$1==null))return coll.cljs$core$ISeq$_rest$arity$1(coll);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._rest[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto__.call(null,coll);else{var m__7955__auto____$1=cljs.core._rest["_"];if(!(m__7955__auto____$1==
null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto____$1.call(null,coll);else throw cljs.core.missing_protocol("ISeq.-rest",coll);}}};cljs.core.INext=function(){};
cljs.core._next=function cljs$core$_next(coll){if(!(coll==null)&&!(coll.cljs$core$INext$_next$arity$1==null))return coll.cljs$core$INext$_next$arity$1(coll);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._next[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto__.call(null,coll);else{var m__7955__auto____$1=cljs.core._next["_"];if(!(m__7955__auto____$1==
null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto____$1.call(null,coll);else throw cljs.core.missing_protocol("INext.-next",coll);}}};cljs.core.ILookup=function(){};
cljs.core._lookup=function cljs$core$_lookup(var_args){var G__9414=arguments.length;switch(G__9414){case 2:return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$2=function(o,k){if(!(o==null)&&!(o.cljs$core$ILookup$_lookup$arity$2==null))return o.cljs$core$ILookup$_lookup$arity$2(o,k);else{var x__7954__auto__=o==null?null:o;var m__7955__auto__=cljs.core._lookup[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(o,k):m__7955__auto__.call(null,o,k);else{var m__7955__auto____$1=cljs.core._lookup["_"];if(!(m__7955__auto____$1==
null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(o,k):m__7955__auto____$1.call(null,o,k);else throw cljs.core.missing_protocol("ILookup.-lookup",o);}}};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$3=function(o,k,not_found){if(!(o==null)&&!(o.cljs$core$ILookup$_lookup$arity$3==null))return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);else{var x__7954__auto__=o==null?null:o;var m__7955__auto__=cljs.core._lookup[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$3?m__7955__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found):m__7955__auto__.call(null,o,k,not_found);else{var m__7955__auto____$1=
cljs.core._lookup["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3(o,k,not_found):m__7955__auto____$1.call(null,o,k,not_found);else throw cljs.core.missing_protocol("ILookup.-lookup",o);}}};cljs.core._lookup.cljs$lang$maxFixedArity=3;cljs.core.IAssociative=function(){};
cljs.core._contains_key_QMARK_=function cljs$core$_contains_key_QMARK_(coll,k){if(!(coll==null)&&!(coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2==null))return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._contains_key_QMARK_[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(coll,k):m__7955__auto__.call(null,
coll,k);else{var m__7955__auto____$1=cljs.core._contains_key_QMARK_["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,k):m__7955__auto____$1.call(null,coll,k);else throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);}}};
cljs.core._assoc=function cljs$core$_assoc(coll,k,v){if(!(coll==null)&&!(coll.cljs$core$IAssociative$_assoc$arity$3==null))return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._assoc[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$3?m__7955__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v):m__7955__auto__.call(null,coll,k,v);else{var m__7955__auto____$1=cljs.core._assoc["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,k,v):m__7955__auto____$1.call(null,coll,k,v);else throw cljs.core.missing_protocol("IAssociative.-assoc",coll);}}};cljs.core.IFind=function(){};
cljs.core._find=function cljs$core$_find(coll,k){if(!(coll==null)&&!(coll.cljs$core$IFind$_find$arity$2==null))return coll.cljs$core$IFind$_find$arity$2(coll,k);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._find[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(coll,k):m__7955__auto__.call(null,coll,k);else{var m__7955__auto____$1=cljs.core._find["_"];if(!(m__7955__auto____$1==
null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,k):m__7955__auto____$1.call(null,coll,k);else throw cljs.core.missing_protocol("IFind.-find",coll);}}};cljs.core.IMap=function(){};
cljs.core._dissoc=function cljs$core$_dissoc(coll,k){if(!(coll==null)&&!(coll.cljs$core$IMap$_dissoc$arity$2==null))return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._dissoc[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(coll,k):m__7955__auto__.call(null,coll,k);else{var m__7955__auto____$1=cljs.core._dissoc["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,k):m__7955__auto____$1.call(null,coll,k);else throw cljs.core.missing_protocol("IMap.-dissoc",coll);}}};cljs.core.IMapEntry=function(){};
cljs.core._key=function cljs$core$_key(coll){if(!(coll==null)&&!(coll.cljs$core$IMapEntry$_key$arity$1==null))return coll.cljs$core$IMapEntry$_key$arity$1(coll);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._key[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto__.call(null,coll);else{var m__7955__auto____$1=cljs.core._key["_"];if(!(m__7955__auto____$1==
null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto____$1.call(null,coll);else throw cljs.core.missing_protocol("IMapEntry.-key",coll);}}};
cljs.core._val=function cljs$core$_val(coll){if(!(coll==null)&&!(coll.cljs$core$IMapEntry$_val$arity$1==null))return coll.cljs$core$IMapEntry$_val$arity$1(coll);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._val[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto__.call(null,coll);else{var m__7955__auto____$1=cljs.core._val["_"];if(!(m__7955__auto____$1==
null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto____$1.call(null,coll);else throw cljs.core.missing_protocol("IMapEntry.-val",coll);}}};cljs.core.ISet=function(){};
cljs.core._disjoin=function cljs$core$_disjoin(coll,v){if(!(coll==null)&&!(coll.cljs$core$ISet$_disjoin$arity$2==null))return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._disjoin[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(coll,v):m__7955__auto__.call(null,coll,v);else{var m__7955__auto____$1=cljs.core._disjoin["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,v):m__7955__auto____$1.call(null,coll,v);else throw cljs.core.missing_protocol("ISet.-disjoin",coll);}}};cljs.core.IStack=function(){};
cljs.core._peek=function cljs$core$_peek(coll){if(!(coll==null)&&!(coll.cljs$core$IStack$_peek$arity$1==null))return coll.cljs$core$IStack$_peek$arity$1(coll);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._peek[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto__.call(null,coll);else{var m__7955__auto____$1=cljs.core._peek["_"];if(!(m__7955__auto____$1==
null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto____$1.call(null,coll);else throw cljs.core.missing_protocol("IStack.-peek",coll);}}};
cljs.core._pop=function cljs$core$_pop(coll){if(!(coll==null)&&!(coll.cljs$core$IStack$_pop$arity$1==null))return coll.cljs$core$IStack$_pop$arity$1(coll);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._pop[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto__.call(null,coll);else{var m__7955__auto____$1=cljs.core._pop["_"];if(!(m__7955__auto____$1==
null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto____$1.call(null,coll);else throw cljs.core.missing_protocol("IStack.-pop",coll);}}};cljs.core.IVector=function(){};
cljs.core._assoc_n=function cljs$core$_assoc_n(coll,n,val){if(!(coll==null)&&!(coll.cljs$core$IVector$_assoc_n$arity$3==null))return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._assoc_n[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$3?m__7955__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val):m__7955__auto__.call(null,coll,n,val);else{var m__7955__auto____$1=
cljs.core._assoc_n["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,n,val):m__7955__auto____$1.call(null,coll,n,val);else throw cljs.core.missing_protocol("IVector.-assoc-n",coll);}}};cljs.core.IDeref=function(){};
cljs.core._deref=function cljs$core$_deref(o){if(!(o==null)&&!(o.cljs$core$IDeref$_deref$arity$1==null))return o.cljs$core$IDeref$_deref$arity$1(o);else{var x__7954__auto__=o==null?null:o;var m__7955__auto__=cljs.core._deref[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(o):m__7955__auto__.call(null,o);else{var m__7955__auto____$1=cljs.core._deref["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?
m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(o):m__7955__auto____$1.call(null,o);else throw cljs.core.missing_protocol("IDeref.-deref",o);}}};cljs.core.IDerefWithTimeout=function(){};
cljs.core._deref_with_timeout=function cljs$core$_deref_with_timeout(o,msec,timeout_val){if(!(o==null)&&!(o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3==null))return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);else{var x__7954__auto__=o==null?null:o;var m__7955__auto__=cljs.core._deref_with_timeout[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$3?m__7955__auto__.cljs$core$IFn$_invoke$arity$3(o,
msec,timeout_val):m__7955__auto__.call(null,o,msec,timeout_val);else{var m__7955__auto____$1=cljs.core._deref_with_timeout["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val):m__7955__auto____$1.call(null,o,msec,timeout_val);else throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);}}};cljs.core.IMeta=function(){};
cljs.core._meta=function cljs$core$_meta(o){if(!(o==null)&&!(o.cljs$core$IMeta$_meta$arity$1==null))return o.cljs$core$IMeta$_meta$arity$1(o);else{var x__7954__auto__=o==null?null:o;var m__7955__auto__=cljs.core._meta[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(o):m__7955__auto__.call(null,o);else{var m__7955__auto____$1=cljs.core._meta["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?
m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(o):m__7955__auto____$1.call(null,o);else throw cljs.core.missing_protocol("IMeta.-meta",o);}}};cljs.core.IWithMeta=function(){};
cljs.core._with_meta=function cljs$core$_with_meta(o,meta){if(!(o==null)&&!(o.cljs$core$IWithMeta$_with_meta$arity$2==null))return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);else{var x__7954__auto__=o==null?null:o;var m__7955__auto__=cljs.core._with_meta[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(o,meta):m__7955__auto__.call(null,o,meta);else{var m__7955__auto____$1=cljs.core._with_meta["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(o,meta):m__7955__auto____$1.call(null,o,meta);else throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);}}};cljs.core.IReduce=function(){};
cljs.core._reduce=function cljs$core$_reduce(var_args){var G__9417=arguments.length;switch(G__9417){case 2:return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$2=function(coll,f){if(!(coll==null)&&!(coll.cljs$core$IReduce$_reduce$arity$2==null))return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._reduce[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(coll,f):m__7955__auto__.call(null,coll,f);else{var m__7955__auto____$1=cljs.core._reduce["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,f):m__7955__auto____$1.call(null,coll,f);else throw cljs.core.missing_protocol("IReduce.-reduce",coll);}}};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$3=function(coll,f,start){if(!(coll==null)&&!(coll.cljs$core$IReduce$_reduce$arity$3==null))return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._reduce[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$3?m__7955__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start):m__7955__auto__.call(null,coll,f,start);else{var m__7955__auto____$1=
cljs.core._reduce["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,f,start):m__7955__auto____$1.call(null,coll,f,start);else throw cljs.core.missing_protocol("IReduce.-reduce",coll);}}};cljs.core._reduce.cljs$lang$maxFixedArity=3;cljs.core.IKVReduce=function(){};
cljs.core._kv_reduce=function cljs$core$_kv_reduce(coll,f,init){if(!(coll==null)&&!(coll.cljs$core$IKVReduce$_kv_reduce$arity$3==null))return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._kv_reduce[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$3?m__7955__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init):m__7955__auto__.call(null,coll,f,init);else{var m__7955__auto____$1=
cljs.core._kv_reduce["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,f,init):m__7955__auto____$1.call(null,coll,f,init);else throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);}}};cljs.core.IEquiv=function(){};
cljs.core._equiv=function cljs$core$_equiv(o,other){if(!(o==null)&&!(o.cljs$core$IEquiv$_equiv$arity$2==null))return o.cljs$core$IEquiv$_equiv$arity$2(o,other);else{var x__7954__auto__=o==null?null:o;var m__7955__auto__=cljs.core._equiv[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(o,other):m__7955__auto__.call(null,o,other);else{var m__7955__auto____$1=cljs.core._equiv["_"];if(!(m__7955__auto____$1==
null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(o,other):m__7955__auto____$1.call(null,o,other);else throw cljs.core.missing_protocol("IEquiv.-equiv",o);}}};cljs.core.IHash=function(){};
cljs.core._hash=function cljs$core$_hash(o){if(!(o==null)&&!(o.cljs$core$IHash$_hash$arity$1==null))return o.cljs$core$IHash$_hash$arity$1(o);else{var x__7954__auto__=o==null?null:o;var m__7955__auto__=cljs.core._hash[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(o):m__7955__auto__.call(null,o);else{var m__7955__auto____$1=cljs.core._hash["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?
m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(o):m__7955__auto____$1.call(null,o);else throw cljs.core.missing_protocol("IHash.-hash",o);}}};cljs.core.ISeqable=function(){};
cljs.core._seq=function cljs$core$_seq(o){if(!(o==null)&&!(o.cljs$core$ISeqable$_seq$arity$1==null))return o.cljs$core$ISeqable$_seq$arity$1(o);else{var x__7954__auto__=o==null?null:o;var m__7955__auto__=cljs.core._seq[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(o):m__7955__auto__.call(null,o);else{var m__7955__auto____$1=cljs.core._seq["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?
m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(o):m__7955__auto____$1.call(null,o);else throw cljs.core.missing_protocol("ISeqable.-seq",o);}}};cljs.core.ISequential=function(){};cljs.core.IList=function(){};cljs.core.IRecord=function(){};cljs.core.IReversible=function(){};
cljs.core._rseq=function cljs$core$_rseq(coll){if(!(coll==null)&&!(coll.cljs$core$IReversible$_rseq$arity$1==null))return coll.cljs$core$IReversible$_rseq$arity$1(coll);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._rseq[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto__.call(null,coll);else{var m__7955__auto____$1=cljs.core._rseq["_"];if(!(m__7955__auto____$1==
null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto____$1.call(null,coll);else throw cljs.core.missing_protocol("IReversible.-rseq",coll);}}};cljs.core.ISorted=function(){};
cljs.core._sorted_seq=function cljs$core$_sorted_seq(coll,ascending_QMARK_){if(!(coll==null)&&!(coll.cljs$core$ISorted$_sorted_seq$arity$2==null))return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._sorted_seq[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_):m__7955__auto__.call(null,
coll,ascending_QMARK_);else{var m__7955__auto____$1=cljs.core._sorted_seq["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_):m__7955__auto____$1.call(null,coll,ascending_QMARK_);else throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);}}};
cljs.core._sorted_seq_from=function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){if(!(coll==null)&&!(coll.cljs$core$ISorted$_sorted_seq_from$arity$3==null))return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._sorted_seq_from[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$3?m__7955__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_):
m__7955__auto__.call(null,coll,k,ascending_QMARK_);else{var m__7955__auto____$1=cljs.core._sorted_seq_from["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_):m__7955__auto____$1.call(null,coll,k,ascending_QMARK_);else throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);}}};
cljs.core._entry_key=function cljs$core$_entry_key(coll,entry){if(!(coll==null)&&!(coll.cljs$core$ISorted$_entry_key$arity$2==null))return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._entry_key[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry):m__7955__auto__.call(null,coll,entry);else{var m__7955__auto____$1=
cljs.core._entry_key["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,entry):m__7955__auto____$1.call(null,coll,entry);else throw cljs.core.missing_protocol("ISorted.-entry-key",coll);}}};
cljs.core._comparator=function cljs$core$_comparator(coll){if(!(coll==null)&&!(coll.cljs$core$ISorted$_comparator$arity$1==null))return coll.cljs$core$ISorted$_comparator$arity$1(coll);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._comparator[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto__.call(null,coll);else{var m__7955__auto____$1=cljs.core._comparator["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto____$1.call(null,coll);else throw cljs.core.missing_protocol("ISorted.-comparator",coll);}}};cljs.core.IWriter=function(){};
cljs.core._write=function cljs$core$_write(writer,s){if(!(writer==null)&&!(writer.cljs$core$IWriter$_write$arity$2==null))return writer.cljs$core$IWriter$_write$arity$2(writer,s);else{var x__7954__auto__=writer==null?null:writer;var m__7955__auto__=cljs.core._write[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(writer,s):m__7955__auto__.call(null,writer,s);else{var m__7955__auto____$1=cljs.core._write["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(writer,s):m__7955__auto____$1.call(null,writer,s);else throw cljs.core.missing_protocol("IWriter.-write",writer);}}};
cljs.core._flush=function cljs$core$_flush(writer){if(!(writer==null)&&!(writer.cljs$core$IWriter$_flush$arity$1==null))return writer.cljs$core$IWriter$_flush$arity$1(writer);else{var x__7954__auto__=writer==null?null:writer;var m__7955__auto__=cljs.core._flush[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(writer):m__7955__auto__.call(null,writer);else{var m__7955__auto____$1=cljs.core._flush["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(writer):m__7955__auto____$1.call(null,writer);else throw cljs.core.missing_protocol("IWriter.-flush",writer);}}};cljs.core.IPrintWithWriter=function(){};
cljs.core._pr_writer=function cljs$core$_pr_writer(o,writer,opts){if(!(o==null)&&!(o.cljs$core$IPrintWithWriter$_pr_writer$arity$3==null))return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);else{var x__7954__auto__=o==null?null:o;var m__7955__auto__=cljs.core._pr_writer[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$3?m__7955__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts):m__7955__auto__.call(null,o,writer,opts);
else{var m__7955__auto____$1=cljs.core._pr_writer["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3(o,writer,opts):m__7955__auto____$1.call(null,o,writer,opts);else throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);}}};cljs.core.IPending=function(){};
cljs.core._realized_QMARK_=function cljs$core$_realized_QMARK_(x){if(!(x==null)&&!(x.cljs$core$IPending$_realized_QMARK_$arity$1==null))return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);else{var x__7954__auto__=x==null?null:x;var m__7955__auto__=cljs.core._realized_QMARK_[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(x):m__7955__auto__.call(null,x);else{var m__7955__auto____$1=cljs.core._realized_QMARK_["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(x):m__7955__auto____$1.call(null,x);else throw cljs.core.missing_protocol("IPending.-realized?",x);}}};cljs.core.IWatchable=function(){};
cljs.core._notify_watches=function cljs$core$_notify_watches(this$,oldval,newval){if(!(this$==null)&&!(this$.cljs$core$IWatchable$_notify_watches$arity$3==null))return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._notify_watches[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$3?m__7955__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,
newval):m__7955__auto__.call(null,this$,oldval,newval);else{var m__7955__auto____$1=cljs.core._notify_watches["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval):m__7955__auto____$1.call(null,this$,oldval,newval);else throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);}}};
cljs.core._add_watch=function cljs$core$_add_watch(this$,key,f){if(!(this$==null)&&!(this$.cljs$core$IWatchable$_add_watch$arity$3==null))return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._add_watch[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$3?m__7955__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f):m__7955__auto__.call(null,this$,key,f);
else{var m__7955__auto____$1=cljs.core._add_watch["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,key,f):m__7955__auto____$1.call(null,this$,key,f);else throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);}}};
cljs.core._remove_watch=function cljs$core$_remove_watch(this$,key){if(!(this$==null)&&!(this$.cljs$core$IWatchable$_remove_watch$arity$2==null))return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);else{var x__7954__auto__=this$==null?null:this$;var m__7955__auto__=cljs.core._remove_watch[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(this$,key):m__7955__auto__.call(null,this$,
key);else{var m__7955__auto____$1=cljs.core._remove_watch["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,key):m__7955__auto____$1.call(null,this$,key);else throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);}}};cljs.core.IEditableCollection=function(){};
cljs.core._as_transient=function cljs$core$_as_transient(coll){if(!(coll==null)&&!(coll.cljs$core$IEditableCollection$_as_transient$arity$1==null))return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._as_transient[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto__.call(null,coll);
else{var m__7955__auto____$1=cljs.core._as_transient["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto____$1.call(null,coll);else throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);}}};cljs.core.ITransientCollection=function(){};
cljs.core._conj_BANG_=function cljs$core$_conj_BANG_(tcoll,val){if(!(tcoll==null)&&!(tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2==null))return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);else{var x__7954__auto__=tcoll==null?null:tcoll;var m__7955__auto__=cljs.core._conj_BANG_[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val):m__7955__auto__.call(null,
tcoll,val);else{var m__7955__auto____$1=cljs.core._conj_BANG_["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,val):m__7955__auto____$1.call(null,tcoll,val);else throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);}}};
cljs.core._persistent_BANG_=function cljs$core$_persistent_BANG_(tcoll){if(!(tcoll==null)&&!(tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1==null))return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);else{var x__7954__auto__=tcoll==null?null:tcoll;var m__7955__auto__=cljs.core._persistent_BANG_[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(tcoll):m__7955__auto__.call(null,
tcoll);else{var m__7955__auto____$1=cljs.core._persistent_BANG_["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll):m__7955__auto____$1.call(null,tcoll);else throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);}}};cljs.core.ITransientAssociative=function(){};
cljs.core._assoc_BANG_=function cljs$core$_assoc_BANG_(tcoll,key,val){if(!(tcoll==null)&&!(tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3==null))return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);else{var x__7954__auto__=tcoll==null?null:tcoll;var m__7955__auto__=cljs.core._assoc_BANG_[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$3?m__7955__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val):
m__7955__auto__.call(null,tcoll,key,val);else{var m__7955__auto____$1=cljs.core._assoc_BANG_["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll,key,val):m__7955__auto____$1.call(null,tcoll,key,val);else throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);}}};cljs.core.ITransientMap=function(){};
cljs.core._dissoc_BANG_=function cljs$core$_dissoc_BANG_(tcoll,key){if(!(tcoll==null)&&!(tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2==null))return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);else{var x__7954__auto__=tcoll==null?null:tcoll;var m__7955__auto__=cljs.core._dissoc_BANG_[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key):m__7955__auto__.call(null,
tcoll,key);else{var m__7955__auto____$1=cljs.core._dissoc_BANG_["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,key):m__7955__auto____$1.call(null,tcoll,key);else throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);}}};cljs.core.ITransientVector=function(){};
cljs.core._assoc_n_BANG_=function cljs$core$_assoc_n_BANG_(tcoll,n,val){if(!(tcoll==null)&&!(tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3==null))return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);else{var x__7954__auto__=tcoll==null?null:tcoll;var m__7955__auto__=cljs.core._assoc_n_BANG_[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$3?m__7955__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val):m__7955__auto__.call(null,
tcoll,n,val);else{var m__7955__auto____$1=cljs.core._assoc_n_BANG_["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll,n,val):m__7955__auto____$1.call(null,tcoll,n,val);else throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);}}};
cljs.core._pop_BANG_=function cljs$core$_pop_BANG_(tcoll){if(!(tcoll==null)&&!(tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1==null))return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);else{var x__7954__auto__=tcoll==null?null:tcoll;var m__7955__auto__=cljs.core._pop_BANG_[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(tcoll):m__7955__auto__.call(null,tcoll);else{var m__7955__auto____$1=
cljs.core._pop_BANG_["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll):m__7955__auto____$1.call(null,tcoll);else throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);}}};cljs.core.ITransientSet=function(){};
cljs.core._disjoin_BANG_=function cljs$core$_disjoin_BANG_(tcoll,v){if(!(tcoll==null)&&!(tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2==null))return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);else{var x__7954__auto__=tcoll==null?null:tcoll;var m__7955__auto__=cljs.core._disjoin_BANG_[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v):m__7955__auto__.call(null,
tcoll,v);else{var m__7955__auto____$1=cljs.core._disjoin_BANG_["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,v):m__7955__auto____$1.call(null,tcoll,v);else throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);}}};cljs.core.IComparable=function(){};
cljs.core._compare=function cljs$core$_compare(x,y){if(!(x==null)&&!(x.cljs$core$IComparable$_compare$arity$2==null))return x.cljs$core$IComparable$_compare$arity$2(x,y);else{var x__7954__auto__=x==null?null:x;var m__7955__auto__=cljs.core._compare[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(x,y):m__7955__auto__.call(null,x,y);else{var m__7955__auto____$1=cljs.core._compare["_"];if(!(m__7955__auto____$1==
null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(x,y):m__7955__auto____$1.call(null,x,y);else throw cljs.core.missing_protocol("IComparable.-compare",x);}}};cljs.core.IChunk=function(){};
cljs.core._drop_first=function cljs$core$_drop_first(coll){if(!(coll==null)&&!(coll.cljs$core$IChunk$_drop_first$arity$1==null))return coll.cljs$core$IChunk$_drop_first$arity$1(coll);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._drop_first[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto__.call(null,coll);else{var m__7955__auto____$1=cljs.core._drop_first["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto____$1.call(null,coll);else throw cljs.core.missing_protocol("IChunk.-drop-first",coll);}}};cljs.core.IChunkedSeq=function(){};
cljs.core._chunked_first=function cljs$core$_chunked_first(coll){if(!(coll==null)&&!(coll.cljs$core$IChunkedSeq$_chunked_first$arity$1==null))return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._chunked_first[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto__.call(null,coll);else{var m__7955__auto____$1=
cljs.core._chunked_first["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto____$1.call(null,coll);else throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);}}};
cljs.core._chunked_rest=function cljs$core$_chunked_rest(coll){if(!(coll==null)&&!(coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1==null))return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._chunked_rest[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto__.call(null,coll);else{var m__7955__auto____$1=
cljs.core._chunked_rest["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto____$1.call(null,coll);else throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);}}};cljs.core.IChunkedNext=function(){};
cljs.core._chunked_next=function cljs$core$_chunked_next(coll){if(!(coll==null)&&!(coll.cljs$core$IChunkedNext$_chunked_next$arity$1==null))return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._chunked_next[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto__.call(null,coll);else{var m__7955__auto____$1=
cljs.core._chunked_next["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto____$1.call(null,coll);else throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);}}};cljs.core.INamed=function(){};
cljs.core._name=function cljs$core$_name(x){if(!(x==null)&&!(x.cljs$core$INamed$_name$arity$1==null))return x.cljs$core$INamed$_name$arity$1(x);else{var x__7954__auto__=x==null?null:x;var m__7955__auto__=cljs.core._name[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(x):m__7955__auto__.call(null,x);else{var m__7955__auto____$1=cljs.core._name["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?
m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(x):m__7955__auto____$1.call(null,x);else throw cljs.core.missing_protocol("INamed.-name",x);}}};
cljs.core._namespace=function cljs$core$_namespace(x){if(!(x==null)&&!(x.cljs$core$INamed$_namespace$arity$1==null))return x.cljs$core$INamed$_namespace$arity$1(x);else{var x__7954__auto__=x==null?null:x;var m__7955__auto__=cljs.core._namespace[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(x):m__7955__auto__.call(null,x);else{var m__7955__auto____$1=cljs.core._namespace["_"];if(!(m__7955__auto____$1==
null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(x):m__7955__auto____$1.call(null,x);else throw cljs.core.missing_protocol("INamed.-namespace",x);}}};cljs.core.IAtom=function(){};cljs.core.IReset=function(){};
cljs.core._reset_BANG_=function cljs$core$_reset_BANG_(o,new_value){if(!(o==null)&&!(o.cljs$core$IReset$_reset_BANG_$arity$2==null))return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);else{var x__7954__auto__=o==null?null:o;var m__7955__auto__=cljs.core._reset_BANG_[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value):m__7955__auto__.call(null,o,new_value);else{var m__7955__auto____$1=
cljs.core._reset_BANG_["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(o,new_value):m__7955__auto____$1.call(null,o,new_value);else throw cljs.core.missing_protocol("IReset.-reset!",o);}}};cljs.core.ISwap=function(){};
cljs.core._swap_BANG_=function cljs$core$_swap_BANG_(var_args){var G__9420=arguments.length;switch(G__9420){case 2:return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;case 5:return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(arguments[0],
arguments[1],arguments[2],arguments[3],arguments[4]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2=function(o,f){if(!(o==null)&&!(o.cljs$core$ISwap$_swap_BANG_$arity$2==null))return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);else{var x__7954__auto__=o==null?null:o;var m__7955__auto__=cljs.core._swap_BANG_[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(o,f):m__7955__auto__.call(null,o,f);else{var m__7955__auto____$1=cljs.core._swap_BANG_["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(o,f):m__7955__auto____$1.call(null,o,f);else throw cljs.core.missing_protocol("ISwap.-swap!",o);}}};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3=function(o,f,a){if(!(o==null)&&!(o.cljs$core$ISwap$_swap_BANG_$arity$3==null))return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);else{var x__7954__auto__=o==null?null:o;var m__7955__auto__=cljs.core._swap_BANG_[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$3?m__7955__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a):m__7955__auto__.call(null,o,f,a);else{var m__7955__auto____$1=cljs.core._swap_BANG_["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$3(o,f,a):m__7955__auto____$1.call(null,o,f,a);else throw cljs.core.missing_protocol("ISwap.-swap!",o);}}};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4=function(o,f,a,b){if(!(o==null)&&!(o.cljs$core$ISwap$_swap_BANG_$arity$4==null))return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);else{var x__7954__auto__=o==null?null:o;var m__7955__auto__=cljs.core._swap_BANG_[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$4?m__7955__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b):m__7955__auto__.call(null,o,f,a,b);else{var m__7955__auto____$1=cljs.core._swap_BANG_["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$4?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$4(o,f,a,b):m__7955__auto____$1.call(null,o,f,a,b);else throw cljs.core.missing_protocol("ISwap.-swap!",o);}}};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5=function(o,f,a,b,xs){if(!(o==null)&&!(o.cljs$core$ISwap$_swap_BANG_$arity$5==null))return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);else{var x__7954__auto__=o==null?null:o;var m__7955__auto__=cljs.core._swap_BANG_[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$5?m__7955__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs):m__7955__auto__.call(null,o,f,a,b,xs);else{var m__7955__auto____$1=
cljs.core._swap_BANG_["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$5?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs):m__7955__auto____$1.call(null,o,f,a,b,xs);else throw cljs.core.missing_protocol("ISwap.-swap!",o);}}};cljs.core._swap_BANG_.cljs$lang$maxFixedArity=5;cljs.core.IVolatile=function(){};
cljs.core._vreset_BANG_=function cljs$core$_vreset_BANG_(o,new_value){if(!(o==null)&&!(o.cljs$core$IVolatile$_vreset_BANG_$arity$2==null))return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);else{var x__7954__auto__=o==null?null:o;var m__7955__auto__=cljs.core._vreset_BANG_[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$2?m__7955__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value):m__7955__auto__.call(null,o,new_value);else{var m__7955__auto____$1=
cljs.core._vreset_BANG_["_"];if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$2(o,new_value):m__7955__auto____$1.call(null,o,new_value);else throw cljs.core.missing_protocol("IVolatile.-vreset!",o);}}};cljs.core.IIterable=function(){};
cljs.core._iterator=function cljs$core$_iterator(coll){if(!(coll==null)&&!(coll.cljs$core$IIterable$_iterator$arity$1==null))return coll.cljs$core$IIterable$_iterator$arity$1(coll);else{var x__7954__auto__=coll==null?null:coll;var m__7955__auto__=cljs.core._iterator[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto__.call(null,coll);else{var m__7955__auto____$1=cljs.core._iterator["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(coll):m__7955__auto____$1.call(null,coll);else throw cljs.core.missing_protocol("IIterable.-iterator",coll);}}};cljs.core.StringBufferWriter=function(sb){this.sb=sb;this.cljs$lang$protocol_mask$partition0$=1073741824;this.cljs$lang$protocol_mask$partition1$=0};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2=function(_,s){var self__=this;var ___$1=this;return self__.sb.append(s)};cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1=function(_){var self__=this;var ___$1=this;return null};cljs.core.StringBufferWriter.getBasis=function(){return new cljs.core.PersistentVector(null,1,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"sb","sb",-1249746442,null)],null)};
cljs.core.StringBufferWriter.cljs$lang$type=true;cljs.core.StringBufferWriter.cljs$lang$ctorStr="cljs.core/StringBufferWriter";cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/StringBufferWriter")};cljs.core.__GT_StringBufferWriter=function cljs$core$__GT_StringBufferWriter(sb){return new cljs.core.StringBufferWriter(sb)};
cljs.core.pr_str_STAR_=function cljs$core$pr_str_STAR_(obj){var sb=new goog.string.StringBuffer;var writer=new cljs.core.StringBufferWriter(sb);obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());writer.cljs$core$IWriter$_flush$arity$1(null);return[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb)].join("")};cljs.core.int_rotate_left=function cljs$core$int_rotate_left(x,n){return x<<n|x>>>-n};
if(typeof Math.imul!=="undefined"&&!(Math.imul(4294967295,5)===0))cljs.core.imul=function cljs$core$imul(a,b){return Math.imul(a,b)};else cljs.core.imul=function cljs$core$imul(a,b){var ah=a>>>16&65535;var al=a&65535;var bh=b>>>16&65535;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16>>>0)|0};cljs.core.m3_seed=0;cljs.core.m3_C1=3432918353|0;cljs.core.m3_C2=461845907|0;
cljs.core.m3_mix_K1=function cljs$core$m3_mix_K1(k1){return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul(k1|0,cljs.core.m3_C1),15),cljs.core.m3_C2)};cljs.core.m3_mix_H1=function cljs$core$m3_mix_H1(h1,k1){return cljs.core.imul(cljs.core.int_rotate_left((h1|0)^(k1|0),13),5)+(3864292196|0)|0};
cljs.core.m3_fmix=function cljs$core$m3_fmix(h1,len){var h1__$1=h1|0;var h1__$2=h1__$1^len;var h1__$3=h1__$2^h1__$2>>>16;var h1__$4=cljs.core.imul(h1__$3,2246822507|0);var h1__$5=h1__$4^h1__$4>>>13;var h1__$6=cljs.core.imul(h1__$5,3266489909|0);return h1__$6^h1__$6>>>16};cljs.core.m3_hash_int=function cljs$core$m3_hash_int(in$){if(in$===0)return in$;else{var k1=cljs.core.m3_mix_K1(in$);var h1=cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);return cljs.core.m3_fmix(h1,4)}};
cljs.core.m3_hash_unencoded_chars=function cljs$core$m3_hash_unencoded_chars(in$){var h1=function(){var i=1;var h1=cljs.core.m3_seed;while(true){if(i<in$.length){var G__9422=i+2;var G__9423=cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1(in$.charCodeAt(i-1)|in$.charCodeAt(i)<<16));i=G__9422;h1=G__9423;continue}else return h1;break}}();var h1__$1=(in$.length&1)===1?h1^cljs.core.m3_mix_K1(in$.charCodeAt(in$.length-1)):h1;return cljs.core.m3_fmix(h1__$1,cljs.core.imul(2,in$.length))};
cljs.core.string_hash_cache={};cljs.core.string_hash_cache_count=0;cljs.core.hash_string_STAR_=function cljs$core$hash_string_STAR_(s){if(!(s==null)){var len=s.length;if(len>0){var i=0;var hash=0;while(true){if(i<len){var G__9426=i+1;var G__9427=cljs.core.imul(31,hash)+s.charCodeAt(i);i=G__9426;hash=G__9427;continue}else return hash;break}}else return 0}else return 0};
cljs.core.add_to_string_hash_cache=function cljs$core$add_to_string_hash_cache(k){var h=cljs.core.hash_string_STAR_(k);cljs.core.string_hash_cache[k]=h;cljs.core.string_hash_cache_count=cljs.core.string_hash_cache_count+1;return h};cljs.core.hash_string=function cljs$core$hash_string(k){if(cljs.core.string_hash_cache_count>255){cljs.core.string_hash_cache={};cljs.core.string_hash_cache_count=0}else;if(k==null)return 0;else{var h=cljs.core.string_hash_cache[k];if(typeof h==="number")return h;else return cljs.core.add_to_string_hash_cache(k)}};
cljs.core.hash=function cljs$core$hash(o){if(!(o==null)?o.cljs$lang$protocol_mask$partition0$&4194304||cljs.core.PROTOCOL_SENTINEL===o.cljs$core$IHash$?true:false:false)return o.cljs$core$IHash$_hash$arity$1(null)^0;else if(typeof o==="number")if(cljs.core.truth_(isFinite(o)))return Math.floor(o)%2147483647;else{var G__9431=o;switch(G__9431){case Infinity:return 2146435072;break;case -Infinity:return-1048576;break;default:return 2146959360}}else if(o===true)return 1231;else if(o===false)return 1237;
else if(typeof o==="string")return cljs.core.m3_hash_int(cljs.core.hash_string(o));else if(o instanceof Date)return o.valueOf()^0;else if(o==null)return 0;else return cljs.core._hash(o)^0};cljs.core.hash_combine=function cljs$core$hash_combine(seed,hash){return seed^hash+2654435769+(seed<<6)+(seed>>2)};cljs.core.instance_QMARK_=function cljs$core$instance_QMARK_(c,x){return x instanceof c};cljs.core.symbol_QMARK_=function cljs$core$symbol_QMARK_(x){return x instanceof cljs.core.Symbol};
cljs.core.hash_symbol=function cljs$core$hash_symbol(sym){return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns))};
cljs.core.compare_symbols=function cljs$core$compare_symbols(a,b){if(a.str===b.str)return 0;else if(cljs.core.truth_(function(){var and__7273__auto__=cljs.core.not(a.ns);if(and__7273__auto__)return b.ns;else return and__7273__auto__}()))return-1;else if(cljs.core.truth_(a.ns))if(cljs.core.not(b.ns))return 1;else{var nsc=function(){var G__9433=a.ns;var G__9434=b.ns;return goog.array.defaultCompare(G__9433,G__9434)}();if(0===nsc){var G__9435=a.name;var G__9436=b.name;return goog.array.defaultCompare(G__9435,
G__9436)}else return nsc}else{var G__9437=a.name;var G__9438=b.name;return goog.array.defaultCompare(G__9437,G__9438)}};cljs.core.Symbol=function(ns,name,str,_hash,_meta){this.ns=ns;this.name=name;this.str=str;this._hash=_hash;this._meta=_meta;this.cljs$lang$protocol_mask$partition0$=2154168321;this.cljs$lang$protocol_mask$partition1$=4096};cljs.core.Symbol.prototype.toString=function(){var self__=this;var _=this;return self__.str};
cljs.core.Symbol.prototype.equiv=function(other){var self__=this;var this$=this;return this$.cljs$core$IEquiv$_equiv$arity$2(null,other)};cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2=function(_,other){var self__=this;var ___$1=this;if(other instanceof cljs.core.Symbol)return self__.str===other.str;else return false};
cljs.core.Symbol.prototype.call=function(){var G__9440=null;var G__9440__2=function(self__,coll){var self__=this;var self____$1=this;var sym=self____$1;return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym)};var G__9440__3=function(self__,coll,not_found){var self__=this;var self____$1=this;var sym=self____$1;return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found)};G__9440=function(self__,coll,not_found){switch(arguments.length){case 2:return G__9440__2.call(this,self__,coll);
case 3:return G__9440__3.call(this,self__,coll,not_found)}throw new Error("Invalid arity: "+(arguments.length-1));};G__9440.cljs$core$IFn$_invoke$arity$2=G__9440__2;G__9440.cljs$core$IFn$_invoke$arity$3=G__9440__3;return G__9440}();cljs.core.Symbol.prototype.apply=function(self__,args9439){var self__=this;var self____$1=this;return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9439)))};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1=function(coll){var self__=this;var sym=this;return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym)};cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2=function(coll,not_found){var self__=this;var sym=this;return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found)};cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1=function(_){var self__=this;var ___$1=this;return self__._meta};
cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2=function(_,new_meta){var self__=this;var ___$1=this;return new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta)};cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1=function(sym){var self__=this;var sym__$1=this;var h__7725__auto__=self__._hash;if(!(h__7725__auto__==null))return h__7725__auto__;else{var h__7725__auto____$1=cljs.core.hash_symbol(sym__$1);self__._hash=h__7725__auto____$1;return h__7725__auto____$1}};
cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1=function(_){var self__=this;var ___$1=this;return self__.name};cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1=function(_){var self__=this;var ___$1=this;return self__.ns};cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3=function(o,writer,_){var self__=this;var o__$1=this;return cljs.core._write(writer,self__.str)};
cljs.core.Symbol.getBasis=function(){return new cljs.core.PersistentVector(null,5,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null)),new cljs.core.Symbol(null,
"_meta","_meta",-1716892533,null)],null)};cljs.core.Symbol.cljs$lang$type=true;cljs.core.Symbol.cljs$lang$ctorStr="cljs.core/Symbol";cljs.core.Symbol.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/Symbol")};cljs.core.__GT_Symbol=function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){return new cljs.core.Symbol(ns,name,str,_hash,_meta)};
cljs.core.symbol=function cljs$core$symbol(var_args){var G__9442=arguments.length;switch(G__9442){case 1:return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1=function(name){if(name instanceof cljs.core.Symbol)return name;else{var idx=name.indexOf("/");if(idx<1)return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);else return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring(0,idx),name.substring(idx+1,name.length))}};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$2=function(ns,name){var sym_str=!(ns==null)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(""):name;return new cljs.core.Symbol(ns,name,sym_str,null,null)};cljs.core.symbol.cljs$lang$maxFixedArity=2;
cljs.core.Var=function(val,sym,_meta){this.val=val;this.sym=sym;this._meta=_meta;this.cljs$lang$protocol_mask$partition0$=6717441;this.cljs$lang$protocol_mask$partition1$=0};cljs.core.Var.prototype.isMacro=function(){var self__=this;var _=this;return(self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null)).cljs$lang$macro};
cljs.core.Var.prototype.toString=function(){var self__=this;var _=this;return[cljs.core.str.cljs$core$IFn$_invoke$arity$1("#'"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.sym)].join("")};cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1=function(_){var self__=this;var ___$1=this;return self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null)};
cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1=function(_){var self__=this;var ___$1=this;return self__._meta};cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2=function(_,new_meta){var self__=this;var ___$1=this;return new cljs.core.Var(self__.val,self__.sym,new_meta)};
cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2=function(this$,other){var self__=this;var this$__$1=this;if(other instanceof cljs.core.Var)return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this$__$1.sym,other.sym);else return false};cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1=function(_){var self__=this;var ___$1=this;return cljs.core.hash_symbol(self__.sym)};cljs.core.Var.prototype.cljs$core$Fn$=cljs.core.PROTOCOL_SENTINEL;
cljs.core.Var.prototype.call=function(){var G__9487=null;var G__9487__1=function(self__){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9445=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9445.cljs$core$IFn$_invoke$arity$0?fexpr__9445.cljs$core$IFn$_invoke$arity$0():fexpr__9445.call(null)};var G__9487__2=function(self__,a){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9446=self__.val.cljs$core$IFn$_invoke$arity$0?
self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9446.cljs$core$IFn$_invoke$arity$1?fexpr__9446.cljs$core$IFn$_invoke$arity$1(a):fexpr__9446.call(null,a)};var G__9487__3=function(self__,a,b){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9447=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9447.cljs$core$IFn$_invoke$arity$2?fexpr__9447.cljs$core$IFn$_invoke$arity$2(a,b):fexpr__9447.call(null,
a,b)};var G__9487__4=function(self__,a,b,c){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9448=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9448.cljs$core$IFn$_invoke$arity$3?fexpr__9448.cljs$core$IFn$_invoke$arity$3(a,b,c):fexpr__9448.call(null,a,b,c)};var G__9487__5=function(self__,a,b,c,d){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9449=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():
self__.val.call(null);return fexpr__9449.cljs$core$IFn$_invoke$arity$4?fexpr__9449.cljs$core$IFn$_invoke$arity$4(a,b,c,d):fexpr__9449.call(null,a,b,c,d)};var G__9487__6=function(self__,a,b,c,d,e){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9450=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9450.cljs$core$IFn$_invoke$arity$5?fexpr__9450.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e):fexpr__9450.call(null,a,b,c,
d,e)};var G__9487__7=function(self__,a,b,c,d,e,f){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9451=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9451.cljs$core$IFn$_invoke$arity$6?fexpr__9451.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f):fexpr__9451.call(null,a,b,c,d,e,f)};var G__9487__8=function(self__,a,b,c,d,e,f,g){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9452=self__.val.cljs$core$IFn$_invoke$arity$0?
self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9452.cljs$core$IFn$_invoke$arity$7?fexpr__9452.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g):fexpr__9452.call(null,a,b,c,d,e,f,g)};var G__9487__9=function(self__,a,b,c,d,e,f,g,h){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9453=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9453.cljs$core$IFn$_invoke$arity$8?fexpr__9453.cljs$core$IFn$_invoke$arity$8(a,
b,c,d,e,f,g,h):fexpr__9453.call(null,a,b,c,d,e,f,g,h)};var G__9487__10=function(self__,a,b,c,d,e,f,g,h,i){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9454=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9454.cljs$core$IFn$_invoke$arity$9?fexpr__9454.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i):fexpr__9454.call(null,a,b,c,d,e,f,g,h,i)};var G__9487__11=function(self__,a,b,c,d,e,f,g,h,i,j){var self__=this;
var self____$1=this;var _=self____$1;var fexpr__9455=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9455.cljs$core$IFn$_invoke$arity$10?fexpr__9455.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j):fexpr__9455.call(null,a,b,c,d,e,f,g,h,i,j)};var G__9487__12=function(self__,a,b,c,d,e,f,g,h,i,j,k){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9456=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():
self__.val.call(null);return fexpr__9456.cljs$core$IFn$_invoke$arity$11?fexpr__9456.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k):fexpr__9456.call(null,a,b,c,d,e,f,g,h,i,j,k)};var G__9487__13=function(self__,a,b,c,d,e,f,g,h,i,j,k,l){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9457=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9457.cljs$core$IFn$_invoke$arity$12?fexpr__9457.cljs$core$IFn$_invoke$arity$12(a,
b,c,d,e,f,g,h,i,j,k,l):fexpr__9457.call(null,a,b,c,d,e,f,g,h,i,j,k,l)};var G__9487__14=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9458=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9458.cljs$core$IFn$_invoke$arity$13?fexpr__9458.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m):fexpr__9458.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m)};var G__9487__15=function(self__,
a,b,c,d,e,f,g,h,i,j,k,l,m,n){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9459=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9459.cljs$core$IFn$_invoke$arity$14?fexpr__9459.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n):fexpr__9459.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n)};var G__9487__16=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9460=
self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9460.cljs$core$IFn$_invoke$arity$15?fexpr__9460.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o):fexpr__9460.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o)};var G__9487__17=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9461=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():
self__.val.call(null);return fexpr__9461.cljs$core$IFn$_invoke$arity$16?fexpr__9461.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p):fexpr__9461.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p)};var G__9487__18=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9462=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9462.cljs$core$IFn$_invoke$arity$17?fexpr__9462.cljs$core$IFn$_invoke$arity$17(a,
b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q):fexpr__9462.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q)};var G__9487__19=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9463=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9463.cljs$core$IFn$_invoke$arity$18?fexpr__9463.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r):fexpr__9463.call(null,a,b,c,d,e,f,g,
h,i,j,k,l,m,n,o,p,q,r)};var G__9487__20=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9464=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9464.cljs$core$IFn$_invoke$arity$19?fexpr__9464.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s):fexpr__9464.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s)};var G__9487__21=function(self__,a,b,c,
d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){var self__=this;var self____$1=this;var _=self____$1;var fexpr__9465=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9465.cljs$core$IFn$_invoke$arity$20?fexpr__9465.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t):fexpr__9465.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t)};var G__9487__22=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){var self__=this;
var self____$1=this;var _=self____$1;return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null),a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest],0))};G__9487=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){switch(arguments.length){case 1:return G__9487__1.call(this,self__);case 2:return G__9487__2.call(this,self__,a);case 3:return G__9487__3.call(this,
self__,a,b);case 4:return G__9487__4.call(this,self__,a,b,c);case 5:return G__9487__5.call(this,self__,a,b,c,d);case 6:return G__9487__6.call(this,self__,a,b,c,d,e);case 7:return G__9487__7.call(this,self__,a,b,c,d,e,f);case 8:return G__9487__8.call(this,self__,a,b,c,d,e,f,g);case 9:return G__9487__9.call(this,self__,a,b,c,d,e,f,g,h);case 10:return G__9487__10.call(this,self__,a,b,c,d,e,f,g,h,i);case 11:return G__9487__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);case 12:return G__9487__12.call(this,
self__,a,b,c,d,e,f,g,h,i,j,k);case 13:return G__9487__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);case 14:return G__9487__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);case 15:return G__9487__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);case 16:return G__9487__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);case 17:return G__9487__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);case 18:return G__9487__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);case 19:return G__9487__19.call(this,
self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);case 20:return G__9487__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);case 21:return G__9487__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);case 22:return G__9487__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest)}throw new Error("Invalid arity: "+(arguments.length-1));};G__9487.cljs$core$IFn$_invoke$arity$1=G__9487__1;G__9487.cljs$core$IFn$_invoke$arity$2=G__9487__2;G__9487.cljs$core$IFn$_invoke$arity$3=G__9487__3;
G__9487.cljs$core$IFn$_invoke$arity$4=G__9487__4;G__9487.cljs$core$IFn$_invoke$arity$5=G__9487__5;G__9487.cljs$core$IFn$_invoke$arity$6=G__9487__6;G__9487.cljs$core$IFn$_invoke$arity$7=G__9487__7;G__9487.cljs$core$IFn$_invoke$arity$8=G__9487__8;G__9487.cljs$core$IFn$_invoke$arity$9=G__9487__9;G__9487.cljs$core$IFn$_invoke$arity$10=G__9487__10;G__9487.cljs$core$IFn$_invoke$arity$11=G__9487__11;G__9487.cljs$core$IFn$_invoke$arity$12=G__9487__12;G__9487.cljs$core$IFn$_invoke$arity$13=G__9487__13;G__9487.cljs$core$IFn$_invoke$arity$14=
G__9487__14;G__9487.cljs$core$IFn$_invoke$arity$15=G__9487__15;G__9487.cljs$core$IFn$_invoke$arity$16=G__9487__16;G__9487.cljs$core$IFn$_invoke$arity$17=G__9487__17;G__9487.cljs$core$IFn$_invoke$arity$18=G__9487__18;G__9487.cljs$core$IFn$_invoke$arity$19=G__9487__19;G__9487.cljs$core$IFn$_invoke$arity$20=G__9487__20;G__9487.cljs$core$IFn$_invoke$arity$21=G__9487__21;G__9487.cljs$core$IFn$_invoke$arity$22=G__9487__22;return G__9487}();
cljs.core.Var.prototype.apply=function(self__,args9444){var self__=this;var self____$1=this;return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9444)))};cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0=function(){var self__=this;var _=this;var fexpr__9466=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9466.cljs$core$IFn$_invoke$arity$0?fexpr__9466.cljs$core$IFn$_invoke$arity$0():fexpr__9466.call(null)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1=function(a){var self__=this;var _=this;var fexpr__9467=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9467.cljs$core$IFn$_invoke$arity$1?fexpr__9467.cljs$core$IFn$_invoke$arity$1(a):fexpr__9467.call(null,a)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2=function(a,b){var self__=this;var _=this;var fexpr__9468=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9468.cljs$core$IFn$_invoke$arity$2?fexpr__9468.cljs$core$IFn$_invoke$arity$2(a,b):fexpr__9468.call(null,a,b)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3=function(a,b,c){var self__=this;var _=this;var fexpr__9469=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9469.cljs$core$IFn$_invoke$arity$3?fexpr__9469.cljs$core$IFn$_invoke$arity$3(a,b,c):fexpr__9469.call(null,a,b,c)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4=function(a,b,c,d){var self__=this;var _=this;var fexpr__9470=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9470.cljs$core$IFn$_invoke$arity$4?fexpr__9470.cljs$core$IFn$_invoke$arity$4(a,b,c,d):fexpr__9470.call(null,a,b,c,d)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5=function(a,b,c,d,e){var self__=this;var _=this;var fexpr__9471=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9471.cljs$core$IFn$_invoke$arity$5?fexpr__9471.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e):fexpr__9471.call(null,a,b,c,d,e)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6=function(a,b,c,d,e,f){var self__=this;var _=this;var fexpr__9472=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9472.cljs$core$IFn$_invoke$arity$6?fexpr__9472.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f):fexpr__9472.call(null,a,b,c,d,e,f)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7=function(a,b,c,d,e,f,g){var self__=this;var _=this;var fexpr__9473=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9473.cljs$core$IFn$_invoke$arity$7?fexpr__9473.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g):fexpr__9473.call(null,a,b,c,d,e,f,g)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8=function(a,b,c,d,e,f,g,h){var self__=this;var _=this;var fexpr__9474=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9474.cljs$core$IFn$_invoke$arity$8?fexpr__9474.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h):fexpr__9474.call(null,a,b,c,d,e,f,g,h)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9=function(a,b,c,d,e,f,g,h,i){var self__=this;var _=this;var fexpr__9475=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9475.cljs$core$IFn$_invoke$arity$9?fexpr__9475.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i):fexpr__9475.call(null,a,b,c,d,e,f,g,h,i)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10=function(a,b,c,d,e,f,g,h,i,j){var self__=this;var _=this;var fexpr__9476=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9476.cljs$core$IFn$_invoke$arity$10?fexpr__9476.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j):fexpr__9476.call(null,a,b,c,d,e,f,g,h,i,j)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11=function(a,b,c,d,e,f,g,h,i,j,k){var self__=this;var _=this;var fexpr__9477=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9477.cljs$core$IFn$_invoke$arity$11?fexpr__9477.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k):fexpr__9477.call(null,a,b,c,d,e,f,g,h,i,j,k)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12=function(a,b,c,d,e,f,g,h,i,j,k,l){var self__=this;var _=this;var fexpr__9478=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9478.cljs$core$IFn$_invoke$arity$12?fexpr__9478.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l):fexpr__9478.call(null,a,b,c,d,e,f,g,h,i,j,k,l)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13=function(a,b,c,d,e,f,g,h,i,j,k,l,m){var self__=this;var _=this;var fexpr__9479=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9479.cljs$core$IFn$_invoke$arity$13?fexpr__9479.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m):fexpr__9479.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14=function(a,b,c,d,e,f,g,h,i,j,k,l,m,n){var self__=this;var _=this;var fexpr__9480=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9480.cljs$core$IFn$_invoke$arity$14?fexpr__9480.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n):fexpr__9480.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15=function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){var self__=this;var _=this;var fexpr__9481=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9481.cljs$core$IFn$_invoke$arity$15?fexpr__9481.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o):fexpr__9481.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16=function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){var self__=this;var _=this;var fexpr__9482=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9482.cljs$core$IFn$_invoke$arity$16?fexpr__9482.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p):fexpr__9482.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17=function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){var self__=this;var _=this;var fexpr__9483=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9483.cljs$core$IFn$_invoke$arity$17?fexpr__9483.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q):fexpr__9483.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18=function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){var self__=this;var _=this;var fexpr__9484=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9484.cljs$core$IFn$_invoke$arity$18?fexpr__9484.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r):fexpr__9484.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19=function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){var self__=this;var _=this;var fexpr__9485=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9485.cljs$core$IFn$_invoke$arity$19?fexpr__9485.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s):fexpr__9485.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20=function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){var self__=this;var _=this;var fexpr__9486=self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null);return fexpr__9486.cljs$core$IFn$_invoke$arity$20?fexpr__9486.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t):fexpr__9486.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t)};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21=function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){var self__=this;var _=this;return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.val.cljs$core$IFn$_invoke$arity$0?self__.val.cljs$core$IFn$_invoke$arity$0():self__.val.call(null),a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest],0))};
cljs.core.Var.getBasis=function(){return new cljs.core.PersistentVector(null,3,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"sym","sym",195671222,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)],null)};cljs.core.Var.cljs$lang$type=true;cljs.core.Var.cljs$lang$ctorStr="cljs.core/Var";
cljs.core.Var.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/Var")};cljs.core.__GT_Var=function cljs$core$__GT_Var(val,sym,_meta){return new cljs.core.Var(val,sym,_meta)};cljs.core.var_QMARK_=function cljs$core$var_QMARK_(v){return v instanceof cljs.core.Var};
cljs.core.iterable_QMARK_=function cljs$core$iterable_QMARK_(x){if(!(x==null))if(x.cljs$lang$protocol_mask$partition1$&131072||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$IIterable$)return true;else if(!x.cljs$lang$protocol_mask$partition1$)return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x)};cljs.core.clone=function cljs$core$clone(value){return cljs.core._clone(value)};
cljs.core.cloneable_QMARK_=function cljs$core$cloneable_QMARK_(value){if(!(value==null))if(value.cljs$lang$protocol_mask$partition1$&8192||cljs.core.PROTOCOL_SENTINEL===value.cljs$core$ICloneable$)return true;else if(!value.cljs$lang$protocol_mask$partition1$)return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value)};
cljs.core.seq=function cljs$core$seq(coll){if(coll==null)return null;else if(!(coll==null)?coll.cljs$lang$protocol_mask$partition0$&8388608||cljs.core.PROTOCOL_SENTINEL===coll.cljs$core$ISeqable$?true:false:false)return coll.cljs$core$ISeqable$_seq$arity$1(null);else if(cljs.core.array_QMARK_(coll))if(coll.length===0)return null;else return new cljs.core.IndexedSeq(coll,0,null);else if(typeof coll==="string")if(coll.length===0)return null;else return new cljs.core.IndexedSeq(coll,0,null);else if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,
coll))return cljs.core._seq(coll);else throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" is not ISeqable")].join(""));};cljs.core.first=function cljs$core$first(coll){if(coll==null)return null;else if(!(coll==null)?coll.cljs$lang$protocol_mask$partition0$&64||cljs.core.PROTOCOL_SENTINEL===coll.cljs$core$ISeq$?true:false:false)return coll.cljs$core$ISeq$_first$arity$1(null);else{var s=cljs.core.seq(coll);if(s==null)return null;else return cljs.core._first(s)}};
cljs.core.rest=function cljs$core$rest(coll){if(!(coll==null))if(!(coll==null)?coll.cljs$lang$protocol_mask$partition0$&64||cljs.core.PROTOCOL_SENTINEL===coll.cljs$core$ISeq$?true:false:false)return coll.cljs$core$ISeq$_rest$arity$1(null);else{var s=cljs.core.seq(coll);if(s)return cljs.core._rest(s);else return cljs.core.List.EMPTY}else return cljs.core.List.EMPTY};
cljs.core.next=function cljs$core$next(coll){if(coll==null)return null;else if(!(coll==null)?coll.cljs$lang$protocol_mask$partition0$&128||cljs.core.PROTOCOL_SENTINEL===coll.cljs$core$INext$?true:false:false)return coll.cljs$core$INext$_next$arity$1(null);else return cljs.core.seq(cljs.core.rest(coll))};
cljs.core._EQ_=function cljs$core$_EQ_(var_args){var G__9498=arguments.length;switch(G__9498){case 1:return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9500=arguments.length;var i__8411__auto___9501=0;while(true){if(i__8411__auto___9501<len__8410__auto___9500){args_arr__8429__auto__.push(arguments[i__8411__auto___9501]);var G__9502=
i__8411__auto___9501+1;i__8411__auto___9501=G__9502;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1=function(x){return true};cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2=function(x,y){if(x==null)return y==null;else return x===y||cljs.core._equiv(x,y)};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){while(true){if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y))if(cljs.core.next(more)){var G__9503=y;var G__9504=cljs.core.first(more);var G__9505=cljs.core.next(more);x=G__9503;y=G__9504;more=G__9505;continue}else return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));else return false;break}};
cljs.core._EQ_.cljs$lang$applyTo=function(seq9495){var G__9496=cljs.core.first(seq9495);var seq9495__$1=cljs.core.next(seq9495);var G__9497=cljs.core.first(seq9495__$1);var seq9495__$2=cljs.core.next(seq9495__$1);return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(G__9496,G__9497,seq9495__$2)};cljs.core._EQ_.cljs$lang$maxFixedArity=2;cljs.core.ES6Iterator=function(s){this.s=s};
cljs.core.ES6Iterator.prototype.next=function(){var self__=this;var _=this;if(!(self__.s==null)){var x=cljs.core.first(self__.s);self__.s=cljs.core.next(self__.s);return{"value":x,"done":false}}else return{"value":null,"done":true}};
cljs.core.ES6Iterator.getBasis=function(){return new cljs.core.PersistentVector(null,1,5,cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null))],null)};cljs.core.ES6Iterator.cljs$lang$type=true;cljs.core.ES6Iterator.cljs$lang$ctorStr="cljs.core/ES6Iterator";
cljs.core.ES6Iterator.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/ES6Iterator")};cljs.core.__GT_ES6Iterator=function cljs$core$__GT_ES6Iterator(s){return new cljs.core.ES6Iterator(s)};cljs.core.es6_iterator=function cljs$core$es6_iterator(coll){return new cljs.core.ES6Iterator(cljs.core.seq(coll))};
cljs.core.ES6IteratorSeq=function(value,iter,_rest){this.value=value;this.iter=iter;this._rest=_rest;this.cljs$lang$protocol_mask$partition0$=8388672;this.cljs$lang$protocol_mask$partition1$=0};cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1=function(this$){var self__=this;var this$__$1=this;return this$__$1};cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1=function(_){var self__=this;var ___$1=this;return self__.value};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1=function(_){var self__=this;var ___$1=this;if(self__._rest==null)self__._rest=cljs.core.es6_iterator_seq(self__.iter);else;return self__._rest};
cljs.core.ES6IteratorSeq.getBasis=function(){return new cljs.core.PersistentVector(null,3,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"iter","iter",-1346195486,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_rest","_rest",-2100466189,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null))],null)};cljs.core.ES6IteratorSeq.cljs$lang$type=true;
cljs.core.ES6IteratorSeq.cljs$lang$ctorStr="cljs.core/ES6IteratorSeq";cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/ES6IteratorSeq")};cljs.core.__GT_ES6IteratorSeq=function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){return new cljs.core.ES6IteratorSeq(value,iter,_rest)};
cljs.core.es6_iterator_seq=function cljs$core$es6_iterator_seq(iter){var v=iter.next();if(cljs.core.truth_(v.done))return cljs.core.List.EMPTY;else return new cljs.core.ES6IteratorSeq(v.value,iter,null)};cljs.core.mix_collection_hash=function cljs$core$mix_collection_hash(hash_basis,count){var h1=cljs.core.m3_seed;var k1=cljs.core.m3_mix_K1(hash_basis);var h1__$1=cljs.core.m3_mix_H1(h1,k1);return cljs.core.m3_fmix(h1__$1,count)};
cljs.core.hash_ordered_coll=function cljs$core$hash_ordered_coll(coll){var n=0;var hash_code=1;var coll__$1=cljs.core.seq(coll);while(true){if(!(coll__$1==null)){var G__9506=n+1;var G__9507=cljs.core.imul(31,hash_code)+cljs.core.hash(cljs.core.first(coll__$1))|0;var G__9508=cljs.core.next(coll__$1);n=G__9506;hash_code=G__9507;coll__$1=G__9508;continue}else return cljs.core.mix_collection_hash(hash_code,n);break}};cljs.core.empty_ordered_hash=cljs.core.mix_collection_hash(1,0);
cljs.core.hash_unordered_coll=function cljs$core$hash_unordered_coll(coll){var n=0;var hash_code=0;var coll__$1=cljs.core.seq(coll);while(true){if(!(coll__$1==null)){var G__9509=n+1;var G__9510=hash_code+cljs.core.hash(cljs.core.first(coll__$1))|0;var G__9511=cljs.core.next(coll__$1);n=G__9509;hash_code=G__9510;coll__$1=G__9511;continue}else return cljs.core.mix_collection_hash(hash_code,n);break}};cljs.core.empty_unordered_hash=cljs.core.mix_collection_hash(0,0);cljs.core.ICounted["null"]=true;
cljs.core._count["null"]=function(_){return 0};Date.prototype.cljs$core$IEquiv$=cljs.core.PROTOCOL_SENTINEL;Date.prototype.cljs$core$IEquiv$_equiv$arity$2=function(o,other){var o__$1=this;return other instanceof Date&&o__$1.valueOf()===other.valueOf()};Date.prototype.cljs$core$IComparable$=cljs.core.PROTOCOL_SENTINEL;
Date.prototype.cljs$core$IComparable$_compare$arity$2=function(this$,other){var this$__$1=this;if(other instanceof Date){var G__9512=this$__$1.valueOf();var G__9513=other.valueOf();return goog.array.defaultCompare(G__9512,G__9513)}else throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Cannot compare "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" to "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(other)].join(""));};
cljs.core.Inst=function(){};
cljs.core.inst_ms_STAR_=function cljs$core$inst_ms_STAR_(inst){if(!(inst==null)&&!(inst.cljs$core$Inst$inst_ms_STAR_$arity$1==null))return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);else{var x__7954__auto__=inst==null?null:inst;var m__7955__auto__=cljs.core.inst_ms_STAR_[goog.typeOf(x__7954__auto__)];if(!(m__7955__auto__==null))return m__7955__auto__.cljs$core$IFn$_invoke$arity$1?m__7955__auto__.cljs$core$IFn$_invoke$arity$1(inst):m__7955__auto__.call(null,inst);else{var m__7955__auto____$1=cljs.core.inst_ms_STAR_["_"];
if(!(m__7955__auto____$1==null))return m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1?m__7955__auto____$1.cljs$core$IFn$_invoke$arity$1(inst):m__7955__auto____$1.call(null,inst);else throw cljs.core.missing_protocol("Inst.inst-ms*",inst);}}};Date.prototype.cljs$core$Inst$=cljs.core.PROTOCOL_SENTINEL;Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1=function(inst){var inst__$1=this;return inst__$1.getTime()};cljs.core.inst_ms=function cljs$core$inst_ms(inst){return cljs.core.inst_ms_STAR_(inst)};
cljs.core.inst_QMARK_=function cljs$core$inst_QMARK_(x){if(!(x==null))if(false||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$Inst$)return true;else if(!x.cljs$lang$protocol_mask$partition$)return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x)};cljs.core.IEquiv["number"]=true;cljs.core._equiv["number"]=function(x,o){return x===o};cljs.core.Fn["function"]=true;cljs.core.IMeta["function"]=true;
cljs.core._meta["function"]=function(_){return null};cljs.core.IHash["_"]=true;cljs.core._hash["_"]=function(o){return goog.getUid(o)};cljs.core.inc=function cljs$core$inc(x){return x+1};cljs.core.Reduced=function(val){this.val=val;this.cljs$lang$protocol_mask$partition0$=32768;this.cljs$lang$protocol_mask$partition1$=0};cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1=function(o){var self__=this;var o__$1=this;return self__.val};
cljs.core.Reduced.getBasis=function(){return new cljs.core.PersistentVector(null,1,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"val","val",1769233139,null)],null)};cljs.core.Reduced.cljs$lang$type=true;cljs.core.Reduced.cljs$lang$ctorStr="cljs.core/Reduced";cljs.core.Reduced.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/Reduced")};cljs.core.__GT_Reduced=function cljs$core$__GT_Reduced(val){return new cljs.core.Reduced(val)};
cljs.core.reduced=function cljs$core$reduced(x){return new cljs.core.Reduced(x)};cljs.core.reduced_QMARK_=function cljs$core$reduced_QMARK_(r){return r instanceof cljs.core.Reduced};cljs.core.ensure_reduced=function cljs$core$ensure_reduced(x){if(cljs.core.reduced_QMARK_(x))return x;else return cljs.core.reduced(x)};cljs.core.unreduced=function cljs$core$unreduced(x){if(cljs.core.reduced_QMARK_(x))return cljs.core.deref(x);else return x};cljs.core.deref=function cljs$core$deref(o){return cljs.core._deref(o)};
cljs.core.ci_reduce=function cljs$core$ci_reduce(var_args){var G__9516=arguments.length;switch(G__9516){case 2:return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),
cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2=function(cicoll,f){var cnt=cljs.core._count(cicoll);if(cnt===0)return f.cljs$core$IFn$_invoke$arity$0?f.cljs$core$IFn$_invoke$arity$0():f.call(null);else{var val=cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,0);var n=1;while(true){if(n<cnt){var nval=function(){var G__9517=val;var G__9518=cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__9517,G__9518):f.call(null,G__9517,
G__9518)}();if(cljs.core.reduced_QMARK_(nval))return cljs.core.deref(nval);else{var G__9524=nval;var G__9525=n+1;val=G__9524;n=G__9525;continue}}else return val;break}}};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3=function(cicoll,f,val){var cnt=cljs.core._count(cicoll);var val__$1=val;var n=0;while(true){if(n<cnt){var nval=function(){var G__9519=val__$1;var G__9520=cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__9519,G__9520):f.call(null,G__9519,G__9520)}();if(cljs.core.reduced_QMARK_(nval))return cljs.core.deref(nval);else{var G__9526=nval;var G__9527=n+1;val__$1=G__9526;n=G__9527;
continue}}else return val__$1;break}};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4=function(cicoll,f,val,idx){var cnt=cljs.core._count(cicoll);var val__$1=val;var n=idx;while(true){if(n<cnt){var nval=function(){var G__9521=val__$1;var G__9522=cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__9521,G__9522):f.call(null,G__9521,G__9522)}();if(cljs.core.reduced_QMARK_(nval))return cljs.core.deref(nval);else{var G__9528=nval;var G__9529=n+1;val__$1=G__9528;
n=G__9529;continue}}else return val__$1;break}};cljs.core.ci_reduce.cljs$lang$maxFixedArity=4;
cljs.core.array_reduce=function cljs$core$array_reduce(var_args){var G__9531=arguments.length;switch(G__9531){case 2:return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),
cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2=function(arr,f){var cnt=arr.length;if(arr.length===0)return f.cljs$core$IFn$_invoke$arity$0?f.cljs$core$IFn$_invoke$arity$0():f.call(null);else{var val=arr[0];var n=1;while(true){if(n<cnt){var nval=function(){var G__9532=val;var G__9533=arr[n];return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__9532,G__9533):f.call(null,G__9532,G__9533)}();if(cljs.core.reduced_QMARK_(nval))return cljs.core.deref(nval);else{var G__9539=nval;
var G__9540=n+1;val=G__9539;n=G__9540;continue}}else return val;break}}};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3=function(arr,f,val){var cnt=arr.length;var val__$1=val;var n=0;while(true){if(n<cnt){var nval=function(){var G__9534=val__$1;var G__9535=arr[n];return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__9534,G__9535):f.call(null,G__9534,G__9535)}();if(cljs.core.reduced_QMARK_(nval))return cljs.core.deref(nval);else{var G__9541=nval;var G__9542=n+1;val__$1=G__9541;n=G__9542;continue}}else return val__$1;break}};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4=function(arr,f,val,idx){var cnt=arr.length;var val__$1=val;var n=idx;while(true){if(n<cnt){var nval=function(){var G__9536=val__$1;var G__9537=arr[n];return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__9536,G__9537):f.call(null,G__9536,G__9537)}();if(cljs.core.reduced_QMARK_(nval))return cljs.core.deref(nval);else{var G__9543=nval;var G__9544=n+1;val__$1=G__9543;n=G__9544;continue}}else return val__$1;break}};
cljs.core.array_reduce.cljs$lang$maxFixedArity=4;cljs.core.counted_QMARK_=function cljs$core$counted_QMARK_(x){if(!(x==null))if(x.cljs$lang$protocol_mask$partition0$&2||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$ICounted$)return true;else if(!x.cljs$lang$protocol_mask$partition0$)return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x)};
cljs.core.indexed_QMARK_=function cljs$core$indexed_QMARK_(x){if(!(x==null))if(x.cljs$lang$protocol_mask$partition0$&16||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$IIndexed$)return true;else if(!x.cljs$lang$protocol_mask$partition0$)return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x)};
cljs.core._indexOf=function cljs$core$_indexOf(var_args){var G__9548=arguments.length;switch(G__9548){case 2:return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2=function(coll,x){return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,0)};
cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3=function(coll,x,start){var len=cljs.core.count(coll);if(start>=len)return-1;else{var idx=start>0?start:start<0?function(){var x__7621__auto__=0;var y__7622__auto__=start+len;return x__7621__auto__>y__7622__auto__?x__7621__auto__:y__7622__auto__}():start;while(true){if(idx<len)if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx),x))return idx;else{var G__9550=idx+1;idx=G__9550;continue}else return-1;break}}};
cljs.core._indexOf.cljs$lang$maxFixedArity=3;
cljs.core._lastIndexOf=function cljs$core$_lastIndexOf(var_args){var G__9552=arguments.length;switch(G__9552){case 2:return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2=function(coll,x){return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll))};
cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3=function(coll,x,start){var len=cljs.core.count(coll);if(len===0)return-1;else{var idx=start>0?function(){var x__7628__auto__=len-1;var y__7629__auto__=start;return x__7628__auto__<y__7629__auto__?x__7628__auto__:y__7629__auto__}():start<0?len+start:start;while(true){if(idx>=0)if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx),x))return idx;else{var G__9554=idx-1;idx=G__9554;continue}else return-1;
break}}};cljs.core._lastIndexOf.cljs$lang$maxFixedArity=3;cljs.core.IndexedSeqIterator=function(arr,i){this.arr=arr;this.i=i};cljs.core.IndexedSeqIterator.prototype.hasNext=function(){var self__=this;var _=this;return self__.i<self__.arr.length};cljs.core.IndexedSeqIterator.prototype.next=function(){var self__=this;var _=this;var ret=self__.arr[self__.i];self__.i=self__.i+1;return ret};
cljs.core.IndexedSeqIterator.getBasis=function(){return new cljs.core.PersistentVector(null,2,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null))],null)};cljs.core.IndexedSeqIterator.cljs$lang$type=true;cljs.core.IndexedSeqIterator.cljs$lang$ctorStr="cljs.core/IndexedSeqIterator";
cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/IndexedSeqIterator")};cljs.core.__GT_IndexedSeqIterator=function cljs$core$__GT_IndexedSeqIterator(arr,i){return new cljs.core.IndexedSeqIterator(arr,i)};
cljs.core.IndexedSeq=function(arr,i,meta){this.arr=arr;this.i=i;this.meta=meta;this.cljs$lang$protocol_mask$partition0$=166592766;this.cljs$lang$protocol_mask$partition1$=139264};cljs.core.IndexedSeq.prototype.toString=function(){var self__=this;var coll=this;return cljs.core.pr_str_STAR_(coll)};cljs.core.IndexedSeq.prototype.equiv=function(other){var self__=this;var this$=this;return this$.cljs$core$IEquiv$_equiv$arity$2(null,other)};
cljs.core.IndexedSeq.prototype.indexOf=function(){var G__9555=null;var G__9555__1=function(x){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,0)};var G__9555__2=function(x,start){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__9555=function(x,start){switch(arguments.length){case 1:return G__9555__1.call(this,x);case 2:return G__9555__2.call(this,x,start)}throw new Error("Invalid arity: "+(arguments.length-
1));};G__9555.cljs$core$IFn$_invoke$arity$1=G__9555__1;G__9555.cljs$core$IFn$_invoke$arity$2=G__9555__2;return G__9555}();
cljs.core.IndexedSeq.prototype.lastIndexOf=function(){var G__9556=null;var G__9556__1=function(x){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll))};var G__9556__2=function(x,start){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__9556=function(x,start){switch(arguments.length){case 1:return G__9556__1.call(this,x);case 2:return G__9556__2.call(this,x,start)}throw new Error("Invalid arity: "+
(arguments.length-1));};G__9556.cljs$core$IFn$_invoke$arity$1=G__9556__1;G__9556.cljs$core$IFn$_invoke$arity$2=G__9556__2;return G__9556}();cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2=function(coll,n){var self__=this;var coll__$1=this;var i__$1=n+self__.i;if(0<=i__$1&&i__$1<self__.arr.length)return self__.arr[i__$1];else throw new Error("Index out of bounds");};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3=function(coll,n,not_found){var self__=this;var coll__$1=this;var i__$1=n+self__.i;if(0<=i__$1&&i__$1<self__.arr.length)return self__.arr[i__$1];else return not_found};cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1=function(coll){var self__=this;var coll__$1=this;return new cljs.core.IndexedSeqIterator(self__.arr,self__.i)};
cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.meta};cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1=function(_){var self__=this;var ___$1=this;return new cljs.core.IndexedSeq(self__.arr,self__.i,self__.meta)};
cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1=function(_){var self__=this;var ___$1=this;if(self__.i+1<self__.arr.length)return new cljs.core.IndexedSeq(self__.arr,self__.i+1,null);else return null};cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1=function(_){var self__=this;var ___$1=this;var x__7621__auto__=0;var y__7622__auto__=self__.arr.length-self__.i;return x__7621__auto__>y__7622__auto__?x__7621__auto__:y__7622__auto__};
cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1=function(coll){var self__=this;var coll__$1=this;var c=coll__$1.cljs$core$ICounted$_count$arity$1(null);if(c>0)return new cljs.core.RSeq(coll__$1,c-1,null);else return null};cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1=function(coll){var self__=this;var coll__$1=this;return cljs.core.hash_ordered_coll(coll__$1)};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2=function(coll,other){var self__=this;var coll__$1=this;return cljs.core.equiv_sequential(coll__$1,other)};cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1=function(coll){var self__=this;var coll__$1=this;return cljs.core.List.EMPTY};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2=function(coll,f){var self__=this;var coll__$1=this;return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,self__.arr[self__.i],self__.i+1)};cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3=function(coll,f,start){var self__=this;var coll__$1=this;return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i)};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1=function(_){var self__=this;var ___$1=this;return self__.arr[self__.i]};cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1=function(_){var self__=this;var ___$1=this;if(self__.i+1<self__.arr.length)return new cljs.core.IndexedSeq(self__.arr,self__.i+1,null);else return cljs.core.List.EMPTY};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1=function(this$){var self__=this;var this$__$1=this;if(self__.i<self__.arr.length)return this$__$1;else return null};cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2=function(coll,new_meta){var self__=this;var coll__$1=this;return new cljs.core.IndexedSeq(self__.arr,self__.i,new_meta)};
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2=function(coll,o){var self__=this;var coll__$1=this;return cljs.core.cons(o,coll__$1)};cljs.core.IndexedSeq.getBasis=function(){return new cljs.core.PersistentVector(null,3,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)],null)};cljs.core.IndexedSeq.cljs$lang$type=true;
cljs.core.IndexedSeq.cljs$lang$ctorStr="cljs.core/IndexedSeq";cljs.core.IndexedSeq.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/IndexedSeq")};cljs.core.__GT_IndexedSeq=function cljs$core$__GT_IndexedSeq(arr,i,meta){return new cljs.core.IndexedSeq(arr,i,meta)};cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL]=function(){var this__8311__auto__=this;return cljs.core.es6_iterator(this__8311__auto__)};
cljs.core.prim_seq=function cljs$core$prim_seq(var_args){var G__9558=arguments.length;switch(G__9558){case 1:return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1=function(prim){return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,0)};cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2=function(prim,i){if(i<prim.length)return new cljs.core.IndexedSeq(prim,i,null);else return null};cljs.core.prim_seq.cljs$lang$maxFixedArity=2;
cljs.core.array_seq=function cljs$core$array_seq(var_args){var G__9561=arguments.length;switch(G__9561){case 1:return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1=function(array){return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,0)};cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2=function(array,i){return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i)};cljs.core.array_seq.cljs$lang$maxFixedArity=2;cljs.core.RSeq=function(ci,i,meta){this.ci=ci;this.i=i;this.meta=meta;this.cljs$lang$protocol_mask$partition0$=32374990;this.cljs$lang$protocol_mask$partition1$=8192};
cljs.core.RSeq.prototype.toString=function(){var self__=this;var coll=this;return cljs.core.pr_str_STAR_(coll)};cljs.core.RSeq.prototype.equiv=function(other){var self__=this;var this$=this;return this$.cljs$core$IEquiv$_equiv$arity$2(null,other)};
cljs.core.RSeq.prototype.indexOf=function(){var G__9563=null;var G__9563__1=function(x){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,0)};var G__9563__2=function(x,start){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__9563=function(x,start){switch(arguments.length){case 1:return G__9563__1.call(this,x);case 2:return G__9563__2.call(this,x,start)}throw new Error("Invalid arity: "+(arguments.length-
1));};G__9563.cljs$core$IFn$_invoke$arity$1=G__9563__1;G__9563.cljs$core$IFn$_invoke$arity$2=G__9563__2;return G__9563}();
cljs.core.RSeq.prototype.lastIndexOf=function(){var G__9564=null;var G__9564__1=function(x){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll))};var G__9564__2=function(x,start){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__9564=function(x,start){switch(arguments.length){case 1:return G__9564__1.call(this,x);case 2:return G__9564__2.call(this,x,start)}throw new Error("Invalid arity: "+
(arguments.length-1));};G__9564.cljs$core$IFn$_invoke$arity$1=G__9564__1;G__9564.cljs$core$IFn$_invoke$arity$2=G__9564__2;return G__9564}();cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.meta};cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1=function(_){var self__=this;var ___$1=this;return new cljs.core.RSeq(self__.ci,self__.i,self__.meta)};
cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1=function(coll){var self__=this;var coll__$1=this;if(self__.i>0)return new cljs.core.RSeq(self__.ci,self__.i-1,null);else return null};cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.i+1};cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1=function(coll){var self__=this;var coll__$1=this;return cljs.core.hash_ordered_coll(coll__$1)};
cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2=function(coll,other){var self__=this;var coll__$1=this;return cljs.core.equiv_sequential(coll__$1,other)};cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1=function(coll){var self__=this;var coll__$1=this;return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta)};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2=function(col,f){var self__=this;var col__$1=this;return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,col__$1)};cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3=function(col,f,start){var self__=this;var col__$1=this;return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,col__$1)};
cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1=function(coll){var self__=this;var coll__$1=this;return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i)};cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1=function(coll){var self__=this;var coll__$1=this;if(self__.i>0)return new cljs.core.RSeq(self__.ci,self__.i-1,null);else return cljs.core.List.EMPTY};cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1=function(coll){var self__=this;var coll__$1=this;return coll__$1};
cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2=function(coll,new_meta){var self__=this;var coll__$1=this;return new cljs.core.RSeq(self__.ci,self__.i,new_meta)};cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2=function(coll,o){var self__=this;var coll__$1=this;return cljs.core.cons(o,coll__$1)};
cljs.core.RSeq.getBasis=function(){return new cljs.core.PersistentVector(null,3,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"ci","ci",2049808339,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)],null)};cljs.core.RSeq.cljs$lang$type=true;cljs.core.RSeq.cljs$lang$ctorStr="cljs.core/RSeq";
cljs.core.RSeq.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/RSeq")};cljs.core.__GT_RSeq=function cljs$core$__GT_RSeq(ci,i,meta){return new cljs.core.RSeq(ci,i,meta)};cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL]=function(){var this__8311__auto__=this;return cljs.core.es6_iterator(this__8311__auto__)};cljs.core.second=function cljs$core$second(coll){return cljs.core.first(cljs.core.next(coll))};
cljs.core.ffirst=function cljs$core$ffirst(coll){return cljs.core.first(cljs.core.first(coll))};cljs.core.nfirst=function cljs$core$nfirst(coll){return cljs.core.next(cljs.core.first(coll))};cljs.core.fnext=function cljs$core$fnext(coll){return cljs.core.first(cljs.core.next(coll))};cljs.core.nnext=function cljs$core$nnext(coll){return cljs.core.next(cljs.core.next(coll))};
cljs.core.last=function cljs$core$last(s){while(true){var sn=cljs.core.next(s);if(!(sn==null)){var G__9565=sn;s=G__9565;continue}else return cljs.core.first(s);break}};cljs.core.IEquiv["_"]=true;cljs.core._equiv["_"]=function(x,o){return x===o};
cljs.core.conj=function cljs$core$conj(var_args){var G__9570=arguments.length;switch(G__9570){case 0:return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();break;case 1:return cljs.core.conj.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9572=arguments.length;var i__8411__auto___9573=0;while(true){if(i__8411__auto___9573<len__8410__auto___9572){args_arr__8429__auto__.push(arguments[i__8411__auto___9573]);
var G__9574=i__8411__auto___9573+1;i__8411__auto___9573=G__9574;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.conj.cljs$core$IFn$_invoke$arity$0=function(){return cljs.core.PersistentVector.EMPTY};cljs.core.conj.cljs$core$IFn$_invoke$arity$1=function(coll){return coll};
cljs.core.conj.cljs$core$IFn$_invoke$arity$2=function(coll,x){if(!(coll==null))return cljs.core._conj(coll,x);else{var x__8128__auto__=x;return cljs.core._conj(cljs.core.List.EMPTY,x__8128__auto__)}};
cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic=function(coll,x,xs){while(true){if(cljs.core.truth_(xs)){var G__9575=cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);var G__9576=cljs.core.first(xs);var G__9577=cljs.core.next(xs);coll=G__9575;x=G__9576;xs=G__9577;continue}else return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);break}};
cljs.core.conj.cljs$lang$applyTo=function(seq9567){var G__9568=cljs.core.first(seq9567);var seq9567__$1=cljs.core.next(seq9567);var G__9569=cljs.core.first(seq9567__$1);var seq9567__$2=cljs.core.next(seq9567__$1);return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(G__9568,G__9569,seq9567__$2)};cljs.core.conj.cljs$lang$maxFixedArity=2;cljs.core.empty=function cljs$core$empty(coll){if(coll==null)return null;else return cljs.core._empty(coll)};
cljs.core.accumulating_seq_count=function cljs$core$accumulating_seq_count(coll){var s=cljs.core.seq(coll);var acc=0;while(true){if(cljs.core.counted_QMARK_(s))return acc+cljs.core._count(s);else{var G__9578=cljs.core.next(s);var G__9579=acc+1;s=G__9578;acc=G__9579;continue}break}};
cljs.core.count=function cljs$core$count(coll){if(!(coll==null))if(!(coll==null)?coll.cljs$lang$protocol_mask$partition0$&2||cljs.core.PROTOCOL_SENTINEL===coll.cljs$core$ICounted$?true:false:false)return coll.cljs$core$ICounted$_count$arity$1(null);else if(cljs.core.array_QMARK_(coll))return coll.length;else if(typeof coll==="string")return coll.length;else if(!(coll==null)?coll.cljs$lang$protocol_mask$partition0$&8388608||cljs.core.PROTOCOL_SENTINEL===coll.cljs$core$ISeqable$?true:false:false)return cljs.core.accumulating_seq_count(coll);
else return cljs.core._count(coll);else return 0};
cljs.core.linear_traversal_nth=function cljs$core$linear_traversal_nth(var_args){var G__9583=arguments.length;switch(G__9583){case 2:return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2=function(coll,n){while(true){if(coll==null)throw new Error("Index out of bounds");else if(n===0)if(cljs.core.seq(coll))return cljs.core.first(coll);else throw new Error("Index out of bounds");else if(cljs.core.indexed_QMARK_(coll))return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);else if(cljs.core.seq(coll)){var G__9585=cljs.core.next(coll);var G__9586=n-1;coll=G__9585;n=G__9586;continue}else throw new Error("Index out of bounds");
break}};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3=function(coll,n,not_found){while(true){if(coll==null)return not_found;else if(n===0)if(cljs.core.seq(coll))return cljs.core.first(coll);else return not_found;else if(cljs.core.indexed_QMARK_(coll))return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);else if(cljs.core.seq(coll)){var G__9587=cljs.core.next(coll);var G__9588=n-1;var G__9589=not_found;coll=G__9587;n=G__9588;not_found=G__9589;continue}else return not_found;break}};
cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity=3;
cljs.core.nth=function cljs$core$nth(var_args){var G__9591=arguments.length;switch(G__9591){case 2:return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.nth.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.nth.cljs$core$IFn$_invoke$arity$2=function(coll,n){if(!(typeof n==="number"))throw new Error("Index argument to nth must be a number");else if(coll==null)return coll;else if(!(coll==null)?coll.cljs$lang$protocol_mask$partition0$&16||cljs.core.PROTOCOL_SENTINEL===coll.cljs$core$IIndexed$?true:false:false)return coll.cljs$core$IIndexed$_nth$arity$2(null,n);else if(cljs.core.array_QMARK_(coll))if(n>=0&&n<coll.length)return coll[n];else throw new Error("Index out of bounds");else if(typeof coll===
"string")if(n>=0&&n<coll.length)return coll.charAt(n);else throw new Error("Index out of bounds");else if(!(coll==null)?coll.cljs$lang$protocol_mask$partition0$&64||cljs.core.PROTOCOL_SENTINEL===coll.cljs$core$ISeq$?true:false:false)return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);else if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll))return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);else throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("nth not supported on this type "),
cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));};
cljs.core.nth.cljs$core$IFn$_invoke$arity$3=function(coll,n,not_found){if(!(typeof n==="number"))throw new Error("Index argument to nth must be a number.");else if(coll==null)return not_found;else if(!(coll==null)?coll.cljs$lang$protocol_mask$partition0$&16||cljs.core.PROTOCOL_SENTINEL===coll.cljs$core$IIndexed$?true:false:false)return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);else if(cljs.core.array_QMARK_(coll))if(n>=0&&n<coll.length)return coll[n];else return not_found;else if(typeof coll===
"string")if(n>=0&&n<coll.length)return coll.charAt(n);else return not_found;else if(!(coll==null)?coll.cljs$lang$protocol_mask$partition0$&64||cljs.core.PROTOCOL_SENTINEL===coll.cljs$core$ISeq$?true:false:false)return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);else if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll))return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);else throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("nth not supported on this type "),
cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));};cljs.core.nth.cljs$lang$maxFixedArity=3;cljs.core.nthrest=function cljs$core$nthrest(coll,n){var n__$1=n;var xs=coll;while(true){if(n__$1>0&&cljs.core.seq(xs)){var G__9597=n__$1-1;var G__9598=cljs.core.rest(xs);n__$1=G__9597;xs=G__9598;continue}else return xs;break}};
cljs.core.get=function cljs$core$get(var_args){var G__9600=arguments.length;switch(G__9600){case 2:return cljs.core.get.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.get.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.get.cljs$core$IFn$_invoke$arity$2=function(o,k){if(o==null)return null;else if(!(o==null)?o.cljs$lang$protocol_mask$partition0$&256||cljs.core.PROTOCOL_SENTINEL===o.cljs$core$ILookup$?true:false:false)return o.cljs$core$ILookup$_lookup$arity$2(null,k);else if(cljs.core.array_QMARK_(o))if(!(k==null)&&k<o.length)return o[k|0];else return null;else if(typeof o==="string")if(!(k==null)&&k<o.length)return o.charAt(k|0);else return null;else if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,
o))return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);else return null};
cljs.core.get.cljs$core$IFn$_invoke$arity$3=function(o,k,not_found){if(!(o==null))if(!(o==null)?o.cljs$lang$protocol_mask$partition0$&256||cljs.core.PROTOCOL_SENTINEL===o.cljs$core$ILookup$?true:false:false)return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);else if(cljs.core.array_QMARK_(o))if(!(k==null)&&k>=0&&k<o.length)return o[k|0];else return not_found;else if(typeof o==="string")if(!(k==null)&&k>=0&&k<o.length)return o.charAt(k|0);else return not_found;else if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,
o))return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);else return not_found;else return not_found};cljs.core.get.cljs$lang$maxFixedArity=3;
cljs.core.assoc=function cljs$core$assoc(var_args){var G__9609=arguments.length;switch(G__9609){case 3:return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9611=arguments.length;var i__8411__auto___9612=0;while(true){if(i__8411__auto___9612<len__8410__auto___9611){args_arr__8429__auto__.push(arguments[i__8411__auto___9612]);var G__9613=i__8411__auto___9612+1;i__8411__auto___9612=G__9613;continue}else;
break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(3),0,null);return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],arguments[2],argseq__8430__auto__)}};cljs.core.assoc.cljs$core$IFn$_invoke$arity$3=function(coll,k,v){if(!(coll==null))return cljs.core._assoc(coll,k,v);else return cljs.core.PersistentArrayMap.createAsIfByAssoc([k,v])};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic=function(coll,k,v,kvs){while(true){var ret=cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);if(cljs.core.truth_(kvs)){var G__9614=ret;var G__9615=cljs.core.first(kvs);var G__9616=cljs.core.second(kvs);var G__9617=cljs.core.nnext(kvs);coll=G__9614;k=G__9615;v=G__9616;kvs=G__9617;continue}else return ret;break}};
cljs.core.assoc.cljs$lang$applyTo=function(seq9605){var G__9606=cljs.core.first(seq9605);var seq9605__$1=cljs.core.next(seq9605);var G__9607=cljs.core.first(seq9605__$1);var seq9605__$2=cljs.core.next(seq9605__$1);var G__9608=cljs.core.first(seq9605__$2);var seq9605__$3=cljs.core.next(seq9605__$2);return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__9606,G__9607,G__9608,seq9605__$3)};cljs.core.assoc.cljs$lang$maxFixedArity=3;
cljs.core.dissoc=function cljs$core$dissoc(var_args){var G__9622=arguments.length;switch(G__9622){case 1:return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9624=arguments.length;var i__8411__auto___9625=0;while(true){if(i__8411__auto___9625<len__8410__auto___9624){args_arr__8429__auto__.push(arguments[i__8411__auto___9625]);
var G__9626=i__8411__auto___9625+1;i__8411__auto___9625=G__9626;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1=function(coll){return coll};cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2=function(coll,k){if(coll==null)return null;else return cljs.core._dissoc(coll,k)};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic=function(coll,k,ks){while(true){if(coll==null)return null;else{var ret=cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);if(cljs.core.truth_(ks)){var G__9627=ret;var G__9628=cljs.core.first(ks);var G__9629=cljs.core.next(ks);coll=G__9627;k=G__9628;ks=G__9629;continue}else return ret}break}};
cljs.core.dissoc.cljs$lang$applyTo=function(seq9619){var G__9620=cljs.core.first(seq9619);var seq9619__$1=cljs.core.next(seq9619);var G__9621=cljs.core.first(seq9619__$1);var seq9619__$2=cljs.core.next(seq9619__$1);return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__9620,G__9621,seq9619__$2)};cljs.core.dissoc.cljs$lang$maxFixedArity=2;
cljs.core.fn_QMARK_=function cljs$core$fn_QMARK_(f){var or__7285__auto__=goog.isFunction(f);if(or__7285__auto__)return or__7285__auto__;else if(!(f==null))if(false||cljs.core.PROTOCOL_SENTINEL===f.cljs$core$Fn$)return true;else if(!f.cljs$lang$protocol_mask$partition$)return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f)};
cljs.core.MetaFn=function(afn,meta){this.afn=afn;this.meta=meta;this.cljs$lang$protocol_mask$partition0$=393217;this.cljs$lang$protocol_mask$partition1$=0};cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1=function(_){var self__=this;var ___$1=this;return self__.meta};cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2=function(_,new_meta){var self__=this;var ___$1=this;return new cljs.core.MetaFn(self__.afn,new_meta)};cljs.core.MetaFn.prototype.cljs$core$Fn$=cljs.core.PROTOCOL_SENTINEL;
cljs.core.MetaFn.prototype.call=function(){var G__9633=null;var G__9633__1=function(self__){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$0?self__.afn.cljs$core$IFn$_invoke$arity$0():self__.afn.call(null)};var G__9633__2=function(self__,a){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$1?self__.afn.cljs$core$IFn$_invoke$arity$1(a):self__.afn.call(null,a)};var G__9633__3=function(self__,a,b){var self__=
this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$2?self__.afn.cljs$core$IFn$_invoke$arity$2(a,b):self__.afn.call(null,a,b)};var G__9633__4=function(self__,a,b,c){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$3?self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c):self__.afn.call(null,a,b,c)};var G__9633__5=function(self__,a,b,c,d){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$4?
self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d):self__.afn.call(null,a,b,c,d)};var G__9633__6=function(self__,a,b,c,d,e){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$5?self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e):self__.afn.call(null,a,b,c,d,e)};var G__9633__7=function(self__,a,b,c,d,e,f){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$6?self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,
d,e,f):self__.afn.call(null,a,b,c,d,e,f)};var G__9633__8=function(self__,a,b,c,d,e,f,g){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$7?self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g):self__.afn.call(null,a,b,c,d,e,f,g)};var G__9633__9=function(self__,a,b,c,d,e,f,g,h){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$8?self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h):self__.afn.call(null,
a,b,c,d,e,f,g,h)};var G__9633__10=function(self__,a,b,c,d,e,f,g,h,i){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$9?self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i):self__.afn.call(null,a,b,c,d,e,f,g,h,i)};var G__9633__11=function(self__,a,b,c,d,e,f,g,h,i,j){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$10?self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j):self__.afn.call(null,
a,b,c,d,e,f,g,h,i,j)};var G__9633__12=function(self__,a,b,c,d,e,f,g,h,i,j,k){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$11?self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k)};var G__9633__13=function(self__,a,b,c,d,e,f,g,h,i,j,k,l){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$12?self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,
g,h,i,j,k,l):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l)};var G__9633__14=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$13?self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m)};var G__9633__15=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$14?
self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n)};var G__9633__16=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$15?self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o)};var G__9633__17=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){var self__=this;var self____$1=
this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$16?self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p)};var G__9633__18=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$17?self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q)};
var G__9633__19=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$18?self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r)};var G__9633__20=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$19?self__.afn.cljs$core$IFn$_invoke$arity$19(a,
b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s)};var G__9633__21=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){var self__=this;var self____$1=this;var _=self____$1;return self__.afn.cljs$core$IFn$_invoke$arity$20?self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t)};var G__9633__22=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){var self__=
this;var self____$1=this;var _=self____$1;return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn,a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest],0))};G__9633=function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){switch(arguments.length){case 1:return G__9633__1.call(this,self__);case 2:return G__9633__2.call(this,self__,a);case 3:return G__9633__3.call(this,self__,a,b);case 4:return G__9633__4.call(this,self__,a,b,c);case 5:return G__9633__5.call(this,
self__,a,b,c,d);case 6:return G__9633__6.call(this,self__,a,b,c,d,e);case 7:return G__9633__7.call(this,self__,a,b,c,d,e,f);case 8:return G__9633__8.call(this,self__,a,b,c,d,e,f,g);case 9:return G__9633__9.call(this,self__,a,b,c,d,e,f,g,h);case 10:return G__9633__10.call(this,self__,a,b,c,d,e,f,g,h,i);case 11:return G__9633__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);case 12:return G__9633__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);case 13:return G__9633__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,
l);case 14:return G__9633__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);case 15:return G__9633__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);case 16:return G__9633__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);case 17:return G__9633__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);case 18:return G__9633__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);case 19:return G__9633__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);case 20:return G__9633__20.call(this,self__,
a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);case 21:return G__9633__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);case 22:return G__9633__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest)}throw new Error("Invalid arity: "+(arguments.length-1));};G__9633.cljs$core$IFn$_invoke$arity$1=G__9633__1;G__9633.cljs$core$IFn$_invoke$arity$2=G__9633__2;G__9633.cljs$core$IFn$_invoke$arity$3=G__9633__3;G__9633.cljs$core$IFn$_invoke$arity$4=G__9633__4;G__9633.cljs$core$IFn$_invoke$arity$5=
G__9633__5;G__9633.cljs$core$IFn$_invoke$arity$6=G__9633__6;G__9633.cljs$core$IFn$_invoke$arity$7=G__9633__7;G__9633.cljs$core$IFn$_invoke$arity$8=G__9633__8;G__9633.cljs$core$IFn$_invoke$arity$9=G__9633__9;G__9633.cljs$core$IFn$_invoke$arity$10=G__9633__10;G__9633.cljs$core$IFn$_invoke$arity$11=G__9633__11;G__9633.cljs$core$IFn$_invoke$arity$12=G__9633__12;G__9633.cljs$core$IFn$_invoke$arity$13=G__9633__13;G__9633.cljs$core$IFn$_invoke$arity$14=G__9633__14;G__9633.cljs$core$IFn$_invoke$arity$15=
G__9633__15;G__9633.cljs$core$IFn$_invoke$arity$16=G__9633__16;G__9633.cljs$core$IFn$_invoke$arity$17=G__9633__17;G__9633.cljs$core$IFn$_invoke$arity$18=G__9633__18;G__9633.cljs$core$IFn$_invoke$arity$19=G__9633__19;G__9633.cljs$core$IFn$_invoke$arity$20=G__9633__20;G__9633.cljs$core$IFn$_invoke$arity$21=G__9633__21;G__9633.cljs$core$IFn$_invoke$arity$22=G__9633__22;return G__9633}();
cljs.core.MetaFn.prototype.apply=function(self__,args9632){var self__=this;var self____$1=this;return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9632)))};cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0=function(){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$0?self__.afn.cljs$core$IFn$_invoke$arity$0():self__.afn.call(null)};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1=function(a){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$1?self__.afn.cljs$core$IFn$_invoke$arity$1(a):self__.afn.call(null,a)};cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2=function(a,b){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$2?self__.afn.cljs$core$IFn$_invoke$arity$2(a,b):self__.afn.call(null,a,b)};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3=function(a,b,c){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$3?self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c):self__.afn.call(null,a,b,c)};cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4=function(a,b,c,d){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$4?self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d):self__.afn.call(null,a,b,c,d)};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5=function(a,b,c,d,e){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$5?self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e):self__.afn.call(null,a,b,c,d,e)};cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6=function(a,b,c,d,e,f){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$6?self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f):self__.afn.call(null,a,b,c,d,e,f)};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7=function(a,b,c,d,e,f,g){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$7?self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g):self__.afn.call(null,a,b,c,d,e,f,g)};cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8=function(a,b,c,d,e,f,g,h){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$8?self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h):self__.afn.call(null,a,b,c,d,e,f,g,h)};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9=function(a,b,c,d,e,f,g,h,i){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$9?self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i):self__.afn.call(null,a,b,c,d,e,f,g,h,i)};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10=function(a,b,c,d,e,f,g,h,i,j){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$10?self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j)};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11=function(a,b,c,d,e,f,g,h,i,j,k){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$11?self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k)};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12=function(a,b,c,d,e,f,g,h,i,j,k,l){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$12?self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l)};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13=function(a,b,c,d,e,f,g,h,i,j,k,l,m){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$13?self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m)};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14=function(a,b,c,d,e,f,g,h,i,j,k,l,m,n){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$14?self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n)};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15=function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$15?self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o)};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16=function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$16?self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p)};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17=function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$17?self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q)};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18=function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$18?self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r)};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19=function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$19?self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s)};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20=function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){var self__=this;var _=this;return self__.afn.cljs$core$IFn$_invoke$arity$20?self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t):self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t)};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21=function(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){var self__=this;var _=this;return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn,a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest],0))};
cljs.core.MetaFn.getBasis=function(){return new cljs.core.PersistentVector(null,2,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)],null)};cljs.core.MetaFn.cljs$lang$type=true;cljs.core.MetaFn.cljs$lang$ctorStr="cljs.core/MetaFn";cljs.core.MetaFn.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/MetaFn")};
cljs.core.__GT_MetaFn=function cljs$core$__GT_MetaFn(afn,meta){return new cljs.core.MetaFn(afn,meta)};cljs.core.with_meta=function cljs$core$with_meta(o,meta){if(goog.isFunction(o))return new cljs.core.MetaFn(o,meta);else if(o==null)return null;else return cljs.core._with_meta(o,meta)};
cljs.core.meta=function cljs$core$meta(o){if(function(){var and__7273__auto__=!(o==null);if(and__7273__auto__)if(!(o==null))if(o.cljs$lang$protocol_mask$partition0$&131072||cljs.core.PROTOCOL_SENTINEL===o.cljs$core$IMeta$)return true;else if(!o.cljs$lang$protocol_mask$partition0$)return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);else return and__7273__auto__}())return cljs.core._meta(o);else return null};
cljs.core.peek=function cljs$core$peek(coll){if(coll==null)return null;else return cljs.core._peek(coll)};cljs.core.pop=function cljs$core$pop(coll){if(coll==null)return null;else return cljs.core._pop(coll)};
cljs.core.disj=function cljs$core$disj(var_args){var G__9640=arguments.length;switch(G__9640){case 1:return cljs.core.disj.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9642=arguments.length;var i__8411__auto___9643=0;while(true){if(i__8411__auto___9643<len__8410__auto___9642){args_arr__8429__auto__.push(arguments[i__8411__auto___9643]);var G__9644=
i__8411__auto___9643+1;i__8411__auto___9643=G__9644;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.disj.cljs$core$IFn$_invoke$arity$1=function(coll){return coll};cljs.core.disj.cljs$core$IFn$_invoke$arity$2=function(coll,k){if(coll==null)return null;else return cljs.core._disjoin(coll,k)};
cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic=function(coll,k,ks){while(true){if(coll==null)return null;else{var ret=cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);if(cljs.core.truth_(ks)){var G__9645=ret;var G__9646=cljs.core.first(ks);var G__9647=cljs.core.next(ks);coll=G__9645;k=G__9646;ks=G__9647;continue}else return ret}break}};
cljs.core.disj.cljs$lang$applyTo=function(seq9637){var G__9638=cljs.core.first(seq9637);var seq9637__$1=cljs.core.next(seq9637);var G__9639=cljs.core.first(seq9637__$1);var seq9637__$2=cljs.core.next(seq9637__$1);return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(G__9638,G__9639,seq9637__$2)};cljs.core.disj.cljs$lang$maxFixedArity=2;cljs.core.empty_QMARK_=function cljs$core$empty_QMARK_(coll){return coll==null||cljs.core.not(cljs.core.seq(coll))};
cljs.core.coll_QMARK_=function cljs$core$coll_QMARK_(x){if(x==null)return false;else if(!(x==null))if(x.cljs$lang$protocol_mask$partition0$&8||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$ICollection$)return true;else if(!x.cljs$lang$protocol_mask$partition0$)return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x)};
cljs.core.set_QMARK_=function cljs$core$set_QMARK_(x){if(x==null)return false;else if(!(x==null))if(x.cljs$lang$protocol_mask$partition0$&4096||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$ISet$)return true;else if(!x.cljs$lang$protocol_mask$partition0$)return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x)};
cljs.core.associative_QMARK_=function cljs$core$associative_QMARK_(x){if(!(x==null))if(x.cljs$lang$protocol_mask$partition0$&512||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$IAssociative$)return true;else if(!x.cljs$lang$protocol_mask$partition0$)return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x)};
cljs.core.ifind_QMARK_=function cljs$core$ifind_QMARK_(x){if(!(x==null))if(false||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$IFind$)return true;else if(!x.cljs$lang$protocol_mask$partition$)return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x)};
cljs.core.sequential_QMARK_=function cljs$core$sequential_QMARK_(x){if(!(x==null))if(x.cljs$lang$protocol_mask$partition0$&16777216||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$ISequential$)return true;else if(!x.cljs$lang$protocol_mask$partition0$)return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x)};
cljs.core.sorted_QMARK_=function cljs$core$sorted_QMARK_(x){if(!(x==null))if(x.cljs$lang$protocol_mask$partition0$&268435456||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$ISorted$)return true;else if(!x.cljs$lang$protocol_mask$partition0$)return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x)};
cljs.core.reduceable_QMARK_=function cljs$core$reduceable_QMARK_(x){if(!(x==null))if(x.cljs$lang$protocol_mask$partition0$&524288||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$IReduce$)return true;else if(!x.cljs$lang$protocol_mask$partition0$)return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x)};
cljs.core.map_QMARK_=function cljs$core$map_QMARK_(x){if(x==null)return false;else if(!(x==null))if(x.cljs$lang$protocol_mask$partition0$&1024||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$IMap$)return true;else if(!x.cljs$lang$protocol_mask$partition0$)return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x)};
cljs.core.record_QMARK_=function cljs$core$record_QMARK_(x){if(!(x==null))if(x.cljs$lang$protocol_mask$partition0$&67108864||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$IRecord$)return true;else if(!x.cljs$lang$protocol_mask$partition0$)return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x)};
cljs.core.vector_QMARK_=function cljs$core$vector_QMARK_(x){if(!(x==null))if(x.cljs$lang$protocol_mask$partition0$&16384||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$IVector$)return true;else if(!x.cljs$lang$protocol_mask$partition0$)return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x)};
cljs.core.chunked_seq_QMARK_=function cljs$core$chunked_seq_QMARK_(x){if(!(x==null))if(x.cljs$lang$protocol_mask$partition1$&512||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$IChunkedSeq$)return true;else return false;else return false};
cljs.core.js_obj=function cljs$core$js_obj(var_args){var G__9661=arguments.length;switch(G__9661){case 0:return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();break;default:var args_arr__8429__auto__=[];var len__8410__auto___9665=arguments.length;var i__8411__auto___9666=0;while(true){if(i__8411__auto___9666<len__8410__auto___9665){args_arr__8429__auto__.push(arguments[i__8411__auto___9666]);var G__9667=i__8411__auto___9666+1;i__8411__auto___9666=G__9667;continue}else;break}var argseq__8430__auto__=
new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(0),0,null);return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__8430__auto__)}};cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0=function(){return{}};cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic=function(keyvals){return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(goog.object.create,keyvals)};cljs.core.js_obj.cljs$lang$applyTo=function(seq9660){return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9660))};
cljs.core.js_obj.cljs$lang$maxFixedArity=0;cljs.core.js_keys=function cljs$core$js_keys(obj){var keys=[];var G__9668_9670=obj;var G__9669_9671=function(G__9668_9670,keys){return function(val,key,obj__$1){return keys.push(key)}}(G__9668_9670,keys);goog.object.forEach(G__9668_9670,G__9669_9671);return keys};cljs.core.js_delete=function cljs$core$js_delete(obj,key){return delete obj[key]};
cljs.core.array_copy=function cljs$core$array_copy(from,i,to,j,len){var i__$1=i;var j__$1=j;var len__$1=len;while(true){if(len__$1===0)return to;else{to[j__$1]=from[i__$1];var G__9672=i__$1+1;var G__9673=j__$1+1;var G__9674=len__$1-1;i__$1=G__9672;j__$1=G__9673;len__$1=G__9674;continue}break}};
cljs.core.array_copy_downward=function cljs$core$array_copy_downward(from,i,to,j,len){var i__$1=i+(len-1);var j__$1=j+(len-1);var len__$1=len;while(true){if(len__$1===0)return to;else{to[j__$1]=from[i__$1];var G__9675=i__$1-1;var G__9676=j__$1-1;var G__9677=len__$1-1;i__$1=G__9675;j__$1=G__9676;len__$1=G__9677;continue}break}};cljs.core.lookup_sentinel={};cljs.core.false_QMARK_=function cljs$core$false_QMARK_(x){return x===false};
cljs.core.true_QMARK_=function cljs$core$true_QMARK_(x){return x===true};cljs.core.boolean_QMARK_=function cljs$core$boolean_QMARK_(x){return x===true||x===false};cljs.core.undefined_QMARK_=function cljs$core$undefined_QMARK_(x){return void 0===x};
cljs.core.seq_QMARK_=function cljs$core$seq_QMARK_(s){if(s==null)return false;else if(!(s==null))if(s.cljs$lang$protocol_mask$partition0$&64||cljs.core.PROTOCOL_SENTINEL===s.cljs$core$ISeq$)return true;else if(!s.cljs$lang$protocol_mask$partition0$)return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s)};
cljs.core.seqable_QMARK_=function cljs$core$seqable_QMARK_(s){var or__7285__auto__=!(s==null)?s.cljs$lang$protocol_mask$partition0$&8388608||cljs.core.PROTOCOL_SENTINEL===s.cljs$core$ISeqable$?true:!s.cljs$lang$protocol_mask$partition0$?cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s):false:cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s);if(or__7285__auto__)return or__7285__auto__;else return cljs.core.array_QMARK_(s)||typeof s==="string"};
cljs.core.boolean$=function cljs$core$boolean(x){if(x==null)return false;else if(x===false)return false;else return true};
cljs.core.ifn_QMARK_=function cljs$core$ifn_QMARK_(f){var or__7285__auto__=cljs.core.fn_QMARK_(f);if(or__7285__auto__)return or__7285__auto__;else if(!(f==null))if(f.cljs$lang$protocol_mask$partition0$&1||cljs.core.PROTOCOL_SENTINEL===f.cljs$core$IFn$)return true;else if(!f.cljs$lang$protocol_mask$partition0$)return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f)};
cljs.core.integer_QMARK_=function cljs$core$integer_QMARK_(n){return typeof n==="number"&&!isNaN(n)&&!(n===Infinity)&&parseFloat(n)===parseInt(n,10)};cljs.core.int_QMARK_=function cljs$core$int_QMARK_(x){return cljs.core.integer_QMARK_(x)||x instanceof goog.math.Integer||x instanceof goog.math.Long};
cljs.core.pos_int_QMARK_=function cljs$core$pos_int_QMARK_(x){if(cljs.core.integer_QMARK_(x))return x>0;else if(x instanceof goog.math.Integer)return cljs.core.not(x.isNegative())&&cljs.core.not(x.isZero());else if(x instanceof goog.math.Long)return cljs.core.not(x.isNegative())&&cljs.core.not(x.isZero());else return false};
cljs.core.neg_int_QMARK_=function cljs$core$neg_int_QMARK_(x){if(cljs.core.integer_QMARK_(x))return x<0;else if(x instanceof goog.math.Integer)return x.isNegative();else if(x instanceof goog.math.Long)return x.isNegative();else return false};
cljs.core.nat_int_QMARK_=function cljs$core$nat_int_QMARK_(x){if(cljs.core.integer_QMARK_(x))return!(x<0)||x===0;else if(x instanceof goog.math.Integer){var or__7285__auto__=cljs.core.not(x.isNegative());if(or__7285__auto__)return or__7285__auto__;else return x.isZero()}else if(x instanceof goog.math.Long){var or__7285__auto__=cljs.core.not(x.isNegative());if(or__7285__auto__)return or__7285__auto__;else return x.isZero()}else return false};
cljs.core.float_QMARK_=function cljs$core$float_QMARK_(x){return typeof x==="number"};cljs.core.double_QMARK_=function cljs$core$double_QMARK_(x){return typeof x==="number"};cljs.core.infinite_QMARK_=function cljs$core$infinite_QMARK_(x){return x===Number.POSITIVE_INFINITY||x===Number.NEGATIVE_INFINITY};cljs.core.contains_QMARK_=function cljs$core$contains_QMARK_(coll,v){if(cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel)===cljs.core.lookup_sentinel)return false;else return true};
cljs.core.find=function cljs$core$find(coll,k){if(cljs.core.ifind_QMARK_(coll))return cljs.core._find(coll,k);else if(!(coll==null)&&cljs.core.associative_QMARK_(coll)&&cljs.core.contains_QMARK_(coll,k))return new cljs.core.PersistentVector(null,2,5,cljs.core.PersistentVector.EMPTY_NODE,[k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k)],null);else return null};
cljs.core.distinct_QMARK_=function cljs$core$distinct_QMARK_(var_args){var G__9689=arguments.length;switch(G__9689){case 1:return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9691=arguments.length;var i__8411__auto___9692=0;while(true){if(i__8411__auto___9692<len__8410__auto___9691){args_arr__8429__auto__.push(arguments[i__8411__auto___9692]);
var G__9693=i__8411__auto___9692+1;i__8411__auto___9692=G__9693;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1=function(x){return true};cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2=function(x,y){return!cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){if(!cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){var s=cljs.core.PersistentHashSet.createAsIfByAssoc([x,y]);var xs=more;while(true){var x__$1=cljs.core.first(xs);var etc=cljs.core.next(xs);if(cljs.core.truth_(xs))if(cljs.core.contains_QMARK_(s,x__$1))return false;else{var G__9694=cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);var G__9695=etc;s=G__9694;xs=G__9695;continue}else return true;break}}else return false};
cljs.core.distinct_QMARK_.cljs$lang$applyTo=function(seq9686){var G__9687=cljs.core.first(seq9686);var seq9686__$1=cljs.core.next(seq9686);var G__9688=cljs.core.first(seq9686__$1);var seq9686__$2=cljs.core.next(seq9686__$1);return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__9687,G__9688,seq9686__$2)};cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity=2;
cljs.core.compare=function cljs$core$compare(x,y){if(x===y)return 0;else if(x==null)return-1;else if(y==null)return 1;else if(typeof x==="number")if(typeof y==="number")return goog.array.defaultCompare(x,y);else throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Cannot compare "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" to "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join(""));else if(!(x==null)?x.cljs$lang$protocol_mask$partition1$&
2048||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$IComparable$?true:!x.cljs$lang$protocol_mask$partition1$?cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x):false:cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x))return cljs.core._compare(x,y);else if((typeof x==="string"||cljs.core.array_QMARK_(x)||x===true||x===false)&&cljs.core.type(x)===cljs.core.type(y))return goog.array.defaultCompare(x,y);else throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Cannot compare "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),
cljs.core.str.cljs$core$IFn$_invoke$arity$1(" to "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join(""));};
cljs.core.compare_indexed=function cljs$core$compare_indexed(var_args){var G__9698=arguments.length;switch(G__9698){case 2:return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 4:return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
}};cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2=function(xs,ys){var xl=cljs.core.count(xs);var yl=cljs.core.count(ys);if(xl<yl)return-1;else if(xl>yl)return 1;else if(xl===0)return 0;else return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,0)};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4=function(xs,ys,len,n){while(true){var d=cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));if(d===0&&n+1<len){var G__9700=xs;var G__9701=ys;var G__9702=len;var G__9703=n+1;xs=G__9700;ys=G__9701;len=G__9702;n=G__9703;continue}else return d;break}};cljs.core.compare_indexed.cljs$lang$maxFixedArity=4;
cljs.core.fn__GT_comparator=function cljs$core$fn__GT_comparator(f){if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare))return cljs.core.compare;else return function(x,y){var r=f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(x,y):f.call(null,x,y);if(typeof r==="number")return r;else if(cljs.core.truth_(r))return-1;else if(cljs.core.truth_(f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(y,x):f.call(null,y,x)))return 1;else return 0}};
cljs.core.sort=function cljs$core$sort(var_args){var G__9705=arguments.length;switch(G__9705){case 1:return cljs.core.sort.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.sort.cljs$core$IFn$_invoke$arity$1=function(coll){return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll)};cljs.core.sort.cljs$core$IFn$_invoke$arity$2=function(comp,coll){if(cljs.core.seq(coll)){var a=cljs.core.to_array(coll);var G__9706_9709=a;var G__9707_9710=cljs.core.fn__GT_comparator(comp);goog.array.stableSort(G__9706_9709,G__9707_9710);return cljs.core.seq(a)}else return cljs.core.List.EMPTY};cljs.core.sort.cljs$lang$maxFixedArity=2;
cljs.core.sort_by=function cljs$core$sort_by(var_args){var G__9712=arguments.length;switch(G__9712){case 2:return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2=function(keyfn,coll){return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll)};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3=function(keyfn,comp,coll){return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(function(x,y){var G__9714=keyfn.cljs$core$IFn$_invoke$arity$1?keyfn.cljs$core$IFn$_invoke$arity$1(x):keyfn.call(null,x);var G__9715=keyfn.cljs$core$IFn$_invoke$arity$1?keyfn.cljs$core$IFn$_invoke$arity$1(y):keyfn.call(null,y);var fexpr__9713=cljs.core.fn__GT_comparator(comp);return fexpr__9713.cljs$core$IFn$_invoke$arity$2?fexpr__9713.cljs$core$IFn$_invoke$arity$2(G__9714,
G__9715):fexpr__9713.call(null,G__9714,G__9715)},coll)};cljs.core.sort_by.cljs$lang$maxFixedArity=3;
cljs.core.seq_reduce=function cljs$core$seq_reduce(var_args){var G__9718=arguments.length;switch(G__9718){case 2:return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2=function(f,coll){var temp__4655__auto__=cljs.core.seq(coll);if(temp__4655__auto__){var s=temp__4655__auto__;return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.next(s))}else return f.cljs$core$IFn$_invoke$arity$0?f.cljs$core$IFn$_invoke$arity$0():f.call(null)};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3=function(f,val,coll){var val__$1=val;var coll__$1=cljs.core.seq(coll);while(true){if(coll__$1){var nval=function(){var G__9719=val__$1;var G__9720=cljs.core.first(coll__$1);return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__9719,G__9720):f.call(null,G__9719,G__9720)}();if(cljs.core.reduced_QMARK_(nval))return cljs.core.deref(nval);else{var G__9722=nval;var G__9723=cljs.core.next(coll__$1);val__$1=G__9722;coll__$1=G__9723;continue}}else return val__$1;
break}};cljs.core.seq_reduce.cljs$lang$maxFixedArity=3;cljs.core.shuffle=function cljs$core$shuffle(coll){var a=cljs.core.to_array(coll);goog.array.shuffle(a);return cljs.core.vec(a)};
cljs.core.iter_reduce=function cljs$core$iter_reduce(var_args){var G__9725=arguments.length;switch(G__9725){case 2:return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2=function(coll,f){var iter=cljs.core._iterator(coll);if(cljs.core.truth_(iter.hasNext())){var init=iter.next();var acc=init;while(true){if(iter.hasNext()){var nacc=function(){var G__9726=acc;var G__9727=iter.next();return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__9726,G__9727):f.call(null,G__9726,G__9727)}();if(cljs.core.reduced_QMARK_(nacc))return cljs.core.deref(nacc);else{var G__9731=nacc;acc=G__9731;continue}}else return acc;
break}}else return f.cljs$core$IFn$_invoke$arity$0?f.cljs$core$IFn$_invoke$arity$0():f.call(null)};
cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3=function(coll,f,init){var iter=cljs.core._iterator(coll);var acc=init;while(true){if(iter.hasNext()){var nacc=function(){var G__9728=acc;var G__9729=iter.next();return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__9728,G__9729):f.call(null,G__9728,G__9729)}();if(cljs.core.reduced_QMARK_(nacc))return cljs.core.deref(nacc);else{var G__9732=nacc;acc=G__9732;continue}}else return acc;break}};
cljs.core.iter_reduce.cljs$lang$maxFixedArity=3;
cljs.core.reduce=function cljs$core$reduce(var_args){var G__9734=arguments.length;switch(G__9734){case 2:return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$2=function(f,coll){if(!(coll==null)?coll.cljs$lang$protocol_mask$partition0$&524288||cljs.core.PROTOCOL_SENTINEL===coll.cljs$core$IReduce$?true:false:false)return coll.cljs$core$IReduce$_reduce$arity$2(null,f);else if(cljs.core.array_QMARK_(coll))return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);else if(typeof coll==="string")return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);else if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,
coll))return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);else if(cljs.core.iterable_QMARK_(coll))return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);else return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll)};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3=function(f,val,coll){if(!(coll==null)?coll.cljs$lang$protocol_mask$partition0$&524288||cljs.core.PROTOCOL_SENTINEL===coll.cljs$core$IReduce$?true:false:false)return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);else if(cljs.core.array_QMARK_(coll))return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);else if(typeof coll==="string")return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);else if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,
coll))return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);else if(cljs.core.iterable_QMARK_(coll))return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);else return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll)};cljs.core.reduce.cljs$lang$maxFixedArity=3;cljs.core.reduce_kv=function cljs$core$reduce_kv(f,init,coll){if(!(coll==null))return cljs.core._kv_reduce(coll,f,init);else return init};cljs.core.identity=function cljs$core$identity(x){return x};
cljs.core.completing=function cljs$core$completing(var_args){var G__9739=arguments.length;switch(G__9739){case 1:return cljs.core.completing.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.completing.cljs$core$IFn$_invoke$arity$1=function(f){return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity)};
cljs.core.completing.cljs$core$IFn$_invoke$arity$2=function(f,cf){return function(){var G__9741=null;var G__9741__0=function(){return f.cljs$core$IFn$_invoke$arity$0?f.cljs$core$IFn$_invoke$arity$0():f.call(null)};var G__9741__1=function(x){return cf.cljs$core$IFn$_invoke$arity$1?cf.cljs$core$IFn$_invoke$arity$1(x):cf.call(null,x)};var G__9741__2=function(x,y){return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(x,y):f.call(null,x,y)};G__9741=function(x,y){switch(arguments.length){case 0:return G__9741__0.call(this);
case 1:return G__9741__1.call(this,x);case 2:return G__9741__2.call(this,x,y)}throw new Error("Invalid arity: "+(arguments.length-1));};G__9741.cljs$core$IFn$_invoke$arity$0=G__9741__0;G__9741.cljs$core$IFn$_invoke$arity$1=G__9741__1;G__9741.cljs$core$IFn$_invoke$arity$2=G__9741__2;return G__9741}()};cljs.core.completing.cljs$lang$maxFixedArity=2;
cljs.core.transduce=function cljs$core$transduce(var_args){var G__9743=arguments.length;switch(G__9743){case 3:return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$3=function(xform,f,coll){return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,f.cljs$core$IFn$_invoke$arity$0?f.cljs$core$IFn$_invoke$arity$0():f.call(null),coll)};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$4=function(xform,f,init,coll){var f__$1=xform.cljs$core$IFn$_invoke$arity$1?xform.cljs$core$IFn$_invoke$arity$1(f):xform.call(null,f);var ret=cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);return f__$1.cljs$core$IFn$_invoke$arity$1?f__$1.cljs$core$IFn$_invoke$arity$1(ret):f__$1.call(null,ret)};cljs.core.transduce.cljs$lang$maxFixedArity=4;
cljs.core._PLUS_=function cljs$core$_PLUS_(var_args){var G__9749=arguments.length;switch(G__9749){case 0:return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();break;case 1:return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9751=arguments.length;var i__8411__auto___9752=0;while(true){if(i__8411__auto___9752<len__8410__auto___9751){args_arr__8429__auto__.push(arguments[i__8411__auto___9752]);
var G__9753=i__8411__auto___9752+1;i__8411__auto___9752=G__9753;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0=function(){return 0};cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1=function(x){return x};cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2=function(x,y){return x+y};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,x+y,more)};cljs.core._PLUS_.cljs$lang$applyTo=function(seq9746){var G__9747=cljs.core.first(seq9746);var seq9746__$1=cljs.core.next(seq9746);var G__9748=cljs.core.first(seq9746__$1);var seq9746__$2=cljs.core.next(seq9746__$1);return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__9747,G__9748,seq9746__$2)};
cljs.core._PLUS_.cljs$lang$maxFixedArity=2;
cljs.core._=function cljs$core$_(var_args){var G__9758=arguments.length;switch(G__9758){case 1:return cljs.core._.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core._.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9760=arguments.length;var i__8411__auto___9761=0;while(true){if(i__8411__auto___9761<len__8410__auto___9760){args_arr__8429__auto__.push(arguments[i__8411__auto___9761]);var G__9762=i__8411__auto___9761+
1;i__8411__auto___9761=G__9762;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core._.cljs$core$IFn$_invoke$arity$1=function(x){return-x};cljs.core._.cljs$core$IFn$_invoke$arity$2=function(x,y){return x-y};
cljs.core._.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,x-y,more)};cljs.core._.cljs$lang$applyTo=function(seq9755){var G__9756=cljs.core.first(seq9755);var seq9755__$1=cljs.core.next(seq9755);var G__9757=cljs.core.first(seq9755__$1);var seq9755__$2=cljs.core.next(seq9755__$1);return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(G__9756,G__9757,seq9755__$2)};cljs.core._.cljs$lang$maxFixedArity=2;
cljs.core._STAR_=function cljs$core$_STAR_(var_args){var G__9767=arguments.length;switch(G__9767){case 0:return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();break;case 1:return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9769=arguments.length;var i__8411__auto___9770=0;while(true){if(i__8411__auto___9770<len__8410__auto___9769){args_arr__8429__auto__.push(arguments[i__8411__auto___9770]);
var G__9771=i__8411__auto___9770+1;i__8411__auto___9770=G__9771;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0=function(){return 1};cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1=function(x){return x};cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2=function(x,y){return x*y};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,x*y,more)};cljs.core._STAR_.cljs$lang$applyTo=function(seq9764){var G__9765=cljs.core.first(seq9764);var seq9764__$1=cljs.core.next(seq9764);var G__9766=cljs.core.first(seq9764__$1);var seq9764__$2=cljs.core.next(seq9764__$1);return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__9765,G__9766,seq9764__$2)};
cljs.core._STAR_.cljs$lang$maxFixedArity=2;
cljs.core._SLASH_=function cljs$core$_SLASH_(var_args){var G__9776=arguments.length;switch(G__9776){case 1:return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9778=arguments.length;var i__8411__auto___9779=0;while(true){if(i__8411__auto___9779<len__8410__auto___9778){args_arr__8429__auto__.push(arguments[i__8411__auto___9779]);var G__9780=
i__8411__auto___9779+1;i__8411__auto___9779=G__9780;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1=function(x){return 1/x};cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2=function(x,y){return x/y};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,x/y,more)};cljs.core._SLASH_.cljs$lang$applyTo=function(seq9773){var G__9774=cljs.core.first(seq9773);var seq9773__$1=cljs.core.next(seq9773);var G__9775=cljs.core.first(seq9773__$1);var seq9773__$2=cljs.core.next(seq9773__$1);return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__9774,G__9775,seq9773__$2)};
cljs.core._SLASH_.cljs$lang$maxFixedArity=2;
cljs.core._LT_=function cljs$core$_LT_(var_args){var G__9785=arguments.length;switch(G__9785){case 1:return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9787=arguments.length;var i__8411__auto___9788=0;while(true){if(i__8411__auto___9788<len__8410__auto___9787){args_arr__8429__auto__.push(arguments[i__8411__auto___9788]);var G__9789=
i__8411__auto___9788+1;i__8411__auto___9788=G__9789;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core._LT_.cljs$core$IFn$_invoke$arity$1=function(x){return true};cljs.core._LT_.cljs$core$IFn$_invoke$arity$2=function(x,y){return x<y};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){while(true){if(x<y)if(cljs.core.next(more)){var G__9790=y;var G__9791=cljs.core.first(more);var G__9792=cljs.core.next(more);x=G__9790;y=G__9791;more=G__9792;continue}else return y<cljs.core.first(more);else return false;break}};
cljs.core._LT_.cljs$lang$applyTo=function(seq9782){var G__9783=cljs.core.first(seq9782);var seq9782__$1=cljs.core.next(seq9782);var G__9784=cljs.core.first(seq9782__$1);var seq9782__$2=cljs.core.next(seq9782__$1);return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(G__9783,G__9784,seq9782__$2)};cljs.core._LT_.cljs$lang$maxFixedArity=2;
cljs.core._LT__EQ_=function cljs$core$_LT__EQ_(var_args){var G__9797=arguments.length;switch(G__9797){case 1:return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9799=arguments.length;var i__8411__auto___9800=0;while(true){if(i__8411__auto___9800<len__8410__auto___9799){args_arr__8429__auto__.push(arguments[i__8411__auto___9800]);
var G__9801=i__8411__auto___9800+1;i__8411__auto___9800=G__9801;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1=function(x){return true};cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2=function(x,y){return x<=y};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){while(true){if(x<=y)if(cljs.core.next(more)){var G__9802=y;var G__9803=cljs.core.first(more);var G__9804=cljs.core.next(more);x=G__9802;y=G__9803;more=G__9804;continue}else return y<=cljs.core.first(more);else return false;break}};
cljs.core._LT__EQ_.cljs$lang$applyTo=function(seq9794){var G__9795=cljs.core.first(seq9794);var seq9794__$1=cljs.core.next(seq9794);var G__9796=cljs.core.first(seq9794__$1);var seq9794__$2=cljs.core.next(seq9794__$1);return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__9795,G__9796,seq9794__$2)};cljs.core._LT__EQ_.cljs$lang$maxFixedArity=2;
cljs.core._GT_=function cljs$core$_GT_(var_args){var G__9809=arguments.length;switch(G__9809){case 1:return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9811=arguments.length;var i__8411__auto___9812=0;while(true){if(i__8411__auto___9812<len__8410__auto___9811){args_arr__8429__auto__.push(arguments[i__8411__auto___9812]);var G__9813=
i__8411__auto___9812+1;i__8411__auto___9812=G__9813;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core._GT_.cljs$core$IFn$_invoke$arity$1=function(x){return true};cljs.core._GT_.cljs$core$IFn$_invoke$arity$2=function(x,y){return x>y};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){while(true){if(x>y)if(cljs.core.next(more)){var G__9814=y;var G__9815=cljs.core.first(more);var G__9816=cljs.core.next(more);x=G__9814;y=G__9815;more=G__9816;continue}else return y>cljs.core.first(more);else return false;break}};
cljs.core._GT_.cljs$lang$applyTo=function(seq9806){var G__9807=cljs.core.first(seq9806);var seq9806__$1=cljs.core.next(seq9806);var G__9808=cljs.core.first(seq9806__$1);var seq9806__$2=cljs.core.next(seq9806__$1);return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(G__9807,G__9808,seq9806__$2)};cljs.core._GT_.cljs$lang$maxFixedArity=2;
cljs.core._GT__EQ_=function cljs$core$_GT__EQ_(var_args){var G__9821=arguments.length;switch(G__9821){case 1:return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9823=arguments.length;var i__8411__auto___9824=0;while(true){if(i__8411__auto___9824<len__8410__auto___9823){args_arr__8429__auto__.push(arguments[i__8411__auto___9824]);
var G__9825=i__8411__auto___9824+1;i__8411__auto___9824=G__9825;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1=function(x){return true};cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2=function(x,y){return x>=y};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){while(true){if(x>=y)if(cljs.core.next(more)){var G__9826=y;var G__9827=cljs.core.first(more);var G__9828=cljs.core.next(more);x=G__9826;y=G__9827;more=G__9828;continue}else return y>=cljs.core.first(more);else return false;break}};
cljs.core._GT__EQ_.cljs$lang$applyTo=function(seq9818){var G__9819=cljs.core.first(seq9818);var seq9818__$1=cljs.core.next(seq9818);var G__9820=cljs.core.first(seq9818__$1);var seq9818__$2=cljs.core.next(seq9818__$1);return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__9819,G__9820,seq9818__$2)};cljs.core._GT__EQ_.cljs$lang$maxFixedArity=2;cljs.core.dec=function cljs$core$dec(x){return x-1};
cljs.core.max=function cljs$core$max(var_args){var G__9833=arguments.length;switch(G__9833){case 1:return cljs.core.max.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.max.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9835=arguments.length;var i__8411__auto___9836=0;while(true){if(i__8411__auto___9836<len__8410__auto___9835){args_arr__8429__auto__.push(arguments[i__8411__auto___9836]);var G__9837=
i__8411__auto___9836+1;i__8411__auto___9836=G__9837;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.max.cljs$core$IFn$_invoke$arity$1=function(x){return x};cljs.core.max.cljs$core$IFn$_invoke$arity$2=function(x,y){var x__7621__auto__=x;var y__7622__auto__=y;return x__7621__auto__>y__7622__auto__?x__7621__auto__:y__7622__auto__};
cljs.core.max.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,function(){var x__7621__auto__=x;var y__7622__auto__=y;return x__7621__auto__>y__7622__auto__?x__7621__auto__:y__7622__auto__}(),more)};
cljs.core.max.cljs$lang$applyTo=function(seq9830){var G__9831=cljs.core.first(seq9830);var seq9830__$1=cljs.core.next(seq9830);var G__9832=cljs.core.first(seq9830__$1);var seq9830__$2=cljs.core.next(seq9830__$1);return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(G__9831,G__9832,seq9830__$2)};cljs.core.max.cljs$lang$maxFixedArity=2;
cljs.core.min=function cljs$core$min(var_args){var G__9842=arguments.length;switch(G__9842){case 1:return cljs.core.min.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.min.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9844=arguments.length;var i__8411__auto___9845=0;while(true){if(i__8411__auto___9845<len__8410__auto___9844){args_arr__8429__auto__.push(arguments[i__8411__auto___9845]);var G__9846=
i__8411__auto___9845+1;i__8411__auto___9845=G__9846;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.min.cljs$core$IFn$_invoke$arity$1=function(x){return x};cljs.core.min.cljs$core$IFn$_invoke$arity$2=function(x,y){var x__7628__auto__=x;var y__7629__auto__=y;return x__7628__auto__<y__7629__auto__?x__7628__auto__:y__7629__auto__};
cljs.core.min.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,function(){var x__7628__auto__=x;var y__7629__auto__=y;return x__7628__auto__<y__7629__auto__?x__7628__auto__:y__7629__auto__}(),more)};
cljs.core.min.cljs$lang$applyTo=function(seq9839){var G__9840=cljs.core.first(seq9839);var seq9839__$1=cljs.core.next(seq9839);var G__9841=cljs.core.first(seq9839__$1);var seq9839__$2=cljs.core.next(seq9839__$1);return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(G__9840,G__9841,seq9839__$2)};cljs.core.min.cljs$lang$maxFixedArity=2;cljs.core.byte$=function cljs$core$byte(x){return x};
cljs.core.char$=function cljs$core$char(x){if(typeof x==="number")return String.fromCharCode(x);else if(typeof x==="string"&&x.length===1)return x;else throw new Error("Argument to char must be a character or number");};cljs.core.short$=function cljs$core$short(x){return x};cljs.core.float$=function cljs$core$float(x){return x};cljs.core.double$=function cljs$core$double(x){return x};cljs.core.unchecked_byte=function cljs$core$unchecked_byte(x){return x};cljs.core.unchecked_char=function cljs$core$unchecked_char(x){return x};
cljs.core.unchecked_short=function cljs$core$unchecked_short(x){return x};cljs.core.unchecked_float=function cljs$core$unchecked_float(x){return x};cljs.core.unchecked_double=function cljs$core$unchecked_double(x){return x};
cljs.core.unchecked_add=function cljs$core$unchecked_add(var_args){var G__9851=arguments.length;switch(G__9851){case 0:return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();break;case 1:return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9853=arguments.length;var i__8411__auto___9854=0;while(true){if(i__8411__auto___9854<
len__8410__auto___9853){args_arr__8429__auto__.push(arguments[i__8411__auto___9854]);var G__9855=i__8411__auto___9854+1;i__8411__auto___9854=G__9855;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0=function(){return 0};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1=function(x){return x};cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2=function(x,y){return x+y};cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,x+y,more)};
cljs.core.unchecked_add.cljs$lang$applyTo=function(seq9848){var G__9849=cljs.core.first(seq9848);var seq9848__$1=cljs.core.next(seq9848);var G__9850=cljs.core.first(seq9848__$1);var seq9848__$2=cljs.core.next(seq9848__$1);return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__9849,G__9850,seq9848__$2)};cljs.core.unchecked_add.cljs$lang$maxFixedArity=2;
cljs.core.unchecked_add_int=function cljs$core$unchecked_add_int(var_args){var G__9860=arguments.length;switch(G__9860){case 0:return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();break;case 1:return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9862=arguments.length;var i__8411__auto___9863=
0;while(true){if(i__8411__auto___9863<len__8410__auto___9862){args_arr__8429__auto__.push(arguments[i__8411__auto___9863]);var G__9864=i__8411__auto___9863+1;i__8411__auto___9863=G__9864;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0=function(){return 0};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1=function(x){return x};cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2=function(x,y){return x+y};cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,x+y,more)};
cljs.core.unchecked_add_int.cljs$lang$applyTo=function(seq9857){var G__9858=cljs.core.first(seq9857);var seq9857__$1=cljs.core.next(seq9857);var G__9859=cljs.core.first(seq9857__$1);var seq9857__$2=cljs.core.next(seq9857__$1);return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__9858,G__9859,seq9857__$2)};cljs.core.unchecked_add_int.cljs$lang$maxFixedArity=2;cljs.core.unchecked_dec=function cljs$core$unchecked_dec(x){return x-1};
cljs.core.unchecked_dec_int=function cljs$core$unchecked_dec_int(x){return x-1};
cljs.core.unchecked_divide_int=function cljs$core$unchecked_divide_int(var_args){var G__9869=arguments.length;switch(G__9869){case 1:return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9871=arguments.length;var i__8411__auto___9872=0;while(true){if(i__8411__auto___9872<len__8410__auto___9871){args_arr__8429__auto__.push(arguments[i__8411__auto___9872]);
var G__9873=i__8411__auto___9872+1;i__8411__auto___9872=G__9873;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1=function(x){return 1/x};cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2=function(x,y){return x/y};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,x/y,more)};
cljs.core.unchecked_divide_int.cljs$lang$applyTo=function(seq9866){var G__9867=cljs.core.first(seq9866);var seq9866__$1=cljs.core.next(seq9866);var G__9868=cljs.core.first(seq9866__$1);var seq9866__$2=cljs.core.next(seq9866__$1);return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__9867,G__9868,seq9866__$2)};cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity=2;cljs.core.unchecked_inc=function cljs$core$unchecked_inc(x){return x+1};
cljs.core.unchecked_inc_int=function cljs$core$unchecked_inc_int(x){return x+1};
cljs.core.unchecked_multiply=function cljs$core$unchecked_multiply(var_args){var G__9878=arguments.length;switch(G__9878){case 0:return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();break;case 1:return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9880=arguments.length;var i__8411__auto___9881=
0;while(true){if(i__8411__auto___9881<len__8410__auto___9880){args_arr__8429__auto__.push(arguments[i__8411__auto___9881]);var G__9882=i__8411__auto___9881+1;i__8411__auto___9881=G__9882;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0=function(){return 1};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1=function(x){return x};cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2=function(x,y){return x*y};cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,x*y,more)};
cljs.core.unchecked_multiply.cljs$lang$applyTo=function(seq9875){var G__9876=cljs.core.first(seq9875);var seq9875__$1=cljs.core.next(seq9875);var G__9877=cljs.core.first(seq9875__$1);var seq9875__$2=cljs.core.next(seq9875__$1);return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__9876,G__9877,seq9875__$2)};cljs.core.unchecked_multiply.cljs$lang$maxFixedArity=2;
cljs.core.unchecked_multiply_int=function cljs$core$unchecked_multiply_int(var_args){var G__9887=arguments.length;switch(G__9887){case 0:return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();break;case 1:return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9889=arguments.length;
var i__8411__auto___9890=0;while(true){if(i__8411__auto___9890<len__8410__auto___9889){args_arr__8429__auto__.push(arguments[i__8411__auto___9890]);var G__9891=i__8411__auto___9890+1;i__8411__auto___9890=G__9891;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0=function(){return 1};cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1=function(x){return x};cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2=function(x,y){return x*y};cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,x*y,more)};
cljs.core.unchecked_multiply_int.cljs$lang$applyTo=function(seq9884){var G__9885=cljs.core.first(seq9884);var seq9884__$1=cljs.core.next(seq9884);var G__9886=cljs.core.first(seq9884__$1);var seq9884__$2=cljs.core.next(seq9884__$1);return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__9885,G__9886,seq9884__$2)};cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity=2;cljs.core.unchecked_negate=function cljs$core$unchecked_negate(x){return-x};
cljs.core.unchecked_negate_int=function cljs$core$unchecked_negate_int(x){return-x};cljs.core.unchecked_remainder_int=function cljs$core$unchecked_remainder_int(x,n){return cljs.core.mod(x,n)};
cljs.core.unchecked_subtract=function cljs$core$unchecked_subtract(var_args){var G__9896=arguments.length;switch(G__9896){case 1:return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9898=arguments.length;var i__8411__auto___9899=0;while(true){if(i__8411__auto___9899<len__8410__auto___9898){args_arr__8429__auto__.push(arguments[i__8411__auto___9899]);
var G__9900=i__8411__auto___9899+1;i__8411__auto___9899=G__9900;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1=function(x){return-x};cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2=function(x,y){return x-y};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,x-y,more)};cljs.core.unchecked_subtract.cljs$lang$applyTo=function(seq9893){var G__9894=cljs.core.first(seq9893);var seq9893__$1=cljs.core.next(seq9893);var G__9895=cljs.core.first(seq9893__$1);var seq9893__$2=cljs.core.next(seq9893__$1);return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__9894,G__9895,seq9893__$2)};
cljs.core.unchecked_subtract.cljs$lang$maxFixedArity=2;
cljs.core.unchecked_subtract_int=function cljs$core$unchecked_subtract_int(var_args){var G__9905=arguments.length;switch(G__9905){case 1:return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9907=arguments.length;var i__8411__auto___9908=0;while(true){if(i__8411__auto___9908<len__8410__auto___9907){args_arr__8429__auto__.push(arguments[i__8411__auto___9908]);
var G__9909=i__8411__auto___9908+1;i__8411__auto___9908=G__9909;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1=function(x){return-x};cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2=function(x,y){return x-y};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,x-y,more)};
cljs.core.unchecked_subtract_int.cljs$lang$applyTo=function(seq9902){var G__9903=cljs.core.first(seq9902);var seq9902__$1=cljs.core.next(seq9902);var G__9904=cljs.core.first(seq9902__$1);var seq9902__$2=cljs.core.next(seq9902__$1);return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__9903,G__9904,seq9902__$2)};cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity=2;cljs.core.fix=function cljs$core$fix(q){if(q>=0)return Math.floor(q);else return Math.ceil(q)};
cljs.core.int$=function cljs$core$int(x){return x|0};cljs.core.unchecked_int=function cljs$core$unchecked_int(x){return cljs.core.fix(x)};cljs.core.long$=function cljs$core$long(x){return cljs.core.fix(x)};cljs.core.unchecked_long=function cljs$core$unchecked_long(x){return cljs.core.fix(x)};cljs.core.booleans=function cljs$core$booleans(x){return x};cljs.core.bytes=function cljs$core$bytes(x){return x};cljs.core.chars=function cljs$core$chars(x){return x};cljs.core.shorts=function cljs$core$shorts(x){return x};
cljs.core.ints=function cljs$core$ints(x){return x};cljs.core.floats=function cljs$core$floats(x){return x};cljs.core.doubles=function cljs$core$doubles(x){return x};cljs.core.longs=function cljs$core$longs(x){return x};cljs.core.js_mod=function cljs$core$js_mod(n,d){return n%d};cljs.core.mod=function cljs$core$mod(n,d){return(n%d+d)%d};cljs.core.quot=function cljs$core$quot(n,d){var rem=n%d;return cljs.core.fix((n-rem)/d)};
cljs.core.rem=function cljs$core$rem(n,d){var q=cljs.core.quot(n,d);return n-d*q};
cljs.core.bit_xor=function cljs$core$bit_xor(var_args){var G__9914=arguments.length;switch(G__9914){case 2:return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9916=arguments.length;var i__8411__auto___9917=0;while(true){if(i__8411__auto___9917<len__8410__auto___9916){args_arr__8429__auto__.push(arguments[i__8411__auto___9917]);var G__9918=i__8411__auto___9917+1;i__8411__auto___9917=G__9918;continue}else;
break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2=function(x,y){return x^y};cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,x^y,more)};
cljs.core.bit_xor.cljs$lang$applyTo=function(seq9911){var G__9912=cljs.core.first(seq9911);var seq9911__$1=cljs.core.next(seq9911);var G__9913=cljs.core.first(seq9911__$1);var seq9911__$2=cljs.core.next(seq9911__$1);return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__9912,G__9913,seq9911__$2)};cljs.core.bit_xor.cljs$lang$maxFixedArity=2;
cljs.core.bit_and=function cljs$core$bit_and(var_args){var G__9923=arguments.length;switch(G__9923){case 2:return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9925=arguments.length;var i__8411__auto___9926=0;while(true){if(i__8411__auto___9926<len__8410__auto___9925){args_arr__8429__auto__.push(arguments[i__8411__auto___9926]);var G__9927=i__8411__auto___9926+1;i__8411__auto___9926=G__9927;continue}else;
break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2=function(x,y){return x&y};cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,x&y,more)};
cljs.core.bit_and.cljs$lang$applyTo=function(seq9920){var G__9921=cljs.core.first(seq9920);var seq9920__$1=cljs.core.next(seq9920);var G__9922=cljs.core.first(seq9920__$1);var seq9920__$2=cljs.core.next(seq9920__$1);return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__9921,G__9922,seq9920__$2)};cljs.core.bit_and.cljs$lang$maxFixedArity=2;
cljs.core.bit_or=function cljs$core$bit_or(var_args){var G__9932=arguments.length;switch(G__9932){case 2:return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9934=arguments.length;var i__8411__auto___9935=0;while(true){if(i__8411__auto___9935<len__8410__auto___9934){args_arr__8429__auto__.push(arguments[i__8411__auto___9935]);var G__9936=i__8411__auto___9935+1;i__8411__auto___9935=G__9936;continue}else;break}var argseq__8430__auto__=
new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2=function(x,y){return x|y};cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,x|y,more)};
cljs.core.bit_or.cljs$lang$applyTo=function(seq9929){var G__9930=cljs.core.first(seq9929);var seq9929__$1=cljs.core.next(seq9929);var G__9931=cljs.core.first(seq9929__$1);var seq9929__$2=cljs.core.next(seq9929__$1);return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__9930,G__9931,seq9929__$2)};cljs.core.bit_or.cljs$lang$maxFixedArity=2;
cljs.core.bit_and_not=function cljs$core$bit_and_not(var_args){var G__9941=arguments.length;switch(G__9941){case 2:return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9943=arguments.length;var i__8411__auto___9944=0;while(true){if(i__8411__auto___9944<len__8410__auto___9943){args_arr__8429__auto__.push(arguments[i__8411__auto___9944]);var G__9945=i__8411__auto___9944+1;i__8411__auto___9944=G__9945;
continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2=function(x,y){return x&~y};cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,x&~y,more)};
cljs.core.bit_and_not.cljs$lang$applyTo=function(seq9938){var G__9939=cljs.core.first(seq9938);var seq9938__$1=cljs.core.next(seq9938);var G__9940=cljs.core.first(seq9938__$1);var seq9938__$2=cljs.core.next(seq9938__$1);return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__9939,G__9940,seq9938__$2)};cljs.core.bit_and_not.cljs$lang$maxFixedArity=2;cljs.core.bit_clear=function cljs$core$bit_clear(x,n){return x&~(1<<n)};cljs.core.bit_flip=function cljs$core$bit_flip(x,n){return x^1<<n};
cljs.core.bit_not=function cljs$core$bit_not(x){return~x};cljs.core.bit_set=function cljs$core$bit_set(x,n){return x|1<<n};cljs.core.bit_test=function cljs$core$bit_test(x,n){return(x&1<<n)!=0};cljs.core.bit_shift_left=function cljs$core$bit_shift_left(x,n){return x<<n};cljs.core.bit_shift_right=function cljs$core$bit_shift_right(x,n){return x>>n};cljs.core.bit_shift_right_zero_fill=function cljs$core$bit_shift_right_zero_fill(x,n){return x>>>n};
cljs.core.unsigned_bit_shift_right=function cljs$core$unsigned_bit_shift_right(x,n){return x>>>n};cljs.core.bit_count=function cljs$core$bit_count(v){var v__$1=v-(v>>1&1431655765);var v__$2=(v__$1&858993459)+(v__$1>>2&858993459);return(v__$2+(v__$2>>4)&252645135)*16843009>>24};
cljs.core._EQ__EQ_=function cljs$core$_EQ__EQ_(var_args){var G__9950=arguments.length;switch(G__9950){case 1:return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9952=arguments.length;var i__8411__auto___9953=0;while(true){if(i__8411__auto___9953<len__8410__auto___9952){args_arr__8429__auto__.push(arguments[i__8411__auto___9953]);
var G__9954=i__8411__auto___9953+1;i__8411__auto___9953=G__9954;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1=function(x){return true};cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2=function(x,y){return cljs.core._equiv(x,y)};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){while(true){if(x===y)if(cljs.core.next(more)){var G__9955=y;var G__9956=cljs.core.first(more);var G__9957=cljs.core.next(more);x=G__9955;y=G__9956;more=G__9957;continue}else return y===cljs.core.first(more);else return false;break}};
cljs.core._EQ__EQ_.cljs$lang$applyTo=function(seq9947){var G__9948=cljs.core.first(seq9947);var seq9947__$1=cljs.core.next(seq9947);var G__9949=cljs.core.first(seq9947__$1);var seq9947__$2=cljs.core.next(seq9947__$1);return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__9948,G__9949,seq9947__$2)};cljs.core._EQ__EQ_.cljs$lang$maxFixedArity=2;cljs.core.pos_QMARK_=function cljs$core$pos_QMARK_(x){return x>0};cljs.core.zero_QMARK_=function cljs$core$zero_QMARK_(x){return x===0};
cljs.core.neg_QMARK_=function cljs$core$neg_QMARK_(x){return x<0};cljs.core.nthnext=function cljs$core$nthnext(coll,n){var n__$1=n;var xs=cljs.core.seq(coll);while(true){if(xs&&n__$1>0){var G__9958=n__$1-1;var G__9959=cljs.core.next(xs);n__$1=G__9958;xs=G__9959;continue}else return xs;break}};
cljs.core.str=function cljs$core$str(var_args){var G__9963=arguments.length;switch(G__9963){case 0:return cljs.core.str.cljs$core$IFn$_invoke$arity$0();break;case 1:return cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___9965=arguments.length;var i__8411__auto___9966=0;while(true){if(i__8411__auto___9966<len__8410__auto___9965){args_arr__8429__auto__.push(arguments[i__8411__auto___9966]);var G__9967=i__8411__auto___9966+1;
i__8411__auto___9966=G__9967;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(1),0,null);return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(arguments[0],argseq__8430__auto__)}};cljs.core.str.cljs$core$IFn$_invoke$arity$0=function(){return""};cljs.core.str.cljs$core$IFn$_invoke$arity$1=function(x){if(x==null)return"";else return[x].join("")};
cljs.core.str.cljs$core$IFn$_invoke$arity$variadic=function(x,ys){var sb=new goog.string.StringBuffer([cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(""));var more=ys;while(true){if(cljs.core.truth_(more)){var G__9968=sb.append([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more))].join(""));var G__9969=cljs.core.next(more);sb=G__9968;more=G__9969;continue}else return sb.toString();break}};
cljs.core.str.cljs$lang$applyTo=function(seq9961){var G__9962=cljs.core.first(seq9961);var seq9961__$1=cljs.core.next(seq9961);return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(G__9962,seq9961__$1)};cljs.core.str.cljs$lang$maxFixedArity=1;
cljs.core.subs=function cljs$core$subs(var_args){var G__9971=arguments.length;switch(G__9971){case 2:return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.subs.cljs$core$IFn$_invoke$arity$2=function(s,start){return s.substring(start)};cljs.core.subs.cljs$core$IFn$_invoke$arity$3=function(s,start,end){return s.substring(start,end)};cljs.core.subs.cljs$lang$maxFixedArity=3;
cljs.core.equiv_sequential=function cljs$core$equiv_sequential(x,y){return cljs.core.boolean$(cljs.core.sequential_QMARK_(y)?cljs.core.counted_QMARK_(x)&&cljs.core.counted_QMARK_(y)&&!(cljs.core.count(x)===cljs.core.count(y))?false:function(){var xs=cljs.core.seq(x);var ys=cljs.core.seq(y);while(true){if(xs==null)return ys==null;else if(ys==null)return false;else if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){var G__9973=cljs.core.next(xs);var G__9974=cljs.core.next(ys);
xs=G__9973;ys=G__9974;continue}else return false;break}}():null)};cljs.core.hash_coll=function cljs$core$hash_coll(coll){if(cljs.core.seq(coll)){var res=cljs.core.hash(cljs.core.first(coll));var s=cljs.core.next(coll);while(true){if(s==null)return res;else{var G__9975=cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));var G__9976=cljs.core.next(s);res=G__9975;s=G__9976;continue}break}}else return 0};
cljs.core.hash_imap=function cljs$core$hash_imap(m){var h=0;var s=cljs.core.seq(m);while(true){if(s){var e=cljs.core.first(s);var G__9977=(h+(cljs.core.hash(cljs.core.key(e))^cljs.core.hash(cljs.core.val(e))))%4503599627370496;var G__9978=cljs.core.next(s);h=G__9977;s=G__9978;continue}else return h;break}};
cljs.core.hash_iset=function cljs$core$hash_iset(s){var h=0;var s__$1=cljs.core.seq(s);while(true){if(s__$1){var e=cljs.core.first(s__$1);var G__9979=(h+cljs.core.hash(e))%4503599627370496;var G__9980=cljs.core.next(s__$1);h=G__9979;s__$1=G__9980;continue}else return h;break}};
cljs.core.extend_object_BANG_=function cljs$core$extend_object_BANG_(obj,fn_map){var seq__9981_9991=cljs.core.seq(fn_map);var chunk__9982_9992=null;var count__9983_9993=0;var i__9984_9994=0;while(true){if(i__9984_9994<count__9983_9993){var vec__9985_9995=chunk__9982_9992.cljs$core$IIndexed$_nth$arity$2(null,i__9984_9994);var key_name_9996=cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9985_9995,0,null);var f_9997=cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9985_9995,1,null);var str_name_9998=
cljs.core.name(key_name_9996);obj[str_name_9998]=f_9997;var G__9999=seq__9981_9991;var G__10000=chunk__9982_9992;var G__10001=count__9983_9993;var G__10002=i__9984_9994+1;seq__9981_9991=G__9999;chunk__9982_9992=G__10000;count__9983_9993=G__10001;i__9984_9994=G__10002;continue}else{var temp__4657__auto___10003=cljs.core.seq(seq__9981_9991);if(temp__4657__auto___10003){var seq__9981_10004__$1=temp__4657__auto___10003;if(cljs.core.chunked_seq_QMARK_(seq__9981_10004__$1)){var c__8105__auto___10005=cljs.core.chunk_first(seq__9981_10004__$1);
var G__10006=cljs.core.chunk_rest(seq__9981_10004__$1);var G__10007=c__8105__auto___10005;var G__10008=cljs.core.count(c__8105__auto___10005);var G__10009=0;seq__9981_9991=G__10006;chunk__9982_9992=G__10007;count__9983_9993=G__10008;i__9984_9994=G__10009;continue}else{var vec__9988_10010=cljs.core.first(seq__9981_10004__$1);var key_name_10011=cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9988_10010,0,null);var f_10012=cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9988_10010,1,null);var str_name_10013=
cljs.core.name(key_name_10011);obj[str_name_10013]=f_10012;var G__10014=cljs.core.next(seq__9981_10004__$1);var G__10015=null;var G__10016=0;var G__10017=0;seq__9981_9991=G__10014;chunk__9982_9992=G__10015;count__9983_9993=G__10016;i__9984_9994=G__10017;continue}}else;}break}return obj};
cljs.core.List=function(meta,first,rest,count,__hash){this.meta=meta;this.first=first;this.rest=rest;this.count=count;this.__hash=__hash;this.cljs$lang$protocol_mask$partition0$=65937646;this.cljs$lang$protocol_mask$partition1$=8192};cljs.core.List.prototype.toString=function(){var self__=this;var coll=this;return cljs.core.pr_str_STAR_(coll)};cljs.core.List.prototype.equiv=function(other){var self__=this;var this$=this;return this$.cljs$core$IEquiv$_equiv$arity$2(null,other)};
cljs.core.List.prototype.indexOf=function(){var G__10018=null;var G__10018__1=function(x){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,0)};var G__10018__2=function(x,start){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__10018=function(x,start){switch(arguments.length){case 1:return G__10018__1.call(this,x);case 2:return G__10018__2.call(this,x,start)}throw new Error("Invalid arity: "+(arguments.length-
1));};G__10018.cljs$core$IFn$_invoke$arity$1=G__10018__1;G__10018.cljs$core$IFn$_invoke$arity$2=G__10018__2;return G__10018}();
cljs.core.List.prototype.lastIndexOf=function(){var G__10019=null;var G__10019__1=function(x){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count)};var G__10019__2=function(x,start){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__10019=function(x,start){switch(arguments.length){case 1:return G__10019__1.call(this,x);case 2:return G__10019__2.call(this,x,start)}throw new Error("Invalid arity: "+
(arguments.length-1));};G__10019.cljs$core$IFn$_invoke$arity$1=G__10019__1;G__10019.cljs$core$IFn$_invoke$arity$2=G__10019__2;return G__10019}();cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.meta};cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1=function(_){var self__=this;var ___$1=this;return new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash)};
cljs.core.List.prototype.cljs$core$INext$_next$arity$1=function(coll){var self__=this;var coll__$1=this;if(self__.count===1)return null;else return self__.rest};cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.count};cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.first};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1=function(coll){var self__=this;var coll__$1=this;return coll__$1.cljs$core$ISeq$_rest$arity$1(null)};cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1=function(coll){var self__=this;var coll__$1=this;var h__7725__auto__=self__.__hash;if(!(h__7725__auto__==null))return h__7725__auto__;else{var h__7725__auto____$1=cljs.core.hash_ordered_coll(coll__$1);self__.__hash=h__7725__auto____$1;return h__7725__auto____$1}};
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2=function(coll,other){var self__=this;var coll__$1=this;return cljs.core.equiv_sequential(coll__$1,other)};cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1=function(coll){var self__=this;var coll__$1=this;return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta)};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2=function(coll,f){var self__=this;var coll__$1=this;return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1)};cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3=function(coll,f,start){var self__=this;var coll__$1=this;return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1)};cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.first};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1=function(coll){var self__=this;var coll__$1=this;if(self__.count===1)return cljs.core.List.EMPTY;else return self__.rest};cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1=function(coll){var self__=this;var coll__$1=this;return coll__$1};cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2=function(coll,meta__$1){var self__=this;var coll__$1=this;return new cljs.core.List(meta__$1,self__.first,self__.rest,self__.count,self__.__hash)};
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2=function(coll,o){var self__=this;var coll__$1=this;return new cljs.core.List(self__.meta,o,coll__$1,self__.count+1,null)};
cljs.core.List.getBasis=function(){return new cljs.core.PersistentVector(null,5,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"count","count",-514511684,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,
"mutable","mutable",875778266),true],null))],null)};cljs.core.List.cljs$lang$type=true;cljs.core.List.cljs$lang$ctorStr="cljs.core/List";cljs.core.List.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/List")};cljs.core.__GT_List=function cljs$core$__GT_List(meta,first,rest,count,__hash){return new cljs.core.List(meta,first,rest,count,__hash)};
cljs.core.list_QMARK_=function cljs$core$list_QMARK_(x){if(!(x==null))if(x.cljs$lang$protocol_mask$partition0$&33554432||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$IList$)return true;else if(!x.cljs$lang$protocol_mask$partition0$)return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x)};cljs.core.List.prototype[cljs.core.ITER_SYMBOL]=function(){var this__8311__auto__=this;return cljs.core.es6_iterator(this__8311__auto__)};
cljs.core.EmptyList=function(meta){this.meta=meta;this.cljs$lang$protocol_mask$partition0$=65937614;this.cljs$lang$protocol_mask$partition1$=8192};cljs.core.EmptyList.prototype.toString=function(){var self__=this;var coll=this;return cljs.core.pr_str_STAR_(coll)};cljs.core.EmptyList.prototype.equiv=function(other){var self__=this;var this$=this;return this$.cljs$core$IEquiv$_equiv$arity$2(null,other)};
cljs.core.EmptyList.prototype.indexOf=function(){var G__10021=null;var G__10021__1=function(x){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,0)};var G__10021__2=function(x,start){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__10021=function(x,start){switch(arguments.length){case 1:return G__10021__1.call(this,x);case 2:return G__10021__2.call(this,x,start)}throw new Error("Invalid arity: "+(arguments.length-
1));};G__10021.cljs$core$IFn$_invoke$arity$1=G__10021__1;G__10021.cljs$core$IFn$_invoke$arity$2=G__10021__2;return G__10021}();
cljs.core.EmptyList.prototype.lastIndexOf=function(){var G__10022=null;var G__10022__1=function(x){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll))};var G__10022__2=function(x,start){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__10022=function(x,start){switch(arguments.length){case 1:return G__10022__1.call(this,x);case 2:return G__10022__2.call(this,x,start)}throw new Error("Invalid arity: "+
(arguments.length-1));};G__10022.cljs$core$IFn$_invoke$arity$1=G__10022__1;G__10022.cljs$core$IFn$_invoke$arity$2=G__10022__2;return G__10022}();cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.meta};cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1=function(_){var self__=this;var ___$1=this;return new cljs.core.EmptyList(self__.meta)};
cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1=function(coll){var self__=this;var coll__$1=this;return null};cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1=function(coll){var self__=this;var coll__$1=this;return 0};cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1=function(coll){var self__=this;var coll__$1=this;return null};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1=function(coll){var self__=this;var coll__$1=this;throw new Error("Can't pop empty list");};cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1=function(coll){var self__=this;var coll__$1=this;return cljs.core.empty_ordered_hash};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2=function(coll,other){var self__=this;var coll__$1=this;if(cljs.core.list_QMARK_(other)||cljs.core.sequential_QMARK_(other))return cljs.core.seq(other)==null;else return false};cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1=function(coll){var self__=this;var coll__$1=this;return coll__$1};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2=function(coll,f){var self__=this;var coll__$1=this;return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1)};cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3=function(coll,f,start){var self__=this;var coll__$1=this;return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1)};cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1=function(coll){var self__=this;var coll__$1=this;return null};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1=function(coll){var self__=this;var coll__$1=this;return cljs.core.List.EMPTY};cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1=function(coll){var self__=this;var coll__$1=this;return null};cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2=function(coll,meta__$1){var self__=this;var coll__$1=this;return new cljs.core.EmptyList(meta__$1)};
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2=function(coll,o){var self__=this;var coll__$1=this;return new cljs.core.List(self__.meta,o,null,1,null)};cljs.core.EmptyList.getBasis=function(){return new cljs.core.PersistentVector(null,1,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"meta","meta",-1154898805,null)],null)};cljs.core.EmptyList.cljs$lang$type=true;cljs.core.EmptyList.cljs$lang$ctorStr="cljs.core/EmptyList";
cljs.core.EmptyList.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/EmptyList")};cljs.core.__GT_EmptyList=function cljs$core$__GT_EmptyList(meta){return new cljs.core.EmptyList(meta)};cljs.core.List.EMPTY=new cljs.core.EmptyList(null);cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL]=function(){var this__8311__auto__=this;return cljs.core.es6_iterator(this__8311__auto__)};
cljs.core.reversible_QMARK_=function cljs$core$reversible_QMARK_(coll){if(!(coll==null))if(coll.cljs$lang$protocol_mask$partition0$&134217728||cljs.core.PROTOCOL_SENTINEL===coll.cljs$core$IReversible$)return true;else if(!coll.cljs$lang$protocol_mask$partition0$)return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);else return false;else return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll)};cljs.core.rseq=function cljs$core$rseq(rev){return cljs.core._rseq(rev)};
cljs.core.reverse=function cljs$core$reverse(coll){if(cljs.core.reversible_QMARK_(coll))return cljs.core.rseq(coll);else return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll)};
cljs.core.list=function cljs$core$list(var_args){var args__8417__auto__=[];var len__8410__auto___10025=arguments.length;var i__8411__auto___10026=0;while(true){if(i__8411__auto___10026<len__8410__auto___10025){args__8417__auto__.push(arguments[i__8411__auto___10026]);var G__10027=i__8411__auto___10026+1;i__8411__auto___10026=G__10027;continue}else;break}var argseq__8418__auto__=0<args__8417__auto__.length?new cljs.core.IndexedSeq(args__8417__auto__.slice(0),0,null):null;return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__8418__auto__)};
cljs.core.list.cljs$core$IFn$_invoke$arity$variadic=function(xs){var arr=xs instanceof cljs.core.IndexedSeq&&xs.i===0?xs.arr:function(){var arr=[];var xs__$1=xs;while(true){if(!(xs__$1==null)){arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));var G__10028=xs__$1.cljs$core$INext$_next$arity$1(null);xs__$1=G__10028;continue}else return arr;break}}();var i=arr.length;var r=cljs.core.List.EMPTY;while(true){if(i>0){var G__10029=i-1;var G__10030=r.cljs$core$ICollection$_conj$arity$2(null,arr[i-1]);i=
G__10029;r=G__10030;continue}else return r;break}};cljs.core.list.cljs$lang$maxFixedArity=0;cljs.core.list.cljs$lang$applyTo=function(seq10024){return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10024))};cljs.core.Cons=function(meta,first,rest,__hash){this.meta=meta;this.first=first;this.rest=rest;this.__hash=__hash;this.cljs$lang$protocol_mask$partition0$=65929452;this.cljs$lang$protocol_mask$partition1$=8192};
cljs.core.Cons.prototype.toString=function(){var self__=this;var coll=this;return cljs.core.pr_str_STAR_(coll)};cljs.core.Cons.prototype.equiv=function(other){var self__=this;var this$=this;return this$.cljs$core$IEquiv$_equiv$arity$2(null,other)};
cljs.core.Cons.prototype.indexOf=function(){var G__10031=null;var G__10031__1=function(x){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,0)};var G__10031__2=function(x,start){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__10031=function(x,start){switch(arguments.length){case 1:return G__10031__1.call(this,x);case 2:return G__10031__2.call(this,x,start)}throw new Error("Invalid arity: "+(arguments.length-
1));};G__10031.cljs$core$IFn$_invoke$arity$1=G__10031__1;G__10031.cljs$core$IFn$_invoke$arity$2=G__10031__2;return G__10031}();
cljs.core.Cons.prototype.lastIndexOf=function(){var G__10032=null;var G__10032__1=function(x){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll))};var G__10032__2=function(x,start){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__10032=function(x,start){switch(arguments.length){case 1:return G__10032__1.call(this,x);case 2:return G__10032__2.call(this,x,start)}throw new Error("Invalid arity: "+
(arguments.length-1));};G__10032.cljs$core$IFn$_invoke$arity$1=G__10032__1;G__10032.cljs$core$IFn$_invoke$arity$2=G__10032__2;return G__10032}();cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.meta};cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1=function(_){var self__=this;var ___$1=this;return new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash)};
cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1=function(coll){var self__=this;var coll__$1=this;if(self__.rest==null)return null;else return cljs.core.seq(self__.rest)};cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1=function(coll){var self__=this;var coll__$1=this;var h__7725__auto__=self__.__hash;if(!(h__7725__auto__==null))return h__7725__auto__;else{var h__7725__auto____$1=cljs.core.hash_ordered_coll(coll__$1);self__.__hash=h__7725__auto____$1;return h__7725__auto____$1}};
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2=function(coll,other){var self__=this;var coll__$1=this;return cljs.core.equiv_sequential(coll__$1,other)};cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1=function(coll){var self__=this;var coll__$1=this;return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta)};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2=function(coll,f){var self__=this;var coll__$1=this;return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1)};cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3=function(coll,f,start){var self__=this;var coll__$1=this;return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1)};cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.first};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1=function(coll){var self__=this;var coll__$1=this;if(self__.rest==null)return cljs.core.List.EMPTY;else return self__.rest};cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1=function(coll){var self__=this;var coll__$1=this;return coll__$1};cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2=function(coll,meta__$1){var self__=this;var coll__$1=this;return new cljs.core.Cons(meta__$1,self__.first,self__.rest,self__.__hash)};
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2=function(coll,o){var self__=this;var coll__$1=this;return new cljs.core.Cons(null,o,coll__$1,null)};
cljs.core.Cons.getBasis=function(){return new cljs.core.PersistentVector(null,4,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null))],null)};
cljs.core.Cons.cljs$lang$type=true;cljs.core.Cons.cljs$lang$ctorStr="cljs.core/Cons";cljs.core.Cons.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/Cons")};cljs.core.__GT_Cons=function cljs$core$__GT_Cons(meta,first,rest,__hash){return new cljs.core.Cons(meta,first,rest,__hash)};cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL]=function(){var this__8311__auto__=this;return cljs.core.es6_iterator(this__8311__auto__)};
cljs.core.cons=function cljs$core$cons(x,coll){if(function(){var or__7285__auto__=coll==null;if(or__7285__auto__)return or__7285__auto__;else if(!(coll==null))if(coll.cljs$lang$protocol_mask$partition0$&64||cljs.core.PROTOCOL_SENTINEL===coll.cljs$core$ISeq$)return true;else return false;else return false}())return new cljs.core.Cons(null,x,coll,null);else return new cljs.core.Cons(null,x,cljs.core.seq(coll),null)};
cljs.core.hash_keyword=function cljs$core$hash_keyword(k){return cljs.core.hash_symbol(k)+2654435769|0};
cljs.core.compare_keywords=function cljs$core$compare_keywords(a,b){if(a.fqn===b.fqn)return 0;else if(cljs.core.truth_(function(){var and__7273__auto__=cljs.core.not(a.ns);if(and__7273__auto__)return b.ns;else return and__7273__auto__}()))return-1;else if(cljs.core.truth_(a.ns))if(cljs.core.not(b.ns))return 1;else{var nsc=function(){var G__10035=a.ns;var G__10036=b.ns;return goog.array.defaultCompare(G__10035,G__10036)}();if(0===nsc){var G__10037=a.name;var G__10038=b.name;return goog.array.defaultCompare(G__10037,
G__10038)}else return nsc}else{var G__10039=a.name;var G__10040=b.name;return goog.array.defaultCompare(G__10039,G__10040)}};cljs.core.Keyword=function(ns,name,fqn,_hash){this.ns=ns;this.name=name;this.fqn=fqn;this._hash=_hash;this.cljs$lang$protocol_mask$partition0$=2153775105;this.cljs$lang$protocol_mask$partition1$=4096};cljs.core.Keyword.prototype.toString=function(){var self__=this;var _=this;return[cljs.core.str.cljs$core$IFn$_invoke$arity$1(":"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join("")};
cljs.core.Keyword.prototype.equiv=function(other){var self__=this;var this$=this;return this$.cljs$core$IEquiv$_equiv$arity$2(null,other)};cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2=function(_,other){var self__=this;var ___$1=this;if(other instanceof cljs.core.Keyword)return self__.fqn===other.fqn;else return false};
cljs.core.Keyword.prototype.call=function(){var G__10042=null;var G__10042__2=function(self__,coll){var self__=this;var self____$1=this;var kw=self____$1;return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw)};var G__10042__3=function(self__,coll,not_found){var self__=this;var self____$1=this;var kw=self____$1;return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found)};G__10042=function(self__,coll,not_found){switch(arguments.length){case 2:return G__10042__2.call(this,self__,coll);
case 3:return G__10042__3.call(this,self__,coll,not_found)}throw new Error("Invalid arity: "+(arguments.length-1));};G__10042.cljs$core$IFn$_invoke$arity$2=G__10042__2;G__10042.cljs$core$IFn$_invoke$arity$3=G__10042__3;return G__10042}();cljs.core.Keyword.prototype.apply=function(self__,args10041){var self__=this;var self____$1=this;return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10041)))};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1=function(coll){var self__=this;var kw=this;return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw)};cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2=function(coll,not_found){var self__=this;var kw=this;return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found)};
cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1=function(this$){var self__=this;var this$__$1=this;var h__7725__auto__=self__._hash;if(!(h__7725__auto__==null))return h__7725__auto__;else{var h__7725__auto____$1=cljs.core.hash_keyword(this$__$1);self__._hash=h__7725__auto____$1;return h__7725__auto____$1}};cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1=function(_){var self__=this;var ___$1=this;return self__.name};
cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1=function(_){var self__=this;var ___$1=this;return self__.ns};cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3=function(o,writer,_){var self__=this;var o__$1=this;return cljs.core._write(writer,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(":"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(""))};
cljs.core.Keyword.getBasis=function(){return new cljs.core.PersistentVector(null,4,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"fqn","fqn",-1749334463,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null))],null)};
cljs.core.Keyword.cljs$lang$type=true;cljs.core.Keyword.cljs$lang$ctorStr="cljs.core/Keyword";cljs.core.Keyword.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/Keyword")};cljs.core.__GT_Keyword=function cljs$core$__GT_Keyword(ns,name,fqn,_hash){return new cljs.core.Keyword(ns,name,fqn,_hash)};cljs.core.keyword_QMARK_=function cljs$core$keyword_QMARK_(x){return x instanceof cljs.core.Keyword};
cljs.core.keyword_identical_QMARK_=function cljs$core$keyword_identical_QMARK_(x,y){if(x===y)return true;else if(x instanceof cljs.core.Keyword&&y instanceof cljs.core.Keyword)return x.fqn===y.fqn;else return false};cljs.core.symbol_identical_QMARK_=function cljs$core$symbol_identical_QMARK_(x,y){if(x===y)return true;else if(x instanceof cljs.core.Symbol&&y instanceof cljs.core.Symbol)return x.str===y.str;else return false};
cljs.core.namespace=function cljs$core$namespace(x){if(!(x==null)?x.cljs$lang$protocol_mask$partition1$&4096||cljs.core.PROTOCOL_SENTINEL===x.cljs$core$INamed$?true:false:false)return x.cljs$core$INamed$_namespace$arity$1(null);else throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Doesn't support namespace: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(""));};cljs.core.ident_QMARK_=function cljs$core$ident_QMARK_(x){return x instanceof cljs.core.Keyword||x instanceof cljs.core.Symbol};
cljs.core.simple_ident_QMARK_=function cljs$core$simple_ident_QMARK_(x){return cljs.core.ident_QMARK_(x)&&cljs.core.namespace(x)==null};cljs.core.qualified_ident_QMARK_=function cljs$core$qualified_ident_QMARK_(x){return cljs.core.boolean$(function(){var and__7273__auto__=cljs.core.ident_QMARK_(x);if(and__7273__auto__){var and__7273__auto____$1=cljs.core.namespace(x);if(cljs.core.truth_(and__7273__auto____$1))return true;else return and__7273__auto____$1}else return and__7273__auto__}())};
cljs.core.simple_symbol_QMARK_=function cljs$core$simple_symbol_QMARK_(x){return x instanceof cljs.core.Symbol&&cljs.core.namespace(x)==null};cljs.core.qualified_symbol_QMARK_=function cljs$core$qualified_symbol_QMARK_(x){return cljs.core.boolean$(function(){var and__7273__auto__=x instanceof cljs.core.Symbol;if(and__7273__auto__){var and__7273__auto____$1=cljs.core.namespace(x);if(cljs.core.truth_(and__7273__auto____$1))return true;else return and__7273__auto____$1}else return and__7273__auto__}())};
cljs.core.simple_keyword_QMARK_=function cljs$core$simple_keyword_QMARK_(x){return x instanceof cljs.core.Keyword&&cljs.core.namespace(x)==null};cljs.core.qualified_keyword_QMARK_=function cljs$core$qualified_keyword_QMARK_(x){return cljs.core.boolean$(function(){var and__7273__auto__=x instanceof cljs.core.Keyword;if(and__7273__auto__){var and__7273__auto____$1=cljs.core.namespace(x);if(cljs.core.truth_(and__7273__auto____$1))return true;else return and__7273__auto____$1}else return and__7273__auto__}())};
cljs.core.keyword=function cljs$core$keyword(var_args){var G__10045=arguments.length;switch(G__10045){case 1:return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$1=function(name){if(name instanceof cljs.core.Keyword)return name;else if(name instanceof cljs.core.Symbol)return new cljs.core.Keyword(cljs.core.namespace(name),cljs.core.name(name),name.str,null);else if(typeof name==="string"){var parts=name.split("/");if(parts.length===2)return new cljs.core.Keyword(parts[0],parts[1],name,null);else return new cljs.core.Keyword(null,parts[0],name,null)}else return null};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$2=function(ns,name){var ns__$1=ns instanceof cljs.core.Keyword?cljs.core.name(ns):ns instanceof cljs.core.Symbol?cljs.core.name(ns):ns;var name__$1=name instanceof cljs.core.Keyword?cljs.core.name(name):name instanceof cljs.core.Symbol?cljs.core.name(name):name;return new cljs.core.Keyword(ns__$1,name__$1,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.truth_(ns__$1)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/")].join(""):
null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1)].join(""),null)};cljs.core.keyword.cljs$lang$maxFixedArity=2;cljs.core.LazySeq=function(meta,fn,s,__hash){this.meta=meta;this.fn=fn;this.s=s;this.__hash=__hash;this.cljs$lang$protocol_mask$partition0$=32374988;this.cljs$lang$protocol_mask$partition1$=1};cljs.core.LazySeq.prototype.toString=function(){var self__=this;var coll=this;return cljs.core.pr_str_STAR_(coll)};
cljs.core.LazySeq.prototype.equiv=function(other){var self__=this;var this$=this;return this$.cljs$core$IEquiv$_equiv$arity$2(null,other)};cljs.core.LazySeq.prototype.sval=function(){var self__=this;var coll=this;if(self__.fn==null)return self__.s;else{self__.s=self__.fn.cljs$core$IFn$_invoke$arity$0?self__.fn.cljs$core$IFn$_invoke$arity$0():self__.fn.call(null);self__.fn=null;return self__.s}};
cljs.core.LazySeq.prototype.indexOf=function(){var G__10047=null;var G__10047__1=function(x){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,0)};var G__10047__2=function(x,start){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__10047=function(x,start){switch(arguments.length){case 1:return G__10047__1.call(this,x);case 2:return G__10047__2.call(this,x,start)}throw new Error("Invalid arity: "+(arguments.length-
1));};G__10047.cljs$core$IFn$_invoke$arity$1=G__10047__1;G__10047.cljs$core$IFn$_invoke$arity$2=G__10047__2;return G__10047}();
cljs.core.LazySeq.prototype.lastIndexOf=function(){var G__10048=null;var G__10048__1=function(x){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll))};var G__10048__2=function(x,start){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__10048=function(x,start){switch(arguments.length){case 1:return G__10048__1.call(this,x);case 2:return G__10048__2.call(this,x,start)}throw new Error("Invalid arity: "+
(arguments.length-1));};G__10048.cljs$core$IFn$_invoke$arity$1=G__10048__1;G__10048.cljs$core$IFn$_invoke$arity$2=G__10048__2;return G__10048}();cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.meta};cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1=function(coll){var self__=this;var coll__$1=this;coll__$1.cljs$core$ISeqable$_seq$arity$1(null);if(self__.s==null)return null;else return cljs.core.next(self__.s)};
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1=function(coll){var self__=this;var coll__$1=this;var h__7725__auto__=self__.__hash;if(!(h__7725__auto__==null))return h__7725__auto__;else{var h__7725__auto____$1=cljs.core.hash_ordered_coll(coll__$1);self__.__hash=h__7725__auto____$1;return h__7725__auto____$1}};cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2=function(coll,other){var self__=this;var coll__$1=this;return cljs.core.equiv_sequential(coll__$1,other)};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1=function(coll){var self__=this;var coll__$1=this;return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta)};cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1=function(coll){var self__=this;var coll__$1=this;return cljs.core.not(self__.fn)};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2=function(coll,f){var self__=this;var coll__$1=this;return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1)};cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3=function(coll,f,start){var self__=this;var coll__$1=this;return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1)};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1=function(coll){var self__=this;var coll__$1=this;coll__$1.cljs$core$ISeqable$_seq$arity$1(null);if(self__.s==null)return null;else return cljs.core.first(self__.s)};cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1=function(coll){var self__=this;var coll__$1=this;coll__$1.cljs$core$ISeqable$_seq$arity$1(null);if(!(self__.s==null))return cljs.core.rest(self__.s);else return cljs.core.List.EMPTY};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1=function(coll){var self__=this;var coll__$1=this;coll__$1.sval();if(self__.s==null)return null;else{var ls=self__.s;while(true){if(ls instanceof cljs.core.LazySeq){var G__10049=ls.sval();ls=G__10049;continue}else{self__.s=ls;return cljs.core.seq(self__.s)}break}}};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2=function(coll,meta__$1){var self__=this;var coll__$1=this;return new cljs.core.LazySeq(meta__$1,self__.fn,self__.s,self__.__hash)};cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2=function(coll,o){var self__=this;var coll__$1=this;return cljs.core.cons(o,coll__$1)};
cljs.core.LazySeq.getBasis=function(){return new cljs.core.PersistentVector(null,4,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"fn","fn",465265323,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null)),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,
"mutable","mutable",875778266),true],null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null))],null)};cljs.core.LazySeq.cljs$lang$type=true;cljs.core.LazySeq.cljs$lang$ctorStr="cljs.core/LazySeq";cljs.core.LazySeq.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/LazySeq")};
cljs.core.__GT_LazySeq=function cljs$core$__GT_LazySeq(meta,fn,s,__hash){return new cljs.core.LazySeq(meta,fn,s,__hash)};cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL]=function(){var this__8311__auto__=this;return cljs.core.es6_iterator(this__8311__auto__)};cljs.core.ChunkBuffer=function(buf,end){this.buf=buf;this.end=end;this.cljs$lang$protocol_mask$partition0$=2;this.cljs$lang$protocol_mask$partition1$=0};
cljs.core.ChunkBuffer.prototype.add=function(o){var self__=this;var _=this;self__.buf[self__.end]=o;return self__.end=self__.end+1};cljs.core.ChunkBuffer.prototype.chunk=function(){var self__=this;var _=this;var ret=new cljs.core.ArrayChunk(self__.buf,0,self__.end);self__.buf=null;return ret};cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1=function(_){var self__=this;var ___$1=this;return self__.end};
cljs.core.ChunkBuffer.getBasis=function(){return new cljs.core.PersistentVector(null,2,5,cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.with_meta(new cljs.core.Symbol(null,"buf","buf",1426618187,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null)),cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null))],
null)};cljs.core.ChunkBuffer.cljs$lang$type=true;cljs.core.ChunkBuffer.cljs$lang$ctorStr="cljs.core/ChunkBuffer";cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/ChunkBuffer")};cljs.core.__GT_ChunkBuffer=function cljs$core$__GT_ChunkBuffer(buf,end){return new cljs.core.ChunkBuffer(buf,end)};
cljs.core.chunk_buffer=function cljs$core$chunk_buffer(capacity){return new cljs.core.ChunkBuffer(new Array(capacity),0)};cljs.core.ArrayChunk=function(arr,off,end){this.arr=arr;this.off=off;this.end=end;this.cljs$lang$protocol_mask$partition0$=524306;this.cljs$lang$protocol_mask$partition1$=0};cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1=function(_){var self__=this;var ___$1=this;return self__.end-self__.off};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2=function(coll,i){var self__=this;var coll__$1=this;return self__.arr[self__.off+i]};cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3=function(coll,i,not_found){var self__=this;var coll__$1=this;if(i>=0&&i<self__.end-self__.off)return self__.arr[self__.off+i];else return not_found};cljs.core.ArrayChunk.prototype.cljs$core$IChunk$=cljs.core.PROTOCOL_SENTINEL;
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1=function(coll){var self__=this;var coll__$1=this;if(self__.off===self__.end)throw new Error("-drop-first of empty chunk");else return new cljs.core.ArrayChunk(self__.arr,self__.off+1,self__.end)};cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2=function(coll,f){var self__=this;var coll__$1=this;return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,self__.arr[self__.off],self__.off+1)};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3=function(coll,f,start){var self__=this;var coll__$1=this;return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off)};
cljs.core.ArrayChunk.getBasis=function(){return new cljs.core.PersistentVector(null,3,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)],null)};cljs.core.ArrayChunk.cljs$lang$type=true;cljs.core.ArrayChunk.cljs$lang$ctorStr="cljs.core/ArrayChunk";
cljs.core.ArrayChunk.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/ArrayChunk")};cljs.core.__GT_ArrayChunk=function cljs$core$__GT_ArrayChunk(arr,off,end){return new cljs.core.ArrayChunk(arr,off,end)};
cljs.core.array_chunk=function cljs$core$array_chunk(var_args){var G__10051=arguments.length;switch(G__10051){case 1:return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
}};cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1=function(arr){return new cljs.core.ArrayChunk(arr,0,arr.length)};cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2=function(arr,off){return new cljs.core.ArrayChunk(arr,off,arr.length)};cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3=function(arr,off,end){return new cljs.core.ArrayChunk(arr,off,end)};cljs.core.array_chunk.cljs$lang$maxFixedArity=3;
cljs.core.ChunkedCons=function(chunk,more,meta,__hash){this.chunk=chunk;this.more=more;this.meta=meta;this.__hash=__hash;this.cljs$lang$protocol_mask$partition0$=31850732;this.cljs$lang$protocol_mask$partition1$=1536};cljs.core.ChunkedCons.prototype.toString=function(){var self__=this;var coll=this;return cljs.core.pr_str_STAR_(coll)};cljs.core.ChunkedCons.prototype.equiv=function(other){var self__=this;var this$=this;return this$.cljs$core$IEquiv$_equiv$arity$2(null,other)};
cljs.core.ChunkedCons.prototype.indexOf=function(){var G__10053=null;var G__10053__1=function(x){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,0)};var G__10053__2=function(x,start){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__10053=function(x,start){switch(arguments.length){case 1:return G__10053__1.call(this,x);case 2:return G__10053__2.call(this,x,start)}throw new Error("Invalid arity: "+(arguments.length-
1));};G__10053.cljs$core$IFn$_invoke$arity$1=G__10053__1;G__10053.cljs$core$IFn$_invoke$arity$2=G__10053__2;return G__10053}();
cljs.core.ChunkedCons.prototype.lastIndexOf=function(){var G__10054=null;var G__10054__1=function(x){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll))};var G__10054__2=function(x,start){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__10054=function(x,start){switch(arguments.length){case 1:return G__10054__1.call(this,x);case 2:return G__10054__2.call(this,x,start)}throw new Error("Invalid arity: "+
(arguments.length-1));};G__10054.cljs$core$IFn$_invoke$arity$1=G__10054__1;G__10054.cljs$core$IFn$_invoke$arity$2=G__10054__2;return G__10054}();cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.meta};
cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1=function(coll){var self__=this;var coll__$1=this;if(cljs.core._count(self__.chunk)>1)return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null);else{var more__$1=cljs.core._seq(self__.more);if(more__$1==null)return null;else return more__$1}};
cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1=function(coll){var self__=this;var coll__$1=this;var h__7725__auto__=self__.__hash;if(!(h__7725__auto__==null))return h__7725__auto__;else{var h__7725__auto____$1=cljs.core.hash_ordered_coll(coll__$1);self__.__hash=h__7725__auto____$1;return h__7725__auto____$1}};cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2=function(coll,other){var self__=this;var coll__$1=this;return cljs.core.equiv_sequential(coll__$1,other)};
cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1=function(coll){var self__=this;var coll__$1=this;return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta)};cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1=function(coll){var self__=this;var coll__$1=this;return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,0)};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1=function(coll){var self__=this;var coll__$1=this;if(cljs.core._count(self__.chunk)>1)return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null);else if(self__.more==null)return cljs.core.List.EMPTY;else return self__.more};cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1=function(coll){var self__=this;var coll__$1=this;return coll__$1};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.chunk};cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1=function(coll){var self__=this;var coll__$1=this;if(self__.more==null)return cljs.core.List.EMPTY;else return self__.more};
cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2=function(coll,m){var self__=this;var coll__$1=this;return new cljs.core.ChunkedCons(self__.chunk,self__.more,m,self__.__hash)};cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2=function(this$,o){var self__=this;var this$__$1=this;return cljs.core.cons(o,this$__$1)};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1=function(coll){var self__=this;var coll__$1=this;if(self__.more==null)return null;else return self__.more};
cljs.core.ChunkedCons.getBasis=function(){return new cljs.core.PersistentVector(null,4,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"chunk","chunk",449371907,null),new cljs.core.Symbol(null,"more","more",-418290273,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null))],null)};
cljs.core.ChunkedCons.cljs$lang$type=true;cljs.core.ChunkedCons.cljs$lang$ctorStr="cljs.core/ChunkedCons";cljs.core.ChunkedCons.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/ChunkedCons")};cljs.core.__GT_ChunkedCons=function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){return new cljs.core.ChunkedCons(chunk,more,meta,__hash)};
cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL]=function(){var this__8311__auto__=this;return cljs.core.es6_iterator(this__8311__auto__)};cljs.core.chunk_cons=function cljs$core$chunk_cons(chunk,rest){if(cljs.core._count(chunk)===0)return rest;else return new cljs.core.ChunkedCons(chunk,rest,null,null)};cljs.core.chunk_append=function cljs$core$chunk_append(b,x){return b.add(x)};cljs.core.chunk=function cljs$core$chunk(b){return b.chunk()};cljs.core.chunk_first=function cljs$core$chunk_first(s){return cljs.core._chunked_first(s)};
cljs.core.chunk_rest=function cljs$core$chunk_rest(s){return cljs.core._chunked_rest(s)};cljs.core.chunk_next=function cljs$core$chunk_next(s){if(!(s==null)?s.cljs$lang$protocol_mask$partition1$&1024||cljs.core.PROTOCOL_SENTINEL===s.cljs$core$IChunkedNext$?true:false:false)return cljs.core._chunked_next(s);else return cljs.core.seq(cljs.core._chunked_rest(s))};
cljs.core.to_array=function cljs$core$to_array(s){var ary=[];var s__$1=cljs.core.seq(s);while(true){if(!(s__$1==null)){ary.push(cljs.core.first(s__$1));var G__10056=cljs.core.next(s__$1);s__$1=G__10056;continue}else return ary;break}};
cljs.core.to_array_2d=function cljs$core$to_array_2d(coll){var ret=new Array(cljs.core.count(coll));var i_10057=0;var xs_10058=cljs.core.seq(coll);while(true){if(xs_10058==null);else{ret[i_10057]=cljs.core.to_array(cljs.core.first(xs_10058));var G__10059=i_10057+1;var G__10060=cljs.core.next(xs_10058);i_10057=G__10059;xs_10058=G__10060;continue}break}return ret};
cljs.core.int_array=function cljs$core$int_array(var_args){var G__10062=arguments.length;switch(G__10062){case 1:return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$1=function(size_or_seq){if(typeof size_or_seq==="number")return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);else return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq)};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$2=function(size,init_val_or_seq){var a=new Array(size);if(cljs.core.seq_QMARK_(init_val_or_seq)){var s=cljs.core.seq(init_val_or_seq);var i=0;var s__$1=s;while(true){if(s__$1&&i<size){a[i]=cljs.core.first(s__$1);var G__10064=i+1;var G__10065=cljs.core.next(s__$1);i=G__10064;s__$1=G__10065;continue}else return a;break}}else{var n__8209__auto___10066=size;var i_10067=0;while(true){if(i_10067<n__8209__auto___10066){a[i_10067]=init_val_or_seq;var G__10068=
i_10067+1;i_10067=G__10068;continue}else;break}return a}};cljs.core.int_array.cljs$lang$maxFixedArity=2;
cljs.core.long_array=function cljs$core$long_array(var_args){var G__10070=arguments.length;switch(G__10070){case 1:return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$1=function(size_or_seq){if(typeof size_or_seq==="number")return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);else return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq)};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$2=function(size,init_val_or_seq){var a=new Array(size);if(cljs.core.seq_QMARK_(init_val_or_seq)){var s=cljs.core.seq(init_val_or_seq);var i=0;var s__$1=s;while(true){if(s__$1&&i<size){a[i]=cljs.core.first(s__$1);var G__10072=i+1;var G__10073=cljs.core.next(s__$1);i=G__10072;s__$1=G__10073;continue}else return a;break}}else{var n__8209__auto___10074=size;var i_10075=0;while(true){if(i_10075<n__8209__auto___10074){a[i_10075]=init_val_or_seq;var G__10076=
i_10075+1;i_10075=G__10076;continue}else;break}return a}};cljs.core.long_array.cljs$lang$maxFixedArity=2;
cljs.core.double_array=function cljs$core$double_array(var_args){var G__10078=arguments.length;switch(G__10078){case 1:return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$1=function(size_or_seq){if(typeof size_or_seq==="number")return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);else return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq)};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$2=function(size,init_val_or_seq){var a=new Array(size);if(cljs.core.seq_QMARK_(init_val_or_seq)){var s=cljs.core.seq(init_val_or_seq);var i=0;var s__$1=s;while(true){if(s__$1&&i<size){a[i]=cljs.core.first(s__$1);var G__10080=i+1;var G__10081=cljs.core.next(s__$1);i=G__10080;s__$1=G__10081;continue}else return a;break}}else{var n__8209__auto___10082=size;var i_10083=0;while(true){if(i_10083<n__8209__auto___10082){a[i_10083]=init_val_or_seq;var G__10084=
i_10083+1;i_10083=G__10084;continue}else;break}return a}};cljs.core.double_array.cljs$lang$maxFixedArity=2;
cljs.core.object_array=function cljs$core$object_array(var_args){var G__10086=arguments.length;switch(G__10086){case 1:return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$1=function(size_or_seq){if(typeof size_or_seq==="number")return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);else return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq)};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$2=function(size,init_val_or_seq){var a=new Array(size);if(cljs.core.seq_QMARK_(init_val_or_seq)){var s=cljs.core.seq(init_val_or_seq);var i=0;var s__$1=s;while(true){if(s__$1&&i<size){a[i]=cljs.core.first(s__$1);var G__10088=i+1;var G__10089=cljs.core.next(s__$1);i=G__10088;s__$1=G__10089;continue}else return a;break}}else{var n__8209__auto___10090=size;var i_10091=0;while(true){if(i_10091<n__8209__auto___10090){a[i_10091]=init_val_or_seq;var G__10092=
i_10091+1;i_10091=G__10092;continue}else;break}return a}};cljs.core.object_array.cljs$lang$maxFixedArity=2;cljs.core.bounded_count=function cljs$core$bounded_count(n,coll){if(cljs.core.counted_QMARK_(coll))return cljs.core.count(coll);else{var i=0;var s=cljs.core.seq(coll);while(true){if(!(s==null)&&i<n){var G__10093=i+1;var G__10094=cljs.core.next(s);i=G__10093;s=G__10094;continue}else return i;break}}};
cljs.core.spread=function cljs$core$spread(arglist){if(arglist==null)return null;else{var n=cljs.core.next(arglist);if(n==null)return cljs.core.seq(cljs.core.first(arglist));else return cljs.core.cons(cljs.core.first(arglist),cljs.core.spread.cljs$core$IFn$_invoke$arity$1?cljs.core.spread.cljs$core$IFn$_invoke$arity$1(n):cljs.core.spread.call(null,n))}};
cljs.core.concat=function cljs$core$concat(var_args){var G__10099=arguments.length;switch(G__10099){case 0:return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();break;case 1:return cljs.core.concat.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10101=arguments.length;var i__8411__auto___10102=0;while(true){if(i__8411__auto___10102<len__8410__auto___10101){args_arr__8429__auto__.push(arguments[i__8411__auto___10102]);
var G__10103=i__8411__auto___10102+1;i__8411__auto___10102=G__10103;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.concat.cljs$core$IFn$_invoke$arity$0=function(){return new cljs.core.LazySeq(null,function(){return null},null,null)};
cljs.core.concat.cljs$core$IFn$_invoke$arity$1=function(x){return new cljs.core.LazySeq(null,function(){return x},null,null)};
cljs.core.concat.cljs$core$IFn$_invoke$arity$2=function(x,y){return new cljs.core.LazySeq(null,function(){var s=cljs.core.seq(x);if(s)if(cljs.core.chunked_seq_QMARK_(s))return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));else return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));else return y},null,null)};
cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic=function(x,y,zs){var cat=function cljs$core$cat(xys,zs__$1){return new cljs.core.LazySeq(null,function(){var xys__$1=cljs.core.seq(xys);if(xys__$1)if(cljs.core.chunked_seq_QMARK_(xys__$1))return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$cat(cljs.core.chunk_rest(xys__$1),zs__$1));else return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$cat(cljs.core.rest(xys__$1),zs__$1));else if(cljs.core.truth_(zs__$1))return cljs$core$cat(cljs.core.first(zs__$1),
cljs.core.next(zs__$1));else return null},null,null)};return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs)};cljs.core.concat.cljs$lang$applyTo=function(seq10096){var G__10097=cljs.core.first(seq10096);var seq10096__$1=cljs.core.next(seq10096);var G__10098=cljs.core.first(seq10096__$1);var seq10096__$2=cljs.core.next(seq10096__$1);return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(G__10097,G__10098,seq10096__$2)};cljs.core.concat.cljs$lang$maxFixedArity=2;
cljs.core.list_STAR_=function cljs$core$list_STAR_(var_args){var G__10110=arguments.length;switch(G__10110){case 1:return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],
arguments[3]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10112=arguments.length;var i__8411__auto___10113=0;while(true){if(i__8411__auto___10113<len__8410__auto___10112){args_arr__8429__auto__.push(arguments[i__8411__auto___10113]);var G__10114=i__8411__auto___10113+1;i__8411__auto___10113=G__10114;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(4),0,null);return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0],
arguments[1],arguments[2],arguments[3],argseq__8430__auto__)}};cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1=function(args){return cljs.core.seq(args)};cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2=function(a,args){return cljs.core.cons(a,args)};cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3=function(a,b,args){return cljs.core.cons(a,cljs.core.cons(b,args))};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4=function(a,b,c,args){return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)))};cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic=function(a,b,c,d,more){return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))))};
cljs.core.list_STAR_.cljs$lang$applyTo=function(seq10105){var G__10106=cljs.core.first(seq10105);var seq10105__$1=cljs.core.next(seq10105);var G__10107=cljs.core.first(seq10105__$1);var seq10105__$2=cljs.core.next(seq10105__$1);var G__10108=cljs.core.first(seq10105__$2);var seq10105__$3=cljs.core.next(seq10105__$2);var G__10109=cljs.core.first(seq10105__$3);var seq10105__$4=cljs.core.next(seq10105__$3);return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__10106,G__10107,G__10108,G__10109,
seq10105__$4)};cljs.core.list_STAR_.cljs$lang$maxFixedArity=4;cljs.core.transient$=function cljs$core$transient(coll){return cljs.core._as_transient(coll)};cljs.core.persistent_BANG_=function cljs$core$persistent_BANG_(tcoll){return cljs.core._persistent_BANG_(tcoll)};
cljs.core.conj_BANG_=function cljs$core$conj_BANG_(var_args){var G__10119=arguments.length;switch(G__10119){case 0:return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();break;case 1:return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10121=arguments.length;var i__8411__auto___10122=0;while(true){if(i__8411__auto___10122<
len__8410__auto___10121){args_arr__8429__auto__.push(arguments[i__8411__auto___10122]);var G__10123=i__8411__auto___10122+1;i__8411__auto___10122=G__10123;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0=function(){return cljs.core.transient$(cljs.core.PersistentVector.EMPTY)};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1=function(tcoll){return tcoll};cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2=function(tcoll,val){return cljs.core._conj_BANG_(tcoll,val)};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic=function(tcoll,val,vals){while(true){var ntcoll=cljs.core._conj_BANG_(tcoll,val);if(cljs.core.truth_(vals)){var G__10124=ntcoll;var G__10125=cljs.core.first(vals);var G__10126=cljs.core.next(vals);tcoll=G__10124;val=G__10125;vals=G__10126;continue}else return ntcoll;break}};
cljs.core.conj_BANG_.cljs$lang$applyTo=function(seq10116){var G__10117=cljs.core.first(seq10116);var seq10116__$1=cljs.core.next(seq10116);var G__10118=cljs.core.first(seq10116__$1);var seq10116__$2=cljs.core.next(seq10116__$1);return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10117,G__10118,seq10116__$2)};cljs.core.conj_BANG_.cljs$lang$maxFixedArity=2;
cljs.core.assoc_BANG_=function cljs$core$assoc_BANG_(var_args){var G__10132=arguments.length;switch(G__10132){case 3:return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10134=arguments.length;var i__8411__auto___10135=0;while(true){if(i__8411__auto___10135<len__8410__auto___10134){args_arr__8429__auto__.push(arguments[i__8411__auto___10135]);var G__10136=i__8411__auto___10135+1;i__8411__auto___10135=
G__10136;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(3),0,null);return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],arguments[2],argseq__8430__auto__)}};cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3=function(tcoll,key,val){return cljs.core._assoc_BANG_(tcoll,key,val)};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic=function(tcoll,key,val,kvs){while(true){var ntcoll=cljs.core._assoc_BANG_(tcoll,key,val);if(cljs.core.truth_(kvs)){var G__10137=ntcoll;var G__10138=cljs.core.first(kvs);var G__10139=cljs.core.second(kvs);var G__10140=cljs.core.nnext(kvs);tcoll=G__10137;key=G__10138;val=G__10139;kvs=G__10140;continue}else return ntcoll;break}};
cljs.core.assoc_BANG_.cljs$lang$applyTo=function(seq10128){var G__10129=cljs.core.first(seq10128);var seq10128__$1=cljs.core.next(seq10128);var G__10130=cljs.core.first(seq10128__$1);var seq10128__$2=cljs.core.next(seq10128__$1);var G__10131=cljs.core.first(seq10128__$2);var seq10128__$3=cljs.core.next(seq10128__$2);return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10129,G__10130,G__10131,seq10128__$3)};cljs.core.assoc_BANG_.cljs$lang$maxFixedArity=3;
cljs.core.dissoc_BANG_=function cljs$core$dissoc_BANG_(var_args){var G__10145=arguments.length;switch(G__10145){case 2:return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10147=arguments.length;var i__8411__auto___10148=0;while(true){if(i__8411__auto___10148<len__8410__auto___10147){args_arr__8429__auto__.push(arguments[i__8411__auto___10148]);var G__10149=i__8411__auto___10148+1;i__8411__auto___10148=
G__10149;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2=function(tcoll,key){return cljs.core._dissoc_BANG_(tcoll,key)};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic=function(tcoll,key,ks){while(true){var ntcoll=cljs.core._dissoc_BANG_(tcoll,key);if(cljs.core.truth_(ks)){var G__10150=ntcoll;var G__10151=cljs.core.first(ks);var G__10152=cljs.core.next(ks);tcoll=G__10150;key=G__10151;ks=G__10152;continue}else return ntcoll;break}};
cljs.core.dissoc_BANG_.cljs$lang$applyTo=function(seq10142){var G__10143=cljs.core.first(seq10142);var seq10142__$1=cljs.core.next(seq10142);var G__10144=cljs.core.first(seq10142__$1);var seq10142__$2=cljs.core.next(seq10142__$1);return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10143,G__10144,seq10142__$2)};cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity=2;cljs.core.pop_BANG_=function cljs$core$pop_BANG_(tcoll){return cljs.core._pop_BANG_(tcoll)};
cljs.core.disj_BANG_=function cljs$core$disj_BANG_(var_args){var G__10157=arguments.length;switch(G__10157){case 2:return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10159=arguments.length;var i__8411__auto___10160=0;while(true){if(i__8411__auto___10160<len__8410__auto___10159){args_arr__8429__auto__.push(arguments[i__8411__auto___10160]);var G__10161=i__8411__auto___10160+1;i__8411__auto___10160=G__10161;
continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2=function(tcoll,val){return cljs.core._disjoin_BANG_(tcoll,val)};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic=function(tcoll,val,vals){while(true){var ntcoll=cljs.core._disjoin_BANG_(tcoll,val);if(cljs.core.truth_(vals)){var G__10162=ntcoll;var G__10163=cljs.core.first(vals);var G__10164=cljs.core.next(vals);tcoll=G__10162;val=G__10163;vals=G__10164;continue}else return ntcoll;break}};
cljs.core.disj_BANG_.cljs$lang$applyTo=function(seq10154){var G__10155=cljs.core.first(seq10154);var seq10154__$1=cljs.core.next(seq10154);var G__10156=cljs.core.first(seq10154__$1);var seq10154__$2=cljs.core.next(seq10154__$1);return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10155,G__10156,seq10154__$2)};cljs.core.disj_BANG_.cljs$lang$maxFixedArity=2;
cljs.core.apply_to=function cljs$core$apply_to(f,argc,args){var args__$1=cljs.core.seq(args);if(argc===0)return f.cljs$core$IFn$_invoke$arity$0?f.cljs$core$IFn$_invoke$arity$0():f.call(null);else{var a8253=cljs.core._first(args__$1);var args__$2=cljs.core._rest(args__$1);if(argc===1)return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(a8253):f.call(null,a8253);else{var b8254=cljs.core._first(args__$2);var args__$3=cljs.core._rest(args__$2);if(argc===2)return f.cljs$core$IFn$_invoke$arity$2?
f.cljs$core$IFn$_invoke$arity$2(a8253,b8254):f.call(null,a8253,b8254);else{var c8255=cljs.core._first(args__$3);var args__$4=cljs.core._rest(args__$3);if(argc===3)return f.cljs$core$IFn$_invoke$arity$3?f.cljs$core$IFn$_invoke$arity$3(a8253,b8254,c8255):f.call(null,a8253,b8254,c8255);else{var d8256=cljs.core._first(args__$4);var args__$5=cljs.core._rest(args__$4);if(argc===4)return f.cljs$core$IFn$_invoke$arity$4?f.cljs$core$IFn$_invoke$arity$4(a8253,b8254,c8255,d8256):f.call(null,a8253,b8254,c8255,
d8256);else{var e8257=cljs.core._first(args__$5);var args__$6=cljs.core._rest(args__$5);if(argc===5)return f.cljs$core$IFn$_invoke$arity$5?f.cljs$core$IFn$_invoke$arity$5(a8253,b8254,c8255,d8256,e8257):f.call(null,a8253,b8254,c8255,d8256,e8257);else{var f8258=cljs.core._first(args__$6);var args__$7=cljs.core._rest(args__$6);if(argc===6)return f.cljs$core$IFn$_invoke$arity$6?f.cljs$core$IFn$_invoke$arity$6(a8253,b8254,c8255,d8256,e8257,f8258):f.call(null,a8253,b8254,c8255,d8256,e8257,f8258);else{var g8259=
cljs.core._first(args__$7);var args__$8=cljs.core._rest(args__$7);if(argc===7)return f.cljs$core$IFn$_invoke$arity$7?f.cljs$core$IFn$_invoke$arity$7(a8253,b8254,c8255,d8256,e8257,f8258,g8259):f.call(null,a8253,b8254,c8255,d8256,e8257,f8258,g8259);else{var h8260=cljs.core._first(args__$8);var args__$9=cljs.core._rest(args__$8);if(argc===8)return f.cljs$core$IFn$_invoke$arity$8?f.cljs$core$IFn$_invoke$arity$8(a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260):f.call(null,a8253,b8254,c8255,d8256,e8257,
f8258,g8259,h8260);else{var i8261=cljs.core._first(args__$9);var args__$10=cljs.core._rest(args__$9);if(argc===9)return f.cljs$core$IFn$_invoke$arity$9?f.cljs$core$IFn$_invoke$arity$9(a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261):f.call(null,a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261);else{var j8262=cljs.core._first(args__$10);var args__$11=cljs.core._rest(args__$10);if(argc===10)return f.cljs$core$IFn$_invoke$arity$10?f.cljs$core$IFn$_invoke$arity$10(a8253,b8254,c8255,d8256,e8257,
f8258,g8259,h8260,i8261,j8262):f.call(null,a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262);else{var k8263=cljs.core._first(args__$11);var args__$12=cljs.core._rest(args__$11);if(argc===11)return f.cljs$core$IFn$_invoke$arity$11?f.cljs$core$IFn$_invoke$arity$11(a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263):f.call(null,a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263);else{var l8264=cljs.core._first(args__$12);var args__$13=cljs.core._rest(args__$12);
if(argc===12)return f.cljs$core$IFn$_invoke$arity$12?f.cljs$core$IFn$_invoke$arity$12(a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263,l8264):f.call(null,a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263,l8264);else{var m8265=cljs.core._first(args__$13);var args__$14=cljs.core._rest(args__$13);if(argc===13)return f.cljs$core$IFn$_invoke$arity$13?f.cljs$core$IFn$_invoke$arity$13(a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263,l8264,m8265):f.call(null,
a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263,l8264,m8265);else{var n8266=cljs.core._first(args__$14);var args__$15=cljs.core._rest(args__$14);if(argc===14)return f.cljs$core$IFn$_invoke$arity$14?f.cljs$core$IFn$_invoke$arity$14(a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263,l8264,m8265,n8266):f.call(null,a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263,l8264,m8265,n8266);else{var o8267=cljs.core._first(args__$15);var args__$16=cljs.core._rest(args__$15);
if(argc===15)return f.cljs$core$IFn$_invoke$arity$15?f.cljs$core$IFn$_invoke$arity$15(a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263,l8264,m8265,n8266,o8267):f.call(null,a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263,l8264,m8265,n8266,o8267);else{var p8268=cljs.core._first(args__$16);var args__$17=cljs.core._rest(args__$16);if(argc===16)return f.cljs$core$IFn$_invoke$arity$16?f.cljs$core$IFn$_invoke$arity$16(a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,
j8262,k8263,l8264,m8265,n8266,o8267,p8268):f.call(null,a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263,l8264,m8265,n8266,o8267,p8268);else{var q8269=cljs.core._first(args__$17);var args__$18=cljs.core._rest(args__$17);if(argc===17)return f.cljs$core$IFn$_invoke$arity$17?f.cljs$core$IFn$_invoke$arity$17(a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263,l8264,m8265,n8266,o8267,p8268,q8269):f.call(null,a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263,
l8264,m8265,n8266,o8267,p8268,q8269);else{var r8270=cljs.core._first(args__$18);var args__$19=cljs.core._rest(args__$18);if(argc===18)return f.cljs$core$IFn$_invoke$arity$18?f.cljs$core$IFn$_invoke$arity$18(a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263,l8264,m8265,n8266,o8267,p8268,q8269,r8270):f.call(null,a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263,l8264,m8265,n8266,o8267,p8268,q8269,r8270);else{var s8271=cljs.core._first(args__$19);var args__$20=cljs.core._rest(args__$19);
if(argc===19)return f.cljs$core$IFn$_invoke$arity$19?f.cljs$core$IFn$_invoke$arity$19(a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263,l8264,m8265,n8266,o8267,p8268,q8269,r8270,s8271):f.call(null,a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263,l8264,m8265,n8266,o8267,p8268,q8269,r8270,s8271);else{var t8272=cljs.core._first(args__$20);var args__$21=cljs.core._rest(args__$20);if(argc===20)return f.cljs$core$IFn$_invoke$arity$20?f.cljs$core$IFn$_invoke$arity$20(a8253,
b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263,l8264,m8265,n8266,o8267,p8268,q8269,r8270,s8271,t8272):f.call(null,a8253,b8254,c8255,d8256,e8257,f8258,g8259,h8260,i8261,j8262,k8263,l8264,m8265,n8266,o8267,p8268,q8269,r8270,s8271,t8272);else throw new Error("Only up to 20 arguments supported on functions");}}}}}}}}}}}}}}}}}}}}};
cljs.core.apply_to_simple=function cljs$core$apply_to_simple(var_args){var G__10166=arguments.length;switch(G__10166){case 2:return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;case 5:return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(arguments[0],
arguments[1],arguments[2],arguments[3],arguments[4]);break;case 6:return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2=function(f,args){if(args==null)if(f.cljs$core$IFn$_invoke$arity$0)return f.cljs$core$IFn$_invoke$arity$0();else return f.call(f);else return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,cljs.core._first(args),cljs.core.next(args))};
cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3=function(f,a0,args){if(args==null)if(f.cljs$core$IFn$_invoke$arity$1)return f.cljs$core$IFn$_invoke$arity$1(a0);else return f.call(f,a0);else return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,a0,cljs.core._first(args),cljs.core.next(args))};
cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4=function(f,a0,a1,args){if(args==null)if(f.cljs$core$IFn$_invoke$arity$2)return f.cljs$core$IFn$_invoke$arity$2(a0,a1);else return f.call(f,a0,a1);else return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,a0,a1,cljs.core._first(args),cljs.core.next(args))};
cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5=function(f,a0,a1,a2,args){if(args==null)if(f.cljs$core$IFn$_invoke$arity$3)return f.cljs$core$IFn$_invoke$arity$3(a0,a1,a2);else return f.call(f,a0,a1,a2);else return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a0,a1,a2,cljs.core._first(args),cljs.core.next(args))};
cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6=function(f,a0,a1,a2,a3,args){if(args==null)if(f.cljs$core$IFn$_invoke$arity$4)return f.cljs$core$IFn$_invoke$arity$4(a0,a1,a2,a3);else return f.call(f,a0,a1,a2,a3);else{var a4=cljs.core._first(args);var next_4=cljs.core.next(args);if(next_4==null)if(f.cljs$core$IFn$_invoke$arity$5)return f.cljs$core$IFn$_invoke$arity$5(a0,a1,a2,a3,a4);else return f.call(f,a0,a1,a2,a3,a4);else{var a5=cljs.core._first(next_4);var next_5=cljs.core.next(next_4);
if(next_5==null)if(f.cljs$core$IFn$_invoke$arity$6)return f.cljs$core$IFn$_invoke$arity$6(a0,a1,a2,a3,a4,a5);else return f.call(f,a0,a1,a2,a3,a4,a5);else{var a6=cljs.core._first(next_5);var next_6=cljs.core.next(next_5);if(next_6==null)if(f.cljs$core$IFn$_invoke$arity$7)return f.cljs$core$IFn$_invoke$arity$7(a0,a1,a2,a3,a4,a5,a6);else return f.call(f,a0,a1,a2,a3,a4,a5,a6);else{var a7=cljs.core._first(next_6);var next_7=cljs.core.next(next_6);if(next_7==null)if(f.cljs$core$IFn$_invoke$arity$8)return f.cljs$core$IFn$_invoke$arity$8(a0,
a1,a2,a3,a4,a5,a6,a7);else return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7);else{var a8=cljs.core._first(next_7);var next_8=cljs.core.next(next_7);if(next_8==null)if(f.cljs$core$IFn$_invoke$arity$9)return f.cljs$core$IFn$_invoke$arity$9(a0,a1,a2,a3,a4,a5,a6,a7,a8);else return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8);else{var a9=cljs.core._first(next_8);var next_9=cljs.core.next(next_8);if(next_9==null)if(f.cljs$core$IFn$_invoke$arity$10)return f.cljs$core$IFn$_invoke$arity$10(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);else return f.call(f,
a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);else{var a10=cljs.core._first(next_9);var next_10=cljs.core.next(next_9);if(next_10==null)if(f.cljs$core$IFn$_invoke$arity$11)return f.cljs$core$IFn$_invoke$arity$11(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);else return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);else{var a11=cljs.core._first(next_10);var next_11=cljs.core.next(next_10);if(next_11==null)if(f.cljs$core$IFn$_invoke$arity$12)return f.cljs$core$IFn$_invoke$arity$12(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);else return f.call(f,
a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);else{var a12=cljs.core._first(next_11);var next_12=cljs.core.next(next_11);if(next_12==null)if(f.cljs$core$IFn$_invoke$arity$13)return f.cljs$core$IFn$_invoke$arity$13(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);else return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);else{var a13=cljs.core._first(next_12);var next_13=cljs.core.next(next_12);if(next_13==null)if(f.cljs$core$IFn$_invoke$arity$14)return f.cljs$core$IFn$_invoke$arity$14(a0,a1,a2,a3,a4,a5,a6,
a7,a8,a9,a10,a11,a12,a13);else return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);else{var a14=cljs.core._first(next_13);var next_14=cljs.core.next(next_13);if(next_14==null)if(f.cljs$core$IFn$_invoke$arity$15)return f.cljs$core$IFn$_invoke$arity$15(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);else return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);else{var a15=cljs.core._first(next_14);var next_15=cljs.core.next(next_14);if(next_15==null)if(f.cljs$core$IFn$_invoke$arity$16)return f.cljs$core$IFn$_invoke$arity$16(a0,
a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);else return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);else{var a16=cljs.core._first(next_15);var next_16=cljs.core.next(next_15);if(next_16==null)if(f.cljs$core$IFn$_invoke$arity$17)return f.cljs$core$IFn$_invoke$arity$17(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);else return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);else{var a17=cljs.core._first(next_16);var next_17=cljs.core.next(next_16);
if(next_17==null)if(f.cljs$core$IFn$_invoke$arity$18)return f.cljs$core$IFn$_invoke$arity$18(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);else return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);else{var a18=cljs.core._first(next_17);var next_18=cljs.core.next(next_17);if(next_18==null)if(f.cljs$core$IFn$_invoke$arity$19)return f.cljs$core$IFn$_invoke$arity$19(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);else return f.call(f,a0,a1,
a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);else{var a19=cljs.core._first(next_18);var next_19=cljs.core.next(next_18);if(next_19==null)if(f.cljs$core$IFn$_invoke$arity$20)return f.cljs$core$IFn$_invoke$arity$20(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);else return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);else{var arr__8281__auto__=[a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19];var s__8282__auto___10168=
next_19;while(true){if(s__8282__auto___10168){arr__8281__auto__.push(cljs.core._first(s__8282__auto___10168));var G__10169=cljs.core.next(s__8282__auto___10168);s__8282__auto___10168=G__10169;continue}else;break}return f.apply(f,arr__8281__auto__)}}}}}}}}}}}}}}}}}};cljs.core.apply_to_simple.cljs$lang$maxFixedArity=6;
cljs.core.apply=function cljs$core$apply(var_args){var G__10177=arguments.length;switch(G__10177){case 2:return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;case 5:return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(arguments[0],arguments[1],
arguments[2],arguments[3],arguments[4]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10179=arguments.length;var i__8411__auto___10180=0;while(true){if(i__8411__auto___10180<len__8410__auto___10179){args_arr__8429__auto__.push(arguments[i__8411__auto___10180]);var G__10181=i__8411__auto___10180+1;i__8411__auto___10180=G__10181;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(5),0,null);return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(arguments[0],
arguments[1],arguments[2],arguments[3],arguments[4],argseq__8430__auto__)}};cljs.core.apply.cljs$core$IFn$_invoke$arity$2=function(f,args){if(f.cljs$lang$applyTo){var fixed_arity=f.cljs$lang$maxFixedArity;var bc=cljs.core.bounded_count(fixed_arity+1,args);if(bc<=fixed_arity)return cljs.core.apply_to(f,bc,args);else return f.cljs$lang$applyTo(args)}else return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(args))};
cljs.core.apply.cljs$core$IFn$_invoke$arity$3=function(f,x,args){if(f.cljs$lang$applyTo){var arglist=cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);var fixed_arity=f.cljs$lang$maxFixedArity;var bc=cljs.core.bounded_count(fixed_arity,args)+1;if(bc<=fixed_arity)return cljs.core.apply_to(f,bc,arglist);else return f.cljs$lang$applyTo(arglist)}else return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,x,cljs.core.seq(args))};
cljs.core.apply.cljs$core$IFn$_invoke$arity$4=function(f,x,y,args){if(f.cljs$lang$applyTo){var arglist=cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);var fixed_arity=f.cljs$lang$maxFixedArity;var bc=2+cljs.core.bounded_count(fixed_arity-1,args);if(bc<=fixed_arity)return cljs.core.apply_to(f,bc,arglist);else return f.cljs$lang$applyTo(arglist)}else return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,x,y,cljs.core.seq(args))};
cljs.core.apply.cljs$core$IFn$_invoke$arity$5=function(f,x,y,z,args){if(f.cljs$lang$applyTo){var arglist=cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);var fixed_arity=f.cljs$lang$maxFixedArity;var bc=3+cljs.core.bounded_count(fixed_arity-2,args);if(bc<=fixed_arity)return cljs.core.apply_to(f,bc,arglist);else return f.cljs$lang$applyTo(arglist)}else return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,x,y,z,cljs.core.seq(args))};
cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic=function(f,a,b,c,d,args){if(f.cljs$lang$applyTo){var spread_args=cljs.core.spread(args);var arglist=cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,spread_args))));var fixed_arity=f.cljs$lang$maxFixedArity;var bc=4+cljs.core.bounded_count(fixed_arity-3,spread_args);if(bc<=fixed_arity)return cljs.core.apply_to(f,bc,arglist);else return f.cljs$lang$applyTo(arglist)}else return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,
a,b,c,d,cljs.core.spread(args))};
cljs.core.apply.cljs$lang$applyTo=function(seq10171){var G__10172=cljs.core.first(seq10171);var seq10171__$1=cljs.core.next(seq10171);var G__10173=cljs.core.first(seq10171__$1);var seq10171__$2=cljs.core.next(seq10171__$1);var G__10174=cljs.core.first(seq10171__$2);var seq10171__$3=cljs.core.next(seq10171__$2);var G__10175=cljs.core.first(seq10171__$3);var seq10171__$4=cljs.core.next(seq10171__$3);var G__10176=cljs.core.first(seq10171__$4);var seq10171__$5=cljs.core.next(seq10171__$4);return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(G__10172,
G__10173,G__10174,G__10175,G__10176,seq10171__$5)};cljs.core.apply.cljs$lang$maxFixedArity=5;
cljs.core.vary_meta=function cljs$core$vary_meta(var_args){var G__10190=arguments.length;switch(G__10190){case 2:return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;case 5:return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5(arguments[0],
arguments[1],arguments[2],arguments[3],arguments[4]);break;case 6:return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10207=arguments.length;var i__8411__auto___10208=0;while(true){if(i__8411__auto___10208<len__8410__auto___10207){args_arr__8429__auto__.push(arguments[i__8411__auto___10208]);var G__10209=i__8411__auto___10208+1;i__8411__auto___10208=
G__10209;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(6),0,null);return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],argseq__8430__auto__)}};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2=function(obj,f){return cljs.core.with_meta(obj,function(){var G__10191=cljs.core.meta(obj);return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10191):f.call(null,G__10191)}())};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3=function(obj,f,a){return cljs.core.with_meta(obj,function(){var G__10192=cljs.core.meta(obj);var G__10193=a;return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__10192,G__10193):f.call(null,G__10192,G__10193)}())};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4=function(obj,f,a,b){return cljs.core.with_meta(obj,function(){var G__10194=cljs.core.meta(obj);var G__10195=a;var G__10196=b;return f.cljs$core$IFn$_invoke$arity$3?f.cljs$core$IFn$_invoke$arity$3(G__10194,G__10195,G__10196):f.call(null,G__10194,G__10195,G__10196)}())};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5=function(obj,f,a,b,c){return cljs.core.with_meta(obj,function(){var G__10197=cljs.core.meta(obj);var G__10198=a;var G__10199=b;var G__10200=c;return f.cljs$core$IFn$_invoke$arity$4?f.cljs$core$IFn$_invoke$arity$4(G__10197,G__10198,G__10199,G__10200):f.call(null,G__10197,G__10198,G__10199,G__10200)}())};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6=function(obj,f,a,b,c,d){return cljs.core.with_meta(obj,function(){var G__10201=cljs.core.meta(obj);var G__10202=a;var G__10203=b;var G__10204=c;var G__10205=d;return f.cljs$core$IFn$_invoke$arity$5?f.cljs$core$IFn$_invoke$arity$5(G__10201,G__10202,G__10203,G__10204,G__10205):f.call(null,G__10201,G__10202,G__10203,G__10204,G__10205)}())};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic=function(obj,f,a,b,c,d,args){return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([d,args],0)))};
cljs.core.vary_meta.cljs$lang$applyTo=function(seq10183){var G__10184=cljs.core.first(seq10183);var seq10183__$1=cljs.core.next(seq10183);var G__10185=cljs.core.first(seq10183__$1);var seq10183__$2=cljs.core.next(seq10183__$1);var G__10186=cljs.core.first(seq10183__$2);var seq10183__$3=cljs.core.next(seq10183__$2);var G__10187=cljs.core.first(seq10183__$3);var seq10183__$4=cljs.core.next(seq10183__$3);var G__10188=cljs.core.first(seq10183__$4);var seq10183__$5=cljs.core.next(seq10183__$4);var G__10189=
cljs.core.first(seq10183__$5);var seq10183__$6=cljs.core.next(seq10183__$5);return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(G__10184,G__10185,G__10186,G__10187,G__10188,G__10189,seq10183__$6)};cljs.core.vary_meta.cljs$lang$maxFixedArity=6;
cljs.core.not_EQ_=function cljs$core$not_EQ_(var_args){var G__10214=arguments.length;switch(G__10214){case 1:return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10216=arguments.length;var i__8411__auto___10217=0;while(true){if(i__8411__auto___10217<len__8410__auto___10216){args_arr__8429__auto__.push(arguments[i__8411__auto___10217]);
var G__10218=i__8411__auto___10217+1;i__8411__auto___10217=G__10218;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1=function(x){return false};cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2=function(x,y){return!cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic=function(x,y,more){return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more))};cljs.core.not_EQ_.cljs$lang$applyTo=function(seq10211){var G__10212=cljs.core.first(seq10211);var seq10211__$1=cljs.core.next(seq10211);var G__10213=cljs.core.first(seq10211__$1);var seq10211__$2=cljs.core.next(seq10211__$1);return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__10212,G__10213,seq10211__$2)};
cljs.core.not_EQ_.cljs$lang$maxFixedArity=2;cljs.core.not_empty=function cljs$core$not_empty(coll){if(cljs.core.seq(coll))return coll;else return null};
cljs.core.nil_iter=function cljs$core$nil_iter(){if(typeof cljs.core.t_cljs$core10219!=="undefined");else{cljs.core.t_cljs$core10219=function(meta10220){this.meta10220=meta10220;this.cljs$lang$protocol_mask$partition0$=393216;this.cljs$lang$protocol_mask$partition1$=0};cljs.core.t_cljs$core10219.prototype.cljs$core$IWithMeta$_with_meta$arity$2=function(_10221,meta10220__$1){var self__=this;var _10221__$1=this;return new cljs.core.t_cljs$core10219(meta10220__$1)};cljs.core.t_cljs$core10219.prototype.cljs$core$IMeta$_meta$arity$1=
function(_10221){var self__=this;var _10221__$1=this;return self__.meta10220};cljs.core.t_cljs$core10219.prototype.hasNext=function(){var self__=this;var _=this;return false};cljs.core.t_cljs$core10219.prototype.next=function(){var self__=this;var _=this;return new Error("No such element")};cljs.core.t_cljs$core10219.prototype.remove=function(){var self__=this;var _=this;return new Error("Unsupported operation")};cljs.core.t_cljs$core10219.getBasis=function(){return new cljs.core.PersistentVector(null,
1,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"meta10220","meta10220",286796140,null)],null)};cljs.core.t_cljs$core10219.cljs$lang$type=true;cljs.core.t_cljs$core10219.cljs$lang$ctorStr="cljs.core/t_cljs$core10219";cljs.core.t_cljs$core10219.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/t_cljs$core10219")};cljs.core.__GT_t_cljs$core10219=function cljs$core$nil_iter_$___GT_t_cljs$core10219(meta10220){return new cljs.core.t_cljs$core10219(meta10220)}}return new cljs.core.t_cljs$core10219(cljs.core.PersistentArrayMap.EMPTY)};
cljs.core.StringIter=function(s,i){this.s=s;this.i=i};cljs.core.StringIter.prototype.hasNext=function(){var self__=this;var _=this;return self__.i<self__.s.length};cljs.core.StringIter.prototype.next=function(){var self__=this;var _=this;var ret=self__.s.charAt(self__.i);self__.i=self__.i+1;return ret};cljs.core.StringIter.prototype.remove=function(){var self__=this;var _=this;return new Error("Unsupported operation")};
cljs.core.StringIter.getBasis=function(){return new cljs.core.PersistentVector(null,2,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null))],null)};cljs.core.StringIter.cljs$lang$type=true;cljs.core.StringIter.cljs$lang$ctorStr="cljs.core/StringIter";
cljs.core.StringIter.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/StringIter")};cljs.core.__GT_StringIter=function cljs$core$__GT_StringIter(s,i){return new cljs.core.StringIter(s,i)};cljs.core.string_iter=function cljs$core$string_iter(x){return new cljs.core.StringIter(x,0)};cljs.core.ArrayIter=function(arr,i){this.arr=arr;this.i=i};
cljs.core.ArrayIter.prototype.hasNext=function(){var self__=this;var _=this;return self__.i<self__.arr.length};cljs.core.ArrayIter.prototype.next=function(){var self__=this;var _=this;var ret=self__.arr[self__.i];self__.i=self__.i+1;return ret};cljs.core.ArrayIter.prototype.remove=function(){var self__=this;var _=this;return new Error("Unsupported operation")};
cljs.core.ArrayIter.getBasis=function(){return new cljs.core.PersistentVector(null,2,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null))],null)};cljs.core.ArrayIter.cljs$lang$type=true;cljs.core.ArrayIter.cljs$lang$ctorStr="cljs.core/ArrayIter";
cljs.core.ArrayIter.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/ArrayIter")};cljs.core.__GT_ArrayIter=function cljs$core$__GT_ArrayIter(arr,i){return new cljs.core.ArrayIter(arr,i)};cljs.core.array_iter=function cljs$core$array_iter(x){return new cljs.core.ArrayIter(x,0)};cljs.core.INIT={};cljs.core.START={};cljs.core.SeqIter=function(_seq,_next){this._seq=_seq;this._next=_next};
cljs.core.SeqIter.prototype.hasNext=function(){var self__=this;var _=this;if(self__._seq===cljs.core.INIT){self__._seq=cljs.core.START;self__._next=cljs.core.seq(self__._next)}else if(self__._seq===self__._next)self__._next=cljs.core.next(self__._seq);else;return!(self__._next==null)};cljs.core.SeqIter.prototype.next=function(){var self__=this;var this$=this;if(!this$.hasNext())throw new Error("No such element");else{self__._seq=self__._next;return cljs.core.first(self__._next)}};
cljs.core.SeqIter.prototype.remove=function(){var self__=this;var _=this;return new Error("Unsupported operation")};
cljs.core.SeqIter.getBasis=function(){return new cljs.core.PersistentVector(null,2,5,cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.with_meta(new cljs.core.Symbol(null,"_seq","_seq",-449557847,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null))],
null)};cljs.core.SeqIter.cljs$lang$type=true;cljs.core.SeqIter.cljs$lang$ctorStr="cljs.core/SeqIter";cljs.core.SeqIter.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/SeqIter")};cljs.core.__GT_SeqIter=function cljs$core$__GT_SeqIter(_seq,_next){return new cljs.core.SeqIter(_seq,_next)};cljs.core.seq_iter=function cljs$core$seq_iter(coll){return new cljs.core.SeqIter(cljs.core.INIT,coll)};
cljs.core.iter=function cljs$core$iter(coll){if(coll==null)return cljs.core.nil_iter();else if(typeof coll==="string")return cljs.core.string_iter(coll);else if(cljs.core.array_QMARK_(coll))return cljs.core.array_iter(coll);else if(cljs.core.iterable_QMARK_(coll))return cljs.core._iterator(coll);else if(cljs.core.seqable_QMARK_(coll))return cljs.core.seq_iter(coll);else throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Cannot create iterator from "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)].join(""));
};cljs.core.Many=function(vals){this.vals=vals};cljs.core.Many.prototype.add=function(o){var self__=this;var this$=this;self__.vals.push(o);return this$};cljs.core.Many.prototype.remove=function(){var self__=this;var this$=this;return self__.vals.shift()};cljs.core.Many.prototype.isEmpty=function(){var self__=this;var this$=this;return self__.vals.length===0};cljs.core.Many.prototype.toString=function(){var self__=this;var this$=this;return[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Many: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.vals)].join("")};
cljs.core.Many.getBasis=function(){return new cljs.core.PersistentVector(null,1,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"vals","vals",-1886377036,null)],null)};cljs.core.Many.cljs$lang$type=true;cljs.core.Many.cljs$lang$ctorStr="cljs.core/Many";cljs.core.Many.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/Many")};cljs.core.__GT_Many=function cljs$core$__GT_Many(vals){return new cljs.core.Many(vals)};
cljs.core.NONE={};cljs.core.Single=function(val){this.val=val};cljs.core.Single.prototype.add=function(o){var self__=this;var this$=this;if(self__.val===cljs.core.NONE){self__.val=o;return this$}else return new cljs.core.Many([self__.val,o])};
cljs.core.Single.prototype.remove=function(){var self__=this;var this$=this;if(self__.val===cljs.core.NONE)throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Removing object from empty buffer")].join(""));else{var ret=self__.val;self__.val=cljs.core.NONE;return ret}};cljs.core.Single.prototype.isEmpty=function(){var self__=this;var this$=this;return self__.val===cljs.core.NONE};
cljs.core.Single.prototype.toString=function(){var self__=this;var this$=this;return[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Single: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.val)].join("")};
cljs.core.Single.getBasis=function(){return new cljs.core.PersistentVector(null,1,5,cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null))],null)};cljs.core.Single.cljs$lang$type=true;cljs.core.Single.cljs$lang$ctorStr="cljs.core/Single";
cljs.core.Single.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/Single")};cljs.core.__GT_Single=function cljs$core$__GT_Single(val){return new cljs.core.Single(val)};cljs.core.Empty=function(){};cljs.core.Empty.prototype.add=function(o){var self__=this;var this$=this;return new cljs.core.Single(o)};
cljs.core.Empty.prototype.remove=function(){var self__=this;var this$=this;throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Removing object from empty buffer")].join(""));};cljs.core.Empty.prototype.isEmpty=function(){var self__=this;var this$=this;return true};cljs.core.Empty.prototype.toString=function(){var self__=this;var this$=this;return"Empty"};cljs.core.Empty.getBasis=function(){return cljs.core.PersistentVector.EMPTY};cljs.core.Empty.cljs$lang$type=true;
cljs.core.Empty.cljs$lang$ctorStr="cljs.core/Empty";cljs.core.Empty.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/Empty")};cljs.core.__GT_Empty=function cljs$core$__GT_Empty(){return new cljs.core.Empty};cljs.core.EMPTY=new cljs.core.Empty;cljs.core.MultiIterator=function(iters){this.iters=iters};
cljs.core.MultiIterator.prototype.hasNext=function(){var self__=this;var _=this;var iters__$1=cljs.core.seq(self__.iters);while(true){if(!(iters__$1==null)){var iter=cljs.core.first(iters__$1);if(!iter.hasNext())return false;else{var G__10222=cljs.core.next(iters__$1);iters__$1=G__10222;continue}}else return true;break}};
cljs.core.MultiIterator.prototype.next=function(){var self__=this;var _=this;var nexts=[];var n__8209__auto___10223=self__.iters.length;var i_10224=0;while(true){if(i_10224<n__8209__auto___10223){nexts[i_10224]=self__.iters[i_10224].next();var G__10225=i_10224+1;i_10224=G__10225;continue}else;break}return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(nexts,0)};
cljs.core.MultiIterator.getBasis=function(){return new cljs.core.PersistentVector(null,1,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"iters","iters",719353031,null)],null)};cljs.core.MultiIterator.cljs$lang$type=true;cljs.core.MultiIterator.cljs$lang$ctorStr="cljs.core/MultiIterator";cljs.core.MultiIterator.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/MultiIterator")};
cljs.core.__GT_MultiIterator=function cljs$core$__GT_MultiIterator(iters){return new cljs.core.MultiIterator(iters)};
cljs.core.chunkIteratorSeq=function cljs$core$chunkIteratorSeq(iter){return new cljs.core.LazySeq(null,function(){if(iter.hasNext()){var arr=[];var n=0;while(true){if(cljs.core.truth_(function(){var and__7273__auto__=iter.hasNext();if(cljs.core.truth_(and__7273__auto__))return n<32;else return and__7273__auto__}())){arr[n]=iter.next();var G__10226=n+1;n=G__10226;continue}else return cljs.core.chunk_cons(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arr,0,n),cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1?
cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1(iter):cljs.core.chunkIteratorSeq.call(null,iter));break}}else return null},null,null)};cljs.core.TransformerIterator=function(buffer,_next,completed,xf,sourceIter,multi){this.buffer=buffer;this._next=_next;this.completed=completed;this.xf=xf;this.sourceIter=sourceIter;this.multi=multi};
cljs.core.TransformerIterator.prototype.step=function(){var self__=this;var this$=this;if(!(self__._next===cljs.core.NONE))return true;else while(true){if(self__._next===cljs.core.NONE)if(self__.buffer.isEmpty())if(self__.completed)return false;else if(self__.sourceIter.hasNext()){var iter=self__.multi?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xf,cljs.core.cons(null,self__.sourceIter.next())):function(){var G__10227=null;var G__10228=self__.sourceIter.next();return self__.xf.cljs$core$IFn$_invoke$arity$2?
self__.xf.cljs$core$IFn$_invoke$arity$2(G__10227,G__10228):self__.xf.call(null,G__10227,G__10228)}();if(cljs.core.reduced_QMARK_(iter)){self__.xf.cljs$core$IFn$_invoke$arity$1?self__.xf.cljs$core$IFn$_invoke$arity$1(null):self__.xf.call(null,null);self__.completed=true}else;continue}else{self__.xf.cljs$core$IFn$_invoke$arity$1?self__.xf.cljs$core$IFn$_invoke$arity$1(null):self__.xf.call(null,null);self__.completed=true;continue}else{self__._next=self__.buffer.remove();continue}else return true;break}};
cljs.core.TransformerIterator.prototype.hasNext=function(){var self__=this;var this$=this;return this$.step()};cljs.core.TransformerIterator.prototype.next=function(){var self__=this;var this$=this;if(this$.hasNext()){var ret=self__._next;self__._next=cljs.core.NONE;return ret}else throw new Error("No such element");};cljs.core.TransformerIterator.prototype.remove=function(){var self__=this;var _=this;return new Error("Unsupported operation")};
cljs.core.TransformerIterator.getBasis=function(){return new cljs.core.PersistentVector(null,6,5,cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.with_meta(new cljs.core.Symbol(null,"buffer","buffer",-2037140571,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),
true],null)),cljs.core.with_meta(new cljs.core.Symbol(null,"completed","completed",1154475024,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null)),cljs.core.with_meta(new cljs.core.Symbol(null,"xf","xf",2042434515,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null)),new cljs.core.Symbol(null,"sourceIter","sourceIter",1068220306,null),new cljs.core.Symbol(null,"multi","multi",
1450238522,null)],null)};cljs.core.TransformerIterator.cljs$lang$type=true;cljs.core.TransformerIterator.cljs$lang$ctorStr="cljs.core/TransformerIterator";cljs.core.TransformerIterator.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/TransformerIterator")};
cljs.core.__GT_TransformerIterator=function cljs$core$__GT_TransformerIterator(buffer,_next,completed,xf,sourceIter,multi){return new cljs.core.TransformerIterator(buffer,_next,completed,xf,sourceIter,multi)};cljs.core.TransformerIterator.prototype[cljs.core.ITER_SYMBOL]=function(){var this__8311__auto__=this;return cljs.core.es6_iterator(this__8311__auto__)};
cljs.core.transformer_iterator=function cljs$core$transformer_iterator(xform,sourceIter,multi){var iterator=new cljs.core.TransformerIterator(cljs.core.EMPTY,cljs.core.NONE,false,null,sourceIter,multi);iterator.xf=function(){var G__10229=function(iterator){return function(){var G__10230=null;var G__10230__0=function(){return null};var G__10230__1=function(acc){return acc};var G__10230__2=function(acc,o){iterator.buffer=iterator.buffer.add(o);return acc};G__10230=function(acc,o){switch(arguments.length){case 0:return G__10230__0.call(this);
case 1:return G__10230__1.call(this,acc);case 2:return G__10230__2.call(this,acc,o)}throw new Error("Invalid arity: "+(arguments.length-1));};G__10230.cljs$core$IFn$_invoke$arity$0=G__10230__0;G__10230.cljs$core$IFn$_invoke$arity$1=G__10230__1;G__10230.cljs$core$IFn$_invoke$arity$2=G__10230__2;return G__10230}()}(iterator);return xform.cljs$core$IFn$_invoke$arity$1?xform.cljs$core$IFn$_invoke$arity$1(G__10229):xform.call(null,G__10229)}();return iterator};
cljs.core.TransformerIterator.create=function(xform,coll){return cljs.core.transformer_iterator(xform,cljs.core.iter(coll),false)};
cljs.core.TransformerIterator.createMulti=function(xform,colls){var iters=[];var seq__10231_10235=cljs.core.seq(colls);var chunk__10232_10236=null;var count__10233_10237=0;var i__10234_10238=0;while(true){if(i__10234_10238<count__10233_10237){var coll_10239=chunk__10232_10236.cljs$core$IIndexed$_nth$arity$2(null,i__10234_10238);iters.push(cljs.core.iter(coll_10239));var G__10240=seq__10231_10235;var G__10241=chunk__10232_10236;var G__10242=count__10233_10237;var G__10243=i__10234_10238+1;seq__10231_10235=
G__10240;chunk__10232_10236=G__10241;count__10233_10237=G__10242;i__10234_10238=G__10243;continue}else{var temp__4657__auto___10244=cljs.core.seq(seq__10231_10235);if(temp__4657__auto___10244){var seq__10231_10245__$1=temp__4657__auto___10244;if(cljs.core.chunked_seq_QMARK_(seq__10231_10245__$1)){var c__8105__auto___10246=cljs.core.chunk_first(seq__10231_10245__$1);var G__10247=cljs.core.chunk_rest(seq__10231_10245__$1);var G__10248=c__8105__auto___10246;var G__10249=cljs.core.count(c__8105__auto___10246);
var G__10250=0;seq__10231_10235=G__10247;chunk__10232_10236=G__10248;count__10233_10237=G__10249;i__10234_10238=G__10250;continue}else{var coll_10251=cljs.core.first(seq__10231_10245__$1);iters.push(cljs.core.iter(coll_10251));var G__10252=cljs.core.next(seq__10231_10245__$1);var G__10253=null;var G__10254=0;var G__10255=0;seq__10231_10235=G__10252;chunk__10232_10236=G__10253;count__10233_10237=G__10254;i__10234_10238=G__10255;continue}}else;}break}return cljs.core.transformer_iterator(xform,new cljs.core.MultiIterator(iters),
true)};
cljs.core.sequence=function cljs$core$sequence(var_args){var G__10260=arguments.length;switch(G__10260){case 1:return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10262=arguments.length;var i__8411__auto___10263=0;while(true){if(i__8411__auto___10263<len__8410__auto___10262){args_arr__8429__auto__.push(arguments[i__8411__auto___10263]);var G__10264=
i__8411__auto___10263+1;i__8411__auto___10263=G__10264;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.sequence.cljs$core$IFn$_invoke$arity$1=function(coll){if(cljs.core.seq_QMARK_(coll))return coll;else{var or__7285__auto__=cljs.core.seq(coll);if(or__7285__auto__)return or__7285__auto__;else return cljs.core.List.EMPTY}};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$2=function(xform,coll){var or__7285__auto__=cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.create(xform,coll));if(cljs.core.truth_(or__7285__auto__))return or__7285__auto__;else return cljs.core.List.EMPTY};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic=function(xform,coll,colls){var or__7285__auto__=cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.createMulti(xform,cljs.core.to_array(cljs.core.cons(coll,colls))));if(cljs.core.truth_(or__7285__auto__))return or__7285__auto__;else return cljs.core.List.EMPTY};
cljs.core.sequence.cljs$lang$applyTo=function(seq10257){var G__10258=cljs.core.first(seq10257);var seq10257__$1=cljs.core.next(seq10257);var G__10259=cljs.core.first(seq10257__$1);var seq10257__$2=cljs.core.next(seq10257__$1);return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(G__10258,G__10259,seq10257__$2)};cljs.core.sequence.cljs$lang$maxFixedArity=2;
cljs.core.every_QMARK_=function cljs$core$every_QMARK_(pred,coll){while(true){if(cljs.core.seq(coll)==null)return true;else if(cljs.core.truth_(function(){var G__10265=cljs.core.first(coll);return pred.cljs$core$IFn$_invoke$arity$1?pred.cljs$core$IFn$_invoke$arity$1(G__10265):pred.call(null,G__10265)}())){var G__10266=pred;var G__10267=cljs.core.next(coll);pred=G__10266;coll=G__10267;continue}else return false;break}};
cljs.core.not_every_QMARK_=function cljs$core$not_every_QMARK_(pred,coll){return!cljs.core.every_QMARK_(pred,coll)};
cljs.core.some=function cljs$core$some(pred,coll){while(true){if(cljs.core.seq(coll)){var or__7285__auto__=function(){var G__10269=cljs.core.first(coll);return pred.cljs$core$IFn$_invoke$arity$1?pred.cljs$core$IFn$_invoke$arity$1(G__10269):pred.call(null,G__10269)}();if(cljs.core.truth_(or__7285__auto__))return or__7285__auto__;else{var G__10270=pred;var G__10271=cljs.core.next(coll);pred=G__10270;coll=G__10271;continue}}else return null;break}};
cljs.core.not_any_QMARK_=function cljs$core$not_any_QMARK_(pred,coll){return cljs.core.not(cljs.core.some(pred,coll))};cljs.core.even_QMARK_=function cljs$core$even_QMARK_(n){if(cljs.core.integer_QMARK_(n))return(n&1)===0;else throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Argument must be an integer: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join(""));};cljs.core.odd_QMARK_=function cljs$core$odd_QMARK_(n){return!cljs.core.even_QMARK_(n)};
cljs.core.complement=function cljs$core$complement(f){return function(){var G__10272=null;var G__10272__0=function(){return cljs.core.not(f.cljs$core$IFn$_invoke$arity$0?f.cljs$core$IFn$_invoke$arity$0():f.call(null))};var G__10272__1=function(x){return cljs.core.not(f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(x):f.call(null,x))};var G__10272__2=function(x,y){return cljs.core.not(f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(x,y):f.call(null,x,y))};var G__10272__3=
function(){var G__10273__delegate=function(x,y,zs){return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs))};var G__10273=function(x,y,var_args){var zs=null;if(arguments.length>2){var G__10274__i=0,G__10274__a=new Array(arguments.length-2);while(G__10274__i<G__10274__a.length){G__10274__a[G__10274__i]=arguments[G__10274__i+2];++G__10274__i}zs=new cljs.core.IndexedSeq(G__10274__a,0,null)}return G__10273__delegate.call(this,x,y,zs)};G__10273.cljs$lang$maxFixedArity=2;G__10273.cljs$lang$applyTo=
function(arglist__10275){var x=cljs.core.first(arglist__10275);arglist__10275=cljs.core.next(arglist__10275);var y=cljs.core.first(arglist__10275);var zs=cljs.core.rest(arglist__10275);return G__10273__delegate(x,y,zs)};G__10273.cljs$core$IFn$_invoke$arity$variadic=G__10273__delegate;return G__10273}();G__10272=function(x,y,var_args){var zs=var_args;switch(arguments.length){case 0:return G__10272__0.call(this);case 1:return G__10272__1.call(this,x);case 2:return G__10272__2.call(this,x,y);default:var G__10276=
null;if(arguments.length>2){var G__10277__i=0,G__10277__a=new Array(arguments.length-2);while(G__10277__i<G__10277__a.length){G__10277__a[G__10277__i]=arguments[G__10277__i+2];++G__10277__i}G__10276=new cljs.core.IndexedSeq(G__10277__a,0,null)}return G__10272__3.cljs$core$IFn$_invoke$arity$variadic(x,y,G__10276)}throw new Error("Invalid arity: "+(arguments.length-1));};G__10272.cljs$lang$maxFixedArity=2;G__10272.cljs$lang$applyTo=G__10272__3.cljs$lang$applyTo;G__10272.cljs$core$IFn$_invoke$arity$0=
G__10272__0;G__10272.cljs$core$IFn$_invoke$arity$1=G__10272__1;G__10272.cljs$core$IFn$_invoke$arity$2=G__10272__2;G__10272.cljs$core$IFn$_invoke$arity$variadic=G__10272__3.cljs$core$IFn$_invoke$arity$variadic;return G__10272}()};
cljs.core.constantly=function cljs$core$constantly(x){return function(){var G__10278__delegate=function(args){return x};var G__10278=function(var_args){var args=null;if(arguments.length>0){var G__10279__i=0,G__10279__a=new Array(arguments.length-0);while(G__10279__i<G__10279__a.length){G__10279__a[G__10279__i]=arguments[G__10279__i+0];++G__10279__i}args=new cljs.core.IndexedSeq(G__10279__a,0,null)}return G__10278__delegate.call(this,args)};G__10278.cljs$lang$maxFixedArity=0;G__10278.cljs$lang$applyTo=
function(arglist__10280){var args=cljs.core.seq(arglist__10280);return G__10278__delegate(args)};G__10278.cljs$core$IFn$_invoke$arity$variadic=G__10278__delegate;return G__10278}()};
cljs.core.comp=function cljs$core$comp(var_args){var G__10286=arguments.length;switch(G__10286){case 0:return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();break;case 1:return cljs.core.comp.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.comp.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10304=
arguments.length;var i__8411__auto___10305=0;while(true){if(i__8411__auto___10305<len__8410__auto___10304){args_arr__8429__auto__.push(arguments[i__8411__auto___10305]);var G__10306=i__8411__auto___10305+1;i__8411__auto___10305=G__10306;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(3),0,null);return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],arguments[2],argseq__8430__auto__)}};
cljs.core.comp.cljs$core$IFn$_invoke$arity$0=function(){return cljs.core.identity};cljs.core.comp.cljs$core$IFn$_invoke$arity$1=function(f){return f};
cljs.core.comp.cljs$core$IFn$_invoke$arity$2=function(f,g){return function(){var G__10307=null;var G__10307__0=function(){var G__10287=g.cljs$core$IFn$_invoke$arity$0?g.cljs$core$IFn$_invoke$arity$0():g.call(null);return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10287):f.call(null,G__10287)};var G__10307__1=function(x){var G__10288=g.cljs$core$IFn$_invoke$arity$1?g.cljs$core$IFn$_invoke$arity$1(x):g.call(null,x);return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10288):
f.call(null,G__10288)};var G__10307__2=function(x,y){var G__10289=g.cljs$core$IFn$_invoke$arity$2?g.cljs$core$IFn$_invoke$arity$2(x,y):g.call(null,x,y);return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10289):f.call(null,G__10289)};var G__10307__3=function(x,y,z){var G__10290=g.cljs$core$IFn$_invoke$arity$3?g.cljs$core$IFn$_invoke$arity$3(x,y,z):g.call(null,x,y,z);return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10290):f.call(null,G__10290)};var G__10307__4=
function(){var G__10308__delegate=function(x,y,z,args){var G__10291=cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10291):f.call(null,G__10291)};var G__10308=function(x,y,z,var_args){var args=null;if(arguments.length>3){var G__10309__i=0,G__10309__a=new Array(arguments.length-3);while(G__10309__i<G__10309__a.length){G__10309__a[G__10309__i]=arguments[G__10309__i+3];++G__10309__i}args=new cljs.core.IndexedSeq(G__10309__a,
0,null)}return G__10308__delegate.call(this,x,y,z,args)};G__10308.cljs$lang$maxFixedArity=3;G__10308.cljs$lang$applyTo=function(arglist__10310){var x=cljs.core.first(arglist__10310);arglist__10310=cljs.core.next(arglist__10310);var y=cljs.core.first(arglist__10310);arglist__10310=cljs.core.next(arglist__10310);var z=cljs.core.first(arglist__10310);var args=cljs.core.rest(arglist__10310);return G__10308__delegate(x,y,z,args)};G__10308.cljs$core$IFn$_invoke$arity$variadic=G__10308__delegate;return G__10308}();
G__10307=function(x,y,z,var_args){var args=var_args;switch(arguments.length){case 0:return G__10307__0.call(this);case 1:return G__10307__1.call(this,x);case 2:return G__10307__2.call(this,x,y);case 3:return G__10307__3.call(this,x,y,z);default:var G__10311=null;if(arguments.length>3){var G__10312__i=0,G__10312__a=new Array(arguments.length-3);while(G__10312__i<G__10312__a.length){G__10312__a[G__10312__i]=arguments[G__10312__i+3];++G__10312__i}G__10311=new cljs.core.IndexedSeq(G__10312__a,0,null)}return G__10307__4.cljs$core$IFn$_invoke$arity$variadic(x,
y,z,G__10311)}throw new Error("Invalid arity: "+(arguments.length-1));};G__10307.cljs$lang$maxFixedArity=3;G__10307.cljs$lang$applyTo=G__10307__4.cljs$lang$applyTo;G__10307.cljs$core$IFn$_invoke$arity$0=G__10307__0;G__10307.cljs$core$IFn$_invoke$arity$1=G__10307__1;G__10307.cljs$core$IFn$_invoke$arity$2=G__10307__2;G__10307.cljs$core$IFn$_invoke$arity$3=G__10307__3;G__10307.cljs$core$IFn$_invoke$arity$variadic=G__10307__4.cljs$core$IFn$_invoke$arity$variadic;return G__10307}()};
cljs.core.comp.cljs$core$IFn$_invoke$arity$3=function(f,g,h){return function(){var G__10313=null;var G__10313__0=function(){var G__10292=function(){var G__10293=h.cljs$core$IFn$_invoke$arity$0?h.cljs$core$IFn$_invoke$arity$0():h.call(null);return g.cljs$core$IFn$_invoke$arity$1?g.cljs$core$IFn$_invoke$arity$1(G__10293):g.call(null,G__10293)}();return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10292):f.call(null,G__10292)};var G__10313__1=function(x){var G__10294=function(){var G__10295=
h.cljs$core$IFn$_invoke$arity$1?h.cljs$core$IFn$_invoke$arity$1(x):h.call(null,x);return g.cljs$core$IFn$_invoke$arity$1?g.cljs$core$IFn$_invoke$arity$1(G__10295):g.call(null,G__10295)}();return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10294):f.call(null,G__10294)};var G__10313__2=function(x,y){var G__10296=function(){var G__10297=h.cljs$core$IFn$_invoke$arity$2?h.cljs$core$IFn$_invoke$arity$2(x,y):h.call(null,x,y);return g.cljs$core$IFn$_invoke$arity$1?g.cljs$core$IFn$_invoke$arity$1(G__10297):
g.call(null,G__10297)}();return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10296):f.call(null,G__10296)};var G__10313__3=function(x,y,z){var G__10298=function(){var G__10299=h.cljs$core$IFn$_invoke$arity$3?h.cljs$core$IFn$_invoke$arity$3(x,y,z):h.call(null,x,y,z);return g.cljs$core$IFn$_invoke$arity$1?g.cljs$core$IFn$_invoke$arity$1(G__10299):g.call(null,G__10299)}();return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10298):f.call(null,G__10298)};var G__10313__4=
function(){var G__10314__delegate=function(x,y,z,args){var G__10300=function(){var G__10301=cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);return g.cljs$core$IFn$_invoke$arity$1?g.cljs$core$IFn$_invoke$arity$1(G__10301):g.call(null,G__10301)}();return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10300):f.call(null,G__10300)};var G__10314=function(x,y,z,var_args){var args=null;if(arguments.length>3){var G__10315__i=0,G__10315__a=new Array(arguments.length-3);while(G__10315__i<
G__10315__a.length){G__10315__a[G__10315__i]=arguments[G__10315__i+3];++G__10315__i}args=new cljs.core.IndexedSeq(G__10315__a,0,null)}return G__10314__delegate.call(this,x,y,z,args)};G__10314.cljs$lang$maxFixedArity=3;G__10314.cljs$lang$applyTo=function(arglist__10316){var x=cljs.core.first(arglist__10316);arglist__10316=cljs.core.next(arglist__10316);var y=cljs.core.first(arglist__10316);arglist__10316=cljs.core.next(arglist__10316);var z=cljs.core.first(arglist__10316);var args=cljs.core.rest(arglist__10316);
return G__10314__delegate(x,y,z,args)};G__10314.cljs$core$IFn$_invoke$arity$variadic=G__10314__delegate;return G__10314}();G__10313=function(x,y,z,var_args){var args=var_args;switch(arguments.length){case 0:return G__10313__0.call(this);case 1:return G__10313__1.call(this,x);case 2:return G__10313__2.call(this,x,y);case 3:return G__10313__3.call(this,x,y,z);default:var G__10317=null;if(arguments.length>3){var G__10318__i=0,G__10318__a=new Array(arguments.length-3);while(G__10318__i<G__10318__a.length){G__10318__a[G__10318__i]=
arguments[G__10318__i+3];++G__10318__i}G__10317=new cljs.core.IndexedSeq(G__10318__a,0,null)}return G__10313__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z,G__10317)}throw new Error("Invalid arity: "+(arguments.length-1));};G__10313.cljs$lang$maxFixedArity=3;G__10313.cljs$lang$applyTo=G__10313__4.cljs$lang$applyTo;G__10313.cljs$core$IFn$_invoke$arity$0=G__10313__0;G__10313.cljs$core$IFn$_invoke$arity$1=G__10313__1;G__10313.cljs$core$IFn$_invoke$arity$2=G__10313__2;G__10313.cljs$core$IFn$_invoke$arity$3=
G__10313__3;G__10313.cljs$core$IFn$_invoke$arity$variadic=G__10313__4.cljs$core$IFn$_invoke$arity$variadic;return G__10313}()};
cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic=function(f1,f2,f3,fs){var fs__$1=cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));return function(fs__$1){return function(){var G__10319__delegate=function(args){var ret=cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);var fs__$2=cljs.core.next(fs__$1);while(true){if(fs__$2){var G__10320=function(){var fexpr__10302=cljs.core.first(fs__$2);return fexpr__10302.cljs$core$IFn$_invoke$arity$1?
fexpr__10302.cljs$core$IFn$_invoke$arity$1(ret):fexpr__10302.call(null,ret)}();var G__10321=cljs.core.next(fs__$2);ret=G__10320;fs__$2=G__10321;continue}else return ret;break}};var G__10319=function(var_args){var args=null;if(arguments.length>0){var G__10322__i=0,G__10322__a=new Array(arguments.length-0);while(G__10322__i<G__10322__a.length){G__10322__a[G__10322__i]=arguments[G__10322__i+0];++G__10322__i}args=new cljs.core.IndexedSeq(G__10322__a,0,null)}return G__10319__delegate.call(this,args)};
G__10319.cljs$lang$maxFixedArity=0;G__10319.cljs$lang$applyTo=function(arglist__10323){var args=cljs.core.seq(arglist__10323);return G__10319__delegate(args)};G__10319.cljs$core$IFn$_invoke$arity$variadic=G__10319__delegate;return G__10319}()}(fs__$1)};
cljs.core.comp.cljs$lang$applyTo=function(seq10282){var G__10283=cljs.core.first(seq10282);var seq10282__$1=cljs.core.next(seq10282);var G__10284=cljs.core.first(seq10282__$1);var seq10282__$2=cljs.core.next(seq10282__$1);var G__10285=cljs.core.first(seq10282__$2);var seq10282__$3=cljs.core.next(seq10282__$2);return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(G__10283,G__10284,G__10285,seq10282__$3)};cljs.core.comp.cljs$lang$maxFixedArity=3;
cljs.core.partial=function cljs$core$partial(var_args){var G__10330=arguments.length;switch(G__10330){case 1:return cljs.core.partial.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.partial.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.partial.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core.partial.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);
break;default:var args_arr__8429__auto__=[];var len__8410__auto___10332=arguments.length;var i__8411__auto___10333=0;while(true){if(i__8411__auto___10333<len__8410__auto___10332){args_arr__8429__auto__.push(arguments[i__8411__auto___10333]);var G__10334=i__8411__auto___10333+1;i__8411__auto___10333=G__10334;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(4),0,null);return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],
arguments[2],arguments[3],argseq__8430__auto__)}};cljs.core.partial.cljs$core$IFn$_invoke$arity$1=function(f){return f};
cljs.core.partial.cljs$core$IFn$_invoke$arity$2=function(f,arg1){return function(){var G__10335=null;var G__10335__0=function(){return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(arg1):f.call(null,arg1)};var G__10335__1=function(x){return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(arg1,x):f.call(null,arg1,x)};var G__10335__2=function(x,y){return f.cljs$core$IFn$_invoke$arity$3?f.cljs$core$IFn$_invoke$arity$3(arg1,x,y):f.call(null,arg1,x,y)};var G__10335__3=
function(x,y,z){return f.cljs$core$IFn$_invoke$arity$4?f.cljs$core$IFn$_invoke$arity$4(arg1,x,y,z):f.call(null,arg1,x,y,z)};var G__10335__4=function(){var G__10336__delegate=function(x,y,z,args){return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args],0))};var G__10336=function(x,y,z,var_args){var args=null;if(arguments.length>3){var G__10337__i=0,G__10337__a=new Array(arguments.length-3);while(G__10337__i<G__10337__a.length){G__10337__a[G__10337__i]=
arguments[G__10337__i+3];++G__10337__i}args=new cljs.core.IndexedSeq(G__10337__a,0,null)}return G__10336__delegate.call(this,x,y,z,args)};G__10336.cljs$lang$maxFixedArity=3;G__10336.cljs$lang$applyTo=function(arglist__10338){var x=cljs.core.first(arglist__10338);arglist__10338=cljs.core.next(arglist__10338);var y=cljs.core.first(arglist__10338);arglist__10338=cljs.core.next(arglist__10338);var z=cljs.core.first(arglist__10338);var args=cljs.core.rest(arglist__10338);return G__10336__delegate(x,y,
z,args)};G__10336.cljs$core$IFn$_invoke$arity$variadic=G__10336__delegate;return G__10336}();G__10335=function(x,y,z,var_args){var args=var_args;switch(arguments.length){case 0:return G__10335__0.call(this);case 1:return G__10335__1.call(this,x);case 2:return G__10335__2.call(this,x,y);case 3:return G__10335__3.call(this,x,y,z);default:var G__10339=null;if(arguments.length>3){var G__10340__i=0,G__10340__a=new Array(arguments.length-3);while(G__10340__i<G__10340__a.length){G__10340__a[G__10340__i]=
arguments[G__10340__i+3];++G__10340__i}G__10339=new cljs.core.IndexedSeq(G__10340__a,0,null)}return G__10335__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z,G__10339)}throw new Error("Invalid arity: "+(arguments.length-1));};G__10335.cljs$lang$maxFixedArity=3;G__10335.cljs$lang$applyTo=G__10335__4.cljs$lang$applyTo;G__10335.cljs$core$IFn$_invoke$arity$0=G__10335__0;G__10335.cljs$core$IFn$_invoke$arity$1=G__10335__1;G__10335.cljs$core$IFn$_invoke$arity$2=G__10335__2;G__10335.cljs$core$IFn$_invoke$arity$3=
G__10335__3;G__10335.cljs$core$IFn$_invoke$arity$variadic=G__10335__4.cljs$core$IFn$_invoke$arity$variadic;return G__10335}()};
cljs.core.partial.cljs$core$IFn$_invoke$arity$3=function(f,arg1,arg2){return function(){var G__10341=null;var G__10341__0=function(){return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(arg1,arg2):f.call(null,arg1,arg2)};var G__10341__1=function(x){return f.cljs$core$IFn$_invoke$arity$3?f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,x):f.call(null,arg1,arg2,x)};var G__10341__2=function(x,y){return f.cljs$core$IFn$_invoke$arity$4?f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,x,y):f.call(null,
arg1,arg2,x,y)};var G__10341__3=function(x,y,z){return f.cljs$core$IFn$_invoke$arity$5?f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,x,y,z):f.call(null,arg1,arg2,x,y,z)};var G__10341__4=function(){var G__10342__delegate=function(x,y,z,args){return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([z,args],0))};var G__10342=function(x,y,z,var_args){var args=null;if(arguments.length>3){var G__10343__i=0,G__10343__a=new Array(arguments.length-
3);while(G__10343__i<G__10343__a.length){G__10343__a[G__10343__i]=arguments[G__10343__i+3];++G__10343__i}args=new cljs.core.IndexedSeq(G__10343__a,0,null)}return G__10342__delegate.call(this,x,y,z,args)};G__10342.cljs$lang$maxFixedArity=3;G__10342.cljs$lang$applyTo=function(arglist__10344){var x=cljs.core.first(arglist__10344);arglist__10344=cljs.core.next(arglist__10344);var y=cljs.core.first(arglist__10344);arglist__10344=cljs.core.next(arglist__10344);var z=cljs.core.first(arglist__10344);var args=
cljs.core.rest(arglist__10344);return G__10342__delegate(x,y,z,args)};G__10342.cljs$core$IFn$_invoke$arity$variadic=G__10342__delegate;return G__10342}();G__10341=function(x,y,z,var_args){var args=var_args;switch(arguments.length){case 0:return G__10341__0.call(this);case 1:return G__10341__1.call(this,x);case 2:return G__10341__2.call(this,x,y);case 3:return G__10341__3.call(this,x,y,z);default:var G__10345=null;if(arguments.length>3){var G__10346__i=0,G__10346__a=new Array(arguments.length-3);while(G__10346__i<
G__10346__a.length){G__10346__a[G__10346__i]=arguments[G__10346__i+3];++G__10346__i}G__10345=new cljs.core.IndexedSeq(G__10346__a,0,null)}return G__10341__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z,G__10345)}throw new Error("Invalid arity: "+(arguments.length-1));};G__10341.cljs$lang$maxFixedArity=3;G__10341.cljs$lang$applyTo=G__10341__4.cljs$lang$applyTo;G__10341.cljs$core$IFn$_invoke$arity$0=G__10341__0;G__10341.cljs$core$IFn$_invoke$arity$1=G__10341__1;G__10341.cljs$core$IFn$_invoke$arity$2=
G__10341__2;G__10341.cljs$core$IFn$_invoke$arity$3=G__10341__3;G__10341.cljs$core$IFn$_invoke$arity$variadic=G__10341__4.cljs$core$IFn$_invoke$arity$variadic;return G__10341}()};
cljs.core.partial.cljs$core$IFn$_invoke$arity$4=function(f,arg1,arg2,arg3){return function(){var G__10347=null;var G__10347__0=function(){return f.cljs$core$IFn$_invoke$arity$3?f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,arg3):f.call(null,arg1,arg2,arg3)};var G__10347__1=function(x){return f.cljs$core$IFn$_invoke$arity$4?f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,arg3,x):f.call(null,arg1,arg2,arg3,x)};var G__10347__2=function(x,y){return f.cljs$core$IFn$_invoke$arity$5?f.cljs$core$IFn$_invoke$arity$5(arg1,
arg2,arg3,x,y):f.call(null,arg1,arg2,arg3,x,y)};var G__10347__3=function(x,y,z){return f.cljs$core$IFn$_invoke$arity$6?f.cljs$core$IFn$_invoke$arity$6(arg1,arg2,arg3,x,y,z):f.call(null,arg1,arg2,arg3,x,y,z)};var G__10347__4=function(){var G__10348__delegate=function(x,y,z,args){return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([y,z,args],0))};var G__10348=function(x,y,z,var_args){var args=null;if(arguments.length>3){var G__10349__i=
0,G__10349__a=new Array(arguments.length-3);while(G__10349__i<G__10349__a.length){G__10349__a[G__10349__i]=arguments[G__10349__i+3];++G__10349__i}args=new cljs.core.IndexedSeq(G__10349__a,0,null)}return G__10348__delegate.call(this,x,y,z,args)};G__10348.cljs$lang$maxFixedArity=3;G__10348.cljs$lang$applyTo=function(arglist__10350){var x=cljs.core.first(arglist__10350);arglist__10350=cljs.core.next(arglist__10350);var y=cljs.core.first(arglist__10350);arglist__10350=cljs.core.next(arglist__10350);var z=
cljs.core.first(arglist__10350);var args=cljs.core.rest(arglist__10350);return G__10348__delegate(x,y,z,args)};G__10348.cljs$core$IFn$_invoke$arity$variadic=G__10348__delegate;return G__10348}();G__10347=function(x,y,z,var_args){var args=var_args;switch(arguments.length){case 0:return G__10347__0.call(this);case 1:return G__10347__1.call(this,x);case 2:return G__10347__2.call(this,x,y);case 3:return G__10347__3.call(this,x,y,z);default:var G__10351=null;if(arguments.length>3){var G__10352__i=0,G__10352__a=
new Array(arguments.length-3);while(G__10352__i<G__10352__a.length){G__10352__a[G__10352__i]=arguments[G__10352__i+3];++G__10352__i}G__10351=new cljs.core.IndexedSeq(G__10352__a,0,null)}return G__10347__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z,G__10351)}throw new Error("Invalid arity: "+(arguments.length-1));};G__10347.cljs$lang$maxFixedArity=3;G__10347.cljs$lang$applyTo=G__10347__4.cljs$lang$applyTo;G__10347.cljs$core$IFn$_invoke$arity$0=G__10347__0;G__10347.cljs$core$IFn$_invoke$arity$1=G__10347__1;
G__10347.cljs$core$IFn$_invoke$arity$2=G__10347__2;G__10347.cljs$core$IFn$_invoke$arity$3=G__10347__3;G__10347.cljs$core$IFn$_invoke$arity$variadic=G__10347__4.cljs$core$IFn$_invoke$arity$variadic;return G__10347}()};
cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic=function(f,arg1,arg2,arg3,more){return function(){var G__10353__delegate=function(args){return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args))};var G__10353=function(var_args){var args=null;if(arguments.length>0){var G__10354__i=0,G__10354__a=new Array(arguments.length-0);while(G__10354__i<G__10354__a.length){G__10354__a[G__10354__i]=arguments[G__10354__i+0];++G__10354__i}args=
new cljs.core.IndexedSeq(G__10354__a,0,null)}return G__10353__delegate.call(this,args)};G__10353.cljs$lang$maxFixedArity=0;G__10353.cljs$lang$applyTo=function(arglist__10355){var args=cljs.core.seq(arglist__10355);return G__10353__delegate(args)};G__10353.cljs$core$IFn$_invoke$arity$variadic=G__10353__delegate;return G__10353}()};
cljs.core.partial.cljs$lang$applyTo=function(seq10325){var G__10326=cljs.core.first(seq10325);var seq10325__$1=cljs.core.next(seq10325);var G__10327=cljs.core.first(seq10325__$1);var seq10325__$2=cljs.core.next(seq10325__$1);var G__10328=cljs.core.first(seq10325__$2);var seq10325__$3=cljs.core.next(seq10325__$2);var G__10329=cljs.core.first(seq10325__$3);var seq10325__$4=cljs.core.next(seq10325__$3);return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(G__10326,G__10327,G__10328,G__10329,
seq10325__$4)};cljs.core.partial.cljs$lang$maxFixedArity=4;
cljs.core.fnil=function cljs$core$fnil(var_args){var G__10357=arguments.length;switch(G__10357){case 2:return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
}};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$2=function(f,x){return function(){var G__10375=null;var G__10375__1=function(a){var G__10358=a==null?x:a;return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10358):f.call(null,G__10358)};var G__10375__2=function(a,b){var G__10359=a==null?x:a;var G__10360=b;return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__10359,G__10360):f.call(null,G__10359,G__10360)};var G__10375__3=function(a,b,c){var G__10361=a==null?x:a;
var G__10362=b;var G__10363=c;return f.cljs$core$IFn$_invoke$arity$3?f.cljs$core$IFn$_invoke$arity$3(G__10361,G__10362,G__10363):f.call(null,G__10361,G__10362,G__10363)};var G__10375__4=function(){var G__10376__delegate=function(a,b,c,ds){return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a==null?x:a,b,c,ds)};var G__10376=function(a,b,c,var_args){var ds=null;if(arguments.length>3){var G__10377__i=0,G__10377__a=new Array(arguments.length-3);while(G__10377__i<G__10377__a.length){G__10377__a[G__10377__i]=
arguments[G__10377__i+3];++G__10377__i}ds=new cljs.core.IndexedSeq(G__10377__a,0,null)}return G__10376__delegate.call(this,a,b,c,ds)};G__10376.cljs$lang$maxFixedArity=3;G__10376.cljs$lang$applyTo=function(arglist__10378){var a=cljs.core.first(arglist__10378);arglist__10378=cljs.core.next(arglist__10378);var b=cljs.core.first(arglist__10378);arglist__10378=cljs.core.next(arglist__10378);var c=cljs.core.first(arglist__10378);var ds=cljs.core.rest(arglist__10378);return G__10376__delegate(a,b,c,ds)};
G__10376.cljs$core$IFn$_invoke$arity$variadic=G__10376__delegate;return G__10376}();G__10375=function(a,b,c,var_args){var ds=var_args;switch(arguments.length){case 1:return G__10375__1.call(this,a);case 2:return G__10375__2.call(this,a,b);case 3:return G__10375__3.call(this,a,b,c);default:var G__10379=null;if(arguments.length>3){var G__10380__i=0,G__10380__a=new Array(arguments.length-3);while(G__10380__i<G__10380__a.length){G__10380__a[G__10380__i]=arguments[G__10380__i+3];++G__10380__i}G__10379=
new cljs.core.IndexedSeq(G__10380__a,0,null)}return G__10375__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c,G__10379)}throw new Error("Invalid arity: "+(arguments.length-1));};G__10375.cljs$lang$maxFixedArity=3;G__10375.cljs$lang$applyTo=G__10375__4.cljs$lang$applyTo;G__10375.cljs$core$IFn$_invoke$arity$1=G__10375__1;G__10375.cljs$core$IFn$_invoke$arity$2=G__10375__2;G__10375.cljs$core$IFn$_invoke$arity$3=G__10375__3;G__10375.cljs$core$IFn$_invoke$arity$variadic=G__10375__4.cljs$core$IFn$_invoke$arity$variadic;
return G__10375}()};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$3=function(f,x,y){return function(){var G__10381=null;var G__10381__2=function(a,b){var G__10364=a==null?x:a;var G__10365=b==null?y:b;return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__10364,G__10365):f.call(null,G__10364,G__10365)};var G__10381__3=function(a,b,c){var G__10366=a==null?x:a;var G__10367=b==null?y:b;var G__10368=c;return f.cljs$core$IFn$_invoke$arity$3?f.cljs$core$IFn$_invoke$arity$3(G__10366,G__10367,G__10368):f.call(null,
G__10366,G__10367,G__10368)};var G__10381__4=function(){var G__10382__delegate=function(a,b,c,ds){return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a==null?x:a,b==null?y:b,c,ds)};var G__10382=function(a,b,c,var_args){var ds=null;if(arguments.length>3){var G__10383__i=0,G__10383__a=new Array(arguments.length-3);while(G__10383__i<G__10383__a.length){G__10383__a[G__10383__i]=arguments[G__10383__i+3];++G__10383__i}ds=new cljs.core.IndexedSeq(G__10383__a,0,null)}return G__10382__delegate.call(this,
a,b,c,ds)};G__10382.cljs$lang$maxFixedArity=3;G__10382.cljs$lang$applyTo=function(arglist__10384){var a=cljs.core.first(arglist__10384);arglist__10384=cljs.core.next(arglist__10384);var b=cljs.core.first(arglist__10384);arglist__10384=cljs.core.next(arglist__10384);var c=cljs.core.first(arglist__10384);var ds=cljs.core.rest(arglist__10384);return G__10382__delegate(a,b,c,ds)};G__10382.cljs$core$IFn$_invoke$arity$variadic=G__10382__delegate;return G__10382}();G__10381=function(a,b,c,var_args){var ds=
var_args;switch(arguments.length){case 2:return G__10381__2.call(this,a,b);case 3:return G__10381__3.call(this,a,b,c);default:var G__10385=null;if(arguments.length>3){var G__10386__i=0,G__10386__a=new Array(arguments.length-3);while(G__10386__i<G__10386__a.length){G__10386__a[G__10386__i]=arguments[G__10386__i+3];++G__10386__i}G__10385=new cljs.core.IndexedSeq(G__10386__a,0,null)}return G__10381__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c,G__10385)}throw new Error("Invalid arity: "+(arguments.length-
1));};G__10381.cljs$lang$maxFixedArity=3;G__10381.cljs$lang$applyTo=G__10381__4.cljs$lang$applyTo;G__10381.cljs$core$IFn$_invoke$arity$2=G__10381__2;G__10381.cljs$core$IFn$_invoke$arity$3=G__10381__3;G__10381.cljs$core$IFn$_invoke$arity$variadic=G__10381__4.cljs$core$IFn$_invoke$arity$variadic;return G__10381}()};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$4=function(f,x,y,z){return function(){var G__10387=null;var G__10387__2=function(a,b){var G__10369=a==null?x:a;var G__10370=b==null?y:b;return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__10369,G__10370):f.call(null,G__10369,G__10370)};var G__10387__3=function(a,b,c){var G__10371=a==null?x:a;var G__10372=b==null?y:b;var G__10373=c==null?z:c;return f.cljs$core$IFn$_invoke$arity$3?f.cljs$core$IFn$_invoke$arity$3(G__10371,G__10372,G__10373):
f.call(null,G__10371,G__10372,G__10373)};var G__10387__4=function(){var G__10388__delegate=function(a,b,c,ds){return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a==null?x:a,b==null?y:b,c==null?z:c,ds)};var G__10388=function(a,b,c,var_args){var ds=null;if(arguments.length>3){var G__10389__i=0,G__10389__a=new Array(arguments.length-3);while(G__10389__i<G__10389__a.length){G__10389__a[G__10389__i]=arguments[G__10389__i+3];++G__10389__i}ds=new cljs.core.IndexedSeq(G__10389__a,0,null)}return G__10388__delegate.call(this,
a,b,c,ds)};G__10388.cljs$lang$maxFixedArity=3;G__10388.cljs$lang$applyTo=function(arglist__10390){var a=cljs.core.first(arglist__10390);arglist__10390=cljs.core.next(arglist__10390);var b=cljs.core.first(arglist__10390);arglist__10390=cljs.core.next(arglist__10390);var c=cljs.core.first(arglist__10390);var ds=cljs.core.rest(arglist__10390);return G__10388__delegate(a,b,c,ds)};G__10388.cljs$core$IFn$_invoke$arity$variadic=G__10388__delegate;return G__10388}();G__10387=function(a,b,c,var_args){var ds=
var_args;switch(arguments.length){case 2:return G__10387__2.call(this,a,b);case 3:return G__10387__3.call(this,a,b,c);default:var G__10391=null;if(arguments.length>3){var G__10392__i=0,G__10392__a=new Array(arguments.length-3);while(G__10392__i<G__10392__a.length){G__10392__a[G__10392__i]=arguments[G__10392__i+3];++G__10392__i}G__10391=new cljs.core.IndexedSeq(G__10392__a,0,null)}return G__10387__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c,G__10391)}throw new Error("Invalid arity: "+(arguments.length-
1));};G__10387.cljs$lang$maxFixedArity=3;G__10387.cljs$lang$applyTo=G__10387__4.cljs$lang$applyTo;G__10387.cljs$core$IFn$_invoke$arity$2=G__10387__2;G__10387.cljs$core$IFn$_invoke$arity$3=G__10387__3;G__10387.cljs$core$IFn$_invoke$arity$variadic=G__10387__4.cljs$core$IFn$_invoke$arity$variadic;return G__10387}()};cljs.core.fnil.cljs$lang$maxFixedArity=4;
cljs.core.map_indexed=function cljs$core$map_indexed(var_args){var G__10394=arguments.length;switch(G__10394){case 1:return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1=function(f){return function(rf){var i=cljs.core.volatile_BANG_(-1);return function(i){return function(){var G__10408=null;var G__10408__0=function(){return rf.cljs$core$IFn$_invoke$arity$0?rf.cljs$core$IFn$_invoke$arity$0():rf.call(null)};var G__10408__1=function(result){return rf.cljs$core$IFn$_invoke$arity$1?rf.cljs$core$IFn$_invoke$arity$1(result):rf.call(null,result)};var G__10408__2=function(result,input){var G__10395=result;var G__10396=function(){var G__10397=
cljs.core._vreset_BANG_(i,cljs.core._deref(i)+1);var G__10398=input;return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__10397,G__10398):f.call(null,G__10397,G__10398)}();return rf.cljs$core$IFn$_invoke$arity$2?rf.cljs$core$IFn$_invoke$arity$2(G__10395,G__10396):rf.call(null,G__10395,G__10396)};G__10408=function(result,input){switch(arguments.length){case 0:return G__10408__0.call(this);case 1:return G__10408__1.call(this,result);case 2:return G__10408__2.call(this,result,input)}throw new Error("Invalid arity: "+
(arguments.length-1));};G__10408.cljs$core$IFn$_invoke$arity$0=G__10408__0;G__10408.cljs$core$IFn$_invoke$arity$1=G__10408__1;G__10408.cljs$core$IFn$_invoke$arity$2=G__10408__2;return G__10408}()}(i)}};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2=function(f,coll){var mapi=function cljs$core$mapi(idx,coll__$1){return new cljs.core.LazySeq(null,function(){var temp__4657__auto__=cljs.core.seq(coll__$1);if(temp__4657__auto__){var s=temp__4657__auto__;if(cljs.core.chunked_seq_QMARK_(s)){var c=cljs.core.chunk_first(s);var size=cljs.core.count(c);var b=cljs.core.chunk_buffer(size);var n__8209__auto___10409=size;var i_10410=0;while(true){if(i_10410<n__8209__auto___10409){cljs.core.chunk_append(b,
function(){var G__10403=idx+i_10410;var G__10404=cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_10410);return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__10403,G__10404):f.call(null,G__10403,G__10404)}());var G__10411=i_10410+1;i_10410=G__10411;continue}else;break}return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$mapi(idx+size,cljs.core.chunk_rest(s)))}else return cljs.core.cons(function(){var G__10405=idx;var G__10406=cljs.core.first(s);return f.cljs$core$IFn$_invoke$arity$2?
f.cljs$core$IFn$_invoke$arity$2(G__10405,G__10406):f.call(null,G__10405,G__10406)}(),cljs$core$mapi(idx+1,cljs.core.rest(s)))}else return null},null,null)};return mapi(0,coll)};cljs.core.map_indexed.cljs$lang$maxFixedArity=2;
cljs.core.keep=function cljs$core$keep(var_args){var G__10413=arguments.length;switch(G__10413){case 1:return cljs.core.keep.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.keep.cljs$core$IFn$_invoke$arity$1=function(f){return function(rf){return function(){var G__10417=null;var G__10417__0=function(){return rf.cljs$core$IFn$_invoke$arity$0?rf.cljs$core$IFn$_invoke$arity$0():rf.call(null)};var G__10417__1=function(result){return rf.cljs$core$IFn$_invoke$arity$1?rf.cljs$core$IFn$_invoke$arity$1(result):rf.call(null,result)};var G__10417__2=function(result,input){var v=f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(input):f.call(null,input);
if(v==null)return result;else return rf.cljs$core$IFn$_invoke$arity$2?rf.cljs$core$IFn$_invoke$arity$2(result,v):rf.call(null,result,v)};G__10417=function(result,input){switch(arguments.length){case 0:return G__10417__0.call(this);case 1:return G__10417__1.call(this,result);case 2:return G__10417__2.call(this,result,input)}throw new Error("Invalid arity: "+(arguments.length-1));};G__10417.cljs$core$IFn$_invoke$arity$0=G__10417__0;G__10417.cljs$core$IFn$_invoke$arity$1=G__10417__1;G__10417.cljs$core$IFn$_invoke$arity$2=
G__10417__2;return G__10417}()}};
cljs.core.keep.cljs$core$IFn$_invoke$arity$2=function(f,coll){return new cljs.core.LazySeq(null,function(){var temp__4657__auto__=cljs.core.seq(coll);if(temp__4657__auto__){var s=temp__4657__auto__;if(cljs.core.chunked_seq_QMARK_(s)){var c=cljs.core.chunk_first(s);var size=cljs.core.count(c);var b=cljs.core.chunk_buffer(size);var n__8209__auto___10418=size;var i_10419=0;while(true){if(i_10419<n__8209__auto___10418){var x_10420=function(){var G__10414=cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_10419);
return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10414):f.call(null,G__10414)}();if(x_10420==null);else cljs.core.chunk_append(b,x_10420);var G__10421=i_10419+1;i_10419=G__10421;continue}else;break}return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)))}else{var x=function(){var G__10415=cljs.core.first(s);return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10415):f.call(null,G__10415)}();
if(x==null)return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));else return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)))}}else return null},null,null)};cljs.core.keep.cljs$lang$maxFixedArity=2;cljs.core.Atom=function(state,meta,validator,watches){this.state=state;this.meta=meta;this.validator=validator;this.watches=watches;this.cljs$lang$protocol_mask$partition1$=16386;this.cljs$lang$protocol_mask$partition0$=6455296};
cljs.core.Atom.prototype.equiv=function(other){var self__=this;var this$=this;return this$.cljs$core$IEquiv$_equiv$arity$2(null,other)};cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2=function(o,other){var self__=this;var o__$1=this;return o__$1===other};cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1=function(_){var self__=this;var ___$1=this;return self__.state};cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1=function(_){var self__=this;var ___$1=this;return self__.meta};
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3=function(this$,oldval,newval){var self__=this;var this$__$1=this;var seq__10422=cljs.core.seq(self__.watches);var chunk__10423=null;var count__10424=0;var i__10425=0;while(true){if(i__10425<count__10424){var vec__10426=chunk__10423.cljs$core$IIndexed$_nth$arity$2(null,i__10425);var key=cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10426,0,null);var f=cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10426,1,null);f.cljs$core$IFn$_invoke$arity$4?
f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval):f.call(null,key,this$__$1,oldval,newval);var G__10432=seq__10422;var G__10433=chunk__10423;var G__10434=count__10424;var G__10435=i__10425+1;seq__10422=G__10432;chunk__10423=G__10433;count__10424=G__10434;i__10425=G__10435;continue}else{var temp__4657__auto__=cljs.core.seq(seq__10422);if(temp__4657__auto__){var seq__10422__$1=temp__4657__auto__;if(cljs.core.chunked_seq_QMARK_(seq__10422__$1)){var c__8105__auto__=cljs.core.chunk_first(seq__10422__$1);
var G__10436=cljs.core.chunk_rest(seq__10422__$1);var G__10437=c__8105__auto__;var G__10438=cljs.core.count(c__8105__auto__);var G__10439=0;seq__10422=G__10436;chunk__10423=G__10437;count__10424=G__10438;i__10425=G__10439;continue}else{var vec__10429=cljs.core.first(seq__10422__$1);var key=cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10429,0,null);var f=cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10429,1,null);f.cljs$core$IFn$_invoke$arity$4?f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,
oldval,newval):f.call(null,key,this$__$1,oldval,newval);var G__10440=cljs.core.next(seq__10422__$1);var G__10441=null;var G__10442=0;var G__10443=0;seq__10422=G__10440;chunk__10423=G__10441;count__10424=G__10442;i__10425=G__10443;continue}}else return null}break}};cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3=function(this$,key,f){var self__=this;var this$__$1=this;this$__$1.watches=cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f);return this$__$1};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2=function(this$,key){var self__=this;var this$__$1=this;return this$__$1.watches=cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key)};cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1=function(this$){var self__=this;var this$__$1=this;return goog.getUid(this$__$1)};
cljs.core.Atom.getBasis=function(){return new cljs.core.PersistentVector(null,4,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null),new cljs.core.Symbol(null,"watches","watches",1367433992,null)],null)};cljs.core.Atom.cljs$lang$type=true;cljs.core.Atom.cljs$lang$ctorStr="cljs.core/Atom";
cljs.core.Atom.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/Atom")};cljs.core.__GT_Atom=function cljs$core$__GT_Atom(state,meta,validator,watches){return new cljs.core.Atom(state,meta,validator,watches)};
cljs.core.atom=function cljs$core$atom(var_args){var G__10447=arguments.length;switch(G__10447){case 1:return cljs.core.atom.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10452=arguments.length;var i__8411__auto___10453=0;while(true){if(i__8411__auto___10453<len__8410__auto___10452){args_arr__8429__auto__.push(arguments[i__8411__auto___10453]);var G__10454=i__8411__auto___10453+1;i__8411__auto___10453=G__10454;continue}else;break}var argseq__8430__auto__=
new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(1),0,null);return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(arguments[0],argseq__8430__auto__)}};cljs.core.atom.cljs$core$IFn$_invoke$arity$1=function(x){return new cljs.core.Atom(x,null,null,null)};
cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic=function(x,p__10448){var map__10449=p__10448;var map__10449__$1=(!(map__10449==null)?map__10449.cljs$lang$protocol_mask$partition0$&64||cljs.core.PROTOCOL_SENTINEL===map__10449.cljs$core$ISeq$?true:false:false)?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10449):map__10449;var meta=cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10449__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));var validator=cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10449__$1,
new cljs.core.Keyword(null,"validator","validator",-1966190681));return new cljs.core.Atom(x,meta,validator,null)};cljs.core.atom.cljs$lang$applyTo=function(seq10445){var G__10446=cljs.core.first(seq10445);var seq10445__$1=cljs.core.next(seq10445);return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(G__10446,seq10445__$1)};cljs.core.atom.cljs$lang$maxFixedArity=1;
cljs.core.reset_BANG_=function cljs$core$reset_BANG_(a,new_value){if(a instanceof cljs.core.Atom){var validate=a.validator;if(validate==null);else if(cljs.core.truth_(validate.cljs$core$IFn$_invoke$arity$1?validate.cljs$core$IFn$_invoke$arity$1(new_value):validate.call(null,new_value)));else throw new Error("Validator rejected reference state");var old_value=a.state;a.state=new_value;if(a.watches==null);else cljs.core._notify_watches(a,old_value,new_value);return new_value}else return cljs.core._reset_BANG_(a,
new_value)};
cljs.core.swap_BANG_=function cljs$core$swap_BANG_(var_args){var G__10461=arguments.length;switch(G__10461){case 2:return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10469=arguments.length;
var i__8411__auto___10470=0;while(true){if(i__8411__auto___10470<len__8410__auto___10469){args_arr__8429__auto__.push(arguments[i__8411__auto___10470]);var G__10471=i__8411__auto___10470+1;i__8411__auto___10470=G__10471;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(4),0,null);return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],arguments[2],arguments[3],argseq__8430__auto__)}};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2=function(a,f){if(a instanceof cljs.core.Atom)return cljs.core.reset_BANG_(a,function(){var G__10462=a.state;return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10462):f.call(null,G__10462)}());else return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f)};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3=function(a,f,x){if(a instanceof cljs.core.Atom)return cljs.core.reset_BANG_(a,function(){var G__10463=a.state;var G__10464=x;return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__10463,G__10464):f.call(null,G__10463,G__10464)}());else return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x)};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4=function(a,f,x,y){if(a instanceof cljs.core.Atom)return cljs.core.reset_BANG_(a,function(){var G__10465=a.state;var G__10466=x;var G__10467=y;return f.cljs$core$IFn$_invoke$arity$3?f.cljs$core$IFn$_invoke$arity$3(G__10465,G__10466,G__10467):f.call(null,G__10465,G__10466,G__10467)}());else return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y)};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic=function(a,f,x,y,more){if(a instanceof cljs.core.Atom)return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));else return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more)};
cljs.core.swap_BANG_.cljs$lang$applyTo=function(seq10456){var G__10457=cljs.core.first(seq10456);var seq10456__$1=cljs.core.next(seq10456);var G__10458=cljs.core.first(seq10456__$1);var seq10456__$2=cljs.core.next(seq10456__$1);var G__10459=cljs.core.first(seq10456__$2);var seq10456__$3=cljs.core.next(seq10456__$2);var G__10460=cljs.core.first(seq10456__$3);var seq10456__$4=cljs.core.next(seq10456__$3);return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10457,G__10458,G__10459,G__10460,
seq10456__$4)};cljs.core.swap_BANG_.cljs$lang$maxFixedArity=4;cljs.core.compare_and_set_BANG_=function cljs$core$compare_and_set_BANG_(a,oldval,newval){if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){cljs.core.reset_BANG_(a,newval);return true}else return false};
cljs.core.set_validator_BANG_=function cljs$core$set_validator_BANG_(iref,val){if(!(val==null)&&cljs.core.not(function(){var G__10473=cljs.core._deref(iref);return val.cljs$core$IFn$_invoke$arity$1?val.cljs$core$IFn$_invoke$arity$1(G__10473):val.call(null,G__10473)}()))throw new Error("Validator rejected reference state");else;return iref.validator=val};cljs.core.get_validator=function cljs$core$get_validator(iref){return iref.validator};
cljs.core.Volatile=function(state){this.state=state;this.cljs$lang$protocol_mask$partition0$=32768;this.cljs$lang$protocol_mask$partition1$=0};cljs.core.Volatile.prototype.cljs$core$IVolatile$=cljs.core.PROTOCOL_SENTINEL;cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2=function(_,new_state){var self__=this;var ___$1=this;return self__.state=new_state};cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1=function(_){var self__=this;var ___$1=this;return self__.state};
cljs.core.Volatile.getBasis=function(){return new cljs.core.PersistentVector(null,1,5,cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null))],null)};cljs.core.Volatile.cljs$lang$type=true;cljs.core.Volatile.cljs$lang$ctorStr="cljs.core/Volatile";
cljs.core.Volatile.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/Volatile")};cljs.core.__GT_Volatile=function cljs$core$__GT_Volatile(state){return new cljs.core.Volatile(state)};cljs.core.volatile_BANG_=function cljs$core$volatile_BANG_(val){return new cljs.core.Volatile(val)};cljs.core.volatile_QMARK_=function cljs$core$volatile_QMARK_(x){return x instanceof cljs.core.Volatile};
cljs.core.vreset_BANG_=function cljs$core$vreset_BANG_(vol,newval){return cljs.core._vreset_BANG_(vol,newval)};
cljs.core.keep_indexed=function cljs$core$keep_indexed(var_args){var G__10475=arguments.length;switch(G__10475){case 1:return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1=function(f){return function(rf){var ia=cljs.core.volatile_BANG_(-1);return function(ia){return function(){var G__10485=null;var G__10485__0=function(){return rf.cljs$core$IFn$_invoke$arity$0?rf.cljs$core$IFn$_invoke$arity$0():rf.call(null)};var G__10485__1=function(result){return rf.cljs$core$IFn$_invoke$arity$1?rf.cljs$core$IFn$_invoke$arity$1(result):rf.call(null,result)};var G__10485__2=function(result,input){var i=cljs.core._vreset_BANG_(ia,
cljs.core._deref(ia)+1);var v=f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(i,input):f.call(null,i,input);if(v==null)return result;else return rf.cljs$core$IFn$_invoke$arity$2?rf.cljs$core$IFn$_invoke$arity$2(result,v):rf.call(null,result,v)};G__10485=function(result,input){switch(arguments.length){case 0:return G__10485__0.call(this);case 1:return G__10485__1.call(this,result);case 2:return G__10485__2.call(this,result,input)}throw new Error("Invalid arity: "+(arguments.length-
1));};G__10485.cljs$core$IFn$_invoke$arity$0=G__10485__0;G__10485.cljs$core$IFn$_invoke$arity$1=G__10485__1;G__10485.cljs$core$IFn$_invoke$arity$2=G__10485__2;return G__10485}()}(ia)}};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2=function(f,coll){var keepi=function cljs$core$keepi(idx,coll__$1){return new cljs.core.LazySeq(null,function(){var temp__4657__auto__=cljs.core.seq(coll__$1);if(temp__4657__auto__){var s=temp__4657__auto__;if(cljs.core.chunked_seq_QMARK_(s)){var c=cljs.core.chunk_first(s);var size=cljs.core.count(c);var b=cljs.core.chunk_buffer(size);var n__8209__auto___10486=size;var i_10487=0;while(true){if(i_10487<n__8209__auto___10486){var x_10488=function(){var G__10480=
idx+i_10487;var G__10481=cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_10487);return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__10480,G__10481):f.call(null,G__10480,G__10481)}();if(x_10488==null);else cljs.core.chunk_append(b,x_10488);var G__10489=i_10487+1;i_10487=G__10489;continue}else;break}return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keepi(idx+size,cljs.core.chunk_rest(s)))}else{var x=function(){var G__10482=idx;var G__10483=cljs.core.first(s);return f.cljs$core$IFn$_invoke$arity$2?
f.cljs$core$IFn$_invoke$arity$2(G__10482,G__10483):f.call(null,G__10482,G__10483)}();if(x==null)return cljs$core$keepi(idx+1,cljs.core.rest(s));else return cljs.core.cons(x,cljs$core$keepi(idx+1,cljs.core.rest(s)))}}else return null},null,null)};return keepi(0,coll)};cljs.core.keep_indexed.cljs$lang$maxFixedArity=2;
cljs.core.every_pred=function cljs$core$every_pred(var_args){var G__10501=arguments.length;switch(G__10501){case 1:return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10503=arguments.length;var i__8411__auto___10504=
0;while(true){if(i__8411__auto___10504<len__8410__auto___10503){args_arr__8429__auto__.push(arguments[i__8411__auto___10504]);var G__10505=i__8411__auto___10504+1;i__8411__auto___10504=G__10505;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(3),0,null);return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],arguments[2],argseq__8430__auto__)}};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1=function(p){return function(){var cljs$core$ep1=null;var cljs$core$ep1__0=function(){return true};var cljs$core$ep1__1=function(x){return cljs.core.boolean$(p.cljs$core$IFn$_invoke$arity$1?p.cljs$core$IFn$_invoke$arity$1(x):p.call(null,x))};var cljs$core$ep1__2=function(x,y){return cljs.core.boolean$(function(){var and__7273__auto__=p.cljs$core$IFn$_invoke$arity$1?p.cljs$core$IFn$_invoke$arity$1(x):p.call(null,x);if(cljs.core.truth_(and__7273__auto__))return p.cljs$core$IFn$_invoke$arity$1?
p.cljs$core$IFn$_invoke$arity$1(y):p.call(null,y);else return and__7273__auto__}())};var cljs$core$ep1__3=function(x,y,z){return cljs.core.boolean$(function(){var and__7273__auto__=p.cljs$core$IFn$_invoke$arity$1?p.cljs$core$IFn$_invoke$arity$1(x):p.call(null,x);if(cljs.core.truth_(and__7273__auto__)){var and__7273__auto____$1=p.cljs$core$IFn$_invoke$arity$1?p.cljs$core$IFn$_invoke$arity$1(y):p.call(null,y);if(cljs.core.truth_(and__7273__auto____$1))return p.cljs$core$IFn$_invoke$arity$1?p.cljs$core$IFn$_invoke$arity$1(z):
p.call(null,z);else return and__7273__auto____$1}else return and__7273__auto__}())};var cljs$core$ep1__4=function(){var G__10506__delegate=function(x,y,z,args){return cljs.core.boolean$(function(){var and__7273__auto__=cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);if(cljs.core.truth_(and__7273__auto__))return cljs.core.every_QMARK_(p,args);else return and__7273__auto__}())};var G__10506=function(x,y,z,var_args){var args=null;if(arguments.length>3){var G__10507__i=0,G__10507__a=new Array(arguments.length-
3);while(G__10507__i<G__10507__a.length){G__10507__a[G__10507__i]=arguments[G__10507__i+3];++G__10507__i}args=new cljs.core.IndexedSeq(G__10507__a,0,null)}return G__10506__delegate.call(this,x,y,z,args)};G__10506.cljs$lang$maxFixedArity=3;G__10506.cljs$lang$applyTo=function(arglist__10508){var x=cljs.core.first(arglist__10508);arglist__10508=cljs.core.next(arglist__10508);var y=cljs.core.first(arglist__10508);arglist__10508=cljs.core.next(arglist__10508);var z=cljs.core.first(arglist__10508);var args=
cljs.core.rest(arglist__10508);return G__10506__delegate(x,y,z,args)};G__10506.cljs$core$IFn$_invoke$arity$variadic=G__10506__delegate;return G__10506}();cljs$core$ep1=function(x,y,z,var_args){var args=var_args;switch(arguments.length){case 0:return cljs$core$ep1__0.call(this);case 1:return cljs$core$ep1__1.call(this,x);case 2:return cljs$core$ep1__2.call(this,x,y);case 3:return cljs$core$ep1__3.call(this,x,y,z);default:var G__10509=null;if(arguments.length>3){var G__10510__i=0,G__10510__a=new Array(arguments.length-
3);while(G__10510__i<G__10510__a.length){G__10510__a[G__10510__i]=arguments[G__10510__i+3];++G__10510__i}G__10509=new cljs.core.IndexedSeq(G__10510__a,0,null)}return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z,G__10509)}throw new Error("Invalid arity: "+(arguments.length-1));};cljs$core$ep1.cljs$lang$maxFixedArity=3;cljs$core$ep1.cljs$lang$applyTo=cljs$core$ep1__4.cljs$lang$applyTo;cljs$core$ep1.cljs$core$IFn$_invoke$arity$0=cljs$core$ep1__0;cljs$core$ep1.cljs$core$IFn$_invoke$arity$1=
cljs$core$ep1__1;cljs$core$ep1.cljs$core$IFn$_invoke$arity$2=cljs$core$ep1__2;cljs$core$ep1.cljs$core$IFn$_invoke$arity$3=cljs$core$ep1__3;cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic=cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;return cljs$core$ep1}()};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2=function(p1,p2){return function(){var cljs$core$ep2=null;var cljs$core$ep2__0=function(){return true};var cljs$core$ep2__1=function(x){return cljs.core.boolean$(function(){var and__7273__auto__=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(x):p1.call(null,x);if(cljs.core.truth_(and__7273__auto__))return p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(x):p2.call(null,x);else return and__7273__auto__}())};var cljs$core$ep2__2=
function(x,y){return cljs.core.boolean$(function(){var and__7273__auto__=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(x):p1.call(null,x);if(cljs.core.truth_(and__7273__auto__)){var and__7273__auto____$1=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(y):p1.call(null,y);if(cljs.core.truth_(and__7273__auto____$1)){var and__7273__auto____$2=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(x):p2.call(null,x);if(cljs.core.truth_(and__7273__auto____$2))return p2.cljs$core$IFn$_invoke$arity$1?
p2.cljs$core$IFn$_invoke$arity$1(y):p2.call(null,y);else return and__7273__auto____$2}else return and__7273__auto____$1}else return and__7273__auto__}())};var cljs$core$ep2__3=function(x,y,z){return cljs.core.boolean$(function(){var and__7273__auto__=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(x):p1.call(null,x);if(cljs.core.truth_(and__7273__auto__)){var and__7273__auto____$1=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(y):p1.call(null,y);if(cljs.core.truth_(and__7273__auto____$1)){var and__7273__auto____$2=
p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(z):p1.call(null,z);if(cljs.core.truth_(and__7273__auto____$2)){var and__7273__auto____$3=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(x):p2.call(null,x);if(cljs.core.truth_(and__7273__auto____$3)){var and__7273__auto____$4=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(y):p2.call(null,y);if(cljs.core.truth_(and__7273__auto____$4))return p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(z):
p2.call(null,z);else return and__7273__auto____$4}else return and__7273__auto____$3}else return and__7273__auto____$2}else return and__7273__auto____$1}else return and__7273__auto__}())};var cljs$core$ep2__4=function(){var G__10511__delegate=function(x,y,z,args){return cljs.core.boolean$(function(){var and__7273__auto__=cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);if(cljs.core.truth_(and__7273__auto__))return cljs.core.every_QMARK_(function(and__7273__auto__){return function(p1__10490_SHARP_){var and__7273__auto____$1=
p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(p1__10490_SHARP_):p1.call(null,p1__10490_SHARP_);if(cljs.core.truth_(and__7273__auto____$1))return p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(p1__10490_SHARP_):p2.call(null,p1__10490_SHARP_);else return and__7273__auto____$1}}(and__7273__auto__),args);else return and__7273__auto__}())};var G__10511=function(x,y,z,var_args){var args=null;if(arguments.length>3){var G__10512__i=0,G__10512__a=new Array(arguments.length-
3);while(G__10512__i<G__10512__a.length){G__10512__a[G__10512__i]=arguments[G__10512__i+3];++G__10512__i}args=new cljs.core.IndexedSeq(G__10512__a,0,null)}return G__10511__delegate.call(this,x,y,z,args)};G__10511.cljs$lang$maxFixedArity=3;G__10511.cljs$lang$applyTo=function(arglist__10513){var x=cljs.core.first(arglist__10513);arglist__10513=cljs.core.next(arglist__10513);var y=cljs.core.first(arglist__10513);arglist__10513=cljs.core.next(arglist__10513);var z=cljs.core.first(arglist__10513);var args=
cljs.core.rest(arglist__10513);return G__10511__delegate(x,y,z,args)};G__10511.cljs$core$IFn$_invoke$arity$variadic=G__10511__delegate;return G__10511}();cljs$core$ep2=function(x,y,z,var_args){var args=var_args;switch(arguments.length){case 0:return cljs$core$ep2__0.call(this);case 1:return cljs$core$ep2__1.call(this,x);case 2:return cljs$core$ep2__2.call(this,x,y);case 3:return cljs$core$ep2__3.call(this,x,y,z);default:var G__10514=null;if(arguments.length>3){var G__10515__i=0,G__10515__a=new Array(arguments.length-
3);while(G__10515__i<G__10515__a.length){G__10515__a[G__10515__i]=arguments[G__10515__i+3];++G__10515__i}G__10514=new cljs.core.IndexedSeq(G__10515__a,0,null)}return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z,G__10514)}throw new Error("Invalid arity: "+(arguments.length-1));};cljs$core$ep2.cljs$lang$maxFixedArity=3;cljs$core$ep2.cljs$lang$applyTo=cljs$core$ep2__4.cljs$lang$applyTo;cljs$core$ep2.cljs$core$IFn$_invoke$arity$0=cljs$core$ep2__0;cljs$core$ep2.cljs$core$IFn$_invoke$arity$1=
cljs$core$ep2__1;cljs$core$ep2.cljs$core$IFn$_invoke$arity$2=cljs$core$ep2__2;cljs$core$ep2.cljs$core$IFn$_invoke$arity$3=cljs$core$ep2__3;cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic=cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;return cljs$core$ep2}()};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3=function(p1,p2,p3){return function(){var cljs$core$ep3=null;var cljs$core$ep3__0=function(){return true};var cljs$core$ep3__1=function(x){return cljs.core.boolean$(function(){var and__7273__auto__=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(x):p1.call(null,x);if(cljs.core.truth_(and__7273__auto__)){var and__7273__auto____$1=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(x):p2.call(null,x);if(cljs.core.truth_(and__7273__auto____$1))return p3.cljs$core$IFn$_invoke$arity$1?
p3.cljs$core$IFn$_invoke$arity$1(x):p3.call(null,x);else return and__7273__auto____$1}else return and__7273__auto__}())};var cljs$core$ep3__2=function(x,y){return cljs.core.boolean$(function(){var and__7273__auto__=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(x):p1.call(null,x);if(cljs.core.truth_(and__7273__auto__)){var and__7273__auto____$1=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(x):p2.call(null,x);if(cljs.core.truth_(and__7273__auto____$1)){var and__7273__auto____$2=
p3.cljs$core$IFn$_invoke$arity$1?p3.cljs$core$IFn$_invoke$arity$1(x):p3.call(null,x);if(cljs.core.truth_(and__7273__auto____$2)){var and__7273__auto____$3=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(y):p1.call(null,y);if(cljs.core.truth_(and__7273__auto____$3)){var and__7273__auto____$4=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(y):p2.call(null,y);if(cljs.core.truth_(and__7273__auto____$4))return p3.cljs$core$IFn$_invoke$arity$1?p3.cljs$core$IFn$_invoke$arity$1(y):
p3.call(null,y);else return and__7273__auto____$4}else return and__7273__auto____$3}else return and__7273__auto____$2}else return and__7273__auto____$1}else return and__7273__auto__}())};var cljs$core$ep3__3=function(x,y,z){return cljs.core.boolean$(function(){var and__7273__auto__=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(x):p1.call(null,x);if(cljs.core.truth_(and__7273__auto__)){var and__7273__auto____$1=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(x):
p2.call(null,x);if(cljs.core.truth_(and__7273__auto____$1)){var and__7273__auto____$2=p3.cljs$core$IFn$_invoke$arity$1?p3.cljs$core$IFn$_invoke$arity$1(x):p3.call(null,x);if(cljs.core.truth_(and__7273__auto____$2)){var and__7273__auto____$3=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(y):p1.call(null,y);if(cljs.core.truth_(and__7273__auto____$3)){var and__7273__auto____$4=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(y):p2.call(null,y);if(cljs.core.truth_(and__7273__auto____$4)){var and__7273__auto____$5=
p3.cljs$core$IFn$_invoke$arity$1?p3.cljs$core$IFn$_invoke$arity$1(y):p3.call(null,y);if(cljs.core.truth_(and__7273__auto____$5)){var and__7273__auto____$6=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(z):p1.call(null,z);if(cljs.core.truth_(and__7273__auto____$6)){var and__7273__auto____$7=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(z):p2.call(null,z);if(cljs.core.truth_(and__7273__auto____$7))return p3.cljs$core$IFn$_invoke$arity$1?p3.cljs$core$IFn$_invoke$arity$1(z):
p3.call(null,z);else return and__7273__auto____$7}else return and__7273__auto____$6}else return and__7273__auto____$5}else return and__7273__auto____$4}else return and__7273__auto____$3}else return and__7273__auto____$2}else return and__7273__auto____$1}else return and__7273__auto__}())};var cljs$core$ep3__4=function(){var G__10516__delegate=function(x,y,z,args){return cljs.core.boolean$(function(){var and__7273__auto__=cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);if(cljs.core.truth_(and__7273__auto__))return cljs.core.every_QMARK_(function(and__7273__auto__){return function(p1__10491_SHARP_){var and__7273__auto____$1=
p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(p1__10491_SHARP_):p1.call(null,p1__10491_SHARP_);if(cljs.core.truth_(and__7273__auto____$1)){var and__7273__auto____$2=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(p1__10491_SHARP_):p2.call(null,p1__10491_SHARP_);if(cljs.core.truth_(and__7273__auto____$2))return p3.cljs$core$IFn$_invoke$arity$1?p3.cljs$core$IFn$_invoke$arity$1(p1__10491_SHARP_):p3.call(null,p1__10491_SHARP_);else return and__7273__auto____$2}else return and__7273__auto____$1}}(and__7273__auto__),
args);else return and__7273__auto__}())};var G__10516=function(x,y,z,var_args){var args=null;if(arguments.length>3){var G__10517__i=0,G__10517__a=new Array(arguments.length-3);while(G__10517__i<G__10517__a.length){G__10517__a[G__10517__i]=arguments[G__10517__i+3];++G__10517__i}args=new cljs.core.IndexedSeq(G__10517__a,0,null)}return G__10516__delegate.call(this,x,y,z,args)};G__10516.cljs$lang$maxFixedArity=3;G__10516.cljs$lang$applyTo=function(arglist__10518){var x=cljs.core.first(arglist__10518);
arglist__10518=cljs.core.next(arglist__10518);var y=cljs.core.first(arglist__10518);arglist__10518=cljs.core.next(arglist__10518);var z=cljs.core.first(arglist__10518);var args=cljs.core.rest(arglist__10518);return G__10516__delegate(x,y,z,args)};G__10516.cljs$core$IFn$_invoke$arity$variadic=G__10516__delegate;return G__10516}();cljs$core$ep3=function(x,y,z,var_args){var args=var_args;switch(arguments.length){case 0:return cljs$core$ep3__0.call(this);case 1:return cljs$core$ep3__1.call(this,x);case 2:return cljs$core$ep3__2.call(this,
x,y);case 3:return cljs$core$ep3__3.call(this,x,y,z);default:var G__10519=null;if(arguments.length>3){var G__10520__i=0,G__10520__a=new Array(arguments.length-3);while(G__10520__i<G__10520__a.length){G__10520__a[G__10520__i]=arguments[G__10520__i+3];++G__10520__i}G__10519=new cljs.core.IndexedSeq(G__10520__a,0,null)}return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z,G__10519)}throw new Error("Invalid arity: "+(arguments.length-1));};cljs$core$ep3.cljs$lang$maxFixedArity=3;cljs$core$ep3.cljs$lang$applyTo=
cljs$core$ep3__4.cljs$lang$applyTo;cljs$core$ep3.cljs$core$IFn$_invoke$arity$0=cljs$core$ep3__0;cljs$core$ep3.cljs$core$IFn$_invoke$arity$1=cljs$core$ep3__1;cljs$core$ep3.cljs$core$IFn$_invoke$arity$2=cljs$core$ep3__2;cljs$core$ep3.cljs$core$IFn$_invoke$arity$3=cljs$core$ep3__3;cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic=cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;return cljs$core$ep3}()};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic=function(p1,p2,p3,ps){var ps__$1=cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);return function(ps__$1){return function(){var cljs$core$epn=null;var cljs$core$epn__0=function(){return true};var cljs$core$epn__1=function(x){return cljs.core.every_QMARK_(function(ps__$1){return function(p1__10492_SHARP_){return p1__10492_SHARP_.cljs$core$IFn$_invoke$arity$1?p1__10492_SHARP_.cljs$core$IFn$_invoke$arity$1(x):p1__10492_SHARP_.call(null,
x)}}(ps__$1),ps__$1)};var cljs$core$epn__2=function(x,y){return cljs.core.every_QMARK_(function(ps__$1){return function(p1__10493_SHARP_){var and__7273__auto__=p1__10493_SHARP_.cljs$core$IFn$_invoke$arity$1?p1__10493_SHARP_.cljs$core$IFn$_invoke$arity$1(x):p1__10493_SHARP_.call(null,x);if(cljs.core.truth_(and__7273__auto__))return p1__10493_SHARP_.cljs$core$IFn$_invoke$arity$1?p1__10493_SHARP_.cljs$core$IFn$_invoke$arity$1(y):p1__10493_SHARP_.call(null,y);else return and__7273__auto__}}(ps__$1),ps__$1)};
var cljs$core$epn__3=function(x,y,z){return cljs.core.every_QMARK_(function(ps__$1){return function(p1__10494_SHARP_){var and__7273__auto__=p1__10494_SHARP_.cljs$core$IFn$_invoke$arity$1?p1__10494_SHARP_.cljs$core$IFn$_invoke$arity$1(x):p1__10494_SHARP_.call(null,x);if(cljs.core.truth_(and__7273__auto__)){var and__7273__auto____$1=p1__10494_SHARP_.cljs$core$IFn$_invoke$arity$1?p1__10494_SHARP_.cljs$core$IFn$_invoke$arity$1(y):p1__10494_SHARP_.call(null,y);if(cljs.core.truth_(and__7273__auto____$1))return p1__10494_SHARP_.cljs$core$IFn$_invoke$arity$1?
p1__10494_SHARP_.cljs$core$IFn$_invoke$arity$1(z):p1__10494_SHARP_.call(null,z);else return and__7273__auto____$1}else return and__7273__auto__}}(ps__$1),ps__$1)};var cljs$core$epn__4=function(){var G__10521__delegate=function(x,y,z,args){return cljs.core.boolean$(function(){var and__7273__auto__=cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x,y,z);if(cljs.core.truth_(and__7273__auto__))return cljs.core.every_QMARK_(function(and__7273__auto__,ps__$1){return function(p1__10495_SHARP_){return cljs.core.every_QMARK_(p1__10495_SHARP_,
args)}}(and__7273__auto__,ps__$1),ps__$1);else return and__7273__auto__}())};var G__10521=function(x,y,z,var_args){var args=null;if(arguments.length>3){var G__10522__i=0,G__10522__a=new Array(arguments.length-3);while(G__10522__i<G__10522__a.length){G__10522__a[G__10522__i]=arguments[G__10522__i+3];++G__10522__i}args=new cljs.core.IndexedSeq(G__10522__a,0,null)}return G__10521__delegate.call(this,x,y,z,args)};G__10521.cljs$lang$maxFixedArity=3;G__10521.cljs$lang$applyTo=function(arglist__10523){var x=
cljs.core.first(arglist__10523);arglist__10523=cljs.core.next(arglist__10523);var y=cljs.core.first(arglist__10523);arglist__10523=cljs.core.next(arglist__10523);var z=cljs.core.first(arglist__10523);var args=cljs.core.rest(arglist__10523);return G__10521__delegate(x,y,z,args)};G__10521.cljs$core$IFn$_invoke$arity$variadic=G__10521__delegate;return G__10521}();cljs$core$epn=function(x,y,z,var_args){var args=var_args;switch(arguments.length){case 0:return cljs$core$epn__0.call(this);case 1:return cljs$core$epn__1.call(this,
x);case 2:return cljs$core$epn__2.call(this,x,y);case 3:return cljs$core$epn__3.call(this,x,y,z);default:var G__10524=null;if(arguments.length>3){var G__10525__i=0,G__10525__a=new Array(arguments.length-3);while(G__10525__i<G__10525__a.length){G__10525__a[G__10525__i]=arguments[G__10525__i+3];++G__10525__i}G__10524=new cljs.core.IndexedSeq(G__10525__a,0,null)}return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z,G__10524)}throw new Error("Invalid arity: "+(arguments.length-1));};cljs$core$epn.cljs$lang$maxFixedArity=
3;cljs$core$epn.cljs$lang$applyTo=cljs$core$epn__4.cljs$lang$applyTo;cljs$core$epn.cljs$core$IFn$_invoke$arity$0=cljs$core$epn__0;cljs$core$epn.cljs$core$IFn$_invoke$arity$1=cljs$core$epn__1;cljs$core$epn.cljs$core$IFn$_invoke$arity$2=cljs$core$epn__2;cljs$core$epn.cljs$core$IFn$_invoke$arity$3=cljs$core$epn__3;cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic=cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;return cljs$core$epn}()}(ps__$1)};
cljs.core.every_pred.cljs$lang$applyTo=function(seq10497){var G__10498=cljs.core.first(seq10497);var seq10497__$1=cljs.core.next(seq10497);var G__10499=cljs.core.first(seq10497__$1);var seq10497__$2=cljs.core.next(seq10497__$1);var G__10500=cljs.core.first(seq10497__$2);var seq10497__$3=cljs.core.next(seq10497__$2);return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(G__10498,G__10499,G__10500,seq10497__$3)};cljs.core.every_pred.cljs$lang$maxFixedArity=3;
cljs.core.some_fn=function cljs$core$some_fn(var_args){var G__10537=arguments.length;switch(G__10537){case 1:return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10539=arguments.length;var i__8411__auto___10540=0;while(true){if(i__8411__auto___10540<
len__8410__auto___10539){args_arr__8429__auto__.push(arguments[i__8411__auto___10540]);var G__10541=i__8411__auto___10540+1;i__8411__auto___10540=G__10541;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(3),0,null);return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],arguments[2],argseq__8430__auto__)}};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1=function(p){return function(){var cljs$core$sp1=null;var cljs$core$sp1__0=function(){return null};var cljs$core$sp1__1=function(x){return p.cljs$core$IFn$_invoke$arity$1?p.cljs$core$IFn$_invoke$arity$1(x):p.call(null,x)};var cljs$core$sp1__2=function(x,y){var or__7285__auto__=p.cljs$core$IFn$_invoke$arity$1?p.cljs$core$IFn$_invoke$arity$1(x):p.call(null,x);if(cljs.core.truth_(or__7285__auto__))return or__7285__auto__;else return p.cljs$core$IFn$_invoke$arity$1?
p.cljs$core$IFn$_invoke$arity$1(y):p.call(null,y)};var cljs$core$sp1__3=function(x,y,z){var or__7285__auto__=p.cljs$core$IFn$_invoke$arity$1?p.cljs$core$IFn$_invoke$arity$1(x):p.call(null,x);if(cljs.core.truth_(or__7285__auto__))return or__7285__auto__;else{var or__7285__auto____$1=p.cljs$core$IFn$_invoke$arity$1?p.cljs$core$IFn$_invoke$arity$1(y):p.call(null,y);if(cljs.core.truth_(or__7285__auto____$1))return or__7285__auto____$1;else return p.cljs$core$IFn$_invoke$arity$1?p.cljs$core$IFn$_invoke$arity$1(z):
p.call(null,z)}};var cljs$core$sp1__4=function(){var G__10542__delegate=function(x,y,z,args){var or__7285__auto__=cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);if(cljs.core.truth_(or__7285__auto__))return or__7285__auto__;else return cljs.core.some(p,args)};var G__10542=function(x,y,z,var_args){var args=null;if(arguments.length>3){var G__10543__i=0,G__10543__a=new Array(arguments.length-3);while(G__10543__i<G__10543__a.length){G__10543__a[G__10543__i]=arguments[G__10543__i+3];++G__10543__i}args=
new cljs.core.IndexedSeq(G__10543__a,0,null)}return G__10542__delegate.call(this,x,y,z,args)};G__10542.cljs$lang$maxFixedArity=3;G__10542.cljs$lang$applyTo=function(arglist__10544){var x=cljs.core.first(arglist__10544);arglist__10544=cljs.core.next(arglist__10544);var y=cljs.core.first(arglist__10544);arglist__10544=cljs.core.next(arglist__10544);var z=cljs.core.first(arglist__10544);var args=cljs.core.rest(arglist__10544);return G__10542__delegate(x,y,z,args)};G__10542.cljs$core$IFn$_invoke$arity$variadic=
G__10542__delegate;return G__10542}();cljs$core$sp1=function(x,y,z,var_args){var args=var_args;switch(arguments.length){case 0:return cljs$core$sp1__0.call(this);case 1:return cljs$core$sp1__1.call(this,x);case 2:return cljs$core$sp1__2.call(this,x,y);case 3:return cljs$core$sp1__3.call(this,x,y,z);default:var G__10545=null;if(arguments.length>3){var G__10546__i=0,G__10546__a=new Array(arguments.length-3);while(G__10546__i<G__10546__a.length){G__10546__a[G__10546__i]=arguments[G__10546__i+3];++G__10546__i}G__10545=
new cljs.core.IndexedSeq(G__10546__a,0,null)}return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z,G__10545)}throw new Error("Invalid arity: "+(arguments.length-1));};cljs$core$sp1.cljs$lang$maxFixedArity=3;cljs$core$sp1.cljs$lang$applyTo=cljs$core$sp1__4.cljs$lang$applyTo;cljs$core$sp1.cljs$core$IFn$_invoke$arity$0=cljs$core$sp1__0;cljs$core$sp1.cljs$core$IFn$_invoke$arity$1=cljs$core$sp1__1;cljs$core$sp1.cljs$core$IFn$_invoke$arity$2=cljs$core$sp1__2;cljs$core$sp1.cljs$core$IFn$_invoke$arity$3=
cljs$core$sp1__3;cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic=cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;return cljs$core$sp1}()};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2=function(p1,p2){return function(){var cljs$core$sp2=null;var cljs$core$sp2__0=function(){return null};var cljs$core$sp2__1=function(x){var or__7285__auto__=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(x):p1.call(null,x);if(cljs.core.truth_(or__7285__auto__))return or__7285__auto__;else return p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(x):p2.call(null,x)};var cljs$core$sp2__2=function(x,y){var or__7285__auto__=
p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(x):p1.call(null,x);if(cljs.core.truth_(or__7285__auto__))return or__7285__auto__;else{var or__7285__auto____$1=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(y):p1.call(null,y);if(cljs.core.truth_(or__7285__auto____$1))return or__7285__auto____$1;else{var or__7285__auto____$2=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(x):p2.call(null,x);if(cljs.core.truth_(or__7285__auto____$2))return or__7285__auto____$2;
else return p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(y):p2.call(null,y)}}};var cljs$core$sp2__3=function(x,y,z){var or__7285__auto__=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(x):p1.call(null,x);if(cljs.core.truth_(or__7285__auto__))return or__7285__auto__;else{var or__7285__auto____$1=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(y):p1.call(null,y);if(cljs.core.truth_(or__7285__auto____$1))return or__7285__auto____$1;else{var or__7285__auto____$2=
p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(z):p1.call(null,z);if(cljs.core.truth_(or__7285__auto____$2))return or__7285__auto____$2;else{var or__7285__auto____$3=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(x):p2.call(null,x);if(cljs.core.truth_(or__7285__auto____$3))return or__7285__auto____$3;else{var or__7285__auto____$4=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(y):p2.call(null,y);if(cljs.core.truth_(or__7285__auto____$4))return or__7285__auto____$4;
else return p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(z):p2.call(null,z)}}}}};var cljs$core$sp2__4=function(){var G__10547__delegate=function(x,y,z,args){var or__7285__auto__=cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);if(cljs.core.truth_(or__7285__auto__))return or__7285__auto__;else return cljs.core.some(function(or__7285__auto__){return function(p1__10526_SHARP_){var or__7285__auto____$1=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(p1__10526_SHARP_):
p1.call(null,p1__10526_SHARP_);if(cljs.core.truth_(or__7285__auto____$1))return or__7285__auto____$1;else return p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(p1__10526_SHARP_):p2.call(null,p1__10526_SHARP_)}}(or__7285__auto__),args)};var G__10547=function(x,y,z,var_args){var args=null;if(arguments.length>3){var G__10548__i=0,G__10548__a=new Array(arguments.length-3);while(G__10548__i<G__10548__a.length){G__10548__a[G__10548__i]=arguments[G__10548__i+3];++G__10548__i}args=new cljs.core.IndexedSeq(G__10548__a,
0,null)}return G__10547__delegate.call(this,x,y,z,args)};G__10547.cljs$lang$maxFixedArity=3;G__10547.cljs$lang$applyTo=function(arglist__10549){var x=cljs.core.first(arglist__10549);arglist__10549=cljs.core.next(arglist__10549);var y=cljs.core.first(arglist__10549);arglist__10549=cljs.core.next(arglist__10549);var z=cljs.core.first(arglist__10549);var args=cljs.core.rest(arglist__10549);return G__10547__delegate(x,y,z,args)};G__10547.cljs$core$IFn$_invoke$arity$variadic=G__10547__delegate;return G__10547}();
cljs$core$sp2=function(x,y,z,var_args){var args=var_args;switch(arguments.length){case 0:return cljs$core$sp2__0.call(this);case 1:return cljs$core$sp2__1.call(this,x);case 2:return cljs$core$sp2__2.call(this,x,y);case 3:return cljs$core$sp2__3.call(this,x,y,z);default:var G__10550=null;if(arguments.length>3){var G__10551__i=0,G__10551__a=new Array(arguments.length-3);while(G__10551__i<G__10551__a.length){G__10551__a[G__10551__i]=arguments[G__10551__i+3];++G__10551__i}G__10550=new cljs.core.IndexedSeq(G__10551__a,
0,null)}return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z,G__10550)}throw new Error("Invalid arity: "+(arguments.length-1));};cljs$core$sp2.cljs$lang$maxFixedArity=3;cljs$core$sp2.cljs$lang$applyTo=cljs$core$sp2__4.cljs$lang$applyTo;cljs$core$sp2.cljs$core$IFn$_invoke$arity$0=cljs$core$sp2__0;cljs$core$sp2.cljs$core$IFn$_invoke$arity$1=cljs$core$sp2__1;cljs$core$sp2.cljs$core$IFn$_invoke$arity$2=cljs$core$sp2__2;cljs$core$sp2.cljs$core$IFn$_invoke$arity$3=cljs$core$sp2__3;cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic=
cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;return cljs$core$sp2}()};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3=function(p1,p2,p3){return function(){var cljs$core$sp3=null;var cljs$core$sp3__0=function(){return null};var cljs$core$sp3__1=function(x){var or__7285__auto__=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(x):p1.call(null,x);if(cljs.core.truth_(or__7285__auto__))return or__7285__auto__;else{var or__7285__auto____$1=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(x):p2.call(null,x);if(cljs.core.truth_(or__7285__auto____$1))return or__7285__auto____$1;
else return p3.cljs$core$IFn$_invoke$arity$1?p3.cljs$core$IFn$_invoke$arity$1(x):p3.call(null,x)}};var cljs$core$sp3__2=function(x,y){var or__7285__auto__=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(x):p1.call(null,x);if(cljs.core.truth_(or__7285__auto__))return or__7285__auto__;else{var or__7285__auto____$1=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(x):p2.call(null,x);if(cljs.core.truth_(or__7285__auto____$1))return or__7285__auto____$1;else{var or__7285__auto____$2=
p3.cljs$core$IFn$_invoke$arity$1?p3.cljs$core$IFn$_invoke$arity$1(x):p3.call(null,x);if(cljs.core.truth_(or__7285__auto____$2))return or__7285__auto____$2;else{var or__7285__auto____$3=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(y):p1.call(null,y);if(cljs.core.truth_(or__7285__auto____$3))return or__7285__auto____$3;else{var or__7285__auto____$4=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(y):p2.call(null,y);if(cljs.core.truth_(or__7285__auto____$4))return or__7285__auto____$4;
else return p3.cljs$core$IFn$_invoke$arity$1?p3.cljs$core$IFn$_invoke$arity$1(y):p3.call(null,y)}}}}};var cljs$core$sp3__3=function(x,y,z){var or__7285__auto__=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(x):p1.call(null,x);if(cljs.core.truth_(or__7285__auto__))return or__7285__auto__;else{var or__7285__auto____$1=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(x):p2.call(null,x);if(cljs.core.truth_(or__7285__auto____$1))return or__7285__auto____$1;else{var or__7285__auto____$2=
p3.cljs$core$IFn$_invoke$arity$1?p3.cljs$core$IFn$_invoke$arity$1(x):p3.call(null,x);if(cljs.core.truth_(or__7285__auto____$2))return or__7285__auto____$2;else{var or__7285__auto____$3=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(y):p1.call(null,y);if(cljs.core.truth_(or__7285__auto____$3))return or__7285__auto____$3;else{var or__7285__auto____$4=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(y):p2.call(null,y);if(cljs.core.truth_(or__7285__auto____$4))return or__7285__auto____$4;
else{var or__7285__auto____$5=p3.cljs$core$IFn$_invoke$arity$1?p3.cljs$core$IFn$_invoke$arity$1(y):p3.call(null,y);if(cljs.core.truth_(or__7285__auto____$5))return or__7285__auto____$5;else{var or__7285__auto____$6=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(z):p1.call(null,z);if(cljs.core.truth_(or__7285__auto____$6))return or__7285__auto____$6;else{var or__7285__auto____$7=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(z):p2.call(null,z);if(cljs.core.truth_(or__7285__auto____$7))return or__7285__auto____$7;
else return p3.cljs$core$IFn$_invoke$arity$1?p3.cljs$core$IFn$_invoke$arity$1(z):p3.call(null,z)}}}}}}}};var cljs$core$sp3__4=function(){var G__10552__delegate=function(x,y,z,args){var or__7285__auto__=cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);if(cljs.core.truth_(or__7285__auto__))return or__7285__auto__;else return cljs.core.some(function(or__7285__auto__){return function(p1__10527_SHARP_){var or__7285__auto____$1=p1.cljs$core$IFn$_invoke$arity$1?p1.cljs$core$IFn$_invoke$arity$1(p1__10527_SHARP_):
p1.call(null,p1__10527_SHARP_);if(cljs.core.truth_(or__7285__auto____$1))return or__7285__auto____$1;else{var or__7285__auto____$2=p2.cljs$core$IFn$_invoke$arity$1?p2.cljs$core$IFn$_invoke$arity$1(p1__10527_SHARP_):p2.call(null,p1__10527_SHARP_);if(cljs.core.truth_(or__7285__auto____$2))return or__7285__auto____$2;else return p3.cljs$core$IFn$_invoke$arity$1?p3.cljs$core$IFn$_invoke$arity$1(p1__10527_SHARP_):p3.call(null,p1__10527_SHARP_)}}}(or__7285__auto__),args)};var G__10552=function(x,y,z,var_args){var args=
null;if(arguments.length>3){var G__10553__i=0,G__10553__a=new Array(arguments.length-3);while(G__10553__i<G__10553__a.length){G__10553__a[G__10553__i]=arguments[G__10553__i+3];++G__10553__i}args=new cljs.core.IndexedSeq(G__10553__a,0,null)}return G__10552__delegate.call(this,x,y,z,args)};G__10552.cljs$lang$maxFixedArity=3;G__10552.cljs$lang$applyTo=function(arglist__10554){var x=cljs.core.first(arglist__10554);arglist__10554=cljs.core.next(arglist__10554);var y=cljs.core.first(arglist__10554);arglist__10554=
cljs.core.next(arglist__10554);var z=cljs.core.first(arglist__10554);var args=cljs.core.rest(arglist__10554);return G__10552__delegate(x,y,z,args)};G__10552.cljs$core$IFn$_invoke$arity$variadic=G__10552__delegate;return G__10552}();cljs$core$sp3=function(x,y,z,var_args){var args=var_args;switch(arguments.length){case 0:return cljs$core$sp3__0.call(this);case 1:return cljs$core$sp3__1.call(this,x);case 2:return cljs$core$sp3__2.call(this,x,y);case 3:return cljs$core$sp3__3.call(this,x,y,z);default:var G__10555=
null;if(arguments.length>3){var G__10556__i=0,G__10556__a=new Array(arguments.length-3);while(G__10556__i<G__10556__a.length){G__10556__a[G__10556__i]=arguments[G__10556__i+3];++G__10556__i}G__10555=new cljs.core.IndexedSeq(G__10556__a,0,null)}return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z,G__10555)}throw new Error("Invalid arity: "+(arguments.length-1));};cljs$core$sp3.cljs$lang$maxFixedArity=3;cljs$core$sp3.cljs$lang$applyTo=cljs$core$sp3__4.cljs$lang$applyTo;cljs$core$sp3.cljs$core$IFn$_invoke$arity$0=
cljs$core$sp3__0;cljs$core$sp3.cljs$core$IFn$_invoke$arity$1=cljs$core$sp3__1;cljs$core$sp3.cljs$core$IFn$_invoke$arity$2=cljs$core$sp3__2;cljs$core$sp3.cljs$core$IFn$_invoke$arity$3=cljs$core$sp3__3;cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic=cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;return cljs$core$sp3}()};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic=function(p1,p2,p3,ps){var ps__$1=cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);return function(ps__$1){return function(){var cljs$core$spn=null;var cljs$core$spn__0=function(){return null};var cljs$core$spn__1=function(x){return cljs.core.some(function(ps__$1){return function(p1__10528_SHARP_){return p1__10528_SHARP_.cljs$core$IFn$_invoke$arity$1?p1__10528_SHARP_.cljs$core$IFn$_invoke$arity$1(x):p1__10528_SHARP_.call(null,x)}}(ps__$1),
ps__$1)};var cljs$core$spn__2=function(x,y){return cljs.core.some(function(ps__$1){return function(p1__10529_SHARP_){var or__7285__auto__=p1__10529_SHARP_.cljs$core$IFn$_invoke$arity$1?p1__10529_SHARP_.cljs$core$IFn$_invoke$arity$1(x):p1__10529_SHARP_.call(null,x);if(cljs.core.truth_(or__7285__auto__))return or__7285__auto__;else return p1__10529_SHARP_.cljs$core$IFn$_invoke$arity$1?p1__10529_SHARP_.cljs$core$IFn$_invoke$arity$1(y):p1__10529_SHARP_.call(null,y)}}(ps__$1),ps__$1)};var cljs$core$spn__3=
function(x,y,z){return cljs.core.some(function(ps__$1){return function(p1__10530_SHARP_){var or__7285__auto__=p1__10530_SHARP_.cljs$core$IFn$_invoke$arity$1?p1__10530_SHARP_.cljs$core$IFn$_invoke$arity$1(x):p1__10530_SHARP_.call(null,x);if(cljs.core.truth_(or__7285__auto__))return or__7285__auto__;else{var or__7285__auto____$1=p1__10530_SHARP_.cljs$core$IFn$_invoke$arity$1?p1__10530_SHARP_.cljs$core$IFn$_invoke$arity$1(y):p1__10530_SHARP_.call(null,y);if(cljs.core.truth_(or__7285__auto____$1))return or__7285__auto____$1;
else return p1__10530_SHARP_.cljs$core$IFn$_invoke$arity$1?p1__10530_SHARP_.cljs$core$IFn$_invoke$arity$1(z):p1__10530_SHARP_.call(null,z)}}}(ps__$1),ps__$1)};var cljs$core$spn__4=function(){var G__10557__delegate=function(x,y,z,args){var or__7285__auto__=cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x,y,z);if(cljs.core.truth_(or__7285__auto__))return or__7285__auto__;else return cljs.core.some(function(or__7285__auto__,ps__$1){return function(p1__10531_SHARP_){return cljs.core.some(p1__10531_SHARP_,
args)}}(or__7285__auto__,ps__$1),ps__$1)};var G__10557=function(x,y,z,var_args){var args=null;if(arguments.length>3){var G__10558__i=0,G__10558__a=new Array(arguments.length-3);while(G__10558__i<G__10558__a.length){G__10558__a[G__10558__i]=arguments[G__10558__i+3];++G__10558__i}args=new cljs.core.IndexedSeq(G__10558__a,0,null)}return G__10557__delegate.call(this,x,y,z,args)};G__10557.cljs$lang$maxFixedArity=3;G__10557.cljs$lang$applyTo=function(arglist__10559){var x=cljs.core.first(arglist__10559);
arglist__10559=cljs.core.next(arglist__10559);var y=cljs.core.first(arglist__10559);arglist__10559=cljs.core.next(arglist__10559);var z=cljs.core.first(arglist__10559);var args=cljs.core.rest(arglist__10559);return G__10557__delegate(x,y,z,args)};G__10557.cljs$core$IFn$_invoke$arity$variadic=G__10557__delegate;return G__10557}();cljs$core$spn=function(x,y,z,var_args){var args=var_args;switch(arguments.length){case 0:return cljs$core$spn__0.call(this);case 1:return cljs$core$spn__1.call(this,x);case 2:return cljs$core$spn__2.call(this,
x,y);case 3:return cljs$core$spn__3.call(this,x,y,z);default:var G__10560=null;if(arguments.length>3){var G__10561__i=0,G__10561__a=new Array(arguments.length-3);while(G__10561__i<G__10561__a.length){G__10561__a[G__10561__i]=arguments[G__10561__i+3];++G__10561__i}G__10560=new cljs.core.IndexedSeq(G__10561__a,0,null)}return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z,G__10560)}throw new Error("Invalid arity: "+(arguments.length-1));};cljs$core$spn.cljs$lang$maxFixedArity=3;cljs$core$spn.cljs$lang$applyTo=
cljs$core$spn__4.cljs$lang$applyTo;cljs$core$spn.cljs$core$IFn$_invoke$arity$0=cljs$core$spn__0;cljs$core$spn.cljs$core$IFn$_invoke$arity$1=cljs$core$spn__1;cljs$core$spn.cljs$core$IFn$_invoke$arity$2=cljs$core$spn__2;cljs$core$spn.cljs$core$IFn$_invoke$arity$3=cljs$core$spn__3;cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic=cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;return cljs$core$spn}()}(ps__$1)};
cljs.core.some_fn.cljs$lang$applyTo=function(seq10533){var G__10534=cljs.core.first(seq10533);var seq10533__$1=cljs.core.next(seq10533);var G__10535=cljs.core.first(seq10533__$1);var seq10533__$2=cljs.core.next(seq10533__$1);var G__10536=cljs.core.first(seq10533__$2);var seq10533__$3=cljs.core.next(seq10533__$2);return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(G__10534,G__10535,G__10536,seq10533__$3)};cljs.core.some_fn.cljs$lang$maxFixedArity=3;
cljs.core.map=function cljs$core$map(var_args){var G__10569=arguments.length;switch(G__10569){case 1:return cljs.core.map.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.map.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.map.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core.map.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;default:var args_arr__8429__auto__=
[];var len__8410__auto___10582=arguments.length;var i__8411__auto___10583=0;while(true){if(i__8411__auto___10583<len__8410__auto___10582){args_arr__8429__auto__.push(arguments[i__8411__auto___10583]);var G__10584=i__8411__auto___10583+1;i__8411__auto___10583=G__10584;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(4),0,null);return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],arguments[2],arguments[3],argseq__8430__auto__)}};
cljs.core.map.cljs$core$IFn$_invoke$arity$1=function(f){return function(rf){return function(){var G__10585=null;var G__10585__0=function(){return rf.cljs$core$IFn$_invoke$arity$0?rf.cljs$core$IFn$_invoke$arity$0():rf.call(null)};var G__10585__1=function(result){return rf.cljs$core$IFn$_invoke$arity$1?rf.cljs$core$IFn$_invoke$arity$1(result):rf.call(null,result)};var G__10585__2=function(result,input){var G__10570=result;var G__10571=f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(input):
f.call(null,input);return rf.cljs$core$IFn$_invoke$arity$2?rf.cljs$core$IFn$_invoke$arity$2(G__10570,G__10571):rf.call(null,G__10570,G__10571)};var G__10585__3=function(){var G__10586__delegate=function(result,input,inputs){var G__10572=result;var G__10573=cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);return rf.cljs$core$IFn$_invoke$arity$2?rf.cljs$core$IFn$_invoke$arity$2(G__10572,G__10573):rf.call(null,G__10572,G__10573)};var G__10586=function(result,input,var_args){var inputs=null;
if(arguments.length>2){var G__10587__i=0,G__10587__a=new Array(arguments.length-2);while(G__10587__i<G__10587__a.length){G__10587__a[G__10587__i]=arguments[G__10587__i+2];++G__10587__i}inputs=new cljs.core.IndexedSeq(G__10587__a,0,null)}return G__10586__delegate.call(this,result,input,inputs)};G__10586.cljs$lang$maxFixedArity=2;G__10586.cljs$lang$applyTo=function(arglist__10588){var result=cljs.core.first(arglist__10588);arglist__10588=cljs.core.next(arglist__10588);var input=cljs.core.first(arglist__10588);
var inputs=cljs.core.rest(arglist__10588);return G__10586__delegate(result,input,inputs)};G__10586.cljs$core$IFn$_invoke$arity$variadic=G__10586__delegate;return G__10586}();G__10585=function(result,input,var_args){var inputs=var_args;switch(arguments.length){case 0:return G__10585__0.call(this);case 1:return G__10585__1.call(this,result);case 2:return G__10585__2.call(this,result,input);default:var G__10589=null;if(arguments.length>2){var G__10590__i=0,G__10590__a=new Array(arguments.length-2);while(G__10590__i<
G__10590__a.length){G__10590__a[G__10590__i]=arguments[G__10590__i+2];++G__10590__i}G__10589=new cljs.core.IndexedSeq(G__10590__a,0,null)}return G__10585__3.cljs$core$IFn$_invoke$arity$variadic(result,input,G__10589)}throw new Error("Invalid arity: "+(arguments.length-1));};G__10585.cljs$lang$maxFixedArity=2;G__10585.cljs$lang$applyTo=G__10585__3.cljs$lang$applyTo;G__10585.cljs$core$IFn$_invoke$arity$0=G__10585__0;G__10585.cljs$core$IFn$_invoke$arity$1=G__10585__1;G__10585.cljs$core$IFn$_invoke$arity$2=
G__10585__2;G__10585.cljs$core$IFn$_invoke$arity$variadic=G__10585__3.cljs$core$IFn$_invoke$arity$variadic;return G__10585}()}};
cljs.core.map.cljs$core$IFn$_invoke$arity$2=function(f,coll){return new cljs.core.LazySeq(null,function(){var temp__4657__auto__=cljs.core.seq(coll);if(temp__4657__auto__){var s=temp__4657__auto__;if(cljs.core.chunked_seq_QMARK_(s)){var c=cljs.core.chunk_first(s);var size=cljs.core.count(c);var b=cljs.core.chunk_buffer(size);var n__8209__auto___10591=size;var i_10592=0;while(true){if(i_10592<n__8209__auto___10591){cljs.core.chunk_append(b,function(){var G__10574=cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,
i_10592);return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10574):f.call(null,G__10574)}());var G__10593=i_10592+1;i_10592=G__10593;continue}else;break}return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)))}else return cljs.core.cons(function(){var G__10575=cljs.core.first(s);return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10575):f.call(null,G__10575)}(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,
cljs.core.rest(s)))}else return null},null,null)};
cljs.core.map.cljs$core$IFn$_invoke$arity$3=function(f,c1,c2){return new cljs.core.LazySeq(null,function(){var s1=cljs.core.seq(c1);var s2=cljs.core.seq(c2);if(s1&&s2)return cljs.core.cons(function(){var G__10576=cljs.core.first(s1);var G__10577=cljs.core.first(s2);return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__10576,G__10577):f.call(null,G__10576,G__10577)}(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));else return null},null,null)};
cljs.core.map.cljs$core$IFn$_invoke$arity$4=function(f,c1,c2,c3){return new cljs.core.LazySeq(null,function(){var s1=cljs.core.seq(c1);var s2=cljs.core.seq(c2);var s3=cljs.core.seq(c3);if(s1&&s2&&s3)return cljs.core.cons(function(){var G__10578=cljs.core.first(s1);var G__10579=cljs.core.first(s2);var G__10580=cljs.core.first(s3);return f.cljs$core$IFn$_invoke$arity$3?f.cljs$core$IFn$_invoke$arity$3(G__10578,G__10579,G__10580):f.call(null,G__10578,G__10579,G__10580)}(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,
cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));else return null},null,null)};
cljs.core.map.cljs$core$IFn$_invoke$arity$variadic=function(f,c1,c2,c3,colls){var step=function cljs$core$step(cs){return new cljs.core.LazySeq(null,function(){var ss=cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);if(cljs.core.every_QMARK_(cljs.core.identity,ss))return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));else return null},null,null)};return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(step){return function(p1__10562_SHARP_){return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,
p1__10562_SHARP_)}}(step),step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c2,c1],0))))};
cljs.core.map.cljs$lang$applyTo=function(seq10564){var G__10565=cljs.core.first(seq10564);var seq10564__$1=cljs.core.next(seq10564);var G__10566=cljs.core.first(seq10564__$1);var seq10564__$2=cljs.core.next(seq10564__$1);var G__10567=cljs.core.first(seq10564__$2);var seq10564__$3=cljs.core.next(seq10564__$2);var G__10568=cljs.core.first(seq10564__$3);var seq10564__$4=cljs.core.next(seq10564__$3);return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(G__10565,G__10566,G__10567,G__10568,seq10564__$4)};
cljs.core.map.cljs$lang$maxFixedArity=4;cljs.core.take=function cljs$core$take(var_args){var G__10595=arguments.length;switch(G__10595){case 1:return cljs.core.take.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.take.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.take.cljs$core$IFn$_invoke$arity$1=function(n){if(typeof n==="number");else throw new Error("Assert failed: (number? n)");return function(rf){var na=cljs.core.volatile_BANG_(n);return function(na){return function(){var G__10597=null;var G__10597__0=function(){return rf.cljs$core$IFn$_invoke$arity$0?rf.cljs$core$IFn$_invoke$arity$0():rf.call(null)};var G__10597__1=function(result){return rf.cljs$core$IFn$_invoke$arity$1?rf.cljs$core$IFn$_invoke$arity$1(result):rf.call(null,result)};var G__10597__2=
function(result,input){var n__$1=cljs.core.deref(na);var nn=cljs.core._vreset_BANG_(na,cljs.core._deref(na)-1);var result__$1=n__$1>0?rf.cljs$core$IFn$_invoke$arity$2?rf.cljs$core$IFn$_invoke$arity$2(result,input):rf.call(null,result,input):result;if(!(nn>0))return cljs.core.ensure_reduced(result__$1);else return result__$1};G__10597=function(result,input){switch(arguments.length){case 0:return G__10597__0.call(this);case 1:return G__10597__1.call(this,result);case 2:return G__10597__2.call(this,
result,input)}throw new Error("Invalid arity: "+(arguments.length-1));};G__10597.cljs$core$IFn$_invoke$arity$0=G__10597__0;G__10597.cljs$core$IFn$_invoke$arity$1=G__10597__1;G__10597.cljs$core$IFn$_invoke$arity$2=G__10597__2;return G__10597}()}(na)}};
cljs.core.take.cljs$core$IFn$_invoke$arity$2=function(n,coll){if(typeof n==="number");else throw new Error("Assert failed: (number? n)");return new cljs.core.LazySeq(null,function(){if(n>0){var temp__4657__auto__=cljs.core.seq(coll);if(temp__4657__auto__){var s=temp__4657__auto__;return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2(n-1,cljs.core.rest(s)))}else return null}else return null},null,null)};cljs.core.take.cljs$lang$maxFixedArity=2;
cljs.core.drop=function cljs$core$drop(var_args){var G__10599=arguments.length;switch(G__10599){case 1:return cljs.core.drop.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.drop.cljs$core$IFn$_invoke$arity$1=function(n){if(typeof n==="number");else throw new Error("Assert failed: (number? n)");return function(rf){var na=cljs.core.volatile_BANG_(n);return function(na){return function(){var G__10601=null;var G__10601__0=function(){return rf.cljs$core$IFn$_invoke$arity$0?rf.cljs$core$IFn$_invoke$arity$0():rf.call(null)};var G__10601__1=function(result){return rf.cljs$core$IFn$_invoke$arity$1?rf.cljs$core$IFn$_invoke$arity$1(result):rf.call(null,result)};var G__10601__2=
function(result,input){var n__$1=cljs.core.deref(na);cljs.core._vreset_BANG_(na,cljs.core._deref(na)-1);if(n__$1>0)return result;else return rf.cljs$core$IFn$_invoke$arity$2?rf.cljs$core$IFn$_invoke$arity$2(result,input):rf.call(null,result,input)};G__10601=function(result,input){switch(arguments.length){case 0:return G__10601__0.call(this);case 1:return G__10601__1.call(this,result);case 2:return G__10601__2.call(this,result,input)}throw new Error("Invalid arity: "+(arguments.length-1));};G__10601.cljs$core$IFn$_invoke$arity$0=
G__10601__0;G__10601.cljs$core$IFn$_invoke$arity$1=G__10601__1;G__10601.cljs$core$IFn$_invoke$arity$2=G__10601__2;return G__10601}()}(na)}};
cljs.core.drop.cljs$core$IFn$_invoke$arity$2=function(n,coll){if(typeof n==="number");else throw new Error("Assert failed: (number? n)");var step=function(n__$1,coll__$1){while(true){var s=cljs.core.seq(coll__$1);if(n__$1>0&&s){var G__10602=n__$1-1;var G__10603=cljs.core.rest(s);n__$1=G__10602;coll__$1=G__10603;continue}else return s;break}};return new cljs.core.LazySeq(null,function(step){return function(){return step(n,coll)}}(step),null,null)};cljs.core.drop.cljs$lang$maxFixedArity=2;
cljs.core.drop_last=function cljs$core$drop_last(var_args){var G__10605=arguments.length;switch(G__10605){case 1:return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1=function(s){return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(1,s)};cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2=function(n,s){return cljs.core.map.cljs$core$IFn$_invoke$arity$3(function(x,_){return x},s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s))};cljs.core.drop_last.cljs$lang$maxFixedArity=2;
cljs.core.take_last=function cljs$core$take_last(n,coll){var s=cljs.core.seq(coll);var lead=cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));while(true){if(lead){var G__10607=cljs.core.next(s);var G__10608=cljs.core.next(lead);s=G__10607;lead=G__10608;continue}else return s;break}};
cljs.core.drop_while=function cljs$core$drop_while(var_args){var G__10610=arguments.length;switch(G__10610){case 1:return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1=function(pred){return function(rf){var da=cljs.core.volatile_BANG_(true);return function(da){return function(){var G__10614=null;var G__10614__0=function(){return rf.cljs$core$IFn$_invoke$arity$0?rf.cljs$core$IFn$_invoke$arity$0():rf.call(null)};var G__10614__1=function(result){return rf.cljs$core$IFn$_invoke$arity$1?rf.cljs$core$IFn$_invoke$arity$1(result):rf.call(null,result)};var G__10614__2=function(result,input){var drop_QMARK_=cljs.core.deref(da);
if(cljs.core.truth_(function(){var and__7273__auto__=drop_QMARK_;if(cljs.core.truth_(and__7273__auto__))return pred.cljs$core$IFn$_invoke$arity$1?pred.cljs$core$IFn$_invoke$arity$1(input):pred.call(null,input);else return and__7273__auto__}()))return result;else{cljs.core.vreset_BANG_(da,null);return rf.cljs$core$IFn$_invoke$arity$2?rf.cljs$core$IFn$_invoke$arity$2(result,input):rf.call(null,result,input)}};G__10614=function(result,input){switch(arguments.length){case 0:return G__10614__0.call(this);
case 1:return G__10614__1.call(this,result);case 2:return G__10614__2.call(this,result,input)}throw new Error("Invalid arity: "+(arguments.length-1));};G__10614.cljs$core$IFn$_invoke$arity$0=G__10614__0;G__10614.cljs$core$IFn$_invoke$arity$1=G__10614__1;G__10614.cljs$core$IFn$_invoke$arity$2=G__10614__2;return G__10614}()}(da)}};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2=function(pred,coll){var step=function(pred__$1,coll__$1){while(true){var s=cljs.core.seq(coll__$1);if(cljs.core.truth_(function(){var and__7273__auto__=s;if(and__7273__auto__){var G__10612=cljs.core.first(s);return pred__$1.cljs$core$IFn$_invoke$arity$1?pred__$1.cljs$core$IFn$_invoke$arity$1(G__10612):pred__$1.call(null,G__10612)}else return and__7273__auto__}())){var G__10615=pred__$1;var G__10616=cljs.core.rest(s);pred__$1=G__10615;coll__$1=G__10616;
continue}else return s;break}};return new cljs.core.LazySeq(null,function(step){return function(){return step(pred,coll)}}(step),null,null)};cljs.core.drop_while.cljs$lang$maxFixedArity=2;
cljs.core.cycle=function cljs$core$cycle(coll){return new cljs.core.LazySeq(null,function(){var temp__4657__auto__=cljs.core.seq(coll);if(temp__4657__auto__){var s=temp__4657__auto__;return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s,cljs.core.cycle.cljs$core$IFn$_invoke$arity$1?cljs.core.cycle.cljs$core$IFn$_invoke$arity$1(s):cljs.core.cycle.call(null,s))}else return null},null,null)};
cljs.core.split_at=function cljs$core$split_at(n,coll){return new cljs.core.PersistentVector(null,2,5,cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)],null)};
cljs.core.repeat=function cljs$core$repeat(var_args){var G__10618=arguments.length;switch(G__10618){case 1:return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$1=function(x){return new cljs.core.LazySeq(null,function(){return cljs.core.cons(x,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x))},null,null)};cljs.core.repeat.cljs$core$IFn$_invoke$arity$2=function(n,x){return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x))};cljs.core.repeat.cljs$lang$maxFixedArity=2;
cljs.core.replicate=function cljs$core$replicate(n,x){return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x))};
cljs.core.repeatedly=function cljs$core$repeatedly(var_args){var G__10621=arguments.length;switch(G__10621){case 1:return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1=function(f){return new cljs.core.LazySeq(null,function(){return cljs.core.cons(f.cljs$core$IFn$_invoke$arity$0?f.cljs$core$IFn$_invoke$arity$0():f.call(null),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f))},null,null)};cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2=function(n,f){return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f))};cljs.core.repeatedly.cljs$lang$maxFixedArity=2;
cljs.core.iterate=function cljs$core$iterate(f,x){return cljs.core.cons(x,new cljs.core.LazySeq(null,function(){var G__10623=f;var G__10624=f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(x):f.call(null,x);return cljs.core.iterate.cljs$core$IFn$_invoke$arity$2?cljs.core.iterate.cljs$core$IFn$_invoke$arity$2(G__10623,G__10624):cljs.core.iterate.call(null,G__10623,G__10624)},null,null))};
cljs.core.interleave=function cljs$core$interleave(var_args){var G__10629=arguments.length;switch(G__10629){case 0:return cljs.core.interleave.cljs$core$IFn$_invoke$arity$0();break;case 1:return cljs.core.interleave.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10631=arguments.length;var i__8411__auto___10632=0;while(true){if(i__8411__auto___10632<
len__8410__auto___10631){args_arr__8429__auto__.push(arguments[i__8411__auto___10632]);var G__10633=i__8411__auto___10632+1;i__8411__auto___10632=G__10633;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(2),0,null);return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],argseq__8430__auto__)}};cljs.core.interleave.cljs$core$IFn$_invoke$arity$0=function(){return cljs.core.List.EMPTY};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$1=function(c1){return new cljs.core.LazySeq(null,function(){return c1},null,null)};cljs.core.interleave.cljs$core$IFn$_invoke$arity$2=function(c1,c2){return new cljs.core.LazySeq(null,function(){var s1=cljs.core.seq(c1);var s2=cljs.core.seq(c2);if(s1&&s2)return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));else return null},null,null)};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic=function(c1,c2,colls){return new cljs.core.LazySeq(null,function(){var ss=cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c1],0)));if(cljs.core.every_QMARK_(cljs.core.identity,ss))return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,
cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));else return null},null,null)};cljs.core.interleave.cljs$lang$applyTo=function(seq10626){var G__10627=cljs.core.first(seq10626);var seq10626__$1=cljs.core.next(seq10626);var G__10628=cljs.core.first(seq10626__$1);var seq10626__$2=cljs.core.next(seq10626__$1);return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(G__10627,G__10628,seq10626__$2)};cljs.core.interleave.cljs$lang$maxFixedArity=2;
cljs.core.interpose=function cljs$core$interpose(var_args){var G__10635=arguments.length;switch(G__10635){case 1:return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$1=function(sep){return function(rf){var started=cljs.core.volatile_BANG_(false);return function(started){return function(){var G__10637=null;var G__10637__0=function(){return rf.cljs$core$IFn$_invoke$arity$0?rf.cljs$core$IFn$_invoke$arity$0():rf.call(null)};var G__10637__1=function(result){return rf.cljs$core$IFn$_invoke$arity$1?rf.cljs$core$IFn$_invoke$arity$1(result):rf.call(null,result)};var G__10637__2=function(result,input){if(cljs.core.truth_(cljs.core.deref(started))){var sepr=
rf.cljs$core$IFn$_invoke$arity$2?rf.cljs$core$IFn$_invoke$arity$2(result,sep):rf.call(null,result,sep);if(cljs.core.reduced_QMARK_(sepr))return sepr;else return rf.cljs$core$IFn$_invoke$arity$2?rf.cljs$core$IFn$_invoke$arity$2(sepr,input):rf.call(null,sepr,input)}else{cljs.core.vreset_BANG_(started,true);return rf.cljs$core$IFn$_invoke$arity$2?rf.cljs$core$IFn$_invoke$arity$2(result,input):rf.call(null,result,input)}};G__10637=function(result,input){switch(arguments.length){case 0:return G__10637__0.call(this);
case 1:return G__10637__1.call(this,result);case 2:return G__10637__2.call(this,result,input)}throw new Error("Invalid arity: "+(arguments.length-1));};G__10637.cljs$core$IFn$_invoke$arity$0=G__10637__0;G__10637.cljs$core$IFn$_invoke$arity$1=G__10637__1;G__10637.cljs$core$IFn$_invoke$arity$2=G__10637__2;return G__10637}()}(started)}};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$2=function(sep,coll){return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(1,cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll))};cljs.core.interpose.cljs$lang$maxFixedArity=2;
cljs.core.flatten1=function cljs$core$flatten1(colls){var cat=function cljs$core$flatten1_$_cat(coll,colls__$1){return new cljs.core.LazySeq(null,function(){var temp__4655__auto__=cljs.core.seq(coll);if(temp__4655__auto__){var coll__$1=temp__4655__auto__;return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1))}else if(cljs.core.seq(colls__$1))return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));else return null},
null,null)};return cat(null,colls)};
cljs.core.mapcat=function cljs$core$mapcat(var_args){var G__10641=arguments.length;switch(G__10641){case 1:return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10643=arguments.length;var i__8411__auto___10644=0;while(true){if(i__8411__auto___10644<len__8410__auto___10643){args_arr__8429__auto__.push(arguments[i__8411__auto___10644]);var G__10645=i__8411__auto___10644+1;i__8411__auto___10644=G__10645;continue}else;break}var argseq__8430__auto__=
new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(1),0,null);return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(arguments[0],argseq__8430__auto__)}};cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1=function(f){return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat)};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic=function(f,colls){return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls))};cljs.core.mapcat.cljs$lang$applyTo=function(seq10639){var G__10640=cljs.core.first(seq10639);var seq10639__$1=cljs.core.next(seq10639);return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(G__10640,seq10639__$1)};cljs.core.mapcat.cljs$lang$maxFixedArity=1;
cljs.core.filter=function cljs$core$filter(var_args){var G__10647=arguments.length;switch(G__10647){case 1:return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.filter.cljs$core$IFn$_invoke$arity$1=function(pred){return function(rf){return function(){var G__10650=null;var G__10650__0=function(){return rf.cljs$core$IFn$_invoke$arity$0?rf.cljs$core$IFn$_invoke$arity$0():rf.call(null)};var G__10650__1=function(result){return rf.cljs$core$IFn$_invoke$arity$1?rf.cljs$core$IFn$_invoke$arity$1(result):rf.call(null,result)};var G__10650__2=function(result,input){if(cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1?pred.cljs$core$IFn$_invoke$arity$1(input):
pred.call(null,input)))return rf.cljs$core$IFn$_invoke$arity$2?rf.cljs$core$IFn$_invoke$arity$2(result,input):rf.call(null,result,input);else return result};G__10650=function(result,input){switch(arguments.length){case 0:return G__10650__0.call(this);case 1:return G__10650__1.call(this,result);case 2:return G__10650__2.call(this,result,input)}throw new Error("Invalid arity: "+(arguments.length-1));};G__10650.cljs$core$IFn$_invoke$arity$0=G__10650__0;G__10650.cljs$core$IFn$_invoke$arity$1=G__10650__1;
G__10650.cljs$core$IFn$_invoke$arity$2=G__10650__2;return G__10650}()}};
cljs.core.filter.cljs$core$IFn$_invoke$arity$2=function(pred,coll){return new cljs.core.LazySeq(null,function(){var temp__4657__auto__=cljs.core.seq(coll);if(temp__4657__auto__){var s=temp__4657__auto__;if(cljs.core.chunked_seq_QMARK_(s)){var c=cljs.core.chunk_first(s);var size=cljs.core.count(c);var b=cljs.core.chunk_buffer(size);var n__8209__auto___10651=size;var i_10652=0;while(true){if(i_10652<n__8209__auto___10651){if(cljs.core.truth_(function(){var G__10648=cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,
i_10652);return pred.cljs$core$IFn$_invoke$arity$1?pred.cljs$core$IFn$_invoke$arity$1(G__10648):pred.call(null,G__10648)}()))cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_10652));else;var G__10653=i_10652+1;i_10652=G__10653;continue}else;break}return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)))}else{var f=cljs.core.first(s);var r=cljs.core.rest(s);if(cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1?
pred.cljs$core$IFn$_invoke$arity$1(f):pred.call(null,f)))return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));else return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r)}}else return null},null,null)};cljs.core.filter.cljs$lang$maxFixedArity=2;
cljs.core.remove=function cljs$core$remove(var_args){var G__10655=arguments.length;switch(G__10655){case 1:return cljs.core.remove.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};cljs.core.remove.cljs$core$IFn$_invoke$arity$1=function(pred){return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred))};
cljs.core.remove.cljs$core$IFn$_invoke$arity$2=function(pred,coll){return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll)};cljs.core.remove.cljs$lang$maxFixedArity=2;
cljs.core.tree_seq=function cljs$core$tree_seq(branch_QMARK_,children,root){var walk=function cljs$core$tree_seq_$_walk(node){return new cljs.core.LazySeq(null,function(){return cljs.core.cons(node,cljs.core.truth_(branch_QMARK_.cljs$core$IFn$_invoke$arity$1?branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node):branch_QMARK_.call(null,node))?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([children.cljs$core$IFn$_invoke$arity$1?
children.cljs$core$IFn$_invoke$arity$1(node):children.call(null,node)],0)):null)},null,null)};return walk(root)};cljs.core.flatten=function cljs$core$flatten(x){return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(function(p1__10657_SHARP_){return!cljs.core.sequential_QMARK_(p1__10657_SHARP_)},cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)))};
cljs.core.into=function cljs$core$into(var_args){var G__10659=arguments.length;switch(G__10659){case 0:return cljs.core.into.cljs$core$IFn$_invoke$arity$0();break;case 1:return cljs.core.into.cljs$core$IFn$_invoke$arity$1(arguments[0]);break;case 2:return cljs.core.into.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.into.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),
cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};cljs.core.into.cljs$core$IFn$_invoke$arity$0=function(){return cljs.core.PersistentVector.EMPTY};cljs.core.into.cljs$core$IFn$_invoke$arity$1=function(to){return to};
cljs.core.into.cljs$core$IFn$_invoke$arity$2=function(to,from){if(!(to==null))if(!(to==null)?to.cljs$lang$protocol_mask$partition1$&4||cljs.core.PROTOCOL_SENTINEL===to.cljs$core$IEditableCollection$?true:false:false)return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));else return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);else return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,
cljs.core.List.EMPTY,from)};
cljs.core.into.cljs$core$IFn$_invoke$arity$3=function(to,xform,from){if(!(to==null)?to.cljs$lang$protocol_mask$partition1$&4||cljs.core.PROTOCOL_SENTINEL===to.cljs$core$IEditableCollection$?true:false:false)return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));else return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from)};
cljs.core.into.cljs$lang$maxFixedArity=3;
cljs.core.mapv=function cljs$core$mapv(var_args){var G__10669=arguments.length;switch(G__10669){case 2:return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10671=arguments.length;var i__8411__auto___10672=
0;while(true){if(i__8411__auto___10672<len__8410__auto___10671){args_arr__8429__auto__.push(arguments[i__8411__auto___10672]);var G__10673=i__8411__auto___10672+1;i__8411__auto___10672=G__10673;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(4),0,null);return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(arguments[0],arguments[1],arguments[2],arguments[3],argseq__8430__auto__)}};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$2=function(f,coll){return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v,o){return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(o):f.call(null,o))},cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll))};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$3=function(f,c1,c2){return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2))};cljs.core.mapv.cljs$core$IFn$_invoke$arity$4=function(f,c1,c2,c3){return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3))};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic=function(f,c1,c2,c3,colls){return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([colls],0)))};
cljs.core.mapv.cljs$lang$applyTo=function(seq10664){var G__10665=cljs.core.first(seq10664);var seq10664__$1=cljs.core.next(seq10664);var G__10666=cljs.core.first(seq10664__$1);var seq10664__$2=cljs.core.next(seq10664__$1);var G__10667=cljs.core.first(seq10664__$2);var seq10664__$3=cljs.core.next(seq10664__$2);var G__10668=cljs.core.first(seq10664__$3);var seq10664__$4=cljs.core.next(seq10664__$3);return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(G__10665,G__10666,G__10667,G__10668,seq10664__$4)};
cljs.core.mapv.cljs$lang$maxFixedArity=4;cljs.core.filterv=function cljs$core$filterv(pred,coll){return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v,o){if(cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1?pred.cljs$core$IFn$_invoke$arity$1(o):pred.call(null,o)))return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);else return v},cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll))};
cljs.core.partition=function cljs$core$partition(var_args){var G__10675=arguments.length;switch(G__10675){case 2:return cljs.core.partition.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core.partition.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),
cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};cljs.core.partition.cljs$core$IFn$_invoke$arity$2=function(n,coll){return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll)};
cljs.core.partition.cljs$core$IFn$_invoke$arity$3=function(n,step,coll){return new cljs.core.LazySeq(null,function(){var temp__4657__auto__=cljs.core.seq(coll);if(temp__4657__auto__){var s=temp__4657__auto__;var p=cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);if(n===cljs.core.count(p))return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));else return null}else return null},null,null)};
cljs.core.partition.cljs$core$IFn$_invoke$arity$4=function(n,step,pad,coll){return new cljs.core.LazySeq(null,function(){var temp__4657__auto__=cljs.core.seq(coll);if(temp__4657__auto__){var s=temp__4657__auto__;var p=cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);if(n===cljs.core.count(p))return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));else{var x__8128__auto__=cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,
cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad));return cljs.core._conj(cljs.core.List.EMPTY,x__8128__auto__)}}else return null},null,null)};cljs.core.partition.cljs$lang$maxFixedArity=4;
cljs.core.get_in=function cljs$core$get_in(var_args){var G__10678=arguments.length;switch(G__10678){case 2:return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(arguments[0],arguments[1]);break;case 3:return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$2=function(m,ks){return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.get,m,ks)};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$3=function(m,ks,not_found){var sentinel=cljs.core.lookup_sentinel;var m__$1=m;var ks__$1=cljs.core.seq(ks);while(true){if(!(ks__$1==null)){var m__$2=cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);if(sentinel===m__$2)return not_found;else{var G__10680=sentinel;var G__10681=m__$2;var G__10682=cljs.core.next(ks__$1);sentinel=G__10680;m__$1=G__10681;ks__$1=G__10682;continue}}else return m__$1;break}};
cljs.core.get_in.cljs$lang$maxFixedArity=3;
cljs.core.assoc_in=function cljs$core$assoc_in(m,p__10683,v){var vec__10684=p__10683;var seq__10685=cljs.core.seq(vec__10684);var first__10686=cljs.core.first(seq__10685);var seq__10685__$1=cljs.core.next(seq__10685);var k=first__10686;var ks=seq__10685__$1;if(ks)return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,function(){var G__10687=cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);var G__10688=ks;var G__10689=v;return cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3?cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3(G__10687,
G__10688,G__10689):cljs.core.assoc_in.call(null,G__10687,G__10688,G__10689)}());else return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v)};
cljs.core.update_in=function cljs$core$update_in(var_args){var G__10698=arguments.length;switch(G__10698){case 3:return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;case 5:return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4]);break;case 6:return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(arguments[0],
arguments[1],arguments[2],arguments[3],arguments[4],arguments[5]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10730=arguments.length;var i__8411__auto___10731=0;while(true){if(i__8411__auto___10731<len__8410__auto___10730){args_arr__8429__auto__.push(arguments[i__8411__auto___10731]);var G__10732=i__8411__auto___10731+1;i__8411__auto___10731=G__10732;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(6),0,null);return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(arguments[0],
arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],argseq__8430__auto__)}};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$3=function(m,p__10699,f){var vec__10700=p__10699;var seq__10701=cljs.core.seq(vec__10700);var first__10702=cljs.core.first(seq__10701);var seq__10701__$1=cljs.core.next(seq__10701);var k=first__10702;var ks=seq__10701__$1;if(ks)return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));else return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,
function(){var G__10703=cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10703):f.call(null,G__10703)}())};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$4=function(m,p__10704,f,a){var vec__10705=p__10704;var seq__10706=cljs.core.seq(vec__10705);var first__10707=cljs.core.first(seq__10706);var seq__10706__$1=cljs.core.next(seq__10706);var k=first__10707;var ks=seq__10706__$1;if(ks)return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));else return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,
k,function(){var G__10708=cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);var G__10709=a;return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__10708,G__10709):f.call(null,G__10708,G__10709)}())};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$5=function(m,p__10710,f,a,b){var vec__10711=p__10710;var seq__10712=cljs.core.seq(vec__10711);var first__10713=cljs.core.first(seq__10712);var seq__10712__$1=cljs.core.next(seq__10712);var k=first__10713;var ks=seq__10712__$1;if(ks)return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));else return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,
k,function(){var G__10714=cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);var G__10715=a;var G__10716=b;return f.cljs$core$IFn$_invoke$arity$3?f.cljs$core$IFn$_invoke$arity$3(G__10714,G__10715,G__10716):f.call(null,G__10714,G__10715,G__10716)}())};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$6=function(m,p__10717,f,a,b,c){var vec__10718=p__10717;var seq__10719=cljs.core.seq(vec__10718);var first__10720=cljs.core.first(seq__10719);var seq__10719__$1=cljs.core.next(seq__10719);var k=first__10720;var ks=seq__10719__$1;if(ks)return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));else return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,
k,function(){var G__10721=cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);var G__10722=a;var G__10723=b;var G__10724=c;return f.cljs$core$IFn$_invoke$arity$4?f.cljs$core$IFn$_invoke$arity$4(G__10721,G__10722,G__10723,G__10724):f.call(null,G__10721,G__10722,G__10723,G__10724)}())};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic=function(m,p__10725,f,a,b,c,args){var vec__10726=p__10725;var seq__10727=cljs.core.seq(vec__10726);var first__10728=cljs.core.first(seq__10727);var seq__10727__$1=cljs.core.next(seq__10727);var k=first__10728;var ks=seq__10727__$1;if(ks)return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([b,
c,args],0)));else return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args],0)))};
cljs.core.update_in.cljs$lang$applyTo=function(seq10691){var G__10692=cljs.core.first(seq10691);var seq10691__$1=cljs.core.next(seq10691);var G__10693=cljs.core.first(seq10691__$1);var seq10691__$2=cljs.core.next(seq10691__$1);var G__10694=cljs.core.first(seq10691__$2);var seq10691__$3=cljs.core.next(seq10691__$2);var G__10695=cljs.core.first(seq10691__$3);var seq10691__$4=cljs.core.next(seq10691__$3);var G__10696=cljs.core.first(seq10691__$4);var seq10691__$5=cljs.core.next(seq10691__$4);var G__10697=
cljs.core.first(seq10691__$5);var seq10691__$6=cljs.core.next(seq10691__$5);return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(G__10692,G__10693,G__10694,G__10695,G__10696,G__10697,seq10691__$6)};cljs.core.update_in.cljs$lang$maxFixedArity=6;
cljs.core.update=function cljs$core$update(var_args){var G__10741=arguments.length;switch(G__10741){case 3:return cljs.core.update.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core.update.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;case 5:return cljs.core.update.cljs$core$IFn$_invoke$arity$5(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4]);break;case 6:return cljs.core.update.cljs$core$IFn$_invoke$arity$6(arguments[0],
arguments[1],arguments[2],arguments[3],arguments[4],arguments[5]);break;default:var args_arr__8429__auto__=[];var len__8410__auto___10753=arguments.length;var i__8411__auto___10754=0;while(true){if(i__8411__auto___10754<len__8410__auto___10753){args_arr__8429__auto__.push(arguments[i__8411__auto___10754]);var G__10755=i__8411__auto___10754+1;i__8411__auto___10754=G__10755;continue}else;break}var argseq__8430__auto__=new cljs.core.IndexedSeq(args_arr__8429__auto__.slice(6),0,null);return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(arguments[0],
arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],argseq__8430__auto__)}};cljs.core.update.cljs$core$IFn$_invoke$arity$3=function(m,k,f){return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,function(){var G__10742=cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);return f.cljs$core$IFn$_invoke$arity$1?f.cljs$core$IFn$_invoke$arity$1(G__10742):f.call(null,G__10742)}())};
cljs.core.update.cljs$core$IFn$_invoke$arity$4=function(m,k,f,x){return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,function(){var G__10743=cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);var G__10744=x;return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__10743,G__10744):f.call(null,G__10743,G__10744)}())};
cljs.core.update.cljs$core$IFn$_invoke$arity$5=function(m,k,f,x,y){return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,function(){var G__10745=cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);var G__10746=x;var G__10747=y;return f.cljs$core$IFn$_invoke$arity$3?f.cljs$core$IFn$_invoke$arity$3(G__10745,G__10746,G__10747):f.call(null,G__10745,G__10746,G__10747)}())};
cljs.core.update.cljs$core$IFn$_invoke$arity$6=function(m,k,f,x,y,z){return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,function(){var G__10748=cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);var G__10749=x;var G__10750=y;var G__10751=z;return f.cljs$core$IFn$_invoke$arity$4?f.cljs$core$IFn$_invoke$arity$4(G__10748,G__10749,G__10750,G__10751):f.call(null,G__10748,G__10749,G__10750,G__10751)}())};
cljs.core.update.cljs$core$IFn$_invoke$arity$variadic=function(m,k,f,x,y,z,more){return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([more],0)))};
cljs.core.update.cljs$lang$applyTo=function(seq10734){var G__10735=cljs.core.first(seq10734);var seq10734__$1=cljs.core.next(seq10734);var G__10736=cljs.core.first(seq10734__$1);var seq10734__$2=cljs.core.next(seq10734__$1);var G__10737=cljs.core.first(seq10734__$2);var seq10734__$3=cljs.core.next(seq10734__$2);var G__10738=cljs.core.first(seq10734__$3);var seq10734__$4=cljs.core.next(seq10734__$3);var G__10739=cljs.core.first(seq10734__$4);var seq10734__$5=cljs.core.next(seq10734__$4);var G__10740=
cljs.core.first(seq10734__$5);var seq10734__$6=cljs.core.next(seq10734__$5);return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(G__10735,G__10736,G__10737,G__10738,G__10739,G__10740,seq10734__$6)};cljs.core.update.cljs$lang$maxFixedArity=6;cljs.core.VectorNode=function(edit,arr){this.edit=edit;this.arr=arr};
cljs.core.VectorNode.getBasis=function(){return new cljs.core.PersistentVector(null,2,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null)],null)};cljs.core.VectorNode.cljs$lang$type=true;cljs.core.VectorNode.cljs$lang$ctorStr="cljs.core/VectorNode";
cljs.core.VectorNode.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/VectorNode")};cljs.core.__GT_VectorNode=function cljs$core$__GT_VectorNode(edit,arr){return new cljs.core.VectorNode(edit,arr)};
cljs.core.pv_fresh_node=function cljs$core$pv_fresh_node(edit){return new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null])};cljs.core.pv_aget=function cljs$core$pv_aget(node,idx){return node.arr[idx]};cljs.core.pv_aset=function cljs$core$pv_aset(node,idx,val){return node.arr[idx]=val};
cljs.core.pv_clone_node=function cljs$core$pv_clone_node(node){return new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr))};cljs.core.tail_off=function cljs$core$tail_off(pv){var cnt=pv.cnt;if(cnt<32)return 0;else return cnt-1>>>5<<5};
cljs.core.new_path=function cljs$core$new_path(edit,level,node){var ll=level;var ret=node;while(true){if(ll===0)return ret;else{var embed=ret;var r=cljs.core.pv_fresh_node(edit);var _=cljs.core.pv_aset(r,0,embed);var G__10756=ll-5;var G__10757=r;ll=G__10756;ret=G__10757;continue}break}};
cljs.core.push_tail=function cljs$core$push_tail(pv,level,parent,tailnode){var ret=cljs.core.pv_clone_node(parent);var subidx=pv.cnt-1>>>level&31;if(5===level){cljs.core.pv_aset(ret,subidx,tailnode);return ret}else{var child=cljs.core.pv_aget(parent,subidx);if(!(child==null)){var node_to_insert=function(){var G__10758=pv;var G__10759=level-5;var G__10760=child;var G__10761=tailnode;return cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4?cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4(G__10758,
G__10759,G__10760,G__10761):cljs.core.push_tail.call(null,G__10758,G__10759,G__10760,G__10761)}();cljs.core.pv_aset(ret,subidx,node_to_insert);return ret}else{var node_to_insert=cljs.core.new_path(null,level-5,tailnode);cljs.core.pv_aset(ret,subidx,node_to_insert);return ret}}};
cljs.core.vector_index_out_of_bounds=function cljs$core$vector_index_out_of_bounds(i,cnt){throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No item "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(i),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" in vector of length "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join(""));};
cljs.core.first_array_for_longvec=function cljs$core$first_array_for_longvec(pv){var node=pv.root;var level=pv.shift;while(true){if(level>0){var G__10762=cljs.core.pv_aget(node,0);var G__10763=level-5;node=G__10762;level=G__10763;continue}else return node.arr;break}};
cljs.core.unchecked_array_for=function cljs$core$unchecked_array_for(pv,i){if(i>=cljs.core.tail_off(pv))return pv.tail;else{var node=pv.root;var level=pv.shift;while(true){if(level>0){var G__10764=cljs.core.pv_aget(node,i>>>level&31);var G__10765=level-5;node=G__10764;level=G__10765;continue}else return node.arr;break}}};cljs.core.array_for=function cljs$core$array_for(pv,i){if(0<=i&&i<pv.cnt)return cljs.core.unchecked_array_for(pv,i);else return cljs.core.vector_index_out_of_bounds(i,pv.cnt)};
cljs.core.do_assoc=function cljs$core$do_assoc(pv,level,node,i,val){var ret=cljs.core.pv_clone_node(node);if(level===0){cljs.core.pv_aset(ret,i&31,val);return ret}else{var subidx=i>>>level&31;cljs.core.pv_aset(ret,subidx,function(){var G__10766=pv;var G__10767=level-5;var G__10768=cljs.core.pv_aget(node,subidx);var G__10769=i;var G__10770=val;return cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5?cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5(G__10766,G__10767,G__10768,G__10769,G__10770):cljs.core.do_assoc.call(null,
G__10766,G__10767,G__10768,G__10769,G__10770)}());return ret}};
cljs.core.pop_tail=function cljs$core$pop_tail(pv,level,node){var subidx=pv.cnt-2>>>level&31;if(level>5){var new_child=function(){var G__10771=pv;var G__10772=level-5;var G__10773=cljs.core.pv_aget(node,subidx);return cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3?cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3(G__10771,G__10772,G__10773):cljs.core.pop_tail.call(null,G__10771,G__10772,G__10773)}();if(new_child==null&&subidx===0)return null;else{var ret=cljs.core.pv_clone_node(node);cljs.core.pv_aset(ret,
subidx,new_child);return ret}}else if(subidx===0)return null;else{var ret=cljs.core.pv_clone_node(node);cljs.core.pv_aset(ret,subidx,null);return ret}};cljs.core.RangedIterator=function(i,base,arr,v,start,end){this.i=i;this.base=base;this.arr=arr;this.v=v;this.start=start;this.end=end};cljs.core.RangedIterator.prototype.hasNext=function(){var self__=this;var this$=this;return self__.i<self__.end};
cljs.core.RangedIterator.prototype.next=function(){var self__=this;var this$=this;if(self__.i-self__.base===32){self__.arr=cljs.core.unchecked_array_for(self__.v,self__.i);self__.base=self__.base+32}else;var ret=self__.arr[self__.i&31];self__.i=self__.i+1;return ret};
cljs.core.RangedIterator.getBasis=function(){return new cljs.core.PersistentVector(null,6,5,cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null)),cljs.core.with_meta(new cljs.core.Symbol(null,"base","base",1825810849,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null)),
cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null)),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)],null)};cljs.core.RangedIterator.cljs$lang$type=true;cljs.core.RangedIterator.cljs$lang$ctorStr="cljs.core/RangedIterator";
cljs.core.RangedIterator.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/RangedIterator")};cljs.core.__GT_RangedIterator=function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){return new cljs.core.RangedIterator(i,base,arr,v,start,end)};
cljs.core.ranged_iterator=function cljs$core$ranged_iterator(v,start,end){var i=start;return new cljs.core.RangedIterator(i,i-i%32,start<cljs.core.count(v)?cljs.core.unchecked_array_for(v,i):null,v,start,end)};
cljs.core.pv_reduce=function cljs$core$pv_reduce(var_args){var G__10775=arguments.length;switch(G__10775){case 4:return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;case 5:return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
}};cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4=function(pv,f,start,end){if(start<end)return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(pv,f,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pv,start),start+1,end);else return f.cljs$core$IFn$_invoke$arity$0?f.cljs$core$IFn$_invoke$arity$0():f.call(null)};
cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5=function(pv,f,init,start,end){var acc=init;var i=start;var arr=cljs.core.unchecked_array_for(pv,start);while(true){if(i<end){var j=i&31;var arr__$1=j===0?cljs.core.unchecked_array_for(pv,i):arr;var nacc=function(){var G__10776=acc;var G__10777=arr__$1[j];return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__10776,G__10777):f.call(null,G__10776,G__10777)}();if(cljs.core.reduced_QMARK_(nacc))return cljs.core.deref(nacc);else{var G__10779=
nacc;var G__10780=i+1;var G__10781=arr__$1;acc=G__10779;i=G__10780;arr=G__10781;continue}}else return acc;break}};cljs.core.pv_reduce.cljs$lang$maxFixedArity=5;cljs.core.APersistentVector=function(){};cljs.core.PersistentVector=function(meta,cnt,shift,root,tail,__hash){this.meta=meta;this.cnt=cnt;this.shift=shift;this.root=root;this.tail=tail;this.__hash=__hash;this.cljs$lang$protocol_mask$partition0$=167668511;this.cljs$lang$protocol_mask$partition1$=139268};
cljs.core.PersistentVector.prototype.cljs$core$IFind$=cljs.core.PROTOCOL_SENTINEL;cljs.core.PersistentVector.prototype.cljs$core$IFind$_find$arity$2=function(coll,n){var self__=this;var coll__$1=this;if(0<=n&&n<self__.cnt)return new cljs.core.PersistentVector(null,2,5,cljs.core.PersistentVector.EMPTY_NODE,[n,cljs.core.unchecked_array_for(coll__$1,n)[n&31]],null);else return null};cljs.core.PersistentVector.prototype.toString=function(){var self__=this;var coll=this;return cljs.core.pr_str_STAR_(coll)};
cljs.core.PersistentVector.prototype.equiv=function(other){var self__=this;var this$=this;return this$.cljs$core$IEquiv$_equiv$arity$2(null,other)};
cljs.core.PersistentVector.prototype.indexOf=function(){var G__10788=null;var G__10788__1=function(x){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,0)};var G__10788__2=function(x,start){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__10788=function(x,start){switch(arguments.length){case 1:return G__10788__1.call(this,x);case 2:return G__10788__2.call(this,x,start)}throw new Error("Invalid arity: "+
(arguments.length-1));};G__10788.cljs$core$IFn$_invoke$arity$1=G__10788__1;G__10788.cljs$core$IFn$_invoke$arity$2=G__10788__2;return G__10788}();
cljs.core.PersistentVector.prototype.lastIndexOf=function(){var G__10789=null;var G__10789__1=function(x){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll))};var G__10789__2=function(x,start){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__10789=function(x,start){switch(arguments.length){case 1:return G__10789__1.call(this,x);case 2:return G__10789__2.call(this,x,start)}throw new Error("Invalid arity: "+
(arguments.length-1));};G__10789.cljs$core$IFn$_invoke$arity$1=G__10789__1;G__10789.cljs$core$IFn$_invoke$arity$2=G__10789__2;return G__10789}();cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2=function(coll,k){var self__=this;var coll__$1=this;return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null)};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3=function(coll,k,not_found){var self__=this;var coll__$1=this;if(typeof k==="number")return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);else return not_found};
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3=function(v,f,init){var self__=this;var v__$1=this;var i=0;var init__$1=init;while(true){if(i<self__.cnt){var arr=cljs.core.unchecked_array_for(v__$1,i);var len=arr.length;var init__$2=function(){var j=0;var init__$2=init__$1;while(true){if(j<len){var init__$3=function(){var G__10783=init__$2;var G__10784=j+i;var G__10785=arr[j];return f.cljs$core$IFn$_invoke$arity$3?f.cljs$core$IFn$_invoke$arity$3(G__10783,G__10784,G__10785):
f.call(null,G__10783,G__10784,G__10785)}();if(cljs.core.reduced_QMARK_(init__$3))return init__$3;else{var G__10790=j+1;var G__10791=init__$3;j=G__10790;init__$2=G__10791;continue}}else return init__$2;break}}();if(cljs.core.reduced_QMARK_(init__$2))return cljs.core.deref(init__$2);else{var G__10792=i+len;var G__10793=init__$2;i=G__10792;init__$1=G__10793;continue}}else return init__$1;break}};cljs.core.PersistentVector.prototype.cljs$core$APersistentVector$=cljs.core.PROTOCOL_SENTINEL;
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2=function(coll,n){var self__=this;var coll__$1=this;return cljs.core.array_for(coll__$1,n)[n&31]};cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3=function(coll,n,not_found){var self__=this;var coll__$1=this;if(0<=n&&n<self__.cnt)return cljs.core.unchecked_array_for(coll__$1,n)[n&31];else return not_found};
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3=function(coll,n,val){var self__=this;var coll__$1=this;if(0<=n&&n<self__.cnt)if(cljs.core.tail_off(coll__$1)<=n){var new_tail=cljs.core.aclone(self__.tail);new_tail[n&31]=val;return new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null)}else return new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null);
else if(n===self__.cnt)return coll__$1.cljs$core$ICollection$_conj$arity$2(null,val);else throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Index "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(n),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" out of bounds  [0,"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt),cljs.core.str.cljs$core$IFn$_invoke$arity$1("]")].join(""));};
cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1=function(this$){var self__=this;var this$__$1=this;return cljs.core.ranged_iterator(this$__$1,0,self__.cnt)};cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.meta};
cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1=function(_){var self__=this;var ___$1=this;return new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash)};cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.cnt};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1=function(coll){var self__=this;var coll__$1=this;return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,0)};cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1=function(coll){var self__=this;var coll__$1=this;return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,1)};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1=function(coll){var self__=this;var coll__$1=this;if(self__.cnt>0)return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,self__.cnt-1);else return null};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1=function(coll){var self__=this;var coll__$1=this;if(self__.cnt===0)throw new Error("Can't pop empty vector");else if(1===self__.cnt)return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);else if(1<self__.cnt-cljs.core.tail_off(coll__$1))return new cljs.core.PersistentVector(self__.meta,self__.cnt-1,self__.shift,self__.root,self__.tail.slice(0,-1),null);else{var new_tail=cljs.core.unchecked_array_for(coll__$1,self__.cnt-
2);var nr=cljs.core.pop_tail(coll__$1,self__.shift,self__.root);var new_root=nr==null?cljs.core.PersistentVector.EMPTY_NODE:nr;var cnt_1=self__.cnt-1;if(5<self__.shift&&cljs.core.pv_aget(new_root,1)==null)return new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift-5,cljs.core.pv_aget(new_root,0),new_tail,null);else return new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null)}};
cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1=function(coll){var self__=this;var coll__$1=this;if(self__.cnt>0)return new cljs.core.RSeq(coll__$1,self__.cnt-1,null);else return null};
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1=function(coll){var self__=this;var coll__$1=this;var h__7725__auto__=self__.__hash;if(!(h__7725__auto__==null))return h__7725__auto__;else{var h__7725__auto____$1=cljs.core.hash_ordered_coll(coll__$1);self__.__hash=h__7725__auto____$1;return h__7725__auto____$1}};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2=function(coll,other){var self__=this;var coll__$1=this;if(other instanceof cljs.core.PersistentVector)if(self__.cnt===cljs.core.count(other)){var me_iter=coll__$1.cljs$core$IIterable$_iterator$arity$1(null);var you_iter=cljs.core._iterator(other);while(true){if(me_iter.hasNext()){var x=me_iter.next();var y=you_iter.next();if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y))continue;else return false}else return true;break}}else return false;
else return cljs.core.equiv_sequential(coll__$1,other)};cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1=function(coll){var self__=this;var coll__$1=this;return new cljs.core.TransientVector(self__.cnt,self__.shift,cljs.core.tv_editable_root(self__.root),cljs.core.tv_editable_tail(self__.tail))};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1=function(coll){var self__=this;var coll__$1=this;return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta)};cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2=function(v,f){var self__=this;var v__$1=this;return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(v__$1,f,0,self__.cnt)};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3=function(v,f,init){var self__=this;var v__$1=this;var i=0;var init__$1=init;while(true){if(i<self__.cnt){var arr=cljs.core.unchecked_array_for(v__$1,i);var len=arr.length;var init__$2=function(){var j=0;var init__$2=init__$1;while(true){if(j<len){var init__$3=function(){var G__10786=init__$2;var G__10787=arr[j];return f.cljs$core$IFn$_invoke$arity$2?f.cljs$core$IFn$_invoke$arity$2(G__10786,G__10787):f.call(null,G__10786,G__10787)}();
if(cljs.core.reduced_QMARK_(init__$3))return init__$3;else{var G__10794=j+1;var G__10795=init__$3;j=G__10794;init__$2=G__10795;continue}}else return init__$2;break}}();if(cljs.core.reduced_QMARK_(init__$2))return cljs.core.deref(init__$2);else{var G__10796=i+len;var G__10797=init__$2;i=G__10796;init__$1=G__10797;continue}}else return init__$1;break}};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3=function(coll,k,v){var self__=this;var coll__$1=this;if(typeof k==="number")return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,k,v);else throw new Error("Vector's key for assoc must be a number.");};cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2=function(coll,k){var self__=this;var coll__$1=this;if(cljs.core.integer_QMARK_(k))return 0<=k&&k<self__.cnt;else return false};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1=function(coll){var self__=this;var coll__$1=this;if(self__.cnt===0)return null;else if(self__.cnt<=32)return new cljs.core.IndexedSeq(self__.tail,0,null);else return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(coll__$1,cljs.core.first_array_for_longvec(coll__$1),0,0)};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2=function(coll,meta__$1){var self__=this;var coll__$1=this;return new cljs.core.PersistentVector(meta__$1,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash)};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2=function(coll,o){var self__=this;var coll__$1=this;if(self__.cnt-cljs.core.tail_off(coll__$1)<32){var len=self__.tail.length;var new_tail=new Array(len+1);var n__8209__auto___10798=len;var i_10799=0;while(true){if(i_10799<n__8209__auto___10798){new_tail[i_10799]=self__.tail[i_10799];var G__10800=i_10799+1;i_10799=G__10800;continue}else;break}new_tail[len]=o;return new cljs.core.PersistentVector(self__.meta,self__.cnt+1,self__.shift,
self__.root,new_tail,null)}else{var root_overflow_QMARK_=self__.cnt>>>5>1<<self__.shift;var new_shift=root_overflow_QMARK_?self__.shift+5:self__.shift;var new_root=root_overflow_QMARK_?function(){var n_r=cljs.core.pv_fresh_node(null);cljs.core.pv_aset(n_r,0,self__.root);cljs.core.pv_aset(n_r,1,cljs.core.new_path(null,self__.shift,new cljs.core.VectorNode(null,self__.tail)));return n_r}():cljs.core.push_tail(coll__$1,self__.shift,self__.root,new cljs.core.VectorNode(null,self__.tail));return new cljs.core.PersistentVector(self__.meta,
self__.cnt+1,new_shift,new_root,[o],null)}};
cljs.core.PersistentVector.prototype.call=function(){var G__10801=null;var G__10801__2=function(self__,k){var self__=this;var self____$1=this;var coll=self____$1;return coll.cljs$core$IIndexed$_nth$arity$2(null,k)};var G__10801__3=function(self__,k,not_found){var self__=this;var self____$1=this;var coll=self____$1;return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found)};G__10801=function(self__,k,not_found){switch(arguments.length){case 2:return G__10801__2.call(this,self__,k);case 3:return G__10801__3.call(this,
self__,k,not_found)}throw new Error("Invalid arity: "+(arguments.length-1));};G__10801.cljs$core$IFn$_invoke$arity$2=G__10801__2;G__10801.cljs$core$IFn$_invoke$arity$3=G__10801__3;return G__10801}();cljs.core.PersistentVector.prototype.apply=function(self__,args10782){var self__=this;var self____$1=this;return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10782)))};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1=function(k){var self__=this;var coll=this;return coll.cljs$core$IIndexed$_nth$arity$2(null,k)};cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2=function(k,not_found){var self__=this;var coll=this;return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found)};
cljs.core.PersistentVector.getBasis=function(){return new cljs.core.PersistentVector(null,6,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"tail","tail",494507963,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),
new cljs.core.PersistentArrayMap(null,1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null))],null)};cljs.core.PersistentVector.cljs$lang$type=true;cljs.core.PersistentVector.cljs$lang$ctorStr="cljs.core/PersistentVector";cljs.core.PersistentVector.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/PersistentVector")};
cljs.core.__GT_PersistentVector=function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){return new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash)};cljs.core.PersistentVector.EMPTY_NODE=new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]);
cljs.core.PersistentVector.EMPTY=new cljs.core.PersistentVector(null,0,5,cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash);
cljs.core.PersistentVector.fromArray=function(xs,no_clone){var l=xs.length;var xs__$1=no_clone?xs:cljs.core.aclone(xs);if(l<32)return new cljs.core.PersistentVector(null,l,5,cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null);else{var node=xs__$1.slice(0,32);var v=new cljs.core.PersistentVector(null,32,5,cljs.core.PersistentVector.EMPTY_NODE,node,null);var i=32;var out=v.cljs$core$IEditableCollection$_as_transient$arity$1(null);while(true){if(i<l){var G__10802=i+1;var G__10803=cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,
xs__$1[i]);i=G__10802;out=G__10803;continue}else return cljs.core.persistent_BANG_(out);break}}};cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL]=function(){var this__8311__auto__=this;return cljs.core.es6_iterator(this__8311__auto__)};
cljs.core.vec=function cljs$core$vec(coll){if(cljs.core.array_QMARK_(coll))return cljs.core.PersistentVector.fromArray(coll,true);else return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll))};
cljs.core.vector=function cljs$core$vector(var_args){var args__8417__auto__=[];var len__8410__auto___10805=arguments.length;var i__8411__auto___10806=0;while(true){if(i__8411__auto___10806<len__8410__auto___10805){args__8417__auto__.push(arguments[i__8411__auto___10806]);var G__10807=i__8411__auto___10806+1;i__8411__auto___10806=G__10807;continue}else;break}var argseq__8418__auto__=0<args__8417__auto__.length?new cljs.core.IndexedSeq(args__8417__auto__.slice(0),0,null):null;return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__8418__auto__)};
cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic=function(args){if(args instanceof cljs.core.IndexedSeq&&args.i===0)return cljs.core.PersistentVector.fromArray(args.arr,true);else return cljs.core.vec(args)};cljs.core.vector.cljs$lang$maxFixedArity=0;cljs.core.vector.cljs$lang$applyTo=function(seq10804){return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10804))};
cljs.core.ChunkedSeq=function(vec,node,i,off,meta,__hash){this.vec=vec;this.node=node;this.i=i;this.off=off;this.meta=meta;this.__hash=__hash;this.cljs$lang$protocol_mask$partition0$=32375020;this.cljs$lang$protocol_mask$partition1$=1536};cljs.core.ChunkedSeq.prototype.toString=function(){var self__=this;var coll=this;return cljs.core.pr_str_STAR_(coll)};cljs.core.ChunkedSeq.prototype.equiv=function(other){var self__=this;var this$=this;return this$.cljs$core$IEquiv$_equiv$arity$2(null,other)};
cljs.core.ChunkedSeq.prototype.indexOf=function(){var G__10808=null;var G__10808__1=function(x){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,0)};var G__10808__2=function(x,start){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__10808=function(x,start){switch(arguments.length){case 1:return G__10808__1.call(this,x);case 2:return G__10808__2.call(this,x,start)}throw new Error("Invalid arity: "+(arguments.length-
1));};G__10808.cljs$core$IFn$_invoke$arity$1=G__10808__1;G__10808.cljs$core$IFn$_invoke$arity$2=G__10808__2;return G__10808}();
cljs.core.ChunkedSeq.prototype.lastIndexOf=function(){var G__10809=null;var G__10809__1=function(x){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll))};var G__10809__2=function(x,start){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start)};G__10809=function(x,start){switch(arguments.length){case 1:return G__10809__1.call(this,x);case 2:return G__10809__2.call(this,x,start)}throw new Error("Invalid arity: "+
(arguments.length-1));};G__10809.cljs$core$IFn$_invoke$arity$1=G__10809__1;G__10809.cljs$core$IFn$_invoke$arity$2=G__10809__2;return G__10809}();cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.meta};
cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1=function(coll){var self__=this;var coll__$1=this;if(self__.off+1<self__.node.length){var s=cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,self__.off+1);if(s==null)return null;else return s}else return coll__$1.cljs$core$IChunkedNext$_chunked_next$arity$1(null)};
cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1=function(coll){var self__=this;var coll__$1=this;var h__7725__auto__=self__.__hash;if(!(h__7725__auto__==null))return h__7725__auto__;else{var h__7725__auto____$1=cljs.core.hash_ordered_coll(coll__$1);self__.__hash=h__7725__auto____$1;return h__7725__auto____$1}};cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2=function(coll,other){var self__=this;var coll__$1=this;return cljs.core.equiv_sequential(coll__$1,other)};
cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1=function(coll){var self__=this;var coll__$1=this;return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta)};cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2=function(coll,f){var self__=this;var coll__$1=this;return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.vec,f,self__.i+self__.off,cljs.core.count(self__.vec))};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3=function(coll,f,start){var self__=this;var coll__$1=this;return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.vec,f,start,self__.i+self__.off,cljs.core.count(self__.vec))};cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.node[self__.off]};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1=function(coll){var self__=this;var coll__$1=this;if(self__.off+1<self__.node.length){var s=cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,self__.off+1);if(s==null)return cljs.core.List.EMPTY;else return s}else return coll__$1.cljs$core$IChunkedSeq$_chunked_rest$arity$1(null)};cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1=function(coll){var self__=this;var coll__$1=this;return coll__$1};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1=function(coll){var self__=this;var coll__$1=this;return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off)};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1=function(coll){var self__=this;var coll__$1=this;var end=self__.i+self__.node.length;if(end<cljs.core._count(self__.vec))return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,end),end,0);else return cljs.core.List.EMPTY};
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2=function(coll,m){var self__=this;var coll__$1=this;return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec,self__.node,self__.i,self__.off,m)};cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2=function(coll,o){var self__=this;var coll__$1=this;return cljs.core.cons(o,coll__$1)};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1=function(coll){var self__=this;var coll__$1=this;var end=self__.i+self__.node.length;if(end<cljs.core._count(self__.vec))return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,end),end,0);else return null};
cljs.core.ChunkedSeq.getBasis=function(){return new cljs.core.PersistentVector(null,6,5,cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Symbol(null,"vec","vec",982683596,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null,
1,[new cljs.core.Keyword(null,"mutable","mutable",875778266),true],null))],null)};cljs.core.ChunkedSeq.cljs$lang$type=true;cljs.core.ChunkedSeq.cljs$lang$ctorStr="cljs.core/ChunkedSeq";cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter=function(this__7896__auto__,writer__7897__auto__,opt__7898__auto__){return cljs.core._write(writer__7897__auto__,"cljs.core/ChunkedSeq")};
cljs.core.__GT_ChunkedSeq=function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){return new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash)};cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL]=function(){var this__8311__auto__=this;return cljs.core.es6_iterator(this__8311__auto__)};
cljs.core.chunked_seq=function cljs$core$chunked_seq(var_args){var G__10811=arguments.length;switch(G__10811){case 3:return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3(arguments[0],arguments[1],arguments[2]);break;case 4:return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(arguments[0],arguments[1],arguments[2],arguments[3]);break;case 5:return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4]);break;default:throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),
cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));}};cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3=function(vec,i,off){return new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null)};cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4=function(vec,node,i,off){return new cljs.core.ChunkedSeq(vec,node,i,off,null,null)};cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5=function(vec,node,i,off,meta){return new cljs.core.ChunkedSeq(vec,node,i,off,meta,null)};
cljs.core.chunked_seq.cljs$lang$maxFixedArity=5;cljs.core.Subvec=function(meta,v,start,end,__hash){this.meta=meta;this.v=v;this.start=start;this.end=end;this.__hash=__hash;this.cljs$lang$protocol_mask$partition0$=167666463;this.cljs$lang$protocol_mask$partition1$=139264};cljs.core.Subvec.prototype.cljs$core$IFind$=cljs.core.PROTOCOL_SENTINEL;
cljs.core.Subvec.prototype.cljs$core$IFind$_find$arity$2=function(coll,n){var self__=this;var coll__$1=this;if(n<0)return null;else{var idx=self__.start+n;if(idx<self__.end)return new cljs.core.PersistentVector(null,2,5,cljs.core.PersistentVector.EMPTY_NODE,[n,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.v,idx)],null);else return null}};cljs.core.Subvec.prototype.toString=function(){var self__=this;var coll=this;return cljs.core.pr_str_STAR_(coll)};
cljs.core.Subvec.prototype.equiv=function(other){var self__=this;var this$=this;return this$.cljs$core$IEquiv$_equiv$arity$2(null,other)};
cljs.core.Subvec.prototype.indexOf=function(){var G__10820=null;var G__10820__1=function(x){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,0)};var G__10820__2=function(x,start__$1){var self__=this;var coll=this;return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1)};G__10820=function(x,start__$1){switch(arguments.length){case 1:return G__10820__1.call(this,x);case 2:return G__10820__2.call(this,x,start__$1)}throw new Error("Invalid arity: "+
(arguments.length-1));};G__10820.cljs$core$IFn$_invoke$arity$1=G__10820__1;G__10820.cljs$core$IFn$_invoke$arity$2=G__10820__2;return G__10820}();
cljs.core.Subvec.prototype.lastIndexOf=function(){var G__10821=null;var G__10821__1=function(x){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll))};var G__10821__2=function(x,start__$1){var self__=this;var coll=this;return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1)};G__10821=function(x,start__$1){switch(arguments.length){case 1:return G__10821__1.call(this,x);case 2:return G__10821__2.call(this,x,start__$1)}throw new Error("Invalid arity: "+
(arguments.length-1));};G__10821.cljs$core$IFn$_invoke$arity$1=G__10821__1;G__10821.cljs$core$IFn$_invoke$arity$2=G__10821__2;return G__10821}();cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2=function(coll,k){var self__=this;var coll__$1=this;return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null)};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3=function(coll,k,not_found){var self__=this;var coll__$1=this;if(typeof k==="number")return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);else return not_found};
cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3=function(coll,f,init){var self__=this;var coll__$1=this;var i=self__.start;var j=0;var init__$1=init;while(true){if(i<self__.end){var init__$2=function(){var G__10814=init__$1;var G__10815=j;var G__10816=cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);return f.cljs$core$IFn$_invoke$arity$3?f.cljs$core$IFn$_invoke$arity$3(G__10814,G__10815,G__10816):f.call(null,G__10814,G__10815,G__10816)}();if(cljs.core.reduced_QMARK_(init__$2))return cljs.core.deref(init__$2);
else{var G__10822=i+1;var G__10823=j+1;var G__10824=init__$2;i=G__10822;j=G__10823;init__$1=G__10824;continue}}else return init__$1;break}};cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2=function(coll,n){var self__=this;var coll__$1=this;if(n<0||self__.end<=self__.start+n)return cljs.core.vector_index_out_of_bounds(n,self__.end-self__.start);else return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,self__.start+n)};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3=function(coll,n,not_found){var self__=this;var coll__$1=this;if(n<0||self__.end<=self__.start+n)return not_found;else return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,self__.start+n,not_found)};
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3=function(coll,n,val){var self__=this;var coll__$1=this;var v_pos=self__.start+n;if(n<0||self__.end+1<=v_pos)throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Index "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(n),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" out of bounds [0,"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll__$1.cljs$core$ICounted$_count$arity$1(null)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("]")].join(""));
else return cljs.core.build_subvec(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val),self__.start,function(){var x__7621__auto__=self__.end;var y__7622__auto__=v_pos+1;return x__7621__auto__>y__7622__auto__?x__7621__auto__:y__7622__auto__}(),null)};
cljs.core.Subvec.prototype.cljs$core$IIterable$_iterator$arity$1=function(coll){var self__=this;var coll__$1=this;if(!(self__.v==null)?false||cljs.core.PROTOCOL_SENTINEL===self__.v.cljs$core$APersistentVector$?true:false:false)return cljs.core.ranged_iterator(self__.v,self__.start,self__.end);else return cljs.core.seq_iter(coll__$1)};cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.meta};
cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1=function(_){var self__=this;var ___$1=this;return new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash)};cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1=function(coll){var self__=this;var coll__$1=this;return self__.end-self__.start};
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1=function(coll){var self__=this;var coll__$1=this;return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,self__.end-1)};cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1=function(coll){var self__=this;var coll__$1=this;if(self__.start===self__.end)throw new Error("Can't pop empty vector");else return cljs.core.build_subvec(self__.meta,self__.v,self__.start,self__.end-1,null)};
cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1=function(coll){var self__=this;var coll__$1=this;if(!(self__.start===self__.end))return new cljs.core.RSeq(coll__$1,self__.end-self__.start-1,null);else return null};
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1=function(coll){var self__=this;var coll__$1=this;var h__7725__auto__=self__.__hash;if(!(h__7725__auto__==null))return h__7725__auto__;else{var h__7725__auto____$1=cljs.core.hash_ordered_coll(coll__$1);self__.__hash=h__7725__auto____$1;return h__7725__auto____$1}};cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2=function(coll,other){var self__=this;var coll__$1=this;return cljs.core.equiv_sequential(coll__$1,other)};
cljs.core.Subvec.prototype.cljs$core$IE