(ns statecharts.rf
  "Integration with re-frame"
  (:require [re-frame.core :as rf]
            [re-frame.db :refer [app-db]]
            [statecharts.service :as service]))

(rf/reg-event-db
 ::sync-state-update
 (fn [db [_ path state]]
   (assoc-in db path state)))

(defn connect-rf-db
  "Update the given path of re-frame app-db whenever the state of the
  fsm service changes."
  [service path]
  (service/add-listener
   service
   ;; listener id
   [::connect-rf-db path]
   (fn [_ new-state]
     (rf/dispatch [::sync-state-update path new-state]))))
