package org.ingram.color.util;
 
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.ingram.color.entity.ColorEntity;
import org.ingram.color.entity.ColorListEntity;
 
public class HibernateUtil{
   private static SessionFactory sessionFactory = buildSessionFactory();
 
   private static SessionFactory buildSessionFactory(){
      try{
         if(sessionFactory == null){
            Configuration configuration = new Configuration();
            //configuration.addPackage("org.ingram.color.entity");
            configuration.addAnnotatedClass(ColorEntity.class);
            configuration.addAnnotatedClass(ColorListEntity.class);
            configuration.configure(HibernateUtil.class.getResource("/hibernate.cfg.xml"));
            StandardServiceRegistryBuilder serviceRegistryBuilder = new StandardServiceRegistryBuilder();
            serviceRegistryBuilder.applySettings(configuration.getProperties());
            ServiceRegistry serviceRegistry = serviceRegistryBuilder.build();
            sessionFactory = configuration.buildSessionFactory(serviceRegistry);
         }
         return sessionFactory;
      }catch(Throwable ex){
         System.err.println("Initial SessionFactory creation failed." + ex);
         throw new ExceptionInInitializerError(ex);
      }
   }
 
   public static SessionFactory getSessionFactory(){
      return sessionFactory;
   }
 
   public static void shutdown(){
      getSessionFactory().close();
   }
}