// Compiled by ClojureScript 0.0-3308 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');

figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.all_QMARK_ = (function figwheel$client$file_reloading$all_QMARK_(pred,coll){
return cljs.core.reduce.call(null,(function (p1__27118_SHARP_,p2__27119_SHARP_){
var and__16097__auto__ = p1__27118_SHARP_;
if(cljs.core.truth_(and__16097__auto__)){
return p2__27119_SHARP_;
} else {
return and__16097__auto__;
}
}),true,cljs.core.map.call(null,pred,coll));
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__16109__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__16109__auto__){
return or__16109__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.ns_to_js_file = (function figwheel$client$file_reloading$ns_to_js_file(ns){

return [cljs.core.str(clojure.string.replace.call(null,ns,".","/")),cljs.core.str(".js")].join('');
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){

return [cljs.core.str(figwheel.client.utils.base_url_path.call(null)),cljs.core.str(figwheel.client.file_reloading.ns_to_js_file.call(null,ns))].join('');
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
goog.isProvided = (function (x){
return false;
});

if(((cljs.core._STAR_loaded_libs_STAR_ == null)) || (cljs.core.empty_QMARK_.call(null,cljs.core._STAR_loaded_libs_STAR_))){
cljs.core._STAR_loaded_libs_STAR_ = (function (){var gntp = goog.dependencies_.nameToPath;
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.call(null,((function (gntp){
return (function (name){
return (goog.dependencies_.visited[(gntp[name])]);
});})(gntp))
,cljs.core.js_keys.call(null,gntp)));
})();
} else {
}

goog.require = (function (name,reload){
if(cljs.core.truth_((function (){var or__16109__auto__ = !(cljs.core.contains_QMARK_.call(null,cljs.core._STAR_loaded_libs_STAR_,name));
if(or__16109__auto__){
return or__16109__auto__;
} else {
return reload;
}
})())){
cljs.core._STAR_loaded_libs_STAR_ = cljs.core.conj.call(null,(function (){var or__16109__auto__ = cljs.core._STAR_loaded_libs_STAR_;
if(cljs.core.truth_(or__16109__auto__)){
return or__16109__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})(),name);

return figwheel.client.file_reloading.reload_file_STAR_.call(null,figwheel.client.file_reloading.resolve_ns.call(null,name));
} else {
return null;
}
});

goog.provide = goog.exportPath_;

return goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.reload_file_STAR_;
});
if(typeof figwheel.client.file_reloading.resolve_url !== 'undefined'){
} else {
figwheel.client.file_reloading.resolve_url = (function (){var method_table__17004__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__17005__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__17006__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__17007__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__17008__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"figwheel.client.file-reloading","resolve-url"),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__17008__auto__,method_table__17004__auto__,prefer_table__17005__auto__,method_cache__17006__auto__,cached_hierarchy__17007__auto__));
})();
}
cljs.core._add_method.call(null,figwheel.client.file_reloading.resolve_url,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__27130){
var map__27131 = p__27130;
var map__27131__$1 = ((cljs.core.seq_QMARK_.call(null,map__27131))?cljs.core.apply.call(null,cljs.core.hash_map,map__27131):map__27131);
var file = cljs.core.get.call(null,map__27131__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
return file;
}));
cljs.core._add_method.call(null,figwheel.client.file_reloading.resolve_url,new cljs.core.Keyword(null,"namespace","namespace",-377510372),(function (p__27135){
var map__27136 = p__27135;
var map__27136__$1 = ((cljs.core.seq_QMARK_.call(null,map__27136))?cljs.core.apply.call(null,cljs.core.hash_map,map__27136):map__27136);
var namespace = cljs.core.get.call(null,map__27136__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

return figwheel.client.file_reloading.resolve_ns.call(null,namespace);
}));
if(typeof figwheel.client.file_reloading.reload_base !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_base = (function (){var method_table__17004__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__17005__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__17006__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__17007__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__17008__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"figwheel.client.file-reloading","reload-base"),figwheel.client.utils.host_env_QMARK_,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__17008__auto__,method_table__17004__auto__,prefer_table__17005__auto__,method_cache__17006__auto__,cached_hierarchy__17007__auto__));
})();
}
cljs.core._add_method.call(null,figwheel.client.file_reloading.reload_base,new cljs.core.Keyword(null,"node","node",581201198),(function (request_url,callback){

var root = clojure.string.join.call(null,"/",cljs.core.reverse.call(null,cljs.core.drop.call(null,(2),cljs.core.reverse.call(null,clojure.string.split.call(null,__dirname,"/")))));
var path = [cljs.core.str(root),cljs.core.str("/"),cljs.core.str(request_url)].join('');
(require.cache[path] = null);

return callback.call(null,(function (){try{return require(path);
}catch (e27140){if((e27140 instanceof Error)){
var e = e27140;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e27140;

}
}})());
}));
cljs.core._add_method.call(null,figwheel.client.file_reloading.reload_base,new cljs.core.Keyword(null,"html","html",-998796897),(function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),{"cleanupWhenDone": true});
deferred.addCallback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred))
);

return deferred.addErrback(((function (deferred){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred))
);
}));
figwheel.client.file_reloading.reload_file_STAR_ = (function figwheel$client$file_reloading$reload_file_STAR_(){
var G__27144 = arguments.length;
switch (G__27144) {
case 2:
return figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (request_url,callback){
return figwheel.client.file_reloading.reload_base.call(null,request_url,callback);
});

figwheel.client.file_reloading.reload_file_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (request_url){
return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,cljs.core.identity);
});

figwheel.client.file_reloading.reload_file_STAR_.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__27146,callback){
var map__27150 = p__27146;
var map__27150__$1 = ((cljs.core.seq_QMARK_.call(null,map__27150))?cljs.core.apply.call(null,cljs.core.hash_map,map__27150):map__27150);
var file_msg = map__27150__$1;
var request_url = cljs.core.get.call(null,map__27150__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__27150,map__27150__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfullly loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__27150,map__27150__$1,file_msg,request_url))
);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__27153){
var map__27157 = p__27153;
var map__27157__$1 = ((cljs.core.seq_QMARK_.call(null,map__27157))?cljs.core.apply.call(null,cljs.core.hash_map,map__27157):map__27157);
var file_msg = map__27157__$1;
var namespace = cljs.core.get.call(null,map__27157__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,map__27157__$1,new cljs.core.Keyword(null,"meta-data","meta-data",-1613399157));

var meta_data__$1 = (function (){var or__16109__auto__ = meta_data;
if(cljs.core.truth_(or__16109__auto__)){
return or__16109__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var and__16097__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_data__$1));
if(and__16097__auto__){
var or__16109__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_data__$1);
if(cljs.core.truth_(or__16109__auto__)){
return or__16109__auto__;
} else {
var or__16109__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_data__$1);
if(cljs.core.truth_(or__16109__auto____$1)){
return or__16109__auto____$1;
} else {
var and__16097__auto____$1 = cljs.core.contains_QMARK_.call(null,cljs.core._STAR_loaded_libs_STAR_,namespace);
if(and__16097__auto____$1){
var or__16109__auto____$2 = !(cljs.core.contains_QMARK_.call(null,meta_data__$1,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932)));
if(or__16109__auto____$2){
return or__16109__auto____$2;
} else {
return new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932).cljs$core$IFn$_invoke$arity$1(meta_data__$1);
}
} else {
return and__16097__auto____$1;
}
}
}
} else {
return and__16097__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__27160,callback){
var map__27162 = p__27160;
var map__27162__$1 = ((cljs.core.seq_QMARK_.call(null,map__27162))?cljs.core.apply.call(null,cljs.core.hash_map,map__27162):map__27162);
var file_msg = map__27162__$1;
var request_url = cljs.core.get.call(null,map__27162__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__27162__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.reload_file.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
setTimeout(((function (out){
return (function (){
return figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
figwheel.client.file_reloading.patch_goog_base.call(null);

cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);
});})(out))
,(0));

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__20380__auto___27260 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto___27260,out){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto___27260,out){
return (function (state_27238){
var state_val_27239 = (state_27238[(1)]);
if((state_val_27239 === (1))){
var inst_27216 = cljs.core.nth.call(null,files,(0),null);
var inst_27217 = cljs.core.nthnext.call(null,files,(1));
var inst_27218 = files;
var state_27238__$1 = (function (){var statearr_27240 = state_27238;
(statearr_27240[(7)] = inst_27217);

(statearr_27240[(8)] = inst_27218);

(statearr_27240[(9)] = inst_27216);

return statearr_27240;
})();
var statearr_27241_27261 = state_27238__$1;
(statearr_27241_27261[(2)] = null);

(statearr_27241_27261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (2))){
var inst_27221 = (state_27238[(10)]);
var inst_27218 = (state_27238[(8)]);
var inst_27221__$1 = cljs.core.nth.call(null,inst_27218,(0),null);
var inst_27222 = cljs.core.nthnext.call(null,inst_27218,(1));
var inst_27223 = (inst_27221__$1 == null);
var inst_27224 = cljs.core.not.call(null,inst_27223);
var state_27238__$1 = (function (){var statearr_27244 = state_27238;
(statearr_27244[(10)] = inst_27221__$1);

(statearr_27244[(11)] = inst_27222);

return statearr_27244;
})();
if(inst_27224){
var statearr_27245_27262 = state_27238__$1;
(statearr_27245_27262[(1)] = (4));

} else {
var statearr_27246_27263 = state_27238__$1;
(statearr_27246_27263[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (3))){
var inst_27236 = (state_27238[(2)]);
var state_27238__$1 = state_27238;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27238__$1,inst_27236);
} else {
if((state_val_27239 === (4))){
var inst_27221 = (state_27238[(10)]);
var inst_27226 = figwheel.client.file_reloading.reload_js_file.call(null,inst_27221);
var state_27238__$1 = state_27238;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27238__$1,(7),inst_27226);
} else {
if((state_val_27239 === (5))){
var inst_27232 = cljs.core.async.close_BANG_.call(null,out);
var state_27238__$1 = state_27238;
var statearr_27248_27268 = state_27238__$1;
(statearr_27248_27268[(2)] = inst_27232);

(statearr_27248_27268[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (6))){
var inst_27234 = (state_27238[(2)]);
var state_27238__$1 = state_27238;
var statearr_27249_27269 = state_27238__$1;
(statearr_27249_27269[(2)] = inst_27234);

(statearr_27249_27269[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27239 === (7))){
var inst_27222 = (state_27238[(11)]);
var inst_27228 = (state_27238[(2)]);
var inst_27229 = cljs.core.async.put_BANG_.call(null,out,inst_27228);
var inst_27218 = inst_27222;
var state_27238__$1 = (function (){var statearr_27250 = state_27238;
(statearr_27250[(8)] = inst_27218);

(statearr_27250[(12)] = inst_27229);

return statearr_27250;
})();
var statearr_27251_27272 = state_27238__$1;
(statearr_27251_27272[(2)] = null);

(statearr_27251_27272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__20380__auto___27260,out))
;
return ((function (switch__20318__auto__,c__20380__auto___27260,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20319__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20319__auto____0 = (function (){
var statearr_27255 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27255[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20319__auto__);

(statearr_27255[(1)] = (1));

return statearr_27255;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__20319__auto____1 = (function (state_27238){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_27238);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e27256){if((e27256 instanceof Object)){
var ex__20322__auto__ = e27256;
var statearr_27257_27274 = state_27238;
(statearr_27257_27274[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27238);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27256;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27275 = state_27238;
state_27238 = G__27275;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20319__auto__ = function(state_27238){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20319__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20319__auto____1.call(this,state_27238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20319__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__20319__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto___27260,out))
})();
var state__20382__auto__ = (function (){var statearr_27259 = f__20381__auto__.call(null);
(statearr_27259[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto___27260);

return statearr_27259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto___27260,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.add_request_url = (function figwheel$client$file_reloading$add_request_url(p__27276,p__27277){
var map__27282 = p__27276;
var map__27282__$1 = ((cljs.core.seq_QMARK_.call(null,map__27282))?cljs.core.apply.call(null,cljs.core.hash_map,map__27282):map__27282);
var opts = map__27282__$1;
var url_rewriter = cljs.core.get.call(null,map__27282__$1,new cljs.core.Keyword(null,"url-rewriter","url-rewriter",200543838));
var map__27283 = p__27277;
var map__27283__$1 = ((cljs.core.seq_QMARK_.call(null,map__27283))?cljs.core.apply.call(null,cljs.core.hash_map,map__27283):map__27283);
var file_msg = map__27283__$1;
var file = cljs.core.get.call(null,map__27283__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var resolved_path = figwheel.client.file_reloading.resolve_url.call(null,file_msg);
return cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"request-url","request-url",2100346596),(cljs.core.truth_(url_rewriter)?url_rewriter.call(null,resolved_path):resolved_path));
});
figwheel.client.file_reloading.add_request_urls = (function figwheel$client$file_reloading$add_request_urls(opts,files){
return cljs.core.map.call(null,cljs.core.partial.call(null,figwheel.client.file_reloading.add_request_url,opts),files);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__27288,opts){
var map__27291 = p__27288;
var map__27291__$1 = ((cljs.core.seq_QMARK_.call(null,map__27291))?cljs.core.apply.call(null,cljs.core.hash_map,map__27291):map__27291);
var eval_body__$1 = cljs.core.get.call(null,map__27291__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__27291__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__16097__auto__ = eval_body__$1;
if(cljs.core.truth_(and__16097__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__16097__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e27292){var e = e27292;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__27304,p__27305){
var map__27522 = p__27304;
var map__27522__$1 = ((cljs.core.seq_QMARK_.call(null,map__27522))?cljs.core.apply.call(null,cljs.core.hash_map,map__27522):map__27522);
var opts = map__27522__$1;
var before_jsload = cljs.core.get.call(null,map__27522__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__27522__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var load_unchanged_files = cljs.core.get.call(null,map__27522__$1,new cljs.core.Keyword(null,"load-unchanged-files","load-unchanged-files",-1561468704));
var map__27523 = p__27305;
var map__27523__$1 = ((cljs.core.seq_QMARK_.call(null,map__27523))?cljs.core.apply.call(null,cljs.core.hash_map,map__27523):map__27523);
var msg = map__27523__$1;
var files = cljs.core.get.call(null,map__27523__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var c__20380__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files){
return (function (state_27657){
var state_val_27658 = (state_27657[(1)]);
if((state_val_27658 === (7))){
var inst_27540 = (state_27657[(7)]);
var inst_27541 = (state_27657[(8)]);
var inst_27539 = (state_27657[(9)]);
var inst_27538 = (state_27657[(10)]);
var inst_27546 = cljs.core._nth.call(null,inst_27539,inst_27541);
var inst_27547 = figwheel.client.file_reloading.eval_body.call(null,inst_27546,opts);
var inst_27548 = (inst_27541 + (1));
var tmp27659 = inst_27540;
var tmp27660 = inst_27539;
var tmp27661 = inst_27538;
var inst_27538__$1 = tmp27661;
var inst_27539__$1 = tmp27660;
var inst_27540__$1 = tmp27659;
var inst_27541__$1 = inst_27548;
var state_27657__$1 = (function (){var statearr_27662 = state_27657;
(statearr_27662[(7)] = inst_27540__$1);

(statearr_27662[(11)] = inst_27547);

(statearr_27662[(8)] = inst_27541__$1);

(statearr_27662[(9)] = inst_27539__$1);

(statearr_27662[(10)] = inst_27538__$1);

return statearr_27662;
})();
var statearr_27663_27747 = state_27657__$1;
(statearr_27663_27747[(2)] = null);

(statearr_27663_27747[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (20))){
var inst_27587 = (state_27657[(12)]);
var inst_27590 = (state_27657[(13)]);
var inst_27593 = (state_27657[(14)]);
var inst_27591 = (state_27657[(15)]);
var inst_27586 = (state_27657[(16)]);
var inst_27596 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_27598 = (function (){var all_files = inst_27586;
var files_SINGLEQUOTE_ = inst_27587;
var res_SINGLEQUOTE_ = inst_27590;
var res = inst_27591;
var files_not_loaded = inst_27593;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_27587,inst_27590,inst_27593,inst_27591,inst_27586,inst_27596,state_val_27658,c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files){
return (function (p__27597){
var map__27664 = p__27597;
var map__27664__$1 = ((cljs.core.seq_QMARK_.call(null,map__27664))?cljs.core.apply.call(null,cljs.core.hash_map,map__27664):map__27664);
var namespace = cljs.core.get.call(null,map__27664__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__27664__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.ns_to_js_file.call(null,namespace);
} else {
return file;
}
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_27587,inst_27590,inst_27593,inst_27591,inst_27586,inst_27596,state_val_27658,c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files))
})();
var inst_27599 = cljs.core.map.call(null,inst_27598,inst_27591);
var inst_27600 = cljs.core.pr_str.call(null,inst_27599);
var inst_27601 = figwheel.client.utils.log.call(null,inst_27600);
var inst_27602 = (function (){var all_files = inst_27586;
var files_SINGLEQUOTE_ = inst_27587;
var res_SINGLEQUOTE_ = inst_27590;
var res = inst_27591;
var files_not_loaded = inst_27593;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_27587,inst_27590,inst_27593,inst_27591,inst_27586,inst_27596,inst_27598,inst_27599,inst_27600,inst_27601,state_val_27658,c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_27587,inst_27590,inst_27593,inst_27591,inst_27586,inst_27596,inst_27598,inst_27599,inst_27600,inst_27601,state_val_27658,c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files))
})();
var inst_27603 = setTimeout(inst_27602,(10));
var state_27657__$1 = (function (){var statearr_27665 = state_27657;
(statearr_27665[(17)] = inst_27601);

(statearr_27665[(18)] = inst_27596);

return statearr_27665;
})();
var statearr_27666_27757 = state_27657__$1;
(statearr_27666_27757[(2)] = inst_27603);

(statearr_27666_27757[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (27))){
var inst_27613 = (state_27657[(19)]);
var state_27657__$1 = state_27657;
var statearr_27667_27758 = state_27657__$1;
(statearr_27667_27758[(2)] = inst_27613);

(statearr_27667_27758[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (1))){
var inst_27530 = (state_27657[(20)]);
var inst_27527 = before_jsload.call(null,files);
var inst_27528 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_27529 = (function (){return ((function (inst_27530,inst_27527,inst_27528,state_val_27658,c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files){
return (function (p1__27300_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__27300_SHARP_);
});
;})(inst_27530,inst_27527,inst_27528,state_val_27658,c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files))
})();
var inst_27530__$1 = cljs.core.filter.call(null,inst_27529,files);
var inst_27531 = cljs.core.not_empty.call(null,inst_27530__$1);
var state_27657__$1 = (function (){var statearr_27668 = state_27657;
(statearr_27668[(20)] = inst_27530__$1);

(statearr_27668[(21)] = inst_27527);

(statearr_27668[(22)] = inst_27528);

return statearr_27668;
})();
if(cljs.core.truth_(inst_27531)){
var statearr_27669_27759 = state_27657__$1;
(statearr_27669_27759[(1)] = (2));

} else {
var statearr_27670_27760 = state_27657__$1;
(statearr_27670_27760[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (24))){
var state_27657__$1 = state_27657;
var statearr_27671_27761 = state_27657__$1;
(statearr_27671_27761[(2)] = null);

(statearr_27671_27761[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (4))){
var inst_27575 = (state_27657[(2)]);
var inst_27579 = (function (){return ((function (inst_27575,state_val_27658,c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files){
return (function (p1__27301_SHARP_){
var and__16097__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__27301_SHARP_);
if(cljs.core.truth_(and__16097__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__27301_SHARP_));
} else {
return and__16097__auto__;
}
});
;})(inst_27575,state_val_27658,c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files))
})();
var inst_27580 = cljs.core.filter.call(null,inst_27579,files);
var state_27657__$1 = (function (){var statearr_27672 = state_27657;
(statearr_27672[(23)] = inst_27580);

(statearr_27672[(24)] = inst_27575);

return statearr_27672;
})();
if(cljs.core.truth_(load_unchanged_files)){
var statearr_27673_27768 = state_27657__$1;
(statearr_27673_27768[(1)] = (16));

} else {
var statearr_27674_27769 = state_27657__$1;
(statearr_27674_27769[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (15))){
var inst_27565 = (state_27657[(2)]);
var state_27657__$1 = state_27657;
var statearr_27675_27773 = state_27657__$1;
(statearr_27675_27773[(2)] = inst_27565);

(statearr_27675_27773[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (21))){
var state_27657__$1 = state_27657;
var statearr_27676_27777 = state_27657__$1;
(statearr_27676_27777[(2)] = null);

(statearr_27676_27777[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (31))){
var inst_27621 = (state_27657[(25)]);
var inst_27631 = (state_27657[(2)]);
var inst_27632 = cljs.core.not_empty.call(null,inst_27621);
var state_27657__$1 = (function (){var statearr_27677 = state_27657;
(statearr_27677[(26)] = inst_27631);

return statearr_27677;
})();
if(cljs.core.truth_(inst_27632)){
var statearr_27678_27778 = state_27657__$1;
(statearr_27678_27778[(1)] = (32));

} else {
var statearr_27679_27779 = state_27657__$1;
(statearr_27679_27779[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (32))){
var inst_27621 = (state_27657[(25)]);
var inst_27634 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_27621);
var inst_27635 = cljs.core.pr_str.call(null,inst_27634);
var inst_27636 = [cljs.core.str("file didn't change: "),cljs.core.str(inst_27635)].join('');
var inst_27637 = figwheel.client.utils.log.call(null,inst_27636);
var state_27657__$1 = state_27657;
var statearr_27680_27780 = state_27657__$1;
(statearr_27680_27780[(2)] = inst_27637);

(statearr_27680_27780[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (33))){
var state_27657__$1 = state_27657;
var statearr_27681_27781 = state_27657__$1;
(statearr_27681_27781[(2)] = null);

(statearr_27681_27781[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (13))){
var inst_27551 = (state_27657[(27)]);
var inst_27555 = cljs.core.chunk_first.call(null,inst_27551);
var inst_27556 = cljs.core.chunk_rest.call(null,inst_27551);
var inst_27557 = cljs.core.count.call(null,inst_27555);
var inst_27538 = inst_27556;
var inst_27539 = inst_27555;
var inst_27540 = inst_27557;
var inst_27541 = (0);
var state_27657__$1 = (function (){var statearr_27682 = state_27657;
(statearr_27682[(7)] = inst_27540);

(statearr_27682[(8)] = inst_27541);

(statearr_27682[(9)] = inst_27539);

(statearr_27682[(10)] = inst_27538);

return statearr_27682;
})();
var statearr_27683_27782 = state_27657__$1;
(statearr_27683_27782[(2)] = null);

(statearr_27683_27782[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (22))){
var inst_27593 = (state_27657[(14)]);
var inst_27606 = (state_27657[(2)]);
var inst_27607 = cljs.core.not_empty.call(null,inst_27593);
var state_27657__$1 = (function (){var statearr_27684 = state_27657;
(statearr_27684[(28)] = inst_27606);

return statearr_27684;
})();
if(cljs.core.truth_(inst_27607)){
var statearr_27688_27783 = state_27657__$1;
(statearr_27688_27783[(1)] = (23));

} else {
var statearr_27689_27784 = state_27657__$1;
(statearr_27689_27784[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (36))){
var state_27657__$1 = state_27657;
var statearr_27690_27785 = state_27657__$1;
(statearr_27690_27785[(2)] = null);

(statearr_27690_27785[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (29))){
var inst_27620 = (state_27657[(29)]);
var inst_27625 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_27620);
var inst_27626 = cljs.core.pr_str.call(null,inst_27625);
var inst_27627 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_27626)].join('');
var inst_27628 = figwheel.client.utils.log.call(null,inst_27627);
var state_27657__$1 = state_27657;
var statearr_27691_27786 = state_27657__$1;
(statearr_27691_27786[(2)] = inst_27628);

(statearr_27691_27786[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (6))){
var inst_27572 = (state_27657[(2)]);
var state_27657__$1 = state_27657;
var statearr_27692_27787 = state_27657__$1;
(statearr_27692_27787[(2)] = inst_27572);

(statearr_27692_27787[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (28))){
var inst_27620 = (state_27657[(29)]);
var inst_27619 = (state_27657[(2)]);
var inst_27620__$1 = cljs.core.get.call(null,inst_27619,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_27621 = cljs.core.get.call(null,inst_27619,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932));
var inst_27622 = cljs.core.get.call(null,inst_27619,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_27623 = cljs.core.not_empty.call(null,inst_27620__$1);
var state_27657__$1 = (function (){var statearr_27696 = state_27657;
(statearr_27696[(30)] = inst_27622);

(statearr_27696[(29)] = inst_27620__$1);

(statearr_27696[(25)] = inst_27621);

return statearr_27696;
})();
if(cljs.core.truth_(inst_27623)){
var statearr_27697_27790 = state_27657__$1;
(statearr_27697_27790[(1)] = (29));

} else {
var statearr_27698_27791 = state_27657__$1;
(statearr_27698_27791[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (25))){
var inst_27655 = (state_27657[(2)]);
var state_27657__$1 = state_27657;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27657__$1,inst_27655);
} else {
if((state_val_27658 === (34))){
var inst_27622 = (state_27657[(30)]);
var inst_27643 = (state_27657[(2)]);
var inst_27644 = cljs.core.not_empty.call(null,inst_27622);
var state_27657__$1 = (function (){var statearr_27699 = state_27657;
(statearr_27699[(31)] = inst_27643);

return statearr_27699;
})();
if(cljs.core.truth_(inst_27644)){
var statearr_27700_27792 = state_27657__$1;
(statearr_27700_27792[(1)] = (35));

} else {
var statearr_27704_27793 = state_27657__$1;
(statearr_27704_27793[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (17))){
var inst_27580 = (state_27657[(23)]);
var state_27657__$1 = state_27657;
var statearr_27705_27795 = state_27657__$1;
(statearr_27705_27795[(2)] = inst_27580);

(statearr_27705_27795[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (3))){
var state_27657__$1 = state_27657;
var statearr_27706_27797 = state_27657__$1;
(statearr_27706_27797[(2)] = null);

(statearr_27706_27797[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (12))){
var inst_27568 = (state_27657[(2)]);
var state_27657__$1 = state_27657;
var statearr_27707_27798 = state_27657__$1;
(statearr_27707_27798[(2)] = inst_27568);

(statearr_27707_27798[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (2))){
var inst_27530 = (state_27657[(20)]);
var inst_27537 = cljs.core.seq.call(null,inst_27530);
var inst_27538 = inst_27537;
var inst_27539 = null;
var inst_27540 = (0);
var inst_27541 = (0);
var state_27657__$1 = (function (){var statearr_27711 = state_27657;
(statearr_27711[(7)] = inst_27540);

(statearr_27711[(8)] = inst_27541);

(statearr_27711[(9)] = inst_27539);

(statearr_27711[(10)] = inst_27538);

return statearr_27711;
})();
var statearr_27712_27799 = state_27657__$1;
(statearr_27712_27799[(2)] = null);

(statearr_27712_27799[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (23))){
var inst_27587 = (state_27657[(12)]);
var inst_27590 = (state_27657[(13)]);
var inst_27593 = (state_27657[(14)]);
var inst_27613 = (state_27657[(19)]);
var inst_27591 = (state_27657[(15)]);
var inst_27586 = (state_27657[(16)]);
var inst_27609 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_27612 = (function (){var all_files = inst_27586;
var files_SINGLEQUOTE_ = inst_27587;
var res_SINGLEQUOTE_ = inst_27590;
var res = inst_27591;
var files_not_loaded = inst_27593;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_27587,inst_27590,inst_27593,inst_27613,inst_27591,inst_27586,inst_27609,state_val_27658,c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files){
return (function (p__27611){
var map__27713 = p__27611;
var map__27713__$1 = ((cljs.core.seq_QMARK_.call(null,map__27713))?cljs.core.apply.call(null,cljs.core.hash_map,map__27713):map__27713);
var meta_data = cljs.core.get.call(null,map__27713__$1,new cljs.core.Keyword(null,"meta-data","meta-data",-1613399157));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.contains_QMARK_.call(null,meta_data,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
if((cljs.core.contains_QMARK_.call(null,meta_data,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932))) && (cljs.core.not.call(null,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932).cljs$core$IFn$_invoke$arity$1(meta_data)))){
return new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
}
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,files_not_loaded,inst_27587,inst_27590,inst_27593,inst_27613,inst_27591,inst_27586,inst_27609,state_val_27658,c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files))
})();
var inst_27613__$1 = cljs.core.group_by.call(null,inst_27612,inst_27593);
var inst_27614 = cljs.core.seq_QMARK_.call(null,inst_27613__$1);
var state_27657__$1 = (function (){var statearr_27714 = state_27657;
(statearr_27714[(32)] = inst_27609);

(statearr_27714[(19)] = inst_27613__$1);

return statearr_27714;
})();
if(inst_27614){
var statearr_27715_27809 = state_27657__$1;
(statearr_27715_27809[(1)] = (26));

} else {
var statearr_27716_27810 = state_27657__$1;
(statearr_27716_27810[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (35))){
var inst_27622 = (state_27657[(30)]);
var inst_27646 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_27622);
var inst_27647 = cljs.core.pr_str.call(null,inst_27646);
var inst_27648 = [cljs.core.str("not required: "),cljs.core.str(inst_27647)].join('');
var inst_27649 = figwheel.client.utils.log.call(null,inst_27648);
var state_27657__$1 = state_27657;
var statearr_27717_27812 = state_27657__$1;
(statearr_27717_27812[(2)] = inst_27649);

(statearr_27717_27812[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (19))){
var inst_27587 = (state_27657[(12)]);
var inst_27590 = (state_27657[(13)]);
var inst_27591 = (state_27657[(15)]);
var inst_27586 = (state_27657[(16)]);
var inst_27590__$1 = (state_27657[(2)]);
var inst_27591__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_27590__$1);
var inst_27592 = (function (){var all_files = inst_27586;
var files_SINGLEQUOTE_ = inst_27587;
var res_SINGLEQUOTE_ = inst_27590__$1;
var res = inst_27591__$1;
return ((function (all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,inst_27587,inst_27590,inst_27591,inst_27586,inst_27590__$1,inst_27591__$1,state_val_27658,c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files){
return (function (p1__27303_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__27303_SHARP_));
});
;})(all_files,files_SINGLEQUOTE_,res_SINGLEQUOTE_,res,inst_27587,inst_27590,inst_27591,inst_27586,inst_27590__$1,inst_27591__$1,state_val_27658,c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files))
})();
var inst_27593 = cljs.core.filter.call(null,inst_27592,inst_27590__$1);
var inst_27594 = cljs.core.not_empty.call(null,inst_27591__$1);
var state_27657__$1 = (function (){var statearr_27718 = state_27657;
(statearr_27718[(13)] = inst_27590__$1);

(statearr_27718[(14)] = inst_27593);

(statearr_27718[(15)] = inst_27591__$1);

return statearr_27718;
})();
if(cljs.core.truth_(inst_27594)){
var statearr_27719_27818 = state_27657__$1;
(statearr_27719_27818[(1)] = (20));

} else {
var statearr_27720_27819 = state_27657__$1;
(statearr_27720_27819[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (11))){
var state_27657__$1 = state_27657;
var statearr_27721_27820 = state_27657__$1;
(statearr_27721_27820[(2)] = null);

(statearr_27721_27820[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (9))){
var inst_27570 = (state_27657[(2)]);
var state_27657__$1 = state_27657;
var statearr_27722_27821 = state_27657__$1;
(statearr_27722_27821[(2)] = inst_27570);

(statearr_27722_27821[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (5))){
var inst_27540 = (state_27657[(7)]);
var inst_27541 = (state_27657[(8)]);
var inst_27543 = (inst_27541 < inst_27540);
var inst_27544 = inst_27543;
var state_27657__$1 = state_27657;
if(cljs.core.truth_(inst_27544)){
var statearr_27723_27824 = state_27657__$1;
(statearr_27723_27824[(1)] = (7));

} else {
var statearr_27724_27825 = state_27657__$1;
(statearr_27724_27825[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (14))){
var inst_27551 = (state_27657[(27)]);
var inst_27560 = cljs.core.first.call(null,inst_27551);
var inst_27561 = figwheel.client.file_reloading.eval_body.call(null,inst_27560,opts);
var inst_27562 = cljs.core.next.call(null,inst_27551);
var inst_27538 = inst_27562;
var inst_27539 = null;
var inst_27540 = (0);
var inst_27541 = (0);
var state_27657__$1 = (function (){var statearr_27725 = state_27657;
(statearr_27725[(7)] = inst_27540);

(statearr_27725[(33)] = inst_27561);

(statearr_27725[(8)] = inst_27541);

(statearr_27725[(9)] = inst_27539);

(statearr_27725[(10)] = inst_27538);

return statearr_27725;
})();
var statearr_27726_27826 = state_27657__$1;
(statearr_27726_27826[(2)] = null);

(statearr_27726_27826[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (26))){
var inst_27613 = (state_27657[(19)]);
var inst_27616 = cljs.core.apply.call(null,cljs.core.hash_map,inst_27613);
var state_27657__$1 = state_27657;
var statearr_27727_27827 = state_27657__$1;
(statearr_27727_27827[(2)] = inst_27616);

(statearr_27727_27827[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (16))){
var inst_27580 = (state_27657[(23)]);
var inst_27582 = (function (){var all_files = inst_27580;
return ((function (all_files,inst_27580,state_val_27658,c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files){
return (function (p1__27302_SHARP_){
return cljs.core.update_in.call(null,p1__27302_SHARP_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"meta-data","meta-data",-1613399157)], null),cljs.core.dissoc,new cljs.core.Keyword(null,"file-changed-on-disk","file-changed-on-disk",1086171932));
});
;})(all_files,inst_27580,state_val_27658,c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files))
})();
var inst_27583 = cljs.core.map.call(null,inst_27582,inst_27580);
var state_27657__$1 = state_27657;
var statearr_27728_27861 = state_27657__$1;
(statearr_27728_27861[(2)] = inst_27583);

(statearr_27728_27861[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (30))){
var state_27657__$1 = state_27657;
var statearr_27729_27868 = state_27657__$1;
(statearr_27729_27868[(2)] = null);

(statearr_27729_27868[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (10))){
var inst_27551 = (state_27657[(27)]);
var inst_27553 = cljs.core.chunked_seq_QMARK_.call(null,inst_27551);
var state_27657__$1 = state_27657;
if(inst_27553){
var statearr_27730_27872 = state_27657__$1;
(statearr_27730_27872[(1)] = (13));

} else {
var statearr_27731_27873 = state_27657__$1;
(statearr_27731_27873[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (18))){
var inst_27587 = (state_27657[(12)]);
var inst_27586 = (state_27657[(16)]);
var inst_27586__$1 = (state_27657[(2)]);
var inst_27587__$1 = figwheel.client.file_reloading.add_request_urls.call(null,opts,inst_27586__$1);
var inst_27588 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_27587__$1);
var state_27657__$1 = (function (){var statearr_27732 = state_27657;
(statearr_27732[(12)] = inst_27587__$1);

(statearr_27732[(16)] = inst_27586__$1);

return statearr_27732;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27657__$1,(19),inst_27588);
} else {
if((state_val_27658 === (37))){
var inst_27652 = (state_27657[(2)]);
var state_27657__$1 = state_27657;
var statearr_27733_27874 = state_27657__$1;
(statearr_27733_27874[(2)] = inst_27652);

(statearr_27733_27874[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27658 === (8))){
var inst_27551 = (state_27657[(27)]);
var inst_27538 = (state_27657[(10)]);
var inst_27551__$1 = cljs.core.seq.call(null,inst_27538);
var state_27657__$1 = (function (){var statearr_27734 = state_27657;
(statearr_27734[(27)] = inst_27551__$1);

return statearr_27734;
})();
if(inst_27551__$1){
var statearr_27735_27876 = state_27657__$1;
(statearr_27735_27876[(1)] = (10));

} else {
var statearr_27736_27877 = state_27657__$1;
(statearr_27736_27877[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files))
;
return ((function (switch__20318__auto__,c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20319__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20319__auto____0 = (function (){
var statearr_27740 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27740[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__20319__auto__);

(statearr_27740[(1)] = (1));

return statearr_27740;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__20319__auto____1 = (function (state_27657){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_27657);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e27741){if((e27741 instanceof Object)){
var ex__20322__auto__ = e27741;
var statearr_27742_27878 = state_27657;
(statearr_27742_27878[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27657);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27741;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27879 = state_27657;
state_27657 = G__27879;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__20319__auto__ = function(state_27657){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20319__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20319__auto____1.call(this,state_27657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__20319__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__20319__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files))
})();
var state__20382__auto__ = (function (){var statearr_27743 = f__20381__auto__.call(null);
(statearr_27743[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto__);

return statearr_27743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto__,map__27522,map__27522__$1,opts,before_jsload,on_jsload,load_unchanged_files,map__27523,map__27523__$1,msg,files))
);

return c__20380__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__27885,link){
var map__27889 = p__27885;
var map__27889__$1 = ((cljs.core.seq_QMARK_.call(null,map__27889))?cljs.core.apply.call(null,cljs.core.hash_map,map__27889):map__27889);
var file = cljs.core.get.call(null,map__27889__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = link.href;
if(cljs.core.truth_(temp__4425__auto__)){
var link_href = temp__4425__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4425__auto__,map__27889,map__27889__$1,file){
return (function (p1__27883_SHARP_,p2__27884_SHARP_){
if(cljs.core._EQ_.call(null,p1__27883_SHARP_,p2__27884_SHARP_)){
return p1__27883_SHARP_;
} else {
return false;
}
});})(link_href,temp__4425__auto__,map__27889,map__27889__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4425__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__27893){
var map__27894 = p__27893;
var map__27894__$1 = ((cljs.core.seq_QMARK_.call(null,map__27894))?cljs.core.apply.call(null,cljs.core.hash_map,map__27894):map__27894);
var match_length = cljs.core.get.call(null,map__27894__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__27894__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__27890_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__27890_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4425__auto__)){
var res = temp__4425__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(){
var G__27896 = arguments.length;
switch (G__27896) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__27898){
var map__27900 = p__27898;
var map__27900__$1 = ((cljs.core.seq_QMARK_.call(null,map__27900))?cljs.core.apply.call(null,cljs.core.hash_map,map__27900):map__27900);
var f_data = map__27900__$1;
var file = cljs.core.get.call(null,map__27900__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var request_url = cljs.core.get.call(null,map__27900__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var temp__4423__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4423__auto__)){
var link = temp__4423__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return figwheel.client.file_reloading.add_link_to_doc.call(null,figwheel.client.file_reloading.create_link.call(null,(function (){var or__16109__auto__ = request_url;
if(cljs.core.truth_(or__16109__auto__)){
return or__16109__auto__;
} else {
return file;
}
})()));
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__27901,files_msg){
var map__27923 = p__27901;
var map__27923__$1 = ((cljs.core.seq_QMARK_.call(null,map__27923))?cljs.core.apply.call(null,cljs.core.hash_map,map__27923):map__27923);
var opts = map__27923__$1;
var on_cssload = cljs.core.get.call(null,map__27923__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__27924_27948 = cljs.core.seq.call(null,figwheel.client.file_reloading.add_request_urls.call(null,opts,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__27925_27949 = null;
var count__27926_27950 = (0);
var i__27927_27951 = (0);
while(true){
if((i__27927_27951 < count__27926_27950)){
var f_27955 = cljs.core._nth.call(null,chunk__27925_27949,i__27927_27951);
figwheel.client.file_reloading.reload_css_file.call(null,f_27955);

var G__27956 = seq__27924_27948;
var G__27957 = chunk__27925_27949;
var G__27958 = count__27926_27950;
var G__27959 = (i__27927_27951 + (1));
seq__27924_27948 = G__27956;
chunk__27925_27949 = G__27957;
count__27926_27950 = G__27958;
i__27927_27951 = G__27959;
continue;
} else {
var temp__4425__auto___27960 = cljs.core.seq.call(null,seq__27924_27948);
if(temp__4425__auto___27960){
var seq__27924_27961__$1 = temp__4425__auto___27960;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27924_27961__$1)){
var c__16894__auto___27963 = cljs.core.chunk_first.call(null,seq__27924_27961__$1);
var G__27965 = cljs.core.chunk_rest.call(null,seq__27924_27961__$1);
var G__27966 = c__16894__auto___27963;
var G__27967 = cljs.core.count.call(null,c__16894__auto___27963);
var G__27968 = (0);
seq__27924_27948 = G__27965;
chunk__27925_27949 = G__27966;
count__27926_27950 = G__27967;
i__27927_27951 = G__27968;
continue;
} else {
var f_27970 = cljs.core.first.call(null,seq__27924_27961__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_27970);

var G__27971 = cljs.core.next.call(null,seq__27924_27961__$1);
var G__27972 = null;
var G__27973 = (0);
var G__27974 = (0);
seq__27924_27948 = G__27971;
chunk__27925_27949 = G__27972;
count__27926_27950 = G__27973;
i__27927_27951 = G__27974;
continue;
}
} else {
}
}
break;
}

var c__20380__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__20380__auto__,map__27923,map__27923__$1,opts,on_cssload){
return (function (){
var f__20381__auto__ = (function (){var switch__20318__auto__ = ((function (c__20380__auto__,map__27923,map__27923__$1,opts,on_cssload){
return (function (state_27934){
var state_val_27935 = (state_27934[(1)]);
if((state_val_27935 === (1))){
var inst_27928 = cljs.core.async.timeout.call(null,(100));
var state_27934__$1 = state_27934;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27934__$1,(2),inst_27928);
} else {
if((state_val_27935 === (2))){
var inst_27930 = (state_27934[(2)]);
var inst_27931 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg);
var inst_27932 = on_cssload.call(null,inst_27931);
var state_27934__$1 = (function (){var statearr_27936 = state_27934;
(statearr_27936[(7)] = inst_27930);

return statearr_27936;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27934__$1,inst_27932);
} else {
return null;
}
}
});})(c__20380__auto__,map__27923,map__27923__$1,opts,on_cssload))
;
return ((function (switch__20318__auto__,c__20380__auto__,map__27923,map__27923__$1,opts,on_cssload){
return (function() {
var figwheel$client$file_reloading$reload_css_files_$_state_machine__20319__auto__ = null;
var figwheel$client$file_reloading$reload_css_files_$_state_machine__20319__auto____0 = (function (){
var statearr_27940 = [null,null,null,null,null,null,null,null];
(statearr_27940[(0)] = figwheel$client$file_reloading$reload_css_files_$_state_machine__20319__auto__);

(statearr_27940[(1)] = (1));

return statearr_27940;
});
var figwheel$client$file_reloading$reload_css_files_$_state_machine__20319__auto____1 = (function (state_27934){
while(true){
var ret_value__20320__auto__ = (function (){try{while(true){
var result__20321__auto__ = switch__20318__auto__.call(null,state_27934);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20321__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20321__auto__;
}
break;
}
}catch (e27942){if((e27942 instanceof Object)){
var ex__20322__auto__ = e27942;
var statearr_27944_27975 = state_27934;
(statearr_27944_27975[(5)] = ex__20322__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27934);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27942;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20320__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27976 = state_27934;
state_27934 = G__27976;
continue;
} else {
return ret_value__20320__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_css_files_$_state_machine__20319__auto__ = function(state_27934){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_css_files_$_state_machine__20319__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_css_files_$_state_machine__20319__auto____1.call(this,state_27934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_css_files_$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_css_files_$_state_machine__20319__auto____0;
figwheel$client$file_reloading$reload_css_files_$_state_machine__20319__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_css_files_$_state_machine__20319__auto____1;
return figwheel$client$file_reloading$reload_css_files_$_state_machine__20319__auto__;
})()
;})(switch__20318__auto__,c__20380__auto__,map__27923,map__27923__$1,opts,on_cssload))
})();
var state__20382__auto__ = (function (){var statearr_27946 = f__20381__auto__.call(null);
(statearr_27946[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__20380__auto__);

return statearr_27946;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20382__auto__);
});})(c__20380__auto__,map__27923,map__27923__$1,opts,on_cssload))
);

return c__20380__auto__;
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1437410069072