(ns leiningen.new.bframeworkapp
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "bframeworkapp"))

(defn bframeworkapp
  "FIXME: write documentation"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' bframeworkapp project.")
    (->files data
             ["src/{{sanitized}}/conf.cljs" (render "conf.cljs" data)]
             ["src/buyanFramework/interop.cljs" (render "interop.cljs" data)]
             ["src/buyanFramework/logger.cljs" (render "logger.cljs" data)]
             ["src/{{sanitized}}/main.cljs" (render "main.cljs" data)]
             ["src/buyanFramework/pubsub.cljs" (render "pubsub.cljs" data)]
             ["src/buyanFramework/routing.cljs" (render "routing.cljs" data)]
             ["src/buyanFramework/util.clj" (render "util.clj" data)]
             ["project.clj" (render "project.clj" data)]
             
             )))
