(ns buyanFramework.interop
  (:require
    [cljs.core.async :refer [chan close! timeout put!]]
    [buyanFramework.logger :as l]
    [{{name}}.conf]
    )
  (:require-macros [cljs.core.async.macros :as m :refer [go]]
   [buyanFramework.util :as a :refer [fun c debug ac]]
   )
  )

(fun jsinterop [functionToCall & argumentsForJavaScriptFunction]
  "call javascript function that returns promise in sychronous way

  "
  (def temporaryChannelForExternalFunctionResult (chan))
  (.then (apply functionToCall argumentsForJavaScriptFunction)  (fn [& resultsFromFunction]

    (>! temporaryChannelForExternalFunctionResult resultsFromFunction)
    ))
  (<! temporaryChannelForExternalFunctionResult)

  )
