(ns buyanFramework.pubsub
  (:require
    [cljs.core.async :refer [chan close! timeout put!]]
    [buyanFramework.logger :as l]

    [{{name}}.conf]
    )
  (:require-macros [cljs.core.async.macros :as m :refer [go]]
   [buyanFramework.util :as a :refer [fun c debug ac]]
   )
  )
(def pubsubChannel (chan))

(def subscriptions (js-obj))
(defn sub [subscriptionName subscriptionHandler]

  (if (aget subscriptions subscriptionName)
    (aset subscriptions subscriptionName (conj  (aget subscriptions subscriptionName) subscriptionHandler))

    (aset subscriptions subscriptionName  [subscriptionHandler])

    )
  )
(defn trig [subscriptionName message]
  (-> "body"
    (js/$)
    (.trigger subscriptionName message)

    )
  )
(fun pub [subscriptionName message]

 (if  (aget (aget  js/window "messages") subscriptionName )

   (trig subscriptionName message)
   (>! pubsubChannel (js-obj "typ" subscriptionName "msg" message)))

 )
(fun startpubsub []
 (loop []

   (def messageFromPubSub (<! pubsubChannel))

   (loop [col (aget subscriptions (aget messageFromPubSub "typ"))]
     (if col
       ((first col) (aget messageFromPubSub "msg"))

       (def remainingsubs (rest col))

       (if (> (count remainingsubs) 0)
         (recur remainingsubs)
         )
       )
     )
   (recur ))
 )
(defn makeMsg [typ m pchannel]
  (js-obj "typ" typ "msg" m)
  )
(defn getHook [hookType whatHook]
  (if (aget  js/window hookType)
    (if (aget (aget  js/window hookType)  whatFunctionToCall )
      (aget (aget  js/window hookType)  whatFunctionToCall )
      false
      )

    false
    )
  )
(fun functionThatKnowsHowToRouteInSyncWay [channelThatGetsResultOfACall channelThatGetsWhatFunctionToCall & functionName_FunctionPairsFromRouter]


 (if  (getHook "hook" functionName_FunctionPairsFromRouter )
   (do
     ((getHook "hook" functionName_FunctionPairsFromRouter ) msg)
     )

   (do

         ;;loop until all messages have been checked
         ;;similar to the way erlang process checks its mailbox
         (loop []
           (def whatShouldBeTheNextCall (<! channelThatGetsWhatFunctionToCall))
           (if (== (aget whatShouldBeTheNextCall "typ") 0)
             (do
               ;;if we looked at all return 0
               0
               )

             (do

               (if (aget {{name}}.conf.routes (aget whatShouldBeTheNextCall "typ"))
                (do
                  (def fja (aget {{name}}.conf.routes (aget whatShouldBeTheNextCall "typ") ))
                  (def returnValueOfDesiredFunction 
                    (<! (apply 
                      fja
                      (aget  whatShouldBeTheNextCall "msg")))
                    )
                  (>! channelThatGetsResultOfACall returnValueOfDesiredFunction)
                  )
                )
               )
             )
           (recur)))
   ))

(fun functionThatKnowsHowToRouteInAsyncWay [ channelThatGetsWhatFunctionToCall   & functionName_FunctionPairsFromRouter]


 (if  (getHook "hook" functionName_FunctionPairsFromRouter )
   (do
     ((getHook "hook" functionName_FunctionPairsFromRouter ) msg)
     )

   (do

           ;;loop until all messages have been checked
           ;;similar to the way erlang process checks its mailbox
           (loop []
             (def whatShouldBeTheNextCall (<! channelThatGetsWhatFunctionToCall))
             (if (== (aget whatShouldBeTheNextCall "typ") 0)
               (do
                 ;;if we looked at all return 0
                 0
                 )


               (do
                 ;; out of all messages we are waitin for
                 ;; check if the one extracted from "mailbox" is among them
                 ;;
                 (def result (loop [howManyPairsDidWeCheck 0]

                   (if (< howManyPairsDidWeCheck  (count functionName_FunctionPairsFromRouter) )
                     (do
                       (if (== (aget whatShouldBeTheNextCall "typ") (nth functionName_FunctionPairsFromRouter howManyPairsDidWeCheck ))
                         (do
                                       ;;yay we found one now execute the function associated with it
                                       (apply (nth  typ (+ howManyPairsDidWeCheck 1)) (aget  whatShouldBeTheNextCall "msg"))


                                       )
                         )
                       )
                     )
                   ))
                 )
               )
(recur)))
))


(defn kall [whatFunctionToCall & argumentsForFunctionToBeCalledFromBuyan]

  (go

   (if  (getHook "preroutinghook" whatFunctionToCall)
     (do

       (def argumentsForFunctionToBeCalled (js-obj "arr" (apply (aget (aget  js/window "preroutinghook") whatFunctionToCall ) argumentsForFunctionToBeCalledFromBuyan)))

       )
     (def argumentsForFunctionToBeCalled argumentsForFunctionToBeCalledFromBuyan)
     )


   (def channelThatGetsResultOfACall (chan 1))
   (def channelThatGetsWhatFunctionToCall (chan 1))

   (aset channelThatGetsResultOfACall "typ" whatFunctionToCall)
   (>! channelThatGetsWhatFunctionToCall (js-obj "typ" whatFunctionToCall "msg" argumentsForFunctionToBeCalled))

   (buaynFramework.routing.route functionThatKnowsHowToRouteInSyncWay channelThatGetsResultOfACall channelThatGetsWhatFunctionToCall)

   (if  (getHook "postroutinghook" whatFunctionToCall )
     (do
       (<! (l/og :send "done routing12" ((getHook "postroutinghook" whatFunctionToCall )
        (<! channelThatGetsResultOfACall)) ) )


       )

     (<! (l/og :send "done routing2" (<! channelThatGetsResultOfACall)))
     )
   )
)
(fun asyncCall [typ & m]

 (def pchannel (chan 1))
 (def sch (chan 1))

 (aset pchannel "typ" typ)
 (>! sch (js-obj "typ" typ "msg" (if m  (into [] (.-arr m)) [])))
 (routing.route pubsub/functionThatKnowsHowToRouteInAsyncWay pchannel sch)

 )
