(ns blueprints.clj.gml
  (:refer-clojure :exclude [read])
  (:import (com.tinkerpop.blueprints.util.io.gml GMLReader
                                                 GMLWriter))
  (:require [blueprints.clj :as $])
  (:use clojure.template))

;; [Interface]
(defn read ""
  [source {:keys [default-edge-label edge-id-key edge-label-key vertex-id-key]}]
  (let [reader (GMLReader. $/*db*
                           (or default-edge-label
                               GMLReader/DEFAULT_LABEL))]
    (do-template [<val> <method>]
      (when <val> (<method> reader <val>))
      edge-id-key    .setEdgeIdKey
      edge-label-key .setEdgeLabelKey
      vertex-id-key  .setVertexIdKey)
    (.inputGraph reader source))
  nil)

(defn write! ""
  [target {:keys [^String vertex-id-key ^String edge-id-key ^Boolean strict ^Boolean normalize ^Boolean use-id]}]
  (let [writer (GMLWriter. $/*db*)]
    (do-template [<val> <method>]
      (when <val> (<method> writer <val>))
      vertex-id-key .setVertexIdKey
      edge-id-key   .setEdgeIdKey
      strict        .setStrict
      normalize     .setNormalize
      use-id        .setUseId)
    (.outputGraph writer target))
  nil)
