(ns leiningen.new.boot-app
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files sanitize-ns project-name]]
            [leiningen.core.main :as main]))

(def render (renderer "boot-app"))

(defn boot-app
  "Generate a new Clojure project that uses boot."
  [name]
  (let [sanitized-ns (sanitize-ns name)
        data {:raw-name      name
              :name          (project-name name)
              :namespace     sanitized-ns
              :sanitized     (name-to-path sanitized-ns)
              :namespace-set (str "'#{" namespace "}")}]
    (main/info "Generating fresh 'lein new' boot-app project.")
    (->files data
             "resources"
             ["LICENSE" (render "LICENSE" data)]
             ["README.md"  (render "README.md" data)]
             ["build.boot" (render "build.boot" data)]
             ["doc/intro.md" (render "intro.md" data)]
             ["src/{{sanitized}}/core.clj" (render "core.clj" data)]
             ["test/{{sanitized}}/core_test.clj" (render "core_test.clj" data)])))
