/*
 * Decompiled with CFR 0.152.
 */
package boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.projectodd.shimdandy.ClojureRuntimeShim;

public class App {
    private static File[] podjars = null;
    private static File bootdir = null;
    private static File aetherfile = null;
    private static HashMap<String, File[]> depsCache = null;
    private static final String appversion = "2.0.0";
    private static final String apprelease = "r1";
    private static final String depversion = "2.0.0-SNAPSHOT";
    private static final String aetherjar = "aether-2.0.0-SNAPSHOT-standalone.jar";
    public static ClojureRuntimeShim core = null;
    public static ClojureRuntimeShim aether = null;

    public static ClojureRuntimeShim getCore() {
        return core;
    }

    public static ClojureRuntimeShim getAether() {
        return aether;
    }

    public static File getBootDir() {
        return bootdir;
    }

    public static String getVersion() {
        return appversion;
    }

    public static String getRelease() {
        return apprelease;
    }

    private static FileLock getLock(File f) throws Exception {
        File lockfile = new File(f.getPath() + ".lock");
        return new RandomAccessFile(lockfile, "rw").getChannel().lock();
    }

    public static HashMap<String, File[]> seedCache(ClojureRuntimeShim a) throws Exception {
        if (depsCache != null) {
            return depsCache;
        }
        if (a == null) {
            App.ensureResourceFile(aetherjar, aetherfile);
            a = App.newShim(new File[]{aetherfile});
        }
        HashMap<String, File[]> cache = new HashMap<String, File[]>();
        cache.put("boot/pod", App.getDeps(a, "boot/pod"));
        cache.put("boot/core", App.getDeps(a, "boot/core"));
        cache.put("boot/aether", App.getDeps(a, "boot/aether"));
        depsCache = cache;
        return depsCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCache(File f, Object m) throws Exception {
        FileLock lock = App.getLock(f);
        FileOutputStream file = new FileOutputStream(f);
        try {
            new ObjectOutputStream(file).writeObject(m);
        }
        finally {
            file.close();
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readCache(File f) throws Exception {
        FileLock lock = App.getLock(f);
        try {
            long max = 64800000L;
            long age = System.currentTimeMillis() - f.lastModified();
            if (age > max) {
                throw new Exception("cache age exceeds TTL");
            }
            Object object = new ObjectInputStream(new FileInputStream(f)).readObject();
            return object;
        }
        catch (Throwable e) {
            HashMap<String, File[]> hashMap = App.seedCache(null);
            return hashMap;
        }
        finally {
            lock.release();
        }
    }

    public static ClojureRuntimeShim newShim(File[] jarFiles) throws Exception {
        URL[] urls = new URL[jarFiles.length];
        for (int i = 0; i < jarFiles.length; ++i) {
            urls[i] = jarFiles[i].toURI().toURL();
        }
        URLClassLoader cl = new URLClassLoader(urls, App.class.getClassLoader());
        ClojureRuntimeShim rt = ClojureRuntimeShim.newRuntime((ClassLoader)cl);
        rt.require(new String[]{"boot.pod"});
        rt.invoke("boot.pod/seal-app-classloader");
        return rt;
    }

    public static ClojureRuntimeShim newPod() throws Exception {
        return App.newShim(podjars);
    }

    public static ClojureRuntimeShim newPod(File[] jarFiles) throws Exception {
        int i;
        File[] files = new File[jarFiles.length + podjars.length];
        for (i = 0; i < podjars.length; ++i) {
            files[i] = podjars[i];
        }
        for (i = 0; i < jarFiles.length; ++i) {
            files[i + App.podjars.length] = jarFiles[i];
        }
        return App.newShim(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractResource(String resource, File outfile) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream in = cl.getResourceAsStream(resource);
        FileOutputStream out = new FileOutputStream(outfile);
        int n = 0;
        byte[] buf = new byte[4096];
        try {
            while ((n = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, n);
            }
        }
        finally {
            in.close();
            ((OutputStream)out).close();
        }
    }

    public static void ensureResourceFile(String r, File f) throws Exception {
        if (!f.exists()) {
            App.extractResource(r, f);
        }
    }

    public static File[] getDeps(ClojureRuntimeShim shim, String sym) {
        shim.require(new String[]{"boot.aether"});
        return (File[])shim.invoke("boot.aether/resolve-dependency-jars", (Object)sym, (Object)depversion);
    }

    public static void main(String[] args) throws Exception {
        File homedir = new File(System.getProperty("user.home"));
        bootdir = new File(homedir, ".boot");
        File jardir = new File(new File(bootdir, "lib"), apprelease);
        aetherfile = new File(jardir, aetherjar);
        File cachedir = new File(new File(bootdir, "cache"), apprelease);
        final File cachefile = new File(cachedir, "deps.cache");
        jardir.mkdirs();
        cachedir.mkdirs();
        final HashMap cache = (HashMap)App.readCache(cachefile);
        podjars = (File[])cache.get("boot/pod");
        final ExecutorService ex = Executors.newCachedThreadPool();
        final Future f1 = ex.submit(new Callable(){

            public Object call() throws Exception {
                return App.newShim((File[])cache.get("boot/aether"));
            }
        });
        Future f2 = ex.submit(new Callable(){

            public Object call() throws Exception {
                return App.newShim((File[])cache.get("boot/core"));
            }
        });
        Future f3 = ex.submit(new Callable(){

            public Object call() throws Exception {
                App.writeCache(cachefile, App.seedCache((ClojureRuntimeShim)f1.get()));
                return null;
            }
        });
        Thread shutdown = new Thread(){

            @Override
            public void run() {
                ex.shutdown();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdown);
        aether = (ClojureRuntimeShim)f1.get();
        core = (ClojureRuntimeShim)f2.get();
        core.require(new String[]{"boot.main"});
        core.invoke("boot.main/-main", (Object)args);
        System.exit(0);
    }
}

