/*
 * Decompiled with CFR 0.152.
 */
package com4j.tlbimp.driver;

import com4j.tlbimp.BindingException;
import com4j.tlbimp.CodeWriter;
import com4j.tlbimp.ErrorListener;
import com4j.tlbimp.FileCodeWriter;
import com4j.tlbimp.def.IWTypeLib;
import com4j.tlbimp.driver.Driver;
import com4j.tlbimp.driver.Lib;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class Com4jgenMojo
extends AbstractMojo
implements ErrorListener {
    private Config cfg;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Starting Com4jMojo for: " + this.cfg.file));
        this.checkEnv();
        this.validate();
        Driver driver = new Driver();
        Lib lib = new Lib();
        if (this.cfg.libId != null) {
            lib.setLibid(this.cfg.libId);
            if (this.cfg.libVer != null) {
                lib.setLibver(this.cfg.libVer);
            }
        } else {
            lib.setFile(this.cfg.file);
        }
        lib.setPackage(this.cfg._package);
        try {
            lib.validate();
            this.getLog().info((CharSequence)("Generating COM for LIBID: " + lib.getLibid() + " found here: " + lib.getFile()));
            driver.addLib(lib);
            driver.run((CodeWriter)new FileCodeWriter(this.cfg.outputDirectory), (ErrorListener)this);
        }
        catch (NullPointerException npe) {
            this.getLog().warn((CharSequence)"Com4j had an NPE error while running. This usually happens when it can't create an interface. You many need to manually touch the files before trying to compile them.");
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Com4j had an error while running: \n" + e.getMessage()));
            throw new MojoExecutionException(e.getMessage());
        }
        this.getLog().debug((CharSequence)"adding generated files to Maven compile source");
        this.project.addCompileSourceRoot(this.cfg.outputDirectory.getAbsolutePath());
        this.getLog().debug((CharSequence)("Finished Com4jMojo for: " + this.cfg.file));
    }

    private void checkEnv() throws MojoExecutionException {
        String osName = System.getProperty("os.name");
        if (!osName.startsWith("Windows")) {
            this.getLog().warn((CharSequence)("Wrong OS: " + osName));
            throw new MojoExecutionException("Com4j can only be run on a Windows operating system, and you're running: " + osName);
        }
        if (!this.cfg.outputDirectory.exists() && !this.cfg.outputDirectory.mkdirs()) {
            this.getLog().warn((CharSequence)"outputDirectory couldn't be created");
            throw new MojoExecutionException("The output directory " + this.cfg.outputDirectory + " doesn't exist and couldn't be created.");
        }
    }

    private void validate() throws MojoExecutionException {
        if (this.cfg.file == null && this.cfg.libId == null || this.cfg.file != null && this.cfg.libId != null) {
            this.getLog().warn((CharSequence)"You specified <file> and <libId>.  The <libId> always wins.");
        }
        if (this.cfg.file != null && !this.cfg.file.exists()) {
            this.getLog().warn((CharSequence)("Can't find file: " + this.cfg.file));
            throw new MojoExecutionException("The native COM target file couldn't be found: " + this.cfg.file);
        }
    }

    public void started(IWTypeLib lib) {
        this.getLog().info((CharSequence)("Generating definitions from " + lib.getName()));
    }

    public void error(BindingException e) {
        this.getLog().error((CharSequence)e.getMessage());
    }

    public void warning(String message) {
        this.getLog().warn((CharSequence)message);
    }

    public class Config {
        private String _package;
        private File outputDirectory;
        private File file;
        private String libId;
        private String libVer;
    }
}

