# No assertion warnings. Naw!

[![Clojars Project](https://img.shields.io/clojars/v/borkdude/naw.svg)](https://clojars.org/borkdude/naw)
[![cljdoc badge](https://cljdoc.org/badge/borkdude/naw)](https://cljdoc.org/d/borkdude/naw/CURRENT)

Library for checking absence of assertions in
[clojure.test](https://clojure.github.io/clojure/clojure.test-api.html) tests.

## Usage

Require `naw.core` in your test namespace(s).

Note that in `a-test` no assertions are being made, but `another-test` has one
assertion. So we expect a warning only about `a-test`.

``` clojure
(ns foo.core-test
  (:require [clojure.test :refer [deftest testing is]]
            [naw.core]))

(deftest a-test
  (testing "..."
    1))

(deftest another-test
  (testing (is 1)))
```

When executing the tests, the following warning will get printed to `*err*`:

``` clojure
WARNING: no assertions made in test a-test!
```

## License

Copyright © 2019 Michiel Borkent

Distributed under the EPL License. See LICENSE.
