/*
 * Decompiled with CFR 0.152.
 */
package br.com.gencrawler.crawler.core;

import br.com.gencrawler.CommonLinks;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;

public final class AjaxCollector {
    private List<String> items = List.of();
    private Set<String> urlsOfThisSite = Set.of();
    private String url;
    private String find;
    private String match;
    private final WebDriver driver = new ChromeDriver();

    public AjaxCollector() {
    }

    public AjaxCollector(String url, String find, String match) {
        this.url = url;
        this.find = find;
        this.match = match;
    }

    public void openBrowser(int await) {
        this.driver.manage().timeouts().implicitlyWait((long)await, TimeUnit.SECONDS);
    }

    public void closeBrowser() {
        this.driver.close();
    }

    public void runBrowser() {
        List elements;
        if (this.url == null || this.find == null || this.match == null || this.url.isBlank() || this.find.isBlank() || this.match.isBlank()) {
            throw new RuntimeException("Peat all data");
        }
        this.driver.get(this.url);
        if (this.match.toLowerCase().contains("class")) {
            elements = this.driver.findElements(By.className((String)this.find));
        } else if (this.match.toLowerCase().contains("id")) {
            elements = this.driver.findElements(By.id((String)this.find));
        } else {
            throw new RuntimeException("Invalid match error");
        }
        this.items = elements.stream().map(element -> element.getText()).collect(Collectors.toList());
        String baseUrl = CommonLinks.baseUrl(this.driver.getCurrentUrl());
        this.urlsOfThisSite = this.driver.findElements(By.tagName((String)"a")).parallelStream().map(element -> element.getAttribute("href")).filter(uri -> CommonLinks.is(baseUrl, uri)).collect(Collectors.toSet());
    }

    public final void set(String find, String match, String url) {
        this.find = find;
        this.match = match;
        this.url = url;
    }

    public final void run() {
        this.openBrowser(2);
        this.runBrowser();
        this.closeBrowser();
    }

    public final void run(String find, String match, String url) {
        this.find = find;
        this.match = match;
        this.url = url;
        this.run();
    }

    public List<String> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public Set<String> getURLs() {
        return Collections.unmodifiableSet(this.urlsOfThisSite);
    }

    public void clearItems() {
        this.items.clear();
    }
}

