/*
 * Decompiled with CFR 0.152.
 */
package br.com.gencrawler.crawler.core;

import br.com.gencrawler.CommonLinks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;

public final class AjaxCollector {
    private List<String> items = new ArrayList<String>();
    private Set<String> urlsOfThisSite = new HashSet<String>();
    private String url;
    private String selector;
    private String match;
    private final WebDriver driver = new ChromeDriver();

    public AjaxCollector() {
    }

    public AjaxCollector(String url, String selector, String match) {
        this.url = url;
        this.selector = selector;
        this.match = match;
    }

    public void openBrowser(int await) {
        this.driver.manage().timeouts().implicitlyWait((long)await, TimeUnit.SECONDS);
    }

    public void closeBrowser() {
        this.driver.close();
    }

    public void runBrowser() {
        if (this.url == null || this.selector == null || this.match == null || this.url.isBlank() || this.selector.isBlank() || this.match.isBlank()) {
            this.driver.close();
            throw new RuntimeException("Peat all data");
        }
        this.driver.get(this.url);
        List elements = this.driver.findElements(By.cssSelector((String)this.selector));
        this.items = elements.stream().map(element -> element.getText()).filter(element -> element.matches(this.match)).collect(Collectors.toList());
        String baseUrl = CommonLinks.baseUrl(this.driver.getCurrentUrl());
        this.urlsOfThisSite = this.driver.findElements(By.tagName((String)"a")).parallelStream().map(element -> element.getAttribute("href")).filter(uri -> CommonLinks.is(baseUrl, uri)).collect(Collectors.toSet());
    }

    public final void set(String selector, String match, String url) {
        this.selector = selector;
        this.match = match;
        this.url = url;
    }

    public final void run() {
        this.openBrowser(2);
        this.runBrowser();
        this.closeBrowser();
    }

    public final void run(String selector, String match, String url) {
        this.selector = selector;
        this.match = match;
        this.url = url;
        this.run();
    }

    public List<String> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public Set<String> getURLs() {
        return Collections.unmodifiableSet(this.urlsOfThisSite);
    }

    public void clearItems() {
        this.items.clear();
        this.urlsOfThisSite.clear();
    }
}

