/*
 * Decompiled with CFR 0.152.
 */
package br.com.gencrawler.crawler.core;

import br.com.gencrawler.CommonLinks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public final class SimpleCollector {
    private final List<String> items;
    private Set<String> urlsOfThisSite = Set.of();
    private String url;
    private String selector;
    private String match;

    public SimpleCollector() {
        this.items = new ArrayList<String>();
    }

    public SimpleCollector(String url, String selector, String match) {
        this.items = new ArrayList<String>();
        this.url = url;
        this.selector = selector;
        this.match = match;
    }

    public void verify() {
        if (this.url == null || this.selector == null || this.match == null || this.url.isBlank() || this.selector.isBlank() || this.match.isBlank()) {
            throw new RuntimeException("Peat all data");
        }
    }

    public final void run() {
        Document document;
        this.verify();
        try {
            document = Jsoup.connect((String)this.url).get();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            throw new RuntimeException(e);
        }
        Elements itemsLinks = document.select(this.selector);
        document.outerHtml();
        for (Element item2 : itemsLinks) {
            if (!item2.text().matches(this.match)) continue;
            this.items.add(item2.text());
            this.items.add(item2.attr("abs:href"));
        }
        String fullUrl = document.baseUri();
        String baseUrl = CommonLinks.baseUrl(fullUrl);
        Elements newLinks = document.select("a");
        this.urlsOfThisSite = newLinks.parallelStream().map(item -> item.attr("abs:href")).filter(uri -> CommonLinks.is(baseUrl, uri)).collect(Collectors.toSet());
    }

    public List<String> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public Set<String> getURLs() {
        return Collections.unmodifiableSet(this.urlsOfThisSite);
    }
}

