/*
 * Decompiled with CFR 0.152.
 */
package br.com.gencrawler.crawler.core;

import br.com.gencrawler.crawler.core.Collector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;

public final class AjaxCollector
implements Collector {
    private final List<String> items;
    private String url;
    private String find;
    private String match;
    private final WebDriver driver;

    public AjaxCollector() {
        this.items = new ArrayList<String>();
        this.driver = new FirefoxDriver();
    }

    public AjaxCollector(WebDriver driver) {
        this.items = new ArrayList<String>();
        this.driver = driver;
    }

    public AjaxCollector(List<String> items) {
        this.items = items;
        this.driver = new FirefoxDriver();
    }

    public AjaxCollector(String ... filds) {
        this.items = new ArrayList<String>();
        this.driver = new FirefoxDriver();
        this.url = filds[0];
        this.find = filds[1];
        this.match = filds[2];
    }

    public void openBrowser() {
        if (this.url == null || this.find == null || this.match == null || this.url.equals("") || this.find.equals("") || this.match.equals("")) {
            throw new RuntimeException("Peat all data");
        }
        this.driver.get(this.url);
    }

    public void closeBrowser() {
        this.driver.close();
    }

    public void runBrowser() {
        List elements;
        this.driver.manage().timeouts().implicitlyWait(2L, TimeUnit.SECONDS);
        if (this.match.toLowerCase().equals("class")) {
            elements = this.driver.findElements(By.className((String)this.find));
        } else if (this.match.toLowerCase().equals("id")) {
            elements = this.driver.findElements(By.id((String)this.find));
        } else {
            throw new RuntimeException("Invalid match error");
        }
        elements.forEach(element -> {
            boolean bl = this.items.add(element.getText());
        });
    }

    @Override
    public final void runItem() {
        this.openBrowser();
        this.runBrowser();
        this.closeBrowser();
    }

    @Override
    public final void runItem(String ... filds) {
        this.find = filds[0];
        this.match = filds[1];
        this.url = filds[2];
        this.runItem();
    }

    public final void writeToConsole() {
        this.items.parallelStream().forEach(a -> {
            System.out.println("----");
            System.out.println((String)a);
        });
    }

    @Override
    public void run() {
        this.runItem();
    }

    @Override
    public List<String> getItems() {
        return Collections.unmodifiableList(this.items);
    }
}

