/*
 * Decompiled with CFR 0.152.
 */
package br.com.gencrawler.crawler.core;

import br.com.gencrawler.crawler.core.Collector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public final class SimpleCollector
implements Collector {
    private final List<String> items;
    private String url;
    private String find;
    private String match;

    public SimpleCollector() {
        this.items = new ArrayList<String>();
    }

    public SimpleCollector(List<String> items) {
        this.items = items;
    }

    public SimpleCollector(String url, String find, String match) {
        this.items = new ArrayList<String>();
        this.url = url;
        this.find = find;
        this.match = match;
    }

    @Deprecated
    public SimpleCollector(String ... filds) {
        this.items = new ArrayList<String>();
        this.url = filds[0];
        this.find = filds[1];
        this.match = filds[2];
    }

    public void verify() {
        if (this.url == null || this.find == null || this.match == null || this.url.equals("") || this.find.equals("") || this.match.equals("")) {
            throw new RuntimeException("Peat all data");
        }
    }

    @Override
    public final void runItem() {
        this.verify();
        try {
            Document document = Jsoup.connect((String)this.url).get();
            Elements itemsLinks = document.select(this.find);
            for (Element item : itemsLinks) {
                if (!item.text().matches(this.match)) continue;
                System.out.println(item.attr("abs:href"));
                this.items.add(item.text());
                this.items.add(item.attr("abs:href"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("No expected error - " + e.getMessage(), e);
        }
    }

    @Override
    public final void runItem(String ... filds) {
        this.find = filds[0];
        this.match = filds[1];
        this.url = filds[2];
        this.runItem();
    }

    public final void writeToConsole() {
        this.items.parallelStream().forEach(a -> {
            System.out.println("----");
            System.out.println((String)a);
        });
    }

    @Override
    public void run() {
        this.runItem();
    }

    @Override
    public List<String> getItems() {
        return Collections.unmodifiableList(this.items);
    }
}

