/*
 * Decompiled with CFR 0.152.
 */
package br.com.gencrawler.crawler.core;

import br.com.gencrawler.crawler.core.Crawler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public final class SimpleExtractor
implements Crawler {
    private final Set<String> links;
    private final List<List<String>> items;
    private String url;
    private String paginator;
    private String linkFinded;
    private String match;

    public SimpleExtractor() {
        this.links = new HashSet<String>();
        this.items = new ArrayList<List<String>>();
    }

    public SimpleExtractor(Set<String> links, List<List<String>> products) {
        this.links = links;
        this.items = products;
    }

    public SimpleExtractor(String url, String paginator, String linkFinded, String match) {
        this.links = new HashSet<String>();
        this.items = new ArrayList<List<String>>();
        this.url = url;
        this.paginator = paginator;
        this.linkFinded = linkFinded;
        this.match = match;
    }

    @Deprecated
    public SimpleExtractor(String ... filds) {
        this.links = new HashSet<String>();
        this.items = new ArrayList<List<String>>();
        this.url = filds[0];
        this.paginator = filds[1];
        this.linkFinded = filds[2];
        this.match = filds[3];
    }

    public void verify() {
        if (this.url == null || this.paginator == null || this.linkFinded == null || this.match == null || this.url.equals("") || this.paginator.equals("") || this.linkFinded.equals("") || this.match.equals("")) {
            throw new RuntimeException("Peat all data");
        }
    }

    public final void runPagesLinks() {
        if (!this.links.contains(this.url)) {
            try {
                Document document = Jsoup.connect((String)this.url).timeout(120000).get();
                Elements otherLinks = document.select(this.paginator);
                for (Element page : otherLinks) {
                    this.links.add(this.url);
                    this.runPagesLinks(page.attr("abs:href"), this.paginator);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Exception e) {
                throw new RuntimeException("No expected error - " + e.getMessage(), e);
            }
        }
    }

    public final void runPagesLinks(String URL2, String paginator) {
        this.url = URL2;
        this.paginator = paginator;
        this.runPagesLinks();
    }

    @Override
    public final void runItem() {
        this.verify();
        this.links.parallelStream().forEach(x -> {
            try {
                Document document = Jsoup.connect((String)x).get();
                Elements itemsLinks = document.select(this.linkFinded);
                for (Element item : itemsLinks) {
                    if (!item.text().matches(this.match)) continue;
                    ArrayList<String> temporary = new ArrayList<String>();
                    temporary.add(item.text());
                    temporary.add(item.attr("abs:href"));
                    this.items.add(temporary);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Exception e) {
                throw new RuntimeException("No expected error - " + e.getMessage(), e);
            }
        });
    }

    @Override
    public final void runItem(String ... filds) {
        this.url = filds[2];
        this.linkFinded = filds[0];
        this.match = filds[1];
        this.runItem();
    }

    public final void writeToConsole() {
        this.items.parallelStream().forEach(a -> {
            System.out.println("----");
            a.forEach(query -> System.out.println((String)query));
        });
    }

    @Override
    public void run() {
        this.runPagesLinks();
        this.runItem();
    }

    public Set<String> getLinks() {
        return Collections.unmodifiableSet(this.links);
    }

    public List<List<String>> getItems() {
        return Collections.unmodifiableList(this.items);
    }
}

