/*
 * Decompiled with CFR 0.152.
 */
package br.com.gencrawler.crawler.parallelbuild;

import br.com.gencrawler.crawler.core.AjaxCollector;
import br.com.gencrawler.crawler.core.Crawler;
import br.com.gencrawler.crawler.parallelbuild.ParallelCollectorsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ParallelAjaxCollectorsBuilder
implements ParallelCollectorsBuilder {
    private final List<AjaxCollector> crawlers = new ArrayList<AjaxCollector>();
    private final List<String> url = new ArrayList<String>();
    private final List<String> finderProducts = new ArrayList<String>();
    private final List<String> matchs = new ArrayList<String>();

    @Override
    public ParallelAjaxCollectorsBuilder addAllUrl(List<String> pages) {
        this.url.addAll(pages);
        return this;
    }

    @Override
    public ParallelAjaxCollectorsBuilder addUrl(String page) {
        this.url.add(page);
        return this;
    }

    @Override
    public ParallelAjaxCollectorsBuilder addAllFinder(List<String> products) {
        this.finderProducts.addAll(products);
        return this;
    }

    @Override
    public ParallelAjaxCollectorsBuilder addFinder(String product) {
        this.finderProducts.add(product);
        return this;
    }

    @Override
    public ParallelAjaxCollectorsBuilder addAllMatchs(List<String> matchs) {
        this.matchs.addAll(matchs);
        return this;
    }

    @Override
    public ParallelAjaxCollectorsBuilder addMatch(String match) {
        this.matchs.add(match);
        return this;
    }

    @Override
    public void verify() {
        if (this.url.isEmpty() || this.finderProducts.isEmpty() || this.matchs.isEmpty()) {
            throw new RuntimeException("Peat all data");
        }
        if (this.url.size() != this.finderProducts.size() || this.url.size() != this.matchs.size()) {
            throw new RuntimeException("The amount of data is not known");
        }
    }

    @Override
    public <T extends Crawler> List<T> build() {
        this.verify();
        ExecutorService executor = Executors.newCachedThreadPool();
        for (int i = 0; i < this.url.size(); ++i) {
            this.crawlers.add(new AjaxCollector(this.url.get(i), this.finderProducts.get(i), this.matchs.get(i)));
            executor.submit(this.crawlers.get(i));
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        return this.crawlers;
    }
}

