/*
 * Decompiled with CFR 0.152.
 */
package br.com.gencrawler.crawler.parallelbuild;

import br.com.gencrawler.crawler.core.Crawler;
import br.com.gencrawler.crawler.core.SimpleExtractor;
import br.com.gencrawler.crawler.parallelbuild.ParallelCrawlerBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ParallelSimpleExtractorsBuilder
implements ParallelCrawlerBuilder {
    private final List<SimpleExtractor> crawlers = new ArrayList<SimpleExtractor>();
    private final List<String> url = new ArrayList<String>();
    private final List<String> paginators = new ArrayList<String>();
    private final List<String> finderProducts = new ArrayList<String>();
    private final List<String> matchs = new ArrayList<String>();

    @Override
    public ParallelSimpleExtractorsBuilder addAllUrl(List<String> pages) {
        this.url.addAll(pages);
        return this;
    }

    @Override
    public ParallelSimpleExtractorsBuilder addUrl(String page) {
        this.url.add(page);
        return this;
    }

    public ParallelSimpleExtractorsBuilder addAllPaginators(List<String> paginators) {
        this.paginators.addAll(paginators);
        return this;
    }

    public ParallelSimpleExtractorsBuilder addPaginator(String paginator) {
        this.paginators.add(paginator);
        return this;
    }

    @Override
    public ParallelSimpleExtractorsBuilder addAllFinder(List<String> products) {
        this.finderProducts.addAll(products);
        return this;
    }

    @Override
    public ParallelSimpleExtractorsBuilder addFinder(String product) {
        this.finderProducts.add(product);
        return this;
    }

    @Override
    public ParallelSimpleExtractorsBuilder addAllMatchs(List<String> matchs) {
        this.matchs.addAll(matchs);
        return this;
    }

    @Override
    public ParallelSimpleExtractorsBuilder addMatch(String match) {
        this.matchs.add(match);
        return this;
    }

    @Override
    public void verify() {
        if (this.url.isEmpty() || this.paginators.isEmpty() || this.finderProducts.isEmpty() || this.matchs.isEmpty()) {
            throw new RuntimeException("Peat all data");
        }
        if (this.url.size() != this.paginators.size() || this.url.size() != this.finderProducts.size() || this.url.size() != this.matchs.size()) {
            throw new RuntimeException("The amount of data is not known");
        }
    }

    @Override
    public <T extends Crawler> List<T> build() {
        this.verify();
        ExecutorService executor = Executors.newCachedThreadPool();
        for (int i = 0; i < this.url.size(); ++i) {
            this.crawlers.add(new SimpleExtractor(this.url.get(i), this.paginators.get(i), this.finderProducts.get(i), this.matchs.get(i)));
            executor.submit(this.crawlers.get(i));
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        return this.crawlers;
    }
}

