(ns plinth.db.postgres
  (:require
    [cheshire.core :as json]
    [clojure.java.jdbc :as jdbc])
  (:import
    [org.postgresql.util PGobject]
    [org.postgis PGgeometry Point Geometry]))

(extend-protocol clojure.java.jdbc/ISQLParameter
  clojure.lang.IPersistentMap
  (set-parameter [value statement idx]
    (doto (PGobject.)
      (.setType "json")
      (.setValue (json/generate-string value)))))

(defn- to-geojson [geometry]
  (condp = (.getType geometry)
    Geometry/POINT
      (let [point (.getPoint geometry 0)]
        {:type "Point" :coordinates [(.x point) (.y point)]})
    nil))

(extend-protocol clojure.java.jdbc/IResultSetReadColumn
  PGobject
  (result-set-read-column [object metadata idx]
    (case (.getType object)
      "json" (json/parse-string (.getValue object) true)
      "geography" (to-geojson (.getGeometry (PGgeometry. (.getValue object))))
      (.getValue object))))
