(ns plinth.queue.immutant
  (:require
    [plinth.queue :as q]
    [immutant.messaging :as m]
    [com.stuartsierra.component :as component]))

(defrecord ImmutantQueue []
  component/Lifecycle
  (start [this] this)
  (stop [this] this)

  q/Queue
  (send! [queue-name msg]
    (m/publish (m/queue queue-name) msg))
  (receive! [queue-name timeout timeout-val]
    (m/receive (m/queue queue-name) {:timeout timeout :timeout-val timeout-val}))
  (listen! [queue-name f]
    (m/listen (m/queue queue-name) f))
  (unlisten! [listener]
    (m/stop listener))

  q/PubSub
  (publish! [topic-name msg]
    (m/publish (m/topic topic-name) msg))
  (subscribe! [topic-name subscriber-id f]
    { :topic-name topic-name
      :subscriber-id subscriber-id
      :listener
      (if subscriber-id
        (m/subscribe (m/topic topic-name) subscriber-id f)
        (m/listen (m/topic topic-name) f)) })
  (unsubscribe! [topic-name subscriber]
    (m/stop (:listener subscriber))
    (when (:subscriber-id subscriber)
      (m/unsubscribe (m/topic (:topic-name subscriber)) (:subscriber-id subscriber)))))
