(ns plinth.scheduler.immutant
  (:require
    [plinth.scheduler :as scheduler]
    [immutant.scheduling :as s]
    [com.stuartsierra.component :as component]))

(defrecord ImmutantScheduler []
  component/Lifecycle
  (start [this] this)
  (stop [this] (do (s/stop) this))

  scheduler/JobScheduler
  (schedule-job! [id f params]
    (s/schedule f (assoc params :id id)))
  (stop-job! [id] (s/stop {:id id})))
