(ns plinth.query
  (:require
    [plinth.db :as db]
    [plinth.schema :as schema]
    [plinth.schema.coerce :as c]
    [plinth.schema.prismatic :as p]
    [io.clojure.liberator-transit]
    [clojure.tools.logging :as log]
    [liberator.core :refer [defresource]]
    [com.stuartsierra.component :as component]))

;; can do the same for wrapping a table...would need authorization support here as well

(defresource query [database fragment schema authorization allowed?]
  :allowed-methods [:get]

  :available-media-types
  [ "application/json"
    "application/edn"
    "application/transit+json"
    "text/csv"
    "text/tab-separated-values"
    "text/html"
    "text/plain" ]

  :allowed?
  (fn [{:keys [auth-token] :as context}]
    (if allowed?
      (allowed? auth-token)
      true))

  :authorized?
  (fn [{:keys [request] :as context}]
    (if authorization
      (if-let [token (authorization request)]
        [true {:auth-token token}]
        false)
      true))

  :malformed?
  (fn [context]
    (let [params (c/coerce schema (select-keys (get-in context [:request :params]) (keys schema)))]
      [(not (p/valid? schema params)) {:params params}]))

  ; :last-modified ?

  :handle-ok
  (fn [{:keys [params] :as context}]
    (db/query database {:sql (:sql fragment) :parameters (mapv #(get params %) (:parameters fragment))})))
