(ns plinth.access
  (:require
    [plinth.schema :as s]))

;; really, this should be a key broker like vault
;; for an api key, give specific grants (role = set of specific grants)

;; https://www.getdonedone.com/building-the-optimal-user-database-model-for-your-application/

; https://flask-login.readthedocs.org/en/latest/#configuring-your-application
(def AccessTokenSchema
  (s/table :access-tokens :token
    { :token (assoc s/Str :required true :unique true)
      :user-id s/Str
      :created-at s/Timestamp
      :expires-at s/Timestamp
      :hard-timeout s/Timestamp
      :inactive-timeout s/Timestamp ;; different than hard timeout?
      ; :grants Set of allowed actions
      ; :ephemeral-cookie s/Bool
      :revoked s/Bool
    }))
