(ns plinth.cache.memcache
  (:require
    [plinth.cache :as cache]
    [taoensso.nippy :as nippy]
    [clojure.tools.logging :as log]
    [clojurewerkz.spyglass.client :as spy]
    [com.stuartsierra.component :as component]))

(defrecord Memcache [hosts]
  component/Lifecycle
  (start [this]
    (let [client (and hosts (spy/bin-connection hosts))]
      (assoc this :client client)))
  (stop [this]
    (when (:client this)
      (spy/shutdown (:client this)))
    (dissoc this :client))

  cache/Cache
  (-fetch [mc key]
    (try
      (when mc
        (when-let [item (spy/get (:client mc) (pr-str key))]
          (nippy/thaw item)))
      (catch Exception e
        (log/warn e "Exception calling Spyglass/get with key" key)
        (throw e))))
  (-put [mc key value expires]
    (try
      (when mc
        (spy/set (:client mc) (pr-str key) (or expires 0) (nippy/freeze value)))
      (catch Exception e
        (log/warn e "Exception calling Spyglass/set with key" key "value" value)
        (throw e))))
  (-delete [mc key]
    (try
      (when mc
        @(spy/delete (:client mc) (pr-str key)))
      (catch Exception e
        (log/warn e "Exception calling Spyglass/delete with key" key)
        (throw e)))))
