(ns plinth.boot-hot-reload
  {:boot/export-tasks true}
  (:require
    [boot.core :as boot]
    ; [clojure.repl :refer :all]
    [ns-tracker.core :as tracker]
    [clojure.tools.logging :as log]
    [clojure.tools.namespace.repl :as repl]))

(def ^:private ns-watcher nil)

(defn- ns-reload [track]
  (doseq [ns-sym (track)]
    (try
      (require ns-sym :reload)
      (catch Throwable e
        (println (char 7))
        (log/warn e "Error reloading namespace" ns-sym)))))

(defn- make-watcher
  "Watches a list of directories for file changes, reloading them as necessary."
  [src-paths]
  (let [done? (atom false)
        track (tracker/ns-tracker src-paths)]
    (doto
      (Thread.
        (fn []
          (while (not @done?)
            (ns-reload track)
            (Thread/sleep 2000))))
      (.setDaemon true)
      (.start))
    (fn [] (swap! done? not))))

(boot/deftask hot-reload
  "Reload changed files in the background"
  []
  (boot/merge-env! :source-paths (boot/get-env :test-paths))
  (let [src-paths (seq (boot/get-env :directories))]
    (comp
      (boot/with-pre-wrap fileset
        (alter-var-root #'ns-watcher (fn [_] (make-watcher src-paths)))
        fileset)
      (boot/with-post-wrap fileset
        (when ns-watcher (ns-watcher))
        (alter-var-root #'ns-watcher (constantly nil))
        fileset))))
