(ns plinth.queue)

(defprotocol Queue
  "Point-to-point communication"
  (send! [queue-name msg])
  (receive! [queue-name timeout timeout-val])
  (listen! [queue-name f])
  (unlisten! [listener]))

(defprotocol PubSub
  "Publish/subscribe"
  (publish! [topic-name msg])
  (subscribe! [topic-name subscriber-id f])
  (unsubscribe! [topic-name subscriber]))
