(ns bridg.metrics.component.handler
  "Componetized Compojure-API routes."
  (:require [com.stuartsierra.component :as component]
            [compojure.api.sweet :refer [api]]
            [duct.util.namespace :as ns]))

(defn find-endpoint-keys [component]
  (sort (map key (filter (comp :routes val) component))))

(defn find-routes [component]
  (map #(:routes (get component %))
       (:endpoints component (find-endpoint-keys component))))

(defn- middleware-fn [f args]
  (let [f    (if (symbol? f) (ns/load-var f) f)
        args (if (or (nil? args) (seq? args)) args (list args))]
    #(apply f % args)))

(defn- middleware-map [{:keys [functions arguments]}]
  (reduce-kv (fn [m k v] (assoc m k (middleware-fn v (arguments k)))) {} functions))

(defn- compose-middleware [{:keys [applied] :as middleware}]
  (->> (reverse applied)
       (map (middleware-map middleware))
       (apply comp identity)))

(defn create-handler
  "Returns a partial handler generating function with an optionally configured
  Swagger definition. Many routes be applied to the handler generator, which
  can be handy if the application has multiple endpoint components."
  ([] api)
  ([swagger] (partial api {:swagger swagger})))

(defrecord Handler [middleware]
  component/Lifecycle
  (start [component]
    (if-not (:handler component)
      (let [routes  (find-routes component)
            wrap-mw (compose-middleware (:middleware component))
            handler (wrap-mw
                      (apply (create-handler (:swagger component)) routes))]
        (assoc component :handler handler))
      component))
  (stop [component]
    (dissoc component :handler)))

(defn handler-component [options]
  (map->Handler options))
